<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialRequiredGrid extends MaterialRequired
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialRequiredGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fmaterial_requiredgrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "materialrequiredgrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->buyer_id->setVisibility();
        $this->poid->setVisibility();
        $this->po->setVisibility();
        $this->week->setVisibility();
        $this->product_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->Size_wl->setVisibility();
        $this->sqm->setVisibility();
        $this->t_sqm->setVisibility();
        $this->unit->setVisibility();
        $this->material_qty->setVisibility();
        $this->method->setVisibility();
        $this->despatch_week->setVisibility();
        $this->production_plan->Visible = false;
        $this->remarks->Visible = false;
        $this->updated->Visible = false;
        $this->req_material_grp->Visible = false;
        $this->req_material_sgrp->Visible = false;
        $this->req_material_product->Visible = false;
        $this->req_material_rid->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->issue_material_lcgp_rid->setVisibility();
        $this->issue_material_qty->Visible = false;
        $this->issue_material_packing->Visible = false;
        $this->issue_material_lot_no->setVisibility();
        $this->issue_material_godown->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->material_out->Visible = false;
        $this->material_out_id->Visible = false;
        $this->despatch_date->setVisibility();
        $this->order_id->setVisibility();
        $this->weaving_works->setVisibility();
        $this->issue_material_grp->Visible = false;
        $this->issue_material_sgrp->Visible = false;
        $this->issue_material_product->Visible = false;
        $this->issue_material_rid->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'material_required';
        $this->TableName = 'material_required';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_required)
        if (!isset($GLOBALS["material_required"]) || $GLOBALS["material_required"]::class == PROJECT_NAMESPACE . "material_required") {
            $GLOBALS["material_required"] = &$this;
        }
        $this->AddUrl = "materialrequiredadd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->week);
        $this->setupLookupOptions($this->product_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->req_material_grp);
        $this->setupLookupOptions($this->req_material_sgrp);
        $this->setupLookupOptions($this->req_material_product);
        $this->setupLookupOptions($this->req_material_rid);
        $this->setupLookupOptions($this->req_material_packing);
        $this->setupLookupOptions($this->issue_material_lcgp_rid);
        $this->setupLookupOptions($this->issue_material_packing);
        $this->setupLookupOptions($this->issue_material_godown);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->material_out);
        $this->setupLookupOptions($this->issue_material_grp);
        $this->setupLookupOptions($this->issue_material_sgrp);
        $this->setupLookupOptions($this->issue_material_product);
        $this->setupLookupOptions($this->issue_material_rid);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fmaterial_requiredgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = false;
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "required_material_compiled") {
            $masterTbl = Container("required_material_compiled");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("requiredmaterialcompiledlist"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->sqm->FormValue = ""; // Clear form value
        $this->t_sqm->FormValue = ""; // Clear form value
        $this->material_qty->FormValue = ""; // Clear form value
        $this->req_material_qty->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->id->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_company_id") &&
            $CurrentForm->hasValue("o_company_id") &&
            $this->company_id->CurrentValue != $this->company_id->DefaultValue &&
            !($this->company_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->company_id->CurrentValue == $this->company_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_buyer_id") &&
            $CurrentForm->hasValue("o_buyer_id") &&
            $this->buyer_id->CurrentValue != $this->buyer_id->DefaultValue &&
            !($this->buyer_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->buyer_id->CurrentValue == $this->buyer_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_poid") &&
            $CurrentForm->hasValue("o_poid") &&
            $this->poid->CurrentValue != $this->poid->DefaultValue &&
            !($this->poid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->poid->CurrentValue == $this->poid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_po") &&
            $CurrentForm->hasValue("o_po") &&
            $this->po->CurrentValue != $this->po->DefaultValue &&
            !($this->po->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->po->CurrentValue == $this->po->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_week") &&
            $CurrentForm->hasValue("o_week") &&
            $this->week->CurrentValue != $this->week->DefaultValue &&
            !($this->week->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->week->CurrentValue == $this->week->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_product_id") &&
            $CurrentForm->hasValue("o_product_id") &&
            $this->product_id->CurrentValue != $this->product_id->DefaultValue &&
            !($this->product_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->product_id->CurrentValue == $this->product_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_batch_no") &&
            $CurrentForm->hasValue("o_batch_no") &&
            $this->batch_no->CurrentValue != $this->batch_no->DefaultValue &&
            !($this->batch_no->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->batch_no->CurrentValue == $this->batch_no->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_quantity") &&
            $CurrentForm->hasValue("o_quantity") &&
            $this->quantity->CurrentValue != $this->quantity->DefaultValue &&
            !($this->quantity->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->quantity->CurrentValue == $this->quantity->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_Size_wl") &&
            $CurrentForm->hasValue("o_Size_wl") &&
            $this->Size_wl->CurrentValue != $this->Size_wl->DefaultValue &&
            !($this->Size_wl->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->Size_wl->CurrentValue == $this->Size_wl->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_sqm") &&
            $CurrentForm->hasValue("o_sqm") &&
            $this->sqm->CurrentValue != $this->sqm->DefaultValue &&
            !($this->sqm->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->sqm->CurrentValue == $this->sqm->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_t_sqm") &&
            $CurrentForm->hasValue("o_t_sqm") &&
            $this->t_sqm->CurrentValue != $this->t_sqm->DefaultValue &&
            !($this->t_sqm->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->t_sqm->CurrentValue == $this->t_sqm->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_unit") &&
            $CurrentForm->hasValue("o_unit") &&
            $this->unit->CurrentValue != $this->unit->DefaultValue &&
            !($this->unit->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->unit->CurrentValue == $this->unit->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_material_qty") &&
            $CurrentForm->hasValue("o_material_qty") &&
            $this->material_qty->CurrentValue != $this->material_qty->DefaultValue &&
            !($this->material_qty->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->material_qty->CurrentValue == $this->material_qty->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_method") &&
            $CurrentForm->hasValue("o_method") &&
            $this->method->CurrentValue != $this->method->DefaultValue &&
            !($this->method->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->method->CurrentValue == $this->method->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_despatch_week") &&
            $CurrentForm->hasValue("o_despatch_week") &&
            $this->despatch_week->CurrentValue != $this->despatch_week->DefaultValue &&
            !($this->despatch_week->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->despatch_week->CurrentValue == $this->despatch_week->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_req_material_rid") &&
            $CurrentForm->hasValue("o_req_material_rid") &&
            $this->req_material_rid->CurrentValue != $this->req_material_rid->DefaultValue &&
            !($this->req_material_rid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->req_material_rid->CurrentValue == $this->req_material_rid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_req_material_packing") &&
            $CurrentForm->hasValue("o_req_material_packing") &&
            $this->req_material_packing->CurrentValue != $this->req_material_packing->DefaultValue &&
            !($this->req_material_packing->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->req_material_packing->CurrentValue == $this->req_material_packing->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_req_material_qty") &&
            $CurrentForm->hasValue("o_req_material_qty") &&
            $this->req_material_qty->CurrentValue != $this->req_material_qty->DefaultValue &&
            !($this->req_material_qty->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->req_material_qty->CurrentValue == $this->req_material_qty->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_issue_material_lcgp_rid") &&
            $CurrentForm->hasValue("o_issue_material_lcgp_rid") &&
            $this->issue_material_lcgp_rid->CurrentValue != $this->issue_material_lcgp_rid->DefaultValue &&
            !($this->issue_material_lcgp_rid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->issue_material_lcgp_rid->CurrentValue == $this->issue_material_lcgp_rid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_issue_material_lot_no") &&
            $CurrentForm->hasValue("o_issue_material_lot_no") &&
            $this->issue_material_lot_no->CurrentValue != $this->issue_material_lot_no->DefaultValue &&
            !($this->issue_material_lot_no->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->issue_material_lot_no->CurrentValue == $this->issue_material_lot_no->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_issue_material_godown") &&
            $CurrentForm->hasValue("o_issue_material_godown") &&
            $this->issue_material_godown->CurrentValue != $this->issue_material_godown->DefaultValue &&
            !($this->issue_material_godown->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->issue_material_godown->CurrentValue == $this->issue_material_godown->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_despatch_date") &&
            $CurrentForm->hasValue("o_despatch_date") &&
            $this->despatch_date->CurrentValue != $this->despatch_date->DefaultValue &&
            !($this->despatch_date->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->despatch_date->CurrentValue == $this->despatch_date->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_order_id") &&
            $CurrentForm->hasValue("o_order_id") &&
            $this->order_id->CurrentValue != $this->order_id->DefaultValue &&
            !($this->order_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->order_id->CurrentValue == $this->order_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_weaving_works") &&
            $CurrentForm->hasValue("o_weaving_works") &&
            $this->weaving_works->CurrentValue != $this->weaving_works->DefaultValue &&
            !($this->weaving_works->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->weaving_works->CurrentValue == $this->weaving_works->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->id->VirtualExpression != "" ? $this->id->VirtualExpression : $this->id->Expression) . " DESC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->po->setSessionValue("");
                        $this->req_material_rid->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"material_required\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = false;
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_material_required", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_material_required",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->week->DefaultValue = $this->week->getDefault(); // PHP
        $this->week->OldValue = $this->week->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->id->setFormValue($val);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_company_id")) {
            $this->company_id->setOldValue($CurrentForm->getValue("o_company_id"));
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_buyer_id")) {
            $this->buyer_id->setOldValue($CurrentForm->getValue("o_buyer_id"));
        }

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_poid")) {
            $this->poid->setOldValue($CurrentForm->getValue("o_poid"));
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_po")) {
            $this->po->setOldValue($CurrentForm->getValue("o_po"));
        }

        // Check field name 'week' first before field var 'x_week'
        $val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
        if (!$this->week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->week->Visible = false; // Disable update for API request
            } else {
                $this->week->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_week")) {
            $this->week->setOldValue($CurrentForm->getValue("o_week"));
        }

        // Check field name 'product_id' first before field var 'x_product_id'
        $val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
        if (!$this->product_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_id->Visible = false; // Disable update for API request
            } else {
                $this->product_id->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_product_id")) {
            $this->product_id->setOldValue($CurrentForm->getValue("o_product_id"));
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_batch_no")) {
            $this->batch_no->setOldValue($CurrentForm->getValue("o_batch_no"));
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_quantity")) {
            $this->quantity->setOldValue($CurrentForm->getValue("o_quantity"));
        }

        // Check field name 'Size_wl' first before field var 'x_Size_wl'
        $val = $CurrentForm->hasValue("Size_wl") ? $CurrentForm->getValue("Size_wl") : $CurrentForm->getValue("x_Size_wl");
        if (!$this->Size_wl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Size_wl->Visible = false; // Disable update for API request
            } else {
                $this->Size_wl->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Size_wl")) {
            $this->Size_wl->setOldValue($CurrentForm->getValue("o_Size_wl"));
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sqm")) {
            $this->sqm->setOldValue($CurrentForm->getValue("o_sqm"));
        }

        // Check field name 't_sqm' first before field var 'x_t_sqm'
        $val = $CurrentForm->hasValue("t_sqm") ? $CurrentForm->getValue("t_sqm") : $CurrentForm->getValue("x_t_sqm");
        if (!$this->t_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_sqm->Visible = false; // Disable update for API request
            } else {
                $this->t_sqm->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_t_sqm")) {
            $this->t_sqm->setOldValue($CurrentForm->getValue("o_t_sqm"));
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_unit")) {
            $this->unit->setOldValue($CurrentForm->getValue("o_unit"));
        }

        // Check field name 'material_qty' first before field var 'x_material_qty'
        $val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
        if (!$this->material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material_qty->Visible = false; // Disable update for API request
            } else {
                $this->material_qty->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_material_qty")) {
            $this->material_qty->setOldValue($CurrentForm->getValue("o_material_qty"));
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_method")) {
            $this->method->setOldValue($CurrentForm->getValue("o_method"));
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_despatch_week")) {
            $this->despatch_week->setOldValue($CurrentForm->getValue("o_despatch_week"));
        }

        // Check field name 'req_material_rid' first before field var 'x_req_material_rid'
        $val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
        if (!$this->req_material_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_rid->Visible = false; // Disable update for API request
            } else {
                $this->req_material_rid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_req_material_rid")) {
            $this->req_material_rid->setOldValue($CurrentForm->getValue("o_req_material_rid"));
        }

        // Check field name 'req_material_packing' first before field var 'x_req_material_packing'
        $val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
        if (!$this->req_material_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_packing->Visible = false; // Disable update for API request
            } else {
                $this->req_material_packing->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_req_material_packing")) {
            $this->req_material_packing->setOldValue($CurrentForm->getValue("o_req_material_packing"));
        }

        // Check field name 'req_material_qty' first before field var 'x_req_material_qty'
        $val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
        if (!$this->req_material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_qty->Visible = false; // Disable update for API request
            } else {
                $this->req_material_qty->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_req_material_qty")) {
            $this->req_material_qty->setOldValue($CurrentForm->getValue("o_req_material_qty"));
        }

        // Check field name 'issue_material_lcgp_rid' first before field var 'x_issue_material_lcgp_rid'
        $val = $CurrentForm->hasValue("issue_material_lcgp_rid") ? $CurrentForm->getValue("issue_material_lcgp_rid") : $CurrentForm->getValue("x_issue_material_lcgp_rid");
        if (!$this->issue_material_lcgp_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_lcgp_rid->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_lcgp_rid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_issue_material_lcgp_rid")) {
            $this->issue_material_lcgp_rid->setOldValue($CurrentForm->getValue("o_issue_material_lcgp_rid"));
        }

        // Check field name 'issue_material_lot_no' first before field var 'x_issue_material_lot_no'
        $val = $CurrentForm->hasValue("issue_material_lot_no") ? $CurrentForm->getValue("issue_material_lot_no") : $CurrentForm->getValue("x_issue_material_lot_no");
        if (!$this->issue_material_lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_lot_no->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_lot_no->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_issue_material_lot_no")) {
            $this->issue_material_lot_no->setOldValue($CurrentForm->getValue("o_issue_material_lot_no"));
        }

        // Check field name 'issue_material_godown' first before field var 'x_issue_material_godown'
        $val = $CurrentForm->hasValue("issue_material_godown") ? $CurrentForm->getValue("issue_material_godown") : $CurrentForm->getValue("x_issue_material_godown");
        if (!$this->issue_material_godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_godown->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_godown->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_issue_material_godown")) {
            $this->issue_material_godown->setOldValue($CurrentForm->getValue("o_issue_material_godown"));
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }
        if ($CurrentForm->hasValue("o_despatch_date")) {
            $this->despatch_date->setOldValue($CurrentForm->getValue("o_despatch_date"));
        }

        // Check field name 'order_id' first before field var 'x_order_id'
        $val = $CurrentForm->hasValue("order_id") ? $CurrentForm->getValue("order_id") : $CurrentForm->getValue("x_order_id");
        if (!$this->order_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_id->Visible = false; // Disable update for API request
            } else {
                $this->order_id->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_order_id")) {
            $this->order_id->setOldValue($CurrentForm->getValue("o_order_id"));
        }

        // Check field name 'weaving_works' first before field var 'x_weaving_works'
        $val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
        if (!$this->weaving_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weaving_works->Visible = false; // Disable update for API request
            } else {
                $this->weaving_works->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_weaving_works")) {
            $this->weaving_works->setOldValue($CurrentForm->getValue("o_weaving_works"));
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_operator")) {
            $this->operator->setOldValue($CurrentForm->getValue("o_operator"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->id->CurrentValue = $this->id->FormValue;
        }
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->week->CurrentValue = $this->week->FormValue;
        $this->product_id->CurrentValue = $this->product_id->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->Size_wl->CurrentValue = $this->Size_wl->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->t_sqm->CurrentValue = $this->t_sqm->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->material_qty->CurrentValue = $this->material_qty->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
        $this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
        $this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
        $this->issue_material_lcgp_rid->CurrentValue = $this->issue_material_lcgp_rid->FormValue;
        $this->issue_material_lot_no->CurrentValue = $this->issue_material_lot_no->FormValue;
        $this->issue_material_godown->CurrentValue = $this->issue_material_godown->FormValue;
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->order_id->CurrentValue = $this->order_id->FormValue;
        $this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->poid->setDbValue($row['poid']);
        $this->po->setDbValue($row['po']);
        $this->week->setDbValue($row['week']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->Size_wl->setDbValue($row['Size_wl']);
        $this->sqm->setDbValue($row['sqm']);
        $this->t_sqm->setDbValue($row['t_sqm']);
        $this->unit->setDbValue($row['unit']);
        $this->material_qty->setDbValue($row['material_qty']);
        $this->method->setDbValue($row['method']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->remarks->setDbValue($row['remarks']);
        $this->updated->setDbValue($row['updated']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        if (array_key_exists('EV__req_material_rid', $row)) {
            $this->req_material_rid->VirtualValue = $row['EV__req_material_rid']; // Set up virtual field value
        } else {
            $this->req_material_rid->VirtualValue = ""; // Clear value
        }
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->issue_material_lcgp_rid->setDbValue($row['issue_material_lcgp_rid']);
        $this->issue_material_qty->setDbValue($row['issue_material_qty']);
        $this->issue_material_packing->setDbValue($row['issue_material_packing']);
        $this->issue_material_lot_no->setDbValue($row['issue_material_lot_no']);
        $this->issue_material_godown->setDbValue($row['issue_material_godown']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->material_out->setDbValue($row['material_out']);
        $this->material_out_id->setDbValue($row['material_out_id']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->order_id->setDbValue($row['order_id']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->issue_material_grp->setDbValue($row['issue_material_grp']);
        $this->issue_material_sgrp->setDbValue($row['issue_material_sgrp']);
        $this->issue_material_product->setDbValue($row['issue_material_product']);
        $this->issue_material_rid->setDbValue($row['issue_material_rid']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['week'] = $this->week->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['Size_wl'] = $this->Size_wl->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['t_sqm'] = $this->t_sqm->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['material_qty'] = $this->material_qty->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['req_material_grp'] = $this->req_material_grp->DefaultValue;
        $row['req_material_sgrp'] = $this->req_material_sgrp->DefaultValue;
        $row['req_material_product'] = $this->req_material_product->DefaultValue;
        $row['req_material_rid'] = $this->req_material_rid->DefaultValue;
        $row['req_material_packing'] = $this->req_material_packing->DefaultValue;
        $row['req_material_qty'] = $this->req_material_qty->DefaultValue;
        $row['issue_material_lcgp_rid'] = $this->issue_material_lcgp_rid->DefaultValue;
        $row['issue_material_qty'] = $this->issue_material_qty->DefaultValue;
        $row['issue_material_packing'] = $this->issue_material_packing->DefaultValue;
        $row['issue_material_lot_no'] = $this->issue_material_lot_no->DefaultValue;
        $row['issue_material_godown'] = $this->issue_material_godown->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['material_out'] = $this->material_out->DefaultValue;
        $row['material_out_id'] = $this->material_out_id->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['order_id'] = $this->order_id->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['issue_material_grp'] = $this->issue_material_grp->DefaultValue;
        $row['issue_material_sgrp'] = $this->issue_material_sgrp->DefaultValue;
        $row['issue_material_product'] = $this->issue_material_product->DefaultValue;
        $row['issue_material_rid'] = $this->issue_material_rid->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // company_id

        // buyer_id

        // poid

        // po

        // week

        // product_id

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // quantity

        // Size_wl

        // sqm

        // t_sqm

        // unit

        // material_qty

        // method

        // despatch_week

        // production_plan

        // remarks
        $this->remarks->CellCssStyle = "white-space: nowrap;";

        // updated
        $this->updated->CellCssStyle = "white-space: nowrap;";

        // req_material_grp

        // req_material_sgrp

        // req_material_product

        // req_material_rid

        // req_material_packing

        // req_material_qty

        // issue_material_lcgp_rid

        // issue_material_qty
        $this->issue_material_qty->CellCssStyle = "white-space: nowrap;";

        // issue_material_packing
        $this->issue_material_packing->CellCssStyle = "white-space: nowrap;";

        // issue_material_lot_no

        // issue_material_godown

        // grp

        // s_grp

        // product

        // material_out

        // material_out_id
        $this->material_out_id->CellCssStyle = "white-space: nowrap;";

        // despatch_date

        // order_id

        // weaving_works

        // issue_material_grp
        $this->issue_material_grp->CellCssStyle = "white-space: nowrap;";

        // issue_material_sgrp
        $this->issue_material_sgrp->CellCssStyle = "white-space: nowrap;";

        // issue_material_product
        $this->issue_material_product->CellCssStyle = "white-space: nowrap;";

        // issue_material_rid
        $this->issue_material_rid->CellCssStyle = "white-space: nowrap;";

        // operator

        // datetime

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->req_material_qty->CurrentValue)) {
                $this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->issue_material_qty->CurrentValue)) {
                $this->issue_material_qty->Total += $this->issue_material_qty->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // week
            $this->week->ViewValue = $this->week->CurrentValue;
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->ViewValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->ViewValue = FormatNumber($this->week->CurrentValue, $this->week->formatPattern());
                    }
                }
            } else {
                $this->week->ViewValue = null;
            }

            // product_id
            $curVal = strval($this->product_id->CurrentValue);
            if ($curVal != "") {
                $this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
                if ($this->product_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                        $this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
                    } else {
                        $this->product_id->ViewValue = $this->product_id->CurrentValue;
                    }
                }
            } else {
                $this->product_id->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // Size_wl
            $this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // t_sqm
            $this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, $this->t_sqm->formatPattern());

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // material_qty
            $this->material_qty->ViewValue = $this->material_qty->CurrentValue;
            $this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, $this->material_qty->formatPattern());

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // req_material_rid
            if ($this->req_material_rid->VirtualValue != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
            } else {
                $curVal = strval($this->req_material_rid->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                    if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                        } else {
                            $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_rid->ViewValue = null;
                }
            }

            // req_material_packing
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->ViewValue = null;
            }

            // req_material_qty
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

            // issue_material_lcgp_rid
            $curVal = strval($this->issue_material_lcgp_rid->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->lookupCacheOption($curVal);
                if ($this->issue_material_lcgp_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_lcgp_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_lcgp_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->displayValue($arwrk);
                    } else {
                        $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->CurrentValue;
                    }
                }
            } else {
                $this->issue_material_lcgp_rid->ViewValue = null;
            }

            // issue_material_lot_no
            $this->issue_material_lot_no->ViewValue = $this->issue_material_lot_no->CurrentValue;

            // issue_material_godown
            $this->issue_material_godown->ViewValue = $this->issue_material_godown->CurrentValue;
            $curVal = strval($this->issue_material_godown->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_godown->ViewValue = $this->issue_material_godown->lookupCacheOption($curVal);
                if ($this->issue_material_godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_godown->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_godown->ViewValue = $this->issue_material_godown->displayValue($arwrk);
                    } else {
                        $this->issue_material_godown->ViewValue = FormatNumber($this->issue_material_godown->CurrentValue, $this->issue_material_godown->formatPattern());
                    }
                }
            } else {
                $this->issue_material_godown->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // order_id
            $this->order_id->ViewValue = $this->order_id->CurrentValue;

            // weaving_works
            $this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
            $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->ViewValue, $this->weaving_works->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }
            $this->buyer_id->TooltipValue = "";

            // poid
            $this->poid->HrefValue = "";
            $this->poid->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // week
            $this->week->HrefValue = "";
            $this->week->TooltipValue = "";

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }
            $this->product_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // Size_wl
            $this->Size_wl->HrefValue = "";
            $this->Size_wl->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";
            $this->t_sqm->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";
            $this->material_qty->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";
            $this->req_material_rid->TooltipValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";
            $this->req_material_packing->TooltipValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->HrefValue = "";
            $this->issue_material_lcgp_rid->TooltipValue = "";

            // issue_material_lot_no
            $this->issue_material_lot_no->HrefValue = "";
            $this->issue_material_lot_no->TooltipValue = "";

            // issue_material_godown
            $this->issue_material_godown->HrefValue = "";
            $this->issue_material_godown->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // order_id
            $this->order_id->HrefValue = "";
            $this->order_id->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = trim(strval($this->buyer_id->CurrentValue));
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->CurrentValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditValue = $this->poid->CurrentValue;
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());
            if (strval($this->poid->EditValue) != "" && is_numeric($this->poid->EditValue)) {
                $this->poid->EditValue = $this->poid->EditValue;
            }

            // po
            $this->po->setupEditAttributes();
            if ($this->po->getSessionValue() != "") {
                $this->po->CurrentValue = GetForeignKeyValue($this->po->getSessionValue());
                $this->po->OldValue = $this->po->CurrentValue;
                $this->po->ViewValue = $this->po->CurrentValue;
            } else {
                $this->po->EditValue = $this->po->CurrentValue;
                $this->po->PlaceHolder = RemoveHtml($this->po->caption());
                if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
                    $this->po->EditValue = $this->po->EditValue;
                }
            }

            // week
            $this->week->setupEditAttributes();
            $this->week->EditValue = $this->week->CurrentValue;
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->EditValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->EditValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->EditValue = HtmlEncode(FormatNumber($this->week->CurrentValue, $this->week->formatPattern()));
                    }
                }
            } else {
                $this->week->EditValue = null;
            }
            $this->week->PlaceHolder = RemoveHtml($this->week->caption());

            // product_id
            $this->product_id->setupEditAttributes();
            $curVal = trim(strval($this->product_id->CurrentValue));
            if ($curVal != "") {
                $this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
            } else {
                $this->product_id->ViewValue = $this->product_id->Lookup !== null && is_array($this->product_id->lookupOptions()) && count($this->product_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_id->ViewValue !== null) { // Load from cache
                $this->product_id->EditValue = array_values($this->product_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_id->CurrentValue, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_id->EditValue = $arwrk;
            }
            $this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->ViewValue == "") {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // Size_wl
            $this->Size_wl->setupEditAttributes();
            if (!$this->Size_wl->Raw) {
                $this->Size_wl->CurrentValue = HtmlDecode($this->Size_wl->CurrentValue);
            }
            $this->Size_wl->EditValue = HtmlEncode($this->Size_wl->CurrentValue);
            $this->Size_wl->PlaceHolder = RemoveHtml($this->Size_wl->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // t_sqm
            $this->t_sqm->setupEditAttributes();
            $this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
            if (strval($this->t_sqm->EditValue) != "" && is_numeric($this->t_sqm->EditValue)) {
                $this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, null);
            }

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // material_qty
            $this->material_qty->setupEditAttributes();
            $this->material_qty->EditValue = $this->material_qty->CurrentValue;
            $this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
            if (strval($this->material_qty->EditValue) != "" && is_numeric($this->material_qty->EditValue)) {
                $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, null);
            }

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->CurrentValue));
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->CurrentValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // req_material_rid
            if ($this->req_material_rid->getSessionValue() != "") {
                $this->req_material_rid->CurrentValue = GetForeignKeyValue($this->req_material_rid->getSessionValue());
                $this->req_material_rid->OldValue = $this->req_material_rid->CurrentValue;
                if ($this->req_material_rid->VirtualValue != "") {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
                } else {
                    $curVal = strval($this->req_material_rid->CurrentValue);
                    if ($curVal != "") {
                        $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                        if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                            $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                            $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                            $conn = Conn();
                            $config = $conn->getConfiguration();
                            $config->setResultCache($this->Cache);
                            $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                            $ari = count($rswrk);
                            if ($ari > 0) { // Lookup values found
                                $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                                $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                            } else {
                                $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                            }
                        }
                    } else {
                        $this->req_material_rid->ViewValue = null;
                    }
                }
            } else {
                $curVal = trim(strval($this->req_material_rid->CurrentValue));
                if ($curVal != "") {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                } else {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->Lookup !== null && is_array($this->req_material_rid->lookupOptions()) && count($this->req_material_rid->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->req_material_rid->ViewValue !== null) { // Load from cache
                    $this->req_material_rid->EditValue = array_values($this->req_material_rid->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_rid->CurrentValue, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->req_material_rid->EditValue = $arwrk;
                }
                $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());
            }

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $curVal = trim(strval($this->req_material_packing->CurrentValue));
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            } else {
                $this->req_material_packing->ViewValue = $this->req_material_packing->Lookup !== null && is_array($this->req_material_packing->lookupOptions()) && count($this->req_material_packing->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_packing->ViewValue !== null) { // Load from cache
                $this->req_material_packing->EditValue = array_values($this->req_material_packing->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_packing->CurrentValue, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_packing->EditValue = $arwrk;
            }
            $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
            if (strval($this->req_material_qty->EditValue) != "" && is_numeric($this->req_material_qty->EditValue)) {
                $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, null);
            }

            // issue_material_lcgp_rid
            $curVal = trim(strval($this->issue_material_lcgp_rid->CurrentValue));
            if ($curVal != "") {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->lookupCacheOption($curVal);
            } else {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->Lookup !== null && is_array($this->issue_material_lcgp_rid->lookupOptions()) && count($this->issue_material_lcgp_rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_material_lcgp_rid->ViewValue !== null) { // Load from cache
                $this->issue_material_lcgp_rid->EditValue = array_values($this->issue_material_lcgp_rid->lookupOptions());
                if ($this->issue_material_lcgp_rid->ViewValue == "") {
                    $this->issue_material_lcgp_rid->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_material_lcgp_rid->CurrentValue, $this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->issue_material_lcgp_rid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_material_lcgp_rid->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->displayValue($arwrk);
                } else {
                    $this->issue_material_lcgp_rid->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->issue_material_lcgp_rid->Lookup->renderViewRow($row);
                }
                $this->issue_material_lcgp_rid->EditValue = $arwrk;
            }
            $this->issue_material_lcgp_rid->PlaceHolder = RemoveHtml($this->issue_material_lcgp_rid->caption());

            // issue_material_lot_no
            $this->issue_material_lot_no->setupEditAttributes();
            $this->issue_material_lot_no->EditCustomAttributes = $this->issue_material_lot_no->getEditCustomAttributes(); // PHP
            if (!$this->issue_material_lot_no->Raw) {
                $this->issue_material_lot_no->CurrentValue = HtmlDecode($this->issue_material_lot_no->CurrentValue);
            }
            $this->issue_material_lot_no->EditValue = HtmlEncode($this->issue_material_lot_no->CurrentValue);
            $this->issue_material_lot_no->PlaceHolder = RemoveHtml($this->issue_material_lot_no->caption());

            // issue_material_godown
            $this->issue_material_godown->setupEditAttributes();
            $this->issue_material_godown->EditCustomAttributes = $this->issue_material_godown->getEditCustomAttributes(); // PHP
            $this->issue_material_godown->EditValue = $this->issue_material_godown->CurrentValue;
            $curVal = strval($this->issue_material_godown->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_godown->EditValue = $this->issue_material_godown->lookupCacheOption($curVal);
                if ($this->issue_material_godown->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_godown->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_godown->EditValue = $this->issue_material_godown->displayValue($arwrk);
                    } else {
                        $this->issue_material_godown->EditValue = HtmlEncode(FormatNumber($this->issue_material_godown->CurrentValue, $this->issue_material_godown->formatPattern()));
                    }
                }
            } else {
                $this->issue_material_godown->EditValue = null;
            }
            $this->issue_material_godown->PlaceHolder = RemoveHtml($this->issue_material_godown->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // order_id
            $this->order_id->setupEditAttributes();
            if (!$this->order_id->Raw) {
                $this->order_id->CurrentValue = HtmlDecode($this->order_id->CurrentValue);
            }
            $this->order_id->EditValue = HtmlEncode($this->order_id->CurrentValue);
            $this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $this->weaving_works->EditValue = $this->weaving_works->CurrentValue;
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());
            if (strval($this->weaving_works->EditValue) != "" && is_numeric($this->weaving_works->EditValue)) {
                $this->weaving_works->EditValue = FormatNumber($this->weaving_works->EditValue, null);
            }

            // operator

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }

            // poid
            $this->poid->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // week
            $this->week->HrefValue = "";

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }

            // quantity
            $this->quantity->HrefValue = "";

            // Size_wl
            $this->Size_wl->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";

            // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->HrefValue = "";

            // issue_material_lot_no
            $this->issue_material_lot_no->HrefValue = "";

            // issue_material_godown
            $this->issue_material_godown->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // order_id
            $this->order_id->HrefValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->EditValue = null;
            }

            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditValue = $this->poid->CurrentValue;

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;

            // week
            $this->week->setupEditAttributes();
            $this->week->EditValue = $this->week->CurrentValue;
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->EditValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->EditValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->EditValue = FormatNumber($this->week->CurrentValue, $this->week->formatPattern());
                    }
                }
            } else {
                $this->week->EditValue = null;
            }

            // product_id
            $this->product_id->setupEditAttributes();
            $curVal = strval($this->product_id->CurrentValue);
            if ($curVal != "") {
                $this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
                if ($this->product_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                        $this->product_id->EditValue = $this->product_id->displayValue($arwrk);
                    } else {
                        $this->product_id->EditValue = $this->product_id->CurrentValue;
                    }
                }
            } else {
                $this->product_id->EditValue = null;
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

            // Size_wl
            $this->Size_wl->setupEditAttributes();
            $this->Size_wl->EditValue = $this->Size_wl->CurrentValue;

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

            // t_sqm
            $this->t_sqm->setupEditAttributes();
            $this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, $this->t_sqm->formatPattern());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->EditValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->EditValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->EditValue = null;
            }

            // material_qty
            $this->material_qty->setupEditAttributes();
            $this->material_qty->EditValue = $this->material_qty->CurrentValue;
            $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, $this->material_qty->formatPattern());

            // method
            $this->method->setupEditAttributes();
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->EditValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->EditValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->EditValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->EditValue = null;
            }

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->EditValue = null;
            }

            // req_material_rid
            $this->req_material_rid->setupEditAttributes();
            if ($this->req_material_rid->VirtualValue != "") {
                $this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
            } else {
                $curVal = strval($this->req_material_rid->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
                    if ($this->req_material_rid->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
                        } else {
                            $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_rid->EditValue = null;
                }
            }

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->EditValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->EditValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->EditValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->EditValue = null;
            }

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, $this->req_material_qty->formatPattern());

            // issue_material_lcgp_rid
            $curVal = trim(strval($this->issue_material_lcgp_rid->CurrentValue));
            if ($curVal != "") {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->lookupCacheOption($curVal);
            } else {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->Lookup !== null && is_array($this->issue_material_lcgp_rid->lookupOptions()) && count($this->issue_material_lcgp_rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_material_lcgp_rid->ViewValue !== null) { // Load from cache
                $this->issue_material_lcgp_rid->EditValue = array_values($this->issue_material_lcgp_rid->lookupOptions());
                if ($this->issue_material_lcgp_rid->ViewValue == "") {
                    $this->issue_material_lcgp_rid->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_material_lcgp_rid->CurrentValue, $this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->issue_material_lcgp_rid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_material_lcgp_rid->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->displayValue($arwrk);
                } else {
                    $this->issue_material_lcgp_rid->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->issue_material_lcgp_rid->Lookup->renderViewRow($row);
                }
                $this->issue_material_lcgp_rid->EditValue = $arwrk;
            }
            $this->issue_material_lcgp_rid->PlaceHolder = RemoveHtml($this->issue_material_lcgp_rid->caption());

            // issue_material_lot_no
            $this->issue_material_lot_no->setupEditAttributes();
            $this->issue_material_lot_no->EditCustomAttributes = $this->issue_material_lot_no->getEditCustomAttributes(); // PHP
            if (!$this->issue_material_lot_no->Raw) {
                $this->issue_material_lot_no->CurrentValue = HtmlDecode($this->issue_material_lot_no->CurrentValue);
            }
            $this->issue_material_lot_no->EditValue = HtmlEncode($this->issue_material_lot_no->CurrentValue);
            $this->issue_material_lot_no->PlaceHolder = RemoveHtml($this->issue_material_lot_no->caption());

            // issue_material_godown
            $this->issue_material_godown->setupEditAttributes();
            $this->issue_material_godown->EditCustomAttributes = $this->issue_material_godown->getEditCustomAttributes(); // PHP
            $this->issue_material_godown->EditValue = $this->issue_material_godown->CurrentValue;
            $curVal = strval($this->issue_material_godown->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_godown->EditValue = $this->issue_material_godown->lookupCacheOption($curVal);
                if ($this->issue_material_godown->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_godown->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_godown->EditValue = $this->issue_material_godown->displayValue($arwrk);
                    } else {
                        $this->issue_material_godown->EditValue = HtmlEncode(FormatNumber($this->issue_material_godown->CurrentValue, $this->issue_material_godown->formatPattern()));
                    }
                }
            } else {
                $this->issue_material_godown->EditValue = null;
            }
            $this->issue_material_godown->PlaceHolder = RemoveHtml($this->issue_material_godown->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->EditValue, $this->despatch_date->formatPattern());

            // order_id
            $this->order_id->setupEditAttributes();
            if (!$this->order_id->Raw) {
                $this->order_id->CurrentValue = HtmlDecode($this->order_id->CurrentValue);
            }
            $this->order_id->EditValue = HtmlEncode($this->order_id->CurrentValue);
            $this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $this->weaving_works->EditValue = $this->weaving_works->CurrentValue;
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());
            if (strval($this->weaving_works->EditValue) != "" && is_numeric($this->weaving_works->EditValue)) {
                $this->weaving_works->EditValue = FormatNumber($this->weaving_works->EditValue, null);
            }

            // operator

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }
            $this->buyer_id->TooltipValue = "";

            // poid
            $this->poid->HrefValue = "";
            $this->poid->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // week
            $this->week->HrefValue = "";
            $this->week->TooltipValue = "";

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }
            $this->product_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // Size_wl
            $this->Size_wl->HrefValue = "";
            $this->Size_wl->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";
            $this->t_sqm->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";
            $this->material_qty->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";
            $this->req_material_rid->TooltipValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";
            $this->req_material_packing->TooltipValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->HrefValue = "";

            // issue_material_lot_no
            $this->issue_material_lot_no->HrefValue = "";

            // issue_material_godown
            $this->issue_material_godown->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // order_id
            $this->order_id->HrefValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->req_material_qty->Total = 0; // Initialize total
                    $this->issue_material_qty->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());
            $this->req_material_qty->HrefValue = ""; // Clear href value
            $this->issue_material_qty->CurrentValue = $this->issue_material_qty->Total;
            $this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
            $this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, $this->issue_material_qty->formatPattern());
            $this->issue_material_qty->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->poid->Visible && $this->poid->Required) {
                if (!$this->poid->IsDetailKey && EmptyValue($this->poid->FormValue)) {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->week->Visible && $this->week->Required) {
                if (!$this->week->IsDetailKey && EmptyValue($this->week->FormValue)) {
                    $this->week->addErrorMessage(str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
                }
            }
            if ($this->product_id->Visible && $this->product_id->Required) {
                if (!$this->product_id->IsDetailKey && EmptyValue($this->product_id->FormValue)) {
                    $this->product_id->addErrorMessage(str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->Size_wl->Visible && $this->Size_wl->Required) {
                if (!$this->Size_wl->IsDetailKey && EmptyValue($this->Size_wl->FormValue)) {
                    $this->Size_wl->addErrorMessage(str_replace("%s", $this->Size_wl->caption(), $this->Size_wl->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->t_sqm->Visible && $this->t_sqm->Required) {
                if (!$this->t_sqm->IsDetailKey && EmptyValue($this->t_sqm->FormValue)) {
                    $this->t_sqm->addErrorMessage(str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->material_qty->Visible && $this->material_qty->Required) {
                if (!$this->material_qty->IsDetailKey && EmptyValue($this->material_qty->FormValue)) {
                    $this->material_qty->addErrorMessage(str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
                }
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->req_material_rid->Visible && $this->req_material_rid->Required) {
                if ($this->req_material_rid->FormValue == "") {
                    $this->req_material_rid->addErrorMessage(str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
                }
            }
            if ($this->req_material_packing->Visible && $this->req_material_packing->Required) {
                if (!$this->req_material_packing->IsDetailKey && EmptyValue($this->req_material_packing->FormValue)) {
                    $this->req_material_packing->addErrorMessage(str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
                }
            }
            if ($this->req_material_qty->Visible && $this->req_material_qty->Required) {
                if (!$this->req_material_qty->IsDetailKey && EmptyValue($this->req_material_qty->FormValue)) {
                    $this->req_material_qty->addErrorMessage(str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
                }
            }
            if ($this->issue_material_lcgp_rid->Visible && $this->issue_material_lcgp_rid->Required) {
                if (!$this->issue_material_lcgp_rid->IsDetailKey && EmptyValue($this->issue_material_lcgp_rid->FormValue)) {
                    $this->issue_material_lcgp_rid->addErrorMessage(str_replace("%s", $this->issue_material_lcgp_rid->caption(), $this->issue_material_lcgp_rid->RequiredErrorMessage));
                }
            }
            if ($this->issue_material_lot_no->Visible && $this->issue_material_lot_no->Required) {
                if (!$this->issue_material_lot_no->IsDetailKey && EmptyValue($this->issue_material_lot_no->FormValue)) {
                    $this->issue_material_lot_no->addErrorMessage(str_replace("%s", $this->issue_material_lot_no->caption(), $this->issue_material_lot_no->RequiredErrorMessage));
                }
            }
            if ($this->issue_material_godown->Visible && $this->issue_material_godown->Required) {
                if (!$this->issue_material_godown->IsDetailKey && EmptyValue($this->issue_material_godown->FormValue)) {
                    $this->issue_material_godown->addErrorMessage(str_replace("%s", $this->issue_material_godown->caption(), $this->issue_material_godown->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->issue_material_godown->FormValue)) {
                $this->issue_material_godown->addErrorMessage($this->issue_material_godown->getErrorMessage(false));
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if ($this->order_id->Visible && $this->order_id->Required) {
                if (!$this->order_id->IsDetailKey && EmptyValue($this->order_id->FormValue)) {
                    $this->order_id->addErrorMessage(str_replace("%s", $this->order_id->caption(), $this->order_id->RequiredErrorMessage));
                }
            }
            if ($this->weaving_works->Visible && $this->weaving_works->Required) {
                if (!$this->weaving_works->IsDetailKey && EmptyValue($this->weaving_works->FormValue)) {
                    $this->weaving_works->addErrorMessage(str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->weaving_works->FormValue)) {
                $this->weaving_works->addErrorMessage($this->weaving_works->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check referential integrity for master table 'required_material_compiled'
        $detailKeys = [];
        $keyValue = $rsnew['po'] ?? $rsold['po'];
        $detailKeys['po'] = $keyValue;
        $keyValue = $rsnew['req_material_rid'] ?? $rsold['req_material_rid'];
        $detailKeys['req_material_rid'] = $keyValue;
        $masterTable = Container("required_material_compiled");
        $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
        if (!EmptyValue($masterFilter)) {
            $rsmaster = $masterTable->loadRs($masterFilter)->fetch();
            $validMasterRecord = $rsmaster !== false;
        } else { // Allow null value if not required field
            $validMasterRecord = $masterFilter === null;
        }
        if (!$validMasterRecord) {
            $relatedRecordMsg = str_replace("%t", "required_material_compiled", $Language->phrase("RelatedRecordRequired"));
            $this->setFailureMessage($relatedRecordMsg);
            return false;
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // issue_material_lcgp_rid
        $this->issue_material_lcgp_rid->setDbValueDef($rsnew, $this->issue_material_lcgp_rid->CurrentValue, $this->issue_material_lcgp_rid->ReadOnly);

        // issue_material_lot_no
        $this->issue_material_lot_no->setDbValueDef($rsnew, $this->issue_material_lot_no->CurrentValue, $this->issue_material_lot_no->ReadOnly);

        // issue_material_godown
        $this->issue_material_godown->setDbValueDef($rsnew, $this->issue_material_godown->CurrentValue, $this->issue_material_godown->ReadOnly);

        // order_id
        $this->order_id->setDbValueDef($rsnew, $this->order_id->CurrentValue, $this->order_id->ReadOnly);

        // weaving_works
        $this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, $this->weaving_works->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['issue_material_lcgp_rid'])) { // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->CurrentValue = $row['issue_material_lcgp_rid'];
        }
        if (isset($row['issue_material_lot_no'])) { // issue_material_lot_no
            $this->issue_material_lot_no->CurrentValue = $row['issue_material_lot_no'];
        }
        if (isset($row['issue_material_godown'])) { // issue_material_godown
            $this->issue_material_godown->CurrentValue = $row['issue_material_godown'];
        }
        if (isset($row['order_id'])) { // order_id
            $this->order_id->CurrentValue = $row['order_id'];
        }
        if (isset($row['weaving_works'])) { // weaving_works
            $this->weaving_works->CurrentValue = $row['weaving_works'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "required_material_compiled") {
            $this->po->Visible = true; // Need to insert foreign key
            $this->po->CurrentValue = $this->po->getSessionValue();
            $this->req_material_rid->Visible = true; // Need to insert foreign key
            $this->req_material_rid->CurrentValue = $this->req_material_rid->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check referential integrity for master table 'material_required'
        $validMasterRecord = true;
        $detailKeys = [];
        $detailKeys["po"] = $this->po->CurrentValue;
        $detailKeys["req_material_rid"] = $this->req_material_rid->CurrentValue;
        $masterTable = Container("required_material_compiled");
        $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
        if (!EmptyValue($masterFilter)) {
            $rsmaster = $masterTable->loadRs($masterFilter)->fetch();
            $validMasterRecord = $rsmaster !== false;
        } else { // Allow null value if not required field
            $validMasterRecord = $masterFilter === null;
        }
        if (!$validMasterRecord) {
            $relatedRecordMsg = str_replace("%t", "required_material_compiled", $Language->phrase("RelatedRecordRequired"));
            $this->setFailureMessage($relatedRecordMsg);
            return false;
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, false);

        // poid
        $this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, false);

        // po
        $this->po->setDbValueDef($rsnew, $this->po->CurrentValue, false);

        // week
        $this->week->setDbValueDef($rsnew, $this->week->CurrentValue, false);

        // product_id
        $this->product_id->setDbValueDef($rsnew, $this->product_id->CurrentValue, false);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // Size_wl
        $this->Size_wl->setDbValueDef($rsnew, $this->Size_wl->CurrentValue, false);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, false);

        // t_sqm
        $this->t_sqm->setDbValueDef($rsnew, $this->t_sqm->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // material_qty
        $this->material_qty->setDbValueDef($rsnew, $this->material_qty->CurrentValue, false);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, false);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, false);

        // req_material_rid
        $this->req_material_rid->setDbValueDef($rsnew, $this->req_material_rid->CurrentValue, false);

        // req_material_packing
        $this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, false);

        // req_material_qty
        $this->req_material_qty->setDbValueDef($rsnew, $this->req_material_qty->CurrentValue, strval($this->req_material_qty->CurrentValue) == "");

        // issue_material_lcgp_rid
        $this->issue_material_lcgp_rid->setDbValueDef($rsnew, $this->issue_material_lcgp_rid->CurrentValue, false);

        // issue_material_lot_no
        $this->issue_material_lot_no->setDbValueDef($rsnew, $this->issue_material_lot_no->CurrentValue, false);

        // issue_material_godown
        $this->issue_material_godown->setDbValueDef($rsnew, $this->issue_material_godown->CurrentValue, false);

        // despatch_date
        $this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()), false);

        // order_id
        $this->order_id->setDbValueDef($rsnew, $this->order_id->CurrentValue, false);

        // weaving_works
        $this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->setFormValue($row['buyer_id']);
        }
        if (isset($row['poid'])) { // poid
            $this->poid->setFormValue($row['poid']);
        }
        if (isset($row['po'])) { // po
            $this->po->setFormValue($row['po']);
        }
        if (isset($row['week'])) { // week
            $this->week->setFormValue($row['week']);
        }
        if (isset($row['product_id'])) { // product_id
            $this->product_id->setFormValue($row['product_id']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['Size_wl'])) { // Size_wl
            $this->Size_wl->setFormValue($row['Size_wl']);
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->setFormValue($row['sqm']);
        }
        if (isset($row['t_sqm'])) { // t_sqm
            $this->t_sqm->setFormValue($row['t_sqm']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['material_qty'])) { // material_qty
            $this->material_qty->setFormValue($row['material_qty']);
        }
        if (isset($row['method'])) { // method
            $this->method->setFormValue($row['method']);
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->setFormValue($row['despatch_week']);
        }
        if (isset($row['req_material_rid'])) { // req_material_rid
            $this->req_material_rid->setFormValue($row['req_material_rid']);
        }
        if (isset($row['req_material_packing'])) { // req_material_packing
            $this->req_material_packing->setFormValue($row['req_material_packing']);
        }
        if (isset($row['req_material_qty'])) { // req_material_qty
            $this->req_material_qty->setFormValue($row['req_material_qty']);
        }
        if (isset($row['issue_material_lcgp_rid'])) { // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->setFormValue($row['issue_material_lcgp_rid']);
        }
        if (isset($row['issue_material_lot_no'])) { // issue_material_lot_no
            $this->issue_material_lot_no->setFormValue($row['issue_material_lot_no']);
        }
        if (isset($row['issue_material_godown'])) { // issue_material_godown
            $this->issue_material_godown->setFormValue($row['issue_material_godown']);
        }
        if (isset($row['despatch_date'])) { // despatch_date
            $this->despatch_date->setFormValue($row['despatch_date']);
        }
        if (isset($row['order_id'])) { // order_id
            $this->order_id->setFormValue($row['order_id']);
        }
        if (isset($row['weaving_works'])) { // weaving_works
            $this->weaving_works->setFormValue($row['weaving_works']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "required_material_compiled") {
            $masterTbl = Container("required_material_compiled");
            $this->po->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
            $this->req_material_rid->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_id":
                    break;
                case "x_week":
                    break;
                case "x_product_id":
                    break;
                case "x_batch_no":
                    break;
                case "x_unit":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_production_plan":
                    break;
                case "x_req_material_grp":
                    break;
                case "x_req_material_sgrp":
                    break;
                case "x_req_material_product":
                    break;
                case "x_req_material_rid":
                    break;
                case "x_req_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_lcgp_rid":
                    break;
                case "x_issue_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_godown":
                    break;
                case "x_grp":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_material_out":
                    break;
                case "x_issue_material_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_sgrp":
                    break;
                case "x_issue_material_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_rid":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
