<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialRequiredEdit extends MaterialRequired
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialRequiredEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialrequirededit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->buyer_id->setVisibility();
        $this->poid->setVisibility();
        $this->po->setVisibility();
        $this->week->setVisibility();
        $this->product_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->Size_wl->setVisibility();
        $this->sqm->setVisibility();
        $this->t_sqm->setVisibility();
        $this->unit->setVisibility();
        $this->material_qty->setVisibility();
        $this->method->setVisibility();
        $this->despatch_week->setVisibility();
        $this->production_plan->setVisibility();
        $this->remarks->Visible = false;
        $this->updated->Visible = false;
        $this->req_material_grp->Visible = false;
        $this->req_material_sgrp->Visible = false;
        $this->req_material_product->Visible = false;
        $this->req_material_rid->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->issue_material_lcgp_rid->setVisibility();
        $this->issue_material_qty->setVisibility();
        $this->issue_material_packing->setVisibility();
        $this->issue_material_lot_no->setVisibility();
        $this->issue_material_godown->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->material_out->Visible = false;
        $this->material_out_id->Visible = false;
        $this->despatch_date->setVisibility();
        $this->order_id->Visible = false;
        $this->weaving_works->Visible = false;
        $this->issue_material_grp->Visible = false;
        $this->issue_material_sgrp->Visible = false;
        $this->issue_material_product->Visible = false;
        $this->issue_material_rid->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_required';
        $this->TableName = 'material_required';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_required)
        if (!isset($GLOBALS["material_required"]) || $GLOBALS["material_required"]::class == PROJECT_NAMESPACE . "material_required") {
            $GLOBALS["material_required"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "materialrequiredview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->company_id->Required = false;
        $this->buyer_id->Required = false;
        $this->poid->Required = false;
        $this->week->Required = false;
        $this->product_id->Required = false;
        $this->batch_no->Required = false;
        $this->quantity->Required = false;
        $this->unit->Required = false;
        $this->method->Required = false;
        $this->despatch_week->Required = false;
        $this->production_plan->Required = false;
        $this->req_material_packing->Required = false;
        $this->despatch_date->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->week);
        $this->setupLookupOptions($this->product_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->req_material_grp);
        $this->setupLookupOptions($this->req_material_sgrp);
        $this->setupLookupOptions($this->req_material_product);
        $this->setupLookupOptions($this->req_material_rid);
        $this->setupLookupOptions($this->req_material_packing);
        $this->setupLookupOptions($this->issue_material_lcgp_rid);
        $this->setupLookupOptions($this->issue_material_packing);
        $this->setupLookupOptions($this->issue_material_godown);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->material_out);
        $this->setupLookupOptions($this->issue_material_grp);
        $this->setupLookupOptions($this->issue_material_sgrp);
        $this->setupLookupOptions($this->issue_material_product);
        $this->setupLookupOptions($this->issue_material_rid);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("materialrequiredlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "materialrequiredlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "materialrequiredlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "materialrequiredlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'week' first before field var 'x_week'
        $val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
        if (!$this->week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->week->Visible = false; // Disable update for API request
            } else {
                $this->week->setFormValue($val);
            }
        }

        // Check field name 'product_id' first before field var 'x_product_id'
        $val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
        if (!$this->product_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_id->Visible = false; // Disable update for API request
            } else {
                $this->product_id->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'Size_wl' first before field var 'x_Size_wl'
        $val = $CurrentForm->hasValue("Size_wl") ? $CurrentForm->getValue("Size_wl") : $CurrentForm->getValue("x_Size_wl");
        if (!$this->Size_wl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Size_wl->Visible = false; // Disable update for API request
            } else {
                $this->Size_wl->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 't_sqm' first before field var 'x_t_sqm'
        $val = $CurrentForm->hasValue("t_sqm") ? $CurrentForm->getValue("t_sqm") : $CurrentForm->getValue("x_t_sqm");
        if (!$this->t_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_sqm->Visible = false; // Disable update for API request
            } else {
                $this->t_sqm->setFormValue($val);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name 'material_qty' first before field var 'x_material_qty'
        $val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
        if (!$this->material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material_qty->Visible = false; // Disable update for API request
            } else {
                $this->material_qty->setFormValue($val);
            }
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val);
            }
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }

        // Check field name 'production_plan' first before field var 'x_production_plan'
        $val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
        if (!$this->production_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_plan->Visible = false; // Disable update for API request
            } else {
                $this->production_plan->setFormValue($val);
            }
        }

        // Check field name 'req_material_rid' first before field var 'x_req_material_rid'
        $val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
        if (!$this->req_material_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_rid->Visible = false; // Disable update for API request
            } else {
                $this->req_material_rid->setFormValue($val);
            }
        }

        // Check field name 'req_material_packing' first before field var 'x_req_material_packing'
        $val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
        if (!$this->req_material_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_packing->Visible = false; // Disable update for API request
            } else {
                $this->req_material_packing->setFormValue($val);
            }
        }

        // Check field name 'req_material_qty' first before field var 'x_req_material_qty'
        $val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
        if (!$this->req_material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_qty->Visible = false; // Disable update for API request
            } else {
                $this->req_material_qty->setFormValue($val);
            }
        }

        // Check field name 'issue_material_lcgp_rid' first before field var 'x_issue_material_lcgp_rid'
        $val = $CurrentForm->hasValue("issue_material_lcgp_rid") ? $CurrentForm->getValue("issue_material_lcgp_rid") : $CurrentForm->getValue("x_issue_material_lcgp_rid");
        if (!$this->issue_material_lcgp_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_lcgp_rid->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_lcgp_rid->setFormValue($val);
            }
        }

        // Check field name 'issue_material_qty' first before field var 'x_issue_material_qty'
        $val = $CurrentForm->hasValue("issue_material_qty") ? $CurrentForm->getValue("issue_material_qty") : $CurrentForm->getValue("x_issue_material_qty");
        if (!$this->issue_material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_qty->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'issue_material_packing' first before field var 'x_issue_material_packing'
        $val = $CurrentForm->hasValue("issue_material_packing") ? $CurrentForm->getValue("issue_material_packing") : $CurrentForm->getValue("x_issue_material_packing");
        if (!$this->issue_material_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_packing->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_packing->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'issue_material_lot_no' first before field var 'x_issue_material_lot_no'
        $val = $CurrentForm->hasValue("issue_material_lot_no") ? $CurrentForm->getValue("issue_material_lot_no") : $CurrentForm->getValue("x_issue_material_lot_no");
        if (!$this->issue_material_lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_lot_no->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_lot_no->setFormValue($val);
            }
        }

        // Check field name 'issue_material_godown' first before field var 'x_issue_material_godown'
        $val = $CurrentForm->hasValue("issue_material_godown") ? $CurrentForm->getValue("issue_material_godown") : $CurrentForm->getValue("x_issue_material_godown");
        if (!$this->issue_material_godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_material_godown->Visible = false; // Disable update for API request
            } else {
                $this->issue_material_godown->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->week->CurrentValue = $this->week->FormValue;
        $this->product_id->CurrentValue = $this->product_id->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->Size_wl->CurrentValue = $this->Size_wl->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->t_sqm->CurrentValue = $this->t_sqm->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->material_qty->CurrentValue = $this->material_qty->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->production_plan->CurrentValue = $this->production_plan->FormValue;
        $this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
        $this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
        $this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
        $this->issue_material_lcgp_rid->CurrentValue = $this->issue_material_lcgp_rid->FormValue;
        $this->issue_material_qty->CurrentValue = $this->issue_material_qty->FormValue;
        $this->issue_material_packing->CurrentValue = $this->issue_material_packing->FormValue;
        $this->issue_material_lot_no->CurrentValue = $this->issue_material_lot_no->FormValue;
        $this->issue_material_godown->CurrentValue = $this->issue_material_godown->FormValue;
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->poid->setDbValue($row['poid']);
        $this->po->setDbValue($row['po']);
        $this->week->setDbValue($row['week']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->Size_wl->setDbValue($row['Size_wl']);
        $this->sqm->setDbValue($row['sqm']);
        $this->t_sqm->setDbValue($row['t_sqm']);
        $this->unit->setDbValue($row['unit']);
        $this->material_qty->setDbValue($row['material_qty']);
        $this->method->setDbValue($row['method']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->remarks->setDbValue($row['remarks']);
        $this->updated->setDbValue($row['updated']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        if (array_key_exists('EV__req_material_rid', $row)) {
            $this->req_material_rid->VirtualValue = $row['EV__req_material_rid']; // Set up virtual field value
        } else {
            $this->req_material_rid->VirtualValue = ""; // Clear value
        }
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->issue_material_lcgp_rid->setDbValue($row['issue_material_lcgp_rid']);
        $this->issue_material_qty->setDbValue($row['issue_material_qty']);
        $this->issue_material_packing->setDbValue($row['issue_material_packing']);
        $this->issue_material_lot_no->setDbValue($row['issue_material_lot_no']);
        $this->issue_material_godown->setDbValue($row['issue_material_godown']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->material_out->setDbValue($row['material_out']);
        $this->material_out_id->setDbValue($row['material_out_id']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->order_id->setDbValue($row['order_id']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->issue_material_grp->setDbValue($row['issue_material_grp']);
        $this->issue_material_sgrp->setDbValue($row['issue_material_sgrp']);
        $this->issue_material_product->setDbValue($row['issue_material_product']);
        $this->issue_material_rid->setDbValue($row['issue_material_rid']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['week'] = $this->week->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['Size_wl'] = $this->Size_wl->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['t_sqm'] = $this->t_sqm->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['material_qty'] = $this->material_qty->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['req_material_grp'] = $this->req_material_grp->DefaultValue;
        $row['req_material_sgrp'] = $this->req_material_sgrp->DefaultValue;
        $row['req_material_product'] = $this->req_material_product->DefaultValue;
        $row['req_material_rid'] = $this->req_material_rid->DefaultValue;
        $row['req_material_packing'] = $this->req_material_packing->DefaultValue;
        $row['req_material_qty'] = $this->req_material_qty->DefaultValue;
        $row['issue_material_lcgp_rid'] = $this->issue_material_lcgp_rid->DefaultValue;
        $row['issue_material_qty'] = $this->issue_material_qty->DefaultValue;
        $row['issue_material_packing'] = $this->issue_material_packing->DefaultValue;
        $row['issue_material_lot_no'] = $this->issue_material_lot_no->DefaultValue;
        $row['issue_material_godown'] = $this->issue_material_godown->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['material_out'] = $this->material_out->DefaultValue;
        $row['material_out_id'] = $this->material_out_id->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['order_id'] = $this->order_id->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['issue_material_grp'] = $this->issue_material_grp->DefaultValue;
        $row['issue_material_sgrp'] = $this->issue_material_sgrp->DefaultValue;
        $row['issue_material_product'] = $this->issue_material_product->DefaultValue;
        $row['issue_material_rid'] = $this->issue_material_rid->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // week
        $this->week->RowCssClass = "row";

        // product_id
        $this->product_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // Size_wl
        $this->Size_wl->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // t_sqm
        $this->t_sqm->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // material_qty
        $this->material_qty->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // req_material_grp
        $this->req_material_grp->RowCssClass = "row";

        // req_material_sgrp
        $this->req_material_sgrp->RowCssClass = "row";

        // req_material_product
        $this->req_material_product->RowCssClass = "row";

        // req_material_rid
        $this->req_material_rid->RowCssClass = "row";

        // req_material_packing
        $this->req_material_packing->RowCssClass = "row";

        // req_material_qty
        $this->req_material_qty->RowCssClass = "row";

        // issue_material_lcgp_rid
        $this->issue_material_lcgp_rid->RowCssClass = "row";

        // issue_material_qty
        $this->issue_material_qty->RowCssClass = "row";

        // issue_material_packing
        $this->issue_material_packing->RowCssClass = "row";

        // issue_material_lot_no
        $this->issue_material_lot_no->RowCssClass = "row";

        // issue_material_godown
        $this->issue_material_godown->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // material_out
        $this->material_out->RowCssClass = "row";

        // material_out_id
        $this->material_out_id->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // order_id
        $this->order_id->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // issue_material_grp
        $this->issue_material_grp->RowCssClass = "row";

        // issue_material_sgrp
        $this->issue_material_sgrp->RowCssClass = "row";

        // issue_material_product
        $this->issue_material_product->RowCssClass = "row";

        // issue_material_rid
        $this->issue_material_rid->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // week
            $this->week->ViewValue = $this->week->CurrentValue;
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->ViewValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->ViewValue = FormatNumber($this->week->CurrentValue, $this->week->formatPattern());
                    }
                }
            } else {
                $this->week->ViewValue = null;
            }

            // product_id
            $curVal = strval($this->product_id->CurrentValue);
            if ($curVal != "") {
                $this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
                if ($this->product_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                        $this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
                    } else {
                        $this->product_id->ViewValue = $this->product_id->CurrentValue;
                    }
                }
            } else {
                $this->product_id->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // Size_wl
            $this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // t_sqm
            $this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, $this->t_sqm->formatPattern());

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // material_qty
            $this->material_qty->ViewValue = $this->material_qty->CurrentValue;
            $this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, $this->material_qty->formatPattern());

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // req_material_rid
            if ($this->req_material_rid->VirtualValue != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
            } else {
                $curVal = strval($this->req_material_rid->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                    if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                        } else {
                            $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_rid->ViewValue = null;
                }
            }

            // req_material_packing
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->ViewValue = null;
            }

            // req_material_qty
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

            // issue_material_lcgp_rid
            $curVal = strval($this->issue_material_lcgp_rid->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->lookupCacheOption($curVal);
                if ($this->issue_material_lcgp_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_lcgp_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_lcgp_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->displayValue($arwrk);
                    } else {
                        $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->CurrentValue;
                    }
                }
            } else {
                $this->issue_material_lcgp_rid->ViewValue = null;
            }

            // issue_material_qty
            $this->issue_material_qty->ViewValue = $this->issue_material_qty->CurrentValue;
            $this->issue_material_qty->ViewValue = FormatNumber($this->issue_material_qty->ViewValue, $this->issue_material_qty->formatPattern());

            // issue_material_packing
            $this->issue_material_packing->ViewValue = $this->issue_material_packing->CurrentValue;
            $curVal = strval($this->issue_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_packing->ViewValue = $this->issue_material_packing->lookupCacheOption($curVal);
                if ($this->issue_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_packing->ViewValue = $this->issue_material_packing->displayValue($arwrk);
                    } else {
                        $this->issue_material_packing->ViewValue = FormatNumber($this->issue_material_packing->CurrentValue, $this->issue_material_packing->formatPattern());
                    }
                }
            } else {
                $this->issue_material_packing->ViewValue = null;
            }

            // issue_material_lot_no
            $this->issue_material_lot_no->ViewValue = $this->issue_material_lot_no->CurrentValue;

            // issue_material_godown
            $this->issue_material_godown->ViewValue = $this->issue_material_godown->CurrentValue;
            $curVal = strval($this->issue_material_godown->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_godown->ViewValue = $this->issue_material_godown->lookupCacheOption($curVal);
                if ($this->issue_material_godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_godown->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_godown->ViewValue = $this->issue_material_godown->displayValue($arwrk);
                    } else {
                        $this->issue_material_godown->ViewValue = FormatNumber($this->issue_material_godown->CurrentValue, $this->issue_material_godown->formatPattern());
                    }
                }
            } else {
                $this->issue_material_godown->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // weaving_works
            $this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
            $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->ViewValue, $this->weaving_works->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }
            $this->buyer_id->TooltipValue = "";

            // poid
            $this->poid->HrefValue = "";
            $this->poid->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // week
            $this->week->HrefValue = "";
            $this->week->TooltipValue = "";

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }
            $this->product_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // Size_wl
            $this->Size_wl->HrefValue = "";
            $this->Size_wl->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";
            $this->t_sqm->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";
            $this->material_qty->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";
            $this->production_plan->TooltipValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";
            $this->req_material_rid->TooltipValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";
            $this->req_material_packing->TooltipValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->HrefValue = "";

            // issue_material_qty
            $this->issue_material_qty->HrefValue = "";

            // issue_material_packing
            $this->issue_material_packing->HrefValue = "";

            // issue_material_lot_no
            $this->issue_material_lot_no->HrefValue = "";

            // issue_material_godown
            $this->issue_material_godown->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->EditValue = null;
            }

            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditValue = $this->poid->CurrentValue;

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;

            // week
            $this->week->setupEditAttributes();
            $this->week->EditValue = $this->week->CurrentValue;
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->EditValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->EditValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->EditValue = FormatNumber($this->week->CurrentValue, $this->week->formatPattern());
                    }
                }
            } else {
                $this->week->EditValue = null;
            }

            // product_id
            $this->product_id->setupEditAttributes();
            $curVal = strval($this->product_id->CurrentValue);
            if ($curVal != "") {
                $this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
                if ($this->product_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                        $this->product_id->EditValue = $this->product_id->displayValue($arwrk);
                    } else {
                        $this->product_id->EditValue = $this->product_id->CurrentValue;
                    }
                }
            } else {
                $this->product_id->EditValue = null;
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

            // Size_wl
            $this->Size_wl->setupEditAttributes();
            $this->Size_wl->EditValue = $this->Size_wl->CurrentValue;

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

            // t_sqm
            $this->t_sqm->setupEditAttributes();
            $this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, $this->t_sqm->formatPattern());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->EditValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->EditValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->EditValue = null;
            }

            // material_qty
            $this->material_qty->setupEditAttributes();
            $this->material_qty->EditValue = $this->material_qty->CurrentValue;
            $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, $this->material_qty->formatPattern());

            // method
            $this->method->setupEditAttributes();
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->EditValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->EditValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->EditValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->EditValue = null;
            }

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->EditValue = null;
            }

            // production_plan
            $this->production_plan->setupEditAttributes();
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->EditValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->EditValue = null;
            }

            // req_material_rid
            $this->req_material_rid->setupEditAttributes();
            if ($this->req_material_rid->VirtualValue != "") {
                $this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
            } else {
                $curVal = strval($this->req_material_rid->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
                    if ($this->req_material_rid->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
                        } else {
                            $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_rid->EditValue = null;
                }
            }

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->EditValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->EditValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->EditValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->EditValue = null;
            }

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, $this->req_material_qty->formatPattern());

            // issue_material_lcgp_rid
            $curVal = trim(strval($this->issue_material_lcgp_rid->CurrentValue));
            if ($curVal != "") {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->lookupCacheOption($curVal);
            } else {
                $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->Lookup !== null && is_array($this->issue_material_lcgp_rid->lookupOptions()) && count($this->issue_material_lcgp_rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_material_lcgp_rid->ViewValue !== null) { // Load from cache
                $this->issue_material_lcgp_rid->EditValue = array_values($this->issue_material_lcgp_rid->lookupOptions());
                if ($this->issue_material_lcgp_rid->ViewValue == "") {
                    $this->issue_material_lcgp_rid->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_material_lcgp_rid->CurrentValue, $this->issue_material_lcgp_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->issue_material_lcgp_rid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_material_lcgp_rid->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_material_lcgp_rid->ViewValue = $this->issue_material_lcgp_rid->displayValue($arwrk);
                } else {
                    $this->issue_material_lcgp_rid->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->issue_material_lcgp_rid->Lookup->renderViewRow($row);
                }
                $this->issue_material_lcgp_rid->EditValue = $arwrk;
            }
            $this->issue_material_lcgp_rid->PlaceHolder = RemoveHtml($this->issue_material_lcgp_rid->caption());

            // issue_material_qty
            $this->issue_material_qty->setupEditAttributes();
            $this->issue_material_qty->EditValue = $this->issue_material_qty->CurrentValue;
            $this->issue_material_qty->PlaceHolder = RemoveHtml($this->issue_material_qty->caption());
            if (strval($this->issue_material_qty->EditValue) != "" && is_numeric($this->issue_material_qty->EditValue)) {
                $this->issue_material_qty->EditValue = FormatNumber($this->issue_material_qty->EditValue, null);
            }

            // issue_material_packing
            $this->issue_material_packing->setupEditAttributes();
            $this->issue_material_packing->EditCustomAttributes = $this->issue_material_packing->getEditCustomAttributes(); // PHP
            $this->issue_material_packing->EditValue = $this->issue_material_packing->CurrentValue;
            $curVal = strval($this->issue_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_packing->EditValue = $this->issue_material_packing->lookupCacheOption($curVal);
                if ($this->issue_material_packing->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_packing->EditValue = $this->issue_material_packing->displayValue($arwrk);
                    } else {
                        $this->issue_material_packing->EditValue = HtmlEncode(FormatNumber($this->issue_material_packing->CurrentValue, $this->issue_material_packing->formatPattern()));
                    }
                }
            } else {
                $this->issue_material_packing->EditValue = null;
            }
            $this->issue_material_packing->PlaceHolder = RemoveHtml($this->issue_material_packing->caption());

            // issue_material_lot_no
            $this->issue_material_lot_no->setupEditAttributes();
            $this->issue_material_lot_no->EditCustomAttributes = $this->issue_material_lot_no->getEditCustomAttributes(); // PHP
            if (!$this->issue_material_lot_no->Raw) {
                $this->issue_material_lot_no->CurrentValue = HtmlDecode($this->issue_material_lot_no->CurrentValue);
            }
            $this->issue_material_lot_no->EditValue = HtmlEncode($this->issue_material_lot_no->CurrentValue);
            $this->issue_material_lot_no->PlaceHolder = RemoveHtml($this->issue_material_lot_no->caption());

            // issue_material_godown
            $this->issue_material_godown->setupEditAttributes();
            $this->issue_material_godown->EditCustomAttributes = $this->issue_material_godown->getEditCustomAttributes(); // PHP
            $this->issue_material_godown->EditValue = $this->issue_material_godown->CurrentValue;
            $curVal = strval($this->issue_material_godown->CurrentValue);
            if ($curVal != "") {
                $this->issue_material_godown->EditValue = $this->issue_material_godown->lookupCacheOption($curVal);
                if ($this->issue_material_godown->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_material_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_material_godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_material_godown->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_material_godown->EditValue = $this->issue_material_godown->displayValue($arwrk);
                    } else {
                        $this->issue_material_godown->EditValue = HtmlEncode(FormatNumber($this->issue_material_godown->CurrentValue, $this->issue_material_godown->formatPattern()));
                    }
                }
            } else {
                $this->issue_material_godown->EditValue = null;
            }
            $this->issue_material_godown->PlaceHolder = RemoveHtml($this->issue_material_godown->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->EditValue, $this->despatch_date->formatPattern());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }
            $this->buyer_id->TooltipValue = "";

            // poid
            $this->poid->HrefValue = "";
            $this->poid->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // week
            $this->week->HrefValue = "";
            $this->week->TooltipValue = "";

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }
            $this->product_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // Size_wl
            $this->Size_wl->HrefValue = "";
            $this->Size_wl->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";
            $this->t_sqm->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";
            $this->material_qty->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";
            $this->production_plan->TooltipValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";
            $this->req_material_rid->TooltipValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";
            $this->req_material_packing->TooltipValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->HrefValue = "";

            // issue_material_qty
            $this->issue_material_qty->HrefValue = "";

            // issue_material_packing
            $this->issue_material_packing->HrefValue = "";

            // issue_material_lot_no
            $this->issue_material_lot_no->HrefValue = "";

            // issue_material_godown
            $this->issue_material_godown->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->poid->Visible && $this->poid->Required) {
                if (!$this->poid->IsDetailKey && EmptyValue($this->poid->FormValue)) {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->week->Visible && $this->week->Required) {
                if (!$this->week->IsDetailKey && EmptyValue($this->week->FormValue)) {
                    $this->week->addErrorMessage(str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
                }
            }
            if ($this->product_id->Visible && $this->product_id->Required) {
                if (!$this->product_id->IsDetailKey && EmptyValue($this->product_id->FormValue)) {
                    $this->product_id->addErrorMessage(str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->Size_wl->Visible && $this->Size_wl->Required) {
                if (!$this->Size_wl->IsDetailKey && EmptyValue($this->Size_wl->FormValue)) {
                    $this->Size_wl->addErrorMessage(str_replace("%s", $this->Size_wl->caption(), $this->Size_wl->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->t_sqm->Visible && $this->t_sqm->Required) {
                if (!$this->t_sqm->IsDetailKey && EmptyValue($this->t_sqm->FormValue)) {
                    $this->t_sqm->addErrorMessage(str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->material_qty->Visible && $this->material_qty->Required) {
                if (!$this->material_qty->IsDetailKey && EmptyValue($this->material_qty->FormValue)) {
                    $this->material_qty->addErrorMessage(str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
                }
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->production_plan->Visible && $this->production_plan->Required) {
                if (!$this->production_plan->IsDetailKey && EmptyValue($this->production_plan->FormValue)) {
                    $this->production_plan->addErrorMessage(str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
                }
            }
            if ($this->req_material_rid->Visible && $this->req_material_rid->Required) {
                if ($this->req_material_rid->FormValue == "") {
                    $this->req_material_rid->addErrorMessage(str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
                }
            }
            if ($this->req_material_packing->Visible && $this->req_material_packing->Required) {
                if (!$this->req_material_packing->IsDetailKey && EmptyValue($this->req_material_packing->FormValue)) {
                    $this->req_material_packing->addErrorMessage(str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
                }
            }
            if ($this->req_material_qty->Visible && $this->req_material_qty->Required) {
                if (!$this->req_material_qty->IsDetailKey && EmptyValue($this->req_material_qty->FormValue)) {
                    $this->req_material_qty->addErrorMessage(str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
                }
            }
            if ($this->issue_material_lcgp_rid->Visible && $this->issue_material_lcgp_rid->Required) {
                if (!$this->issue_material_lcgp_rid->IsDetailKey && EmptyValue($this->issue_material_lcgp_rid->FormValue)) {
                    $this->issue_material_lcgp_rid->addErrorMessage(str_replace("%s", $this->issue_material_lcgp_rid->caption(), $this->issue_material_lcgp_rid->RequiredErrorMessage));
                }
            }
            if ($this->issue_material_qty->Visible && $this->issue_material_qty->Required) {
                if (!$this->issue_material_qty->IsDetailKey && EmptyValue($this->issue_material_qty->FormValue)) {
                    $this->issue_material_qty->addErrorMessage(str_replace("%s", $this->issue_material_qty->caption(), $this->issue_material_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->issue_material_qty->FormValue)) {
                $this->issue_material_qty->addErrorMessage($this->issue_material_qty->getErrorMessage(false));
            }
            if ($this->issue_material_packing->Visible && $this->issue_material_packing->Required) {
                if (!$this->issue_material_packing->IsDetailKey && EmptyValue($this->issue_material_packing->FormValue)) {
                    $this->issue_material_packing->addErrorMessage(str_replace("%s", $this->issue_material_packing->caption(), $this->issue_material_packing->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->issue_material_packing->FormValue)) {
                $this->issue_material_packing->addErrorMessage($this->issue_material_packing->getErrorMessage(false));
            }
            if ($this->issue_material_lot_no->Visible && $this->issue_material_lot_no->Required) {
                if (!$this->issue_material_lot_no->IsDetailKey && EmptyValue($this->issue_material_lot_no->FormValue)) {
                    $this->issue_material_lot_no->addErrorMessage(str_replace("%s", $this->issue_material_lot_no->caption(), $this->issue_material_lot_no->RequiredErrorMessage));
                }
            }
            if ($this->issue_material_godown->Visible && $this->issue_material_godown->Required) {
                if (!$this->issue_material_godown->IsDetailKey && EmptyValue($this->issue_material_godown->FormValue)) {
                    $this->issue_material_godown->addErrorMessage(str_replace("%s", $this->issue_material_godown->caption(), $this->issue_material_godown->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->issue_material_godown->FormValue)) {
                $this->issue_material_godown->addErrorMessage($this->issue_material_godown->getErrorMessage(false));
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check referential integrity for master table 'required_material_compiled'
        $detailKeys = [];
        $keyValue = $rsnew['po'] ?? $rsold['po'];
        $detailKeys['po'] = $keyValue;
        $keyValue = $rsnew['req_material_rid'] ?? $rsold['req_material_rid'];
        $detailKeys['req_material_rid'] = $keyValue;
        $masterTable = Container("required_material_compiled");
        $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
        if (!EmptyValue($masterFilter)) {
            $rsmaster = $masterTable->loadRs($masterFilter)->fetch();
            $validMasterRecord = $rsmaster !== false;
        } else { // Allow null value if not required field
            $validMasterRecord = $masterFilter === null;
        }
        if (!$validMasterRecord) {
            $relatedRecordMsg = str_replace("%t", "required_material_compiled", $Language->phrase("RelatedRecordRequired"));
            $this->setFailureMessage($relatedRecordMsg);
            return false;
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // issue_material_lcgp_rid
        $this->issue_material_lcgp_rid->setDbValueDef($rsnew, $this->issue_material_lcgp_rid->CurrentValue, $this->issue_material_lcgp_rid->ReadOnly);

        // issue_material_qty
        $this->issue_material_qty->setDbValueDef($rsnew, $this->issue_material_qty->CurrentValue, $this->issue_material_qty->ReadOnly);

        // issue_material_packing
        $this->issue_material_packing->setDbValueDef($rsnew, $this->issue_material_packing->CurrentValue, $this->issue_material_packing->ReadOnly);

        // issue_material_lot_no
        $this->issue_material_lot_no->setDbValueDef($rsnew, $this->issue_material_lot_no->CurrentValue, $this->issue_material_lot_no->ReadOnly);

        // issue_material_godown
        $this->issue_material_godown->setDbValueDef($rsnew, $this->issue_material_godown->CurrentValue, $this->issue_material_godown->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['issue_material_lcgp_rid'])) { // issue_material_lcgp_rid
            $this->issue_material_lcgp_rid->CurrentValue = $row['issue_material_lcgp_rid'];
        }
        if (isset($row['issue_material_qty'])) { // issue_material_qty
            $this->issue_material_qty->CurrentValue = $row['issue_material_qty'];
        }
        if (isset($row['issue_material_packing'])) { // issue_material_packing
            $this->issue_material_packing->CurrentValue = $row['issue_material_packing'];
        }
        if (isset($row['issue_material_lot_no'])) { // issue_material_lot_no
            $this->issue_material_lot_no->CurrentValue = $row['issue_material_lot_no'];
        }
        if (isset($row['issue_material_godown'])) { // issue_material_godown
            $this->issue_material_godown->CurrentValue = $row['issue_material_godown'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "required_material_compiled") {
                $validMaster = true;
                $masterTbl = Container("required_material_compiled");
                if (($parm = Get("fk_po", Get("po"))) !== null) {
                    $masterTbl->po->setQueryStringValue($parm);
                    $this->po->QueryStringValue = $masterTbl->po->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->po->setSessionValue($this->po->QueryStringValue);
                    $foreignKeys["po"] = $this->po->QueryStringValue;
                    if (!is_numeric($masterTbl->po->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_req_material_rid", Get("req_material_rid"))) !== null) {
                    $masterTbl->req_material_rid->setQueryStringValue($parm);
                    $this->req_material_rid->QueryStringValue = $masterTbl->req_material_rid->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->req_material_rid->setSessionValue($this->req_material_rid->QueryStringValue);
                    $foreignKeys["req_material_rid"] = $this->req_material_rid->QueryStringValue;
                    if (!is_numeric($masterTbl->req_material_rid->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "required_material_compiled") {
                $validMaster = true;
                $masterTbl = Container("required_material_compiled");
                if (($parm = Post("fk_po", Post("po"))) !== null) {
                    $masterTbl->po->setFormValue($parm);
                    $this->po->FormValue = $masterTbl->po->FormValue;
                    $this->po->setSessionValue($this->po->FormValue);
                    $foreignKeys["po"] = $this->po->FormValue;
                    if (!is_numeric($masterTbl->po->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_req_material_rid", Post("req_material_rid"))) !== null) {
                    $masterTbl->req_material_rid->setFormValue($parm);
                    $this->req_material_rid->FormValue = $masterTbl->req_material_rid->FormValue;
                    $this->req_material_rid->setSessionValue($this->req_material_rid->FormValue);
                    $foreignKeys["req_material_rid"] = $this->req_material_rid->FormValue;
                    if (!is_numeric($masterTbl->req_material_rid->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "required_material_compiled") {
                if (!array_key_exists("po", $foreignKeys)) { // Not current foreign key
                    $this->po->setSessionValue("");
                }
                if (!array_key_exists("req_material_rid", $foreignKeys)) { // Not current foreign key
                    $this->req_material_rid->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialrequiredlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_id":
                    break;
                case "x_week":
                    break;
                case "x_product_id":
                    break;
                case "x_batch_no":
                    break;
                case "x_unit":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_production_plan":
                    break;
                case "x_req_material_grp":
                    break;
                case "x_req_material_sgrp":
                    break;
                case "x_req_material_product":
                    break;
                case "x_req_material_rid":
                    break;
                case "x_req_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_lcgp_rid":
                    break;
                case "x_issue_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_godown":
                    break;
                case "x_grp":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_material_out":
                    break;
                case "x_issue_material_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_sgrp":
                    break;
                case "x_issue_material_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_rid":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
