<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialOutOldList extends MaterialOutOld
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialOutOldList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fmaterial_out_oldlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "materialoutoldlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->rid_1->Visible = false;
        $this->rid_name->Visible = false;
        $this->packets->setVisibility();
        $this->packing_type->setVisibility();
        $this->quantity_avg_act->Visible = false;
        $this->quantity_sub->setVisibility();
        $this->quantity->setVisibility();
        $this->process->setVisibility();
        $this->process_type->setVisibility();
        $this->lot_no->setVisibility();
        $this->_barcode->Visible = false;
        $this->tmp_lot->Visible = false;
        $this->price->setVisibility();
        $this->cart_amount->Visible = false;
        $this->other_amount->Visible = false;
        $this->amount->Visible = false;
        $this->tax_amount->Visible = false;
        $this->total_amount->setVisibility();
        $this->tax_percent->Visible = false;
        $this->hsn_code->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->company_id->Visible = false;
        $this->godown->setVisibility();
        $this->godown_po->setVisibility();
        $this->issue_to->setVisibility();
        $this->issue_to_unit->Visible = false;
        $this->gp_no->Visible = false;
        $this->dated->setVisibility();
        $this->jc_no->setVisibility();
        $this->po->Visible = false;
        $this->_print->Visible = false;
        $this->remarks->Visible = false;
        $this->status->setVisibility();
        $this->uploads->setVisibility();
        $this->cart_ref->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'material_out_old';
        $this->TableName = 'material_out_old';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_out_old)
        if (!isset($GLOBALS["material_out_old"]) || $GLOBALS["material_out_old"]::class == PROJECT_NAMESPACE . "material_out_old") {
            $GLOBALS["material_out_old"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "materialoutoldadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "materialoutolddelete";
        $this->MultiUpdateUrl = "materialoutoldupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out_old');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "materialoutoldview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->rid_1);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->quantity_avg_act);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_type);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->godown_po);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->issue_to_unit);
        $this->setupLookupOptions($this->status);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fmaterial_out_oldgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fmaterial_out_oldsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
        $filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
        $filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
        $filterList = Concat($filterList, $this->rid_1->AdvancedSearch->toJson(), ","); // Field rid_1
        $filterList = Concat($filterList, $this->packets->AdvancedSearch->toJson(), ","); // Field packets
        $filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
        $filterList = Concat($filterList, $this->quantity_sub->AdvancedSearch->toJson(), ","); // Field quantity_sub
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
        $filterList = Concat($filterList, $this->lot_no->AdvancedSearch->toJson(), ","); // Field lot_no
        $filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
        $filterList = Concat($filterList, $this->cart_amount->AdvancedSearch->toJson(), ","); // Field cart_amount
        $filterList = Concat($filterList, $this->other_amount->AdvancedSearch->toJson(), ","); // Field other_amount
        $filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
        $filterList = Concat($filterList, $this->tax_amount->AdvancedSearch->toJson(), ","); // Field tax_amount
        $filterList = Concat($filterList, $this->total_amount->AdvancedSearch->toJson(), ","); // Field total_amount
        $filterList = Concat($filterList, $this->tax_percent->AdvancedSearch->toJson(), ","); // Field tax_percent
        $filterList = Concat($filterList, $this->hsn_code->AdvancedSearch->toJson(), ","); // Field hsn_code
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->godown->AdvancedSearch->toJson(), ","); // Field godown
        $filterList = Concat($filterList, $this->godown_po->AdvancedSearch->toJson(), ","); // Field godown_po
        $filterList = Concat($filterList, $this->issue_to->AdvancedSearch->toJson(), ","); // Field issue_to
        $filterList = Concat($filterList, $this->issue_to_unit->AdvancedSearch->toJson(), ","); // Field issue_to_unit
        $filterList = Concat($filterList, $this->dated->AdvancedSearch->toJson(), ","); // Field dated
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->uploads->AdvancedSearch->toJson(), ","); // Field uploads
        $filterList = Concat($filterList, $this->cart_ref->AdvancedSearch->toJson(), ","); // Field cart_ref
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fmaterial_out_oldsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field s_grp
        $this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
        $this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
        $this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
        $this->s_grp->AdvancedSearch->save();

        // Field product
        $this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
        $this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
        $this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
        $this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
        $this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
        $this->product->AdvancedSearch->save();

        // Field rid
        $this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
        $this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
        $this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
        $this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
        $this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
        $this->rid->AdvancedSearch->save();

        // Field rid_1
        $this->rid_1->AdvancedSearch->SearchValue = @$filter["x_rid_1"];
        $this->rid_1->AdvancedSearch->SearchOperator = @$filter["z_rid_1"];
        $this->rid_1->AdvancedSearch->SearchCondition = @$filter["v_rid_1"];
        $this->rid_1->AdvancedSearch->SearchValue2 = @$filter["y_rid_1"];
        $this->rid_1->AdvancedSearch->SearchOperator2 = @$filter["w_rid_1"];
        $this->rid_1->AdvancedSearch->save();

        // Field packets
        $this->packets->AdvancedSearch->SearchValue = @$filter["x_packets"];
        $this->packets->AdvancedSearch->SearchOperator = @$filter["z_packets"];
        $this->packets->AdvancedSearch->SearchCondition = @$filter["v_packets"];
        $this->packets->AdvancedSearch->SearchValue2 = @$filter["y_packets"];
        $this->packets->AdvancedSearch->SearchOperator2 = @$filter["w_packets"];
        $this->packets->AdvancedSearch->save();

        // Field packing_type
        $this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
        $this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
        $this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
        $this->packing_type->AdvancedSearch->save();

        // Field quantity_sub
        $this->quantity_sub->AdvancedSearch->SearchValue = @$filter["x_quantity_sub"];
        $this->quantity_sub->AdvancedSearch->SearchOperator = @$filter["z_quantity_sub"];
        $this->quantity_sub->AdvancedSearch->SearchCondition = @$filter["v_quantity_sub"];
        $this->quantity_sub->AdvancedSearch->SearchValue2 = @$filter["y_quantity_sub"];
        $this->quantity_sub->AdvancedSearch->SearchOperator2 = @$filter["w_quantity_sub"];
        $this->quantity_sub->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field process
        $this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
        $this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
        $this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
        $this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
        $this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
        $this->process->AdvancedSearch->save();

        // Field lot_no
        $this->lot_no->AdvancedSearch->SearchValue = @$filter["x_lot_no"];
        $this->lot_no->AdvancedSearch->SearchOperator = @$filter["z_lot_no"];
        $this->lot_no->AdvancedSearch->SearchCondition = @$filter["v_lot_no"];
        $this->lot_no->AdvancedSearch->SearchValue2 = @$filter["y_lot_no"];
        $this->lot_no->AdvancedSearch->SearchOperator2 = @$filter["w_lot_no"];
        $this->lot_no->AdvancedSearch->save();

        // Field price
        $this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
        $this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
        $this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
        $this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
        $this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
        $this->price->AdvancedSearch->save();

        // Field cart_amount
        $this->cart_amount->AdvancedSearch->SearchValue = @$filter["x_cart_amount"];
        $this->cart_amount->AdvancedSearch->SearchOperator = @$filter["z_cart_amount"];
        $this->cart_amount->AdvancedSearch->SearchCondition = @$filter["v_cart_amount"];
        $this->cart_amount->AdvancedSearch->SearchValue2 = @$filter["y_cart_amount"];
        $this->cart_amount->AdvancedSearch->SearchOperator2 = @$filter["w_cart_amount"];
        $this->cart_amount->AdvancedSearch->save();

        // Field other_amount
        $this->other_amount->AdvancedSearch->SearchValue = @$filter["x_other_amount"];
        $this->other_amount->AdvancedSearch->SearchOperator = @$filter["z_other_amount"];
        $this->other_amount->AdvancedSearch->SearchCondition = @$filter["v_other_amount"];
        $this->other_amount->AdvancedSearch->SearchValue2 = @$filter["y_other_amount"];
        $this->other_amount->AdvancedSearch->SearchOperator2 = @$filter["w_other_amount"];
        $this->other_amount->AdvancedSearch->save();

        // Field amount
        $this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
        $this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
        $this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
        $this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
        $this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
        $this->amount->AdvancedSearch->save();

        // Field tax_amount
        $this->tax_amount->AdvancedSearch->SearchValue = @$filter["x_tax_amount"];
        $this->tax_amount->AdvancedSearch->SearchOperator = @$filter["z_tax_amount"];
        $this->tax_amount->AdvancedSearch->SearchCondition = @$filter["v_tax_amount"];
        $this->tax_amount->AdvancedSearch->SearchValue2 = @$filter["y_tax_amount"];
        $this->tax_amount->AdvancedSearch->SearchOperator2 = @$filter["w_tax_amount"];
        $this->tax_amount->AdvancedSearch->save();

        // Field total_amount
        $this->total_amount->AdvancedSearch->SearchValue = @$filter["x_total_amount"];
        $this->total_amount->AdvancedSearch->SearchOperator = @$filter["z_total_amount"];
        $this->total_amount->AdvancedSearch->SearchCondition = @$filter["v_total_amount"];
        $this->total_amount->AdvancedSearch->SearchValue2 = @$filter["y_total_amount"];
        $this->total_amount->AdvancedSearch->SearchOperator2 = @$filter["w_total_amount"];
        $this->total_amount->AdvancedSearch->save();

        // Field tax_percent
        $this->tax_percent->AdvancedSearch->SearchValue = @$filter["x_tax_percent"];
        $this->tax_percent->AdvancedSearch->SearchOperator = @$filter["z_tax_percent"];
        $this->tax_percent->AdvancedSearch->SearchCondition = @$filter["v_tax_percent"];
        $this->tax_percent->AdvancedSearch->SearchValue2 = @$filter["y_tax_percent"];
        $this->tax_percent->AdvancedSearch->SearchOperator2 = @$filter["w_tax_percent"];
        $this->tax_percent->AdvancedSearch->save();

        // Field hsn_code
        $this->hsn_code->AdvancedSearch->SearchValue = @$filter["x_hsn_code"];
        $this->hsn_code->AdvancedSearch->SearchOperator = @$filter["z_hsn_code"];
        $this->hsn_code->AdvancedSearch->SearchCondition = @$filter["v_hsn_code"];
        $this->hsn_code->AdvancedSearch->SearchValue2 = @$filter["y_hsn_code"];
        $this->hsn_code->AdvancedSearch->SearchOperator2 = @$filter["w_hsn_code"];
        $this->hsn_code->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field godown
        $this->godown->AdvancedSearch->SearchValue = @$filter["x_godown"];
        $this->godown->AdvancedSearch->SearchOperator = @$filter["z_godown"];
        $this->godown->AdvancedSearch->SearchCondition = @$filter["v_godown"];
        $this->godown->AdvancedSearch->SearchValue2 = @$filter["y_godown"];
        $this->godown->AdvancedSearch->SearchOperator2 = @$filter["w_godown"];
        $this->godown->AdvancedSearch->save();

        // Field godown_po
        $this->godown_po->AdvancedSearch->SearchValue = @$filter["x_godown_po"];
        $this->godown_po->AdvancedSearch->SearchOperator = @$filter["z_godown_po"];
        $this->godown_po->AdvancedSearch->SearchCondition = @$filter["v_godown_po"];
        $this->godown_po->AdvancedSearch->SearchValue2 = @$filter["y_godown_po"];
        $this->godown_po->AdvancedSearch->SearchOperator2 = @$filter["w_godown_po"];
        $this->godown_po->AdvancedSearch->save();

        // Field issue_to
        $this->issue_to->AdvancedSearch->SearchValue = @$filter["x_issue_to"];
        $this->issue_to->AdvancedSearch->SearchOperator = @$filter["z_issue_to"];
        $this->issue_to->AdvancedSearch->SearchCondition = @$filter["v_issue_to"];
        $this->issue_to->AdvancedSearch->SearchValue2 = @$filter["y_issue_to"];
        $this->issue_to->AdvancedSearch->SearchOperator2 = @$filter["w_issue_to"];
        $this->issue_to->AdvancedSearch->save();

        // Field issue_to_unit
        $this->issue_to_unit->AdvancedSearch->SearchValue = @$filter["x_issue_to_unit"];
        $this->issue_to_unit->AdvancedSearch->SearchOperator = @$filter["z_issue_to_unit"];
        $this->issue_to_unit->AdvancedSearch->SearchCondition = @$filter["v_issue_to_unit"];
        $this->issue_to_unit->AdvancedSearch->SearchValue2 = @$filter["y_issue_to_unit"];
        $this->issue_to_unit->AdvancedSearch->SearchOperator2 = @$filter["w_issue_to_unit"];
        $this->issue_to_unit->AdvancedSearch->save();

        // Field dated
        $this->dated->AdvancedSearch->SearchValue = @$filter["x_dated"];
        $this->dated->AdvancedSearch->SearchOperator = @$filter["z_dated"];
        $this->dated->AdvancedSearch->SearchCondition = @$filter["v_dated"];
        $this->dated->AdvancedSearch->SearchValue2 = @$filter["y_dated"];
        $this->dated->AdvancedSearch->SearchOperator2 = @$filter["w_dated"];
        $this->dated->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field uploads
        $this->uploads->AdvancedSearch->SearchValue = @$filter["x_uploads"];
        $this->uploads->AdvancedSearch->SearchOperator = @$filter["z_uploads"];
        $this->uploads->AdvancedSearch->SearchCondition = @$filter["v_uploads"];
        $this->uploads->AdvancedSearch->SearchValue2 = @$filter["y_uploads"];
        $this->uploads->AdvancedSearch->SearchOperator2 = @$filter["w_uploads"];
        $this->uploads->AdvancedSearch->save();

        // Field cart_ref
        $this->cart_ref->AdvancedSearch->SearchValue = @$filter["x_cart_ref"];
        $this->cart_ref->AdvancedSearch->SearchOperator = @$filter["z_cart_ref"];
        $this->cart_ref->AdvancedSearch->SearchCondition = @$filter["v_cart_ref"];
        $this->cart_ref->AdvancedSearch->SearchValue2 = @$filter["y_cart_ref"];
        $this->cart_ref->AdvancedSearch->SearchOperator2 = @$filter["w_cart_ref"];
        $this->cart_ref->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->s_grp, $default, false); // s_grp
        $this->buildSearchSql($where, $this->product, $default, false); // product
        $this->buildSearchSql($where, $this->rid, $default, false); // rid
        $this->buildSearchSql($where, $this->rid_1, $default, false); // rid_1
        $this->buildSearchSql($where, $this->packets, $default, false); // packets
        $this->buildSearchSql($where, $this->packing_type, $default, false); // packing_type
        $this->buildSearchSql($where, $this->quantity_sub, $default, false); // quantity_sub
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->process, $default, false); // process
        $this->buildSearchSql($where, $this->lot_no, $default, false); // lot_no
        $this->buildSearchSql($where, $this->price, $default, false); // price
        $this->buildSearchSql($where, $this->cart_amount, $default, false); // cart_amount
        $this->buildSearchSql($where, $this->other_amount, $default, false); // other_amount
        $this->buildSearchSql($where, $this->amount, $default, false); // amount
        $this->buildSearchSql($where, $this->tax_amount, $default, false); // tax_amount
        $this->buildSearchSql($where, $this->total_amount, $default, false); // total_amount
        $this->buildSearchSql($where, $this->tax_percent, $default, false); // tax_percent
        $this->buildSearchSql($where, $this->hsn_code, $default, false); // hsn_code
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->godown, $default, false); // godown
        $this->buildSearchSql($where, $this->godown_po, $default, false); // godown_po
        $this->buildSearchSql($where, $this->issue_to, $default, false); // issue_to
        $this->buildSearchSql($where, $this->issue_to_unit, $default, false); // issue_to_unit
        $this->buildSearchSql($where, $this->dated, $default, false); // dated
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->uploads, $default, false); // uploads
        $this->buildSearchSql($where, $this->cart_ref, $default, false); // cart_ref

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->rid_1->AdvancedSearch->save(); // rid_1
            $this->packets->AdvancedSearch->save(); // packets
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->quantity_sub->AdvancedSearch->save(); // quantity_sub
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->process->AdvancedSearch->save(); // process
            $this->lot_no->AdvancedSearch->save(); // lot_no
            $this->price->AdvancedSearch->save(); // price
            $this->cart_amount->AdvancedSearch->save(); // cart_amount
            $this->other_amount->AdvancedSearch->save(); // other_amount
            $this->amount->AdvancedSearch->save(); // amount
            $this->tax_amount->AdvancedSearch->save(); // tax_amount
            $this->total_amount->AdvancedSearch->save(); // total_amount
            $this->tax_percent->AdvancedSearch->save(); // tax_percent
            $this->hsn_code->AdvancedSearch->save(); // hsn_code
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->godown->AdvancedSearch->save(); // godown
            $this->godown_po->AdvancedSearch->save(); // godown_po
            $this->issue_to->AdvancedSearch->save(); // issue_to
            $this->issue_to_unit->AdvancedSearch->save(); // issue_to_unit
            $this->dated->AdvancedSearch->save(); // dated
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->status->AdvancedSearch->save(); // status
            $this->uploads->AdvancedSearch->save(); // uploads
            $this->cart_ref->AdvancedSearch->save(); // cart_ref

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->rid_1->AdvancedSearch->save(); // rid_1
            $this->packets->AdvancedSearch->save(); // packets
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->quantity_sub->AdvancedSearch->save(); // quantity_sub
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->process->AdvancedSearch->save(); // process
            $this->lot_no->AdvancedSearch->save(); // lot_no
            $this->price->AdvancedSearch->save(); // price
            $this->cart_amount->AdvancedSearch->save(); // cart_amount
            $this->other_amount->AdvancedSearch->save(); // other_amount
            $this->amount->AdvancedSearch->save(); // amount
            $this->tax_amount->AdvancedSearch->save(); // tax_amount
            $this->total_amount->AdvancedSearch->save(); // total_amount
            $this->tax_percent->AdvancedSearch->save(); // tax_percent
            $this->hsn_code->AdvancedSearch->save(); // hsn_code
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->godown->AdvancedSearch->save(); // godown
            $this->godown_po->AdvancedSearch->save(); // godown_po
            $this->issue_to->AdvancedSearch->save(); // issue_to
            $this->issue_to_unit->AdvancedSearch->save(); // issue_to_unit
            $this->dated->AdvancedSearch->save(); // dated
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->status->AdvancedSearch->save(); // status
            $this->uploads->AdvancedSearch->save(); // uploads
            $this->cart_ref->AdvancedSearch->save(); // cart_ref
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product
        $filter = $this->queryBuilderWhere("product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field rid
        $filter = $this->queryBuilderWhere("rid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->rid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->rid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packets
        $filter = $this->queryBuilderWhere("packets");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packets, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packets->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packing_type
        $filter = $this->queryBuilderWhere("packing_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packing_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packing_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity_sub
        $filter = $this->queryBuilderWhere("quantity_sub");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity_sub, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity_sub->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field process
        $filter = $this->queryBuilderWhere("process");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->process, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->process->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field lot_no
        $filter = $this->queryBuilderWhere("lot_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->lot_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->lot_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price
        $filter = $this->queryBuilderWhere("price");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field total_amount
        $filter = $this->queryBuilderWhere("total_amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->total_amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->total_amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field godown
        $filter = $this->queryBuilderWhere("godown");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->godown, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->godown->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field godown_po
        $filter = $this->queryBuilderWhere("godown_po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->godown_po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->godown_po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field issue_to
        $filter = $this->queryBuilderWhere("issue_to");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->issue_to, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->issue_to->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dated
        $filter = $this->queryBuilderWhere("dated");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dated, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dated->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field uploads
        $filter = $this->queryBuilderWhere("uploads");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->uploads, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->uploads->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cart_ref
        $filter = $this->queryBuilderWhere("cart_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cart_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cart_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->grp;
        $searchFlds[] = &$this->s_grp;
        $searchFlds[] = &$this->product;
        $searchFlds[] = &$this->rid;
        $searchFlds[] = &$this->rid_1;
        $searchFlds[] = &$this->packets;
        $searchFlds[] = &$this->packing_type;
        $searchFlds[] = &$this->quantity_avg_act;
        $searchFlds[] = &$this->quantity_sub;
        $searchFlds[] = &$this->quantity;
        $searchFlds[] = &$this->process;
        $searchFlds[] = &$this->process_type;
        $searchFlds[] = &$this->lot_no;
        $searchFlds[] = &$this->_barcode;
        $searchFlds[] = &$this->tmp_lot;
        $searchFlds[] = &$this->price;
        $searchFlds[] = &$this->cart_amount;
        $searchFlds[] = &$this->other_amount;
        $searchFlds[] = &$this->amount;
        $searchFlds[] = &$this->tax_amount;
        $searchFlds[] = &$this->total_amount;
        $searchFlds[] = &$this->tax_percent;
        $searchFlds[] = &$this->hsn_code;
        $searchFlds[] = &$this->operator;
        $searchFlds[] = &$this->datetime;
        $searchFlds[] = &$this->godown;
        $searchFlds[] = &$this->issue_to;
        $searchFlds[] = &$this->gp_no;
        $searchFlds[] = &$this->dated;
        $searchFlds[] = &$this->jc_no;
        $searchFlds[] = &$this->po;
        $searchFlds[] = &$this->_print;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->status;
        $searchFlds[] = &$this->uploads;
        $searchFlds[] = &$this->cart_ref;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rid_1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packets->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packing_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity_sub->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->process->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->lot_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cart_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->other_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->tax_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->total_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->tax_percent->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->hsn_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->godown->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->godown_po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->issue_to->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->issue_to_unit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->uploads->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cart_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->s_grp->AdvancedSearch->unsetSession();
        $this->product->AdvancedSearch->unsetSession();
        $this->rid->AdvancedSearch->unsetSession();
        $this->rid_1->AdvancedSearch->unsetSession();
        $this->packets->AdvancedSearch->unsetSession();
        $this->packing_type->AdvancedSearch->unsetSession();
        $this->quantity_sub->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->process->AdvancedSearch->unsetSession();
        $this->lot_no->AdvancedSearch->unsetSession();
        $this->price->AdvancedSearch->unsetSession();
        $this->cart_amount->AdvancedSearch->unsetSession();
        $this->other_amount->AdvancedSearch->unsetSession();
        $this->amount->AdvancedSearch->unsetSession();
        $this->tax_amount->AdvancedSearch->unsetSession();
        $this->total_amount->AdvancedSearch->unsetSession();
        $this->tax_percent->AdvancedSearch->unsetSession();
        $this->hsn_code->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->godown->AdvancedSearch->unsetSession();
        $this->godown_po->AdvancedSearch->unsetSession();
        $this->issue_to->AdvancedSearch->unsetSession();
        $this->issue_to_unit->AdvancedSearch->unsetSession();
        $this->dated->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->uploads->AdvancedSearch->unsetSession();
        $this->cart_ref->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->rid_1->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->quantity_sub->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->lot_no->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->cart_amount->AdvancedSearch->load();
        $this->other_amount->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->tax_amount->AdvancedSearch->load();
        $this->total_amount->AdvancedSearch->load();
        $this->tax_percent->AdvancedSearch->load();
        $this->hsn_code->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->godown->AdvancedSearch->load();
        $this->godown_po->AdvancedSearch->load();
        $this->issue_to->AdvancedSearch->load();
        $this->issue_to_unit->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->cart_ref->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->id->VirtualExpression != "" ? $this->id->VirtualExpression : $this->id->Expression) . " DESC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id); // id
            $this->updateSort($this->product); // product
            $this->updateSort($this->rid); // rid
            $this->updateSort($this->packets); // packets
            $this->updateSort($this->packing_type); // packing_type
            $this->updateSort($this->quantity_sub); // quantity_sub
            $this->updateSort($this->quantity); // quantity
            $this->updateSort($this->process); // process
            $this->updateSort($this->process_type); // process_type
            $this->updateSort($this->lot_no); // lot_no
            $this->updateSort($this->price); // price
            $this->updateSort($this->total_amount); // total_amount
            $this->updateSort($this->godown); // godown
            $this->updateSort($this->godown_po); // godown_po
            $this->updateSort($this->issue_to); // issue_to
            $this->updateSort($this->dated); // dated
            $this->updateSort($this->jc_no); // jc_no
            $this->updateSort($this->status); // status
            $this->updateSort($this->uploads); // uploads
            $this->updateSort($this->cart_ref); // cart_ref
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->id->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product->setSort("");
                $this->rid->setSort("");
                $this->rid_1->setSort("");
                $this->rid_name->setSort("");
                $this->packets->setSort("");
                $this->packing_type->setSort("");
                $this->quantity_avg_act->setSort("");
                $this->quantity_sub->setSort("");
                $this->quantity->setSort("");
                $this->process->setSort("");
                $this->process_type->setSort("");
                $this->lot_no->setSort("");
                $this->_barcode->setSort("");
                $this->tmp_lot->setSort("");
                $this->price->setSort("");
                $this->cart_amount->setSort("");
                $this->other_amount->setSort("");
                $this->amount->setSort("");
                $this->tax_amount->setSort("");
                $this->total_amount->setSort("");
                $this->tax_percent->setSort("");
                $this->hsn_code->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->company_id->setSort("");
                $this->godown->setSort("");
                $this->godown_po->setSort("");
                $this->issue_to->setSort("");
                $this->issue_to_unit->setSort("");
                $this->gp_no->setSort("");
                $this->dated->setSort("");
                $this->jc_no->setSort("");
                $this->po->setSort("");
                $this->_print->setSort("");
                $this->remarks->setSort("");
                $this->status->setSort("");
                $this->uploads->setSort("");
                $this->cart_ref->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"material_out_old\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fmaterial_out_oldlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fmaterial_out_oldlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "product");
            $this->createColumnOption($option, "rid");
            $this->createColumnOption($option, "packets");
            $this->createColumnOption($option, "packing_type");
            $this->createColumnOption($option, "quantity_sub");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "process");
            $this->createColumnOption($option, "process_type");
            $this->createColumnOption($option, "lot_no");
            $this->createColumnOption($option, "price");
            $this->createColumnOption($option, "total_amount");
            $this->createColumnOption($option, "godown");
            $this->createColumnOption($option, "godown_po");
            $this->createColumnOption($option, "issue_to");
            $this->createColumnOption($option, "dated");
            $this->createColumnOption($option, "jc_no");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "uploads");
            $this->createColumnOption($option, "cart_ref");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fmaterial_out_oldsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fmaterial_out_oldsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fmaterial_out_oldlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_material_out_old", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_material_out_old",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_grp->AdvancedSearch->SearchValue != "" || $this->s_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product->AdvancedSearch->SearchValue != "" || $this->product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rid->AdvancedSearch->SearchValue != "" || $this->rid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rid_1
        if ($this->rid_1->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rid_1->AdvancedSearch->SearchValue != "" || $this->rid_1->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packets
        if ($this->packets->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packets->AdvancedSearch->SearchValue != "" || $this->packets->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packing_type->AdvancedSearch->SearchValue != "" || $this->packing_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity_sub
        if ($this->quantity_sub->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity_sub->AdvancedSearch->SearchValue != "" || $this->quantity_sub->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->process->AdvancedSearch->SearchValue != "" || $this->process->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // lot_no
        if ($this->lot_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->lot_no->AdvancedSearch->SearchValue != "" || $this->lot_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price->AdvancedSearch->SearchValue != "" || $this->price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cart_amount
        if ($this->cart_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cart_amount->AdvancedSearch->SearchValue != "" || $this->cart_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // other_amount
        if ($this->other_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->other_amount->AdvancedSearch->SearchValue != "" || $this->other_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->amount->AdvancedSearch->SearchValue != "" || $this->amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // tax_amount
        if ($this->tax_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->tax_amount->AdvancedSearch->SearchValue != "" || $this->tax_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // total_amount
        if ($this->total_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->total_amount->AdvancedSearch->SearchValue != "" || $this->total_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // tax_percent
        if ($this->tax_percent->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->tax_percent->AdvancedSearch->SearchValue != "" || $this->tax_percent->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // hsn_code
        if ($this->hsn_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->hsn_code->AdvancedSearch->SearchValue != "" || $this->hsn_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // godown
        if ($this->godown->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->godown->AdvancedSearch->SearchValue != "" || $this->godown->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // godown_po
        if ($this->godown_po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->godown_po->AdvancedSearch->SearchValue != "" || $this->godown_po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // issue_to
        if ($this->issue_to->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->issue_to->AdvancedSearch->SearchValue != "" || $this->issue_to->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // issue_to_unit
        if ($this->issue_to_unit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->issue_to_unit->AdvancedSearch->SearchValue != "" || $this->issue_to_unit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dated->AdvancedSearch->SearchValue != "" || $this->dated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // uploads
        if ($this->uploads->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->uploads->AdvancedSearch->SearchValue != "" || $this->uploads->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cart_ref
        if ($this->cart_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cart_ref->AdvancedSearch->SearchValue != "" || $this->cart_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        if (array_key_exists('EV__rid', $row)) {
            $this->rid->VirtualValue = $row['EV__rid']; // Set up virtual field value
        } else {
            $this->rid->VirtualValue = ""; // Clear value
        }
        $this->rid_1->setDbValue($row['rid_1']);
        $this->rid_name->setDbValue($row['rid_name']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
        $this->quantity_sub->setDbValue($row['quantity_sub']);
        $this->quantity->setDbValue($row['quantity']);
        $this->process->setDbValue($row['process']);
        $this->process_type->setDbValue($row['process_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->tmp_lot->setDbValue($row['tmp_lot']);
        $this->price->setDbValue($row['price']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->other_amount->setDbValue($row['other_amount']);
        $this->amount->setDbValue($row['amount']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->tax_percent->setDbValue($row['tax_percent']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->company_id->setDbValue($row['company_id']);
        $this->godown->setDbValue($row['godown']);
        $this->godown_po->setDbValue($row['godown_po']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->issue_to_unit->setDbValue($row['issue_to_unit']);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->dated->setDbValue($row['dated']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->po->setDbValue($row['po']);
        $this->_print->setDbValue($row['print']);
        $this->remarks->setDbValue($row['remarks']);
        $this->status->setDbValue($row['status']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->cart_ref->setDbValue($row['cart_ref']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['rid_name'] = $this->rid_name->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['quantity_avg_act'] = $this->quantity_avg_act->DefaultValue;
        $row['quantity_sub'] = $this->quantity_sub->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['process_type'] = $this->process_type->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['tmp_lot'] = $this->tmp_lot->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['cart_amount'] = $this->cart_amount->DefaultValue;
        $row['other_amount'] = $this->other_amount->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['tax_amount'] = $this->tax_amount->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['tax_percent'] = $this->tax_percent->DefaultValue;
        $row['hsn_code'] = $this->hsn_code->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['godown_po'] = $this->godown_po->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['issue_to_unit'] = $this->issue_to_unit->DefaultValue;
        $row['gp_no'] = $this->gp_no->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['cart_ref'] = $this->cart_ref->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // grp

        // s_grp

        // product

        // rid

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // rid_name
        $this->rid_name->CellCssStyle = "white-space: nowrap;";

        // packets

        // packing_type

        // quantity_avg_act
        $this->quantity_avg_act->CellCssStyle = "white-space: nowrap;";

        // quantity_sub

        // quantity

        // process
        $this->process->CellCssStyle = "white-space: nowrap;";

        // process_type
        $this->process_type->CellCssStyle = "white-space: nowrap;";

        // lot_no

        // barcode
        $this->_barcode->CellCssStyle = "white-space: nowrap;";

        // tmp_lot
        $this->tmp_lot->CellCssStyle = "white-space: nowrap;";

        // price

        // cart_amount

        // other_amount

        // amount
        $this->amount->CellCssStyle = "white-space: nowrap;";

        // tax_amount
        $this->tax_amount->CellCssStyle = "white-space: nowrap;";

        // total_amount

        // tax_percent
        $this->tax_percent->CellCssStyle = "white-space: nowrap;";

        // hsn_code
        $this->hsn_code->CellCssStyle = "white-space: nowrap;";

        // operator

        // datetime

        // company_id
        $this->company_id->CellCssStyle = "white-space: nowrap;";

        // godown

        // godown_po

        // issue_to

        // issue_to_unit

        // gp_no
        $this->gp_no->CellCssStyle = "white-space: nowrap;";

        // dated

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // po
        $this->po->CellCssStyle = "white-space: nowrap;";

        // print
        $this->_print->CellCssStyle = "white-space: nowrap;";

        // remarks

        // status

        // uploads

        // cart_ref
        $this->cart_ref->CellCssStyle = "white-space: nowrap;";

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->packets->CurrentValue)) {
                $this->packets->Total += $this->packets->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->total_amount->CurrentValue)) {
                $this->total_amount->Total += $this->total_amount->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            if ($this->rid->VirtualValue != "") {
                $this->rid->ViewValue = $this->rid->VirtualValue;
            } else {
                $this->rid->ViewValue = $this->rid->CurrentValue;
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            }

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // quantity_sub
            $this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
            $this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, $this->quantity_sub->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->CssClass = "fw-bold";

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_type
            $curVal = strval($this->process_type->CurrentValue);
            if ($curVal != "") {
                $this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
                if ($this->process_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process_type->Lookup->renderViewRow($rswrk[0]);
                        $this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
                    } else {
                        $this->process_type->ViewValue = $this->process_type->CurrentValue;
                    }
                }
            } else {
                $this->process_type->ViewValue = null;
            }

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());
            $this->price->CellCssStyle .= "text-align: right;";

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // godown_po
            $curVal = strval($this->godown_po->CurrentValue);
            if ($curVal != "") {
                $this->godown_po->ViewValue = $this->godown_po->lookupCacheOption($curVal);
                if ($this->godown_po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown_po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown_po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown_po->Lookup->renderViewRow($rswrk[0]);
                        $this->godown_po->ViewValue = $this->godown_po->displayValue($arwrk);
                    } else {
                        $this->godown_po->ViewValue = FormatNumber($this->godown_po->CurrentValue, $this->godown_po->formatPattern());
                    }
                }
            } else {
                $this->godown_po->ViewValue = null;
            }

            // issue_to
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
                    }
                }
            } else {
                $this->issue_to->ViewValue = null;
            }

            // issue_to_unit
            $curVal = strval($this->issue_to_unit->CurrentValue);
            if ($curVal != "") {
                $this->issue_to_unit->ViewValue = $this->issue_to_unit->lookupCacheOption($curVal);
                if ($this->issue_to_unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to_unit->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to_unit->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to_unit->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to_unit->ViewValue = $this->issue_to_unit->displayValue($arwrk);
                    } else {
                        $this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->CurrentValue, $this->issue_to_unit->formatPattern());
                    }
                }
            } else {
                $this->issue_to_unit->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // cart_ref
            $this->cart_ref->ViewValue = $this->cart_ref->CurrentValue;
            $this->cart_ref->ViewValue = FormatNumber($this->cart_ref->ViewValue, $this->cart_ref->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";
            if (!$this->isExport()) {
                $this->rid->ViewValue = $this->highlightValue($this->rid);
            }

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";
            if (!$this->isExport()) {
                $this->packets->ViewValue = $this->highlightValue($this->packets);
            }

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }
            $this->packing_type->TooltipValue = "";

            // quantity_sub
            $this->quantity_sub->HrefValue = "";
            $this->quantity_sub->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // process_type
            if (!EmptyValue($this->process_type->CurrentValue)) {
                $this->process_type->HrefValue = $this->process_type->getLinkPrefix() . $this->process_type->CurrentValue; // Add prefix/suffix
                $this->process_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
                }
            } else {
                $this->process_type->HrefValue = "";
            }
            $this->process_type->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->lot_no->ViewValue = $this->highlightValue($this->lot_no);
            }

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";
            $this->total_amount->TooltipValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // godown_po
            $this->godown_po->HrefValue = "";
            $this->godown_po->TooltipValue = "";

            // issue_to
            if (!EmptyValue($this->issue_to->CurrentValue)) {
                $this->issue_to->HrefValue = $this->issue_to->getLinkPrefix() . $this->issue_to->CurrentValue; // Add prefix/suffix
                $this->issue_to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
                }
            } else {
                $this->issue_to->HrefValue = "";
            }
            $this->issue_to->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";
            if (!$this->isExport()) {
                $this->dated->ViewValue = $this->highlightValue($this->dated);
            }

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_no->ViewValue = $this->highlightValue($this->jc_no);
            }

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }
            $this->status->TooltipValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "material_out_old_x" . $this->RowCount . "_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // cart_ref
            if (!EmptyValue($this->cart_ref->CurrentValue)) {
                $this->cart_ref->HrefValue = $this->cart_ref->getLinkPrefix() . $this->cart_ref->CurrentValue; // Add prefix/suffix
                $this->cart_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->cart_ref->HrefValue = FullUrl($this->cart_ref->HrefValue, "href");
                }
            } else {
                $this->cart_ref->HrefValue = "";
            }
            $this->cart_ref->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->AdvancedSearch->SearchValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->AdvancedSearch->SearchValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // quantity_sub
            $this->quantity_sub->setupEditAttributes();
            $this->quantity_sub->EditValue = $this->quantity_sub->AdvancedSearch->SearchValue;
            $this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->AdvancedSearch->SearchValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // process_type
            $this->process_type->setupEditAttributes();
            $this->process_type->PlaceHolder = RemoveHtml($this->process_type->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->AdvancedSearch->SearchValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->AdvancedSearch->SearchValue;
            $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());

            // godown
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // godown_po
            $this->godown_po->PlaceHolder = RemoveHtml($this->godown_po->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());
            $this->dated->setupEditAttributes();
            $this->dated->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue2, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            if (!$this->jc_no->Raw) {
                $this->jc_no->AdvancedSearch->SearchValue = HtmlDecode($this->jc_no->AdvancedSearch->SearchValue);
            }
            $this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!$this->uploads->Raw) {
                $this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
            }
            $this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
            $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

            // cart_ref
            $this->cart_ref->setupEditAttributes();
            $this->cart_ref->EditValue = $this->cart_ref->AdvancedSearch->SearchValue;
            $this->cart_ref->PlaceHolder = RemoveHtml($this->cart_ref->caption());
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->packets->Total = 0; // Initialize total
                    $this->quantity->Total = 0; // Initialize total
                    $this->total_amount->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->packets->CurrentValue = $this->packets->Total;
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());
            $this->packets->HrefValue = ""; // Clear href value
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->CssClass = "fw-bold";
            $this->quantity->HrefValue = ""; // Clear href value
            $this->total_amount->CurrentValue = $this->total_amount->Total;
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());
            $this->total_amount->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->rid_1->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->quantity_sub->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->lot_no->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->cart_amount->AdvancedSearch->load();
        $this->other_amount->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->tax_amount->AdvancedSearch->load();
        $this->total_amount->AdvancedSearch->load();
        $this->tax_percent->AdvancedSearch->load();
        $this->hsn_code->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->godown->AdvancedSearch->load();
        $this->godown_po->AdvancedSearch->load();
        $this->issue_to->AdvancedSearch->load();
        $this->issue_to_unit->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->cart_ref->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fmaterial_out_oldlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fmaterial_out_oldlist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fmaterial_out_oldsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"material_out_old\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"materialoutoldsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"materialoutoldsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fmaterial_out_oldsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    break;
                case "x_rid_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_quantity_avg_act":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to_unit":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
