<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for material_out_old
 */
class MaterialOutOld extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $rid_1;
    public $rid_name;
    public $packets;
    public $packing_type;
    public $quantity_avg_act;
    public $quantity_sub;
    public $quantity;
    public $process;
    public $process_type;
    public $lot_no;
    public $_barcode;
    public $tmp_lot;
    public $price;
    public $cart_amount;
    public $other_amount;
    public $amount;
    public $tax_amount;
    public $total_amount;
    public $tax_percent;
    public $hsn_code;
    public $operator;
    public $datetime;
    public $company_id;
    public $godown;
    public $godown_po;
    public $issue_to;
    public $issue_to_unit;
    public $gp_no;
    public $dated;
    public $jc_no;
    public $po;
    public $_print;
    public $remarks;
    public $status;
    public $uploads;
    public $cart_ref;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "material_out_old";
        $this->TableName = 'material_out_old';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "material_out_old";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->grp->addMethod("getDefault", fn() => (isset($_GET['GRP']))  ? $_GET['GRP'] :( (isset($_COOKIE['GRP']))  ? $_COOKIE['GRP'] : ''));
        $this->grp->addMethod("getLinkPrefix", fn() => "materialoutlist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp","x_packing_type"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->s_grp->addMethod("getDefault", fn() => (isset($_GET['SGRP']))  ? $_GET['SGRP'] : ((isset($_COOKIE['SGRP']))  ? $_COOKIE['SGRP'] : ''));
        $this->s_grp->addMethod("getLinkPrefix", fn() => "materialoutlist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->product->addMethod("getDefault", fn() => (isset($_GET['PR']))  ? $_GET['PR'] : ((isset($_COOKIE['PR']))  ? $_COOKIE['PR'] : ''));
        $this->product->addMethod("getLinkPrefix", fn() => "materialoutlist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Nullable = false; // NOT NULL field
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_view2', false, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_rid_1"], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__rid', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->addMethod("getDefault", fn() => (isset($_GET['RID']))  ? $_GET['RID'] : ((isset($_COOKIE['RID']))  ? $_COOKIE['RID'] : ''));
        $this->rid->addMethod("getLinkPrefix", fn() => "materialoutlist?x_rid=");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], ["packing_type"], ["x_packing_type"], true, '`product_code` ASC', '', "`product_code`");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['rid'] = &$this->rid;

        // rid_1
        $this->rid_1 = new DbField(
            $this, // Table
            'x_rid_1', // Variable name
            'rid_1', // Name
            '`rid_1`', // Expression
            '`rid_1`', // Basic search expression
            200, // Type
            30, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid_1->addMethod("getSelectFilter", fn() => (isset($_GET['RID'])) ? ("`rid` = ". $_GET['RID'] ." and `Balance` > 0") :  ("`Balance` > 0"));
        $this->rid_1->addMethod("getDefault", fn() => (isset($_GET['RID1']))  ? $_GET['RID1'] : ((isset($_COOKIE['RID1']))  ? $_COOKIE['RID1'] : ''));
        $this->rid_1->InputTextType = "text";
        $this->rid_1->Sortable = false; // Allow sort
        $this->rid_1->setSelectMultiple(false); // Select one
        $this->rid_1->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid_1->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid_1->Lookup = new Lookup($this->rid_1, 'stock_lcgp', false, 'id', ["packing_type_n","lot_no","Balance","product_code"], '', '', ["x_product","x_godown"], [], ["product","godown"], ["x_product","x_godown"], ["packing_type","rid","lot_no"], ["x_packing_type","x_rid","x_lot_no"], false, '`product_code` ASC', '', "CONCAT(COALESCE(`packing_type_n`, ''),'" . ValueSeparator(1, $this->rid_1) . "',COALESCE(`lot_no`,''),'" . ValueSeparator(2, $this->rid_1) . "',COALESCE(`Balance`,''),'" . ValueSeparator(3, $this->rid_1) . "',COALESCE(`product_code`,''))");
        $this->rid_1->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid_1'] = &$this->rid_1;

        // rid_name
        $this->rid_name = new DbField(
            $this, // Table
            'x_rid_name', // Variable name
            'rid_name', // Name
            '`rid_name`', // Expression
            '`rid_name`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid_name->InputTextType = "text";
        $this->rid_name->Sortable = false; // Allow sort
        $this->rid_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid_name'] = &$this->rid_name;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->addMethod("getDefault", fn() => (isset($_GET['PKT']))  ? $_GET['PKT'] : '');
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->Required = true; // Required field
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->packing_type->addMethod("getDefault", fn() => (isset($_GET['PKG']))  ? $_GET['PKG'] : ((isset($_COOKIE['PKG']))  ? $_COOKIE['PKG'] : 3));
        $this->packing_type->addMethod("getLinkPrefix", fn() => "materialoutlist?x_packing_type=");
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->Required = true; // Required field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', true, 'id', ["packing","code","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], true, '`packing` ASC', '', "CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`code`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // quantity_avg_act
        $this->quantity_avg_act = new DbField(
            $this, // Table
            'x_quantity_avg_act', // Variable name
            'quantity_avg_act', // Name
            '`quantity_avg_act`', // Expression
            '`quantity_avg_act`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity_avg_act`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->quantity_avg_act->addMethod("getEditCustomAttributes", fn() => 'Disabled');
        $this->quantity_avg_act->addMethod("getDefault", fn() => 0);
        $this->quantity_avg_act->InputTextType = "text";
        $this->quantity_avg_act->Raw = true;
        $this->quantity_avg_act->Lookup = new Lookup($this->quantity_avg_act, 'material_out_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->quantity_avg_act->OptionCount = 2;
        $this->quantity_avg_act->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->quantity_avg_act->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity_avg_act'] = &$this->quantity_avg_act;

        // quantity_sub
        $this->quantity_sub = new DbField(
            $this, // Table
            'x_quantity_sub', // Variable name
            'quantity_sub', // Name
            '`quantity_sub`', // Expression
            '`quantity_sub`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity_sub`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity_sub->InputTextType = "text";
        $this->quantity_sub->Raw = true;
        $this->quantity_sub->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity_sub->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity_sub'] = &$this->quantity_sub;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getDefault", fn() => (isset($_GET['QTY']))  ? $_GET['QTY'] : 0);
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->addMethod("getDefault", fn() => (isset($_GET['PRO']))  ? $_GET['PRO'] : '');
        $this->process->addMethod("getLinkPrefix", fn() => "materialoutlist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->Required = true; // Required field
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'process', true, 'id', ["id","name","",""], '', '', [], ["x_issue_to"], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->process) . "',COALESCE(`name`,''))");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // process_type
        $this->process_type = new DbField(
            $this, // Table
            'x_process_type', // Variable name
            'process_type', // Name
            '`process_type`', // Expression
            '`process_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_type->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->process_type->addMethod("getLinkPrefix", fn() => "materialoutlist?x_process_type=");
        $this->process_type->InputTextType = "text";
        $this->process_type->Raw = true;
        $this->process_type->setSelectMultiple(false); // Select one
        $this->process_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_type->Lookup = new Lookup($this->process_type, 'sub_process_type', true, 'id', ["name","","",""], '', '', [], ["x_issue_to_unit"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_type'] = &$this->process_type;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->addMethod("getDefault", fn() => (isset($_GET['LNO']))  ? $_GET['LNO'] : ((isset($_COOKIE['LNO']))  ? $_COOKIE['LNO'] : ''));
        $this->lot_no->InputTextType = "text";
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Raw = true;
        $this->_barcode->Sortable = false; // Allow sort
        $this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // tmp_lot
        $this->tmp_lot = new DbField(
            $this, // Table
            'x_tmp_lot', // Variable name
            'tmp_lot', // Name
            '`tmp_lot`', // Expression
            '`tmp_lot`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tmp_lot`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tmp_lot->InputTextType = "text";
        $this->tmp_lot->Raw = true;
        $this->tmp_lot->Required = true; // Required field
        $this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tmp_lot->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tmp_lot'] = &$this->tmp_lot;

        // price
        $this->price = new DbField(
            $this, // Table
            'x_price', // Variable name
            'price', // Name
            '`price`', // Expression
            '`price`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price->addMethod("getDefault", fn() => (isset($_GET['PRICE']))  ? $_GET['PRICE'] : '');
        $this->price->InputTextType = "text";
        $this->price->Raw = true;
        $this->price->FormatPattern = "0.00"; // Format pattern
        $this->price->DefaultNumberFormat = $this->price->FormatPattern;
        $this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price'] = &$this->price;

        // cart_amount
        $this->cart_amount = new DbField(
            $this, // Table
            'x_cart_amount', // Variable name
            'cart_amount', // Name
            '`cart_amount`', // Expression
            '`cart_amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_amount->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->cart_amount->addMethod("getDefault", fn() => 0);
        $this->cart_amount->InputTextType = "text";
        $this->cart_amount->Raw = true;
        $this->cart_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cart_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_amount'] = &$this->cart_amount;

        // other_amount
        $this->other_amount = new DbField(
            $this, // Table
            'x_other_amount', // Variable name
            'other_amount', // Name
            '`other_amount`', // Expression
            '`other_amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`other_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->other_amount->addMethod("getDefault", fn() => 0);
        $this->other_amount->InputTextType = "text";
        $this->other_amount->Raw = true;
        $this->other_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->other_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['other_amount'] = &$this->other_amount;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->FormatPattern = "0.00"; // Format pattern
        $this->amount->DefaultNumberFormat = $this->amount->FormatPattern;
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount'] = &$this->amount;

        // tax_amount
        $this->tax_amount = new DbField(
            $this, // Table
            'x_tax_amount', // Variable name
            'tax_amount', // Name
            '`tax_amount`', // Expression
            '`tax_amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tax_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tax_amount->InputTextType = "text";
        $this->tax_amount->Raw = true;
        $this->tax_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tax_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tax_amount'] = &$this->tax_amount;

        // total_amount
        $this->total_amount = new DbField(
            $this, // Table
            'x_total_amount', // Variable name
            'total_amount', // Name
            '`total_amount`', // Expression
            '`total_amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`total_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->total_amount->InputTextType = "text";
        $this->total_amount->Raw = true;
        $this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->total_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['total_amount'] = &$this->total_amount;

        // tax_percent
        $this->tax_percent = new DbField(
            $this, // Table
            'x_tax_percent', // Variable name
            'tax_percent', // Name
            '`tax_percent`', // Expression
            '`tax_percent`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tax_percent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tax_percent->InputTextType = "text";
        $this->tax_percent->Raw = true;
        $this->tax_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tax_percent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tax_percent'] = &$this->tax_percent;

        // hsn_code
        $this->hsn_code = new DbField(
            $this, // Table
            'x_hsn_code', // Variable name
            'hsn_code', // Name
            '`hsn_code`', // Expression
            '`hsn_code`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`hsn_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->hsn_code->InputTextType = "text";
        $this->hsn_code->Raw = true;
        $this->hsn_code->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->hsn_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['hsn_code'] = &$this->hsn_code;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->FormatPattern = "0.00"; // Format pattern
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Sortable = false; // Allow sort
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->godown->addMethod("getSelectFilter", fn() => (User_Site() == 0) ? "`status` = 1 and `type` = 2 and `id`  > 0" : "`status` = 1 and `type` = 2  and `id`  > 0  and FIND_IN_SET(`id`,". User_Site() .")");
        $this->godown->addMethod("getDefault", fn() => (isset($_GET['GODOWN']))  ? $_GET['GODOWN'] : ((isset($_COOKIE['GODOWN']))  ? $_COOKIE['GODOWN'] : ''));
        $this->godown->addMethod("getLinkPrefix", fn() => "materialoutlist?x_godown=");
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->Required = true; // Required field
        $this->godown->Lookup = new Lookup($this->godown, 'godown', false, 'id', ["code","name","",""], '', '', [], ["x_rid_1"], [], [], [], [], true, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->godown) . "',COALESCE(`name`,''))");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown'] = &$this->godown;

        // godown_po
        $this->godown_po = new DbField(
            $this, // Table
            'x_godown_po', // Variable name
            'godown_po', // Name
            '`godown_po`', // Expression
            '`godown_po`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown_po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->godown_po->addMethod("getSelectFilter", fn() => "`mo_type` = 103 and `category` = 999");
        $this->godown_po->InputTextType = "text";
        $this->godown_po->Raw = true;
        $this->godown_po->Lookup = new Lookup($this->godown_po, 'buyer_seller_view', false, 'id', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->godown_po) . "',COALESCE(`name`,''))");
        $this->godown_po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown_po->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown_po'] = &$this->godown_po;

        // issue_to
        $this->issue_to = new DbField(
            $this, // Table
            'x_issue_to', // Variable name
            'issue_to', // Name
            '`issue_to`', // Expression
            '`issue_to`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`issue_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->issue_to->addMethod("getSelectFilter", fn() => "`status`=1 and `id` > 0 and `category` != 1");
        $this->issue_to->addMethod("getDefault", fn() => (isset($_GET['BUY']))  ? $_GET['BUY'] : '');
        $this->issue_to->addMethod("getLinkPrefix", fn() => "materialoutlist?x_issue_to=");
        $this->issue_to->InputTextType = "text";
        $this->issue_to->Raw = true;
        $this->issue_to->setSelectMultiple(false); // Select one
        $this->issue_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->issue_to->Lookup = new Lookup($this->issue_to, 'buyer_seller_view', false, 'id', ["name","mobile","",""], '', '', ["x_process"], [], ["mo_type"], ["x_mo_type"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->issue_to) . "',COALESCE(`mobile`,''))");
        $this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->issue_to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issue_to'] = &$this->issue_to;

        // issue_to_unit
        $this->issue_to_unit = new DbField(
            $this, // Table
            'x_issue_to_unit', // Variable name
            'issue_to_unit', // Name
            '`issue_to_unit`', // Expression
            '`issue_to_unit`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`issue_to_unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->issue_to_unit->addMethod("getSelectFilter", fn() => "`status`=1 and `grp` != 3");
        $this->issue_to_unit->InputTextType = "text";
        $this->issue_to_unit->Raw = true;
        $this->issue_to_unit->setSelectMultiple(false); // Select one
        $this->issue_to_unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->issue_to_unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->issue_to_unit->Lookup = new Lookup($this->issue_to_unit, 'loom_info', true, 'id', ["item","","",""], '', '', ["x_process_type"], [], ["process"], ["x_process"], [], [], false, '`item` ASC', '', "`item`");
        $this->issue_to_unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->issue_to_unit->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issue_to_unit'] = &$this->issue_to_unit;

        // gp_no
        $this->gp_no = new DbField(
            $this, // Table
            'x_gp_no', // Variable name
            'gp_no', // Name
            '`gp_no`', // Expression
            '`gp_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gp_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gp_no->addMethod("getViewCustomAttributes", fn() => 'class="btn btn-default"');
        $this->gp_no->addMethod("getLinkPrefix", fn() => "gstchallan?ID=");
        $this->gp_no->InputTextType = "text";
        $this->gp_no->Raw = true;
        $this->gp_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gp_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['gp_no'] = &$this->gp_no;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->addMethod("getDefault", fn() => CurrentDateTime());
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->Required = true; // Required field
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dated'] = &$this->dated;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->addMethod("getDefault", fn() => (isset($_GET['JC']))  ? $_GET['JC'] : '0');
        $this->jc_no->InputTextType = "text";
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->Sortable = false; // Allow sort
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // print
        $this->_print = new DbField(
            $this, // Table
            'x__print', // Variable name
            'print', // Name
            '`print`', // Expression
            '`print`', // Basic search expression
            200, // Type
            225, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`print`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_print->addMethod("getViewCustomAttributes", fn() => 'class = "btn btn-default"');
        $this->_print->InputTextType = "text";
        $this->_print->Sortable = false; // Allow sort
        $this->_print->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['print'] = &$this->_print;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->addMethod("getLinkPrefix", fn() => "materialoutlist?x_status=");
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'material_out_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 3;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->InputTextType = "text";
        $this->uploads->ImageResize = true;
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // cart_ref
        $this->cart_ref = new DbField(
            $this, // Table
            'x_cart_ref', // Variable name
            'cart_ref', // Name
            '`cart_ref`', // Expression
            '`cart_ref`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_ref->addMethod("getLinkPrefix", fn() => "materialoutlist?x_cart_ref=");
        $this->cart_ref->InputTextType = "text";
        $this->cart_ref->Raw = true;
        $this->cart_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cart_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_ref'] = &$this->cart_ref;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            $this->setSessionOrderByList($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "material_out_old";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = material_out_old.rid LIMIT 1) AS EV__rid FROM material_out_old)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Site() == 0) ? "" : "`godown` IN (".User_Site().")";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->rid->AdvancedSearch->SearchValue != "" ||
            $this->rid->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->rid->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->rid_1->DbValue = $row['rid_1'];
        $this->rid_name->DbValue = $row['rid_name'];
        $this->packets->DbValue = $row['packets'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->quantity_avg_act->DbValue = $row['quantity_avg_act'];
        $this->quantity_sub->DbValue = $row['quantity_sub'];
        $this->quantity->DbValue = $row['quantity'];
        $this->process->DbValue = $row['process'];
        $this->process_type->DbValue = $row['process_type'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->tmp_lot->DbValue = $row['tmp_lot'];
        $this->price->DbValue = $row['price'];
        $this->cart_amount->DbValue = $row['cart_amount'];
        $this->other_amount->DbValue = $row['other_amount'];
        $this->amount->DbValue = $row['amount'];
        $this->tax_amount->DbValue = $row['tax_amount'];
        $this->total_amount->DbValue = $row['total_amount'];
        $this->tax_percent->DbValue = $row['tax_percent'];
        $this->hsn_code->DbValue = $row['hsn_code'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->company_id->DbValue = $row['company_id'];
        $this->godown->DbValue = $row['godown'];
        $this->godown_po->DbValue = $row['godown_po'];
        $this->issue_to->DbValue = $row['issue_to'];
        $this->issue_to_unit->DbValue = $row['issue_to_unit'];
        $this->gp_no->DbValue = $row['gp_no'];
        $this->dated->DbValue = $row['dated'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->po->DbValue = $row['po'];
        $this->_print->DbValue = $row['print'];
        $this->remarks->DbValue = $row['remarks'];
        $this->status->DbValue = $row['status'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->cart_ref->DbValue = $row['cart_ref'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("materialoutoldlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "materialoutoldview" => $Language->phrase("View"),
            "materialoutoldedit" => $Language->phrase("Edit"),
            "materialoutoldadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "materialoutoldlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MaterialOutOldView",
            Config("API_ADD_ACTION") => "MaterialOutOldAdd",
            Config("API_EDIT_ACTION") => "MaterialOutOldEdit",
            Config("API_DELETE_ACTION") => "MaterialOutOldDelete",
            Config("API_LIST_ACTION") => "MaterialOutOldList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "materialoutoldlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("materialoutoldview", $parm);
        } else {
            $url = $this->keyUrl("materialoutoldview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "materialoutoldadd?" . $parm;
        } else {
            $url = "materialoutoldadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("materialoutoldedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("materialoutoldlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("materialoutoldadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("materialoutoldlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("materialoutolddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->rid_name->setDbValue($row['rid_name']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
        $this->quantity_sub->setDbValue($row['quantity_sub']);
        $this->quantity->setDbValue($row['quantity']);
        $this->process->setDbValue($row['process']);
        $this->process_type->setDbValue($row['process_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->tmp_lot->setDbValue($row['tmp_lot']);
        $this->price->setDbValue($row['price']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->other_amount->setDbValue($row['other_amount']);
        $this->amount->setDbValue($row['amount']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->tax_percent->setDbValue($row['tax_percent']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->company_id->setDbValue($row['company_id']);
        $this->godown->setDbValue($row['godown']);
        $this->godown_po->setDbValue($row['godown_po']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->issue_to_unit->setDbValue($row['issue_to_unit']);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->dated->setDbValue($row['dated']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->po->setDbValue($row['po']);
        $this->_print->setDbValue($row['print']);
        $this->remarks->setDbValue($row['remarks']);
        $this->status->setDbValue($row['status']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->cart_ref->setDbValue($row['cart_ref']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MaterialOutOldList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // grp

        // s_grp

        // product

        // rid

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // rid_name
        $this->rid_name->CellCssStyle = "white-space: nowrap;";

        // packets

        // packing_type

        // quantity_avg_act
        $this->quantity_avg_act->CellCssStyle = "white-space: nowrap;";

        // quantity_sub

        // quantity

        // process
        $this->process->CellCssStyle = "white-space: nowrap;";

        // process_type
        $this->process_type->CellCssStyle = "white-space: nowrap;";

        // lot_no

        // barcode
        $this->_barcode->CellCssStyle = "white-space: nowrap;";

        // tmp_lot
        $this->tmp_lot->CellCssStyle = "white-space: nowrap;";

        // price

        // cart_amount

        // other_amount

        // amount
        $this->amount->CellCssStyle = "white-space: nowrap;";

        // tax_amount
        $this->tax_amount->CellCssStyle = "white-space: nowrap;";

        // total_amount

        // tax_percent
        $this->tax_percent->CellCssStyle = "white-space: nowrap;";

        // hsn_code
        $this->hsn_code->CellCssStyle = "white-space: nowrap;";

        // operator

        // datetime

        // company_id
        $this->company_id->CellCssStyle = "white-space: nowrap;";

        // godown

        // godown_po

        // issue_to

        // issue_to_unit

        // gp_no
        $this->gp_no->CellCssStyle = "white-space: nowrap;";

        // dated

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // po
        $this->po->CellCssStyle = "white-space: nowrap;";

        // print
        $this->_print->CellCssStyle = "white-space: nowrap;";

        // remarks

        // status

        // uploads

        // cart_ref
        $this->cart_ref->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        if ($this->rid->VirtualValue != "") {
            $this->rid->ViewValue = $this->rid->VirtualValue;
        } else {
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }
        }

        // rid_1
        $curVal = strval($this->rid_1->CurrentValue);
        if ($curVal != "") {
            $this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
            if ($this->rid_1->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_1->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
                } else {
                    $this->rid_1->ViewValue = $this->rid_1->CurrentValue;
                }
            }
        } else {
            $this->rid_1->ViewValue = null;
        }

        // rid_name
        $this->rid_name->ViewValue = $this->rid_name->CurrentValue;

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // quantity_avg_act
        if (strval($this->quantity_avg_act->CurrentValue) != "") {
            $this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
        } else {
            $this->quantity_avg_act->ViewValue = null;
        }

        // quantity_sub
        $this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
        $this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, $this->quantity_sub->formatPattern());

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
        $this->quantity->CssClass = "fw-bold";

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // process_type
        $curVal = strval($this->process_type->CurrentValue);
        if ($curVal != "") {
            $this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
            if ($this->process_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process_type->Lookup->renderViewRow($rswrk[0]);
                    $this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
                } else {
                    $this->process_type->ViewValue = $this->process_type->CurrentValue;
                }
            }
        } else {
            $this->process_type->ViewValue = null;
        }

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
        $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

        // tmp_lot
        $this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
        $this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, $this->tmp_lot->formatPattern());

        // price
        $this->price->ViewValue = $this->price->CurrentValue;
        $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());
        $this->price->CellCssStyle .= "text-align: right;";

        // cart_amount
        $this->cart_amount->ViewValue = $this->cart_amount->CurrentValue;
        $this->cart_amount->ViewValue = FormatNumber($this->cart_amount->ViewValue, $this->cart_amount->formatPattern());

        // other_amount
        $this->other_amount->ViewValue = $this->other_amount->CurrentValue;
        $this->other_amount->ViewValue = FormatNumber($this->other_amount->ViewValue, $this->other_amount->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());
        $this->amount->CssClass = "fw-bold";
        $this->amount->CellCssStyle .= "text-align: right;";

        // tax_amount
        $this->tax_amount->ViewValue = $this->tax_amount->CurrentValue;
        $this->tax_amount->ViewValue = FormatNumber($this->tax_amount->ViewValue, $this->tax_amount->formatPattern());

        // total_amount
        $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
        $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

        // tax_percent
        $this->tax_percent->ViewValue = $this->tax_percent->CurrentValue;
        $this->tax_percent->ViewValue = FormatNumber($this->tax_percent->ViewValue, $this->tax_percent->formatPattern());

        // hsn_code
        $this->hsn_code->ViewValue = $this->hsn_code->CurrentValue;
        $this->hsn_code->ViewValue = FormatNumber($this->hsn_code->ViewValue, $this->hsn_code->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, $this->company_id->formatPattern());

        // godown
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = $this->godown->CurrentValue;
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // godown_po
        $curVal = strval($this->godown_po->CurrentValue);
        if ($curVal != "") {
            $this->godown_po->ViewValue = $this->godown_po->lookupCacheOption($curVal);
            if ($this->godown_po->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->godown_po->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown_po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown_po->Lookup->renderViewRow($rswrk[0]);
                    $this->godown_po->ViewValue = $this->godown_po->displayValue($arwrk);
                } else {
                    $this->godown_po->ViewValue = FormatNumber($this->godown_po->CurrentValue, $this->godown_po->formatPattern());
                }
            }
        } else {
            $this->godown_po->ViewValue = null;
        }

        // issue_to
        $curVal = strval($this->issue_to->CurrentValue);
        if ($curVal != "") {
            $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
            if ($this->issue_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                } else {
                    $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
                }
            }
        } else {
            $this->issue_to->ViewValue = null;
        }

        // issue_to_unit
        $curVal = strval($this->issue_to_unit->CurrentValue);
        if ($curVal != "") {
            $this->issue_to_unit->ViewValue = $this->issue_to_unit->lookupCacheOption($curVal);
            if ($this->issue_to_unit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->issue_to_unit->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_unit->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_to_unit->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_to_unit->ViewValue = $this->issue_to_unit->displayValue($arwrk);
                } else {
                    $this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->CurrentValue, $this->issue_to_unit->formatPattern());
                }
            }
        } else {
            $this->issue_to_unit->ViewValue = null;
        }

        // gp_no
        $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
        $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());
        $this->gp_no->ViewCustomAttributes = $this->gp_no->getViewCustomAttributes(); // PHP

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;

        // po
        $this->po->ViewValue = $this->po->CurrentValue;

        // print
        $this->_print->ViewValue = $this->_print->CurrentValue;
        $this->_print->CssClass = "fw-bold";
        $this->_print->ViewCustomAttributes = $this->_print->getViewCustomAttributes(); // PHP

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // uploads
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }

        // cart_ref
        $this->cart_ref->ViewValue = $this->cart_ref->CurrentValue;
        $this->cart_ref->ViewValue = FormatNumber($this->cart_ref->ViewValue, $this->cart_ref->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        if (!EmptyValue($this->grp->CurrentValue)) {
            $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
            $this->grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
            }
        } else {
            $this->grp->HrefValue = "";
        }
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // rid
        if (!EmptyValue($this->rid->CurrentValue)) {
            $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
            $this->rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
            }
        } else {
            $this->rid->HrefValue = "";
        }
        $this->rid->TooltipValue = "";

        // rid_1
        $this->rid_1->HrefValue = "";
        $this->rid_1->TooltipValue = "";

        // rid_name
        $this->rid_name->HrefValue = "";
        $this->rid_name->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // packing_type
        if (!EmptyValue($this->packing_type->CurrentValue)) {
            $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
            $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
            }
        } else {
            $this->packing_type->HrefValue = "";
        }
        $this->packing_type->TooltipValue = "";

        // quantity_avg_act
        $this->quantity_avg_act->HrefValue = "";
        $this->quantity_avg_act->TooltipValue = "";

        // quantity_sub
        $this->quantity_sub->HrefValue = "";
        $this->quantity_sub->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // process_type
        if (!EmptyValue($this->process_type->CurrentValue)) {
            $this->process_type->HrefValue = $this->process_type->getLinkPrefix() . $this->process_type->CurrentValue; // Add prefix/suffix
            $this->process_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
            }
        } else {
            $this->process_type->HrefValue = "";
        }
        $this->process_type->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // tmp_lot
        $this->tmp_lot->HrefValue = "";
        $this->tmp_lot->TooltipValue = "";

        // price
        $this->price->HrefValue = "";
        $this->price->TooltipValue = "";

        // cart_amount
        $this->cart_amount->HrefValue = "";
        $this->cart_amount->TooltipValue = "";

        // other_amount
        $this->other_amount->HrefValue = "";
        $this->other_amount->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // tax_amount
        $this->tax_amount->HrefValue = "";
        $this->tax_amount->TooltipValue = "";

        // total_amount
        $this->total_amount->HrefValue = "";
        $this->total_amount->TooltipValue = "";

        // tax_percent
        $this->tax_percent->HrefValue = "";
        $this->tax_percent->TooltipValue = "";

        // hsn_code
        $this->hsn_code->HrefValue = "";
        $this->hsn_code->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // godown
        if (!EmptyValue($this->godown->CurrentValue)) {
            $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
            $this->godown->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
            }
        } else {
            $this->godown->HrefValue = "";
        }
        $this->godown->TooltipValue = "";

        // godown_po
        $this->godown_po->HrefValue = "";
        $this->godown_po->TooltipValue = "";

        // issue_to
        if (!EmptyValue($this->issue_to->CurrentValue)) {
            $this->issue_to->HrefValue = $this->issue_to->getLinkPrefix() . $this->issue_to->CurrentValue; // Add prefix/suffix
            $this->issue_to->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
            }
        } else {
            $this->issue_to->HrefValue = "";
        }
        $this->issue_to->TooltipValue = "";

        // issue_to_unit
        $this->issue_to_unit->HrefValue = "";
        $this->issue_to_unit->TooltipValue = "";

        // gp_no
        if (!EmptyValue($this->id->CurrentValue)) {
            $this->gp_no->HrefValue = $this->gp_no->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
            $this->gp_no->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->gp_no->HrefValue = FullUrl($this->gp_no->HrefValue, "href");
            }
        } else {
            $this->gp_no->HrefValue = "";
        }
        $this->gp_no->TooltipValue = "";

        // dated
        $this->dated->HrefValue = "";
        $this->dated->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // print
        $this->_print->HrefValue = "";
        $this->_print->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // status
        if (!EmptyValue($this->status->CurrentValue)) {
            $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
            $this->status->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
            }
        } else {
            $this->status->HrefValue = "";
        }
        $this->status->TooltipValue = "";

        // uploads
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = "%u"; // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "material_out_old_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // cart_ref
        if (!EmptyValue($this->cart_ref->CurrentValue)) {
            $this->cart_ref->HrefValue = $this->cart_ref->getLinkPrefix() . $this->cart_ref->CurrentValue; // Add prefix/suffix
            $this->cart_ref->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->cart_ref->HrefValue = FullUrl($this->cart_ref->HrefValue, "href");
            }
        } else {
            $this->cart_ref->HrefValue = "";
        }
        $this->cart_ref->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // grp
        $this->grp->setupEditAttributes();
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->EditValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->EditValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->EditValue = null;
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->EditValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->EditValue = null;
        }

        // product
        $this->product->setupEditAttributes();
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->EditValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->EditValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->EditValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->EditValue = null;
        }

        // rid
        $this->rid->setupEditAttributes();
        if ($this->rid->VirtualValue != "") {
            $this->rid->EditValue = $this->rid->VirtualValue;
        } else {
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
        }

        // rid_1
        $this->rid_1->setupEditAttributes();
        $curVal = strval($this->rid_1->CurrentValue);
        if ($curVal != "") {
            $this->rid_1->EditValue = $this->rid_1->lookupCacheOption($curVal);
            if ($this->rid_1->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_1->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_1->EditValue = $this->rid_1->displayValue($arwrk);
                } else {
                    $this->rid_1->EditValue = $this->rid_1->CurrentValue;
                }
            }
        } else {
            $this->rid_1->EditValue = null;
        }

        // rid_name
        $this->rid_name->setupEditAttributes();
        if (!$this->rid_name->Raw) {
            $this->rid_name->CurrentValue = HtmlDecode($this->rid_name->CurrentValue);
        }
        $this->rid_name->EditValue = $this->rid_name->CurrentValue;
        $this->rid_name->PlaceHolder = RemoveHtml($this->rid_name->caption());

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->EditValue = FormatNumber($this->packets->EditValue, $this->packets->formatPattern());

        // packing_type
        $this->packing_type->setupEditAttributes();
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->EditValue = $this->packing_type->CurrentValue;
                }
            }
        } else {
            $this->packing_type->EditValue = null;
        }

        // quantity_avg_act
        $this->quantity_avg_act->setupEditAttributes();
        $this->quantity_avg_act->EditCustomAttributes = $this->quantity_avg_act->getEditCustomAttributes(); // PHP
        if (strval($this->quantity_avg_act->CurrentValue) != "") {
            $this->quantity_avg_act->EditValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
        } else {
            $this->quantity_avg_act->EditValue = null;
        }

        // quantity_sub
        $this->quantity_sub->setupEditAttributes();
        $this->quantity_sub->EditValue = $this->quantity_sub->CurrentValue;
        $this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());
        if (strval($this->quantity_sub->EditValue) != "" && is_numeric($this->quantity_sub->EditValue)) {
            $this->quantity_sub->EditValue = FormatNumber($this->quantity_sub->EditValue, null);
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());
        $this->quantity->CssClass = "fw-bold";

        // process
        $this->process->setupEditAttributes();
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->EditValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->EditValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->EditValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->EditValue = null;
        }

        // process_type
        $this->process_type->setupEditAttributes();
        $curVal = strval($this->process_type->CurrentValue);
        if ($curVal != "") {
            $this->process_type->EditValue = $this->process_type->lookupCacheOption($curVal);
            if ($this->process_type->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process_type->Lookup->renderViewRow($rswrk[0]);
                    $this->process_type->EditValue = $this->process_type->displayValue($arwrk);
                } else {
                    $this->process_type->EditValue = $this->process_type->CurrentValue;
                }
            }
        } else {
            $this->process_type->EditValue = null;
        }

        // lot_no
        $this->lot_no->setupEditAttributes();
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
        if (strval($this->_barcode->EditValue) != "" && is_numeric($this->_barcode->EditValue)) {
            $this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, null);
        }

        // tmp_lot
        $this->tmp_lot->setupEditAttributes();
        $this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
        $this->tmp_lot->EditValue = FormatNumber($this->tmp_lot->EditValue, $this->tmp_lot->formatPattern());

        // price
        $this->price->setupEditAttributes();
        $this->price->EditValue = $this->price->CurrentValue;
        $this->price->EditValue = FormatNumber($this->price->EditValue, $this->price->formatPattern());
        $this->price->CellCssStyle .= "text-align: right;";

        // cart_amount
        $this->cart_amount->setupEditAttributes();
        $this->cart_amount->EditCustomAttributes = $this->cart_amount->getEditCustomAttributes(); // PHP
        $this->cart_amount->EditValue = $this->cart_amount->CurrentValue;
        $this->cart_amount->EditValue = FormatNumber($this->cart_amount->EditValue, $this->cart_amount->formatPattern());

        // other_amount
        $this->other_amount->setupEditAttributes();
        $this->other_amount->EditValue = $this->other_amount->CurrentValue;
        $this->other_amount->PlaceHolder = RemoveHtml($this->other_amount->caption());
        if (strval($this->other_amount->EditValue) != "" && is_numeric($this->other_amount->EditValue)) {
            $this->other_amount->EditValue = FormatNumber($this->other_amount->EditValue, null);
        }

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->EditValue = FormatNumber($this->amount->EditValue, $this->amount->formatPattern());
        $this->amount->CssClass = "fw-bold";
        $this->amount->CellCssStyle .= "text-align: right;";

        // tax_amount
        $this->tax_amount->setupEditAttributes();
        $this->tax_amount->EditValue = $this->tax_amount->CurrentValue;
        $this->tax_amount->EditValue = FormatNumber($this->tax_amount->EditValue, $this->tax_amount->formatPattern());

        // total_amount
        $this->total_amount->setupEditAttributes();
        $this->total_amount->EditValue = $this->total_amount->CurrentValue;
        $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, $this->total_amount->formatPattern());

        // tax_percent
        $this->tax_percent->setupEditAttributes();
        $this->tax_percent->EditValue = $this->tax_percent->CurrentValue;
        $this->tax_percent->EditValue = FormatNumber($this->tax_percent->EditValue, $this->tax_percent->formatPattern());

        // hsn_code
        $this->hsn_code->setupEditAttributes();
        $this->hsn_code->EditValue = $this->hsn_code->CurrentValue;
        $this->hsn_code->EditValue = FormatNumber($this->hsn_code->EditValue, $this->hsn_code->formatPattern());

        // operator

        // datetime

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        if (strval($this->company_id->EditValue) != "" && is_numeric($this->company_id->EditValue)) {
            $this->company_id->EditValue = FormatNumber($this->company_id->EditValue, null);
        }

        // godown
        $this->godown->setupEditAttributes();
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->EditValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->EditValue = $this->godown->CurrentValue;
                }
            }
        } else {
            $this->godown->EditValue = null;
        }

        // godown_po
        $this->godown_po->PlaceHolder = RemoveHtml($this->godown_po->caption());

        // issue_to
        $this->issue_to->setupEditAttributes();
        $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

        // issue_to_unit
        $this->issue_to_unit->setupEditAttributes();
        $this->issue_to_unit->PlaceHolder = RemoveHtml($this->issue_to_unit->caption());

        // gp_no
        $this->gp_no->setupEditAttributes();
        $this->gp_no->EditValue = $this->gp_no->CurrentValue;
        $this->gp_no->EditValue = FormatNumber($this->gp_no->EditValue, $this->gp_no->formatPattern());
        $this->gp_no->ViewCustomAttributes = $this->gp_no->getViewCustomAttributes(); // PHP

        // dated
        $this->dated->setupEditAttributes();
        $this->dated->EditValue = $this->dated->CurrentValue;
        $this->dated->EditValue = FormatDateTime($this->dated->EditValue, $this->dated->formatPattern());

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());
        if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
            $this->po->EditValue = $this->po->EditValue;
        }

        // print
        $this->_print->setupEditAttributes();
        if (!$this->_print->Raw) {
            $this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
        }
        $this->_print->EditValue = $this->_print->CurrentValue;
        $this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // status
        $this->status->setupEditAttributes();
        if (strval($this->status->CurrentValue) != "") {
            $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->EditValue = null;
        }

        // uploads
        $this->uploads->setupEditAttributes();
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // cart_ref
        $this->cart_ref->setupEditAttributes();
        $this->cart_ref->EditValue = $this->cart_ref->CurrentValue;
        $this->cart_ref->PlaceHolder = RemoveHtml($this->cart_ref->caption());
        if (strval($this->cart_ref->EditValue) != "" && is_numeric($this->cart_ref->EditValue)) {
            $this->cart_ref->EditValue = FormatNumber($this->cart_ref->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->packets->CurrentValue)) {
                $this->packets->Total += $this->packets->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->total_amount->CurrentValue)) {
                $this->total_amount->Total += $this->total_amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->packets->CurrentValue = $this->packets->Total;
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());
            $this->packets->HrefValue = ""; // Clear href value
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->CssClass = "fw-bold";
            $this->quantity->HrefValue = ""; // Clear href value
            $this->total_amount->CurrentValue = $this->total_amount->Total;
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());
            $this->total_amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid_1);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->quantity_sub);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->cart_amount);
                    $doc->exportCaption($this->other_amount);
                    $doc->exportCaption($this->tax_percent);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->godown_po);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->issue_to_unit);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->cart_ref);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->quantity_sub);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->process_type);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->godown_po);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->issue_to_unit);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->uploads);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid_1);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->quantity_sub);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->process);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->price);
                        $doc->exportField($this->cart_amount);
                        $doc->exportField($this->other_amount);
                        $doc->exportField($this->tax_percent);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->godown_po);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->issue_to_unit);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->status);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->cart_ref);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->quantity_sub);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->process);
                        $doc->exportField($this->process_type);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->price);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->godown_po);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->issue_to_unit);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->status);
                        $doc->exportField($this->uploads);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->grp, '');
                $doc->exportAggregate($this->s_grp, '');
                $doc->exportAggregate($this->product, '');
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->packets, 'TOTAL');
                $doc->exportAggregate($this->packing_type, '');
                $doc->exportAggregate($this->quantity_sub, '');
                $doc->exportAggregate($this->quantity, 'TOTAL');
                $doc->exportAggregate($this->process, '');
                $doc->exportAggregate($this->process_type, '');
                $doc->exportAggregate($this->lot_no, '');
                $doc->exportAggregate($this->price, '');
                $doc->exportAggregate($this->godown, '');
                $doc->exportAggregate($this->godown_po, '');
                $doc->exportAggregate($this->issue_to, '');
                $doc->exportAggregate($this->issue_to_unit, '');
                $doc->exportAggregate($this->dated, '');
                $doc->exportAggregate($this->jc_no, '');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->uploads, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
