<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialOutBcAdd extends MaterialOutBc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialOutBcAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialoutbcadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->process->setVisibility();
        $this->issue_to->setVisibility();
        $this->godown->setVisibility();
        $this->dated->setVisibility();
        $this->remarks->setVisibility();
        $this->_barcode->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_out_bc';
        $this->TableName = 'material_out_bc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_out_bc)
        if (!isset($GLOBALS["material_out_bc"]) || $GLOBALS["material_out_bc"]::class == PROJECT_NAMESPACE . "material_out_bc") {
            $GLOBALS["material_out_bc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out_bc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "materialoutbcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else { // Not post back
            $this->CopyRecord = false;
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("materialoutbclist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "materialoutbclist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "materialoutbcview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "materialoutbclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "materialoutbclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->process->DefaultValue = $this->process->getDefault(); // PHP
        $this->process->OldValue = $this->process->DefaultValue;
        $this->issue_to->DefaultValue = $this->issue_to->getDefault(); // PHP
        $this->issue_to->OldValue = $this->issue_to->DefaultValue;
        $this->godown->DefaultValue = $this->godown->getDefault(); // PHP
        $this->godown->OldValue = $this->godown->DefaultValue;
        $this->dated->DefaultValue = $this->dated->getDefault(); // PHP
        $this->dated->OldValue = $this->dated->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val);
            }
        }

        // Check field name 'issue_to' first before field var 'x_issue_to'
        $val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
        if (!$this->issue_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to->Visible = false; // Disable update for API request
            } else {
                $this->issue_to->setFormValue($val);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->issue_to->CurrentValue = $this->issue_to->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->process->setDbValue($row['process']);
        $this->issue_to->setDbValue($row['issue_to']);
        if (array_key_exists('EV__issue_to', $row)) {
            $this->issue_to->VirtualValue = $row['EV__issue_to']; // Set up virtual field value
        } else {
            $this->issue_to->VirtualValue = ""; // Clear value
        }
        $this->godown->setDbValue($row['godown']);
        $this->dated->setDbValue($row['dated']);
        $this->remarks->setDbValue($row['remarks']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['process'] = $this->process->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // process
        $this->process->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // issue_to
            if ($this->issue_to->VirtualValue != "") {
                $this->issue_to->ViewValue = $this->issue_to->VirtualValue;
            } else {
                $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
                $curVal = strval($this->issue_to->CurrentValue);
                if ($curVal != "") {
                    $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                    if ($this->issue_to->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                            $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                        } else {
                            $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
                        }
                    }
                } else {
                    $this->issue_to->ViewValue = null;
                }
            }

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->godown->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->godown->Lookup->renderViewRow($row);
                            $this->godown->ViewValue->add($this->godown->displayValue($arwrk));
                        }
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // issue_to
            if (!EmptyValue($this->issue_to->CurrentValue)) {
                $this->issue_to->HrefValue = $this->issue_to->getLinkPrefix() . $this->issue_to->CurrentValue; // Add prefix/suffix
                $this->issue_to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
                }
            } else {
                $this->issue_to->HrefValue = "";
            }
            $this->issue_to->TooltipValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->CurrentValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $this->issue_to->EditValue = $this->issue_to->CurrentValue;
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->EditValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->EditValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->EditValue = HtmlEncode($this->issue_to->CurrentValue);
                    }
                }
            } else {
                $this->issue_to->EditValue = null;
            }
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // godown
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditCustomAttributes = $this->_barcode->getEditCustomAttributes(); // PHP
            $this->_barcode->EditValue = $this->_barcode->CurrentValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            if (strval($this->_barcode->EditValue) != "" && is_numeric($this->_barcode->EditValue)) {
                $this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, null);
            }

            // operator

            // datetime

            // Add refer script

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // issue_to
            if (!EmptyValue($this->issue_to->CurrentValue)) {
                $this->issue_to->HrefValue = $this->issue_to->getLinkPrefix() . $this->issue_to->CurrentValue; // Add prefix/suffix
                $this->issue_to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
                }
            } else {
                $this->issue_to->HrefValue = "";
            }

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // dated
            $this->dated->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->process->Visible && $this->process->Required) {
                if (!$this->process->IsDetailKey && EmptyValue($this->process->FormValue)) {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->issue_to->Visible && $this->issue_to->Required) {
                if (!$this->issue_to->IsDetailKey && EmptyValue($this->issue_to->FormValue)) {
                    $this->issue_to->addErrorMessage(str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
                }
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if ($this->godown->FormValue == "") {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->_barcode->FormValue)) {
                $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, false);

        // issue_to
        $this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // barcode
        $this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['process'])) { // process
            $this->process->setFormValue($row['process']);
        }
        if (isset($row['issue_to'])) { // issue_to
            $this->issue_to->setFormValue($row['issue_to']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['barcode'])) { // barcode
            $this->_barcode->setFormValue($row['barcode']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialoutbclist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    	$CUID = CurrentUserID();
    	$row=ExecuteRow("SELECT `process`, `issue_to`, `godown` FROM `material_out` where `operator` = $CUID ORDER BY `material_out`.`id` DESC");
    	setcookie("Process", $row['process']);
    	setcookie("BUY", $row['issue_to']);
    	setcookie("GODOWN", $row['godown']);
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
