<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialOutAdd extends MaterialOut
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialOutAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialoutadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->process->setVisibility();
        $this->process_type->setVisibility();
        $this->issue_to_unit->setVisibility();
        $this->issue_to->setVisibility();
        $this->godown->setVisibility();
        $this->godown_po->setVisibility();
        $this->jc_no->setVisibility();
        $this->gp_no->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid_1->setVisibility();
        $this->packing_type->setVisibility();
        $this->rid_2->setVisibility();
        $this->rid_3->setVisibility();
        $this->rid_po->setVisibility();
        $this->rid->setVisibility();
        $this->lot_no->setVisibility();
        $this->avg_quantity->setVisibility();
        $this->quantity_avg_act->Visible = false;
        $this->max_qty->setVisibility();
        $this->quantity_sub->setVisibility();
        $this->quantity->setVisibility();
        $this->packets->setVisibility();
        $this->price->setVisibility();
        $this->cart_amount->setVisibility();
        $this->other_amount->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->dated->setVisibility();
        $this->remarks->setVisibility();
        $this->status->Visible = false;
        $this->tmp_lot->Visible = false;
        $this->hsn_code->Visible = false;
        $this->amount->Visible = false;
        $this->tax_amount->Visible = false;
        $this->tax_percent->Visible = false;
        $this->total_amount->Visible = false;
        $this->cart_ref->Visible = false;
        $this->po->Visible = false;
        $this->_print->Visible = false;
        $this->_barcode->Visible = false;
        $this->url->Visible = false;
        $this->uploads->setVisibility();
        $this->company_id->Visible = false;
        $this->rid_name->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_out';
        $this->TableName = 'material_out';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_out)
        if (!isset($GLOBALS["material_out"]) || $GLOBALS["material_out"]::class == PROJECT_NAMESPACE . "material_out") {
            $GLOBALS["material_out"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_out');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "materialoutview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_type);
        $this->setupLookupOptions($this->issue_to_unit);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->godown_po);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid_1);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->rid_2);
        $this->setupLookupOptions($this->rid_3);
        $this->setupLookupOptions($this->rid_po);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->quantity_avg_act);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("materialoutlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "materialoutlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "materialoutview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "materialoutlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "materialoutlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->process->DefaultValue = $this->process->getDefault(); // PHP
        $this->process->OldValue = $this->process->DefaultValue;
        $this->issue_to->DefaultValue = $this->issue_to->getDefault(); // PHP
        $this->issue_to->OldValue = $this->issue_to->DefaultValue;
        $this->godown->DefaultValue = $this->godown->getDefault(); // PHP
        $this->godown->OldValue = $this->godown->DefaultValue;
        $this->jc_no->DefaultValue = $this->jc_no->getDefault(); // PHP
        $this->jc_no->OldValue = $this->jc_no->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->rid_1->DefaultValue = $this->rid_1->getDefault(); // PHP
        $this->rid_1->OldValue = $this->rid_1->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->rid_3->DefaultValue = $this->rid_3->getDefault(); // PHP
        $this->rid_3->OldValue = $this->rid_3->DefaultValue;
        $this->rid->DefaultValue = $this->rid->getDefault(); // PHP
        $this->rid->OldValue = $this->rid->DefaultValue;
        $this->lot_no->DefaultValue = $this->lot_no->getDefault(); // PHP
        $this->lot_no->OldValue = $this->lot_no->DefaultValue;
        $this->quantity_avg_act->DefaultValue = $this->quantity_avg_act->getDefault(); // PHP
        $this->quantity_avg_act->OldValue = $this->quantity_avg_act->DefaultValue;
        $this->quantity->DefaultValue = $this->quantity->getDefault(); // PHP
        $this->quantity->OldValue = $this->quantity->DefaultValue;
        $this->packets->DefaultValue = $this->packets->getDefault(); // PHP
        $this->packets->OldValue = $this->packets->DefaultValue;
        $this->price->DefaultValue = $this->price->getDefault(); // PHP
        $this->price->OldValue = $this->price->DefaultValue;
        $this->cart_amount->DefaultValue = $this->cart_amount->getDefault(); // PHP
        $this->cart_amount->OldValue = $this->cart_amount->DefaultValue;
        $this->other_amount->DefaultValue = $this->other_amount->getDefault(); // PHP
        $this->other_amount->OldValue = $this->other_amount->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->dated->DefaultValue = $this->dated->getDefault(); // PHP
        $this->dated->OldValue = $this->dated->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val);
            }
        }

        // Check field name 'process_type' first before field var 'x_process_type'
        $val = $CurrentForm->hasValue("process_type") ? $CurrentForm->getValue("process_type") : $CurrentForm->getValue("x_process_type");
        if (!$this->process_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_type->Visible = false; // Disable update for API request
            } else {
                $this->process_type->setFormValue($val);
            }
        }

        // Check field name 'issue_to_unit' first before field var 'x_issue_to_unit'
        $val = $CurrentForm->hasValue("issue_to_unit") ? $CurrentForm->getValue("issue_to_unit") : $CurrentForm->getValue("x_issue_to_unit");
        if (!$this->issue_to_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to_unit->Visible = false; // Disable update for API request
            } else {
                $this->issue_to_unit->setFormValue($val);
            }
        }

        // Check field name 'issue_to' first before field var 'x_issue_to'
        $val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
        if (!$this->issue_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to->Visible = false; // Disable update for API request
            } else {
                $this->issue_to->setFormValue($val);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'godown_po' first before field var 'x_godown_po'
        $val = $CurrentForm->hasValue("godown_po") ? $CurrentForm->getValue("godown_po") : $CurrentForm->getValue("x_godown_po");
        if (!$this->godown_po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown_po->Visible = false; // Disable update for API request
            } else {
                $this->godown_po->setFormValue($val);
            }
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid_1' first before field var 'x_rid_1'
        $val = $CurrentForm->hasValue("rid_1") ? $CurrentForm->getValue("rid_1") : $CurrentForm->getValue("x_rid_1");
        if (!$this->rid_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_1->Visible = false; // Disable update for API request
            } else {
                $this->rid_1->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'rid_2' first before field var 'x_rid_2'
        $val = $CurrentForm->hasValue("rid_2") ? $CurrentForm->getValue("rid_2") : $CurrentForm->getValue("x_rid_2");
        if (!$this->rid_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_2->Visible = false; // Disable update for API request
            } else {
                $this->rid_2->setFormValue($val);
            }
        }

        // Check field name 'rid_3' first before field var 'x_rid_3'
        $val = $CurrentForm->hasValue("rid_3") ? $CurrentForm->getValue("rid_3") : $CurrentForm->getValue("x_rid_3");
        if (!$this->rid_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_3->Visible = false; // Disable update for API request
            } else {
                $this->rid_3->setFormValue($val);
            }
        }

        // Check field name 'rid_po' first before field var 'x_rid_po'
        $val = $CurrentForm->hasValue("rid_po") ? $CurrentForm->getValue("rid_po") : $CurrentForm->getValue("x_rid_po");
        if (!$this->rid_po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_po->Visible = false; // Disable update for API request
            } else {
                $this->rid_po->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'avg_quantity' first before field var 'x_avg_quantity'
        $val = $CurrentForm->hasValue("avg_quantity") ? $CurrentForm->getValue("avg_quantity") : $CurrentForm->getValue("x_avg_quantity");
        if (!$this->avg_quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->avg_quantity->Visible = false; // Disable update for API request
            } else {
                $this->avg_quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'max_qty' first before field var 'x_max_qty'
        $val = $CurrentForm->hasValue("max_qty") ? $CurrentForm->getValue("max_qty") : $CurrentForm->getValue("x_max_qty");
        if (!$this->max_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->max_qty->Visible = false; // Disable update for API request
            } else {
                $this->max_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity_sub' first before field var 'x_quantity_sub'
        $val = $CurrentForm->hasValue("quantity_sub") ? $CurrentForm->getValue("quantity_sub") : $CurrentForm->getValue("x_quantity_sub");
        if (!$this->quantity_sub->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_sub->Visible = false; // Disable update for API request
            } else {
                $this->quantity_sub->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cart_amount' first before field var 'x_cart_amount'
        $val = $CurrentForm->hasValue("cart_amount") ? $CurrentForm->getValue("cart_amount") : $CurrentForm->getValue("x_cart_amount");
        if (!$this->cart_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cart_amount->Visible = false; // Disable update for API request
            } else {
                $this->cart_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'other_amount' first before field var 'x_other_amount'
        $val = $CurrentForm->hasValue("other_amount") ? $CurrentForm->getValue("other_amount") : $CurrentForm->getValue("x_other_amount");
        if (!$this->other_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_amount->Visible = false; // Disable update for API request
            } else {
                $this->other_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->process_type->CurrentValue = $this->process_type->FormValue;
        $this->issue_to_unit->CurrentValue = $this->issue_to_unit->FormValue;
        $this->issue_to->CurrentValue = $this->issue_to->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->godown_po->CurrentValue = $this->godown_po->FormValue;
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid_1->CurrentValue = $this->rid_1->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->rid_2->CurrentValue = $this->rid_2->FormValue;
        $this->rid_3->CurrentValue = $this->rid_3->FormValue;
        $this->rid_po->CurrentValue = $this->rid_po->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->avg_quantity->CurrentValue = $this->avg_quantity->FormValue;
        $this->max_qty->CurrentValue = $this->max_qty->FormValue;
        $this->quantity_sub->CurrentValue = $this->quantity_sub->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->cart_amount->CurrentValue = $this->cart_amount->FormValue;
        $this->other_amount->CurrentValue = $this->other_amount->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->process->setDbValue($row['process']);
        $this->process_type->setDbValue($row['process_type']);
        $this->issue_to_unit->setDbValue($row['issue_to_unit']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->godown->setDbValue($row['godown']);
        $this->godown_po->setDbValue($row['godown_po']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->rid_2->setDbValue($row['rid_2']);
        $this->rid_3->setDbValue($row['rid_3']);
        $this->rid_po->setDbValue($row['rid_po']);
        $this->rid->setDbValue($row['rid']);
        if (array_key_exists('EV__rid', $row)) {
            $this->rid->VirtualValue = $row['EV__rid']; // Set up virtual field value
        } else {
            $this->rid->VirtualValue = ""; // Clear value
        }
        $this->lot_no->setDbValue($row['lot_no']);
        $this->avg_quantity->setDbValue($row['avg_quantity']);
        $this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
        $this->max_qty->setDbValue($row['max_qty']);
        $this->quantity_sub->setDbValue($row['quantity_sub']);
        $this->quantity->setDbValue($row['quantity']);
        $this->packets->setDbValue($row['packets']);
        $this->price->setDbValue($row['price']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->other_amount->setDbValue($row['other_amount']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->dated->setDbValue($row['dated']);
        $this->remarks->setDbValue($row['remarks']);
        $this->status->setDbValue($row['status']);
        $this->tmp_lot->setDbValue($row['tmp_lot']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->amount->setDbValue($row['amount']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->tax_percent->setDbValue($row['tax_percent']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->cart_ref->setDbValue($row['cart_ref']);
        $this->po->setDbValue($row['po']);
        $this->_print->setDbValue($row['print']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->url->setDbValue($row['url']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->company_id->setDbValue($row['company_id']);
        $this->rid_name->setDbValue($row['rid_name']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['process_type'] = $this->process_type->DefaultValue;
        $row['issue_to_unit'] = $this->issue_to_unit->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['godown_po'] = $this->godown_po->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['gp_no'] = $this->gp_no->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['rid_2'] = $this->rid_2->DefaultValue;
        $row['rid_3'] = $this->rid_3->DefaultValue;
        $row['rid_po'] = $this->rid_po->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['avg_quantity'] = $this->avg_quantity->DefaultValue;
        $row['quantity_avg_act'] = $this->quantity_avg_act->DefaultValue;
        $row['max_qty'] = $this->max_qty->DefaultValue;
        $row['quantity_sub'] = $this->quantity_sub->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['cart_amount'] = $this->cart_amount->DefaultValue;
        $row['other_amount'] = $this->other_amount->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['tmp_lot'] = $this->tmp_lot->DefaultValue;
        $row['hsn_code'] = $this->hsn_code->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['tax_amount'] = $this->tax_amount->DefaultValue;
        $row['tax_percent'] = $this->tax_percent->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['cart_ref'] = $this->cart_ref->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['rid_name'] = $this->rid_name->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // process_type
        $this->process_type->RowCssClass = "row";

        // issue_to_unit
        $this->issue_to_unit->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // godown_po
        $this->godown_po->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // gp_no
        $this->gp_no->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // rid_2
        $this->rid_2->RowCssClass = "row";

        // rid_3
        $this->rid_3->RowCssClass = "row";

        // rid_po
        $this->rid_po->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // avg_quantity
        $this->avg_quantity->RowCssClass = "row";

        // quantity_avg_act
        $this->quantity_avg_act->RowCssClass = "row";

        // max_qty
        $this->max_qty->RowCssClass = "row";

        // quantity_sub
        $this->quantity_sub->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // cart_amount
        $this->cart_amount->RowCssClass = "row";

        // other_amount
        $this->other_amount->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // tmp_lot
        $this->tmp_lot->RowCssClass = "row";

        // hsn_code
        $this->hsn_code->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // tax_amount
        $this->tax_amount->RowCssClass = "row";

        // tax_percent
        $this->tax_percent->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // cart_ref
        $this->cart_ref->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // print
        $this->_print->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // rid_name
        $this->rid_name->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_type
            $curVal = strval($this->process_type->CurrentValue);
            if ($curVal != "") {
                $this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
                if ($this->process_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process_type->Lookup->renderViewRow($rswrk[0]);
                        $this->process_type->ViewValue = $this->process_type->displayValue($arwrk);
                    } else {
                        $this->process_type->ViewValue = $this->process_type->CurrentValue;
                    }
                }
            } else {
                $this->process_type->ViewValue = null;
            }

            // issue_to_unit
            $curVal = strval($this->issue_to_unit->CurrentValue);
            if ($curVal != "") {
                $this->issue_to_unit->ViewValue = $this->issue_to_unit->lookupCacheOption($curVal);
                if ($this->issue_to_unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to_unit->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to_unit->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to_unit->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to_unit->ViewValue = $this->issue_to_unit->displayValue($arwrk);
                    } else {
                        $this->issue_to_unit->ViewValue = FormatNumber($this->issue_to_unit->CurrentValue, $this->issue_to_unit->formatPattern());
                    }
                }
            } else {
                $this->issue_to_unit->ViewValue = null;
            }

            // issue_to
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
                    }
                }
            } else {
                $this->issue_to->ViewValue = null;
            }

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // godown_po
            $curVal = strval($this->godown_po->CurrentValue);
            if ($curVal != "") {
                $this->godown_po->ViewValue = $this->godown_po->lookupCacheOption($curVal);
                if ($this->godown_po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown_po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown_po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown_po->Lookup->renderViewRow($rswrk[0]);
                        $this->godown_po->ViewValue = $this->godown_po->displayValue($arwrk);
                    } else {
                        $this->godown_po->ViewValue = FormatNumber($this->godown_po->CurrentValue, $this->godown_po->formatPattern());
                    }
                }
            } else {
                $this->godown_po->ViewValue = null;
            }

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid_1
            $curVal = strval($this->rid_1->CurrentValue);
            if ($curVal != "") {
                $this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
                if ($this->rid_1->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_1->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
                    } else {
                        $this->rid_1->ViewValue = $this->rid_1->CurrentValue;
                    }
                }
            } else {
                $this->rid_1->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // rid_2
            $curVal = strval($this->rid_2->CurrentValue);
            if ($curVal != "") {
                $this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
                if ($this->rid_2->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid_2->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_2->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
                    } else {
                        $this->rid_2->ViewValue = $this->rid_2->CurrentValue;
                    }
                }
            } else {
                $this->rid_2->ViewValue = null;
            }

            // rid_3
            $curVal = strval($this->rid_3->CurrentValue);
            if ($curVal != "") {
                $this->rid_3->ViewValue = $this->rid_3->lookupCacheOption($curVal);
                if ($this->rid_3->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_3->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_3->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_3->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_3->ViewValue = $this->rid_3->displayValue($arwrk);
                    } else {
                        $this->rid_3->ViewValue = $this->rid_3->CurrentValue;
                    }
                }
            } else {
                $this->rid_3->ViewValue = null;
            }

            // rid_po
            $curVal = strval($this->rid_po->CurrentValue);
            if ($curVal != "") {
                $this->rid_po->ViewValue = $this->rid_po->lookupCacheOption($curVal);
                if ($this->rid_po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_po->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_po->ViewValue = $this->rid_po->displayValue($arwrk);
                    } else {
                        $this->rid_po->ViewValue = $this->rid_po->CurrentValue;
                    }
                }
            } else {
                $this->rid_po->ViewValue = null;
            }

            // rid
            if ($this->rid->VirtualValue != "") {
                $this->rid->ViewValue = $this->rid->VirtualValue;
            } else {
                $this->rid->ViewValue = $this->rid->CurrentValue;
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            }

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // avg_quantity
            $this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;

            // max_qty
            $this->max_qty->ViewValue = $this->max_qty->CurrentValue;

            // quantity_sub
            $this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
            $this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, $this->quantity_sub->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->CssClass = "fw-bold";

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());
            $this->price->CellCssStyle .= "text-align: right;";

            // cart_amount
            $this->cart_amount->ViewValue = $this->cart_amount->CurrentValue;
            $this->cart_amount->ViewValue = FormatNumber($this->cart_amount->ViewValue, $this->cart_amount->formatPattern());

            // other_amount
            $this->other_amount->ViewValue = $this->other_amount->CurrentValue;
            $this->other_amount->ViewValue = FormatNumber($this->other_amount->ViewValue, $this->other_amount->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // process_type
            if (!EmptyValue($this->process_type->CurrentValue)) {
                $this->process_type->HrefValue = $this->process_type->getLinkPrefix() . $this->process_type->CurrentValue; // Add prefix/suffix
                $this->process_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
                }
            } else {
                $this->process_type->HrefValue = "";
            }
            $this->process_type->TooltipValue = "";

            // issue_to_unit
            $this->issue_to_unit->HrefValue = "";

            // issue_to
            if (!EmptyValue($this->issue_to->CurrentValue)) {
                $this->issue_to->HrefValue = $this->issue_to->getLinkPrefix() . $this->issue_to->CurrentValue; // Add prefix/suffix
                $this->issue_to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
                }
            } else {
                $this->issue_to->HrefValue = "";
            }

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // godown_po
            $this->godown_po->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // rid_1
            $this->rid_1->HrefValue = "";
            $this->rid_1->TooltipValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }
            $this->packing_type->TooltipValue = "";

            // rid_2
            $this->rid_2->HrefValue = "";

            // rid_3
            $this->rid_3->HrefValue = "";

            // rid_po
            $this->rid_po->HrefValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // avg_quantity
            $this->avg_quantity->HrefValue = "";
            $this->avg_quantity->TooltipValue = "";

            // max_qty
            $this->max_qty->HrefValue = "";

            // quantity_sub
            $this->quantity_sub->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // cart_amount
            $this->cart_amount->HrefValue = "";
            $this->cart_amount->TooltipValue = "";

            // other_amount
            $this->other_amount->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        } elseif ($this->RowType == RowType::ADD) {
            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->CurrentValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // process_type
            $this->process_type->setupEditAttributes();
            $curVal = trim(strval($this->process_type->CurrentValue));
            if ($curVal != "") {
                $this->process_type->ViewValue = $this->process_type->lookupCacheOption($curVal);
            } else {
                $this->process_type->ViewValue = $this->process_type->Lookup !== null && is_array($this->process_type->lookupOptions()) && count($this->process_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_type->ViewValue !== null) { // Load from cache
                $this->process_type->EditValue = array_values($this->process_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process_type->CurrentValue, $this->process_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process_type->EditValue = $arwrk;
            }
            $this->process_type->PlaceHolder = RemoveHtml($this->process_type->caption());

            // issue_to_unit
            $this->issue_to_unit->setupEditAttributes();
            $curVal = trim(strval($this->issue_to_unit->CurrentValue));
            if ($curVal != "") {
                $this->issue_to_unit->ViewValue = $this->issue_to_unit->lookupCacheOption($curVal);
            } else {
                $this->issue_to_unit->ViewValue = $this->issue_to_unit->Lookup !== null && is_array($this->issue_to_unit->lookupOptions()) && count($this->issue_to_unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to_unit->ViewValue !== null) { // Load from cache
                $this->issue_to_unit->EditValue = array_values($this->issue_to_unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to_unit->CurrentValue, $this->issue_to_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to_unit->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_unit->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to_unit->EditValue = $arwrk;
            }
            $this->issue_to_unit->PlaceHolder = RemoveHtml($this->issue_to_unit->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $curVal = trim(strval($this->issue_to->CurrentValue));
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
            } else {
                $this->issue_to->ViewValue = $this->issue_to->Lookup !== null && is_array($this->issue_to->lookupOptions()) && count($this->issue_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to->ViewValue !== null) { // Load from cache
                $this->issue_to->EditValue = array_values($this->issue_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to->CurrentValue, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to->EditValue = $arwrk;
            }
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // godown
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->CurrentValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // godown_po
            $curVal = trim(strval($this->godown_po->CurrentValue));
            if ($curVal != "") {
                $this->godown_po->ViewValue = $this->godown_po->lookupCacheOption($curVal);
            } else {
                $this->godown_po->ViewValue = $this->godown_po->Lookup !== null && is_array($this->godown_po->lookupOptions()) && count($this->godown_po->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown_po->ViewValue !== null) { // Load from cache
                $this->godown_po->EditValue = array_values($this->godown_po->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown_po->CurrentValue, $this->godown_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown_po->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown_po->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown_po->EditValue = $arwrk;
            }
            $this->godown_po->PlaceHolder = RemoveHtml($this->godown_po->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            if (!$this->jc_no->Raw) {
                $this->jc_no->CurrentValue = HtmlDecode($this->jc_no->CurrentValue);
            }
            $this->jc_no->EditValue = HtmlEncode($this->jc_no->CurrentValue);
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid_1
            $curVal = trim(strval($this->rid_1->CurrentValue));
            if ($curVal != "") {
                $this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
            } else {
                $this->rid_1->ViewValue = $this->rid_1->Lookup !== null && is_array($this->rid_1->lookupOptions()) && count($this->rid_1->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_1->ViewValue !== null) { // Load from cache
                $this->rid_1->EditValue = array_values($this->rid_1->lookupOptions());
                if ($this->rid_1->ViewValue == "") {
                    $this->rid_1->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_1->CurrentValue, $this->rid_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_1->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_1->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
                } else {
                    $this->rid_1->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->rid_1->Lookup->renderViewRow($row);
                }
                $this->rid_1->EditValue = $arwrk;
            }
            $this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // rid_2
            $curVal = trim(strval($this->rid_2->CurrentValue));
            if ($curVal != "") {
                $this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
            } else {
                $this->rid_2->ViewValue = $this->rid_2->Lookup !== null && is_array($this->rid_2->lookupOptions()) && count($this->rid_2->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_2->ViewValue !== null) { // Load from cache
                $this->rid_2->EditValue = array_values($this->rid_2->lookupOptions());
                if ($this->rid_2->ViewValue == "") {
                    $this->rid_2->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_2->CurrentValue, $this->rid_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->rid_2->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_2->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
                } else {
                    $this->rid_2->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->rid_2->Lookup->renderViewRow($row);
                }
                $this->rid_2->EditValue = $arwrk;
            }
            $this->rid_2->PlaceHolder = RemoveHtml($this->rid_2->caption());

            // rid_3
            $curVal = trim(strval($this->rid_3->CurrentValue));
            if ($curVal != "") {
                $this->rid_3->ViewValue = $this->rid_3->lookupCacheOption($curVal);
            } else {
                $this->rid_3->ViewValue = $this->rid_3->Lookup !== null && is_array($this->rid_3->lookupOptions()) && count($this->rid_3->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_3->ViewValue !== null) { // Load from cache
                $this->rid_3->EditValue = array_values($this->rid_3->lookupOptions());
                if ($this->rid_3->ViewValue == "") {
                    $this->rid_3->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_3->CurrentValue, $this->rid_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_3->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_3->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_3->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_3->ViewValue = $this->rid_3->displayValue($arwrk);
                } else {
                    $this->rid_3->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->rid_3->Lookup->renderViewRow($row);
                }
                $this->rid_3->EditValue = $arwrk;
            }
            $this->rid_3->PlaceHolder = RemoveHtml($this->rid_3->caption());

            // rid_po
            $this->rid_po->setupEditAttributes();
            $curVal = trim(strval($this->rid_po->CurrentValue));
            if ($curVal != "") {
                $this->rid_po->ViewValue = $this->rid_po->lookupCacheOption($curVal);
            } else {
                $this->rid_po->ViewValue = $this->rid_po->Lookup !== null && is_array($this->rid_po->lookupOptions()) && count($this->rid_po->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_po->ViewValue !== null) { // Load from cache
                $this->rid_po->EditValue = array_values($this->rid_po->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_po->CurrentValue, $this->rid_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_po->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_po->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->rid_po->Lookup->renderViewRow($row);
                }
                $this->rid_po->EditValue = $arwrk;
            }
            $this->rid_po->PlaceHolder = RemoveHtml($this->rid_po->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // avg_quantity
            $this->avg_quantity->setupEditAttributes();
            if (!$this->avg_quantity->Raw) {
                $this->avg_quantity->CurrentValue = HtmlDecode($this->avg_quantity->CurrentValue);
            }
            $this->avg_quantity->EditValue = HtmlEncode($this->avg_quantity->CurrentValue);
            $this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());

            // max_qty
            $this->max_qty->setupEditAttributes();
            $this->max_qty->EditCustomAttributes = $this->max_qty->getEditCustomAttributes(); // PHP
            $this->max_qty->EditValue = $this->max_qty->CurrentValue;
            $this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());
            if (strval($this->max_qty->EditValue) != "" && is_numeric($this->max_qty->EditValue)) {
                $this->max_qty->EditValue = $this->max_qty->EditValue;
            }

            // quantity_sub
            $this->quantity_sub->setupEditAttributes();
            $this->quantity_sub->EditValue = $this->quantity_sub->CurrentValue;
            $this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());
            if (strval($this->quantity_sub->EditValue) != "" && is_numeric($this->quantity_sub->EditValue)) {
                $this->quantity_sub->EditValue = FormatNumber($this->quantity_sub->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // cart_amount
            $this->cart_amount->setupEditAttributes();
            $this->cart_amount->EditCustomAttributes = $this->cart_amount->getEditCustomAttributes(); // PHP
            $this->cart_amount->EditValue = $this->cart_amount->CurrentValue;
            $this->cart_amount->PlaceHolder = RemoveHtml($this->cart_amount->caption());
            if (strval($this->cart_amount->EditValue) != "" && is_numeric($this->cart_amount->EditValue)) {
                $this->cart_amount->EditValue = FormatNumber($this->cart_amount->EditValue, null);
            }

            // other_amount
            $this->other_amount->setupEditAttributes();
            $this->other_amount->EditValue = $this->other_amount->CurrentValue;
            $this->other_amount->PlaceHolder = RemoveHtml($this->other_amount->caption());
            if (strval($this->other_amount->EditValue) != "" && is_numeric($this->other_amount->EditValue)) {
                $this->other_amount->EditValue = FormatNumber($this->other_amount->EditValue, null);
            }

            // operator

            // datetime

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // Add refer script

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // process_type
            if (!EmptyValue($this->process_type->CurrentValue)) {
                $this->process_type->HrefValue = $this->process_type->getLinkPrefix() . $this->process_type->CurrentValue; // Add prefix/suffix
                $this->process_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process_type->HrefValue = FullUrl($this->process_type->HrefValue, "href");
                }
            } else {
                $this->process_type->HrefValue = "";
            }

            // issue_to_unit
            $this->issue_to_unit->HrefValue = "";

            // issue_to
            if (!EmptyValue($this->issue_to->CurrentValue)) {
                $this->issue_to->HrefValue = $this->issue_to->getLinkPrefix() . $this->issue_to->CurrentValue; // Add prefix/suffix
                $this->issue_to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
                }
            } else {
                $this->issue_to->HrefValue = "";
            }

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // godown_po
            $this->godown_po->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid_1
            $this->rid_1->HrefValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // rid_2
            $this->rid_2->HrefValue = "";

            // rid_3
            $this->rid_3->HrefValue = "";

            // rid_po
            $this->rid_po->HrefValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // lot_no
            $this->lot_no->HrefValue = "";

            // avg_quantity
            $this->avg_quantity->HrefValue = "";

            // max_qty
            $this->max_qty->HrefValue = "";

            // quantity_sub
            $this->quantity_sub->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // cart_amount
            $this->cart_amount->HrefValue = "";

            // other_amount
            $this->other_amount->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->process->Visible && $this->process->Required) {
                if (!$this->process->IsDetailKey && EmptyValue($this->process->FormValue)) {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->process_type->Visible && $this->process_type->Required) {
                if (!$this->process_type->IsDetailKey && EmptyValue($this->process_type->FormValue)) {
                    $this->process_type->addErrorMessage(str_replace("%s", $this->process_type->caption(), $this->process_type->RequiredErrorMessage));
                }
            }
            if ($this->issue_to_unit->Visible && $this->issue_to_unit->Required) {
                if (!$this->issue_to_unit->IsDetailKey && EmptyValue($this->issue_to_unit->FormValue)) {
                    $this->issue_to_unit->addErrorMessage(str_replace("%s", $this->issue_to_unit->caption(), $this->issue_to_unit->RequiredErrorMessage));
                }
            }
            if ($this->issue_to->Visible && $this->issue_to->Required) {
                if (!$this->issue_to->IsDetailKey && EmptyValue($this->issue_to->FormValue)) {
                    $this->issue_to->addErrorMessage(str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
                }
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if ($this->godown->FormValue == "") {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->godown_po->Visible && $this->godown_po->Required) {
                if ($this->godown_po->FormValue == "") {
                    $this->godown_po->addErrorMessage(str_replace("%s", $this->godown_po->caption(), $this->godown_po->RequiredErrorMessage));
                }
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid_1->Visible && $this->rid_1->Required) {
                if (!$this->rid_1->IsDetailKey && EmptyValue($this->rid_1->FormValue)) {
                    $this->rid_1->addErrorMessage(str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->rid_2->Visible && $this->rid_2->Required) {
                if (!$this->rid_2->IsDetailKey && EmptyValue($this->rid_2->FormValue)) {
                    $this->rid_2->addErrorMessage(str_replace("%s", $this->rid_2->caption(), $this->rid_2->RequiredErrorMessage));
                }
            }
            if ($this->rid_3->Visible && $this->rid_3->Required) {
                if (!$this->rid_3->IsDetailKey && EmptyValue($this->rid_3->FormValue)) {
                    $this->rid_3->addErrorMessage(str_replace("%s", $this->rid_3->caption(), $this->rid_3->RequiredErrorMessage));
                }
            }
            if ($this->rid_po->Visible && $this->rid_po->Required) {
                if (!$this->rid_po->IsDetailKey && EmptyValue($this->rid_po->FormValue)) {
                    $this->rid_po->addErrorMessage(str_replace("%s", $this->rid_po->caption(), $this->rid_po->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->avg_quantity->Visible && $this->avg_quantity->Required) {
                if (!$this->avg_quantity->IsDetailKey && EmptyValue($this->avg_quantity->FormValue)) {
                    $this->avg_quantity->addErrorMessage(str_replace("%s", $this->avg_quantity->caption(), $this->avg_quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->avg_quantity->FormValue)) {
                $this->avg_quantity->addErrorMessage($this->avg_quantity->getErrorMessage(false));
            }
            if ($this->max_qty->Visible && $this->max_qty->Required) {
                if (!$this->max_qty->IsDetailKey && EmptyValue($this->max_qty->FormValue)) {
                    $this->max_qty->addErrorMessage(str_replace("%s", $this->max_qty->caption(), $this->max_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->max_qty->FormValue)) {
                $this->max_qty->addErrorMessage($this->max_qty->getErrorMessage(false));
            }
            if ($this->quantity_sub->Visible && $this->quantity_sub->Required) {
                if (!$this->quantity_sub->IsDetailKey && EmptyValue($this->quantity_sub->FormValue)) {
                    $this->quantity_sub->addErrorMessage(str_replace("%s", $this->quantity_sub->caption(), $this->quantity_sub->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity_sub->FormValue)) {
                $this->quantity_sub->addErrorMessage($this->quantity_sub->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->cart_amount->Visible && $this->cart_amount->Required) {
                if (!$this->cart_amount->IsDetailKey && EmptyValue($this->cart_amount->FormValue)) {
                    $this->cart_amount->addErrorMessage(str_replace("%s", $this->cart_amount->caption(), $this->cart_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cart_amount->FormValue)) {
                $this->cart_amount->addErrorMessage($this->cart_amount->getErrorMessage(false));
            }
            if ($this->other_amount->Visible && $this->other_amount->Required) {
                if (!$this->other_amount->IsDetailKey && EmptyValue($this->other_amount->FormValue)) {
                    $this->other_amount->addErrorMessage(str_replace("%s", $this->other_amount->caption(), $this->other_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->other_amount->FormValue)) {
                $this->other_amount->addErrorMessage($this->other_amount->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, false);

        // process_type
        $this->process_type->setDbValueDef($rsnew, $this->process_type->CurrentValue, false);

        // issue_to_unit
        $this->issue_to_unit->setDbValueDef($rsnew, $this->issue_to_unit->CurrentValue, false);

        // issue_to
        $this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);

        // godown_po
        $this->godown_po->setDbValueDef($rsnew, $this->godown_po->CurrentValue, false);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid_1
        $this->rid_1->setDbValueDef($rsnew, $this->rid_1->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, false);

        // rid_2
        $this->rid_2->setDbValueDef($rsnew, $this->rid_2->CurrentValue, false);

        // rid_3
        $this->rid_3->setDbValueDef($rsnew, $this->rid_3->CurrentValue, false);

        // rid_po
        $this->rid_po->setDbValueDef($rsnew, $this->rid_po->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, strval($this->lot_no->CurrentValue) == "");

        // avg_quantity
        $this->avg_quantity->setDbValueDef($rsnew, $this->avg_quantity->CurrentValue, false);

        // max_qty
        $this->max_qty->setDbValueDef($rsnew, $this->max_qty->CurrentValue, false);

        // quantity_sub
        $this->quantity_sub->setDbValueDef($rsnew, $this->quantity_sub->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, false);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, false);

        // cart_amount
        $this->cart_amount->setDbValueDef($rsnew, $this->cart_amount->CurrentValue, strval($this->cart_amount->CurrentValue) == "");

        // other_amount
        $this->other_amount->setDbValueDef($rsnew, $this->other_amount->CurrentValue, strval($this->other_amount->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 600; // Resize width
            $this->uploads->ImageHeight = 600; // Resize height
        }
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['process'])) { // process
            $this->process->setFormValue($row['process']);
        }
        if (isset($row['process_type'])) { // process_type
            $this->process_type->setFormValue($row['process_type']);
        }
        if (isset($row['issue_to_unit'])) { // issue_to_unit
            $this->issue_to_unit->setFormValue($row['issue_to_unit']);
        }
        if (isset($row['issue_to'])) { // issue_to
            $this->issue_to->setFormValue($row['issue_to']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
        if (isset($row['godown_po'])) { // godown_po
            $this->godown_po->setFormValue($row['godown_po']);
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->setFormValue($row['jc_no']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid_1'])) { // rid_1
            $this->rid_1->setFormValue($row['rid_1']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['rid_2'])) { // rid_2
            $this->rid_2->setFormValue($row['rid_2']);
        }
        if (isset($row['rid_3'])) { // rid_3
            $this->rid_3->setFormValue($row['rid_3']);
        }
        if (isset($row['rid_po'])) { // rid_po
            $this->rid_po->setFormValue($row['rid_po']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['avg_quantity'])) { // avg_quantity
            $this->avg_quantity->setFormValue($row['avg_quantity']);
        }
        if (isset($row['max_qty'])) { // max_qty
            $this->max_qty->setFormValue($row['max_qty']);
        }
        if (isset($row['quantity_sub'])) { // quantity_sub
            $this->quantity_sub->setFormValue($row['quantity_sub']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['packets'])) { // packets
            $this->packets->setFormValue($row['packets']);
        }
        if (isset($row['price'])) { // price
            $this->price->setFormValue($row['price']);
        }
        if (isset($row['cart_amount'])) { // cart_amount
            $this->cart_amount->setFormValue($row['cart_amount']);
        }
        if (isset($row['other_amount'])) { // other_amount
            $this->other_amount->setFormValue($row['other_amount']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialoutlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to_unit":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid_2":
                    break;
                case "x_rid_3":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    break;
                case "x_quantity_avg_act":
                    break;
                case "x_operator":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    $CUID = CurrentUserID();
    $row=ExecuteRow("SELECT `process`, `issue_to`, `godown`, `grp`, `s_grp`, `product` FROM `material_out` where `operator` = $CUID ORDER BY `material_out`.`id` DESC");
    if ($row)
    {
    setcookie("Process", $row['process']);
    setcookie("BUY", $row['issue_to']);
    setcookie("GODOWN", $row['godown']);
    setcookie("GRP", $row['grp']);
    setcookie("SGRP", $row['s_grp']);
    setcookie("PR", $row['product']);
    }
    }

    // Page Unload event
    public function pageUnload() {
    	//echo "Page Unload";
    $CUID = CurrentUserID();
    $row=ExecuteRow("SELECT `process`, `issue_to`, `godown`, `grp`, `s_grp`, `product` FROM `material_out` where `operator` = $CUID ORDER BY `material_out`.`id` DESC");
    if ($row)
    {
    setcookie("Process", $row['process']);
    setcookie("BUY", $row['issue_to']);
    setcookie("GODOWN", $row['godown']);
    setcookie("GRP", $row['grp']);
    setcookie("SGRP", $row['s_grp']);
    setcookie("PR", $row['product']);
    }
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'material_out');
    	$this->lot_no->ReadOnly = True;
    	$this->rid->ReadOnly = True;
    	$this->avg_quantity->ReadOnly = True;
    	//$this->packing_type->ReadOnly = True;
    	if (isset($_GET['JC']))
    	{
    	$this->grp->ReadOnly = True;
    	$this->s_grp->ReadOnly = True;
    	$this->product->ReadOnly = True;
    	//$this->quantity->ReadOnly = True;
    	$this->issue_to->ReadOnly = True;
    	$this->quantity_avg_act->ReadOnly = True;
    	$this->process->ReadOnly = True;
    	$this->jc_no->ReadOnly = True;
    	} else {
    	$this->grp->ReadOnly = False;
    	$this->s_grp->ReadOnly = False;
    	$this->product->ReadOnly = False;
    	//$this->quantity->ReadOnly = False;
    	$this->issue_to->ReadOnly = False;
    	$this->quantity_avg_act->ReadOnly = False;
    	$this->process->ReadOnly = False;
    	$this->jc_no->ReadOnly = False;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
    	// Return error message in $customError
    	extract($_POST,EXTR_OVERWRITE);
    	$_SESSION[SESSION_WARNING_MESSAGE] = '';
        if (($x_godown == 1) && ($x_godown_po  == NULL))
        {
            $_SESSION[SESSION_WARNING_MESSAGE].= '"Processing House" can\'t be blank Please Select Some Value to field Processing House<br>';
        }
        if ($x_quantity == 0)
        {
            $_SESSION[SESSION_WARNING_MESSAGE].= '"Quantity" can\'t be 0 or blank Please Select Some Value to field Quantity<br>';
        }
    	if ( ($x_issue_to == NULL) && ($x_issue_to_unit > 0) )
            $x_issue_to = $x_issue_to_unit;
        if ( ( ($x_process == 101) || ($x_process == 102) || ($x_process == 103) || ($x_process == 105)) && ($x_issue_to == NULL) )
    		$_SESSION[SESSION_WARNING_MESSAGE].= '"Issue to" can\'t be blank Please Select Some Value to field<br>';
    	if ( ( ($x_process == 101) || ($x_process == 102) ) && ( ($x_price == NULL) || ($x_cart_amount == NULL) || ($x_other_amount == NULL) ) )
    		$_SESSION[SESSION_WARNING_MESSAGE].= '"Price or Cart Amount or Other Amount" can\'t be blank Please Select Some Value to respective field<br>';
       if ( ($x_process == 105) && ($x_process_type == NULL) )
    			$_SESSION[SESSION_WARNING_MESSAGE].= '"Process Type" can\'t be blank Please Select Some Value to field<br>';
    	if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    	{return TRUE;}
    	else
    	{return false;}
    }
}
