<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialOrderEdit extends MaterialOrder
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialOrderEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialorderedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->order_no->setVisibility();
        $this->date->setVisibility();
        $this->name->setVisibility();
        $this->delivery->setVisibility();
        $this->ref->setVisibility();
        $this->quantity->setVisibility();
        $this->unit->setVisibility();
        $this->price->setVisibility();
        $this->taxes->setVisibility();
        $this->delivery_terms->setVisibility();
        $this->delivery_address->setVisibility();
        $this->payments_terms->setVisibility();
        $this->reference->setVisibility();
        $this->remarks->setVisibility();
        $this->receving_remarks->setVisibility();
        $this->authorised->setVisibility();
        $this->_print->setVisibility();
        $this->updated->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_order';
        $this->TableName = 'material order';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_order)
        if (!isset($GLOBALS["material_order"]) || $GLOBALS["material_order"]::class == PROJECT_NAMESPACE . "material_order") {
            $GLOBALS["material_order"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material order');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "materialorderview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("materialorderlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "materialorderlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "materialorderlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "materialorderlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'order_no' first before field var 'x_order_no'
        $val = $CurrentForm->hasValue("order_no") ? $CurrentForm->getValue("order_no") : $CurrentForm->getValue("x_order_no");
        if (!$this->order_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_no->Visible = false; // Disable update for API request
            } else {
                $this->order_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'date' first before field var 'x_date'
        $val = $CurrentForm->hasValue("date") ? $CurrentForm->getValue("date") : $CurrentForm->getValue("x_date");
        if (!$this->date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date->Visible = false; // Disable update for API request
            } else {
                $this->date->setFormValue($val, true, $validate);
            }
            $this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delivery' first before field var 'x_delivery'
        $val = $CurrentForm->hasValue("delivery") ? $CurrentForm->getValue("delivery") : $CurrentForm->getValue("x_delivery");
        if (!$this->delivery->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery->Visible = false; // Disable update for API request
            } else {
                $this->delivery->setFormValue($val, true, $validate);
            }
            $this->delivery->CurrentValue = UnFormatDateTime($this->delivery->CurrentValue, $this->delivery->formatPattern());
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'taxes' first before field var 'x_taxes'
        $val = $CurrentForm->hasValue("taxes") ? $CurrentForm->getValue("taxes") : $CurrentForm->getValue("x_taxes");
        if (!$this->taxes->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->taxes->Visible = false; // Disable update for API request
            } else {
                $this->taxes->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delivery_terms' first before field var 'x_delivery_terms'
        $val = $CurrentForm->hasValue("delivery_terms") ? $CurrentForm->getValue("delivery_terms") : $CurrentForm->getValue("x_delivery_terms");
        if (!$this->delivery_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_terms->Visible = false; // Disable update for API request
            } else {
                $this->delivery_terms->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delivery_address' first before field var 'x_delivery_address'
        $val = $CurrentForm->hasValue("delivery_address") ? $CurrentForm->getValue("delivery_address") : $CurrentForm->getValue("x_delivery_address");
        if (!$this->delivery_address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_address->Visible = false; // Disable update for API request
            } else {
                $this->delivery_address->setFormValue($val);
            }
        }

        // Check field name 'payments_terms' first before field var 'x_payments_terms'
        $val = $CurrentForm->hasValue("payments_terms") ? $CurrentForm->getValue("payments_terms") : $CurrentForm->getValue("x_payments_terms");
        if (!$this->payments_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payments_terms->Visible = false; // Disable update for API request
            } else {
                $this->payments_terms->setFormValue($val);
            }
        }

        // Check field name 'reference' first before field var 'x_reference'
        $val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
        if (!$this->reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference->Visible = false; // Disable update for API request
            } else {
                $this->reference->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'receving_remarks' first before field var 'x_receving_remarks'
        $val = $CurrentForm->hasValue("receving_remarks") ? $CurrentForm->getValue("receving_remarks") : $CurrentForm->getValue("x_receving_remarks");
        if (!$this->receving_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->receving_remarks->Visible = false; // Disable update for API request
            } else {
                $this->receving_remarks->setFormValue($val);
            }
        }

        // Check field name 'authorised' first before field var 'x_authorised'
        $val = $CurrentForm->hasValue("authorised") ? $CurrentForm->getValue("authorised") : $CurrentForm->getValue("x_authorised");
        if (!$this->authorised->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->authorised->Visible = false; // Disable update for API request
            } else {
                $this->authorised->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'print' first before field var 'x__print'
        $val = $CurrentForm->hasValue("print") ? $CurrentForm->getValue("print") : $CurrentForm->getValue("x__print");
        if (!$this->_print->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_print->Visible = false; // Disable update for API request
            } else {
                $this->_print->setFormValue($val);
            }
        }

        // Check field name 'updated' first before field var 'x_updated'
        $val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
        if (!$this->updated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->updated->Visible = false; // Disable update for API request
            } else {
                $this->updated->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'a_operator' first before field var 'x_a_operator'
        $val = $CurrentForm->hasValue("a_operator") ? $CurrentForm->getValue("a_operator") : $CurrentForm->getValue("x_a_operator");
        if (!$this->a_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->a_operator->Visible = false; // Disable update for API request
            } else {
                $this->a_operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'a_datetime' first before field var 'x_a_datetime'
        $val = $CurrentForm->hasValue("a_datetime") ? $CurrentForm->getValue("a_datetime") : $CurrentForm->getValue("x_a_datetime");
        if (!$this->a_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->a_datetime->Visible = false; // Disable update for API request
            } else {
                $this->a_datetime->setFormValue($val, true, $validate);
            }
            $this->a_datetime->CurrentValue = UnFormatDateTime($this->a_datetime->CurrentValue, $this->a_datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->order_no->CurrentValue = $this->order_no->FormValue;
        $this->date->CurrentValue = $this->date->FormValue;
        $this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        $this->name->CurrentValue = $this->name->FormValue;
        $this->delivery->CurrentValue = $this->delivery->FormValue;
        $this->delivery->CurrentValue = UnFormatDateTime($this->delivery->CurrentValue, $this->delivery->formatPattern());
        $this->ref->CurrentValue = $this->ref->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->taxes->CurrentValue = $this->taxes->FormValue;
        $this->delivery_terms->CurrentValue = $this->delivery_terms->FormValue;
        $this->delivery_address->CurrentValue = $this->delivery_address->FormValue;
        $this->payments_terms->CurrentValue = $this->payments_terms->FormValue;
        $this->reference->CurrentValue = $this->reference->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->receving_remarks->CurrentValue = $this->receving_remarks->FormValue;
        $this->authorised->CurrentValue = $this->authorised->FormValue;
        $this->_print->CurrentValue = $this->_print->FormValue;
        $this->updated->CurrentValue = $this->updated->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->a_operator->CurrentValue = $this->a_operator->FormValue;
        $this->a_datetime->CurrentValue = $this->a_datetime->FormValue;
        $this->a_datetime->CurrentValue = UnFormatDateTime($this->a_datetime->CurrentValue, $this->a_datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->order_no->setDbValue($row['order_no']);
        $this->date->setDbValue($row['date']);
        $this->name->setDbValue($row['name']);
        $this->delivery->setDbValue($row['delivery']);
        $this->ref->setDbValue($row['ref']);
        $this->quantity->setDbValue($row['quantity']);
        $this->unit->setDbValue($row['unit']);
        $this->price->setDbValue($row['price']);
        $this->taxes->setDbValue($row['taxes']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->delivery_address->setDbValue($row['delivery_address']);
        $this->payments_terms->setDbValue($row['payments_terms']);
        $this->reference->setDbValue($row['reference']);
        $this->remarks->setDbValue($row['remarks']);
        $this->receving_remarks->setDbValue($row['receving_remarks']);
        $this->authorised->setDbValue($row['authorised']);
        $this->_print->setDbValue($row['print']);
        $this->updated->setDbValue($row['updated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['order_no'] = $this->order_no->DefaultValue;
        $row['date'] = $this->date->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['delivery'] = $this->delivery->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['taxes'] = $this->taxes->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['delivery_address'] = $this->delivery_address->DefaultValue;
        $row['payments_terms'] = $this->payments_terms->DefaultValue;
        $row['reference'] = $this->reference->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['receving_remarks'] = $this->receving_remarks->DefaultValue;
        $row['authorised'] = $this->authorised->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // order_no
        $this->order_no->RowCssClass = "row";

        // date
        $this->date->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // delivery
        $this->delivery->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // taxes
        $this->taxes->RowCssClass = "row";

        // delivery_terms
        $this->delivery_terms->RowCssClass = "row";

        // delivery_address
        $this->delivery_address->RowCssClass = "row";

        // payments_terms
        $this->payments_terms->RowCssClass = "row";

        // reference
        $this->reference->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // receving_remarks
        $this->receving_remarks->RowCssClass = "row";

        // authorised
        $this->authorised->RowCssClass = "row";

        // print
        $this->_print->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // order_no
            $this->order_no->ViewValue = $this->order_no->CurrentValue;
            $this->order_no->ViewValue = FormatNumber($this->order_no->ViewValue, $this->order_no->formatPattern());

            // date
            $this->date->ViewValue = $this->date->CurrentValue;
            $this->date->ViewValue = FormatDateTime($this->date->ViewValue, $this->date->formatPattern());

            // name
            $this->name->ViewValue = $this->name->CurrentValue;
            $this->name->ViewValue = FormatNumber($this->name->ViewValue, $this->name->formatPattern());

            // delivery
            $this->delivery->ViewValue = $this->delivery->CurrentValue;
            $this->delivery->ViewValue = FormatDateTime($this->delivery->ViewValue, $this->delivery->formatPattern());

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;
            $this->ref->ViewValue = FormatNumber($this->ref->ViewValue, $this->ref->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // unit
            $this->unit->ViewValue = $this->unit->CurrentValue;
            $this->unit->ViewValue = FormatNumber($this->unit->ViewValue, $this->unit->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // taxes
            $this->taxes->ViewValue = $this->taxes->CurrentValue;
            $this->taxes->ViewValue = FormatNumber($this->taxes->ViewValue, $this->taxes->formatPattern());

            // delivery_terms
            $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
            $this->delivery_terms->ViewValue = FormatNumber($this->delivery_terms->ViewValue, $this->delivery_terms->formatPattern());

            // delivery_address
            $this->delivery_address->ViewValue = $this->delivery_address->CurrentValue;

            // payments_terms
            $this->payments_terms->ViewValue = $this->payments_terms->CurrentValue;

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // receving_remarks
            $this->receving_remarks->ViewValue = $this->receving_remarks->CurrentValue;

            // authorised
            $this->authorised->ViewValue = $this->authorised->CurrentValue;
            $this->authorised->ViewValue = FormatNumber($this->authorised->ViewValue, $this->authorised->formatPattern());

            // print
            $this->_print->ViewValue = $this->_print->CurrentValue;

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
            $this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, $this->a_operator->formatPattern());

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // order_no
            $this->order_no->HrefValue = "";

            // date
            $this->date->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // delivery
            $this->delivery->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // taxes
            $this->taxes->HrefValue = "";

            // delivery_terms
            $this->delivery_terms->HrefValue = "";

            // delivery_address
            $this->delivery_address->HrefValue = "";

            // payments_terms
            $this->payments_terms->HrefValue = "";

            // reference
            $this->reference->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // receving_remarks
            $this->receving_remarks->HrefValue = "";

            // authorised
            $this->authorised->HrefValue = "";

            // print
            $this->_print->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // order_no
            $this->order_no->setupEditAttributes();
            $this->order_no->EditValue = $this->order_no->CurrentValue;
            $this->order_no->PlaceHolder = RemoveHtml($this->order_no->caption());
            if (strval($this->order_no->EditValue) != "" && is_numeric($this->order_no->EditValue)) {
                $this->order_no->EditValue = FormatNumber($this->order_no->EditValue, null);
            }

            // date
            $this->date->setupEditAttributes();
            $this->date->EditValue = HtmlEncode(FormatDateTime($this->date->CurrentValue, $this->date->formatPattern()));
            $this->date->PlaceHolder = RemoveHtml($this->date->caption());

            // name
            $this->name->setupEditAttributes();
            $this->name->EditValue = $this->name->CurrentValue;
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());
            if (strval($this->name->EditValue) != "" && is_numeric($this->name->EditValue)) {
                $this->name->EditValue = FormatNumber($this->name->EditValue, null);
            }

            // delivery
            $this->delivery->setupEditAttributes();
            $this->delivery->EditValue = HtmlEncode(FormatDateTime($this->delivery->CurrentValue, $this->delivery->formatPattern()));
            $this->delivery->PlaceHolder = RemoveHtml($this->delivery->caption());

            // ref
            $this->ref->setupEditAttributes();
            $this->ref->EditValue = $this->ref->CurrentValue;
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
            if (strval($this->ref->EditValue) != "" && is_numeric($this->ref->EditValue)) {
                $this->ref->EditValue = FormatNumber($this->ref->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->CurrentValue;
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());
            if (strval($this->unit->EditValue) != "" && is_numeric($this->unit->EditValue)) {
                $this->unit->EditValue = FormatNumber($this->unit->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // taxes
            $this->taxes->setupEditAttributes();
            $this->taxes->EditValue = $this->taxes->CurrentValue;
            $this->taxes->PlaceHolder = RemoveHtml($this->taxes->caption());
            if (strval($this->taxes->EditValue) != "" && is_numeric($this->taxes->EditValue)) {
                $this->taxes->EditValue = FormatNumber($this->taxes->EditValue, null);
            }

            // delivery_terms
            $this->delivery_terms->setupEditAttributes();
            $this->delivery_terms->EditValue = $this->delivery_terms->CurrentValue;
            $this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());
            if (strval($this->delivery_terms->EditValue) != "" && is_numeric($this->delivery_terms->EditValue)) {
                $this->delivery_terms->EditValue = FormatNumber($this->delivery_terms->EditValue, null);
            }

            // delivery_address
            $this->delivery_address->setupEditAttributes();
            if (!$this->delivery_address->Raw) {
                $this->delivery_address->CurrentValue = HtmlDecode($this->delivery_address->CurrentValue);
            }
            $this->delivery_address->EditValue = HtmlEncode($this->delivery_address->CurrentValue);
            $this->delivery_address->PlaceHolder = RemoveHtml($this->delivery_address->caption());

            // payments_terms
            $this->payments_terms->setupEditAttributes();
            if (!$this->payments_terms->Raw) {
                $this->payments_terms->CurrentValue = HtmlDecode($this->payments_terms->CurrentValue);
            }
            $this->payments_terms->EditValue = HtmlEncode($this->payments_terms->CurrentValue);
            $this->payments_terms->PlaceHolder = RemoveHtml($this->payments_terms->caption());

            // reference
            $this->reference->setupEditAttributes();
            if (!$this->reference->Raw) {
                $this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
            }
            $this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // receving_remarks
            $this->receving_remarks->setupEditAttributes();
            if (!$this->receving_remarks->Raw) {
                $this->receving_remarks->CurrentValue = HtmlDecode($this->receving_remarks->CurrentValue);
            }
            $this->receving_remarks->EditValue = HtmlEncode($this->receving_remarks->CurrentValue);
            $this->receving_remarks->PlaceHolder = RemoveHtml($this->receving_remarks->caption());

            // authorised
            $this->authorised->setupEditAttributes();
            $this->authorised->EditValue = $this->authorised->CurrentValue;
            $this->authorised->PlaceHolder = RemoveHtml($this->authorised->caption());
            if (strval($this->authorised->EditValue) != "" && is_numeric($this->authorised->EditValue)) {
                $this->authorised->EditValue = FormatNumber($this->authorised->EditValue, null);
            }

            // print
            $this->_print->setupEditAttributes();
            if (!$this->_print->Raw) {
                $this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
            }
            $this->_print->EditValue = HtmlEncode($this->_print->CurrentValue);
            $this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->CurrentValue;
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
            if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
                $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
            }

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // a_operator
            $this->a_operator->setupEditAttributes();
            $this->a_operator->EditValue = $this->a_operator->CurrentValue;
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());
            if (strval($this->a_operator->EditValue) != "" && is_numeric($this->a_operator->EditValue)) {
                $this->a_operator->EditValue = FormatNumber($this->a_operator->EditValue, null);
            }

            // a_datetime
            $this->a_datetime->setupEditAttributes();
            $this->a_datetime->EditValue = HtmlEncode(FormatDateTime($this->a_datetime->CurrentValue, $this->a_datetime->formatPattern()));
            $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // order_no
            $this->order_no->HrefValue = "";

            // date
            $this->date->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // delivery
            $this->delivery->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // taxes
            $this->taxes->HrefValue = "";

            // delivery_terms
            $this->delivery_terms->HrefValue = "";

            // delivery_address
            $this->delivery_address->HrefValue = "";

            // payments_terms
            $this->payments_terms->HrefValue = "";

            // reference
            $this->reference->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // receving_remarks
            $this->receving_remarks->HrefValue = "";

            // authorised
            $this->authorised->HrefValue = "";

            // print
            $this->_print->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->order_no->Visible && $this->order_no->Required) {
                if (!$this->order_no->IsDetailKey && EmptyValue($this->order_no->FormValue)) {
                    $this->order_no->addErrorMessage(str_replace("%s", $this->order_no->caption(), $this->order_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->order_no->FormValue)) {
                $this->order_no->addErrorMessage($this->order_no->getErrorMessage(false));
            }
            if ($this->date->Visible && $this->date->Required) {
                if (!$this->date->IsDetailKey && EmptyValue($this->date->FormValue)) {
                    $this->date->addErrorMessage(str_replace("%s", $this->date->caption(), $this->date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date->FormValue, $this->date->formatPattern())) {
                $this->date->addErrorMessage($this->date->getErrorMessage(false));
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->name->FormValue)) {
                $this->name->addErrorMessage($this->name->getErrorMessage(false));
            }
            if ($this->delivery->Visible && $this->delivery->Required) {
                if (!$this->delivery->IsDetailKey && EmptyValue($this->delivery->FormValue)) {
                    $this->delivery->addErrorMessage(str_replace("%s", $this->delivery->caption(), $this->delivery->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->delivery->FormValue, $this->delivery->formatPattern())) {
                $this->delivery->addErrorMessage($this->delivery->getErrorMessage(false));
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ref->FormValue)) {
                $this->ref->addErrorMessage($this->ref->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unit->FormValue)) {
                $this->unit->addErrorMessage($this->unit->getErrorMessage(false));
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->taxes->Visible && $this->taxes->Required) {
                if (!$this->taxes->IsDetailKey && EmptyValue($this->taxes->FormValue)) {
                    $this->taxes->addErrorMessage(str_replace("%s", $this->taxes->caption(), $this->taxes->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->taxes->FormValue)) {
                $this->taxes->addErrorMessage($this->taxes->getErrorMessage(false));
            }
            if ($this->delivery_terms->Visible && $this->delivery_terms->Required) {
                if (!$this->delivery_terms->IsDetailKey && EmptyValue($this->delivery_terms->FormValue)) {
                    $this->delivery_terms->addErrorMessage(str_replace("%s", $this->delivery_terms->caption(), $this->delivery_terms->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->delivery_terms->FormValue)) {
                $this->delivery_terms->addErrorMessage($this->delivery_terms->getErrorMessage(false));
            }
            if ($this->delivery_address->Visible && $this->delivery_address->Required) {
                if (!$this->delivery_address->IsDetailKey && EmptyValue($this->delivery_address->FormValue)) {
                    $this->delivery_address->addErrorMessage(str_replace("%s", $this->delivery_address->caption(), $this->delivery_address->RequiredErrorMessage));
                }
            }
            if ($this->payments_terms->Visible && $this->payments_terms->Required) {
                if (!$this->payments_terms->IsDetailKey && EmptyValue($this->payments_terms->FormValue)) {
                    $this->payments_terms->addErrorMessage(str_replace("%s", $this->payments_terms->caption(), $this->payments_terms->RequiredErrorMessage));
                }
            }
            if ($this->reference->Visible && $this->reference->Required) {
                if (!$this->reference->IsDetailKey && EmptyValue($this->reference->FormValue)) {
                    $this->reference->addErrorMessage(str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->receving_remarks->Visible && $this->receving_remarks->Required) {
                if (!$this->receving_remarks->IsDetailKey && EmptyValue($this->receving_remarks->FormValue)) {
                    $this->receving_remarks->addErrorMessage(str_replace("%s", $this->receving_remarks->caption(), $this->receving_remarks->RequiredErrorMessage));
                }
            }
            if ($this->authorised->Visible && $this->authorised->Required) {
                if (!$this->authorised->IsDetailKey && EmptyValue($this->authorised->FormValue)) {
                    $this->authorised->addErrorMessage(str_replace("%s", $this->authorised->caption(), $this->authorised->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->authorised->FormValue)) {
                $this->authorised->addErrorMessage($this->authorised->getErrorMessage(false));
            }
            if ($this->_print->Visible && $this->_print->Required) {
                if (!$this->_print->IsDetailKey && EmptyValue($this->_print->FormValue)) {
                    $this->_print->addErrorMessage(str_replace("%s", $this->_print->caption(), $this->_print->RequiredErrorMessage));
                }
            }
            if ($this->updated->Visible && $this->updated->Required) {
                if (!$this->updated->IsDetailKey && EmptyValue($this->updated->FormValue)) {
                    $this->updated->addErrorMessage(str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->updated->FormValue)) {
                $this->updated->addErrorMessage($this->updated->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }
            if ($this->a_operator->Visible && $this->a_operator->Required) {
                if (!$this->a_operator->IsDetailKey && EmptyValue($this->a_operator->FormValue)) {
                    $this->a_operator->addErrorMessage(str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->a_operator->FormValue)) {
                $this->a_operator->addErrorMessage($this->a_operator->getErrorMessage(false));
            }
            if ($this->a_datetime->Visible && $this->a_datetime->Required) {
                if (!$this->a_datetime->IsDetailKey && EmptyValue($this->a_datetime->FormValue)) {
                    $this->a_datetime->addErrorMessage(str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->a_datetime->FormValue, $this->a_datetime->formatPattern())) {
                $this->a_datetime->addErrorMessage($this->a_datetime->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // order_no
        $this->order_no->setDbValueDef($rsnew, $this->order_no->CurrentValue, $this->order_no->ReadOnly);

        // date
        $this->date->setDbValueDef($rsnew, UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern()), $this->date->ReadOnly);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // delivery
        $this->delivery->setDbValueDef($rsnew, UnFormatDateTime($this->delivery->CurrentValue, $this->delivery->formatPattern()), $this->delivery->ReadOnly);

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, $this->ref->ReadOnly);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, $this->quantity->ReadOnly);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, $this->unit->ReadOnly);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly);

        // taxes
        $this->taxes->setDbValueDef($rsnew, $this->taxes->CurrentValue, $this->taxes->ReadOnly);

        // delivery_terms
        $this->delivery_terms->setDbValueDef($rsnew, $this->delivery_terms->CurrentValue, $this->delivery_terms->ReadOnly);

        // delivery_address
        $this->delivery_address->setDbValueDef($rsnew, $this->delivery_address->CurrentValue, $this->delivery_address->ReadOnly);

        // payments_terms
        $this->payments_terms->setDbValueDef($rsnew, $this->payments_terms->CurrentValue, $this->payments_terms->ReadOnly);

        // reference
        $this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, $this->reference->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // receving_remarks
        $this->receving_remarks->setDbValueDef($rsnew, $this->receving_remarks->CurrentValue, $this->receving_remarks->ReadOnly);

        // authorised
        $this->authorised->setDbValueDef($rsnew, $this->authorised->CurrentValue, $this->authorised->ReadOnly);

        // print
        $this->_print->setDbValueDef($rsnew, $this->_print->CurrentValue, $this->_print->ReadOnly);

        // updated
        $this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, $this->updated->ReadOnly);

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // a_operator
        $this->a_operator->setDbValueDef($rsnew, $this->a_operator->CurrentValue, $this->a_operator->ReadOnly);

        // a_datetime
        $this->a_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->a_datetime->CurrentValue, $this->a_datetime->formatPattern()), $this->a_datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['order_no'])) { // order_no
            $this->order_no->CurrentValue = $row['order_no'];
        }
        if (isset($row['date'])) { // date
            $this->date->CurrentValue = $row['date'];
        }
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['delivery'])) { // delivery
            $this->delivery->CurrentValue = $row['delivery'];
        }
        if (isset($row['ref'])) { // ref
            $this->ref->CurrentValue = $row['ref'];
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->CurrentValue = $row['quantity'];
        }
        if (isset($row['unit'])) { // unit
            $this->unit->CurrentValue = $row['unit'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['taxes'])) { // taxes
            $this->taxes->CurrentValue = $row['taxes'];
        }
        if (isset($row['delivery_terms'])) { // delivery_terms
            $this->delivery_terms->CurrentValue = $row['delivery_terms'];
        }
        if (isset($row['delivery_address'])) { // delivery_address
            $this->delivery_address->CurrentValue = $row['delivery_address'];
        }
        if (isset($row['payments_terms'])) { // payments_terms
            $this->payments_terms->CurrentValue = $row['payments_terms'];
        }
        if (isset($row['reference'])) { // reference
            $this->reference->CurrentValue = $row['reference'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['receving_remarks'])) { // receving_remarks
            $this->receving_remarks->CurrentValue = $row['receving_remarks'];
        }
        if (isset($row['authorised'])) { // authorised
            $this->authorised->CurrentValue = $row['authorised'];
        }
        if (isset($row['print'])) { // print
            $this->_print->CurrentValue = $row['print'];
        }
        if (isset($row['updated'])) { // updated
            $this->updated->CurrentValue = $row['updated'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['a_operator'])) { // a_operator
            $this->a_operator->CurrentValue = $row['a_operator'];
        }
        if (isset($row['a_datetime'])) { // a_datetime
            $this->a_datetime->CurrentValue = $row['a_datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialorderlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
