<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MarginListMonthlyAdd extends MarginListMonthly
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MarginListMonthlyAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "marginlistmonthlyadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->lot_no->setVisibility();
        $this->margin_monthly->setVisibility();
        $this->margin_->setVisibility();
        $this->packets_p->setVisibility();
        $this->quantity_p->setVisibility();
        $this->_p->setVisibility();
        $this->amount_p->setVisibility();
        $this->packets_s->setVisibility();
        $this->quantity_s->setVisibility();
        $this->_s->setVisibility();
        $this->amount_s->setVisibility();
        $this->godown->setVisibility();
        $this->ref->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'margin_list_monthly';
        $this->TableName = 'margin_list_monthly';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (margin_list_monthly)
        if (!isset($GLOBALS["margin_list_monthly"]) || $GLOBALS["margin_list_monthly"]::class == PROJECT_NAMESPACE . "margin_list_monthly") {
            $GLOBALS["margin_list_monthly"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'margin_list_monthly');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "marginlistmonthlyview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->margin_monthly->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->margin_->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->packets_p->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->quantity_p->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_p->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->amount_p->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->packets_s->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->quantity_s->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_s->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->amount_s->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->ref->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->godown);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else { // Not post back
            $this->CopyRecord = false;
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("marginlistmonthlylist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "marginlistmonthlylist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "marginlistmonthlyview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "marginlistmonthlylist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "marginlistmonthlylist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'margin_monthly' first before field var 'x_margin_monthly'
        $val = $CurrentForm->hasValue("margin_monthly") ? $CurrentForm->getValue("margin_monthly") : $CurrentForm->getValue("x_margin_monthly");
        if (!$this->margin_monthly->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->margin_monthly->Visible = false; // Disable update for API request
            } else {
                $this->margin_monthly->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'margin_%' first before field var 'x_margin_'
        $val = $CurrentForm->hasValue("margin_%") ? $CurrentForm->getValue("margin_%") : $CurrentForm->getValue("x_margin_");
        if (!$this->margin_->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->margin_->Visible = false; // Disable update for API request
            } else {
                $this->margin_->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packets_p' first before field var 'x_packets_p'
        $val = $CurrentForm->hasValue("packets_p") ? $CurrentForm->getValue("packets_p") : $CurrentForm->getValue("x_packets_p");
        if (!$this->packets_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets_p->Visible = false; // Disable update for API request
            } else {
                $this->packets_p->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity_p' first before field var 'x_quantity_p'
        $val = $CurrentForm->hasValue("quantity_p") ? $CurrentForm->getValue("quantity_p") : $CurrentForm->getValue("x_quantity_p");
        if (!$this->quantity_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_p->Visible = false; // Disable update for API request
            } else {
                $this->quantity_p->setFormValue($val, true, $validate);
            }
        }

        // Check field name '@_p' first before field var 'x__p'
        $val = $CurrentForm->hasValue("@_p") ? $CurrentForm->getValue("@_p") : $CurrentForm->getValue("x__p");
        if (!$this->_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_p->Visible = false; // Disable update for API request
            } else {
                $this->_p->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'amount_p' first before field var 'x_amount_p'
        $val = $CurrentForm->hasValue("amount_p") ? $CurrentForm->getValue("amount_p") : $CurrentForm->getValue("x_amount_p");
        if (!$this->amount_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount_p->Visible = false; // Disable update for API request
            } else {
                $this->amount_p->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packets_s' first before field var 'x_packets_s'
        $val = $CurrentForm->hasValue("packets_s") ? $CurrentForm->getValue("packets_s") : $CurrentForm->getValue("x_packets_s");
        if (!$this->packets_s->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets_s->Visible = false; // Disable update for API request
            } else {
                $this->packets_s->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity_s' first before field var 'x_quantity_s'
        $val = $CurrentForm->hasValue("quantity_s") ? $CurrentForm->getValue("quantity_s") : $CurrentForm->getValue("x_quantity_s");
        if (!$this->quantity_s->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_s->Visible = false; // Disable update for API request
            } else {
                $this->quantity_s->setFormValue($val, true, $validate);
            }
        }

        // Check field name '@_s' first before field var 'x__s'
        $val = $CurrentForm->hasValue("@_s") ? $CurrentForm->getValue("@_s") : $CurrentForm->getValue("x__s");
        if (!$this->_s->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_s->Visible = false; // Disable update for API request
            } else {
                $this->_s->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'amount_s' first before field var 'x_amount_s'
        $val = $CurrentForm->hasValue("amount_s") ? $CurrentForm->getValue("amount_s") : $CurrentForm->getValue("x_amount_s");
        if (!$this->amount_s->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount_s->Visible = false; // Disable update for API request
            } else {
                $this->amount_s->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->margin_monthly->CurrentValue = $this->margin_monthly->FormValue;
        $this->margin_->CurrentValue = $this->margin_->FormValue;
        $this->packets_p->CurrentValue = $this->packets_p->FormValue;
        $this->quantity_p->CurrentValue = $this->quantity_p->FormValue;
        $this->_p->CurrentValue = $this->_p->FormValue;
        $this->amount_p->CurrentValue = $this->amount_p->FormValue;
        $this->packets_s->CurrentValue = $this->packets_s->FormValue;
        $this->quantity_s->CurrentValue = $this->quantity_s->FormValue;
        $this->_s->CurrentValue = $this->_s->FormValue;
        $this->amount_s->CurrentValue = $this->amount_s->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->ref->CurrentValue = $this->ref->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->margin_monthly->setDbValue($row['margin_monthly']);
        $this->margin_->setDbValue($row['margin_%']);
        $this->packets_p->setDbValue($row['packets_p']);
        $this->quantity_p->setDbValue($row['quantity_p']);
        $this->_p->setDbValue($row['@_p']);
        $this->amount_p->setDbValue($row['amount_p']);
        $this->packets_s->setDbValue($row['packets_s']);
        $this->quantity_s->setDbValue($row['quantity_s']);
        $this->_s->setDbValue($row['@_s']);
        $this->amount_s->setDbValue($row['amount_s']);
        $this->godown->setDbValue($row['godown']);
        $this->ref->setDbValue($row['ref']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['margin_monthly'] = $this->margin_monthly->DefaultValue;
        $row['margin_%'] = $this->margin_->DefaultValue;
        $row['packets_p'] = $this->packets_p->DefaultValue;
        $row['quantity_p'] = $this->quantity_p->DefaultValue;
        $row['@_p'] = $this->_p->DefaultValue;
        $row['amount_p'] = $this->amount_p->DefaultValue;
        $row['packets_s'] = $this->packets_s->DefaultValue;
        $row['quantity_s'] = $this->quantity_s->DefaultValue;
        $row['@_s'] = $this->_s->DefaultValue;
        $row['amount_s'] = $this->amount_s->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // margin_monthly
        $this->margin_monthly->RowCssClass = "row";

        // margin_%
        $this->margin_->RowCssClass = "row";

        // packets_p
        $this->packets_p->RowCssClass = "row";

        // quantity_p
        $this->quantity_p->RowCssClass = "row";

        // @_p
        $this->_p->RowCssClass = "row";

        // amount_p
        $this->amount_p->RowCssClass = "row";

        // packets_s
        $this->packets_s->RowCssClass = "row";

        // quantity_s
        $this->quantity_s->RowCssClass = "row";

        // @_s
        $this->_s->RowCssClass = "row";

        // amount_s
        $this->amount_s->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = FormatNumber($this->rid->CurrentValue, $this->rid->formatPattern());
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // margin_monthly
            $this->margin_monthly->ViewValue = $this->margin_monthly->CurrentValue;
            $this->margin_monthly->ViewValue = FormatNumber($this->margin_monthly->ViewValue, $this->margin_monthly->formatPattern());

            // margin_%
            $this->margin_->ViewValue = $this->margin_->CurrentValue;
            $this->margin_->ViewValue = FormatNumber($this->margin_->ViewValue, $this->margin_->formatPattern());

            // packets_p
            $this->packets_p->ViewValue = $this->packets_p->CurrentValue;
            $this->packets_p->ViewValue = FormatNumber($this->packets_p->ViewValue, $this->packets_p->formatPattern());

            // quantity_p
            $this->quantity_p->ViewValue = $this->quantity_p->CurrentValue;
            $this->quantity_p->ViewValue = FormatNumber($this->quantity_p->ViewValue, $this->quantity_p->formatPattern());

            // @_p
            $this->_p->ViewValue = $this->_p->CurrentValue;
            $this->_p->ViewValue = FormatNumber($this->_p->ViewValue, $this->_p->formatPattern());

            // amount_p
            $this->amount_p->ViewValue = $this->amount_p->CurrentValue;
            $this->amount_p->ViewValue = FormatNumber($this->amount_p->ViewValue, $this->amount_p->formatPattern());

            // packets_s
            $this->packets_s->ViewValue = $this->packets_s->CurrentValue;
            $this->packets_s->ViewValue = FormatNumber($this->packets_s->ViewValue, $this->packets_s->formatPattern());

            // quantity_s
            $this->quantity_s->ViewValue = $this->quantity_s->CurrentValue;
            $this->quantity_s->ViewValue = FormatNumber($this->quantity_s->ViewValue, $this->quantity_s->formatPattern());

            // @_s
            $this->_s->ViewValue = $this->_s->CurrentValue;
            $this->_s->ViewValue = FormatNumber($this->_s->ViewValue, $this->_s->formatPattern());

            // amount_s
            $this->amount_s->ViewValue = $this->amount_s->CurrentValue;
            $this->amount_s->ViewValue = FormatNumber($this->amount_s->ViewValue, $this->amount_s->formatPattern());

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // margin_monthly
            $this->margin_monthly->HrefValue = "";

            // margin_%
            $this->margin_->HrefValue = "";

            // packets_p
            $this->packets_p->HrefValue = "";

            // quantity_p
            $this->quantity_p->HrefValue = "";

            // @_p
            $this->_p->HrefValue = "";

            // amount_p
            $this->amount_p->HrefValue = "";

            // packets_s
            $this->packets_s->HrefValue = "";

            // quantity_s
            $this->quantity_s->HrefValue = "";

            // @_s
            $this->_s->HrefValue = "";

            // amount_s
            $this->amount_s->HrefValue = "";

            // godown
            $this->godown->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = HtmlEncode(FormatNumber($this->rid->CurrentValue, $this->rid->formatPattern()));
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // margin_monthly
            $this->margin_monthly->setupEditAttributes();
            $this->margin_monthly->EditValue = $this->margin_monthly->CurrentValue;
            $this->margin_monthly->PlaceHolder = RemoveHtml($this->margin_monthly->caption());
            if (strval($this->margin_monthly->EditValue) != "" && is_numeric($this->margin_monthly->EditValue)) {
                $this->margin_monthly->EditValue = FormatNumber($this->margin_monthly->EditValue, null);
            }

            // margin_%
            $this->margin_->setupEditAttributes();
            $this->margin_->EditValue = $this->margin_->CurrentValue;
            $this->margin_->PlaceHolder = RemoveHtml($this->margin_->caption());
            if (strval($this->margin_->EditValue) != "" && is_numeric($this->margin_->EditValue)) {
                $this->margin_->EditValue = FormatNumber($this->margin_->EditValue, null);
            }

            // packets_p
            $this->packets_p->setupEditAttributes();
            $this->packets_p->EditValue = $this->packets_p->CurrentValue;
            $this->packets_p->PlaceHolder = RemoveHtml($this->packets_p->caption());
            if (strval($this->packets_p->EditValue) != "" && is_numeric($this->packets_p->EditValue)) {
                $this->packets_p->EditValue = FormatNumber($this->packets_p->EditValue, null);
            }

            // quantity_p
            $this->quantity_p->setupEditAttributes();
            $this->quantity_p->EditValue = $this->quantity_p->CurrentValue;
            $this->quantity_p->PlaceHolder = RemoveHtml($this->quantity_p->caption());
            if (strval($this->quantity_p->EditValue) != "" && is_numeric($this->quantity_p->EditValue)) {
                $this->quantity_p->EditValue = FormatNumber($this->quantity_p->EditValue, null);
            }

            // @_p
            $this->_p->setupEditAttributes();
            $this->_p->EditValue = $this->_p->CurrentValue;
            $this->_p->PlaceHolder = RemoveHtml($this->_p->caption());
            if (strval($this->_p->EditValue) != "" && is_numeric($this->_p->EditValue)) {
                $this->_p->EditValue = FormatNumber($this->_p->EditValue, null);
            }

            // amount_p
            $this->amount_p->setupEditAttributes();
            $this->amount_p->EditValue = $this->amount_p->CurrentValue;
            $this->amount_p->PlaceHolder = RemoveHtml($this->amount_p->caption());
            if (strval($this->amount_p->EditValue) != "" && is_numeric($this->amount_p->EditValue)) {
                $this->amount_p->EditValue = FormatNumber($this->amount_p->EditValue, null);
            }

            // packets_s
            $this->packets_s->setupEditAttributes();
            $this->packets_s->EditValue = $this->packets_s->CurrentValue;
            $this->packets_s->PlaceHolder = RemoveHtml($this->packets_s->caption());
            if (strval($this->packets_s->EditValue) != "" && is_numeric($this->packets_s->EditValue)) {
                $this->packets_s->EditValue = FormatNumber($this->packets_s->EditValue, null);
            }

            // quantity_s
            $this->quantity_s->setupEditAttributes();
            $this->quantity_s->EditValue = $this->quantity_s->CurrentValue;
            $this->quantity_s->PlaceHolder = RemoveHtml($this->quantity_s->caption());
            if (strval($this->quantity_s->EditValue) != "" && is_numeric($this->quantity_s->EditValue)) {
                $this->quantity_s->EditValue = FormatNumber($this->quantity_s->EditValue, null);
            }

            // @_s
            $this->_s->setupEditAttributes();
            $this->_s->EditValue = $this->_s->CurrentValue;
            $this->_s->PlaceHolder = RemoveHtml($this->_s->caption());
            if (strval($this->_s->EditValue) != "" && is_numeric($this->_s->EditValue)) {
                $this->_s->EditValue = FormatNumber($this->_s->EditValue, null);
            }

            // amount_s
            $this->amount_s->setupEditAttributes();
            $this->amount_s->EditValue = $this->amount_s->CurrentValue;
            $this->amount_s->PlaceHolder = RemoveHtml($this->amount_s->caption());
            if (strval($this->amount_s->EditValue) != "" && is_numeric($this->amount_s->EditValue)) {
                $this->amount_s->EditValue = FormatNumber($this->amount_s->EditValue, null);
            }

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->CurrentValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // margin_monthly
            $this->margin_monthly->HrefValue = "";

            // margin_%
            $this->margin_->HrefValue = "";

            // packets_p
            $this->packets_p->HrefValue = "";

            // quantity_p
            $this->quantity_p->HrefValue = "";

            // @_p
            $this->_p->HrefValue = "";

            // amount_p
            $this->amount_p->HrefValue = "";

            // packets_s
            $this->packets_s->HrefValue = "";

            // quantity_s
            $this->quantity_s->HrefValue = "";

            // @_s
            $this->_s->HrefValue = "";

            // amount_s
            $this->amount_s->HrefValue = "";

            // godown
            $this->godown->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->rid->FormValue)) {
                $this->rid->addErrorMessage($this->rid->getErrorMessage(false));
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->margin_monthly->Visible && $this->margin_monthly->Required) {
                if (!$this->margin_monthly->IsDetailKey && EmptyValue($this->margin_monthly->FormValue)) {
                    $this->margin_monthly->addErrorMessage(str_replace("%s", $this->margin_monthly->caption(), $this->margin_monthly->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->margin_monthly->FormValue)) {
                $this->margin_monthly->addErrorMessage($this->margin_monthly->getErrorMessage(false));
            }
            if ($this->margin_->Visible && $this->margin_->Required) {
                if (!$this->margin_->IsDetailKey && EmptyValue($this->margin_->FormValue)) {
                    $this->margin_->addErrorMessage(str_replace("%s", $this->margin_->caption(), $this->margin_->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->margin_->FormValue)) {
                $this->margin_->addErrorMessage($this->margin_->getErrorMessage(false));
            }
            if ($this->packets_p->Visible && $this->packets_p->Required) {
                if (!$this->packets_p->IsDetailKey && EmptyValue($this->packets_p->FormValue)) {
                    $this->packets_p->addErrorMessage(str_replace("%s", $this->packets_p->caption(), $this->packets_p->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->packets_p->FormValue)) {
                $this->packets_p->addErrorMessage($this->packets_p->getErrorMessage(false));
            }
            if ($this->quantity_p->Visible && $this->quantity_p->Required) {
                if (!$this->quantity_p->IsDetailKey && EmptyValue($this->quantity_p->FormValue)) {
                    $this->quantity_p->addErrorMessage(str_replace("%s", $this->quantity_p->caption(), $this->quantity_p->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity_p->FormValue)) {
                $this->quantity_p->addErrorMessage($this->quantity_p->getErrorMessage(false));
            }
            if ($this->_p->Visible && $this->_p->Required) {
                if (!$this->_p->IsDetailKey && EmptyValue($this->_p->FormValue)) {
                    $this->_p->addErrorMessage(str_replace("%s", $this->_p->caption(), $this->_p->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_p->FormValue)) {
                $this->_p->addErrorMessage($this->_p->getErrorMessage(false));
            }
            if ($this->amount_p->Visible && $this->amount_p->Required) {
                if (!$this->amount_p->IsDetailKey && EmptyValue($this->amount_p->FormValue)) {
                    $this->amount_p->addErrorMessage(str_replace("%s", $this->amount_p->caption(), $this->amount_p->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount_p->FormValue)) {
                $this->amount_p->addErrorMessage($this->amount_p->getErrorMessage(false));
            }
            if ($this->packets_s->Visible && $this->packets_s->Required) {
                if (!$this->packets_s->IsDetailKey && EmptyValue($this->packets_s->FormValue)) {
                    $this->packets_s->addErrorMessage(str_replace("%s", $this->packets_s->caption(), $this->packets_s->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->packets_s->FormValue)) {
                $this->packets_s->addErrorMessage($this->packets_s->getErrorMessage(false));
            }
            if ($this->quantity_s->Visible && $this->quantity_s->Required) {
                if (!$this->quantity_s->IsDetailKey && EmptyValue($this->quantity_s->FormValue)) {
                    $this->quantity_s->addErrorMessage(str_replace("%s", $this->quantity_s->caption(), $this->quantity_s->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity_s->FormValue)) {
                $this->quantity_s->addErrorMessage($this->quantity_s->getErrorMessage(false));
            }
            if ($this->_s->Visible && $this->_s->Required) {
                if (!$this->_s->IsDetailKey && EmptyValue($this->_s->FormValue)) {
                    $this->_s->addErrorMessage(str_replace("%s", $this->_s->caption(), $this->_s->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_s->FormValue)) {
                $this->_s->addErrorMessage($this->_s->getErrorMessage(false));
            }
            if ($this->amount_s->Visible && $this->amount_s->Required) {
                if (!$this->amount_s->IsDetailKey && EmptyValue($this->amount_s->FormValue)) {
                    $this->amount_s->addErrorMessage(str_replace("%s", $this->amount_s->caption(), $this->amount_s->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount_s->FormValue)) {
                $this->amount_s->addErrorMessage($this->amount_s->getErrorMessage(false));
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("marginlistmonthlylist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_rid":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
