<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for margin_list
 */
class MarginList extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $godown;
    public $margin_monthly;
    public $margin_;
    public $packets_p;
    public $quantity_p;
    public $_p;
    public $amount_p;
    public $packets_s;
    public $quantity_s;
    public $_s;
    public $amount_s;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "margin_list";
        $this->TableName = 'margin_list';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "margin_list";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getLinkPrefix", fn() => "marginlistlist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], [], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getLinkPrefix", fn() => "marginlistlist?x_sgrp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', [], [], [], [], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getLinkPrefix", fn() => "marginlistlist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product', false, 'id', ["product","","",""], '', '', [], [], [], [], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->IsForeignKey = true; // Foreign key field
        $this->rid->setSelectMultiple(false); // Select one
        $this->rid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->godown->addMethod("getLinkPrefix", fn() => "marginlistlist?x_godown=");
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->setSelectMultiple(false); // Select one
        $this->godown->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->godown->Lookup = new Lookup($this->godown, 'godown', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown'] = &$this->godown;

        // margin_monthly
        $this->margin_monthly = new DbField(
            $this, // Table
            'x_margin_monthly', // Variable name
            'margin_monthly', // Name
            '`margin_monthly`', // Expression
            '`margin_monthly`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`margin_monthly`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->margin_monthly->InputTextType = "text";
        $this->margin_monthly->Raw = true;
        $this->margin_monthly->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->margin_monthly->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['margin_monthly'] = &$this->margin_monthly;

        // margin_%
        $this->margin_ = new DbField(
            $this, // Table
            'x_margin_', // Variable name
            'margin_%', // Name
            '`margin_%`', // Expression
            '`margin_%`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`margin_%`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->margin_->InputTextType = "text";
        $this->margin_->Raw = true;
        $this->margin_->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->margin_->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['margin_%'] = &$this->margin_;

        // packets_p
        $this->packets_p = new DbField(
            $this, // Table
            'x_packets_p', // Variable name
            'packets_p', // Name
            '`packets_p`', // Expression
            '`packets_p`', // Basic search expression
            131, // Type
            31, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets_p->InputTextType = "text";
        $this->packets_p->Raw = true;
        $this->packets_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->packets_p->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets_p'] = &$this->packets_p;

        // quantity_p
        $this->quantity_p = new DbField(
            $this, // Table
            'x_quantity_p', // Variable name
            'quantity_p', // Name
            '`quantity_p`', // Expression
            '`quantity_p`', // Basic search expression
            131, // Type
            33, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity_p->InputTextType = "text";
        $this->quantity_p->Raw = true;
        $this->quantity_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity_p->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity_p'] = &$this->quantity_p;

        // @_p
        $this->_p = new DbField(
            $this, // Table
            'x__p', // Variable name
            '@_p', // Name
            '`@_p`', // Expression
            '`@_p`', // Basic search expression
            131, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_p->InputTextType = "text";
        $this->_p->Raw = true;
        $this->_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_p->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['@_p'] = &$this->_p;

        // amount_p
        $this->amount_p = new DbField(
            $this, // Table
            'x_amount_p', // Variable name
            'amount_p', // Name
            '`amount_p`', // Expression
            '`amount_p`', // Basic search expression
            131, // Type
            41, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount_p->InputTextType = "text";
        $this->amount_p->Raw = true;
        $this->amount_p->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount_p->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount_p'] = &$this->amount_p;

        // packets_s
        $this->packets_s = new DbField(
            $this, // Table
            'x_packets_s', // Variable name
            'packets_s', // Name
            '`packets_s`', // Expression
            '`packets_s`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets_s`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets_s->InputTextType = "text";
        $this->packets_s->Raw = true;
        $this->packets_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->packets_s->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets_s'] = &$this->packets_s;

        // quantity_s
        $this->quantity_s = new DbField(
            $this, // Table
            'x_quantity_s', // Variable name
            'quantity_s', // Name
            '`quantity_s`', // Expression
            '`quantity_s`', // Basic search expression
            131, // Type
            34, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity_s`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity_s->InputTextType = "text";
        $this->quantity_s->Raw = true;
        $this->quantity_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity_s->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity_s'] = &$this->quantity_s;

        // @_s
        $this->_s = new DbField(
            $this, // Table
            'x__s', // Variable name
            '@_s', // Name
            '`@_s`', // Expression
            '`@_s`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@_s`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_s->InputTextType = "text";
        $this->_s->Raw = true;
        $this->_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_s->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['@_s'] = &$this->_s;

        // amount_s
        $this->amount_s = new DbField(
            $this, // Table
            'x_amount_s', // Variable name
            'amount_s', // Name
            '`amount_s`', // Expression
            '`amount_s`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount_s`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount_s->InputTextType = "text";
        $this->amount_s->Raw = true;
        $this->amount_s->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount_s->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount_s'] = &$this->amount_s;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "sales_ref") {
            $detailUrl = Container("sales_ref")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_rid", $this->rid->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "purchase_ref") {
            $detailUrl = Container("purchase_ref")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_rid", $this->rid->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "marginlistlist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "margin_list";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // Cascade Update detail table 'sales_ref'
        $cascadeUpdate = false;
        $rscascade = [];
        if ($rsold && (isset($rs['rid']) && $rsold['rid'] != $rs['rid'])) { // Update detail field 'rid'
            $cascadeUpdate = true;
            $rscascade['rid'] = $rs['rid'];
        }
        if ($cascadeUpdate) {
            $rswrk = Container("sales_ref")->loadRs("`rid` = " . QuotedValue($rsold['rid'], DataType::NUMBER, 'DB'))->fetchAllAssociative();
            foreach ($rswrk as $rsdtlold) {
                $rskey = [];
                $rsdtlnew = array_merge($rsdtlold, $rscascade);
                // Call Row_Updating event
                $success = Container("sales_ref")->rowUpdating($rsdtlold, $rsdtlnew);
                if ($success) {
                    $success = Container("sales_ref")->update($rscascade, $rskey, $rsdtlold);
                }
                if (!$success) {
                    return false;
                }
                // Call Row_Updated event
                Container("sales_ref")->rowUpdated($rsdtlold, $rsdtlnew);
            }
        }

        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;

        // Cascade delete detail table 'sales_ref'
        $dtlrows = Container("sales_ref")->loadRs("`rid` = " . QuotedValue($rs['rid'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("sales_ref")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("sales_ref")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("sales_ref")->rowDeleted($dtlrow);
            }
        }
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->godown->DbValue = $row['godown'];
        $this->margin_monthly->DbValue = $row['margin_monthly'];
        $this->margin_->DbValue = $row['margin_%'];
        $this->packets_p->DbValue = $row['packets_p'];
        $this->quantity_p->DbValue = $row['quantity_p'];
        $this->_p->DbValue = $row['@_p'];
        $this->amount_p->DbValue = $row['amount_p'];
        $this->packets_s->DbValue = $row['packets_s'];
        $this->quantity_s->DbValue = $row['quantity_s'];
        $this->_s->DbValue = $row['@_s'];
        $this->amount_s->DbValue = $row['amount_s'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("marginlistlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "marginlistview" => $Language->phrase("View"),
            "marginlistedit" => $Language->phrase("Edit"),
            "marginlistadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "marginlistlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MarginListView",
            Config("API_ADD_ACTION") => "MarginListAdd",
            Config("API_EDIT_ACTION") => "MarginListEdit",
            Config("API_DELETE_ACTION") => "MarginListDelete",
            Config("API_LIST_ACTION") => "MarginListList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "marginlistlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("marginlistview", $parm);
        } else {
            $url = $this->keyUrl("marginlistview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "marginlistadd?" . $parm;
        } else {
            $url = "marginlistadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("marginlistedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("marginlistlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("marginlistadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("marginlistlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("marginlistdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->godown->setDbValue($row['godown']);
        $this->margin_monthly->setDbValue($row['margin_monthly']);
        $this->margin_->setDbValue($row['margin_%']);
        $this->packets_p->setDbValue($row['packets_p']);
        $this->quantity_p->setDbValue($row['quantity_p']);
        $this->_p->setDbValue($row['@_p']);
        $this->amount_p->setDbValue($row['amount_p']);
        $this->packets_s->setDbValue($row['packets_s']);
        $this->quantity_s->setDbValue($row['quantity_s']);
        $this->_s->setDbValue($row['@_s']);
        $this->amount_s->setDbValue($row['amount_s']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MarginListList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // grp

        // s_grp

        // product

        // rid

        // godown

        // margin_monthly

        // margin_%

        // packets_p

        // quantity_p

        // @_p

        // amount_p

        // packets_s

        // quantity_s

        // @_s

        // amount_s

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = FormatNumber($this->rid->CurrentValue, $this->rid->formatPattern());
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // godown
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // margin_monthly
        $this->margin_monthly->ViewValue = $this->margin_monthly->CurrentValue;
        $this->margin_monthly->ViewValue = FormatNumber($this->margin_monthly->ViewValue, $this->margin_monthly->formatPattern());

        // margin_%
        $this->margin_->ViewValue = $this->margin_->CurrentValue;
        $this->margin_->ViewValue = FormatNumber($this->margin_->ViewValue, $this->margin_->formatPattern());

        // packets_p
        $this->packets_p->ViewValue = $this->packets_p->CurrentValue;
        $this->packets_p->ViewValue = FormatNumber($this->packets_p->ViewValue, $this->packets_p->formatPattern());

        // quantity_p
        $this->quantity_p->ViewValue = $this->quantity_p->CurrentValue;
        $this->quantity_p->ViewValue = FormatNumber($this->quantity_p->ViewValue, $this->quantity_p->formatPattern());

        // @_p
        $this->_p->ViewValue = $this->_p->CurrentValue;
        $this->_p->ViewValue = FormatNumber($this->_p->ViewValue, $this->_p->formatPattern());

        // amount_p
        $this->amount_p->ViewValue = $this->amount_p->CurrentValue;
        $this->amount_p->ViewValue = FormatNumber($this->amount_p->ViewValue, $this->amount_p->formatPattern());

        // packets_s
        $this->packets_s->ViewValue = $this->packets_s->CurrentValue;
        $this->packets_s->ViewValue = FormatNumber($this->packets_s->ViewValue, $this->packets_s->formatPattern());

        // quantity_s
        $this->quantity_s->ViewValue = $this->quantity_s->CurrentValue;
        $this->quantity_s->ViewValue = FormatNumber($this->quantity_s->ViewValue, $this->quantity_s->formatPattern());

        // @_s
        $this->_s->ViewValue = $this->_s->CurrentValue;
        $this->_s->ViewValue = FormatNumber($this->_s->ViewValue, $this->_s->formatPattern());

        // amount_s
        $this->amount_s->ViewValue = $this->amount_s->CurrentValue;
        $this->amount_s->ViewValue = FormatNumber($this->amount_s->ViewValue, $this->amount_s->formatPattern());

        // grp
        if (!EmptyValue($this->grp->CurrentValue)) {
            $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
            $this->grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
            }
        } else {
            $this->grp->HrefValue = "";
        }
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // godown
        if (!EmptyValue($this->godown->CurrentValue)) {
            $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
            $this->godown->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
            }
        } else {
            $this->godown->HrefValue = "";
        }
        $this->godown->TooltipValue = "";

        // margin_monthly
        $this->margin_monthly->HrefValue = "";
        $this->margin_monthly->TooltipValue = "";

        // margin_%
        $this->margin_->HrefValue = "";
        $this->margin_->TooltipValue = "";

        // packets_p
        $this->packets_p->HrefValue = "";
        $this->packets_p->TooltipValue = "";

        // quantity_p
        $this->quantity_p->HrefValue = "";
        $this->quantity_p->TooltipValue = "";

        // @_p
        $this->_p->HrefValue = "";
        $this->_p->TooltipValue = "";

        // amount_p
        $this->amount_p->HrefValue = "";
        $this->amount_p->TooltipValue = "";

        // packets_s
        $this->packets_s->HrefValue = "";
        $this->packets_s->TooltipValue = "";

        // quantity_s
        $this->quantity_s->HrefValue = "";
        $this->quantity_s->TooltipValue = "";

        // @_s
        $this->_s->HrefValue = "";
        $this->_s->TooltipValue = "";

        // amount_s
        $this->amount_s->HrefValue = "";
        $this->amount_s->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

        // godown
        $this->godown->setupEditAttributes();
        $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

        // margin_monthly
        $this->margin_monthly->setupEditAttributes();
        $this->margin_monthly->EditValue = $this->margin_monthly->CurrentValue;
        $this->margin_monthly->PlaceHolder = RemoveHtml($this->margin_monthly->caption());
        if (strval($this->margin_monthly->EditValue) != "" && is_numeric($this->margin_monthly->EditValue)) {
            $this->margin_monthly->EditValue = FormatNumber($this->margin_monthly->EditValue, null);
        }

        // margin_%
        $this->margin_->setupEditAttributes();
        $this->margin_->EditValue = $this->margin_->CurrentValue;
        $this->margin_->PlaceHolder = RemoveHtml($this->margin_->caption());
        if (strval($this->margin_->EditValue) != "" && is_numeric($this->margin_->EditValue)) {
            $this->margin_->EditValue = FormatNumber($this->margin_->EditValue, null);
        }

        // packets_p
        $this->packets_p->setupEditAttributes();
        $this->packets_p->EditValue = $this->packets_p->CurrentValue;
        $this->packets_p->PlaceHolder = RemoveHtml($this->packets_p->caption());
        if (strval($this->packets_p->EditValue) != "" && is_numeric($this->packets_p->EditValue)) {
            $this->packets_p->EditValue = FormatNumber($this->packets_p->EditValue, null);
        }

        // quantity_p
        $this->quantity_p->setupEditAttributes();
        $this->quantity_p->EditValue = $this->quantity_p->CurrentValue;
        $this->quantity_p->PlaceHolder = RemoveHtml($this->quantity_p->caption());
        if (strval($this->quantity_p->EditValue) != "" && is_numeric($this->quantity_p->EditValue)) {
            $this->quantity_p->EditValue = FormatNumber($this->quantity_p->EditValue, null);
        }

        // @_p
        $this->_p->setupEditAttributes();
        $this->_p->EditValue = $this->_p->CurrentValue;
        $this->_p->PlaceHolder = RemoveHtml($this->_p->caption());
        if (strval($this->_p->EditValue) != "" && is_numeric($this->_p->EditValue)) {
            $this->_p->EditValue = FormatNumber($this->_p->EditValue, null);
        }

        // amount_p
        $this->amount_p->setupEditAttributes();
        $this->amount_p->EditValue = $this->amount_p->CurrentValue;
        $this->amount_p->PlaceHolder = RemoveHtml($this->amount_p->caption());
        if (strval($this->amount_p->EditValue) != "" && is_numeric($this->amount_p->EditValue)) {
            $this->amount_p->EditValue = FormatNumber($this->amount_p->EditValue, null);
        }

        // packets_s
        $this->packets_s->setupEditAttributes();
        $this->packets_s->EditValue = $this->packets_s->CurrentValue;
        $this->packets_s->PlaceHolder = RemoveHtml($this->packets_s->caption());
        if (strval($this->packets_s->EditValue) != "" && is_numeric($this->packets_s->EditValue)) {
            $this->packets_s->EditValue = FormatNumber($this->packets_s->EditValue, null);
        }

        // quantity_s
        $this->quantity_s->setupEditAttributes();
        $this->quantity_s->EditValue = $this->quantity_s->CurrentValue;
        $this->quantity_s->PlaceHolder = RemoveHtml($this->quantity_s->caption());
        if (strval($this->quantity_s->EditValue) != "" && is_numeric($this->quantity_s->EditValue)) {
            $this->quantity_s->EditValue = FormatNumber($this->quantity_s->EditValue, null);
        }

        // @_s
        $this->_s->setupEditAttributes();
        $this->_s->EditValue = $this->_s->CurrentValue;
        $this->_s->PlaceHolder = RemoveHtml($this->_s->caption());
        if (strval($this->_s->EditValue) != "" && is_numeric($this->_s->EditValue)) {
            $this->_s->EditValue = FormatNumber($this->_s->EditValue, null);
        }

        // amount_s
        $this->amount_s->setupEditAttributes();
        $this->amount_s->EditValue = $this->amount_s->CurrentValue;
        $this->amount_s->PlaceHolder = RemoveHtml($this->amount_s->caption());
        if (strval($this->amount_s->EditValue) != "" && is_numeric($this->amount_s->EditValue)) {
            $this->amount_s->EditValue = FormatNumber($this->amount_s->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->margin_monthly->CurrentValue)) {
                $this->margin_monthly->Total += $this->margin_monthly->CurrentValue; // Accumulate total
            }
            $this->margin_->Count++; // Increment count
            if (is_numeric($this->margin_->CurrentValue)) {
                $this->margin_->Total += $this->margin_->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->packets_s->CurrentValue)) {
                $this->packets_s->Total += $this->packets_s->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity_s->CurrentValue)) {
                $this->quantity_s->Total += $this->quantity_s->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->amount_s->CurrentValue)) {
                $this->amount_s->Total += $this->amount_s->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->margin_monthly->CurrentValue = $this->margin_monthly->Total;
            $this->margin_monthly->ViewValue = $this->margin_monthly->CurrentValue;
            $this->margin_monthly->ViewValue = FormatNumber($this->margin_monthly->ViewValue, $this->margin_monthly->formatPattern());
            $this->margin_monthly->HrefValue = ""; // Clear href value
            if ($this->margin_->Count > 0) {
                $this->margin_->CurrentValue = $this->margin_->Total / $this->margin_->Count;
            }
            $this->margin_->ViewValue = $this->margin_->CurrentValue;
            $this->margin_->ViewValue = FormatNumber($this->margin_->ViewValue, $this->margin_->formatPattern());
            $this->margin_->HrefValue = ""; // Clear href value
            $this->packets_s->CurrentValue = $this->packets_s->Total;
            $this->packets_s->ViewValue = $this->packets_s->CurrentValue;
            $this->packets_s->ViewValue = FormatNumber($this->packets_s->ViewValue, $this->packets_s->formatPattern());
            $this->packets_s->HrefValue = ""; // Clear href value
            $this->quantity_s->CurrentValue = $this->quantity_s->Total;
            $this->quantity_s->ViewValue = $this->quantity_s->CurrentValue;
            $this->quantity_s->ViewValue = FormatNumber($this->quantity_s->ViewValue, $this->quantity_s->formatPattern());
            $this->quantity_s->HrefValue = ""; // Clear href value
            $this->amount_s->CurrentValue = $this->amount_s->Total;
            $this->amount_s->ViewValue = $this->amount_s->CurrentValue;
            $this->amount_s->ViewValue = FormatNumber($this->amount_s->ViewValue, $this->amount_s->formatPattern());
            $this->amount_s->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->margin_monthly);
                    $doc->exportCaption($this->margin_);
                    $doc->exportCaption($this->packets_p);
                    $doc->exportCaption($this->quantity_p);
                    $doc->exportCaption($this->_p);
                    $doc->exportCaption($this->amount_p);
                    $doc->exportCaption($this->packets_s);
                    $doc->exportCaption($this->quantity_s);
                    $doc->exportCaption($this->_s);
                    $doc->exportCaption($this->amount_s);
                } else {
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->margin_monthly);
                    $doc->exportCaption($this->margin_);
                    $doc->exportCaption($this->packets_p);
                    $doc->exportCaption($this->quantity_p);
                    $doc->exportCaption($this->_p);
                    $doc->exportCaption($this->amount_p);
                    $doc->exportCaption($this->packets_s);
                    $doc->exportCaption($this->quantity_s);
                    $doc->exportCaption($this->_s);
                    $doc->exportCaption($this->amount_s);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->margin_monthly);
                        $doc->exportField($this->margin_);
                        $doc->exportField($this->packets_p);
                        $doc->exportField($this->quantity_p);
                        $doc->exportField($this->_p);
                        $doc->exportField($this->amount_p);
                        $doc->exportField($this->packets_s);
                        $doc->exportField($this->quantity_s);
                        $doc->exportField($this->_s);
                        $doc->exportField($this->amount_s);
                    } else {
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->margin_monthly);
                        $doc->exportField($this->margin_);
                        $doc->exportField($this->packets_p);
                        $doc->exportField($this->quantity_p);
                        $doc->exportField($this->_p);
                        $doc->exportField($this->amount_p);
                        $doc->exportField($this->packets_s);
                        $doc->exportField($this->quantity_s);
                        $doc->exportField($this->_s);
                        $doc->exportField($this->amount_s);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->grp, '');
                $doc->exportAggregate($this->s_grp, '');
                $doc->exportAggregate($this->product, '');
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->godown, '');
                $doc->exportAggregate($this->margin_monthly, 'TOTAL');
                $doc->exportAggregate($this->margin_, 'AVERAGE');
                $doc->exportAggregate($this->packets_p, '');
                $doc->exportAggregate($this->quantity_p, '');
                $doc->exportAggregate($this->_p, '');
                $doc->exportAggregate($this->amount_p, '');
                $doc->exportAggregate($this->packets_s, 'TOTAL');
                $doc->exportAggregate($this->quantity_s, 'TOTAL');
                $doc->exportAggregate($this->_s, '');
                $doc->exportAggregate($this->amount_s, 'TOTAL');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
