<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LotNoDetailsDelete extends LotNoDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LotNoDetailsDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lotnodetailsdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->Visible = false;
        $this->ref->setVisibility();
        $this->packing_type->Visible = false;
        $this->lot_no->setVisibility();
        $this->processed_at->setVisibility();
        $this->micron->setVisibility();
        $this->length->setVisibility();
        $this->balance_quantity->setVisibility();
        $this->balance_packets->setVisibility();
        $this->base_product->setVisibility();
        $this->byproduct_1->setVisibility();
        $this->byproduct_2->setVisibility();
        $this->byproduct_3->setVisibility();
        $this->byproduct_4->setVisibility();
        $this->in_quantity->setVisibility();
        $this->out_quantity->setVisibility();
        $this->in_packets->setVisibility();
        $this->out_packets->setVisibility();
        $this->age->setVisibility();
        $this->remarks->setVisibility();
        $this->dated->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->rid->Visible = false;
        $this->employee_id->Visible = false;
        $this->jc_no->Visible = false;
        $this->raw_qty->Visible = false;
        $this->byproduct_1_in->Visible = false;
        $this->byproduct_2_in->Visible = false;
        $this->byproduct_3_in->Visible = false;
        $this->byproduct_4_in->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'lot_no_details';
        $this->TableName = 'lot_no_details';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (lot_no_details)
        if (!isset($GLOBALS["lot_no_details"]) || $GLOBALS["lot_no_details"]::class == PROJECT_NAMESPACE . "lot_no_details") {
            $GLOBALS["lot_no_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'lot_no_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->lot_no);
        $this->setupLookupOptions($this->processed_at);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("lotnodetailslist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("lotnodetailslist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->ref->setDbValue($row['ref']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        if (array_key_exists('EV__lot_no', $row)) {
            $this->lot_no->VirtualValue = $row['EV__lot_no']; // Set up virtual field value
        } else {
            $this->lot_no->VirtualValue = ""; // Clear value
        }
        $this->processed_at->setDbValue($row['processed_at']);
        $this->micron->setDbValue($row['micron']);
        $this->length->setDbValue($row['length']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->balance_packets->setDbValue($row['balance_packets']);
        $this->base_product->setDbValue($row['base_product']);
        $this->byproduct_1->setDbValue($row['byproduct_1']);
        $this->byproduct_2->setDbValue($row['byproduct_2']);
        $this->byproduct_3->setDbValue($row['byproduct_3']);
        $this->byproduct_4->setDbValue($row['byproduct_4']);
        $this->in_quantity->setDbValue($row['in_quantity']);
        $this->out_quantity->setDbValue($row['out_quantity']);
        $this->in_packets->setDbValue($row['in_packets']);
        $this->out_packets->setDbValue($row['out_packets']);
        $this->age->setDbValue($row['age']);
        $this->remarks->setDbValue($row['remarks']);
        $this->dated->setDbValue($row['dated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->rid->setDbValue($row['rid']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->raw_qty->setDbValue($row['raw_qty']);
        $this->byproduct_1_in->setDbValue($row['byproduct_1_in']);
        $this->byproduct_2_in->setDbValue($row['byproduct_2_in']);
        $this->byproduct_3_in->setDbValue($row['byproduct_3_in']);
        $this->byproduct_4_in->setDbValue($row['byproduct_4_in']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['processed_at'] = $this->processed_at->DefaultValue;
        $row['micron'] = $this->micron->DefaultValue;
        $row['length'] = $this->length->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['balance_packets'] = $this->balance_packets->DefaultValue;
        $row['base_product'] = $this->base_product->DefaultValue;
        $row['byproduct_1'] = $this->byproduct_1->DefaultValue;
        $row['byproduct_2'] = $this->byproduct_2->DefaultValue;
        $row['byproduct_3'] = $this->byproduct_3->DefaultValue;
        $row['byproduct_4'] = $this->byproduct_4->DefaultValue;
        $row['in_quantity'] = $this->in_quantity->DefaultValue;
        $row['out_quantity'] = $this->out_quantity->DefaultValue;
        $row['in_packets'] = $this->in_packets->DefaultValue;
        $row['out_packets'] = $this->out_packets->DefaultValue;
        $row['age'] = $this->age->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['raw_qty'] = $this->raw_qty->DefaultValue;
        $row['byproduct_1_in'] = $this->byproduct_1_in->DefaultValue;
        $row['byproduct_2_in'] = $this->byproduct_2_in->DefaultValue;
        $row['byproduct_3_in'] = $this->byproduct_3_in->DefaultValue;
        $row['byproduct_4_in'] = $this->byproduct_4_in->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // ref

        // packing_type

        // lot_no

        // processed_at

        // micron

        // length

        // balance_quantity

        // balance_packets

        // base_product

        // byproduct_1

        // byproduct_2

        // byproduct_3

        // byproduct_4

        // in_quantity

        // out_quantity

        // in_packets

        // out_packets

        // age
        $this->age->CellCssStyle = "white-space: nowrap;";

        // remarks

        // dated

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // employee_id
        $this->employee_id->CellCssStyle = "white-space: nowrap;";

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // raw_qty
        $this->raw_qty->CellCssStyle = "white-space: nowrap;";

        // byproduct_1_in
        $this->byproduct_1_in->CellCssStyle = "white-space: nowrap;";

        // byproduct_2_in
        $this->byproduct_2_in->CellCssStyle = "white-space: nowrap;";

        // byproduct_3_in
        $this->byproduct_3_in->CellCssStyle = "white-space: nowrap;";

        // byproduct_4_in
        $this->byproduct_4_in->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // lot_no
            if ($this->lot_no->VirtualValue != "") {
                $this->lot_no->ViewValue = $this->lot_no->VirtualValue;
            } else {
                $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                $curVal = strval($this->lot_no->CurrentValue);
                if ($curVal != "") {
                    $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
                    if ($this->lot_no->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchExpression(), "=", $curVal, $this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchDataType(), "");
                        $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->lot_no->Lookup->renderViewRow($rswrk[0]);
                            $this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
                        } else {
                            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                        }
                    }
                } else {
                    $this->lot_no->ViewValue = null;
                }
            }

            // processed_at
            $curVal = strval($this->processed_at->CurrentValue);
            if ($curVal != "") {
                $this->processed_at->ViewValue = $this->processed_at->lookupCacheOption($curVal);
                if ($this->processed_at->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->processed_at->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->processed_at->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->processed_at->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->processed_at->Lookup->renderViewRow($rswrk[0]);
                        $this->processed_at->ViewValue = $this->processed_at->displayValue($arwrk);
                    } else {
                        $this->processed_at->ViewValue = FormatNumber($this->processed_at->CurrentValue, $this->processed_at->formatPattern());
                    }
                }
            } else {
                $this->processed_at->ViewValue = null;
            }

            // micron
            $this->micron->ViewValue = $this->micron->CurrentValue;

            // length
            $this->length->ViewValue = $this->length->CurrentValue;

            // balance_quantity
            $this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
            $this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, $this->balance_quantity->formatPattern());

            // balance_packets
            $this->balance_packets->ViewValue = $this->balance_packets->CurrentValue;
            $this->balance_packets->ViewValue = FormatNumber($this->balance_packets->ViewValue, $this->balance_packets->formatPattern());

            // base_product
            $this->base_product->ViewValue = $this->base_product->CurrentValue;
            $this->base_product->ViewValue = FormatNumber($this->base_product->ViewValue, $this->base_product->formatPattern());

            // byproduct_1
            $this->byproduct_1->ViewValue = $this->byproduct_1->CurrentValue;
            $this->byproduct_1->ViewValue = FormatNumber($this->byproduct_1->ViewValue, $this->byproduct_1->formatPattern());

            // byproduct_2
            $this->byproduct_2->ViewValue = $this->byproduct_2->CurrentValue;
            $this->byproduct_2->ViewValue = FormatNumber($this->byproduct_2->ViewValue, $this->byproduct_2->formatPattern());

            // byproduct_3
            $this->byproduct_3->ViewValue = $this->byproduct_3->CurrentValue;
            $this->byproduct_3->ViewValue = FormatNumber($this->byproduct_3->ViewValue, $this->byproduct_3->formatPattern());

            // byproduct_4
            $this->byproduct_4->ViewValue = $this->byproduct_4->CurrentValue;
            $this->byproduct_4->ViewValue = FormatNumber($this->byproduct_4->ViewValue, $this->byproduct_4->formatPattern());

            // in_quantity
            $this->in_quantity->ViewValue = $this->in_quantity->CurrentValue;
            $this->in_quantity->ViewValue = FormatNumber($this->in_quantity->ViewValue, $this->in_quantity->formatPattern());

            // out_quantity
            $this->out_quantity->ViewValue = $this->out_quantity->CurrentValue;
            $this->out_quantity->ViewValue = FormatNumber($this->out_quantity->ViewValue, $this->out_quantity->formatPattern());

            // in_packets
            $this->in_packets->ViewValue = $this->in_packets->CurrentValue;
            $this->in_packets->ViewValue = FormatNumber($this->in_packets->ViewValue, $this->in_packets->formatPattern());

            // out_packets
            $this->out_packets->ViewValue = $this->out_packets->CurrentValue;
            $this->out_packets->ViewValue = FormatNumber($this->out_packets->ViewValue, $this->out_packets->formatPattern());

            // age
            $this->age->ViewValue = $this->age->CurrentValue;
            $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // processed_at
            $this->processed_at->HrefValue = "";
            $this->processed_at->TooltipValue = "";

            // micron
            $this->micron->HrefValue = "";
            $this->micron->TooltipValue = "";

            // length
            $this->length->HrefValue = "";
            $this->length->TooltipValue = "";

            // balance_quantity
            $this->balance_quantity->HrefValue = "";
            $this->balance_quantity->TooltipValue = "";

            // balance_packets
            $this->balance_packets->HrefValue = "";
            $this->balance_packets->TooltipValue = "";

            // base_product
            $this->base_product->HrefValue = "";
            $this->base_product->TooltipValue = "";

            // byproduct_1
            $this->byproduct_1->HrefValue = "";
            $this->byproduct_1->TooltipValue = "";

            // byproduct_2
            $this->byproduct_2->HrefValue = "";
            $this->byproduct_2->TooltipValue = "";

            // byproduct_3
            $this->byproduct_3->HrefValue = "";
            $this->byproduct_3->TooltipValue = "";

            // byproduct_4
            $this->byproduct_4->HrefValue = "";
            $this->byproduct_4->TooltipValue = "";

            // in_quantity
            $this->in_quantity->HrefValue = "";
            $this->in_quantity->TooltipValue = "";

            // out_quantity
            $this->out_quantity->HrefValue = "";
            $this->out_quantity->TooltipValue = "";

            // in_packets
            $this->in_packets->HrefValue = "";
            $this->in_packets->TooltipValue = "";

            // out_packets
            $this->out_packets->HrefValue = "";
            $this->out_packets->TooltipValue = "";

            // age
            $this->age->HrefValue = "";
            $this->age->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lotnodetailslist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lot_no":
                    break;
                case "x_processed_at":
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
