<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LotNoDetailsAdd extends LotNoDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LotNoDetailsAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lotnodetailsadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->ref->setVisibility();
        $this->packing_type->setVisibility();
        $this->lot_no->setVisibility();
        $this->processed_at->setVisibility();
        $this->micron->setVisibility();
        $this->length->setVisibility();
        $this->balance_quantity->setVisibility();
        $this->balance_packets->setVisibility();
        $this->base_product->setVisibility();
        $this->byproduct_1->setVisibility();
        $this->byproduct_2->setVisibility();
        $this->byproduct_3->setVisibility();
        $this->byproduct_4->setVisibility();
        $this->in_quantity->setVisibility();
        $this->out_quantity->setVisibility();
        $this->in_packets->setVisibility();
        $this->out_packets->setVisibility();
        $this->age->Visible = false;
        $this->remarks->setVisibility();
        $this->dated->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->rid->Visible = false;
        $this->employee_id->Visible = false;
        $this->jc_no->Visible = false;
        $this->raw_qty->Visible = false;
        $this->byproduct_1_in->Visible = false;
        $this->byproduct_2_in->Visible = false;
        $this->byproduct_3_in->Visible = false;
        $this->byproduct_4_in->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'lot_no_details';
        $this->TableName = 'lot_no_details';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (lot_no_details)
        if (!isset($GLOBALS["lot_no_details"]) || $GLOBALS["lot_no_details"]::class == PROJECT_NAMESPACE . "lot_no_details") {
            $GLOBALS["lot_no_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'lot_no_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "lotnodetailsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->lot_no);
        $this->setupLookupOptions($this->processed_at);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("lotnodetailslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "lotnodetailslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "lotnodetailsview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "lotnodetailslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "lotnodetailslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->lot_no->DefaultValue = $this->lot_no->getDefault(); // PHP
        $this->lot_no->OldValue = $this->lot_no->DefaultValue;
        $this->balance_quantity->DefaultValue = $this->balance_quantity->getDefault(); // PHP
        $this->balance_quantity->OldValue = $this->balance_quantity->DefaultValue;
        $this->balance_packets->DefaultValue = $this->balance_packets->getDefault(); // PHP
        $this->balance_packets->OldValue = $this->balance_packets->DefaultValue;
        $this->base_product->DefaultValue = $this->base_product->getDefault(); // PHP
        $this->base_product->OldValue = $this->base_product->DefaultValue;
        $this->byproduct_1->DefaultValue = $this->byproduct_1->getDefault(); // PHP
        $this->byproduct_1->OldValue = $this->byproduct_1->DefaultValue;
        $this->byproduct_2->DefaultValue = $this->byproduct_2->getDefault(); // PHP
        $this->byproduct_2->OldValue = $this->byproduct_2->DefaultValue;
        $this->byproduct_3->DefaultValue = $this->byproduct_3->getDefault(); // PHP
        $this->byproduct_3->OldValue = $this->byproduct_3->DefaultValue;
        $this->byproduct_4->DefaultValue = $this->byproduct_4->getDefault(); // PHP
        $this->byproduct_4->OldValue = $this->byproduct_4->DefaultValue;
        $this->out_quantity->DefaultValue = $this->out_quantity->getDefault(); // PHP
        $this->out_quantity->OldValue = $this->out_quantity->DefaultValue;
        $this->out_packets->DefaultValue = $this->out_packets->getDefault(); // PHP
        $this->out_packets->OldValue = $this->out_packets->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->jc_no->DefaultValue = $this->jc_no->getDefault(); // PHP
        $this->jc_no->OldValue = $this->jc_no->DefaultValue;
        $this->raw_qty->DefaultValue = $this->raw_qty->getDefault(); // PHP
        $this->raw_qty->OldValue = $this->raw_qty->DefaultValue;
        $this->byproduct_1_in->DefaultValue = $this->byproduct_1_in->getDefault(); // PHP
        $this->byproduct_1_in->OldValue = $this->byproduct_1_in->DefaultValue;
        $this->byproduct_2_in->DefaultValue = $this->byproduct_2_in->getDefault(); // PHP
        $this->byproduct_2_in->OldValue = $this->byproduct_2_in->DefaultValue;
        $this->byproduct_3_in->DefaultValue = $this->byproduct_3_in->getDefault(); // PHP
        $this->byproduct_3_in->OldValue = $this->byproduct_3_in->DefaultValue;
        $this->byproduct_4_in->DefaultValue = $this->byproduct_4_in->getDefault(); // PHP
        $this->byproduct_4_in->OldValue = $this->byproduct_4_in->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'processed_at' first before field var 'x_processed_at'
        $val = $CurrentForm->hasValue("processed_at") ? $CurrentForm->getValue("processed_at") : $CurrentForm->getValue("x_processed_at");
        if (!$this->processed_at->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->processed_at->Visible = false; // Disable update for API request
            } else {
                $this->processed_at->setFormValue($val);
            }
        }

        // Check field name 'micron' first before field var 'x_micron'
        $val = $CurrentForm->hasValue("micron") ? $CurrentForm->getValue("micron") : $CurrentForm->getValue("x_micron");
        if (!$this->micron->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->micron->Visible = false; // Disable update for API request
            } else {
                $this->micron->setFormValue($val);
            }
        }

        // Check field name 'length' first before field var 'x_length'
        $val = $CurrentForm->hasValue("length") ? $CurrentForm->getValue("length") : $CurrentForm->getValue("x_length");
        if (!$this->length->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->length->Visible = false; // Disable update for API request
            } else {
                $this->length->setFormValue($val);
            }
        }

        // Check field name 'balance_quantity' first before field var 'x_balance_quantity'
        $val = $CurrentForm->hasValue("balance_quantity") ? $CurrentForm->getValue("balance_quantity") : $CurrentForm->getValue("x_balance_quantity");
        if (!$this->balance_quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->balance_quantity->Visible = false; // Disable update for API request
            } else {
                $this->balance_quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'balance_packets' first before field var 'x_balance_packets'
        $val = $CurrentForm->hasValue("balance_packets") ? $CurrentForm->getValue("balance_packets") : $CurrentForm->getValue("x_balance_packets");
        if (!$this->balance_packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->balance_packets->Visible = false; // Disable update for API request
            } else {
                $this->balance_packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'base_product' first before field var 'x_base_product'
        $val = $CurrentForm->hasValue("base_product") ? $CurrentForm->getValue("base_product") : $CurrentForm->getValue("x_base_product");
        if (!$this->base_product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->base_product->Visible = false; // Disable update for API request
            } else {
                $this->base_product->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'byproduct_1' first before field var 'x_byproduct_1'
        $val = $CurrentForm->hasValue("byproduct_1") ? $CurrentForm->getValue("byproduct_1") : $CurrentForm->getValue("x_byproduct_1");
        if (!$this->byproduct_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->byproduct_1->Visible = false; // Disable update for API request
            } else {
                $this->byproduct_1->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'byproduct_2' first before field var 'x_byproduct_2'
        $val = $CurrentForm->hasValue("byproduct_2") ? $CurrentForm->getValue("byproduct_2") : $CurrentForm->getValue("x_byproduct_2");
        if (!$this->byproduct_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->byproduct_2->Visible = false; // Disable update for API request
            } else {
                $this->byproduct_2->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'byproduct_3' first before field var 'x_byproduct_3'
        $val = $CurrentForm->hasValue("byproduct_3") ? $CurrentForm->getValue("byproduct_3") : $CurrentForm->getValue("x_byproduct_3");
        if (!$this->byproduct_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->byproduct_3->Visible = false; // Disable update for API request
            } else {
                $this->byproduct_3->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'byproduct_4' first before field var 'x_byproduct_4'
        $val = $CurrentForm->hasValue("byproduct_4") ? $CurrentForm->getValue("byproduct_4") : $CurrentForm->getValue("x_byproduct_4");
        if (!$this->byproduct_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->byproduct_4->Visible = false; // Disable update for API request
            } else {
                $this->byproduct_4->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'in_quantity' first before field var 'x_in_quantity'
        $val = $CurrentForm->hasValue("in_quantity") ? $CurrentForm->getValue("in_quantity") : $CurrentForm->getValue("x_in_quantity");
        if (!$this->in_quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_quantity->Visible = false; // Disable update for API request
            } else {
                $this->in_quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'out_quantity' first before field var 'x_out_quantity'
        $val = $CurrentForm->hasValue("out_quantity") ? $CurrentForm->getValue("out_quantity") : $CurrentForm->getValue("x_out_quantity");
        if (!$this->out_quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->out_quantity->Visible = false; // Disable update for API request
            } else {
                $this->out_quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'in_packets' first before field var 'x_in_packets'
        $val = $CurrentForm->hasValue("in_packets") ? $CurrentForm->getValue("in_packets") : $CurrentForm->getValue("x_in_packets");
        if (!$this->in_packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_packets->Visible = false; // Disable update for API request
            } else {
                $this->in_packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'out_packets' first before field var 'x_out_packets'
        $val = $CurrentForm->hasValue("out_packets") ? $CurrentForm->getValue("out_packets") : $CurrentForm->getValue("x_out_packets");
        if (!$this->out_packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->out_packets->Visible = false; // Disable update for API request
            } else {
                $this->out_packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ref->CurrentValue = $this->ref->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->processed_at->CurrentValue = $this->processed_at->FormValue;
        $this->micron->CurrentValue = $this->micron->FormValue;
        $this->length->CurrentValue = $this->length->FormValue;
        $this->balance_quantity->CurrentValue = $this->balance_quantity->FormValue;
        $this->balance_packets->CurrentValue = $this->balance_packets->FormValue;
        $this->base_product->CurrentValue = $this->base_product->FormValue;
        $this->byproduct_1->CurrentValue = $this->byproduct_1->FormValue;
        $this->byproduct_2->CurrentValue = $this->byproduct_2->FormValue;
        $this->byproduct_3->CurrentValue = $this->byproduct_3->FormValue;
        $this->byproduct_4->CurrentValue = $this->byproduct_4->FormValue;
        $this->in_quantity->CurrentValue = $this->in_quantity->FormValue;
        $this->out_quantity->CurrentValue = $this->out_quantity->FormValue;
        $this->in_packets->CurrentValue = $this->in_packets->FormValue;
        $this->out_packets->CurrentValue = $this->out_packets->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->ref->setDbValue($row['ref']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        if (array_key_exists('EV__lot_no', $row)) {
            $this->lot_no->VirtualValue = $row['EV__lot_no']; // Set up virtual field value
        } else {
            $this->lot_no->VirtualValue = ""; // Clear value
        }
        $this->processed_at->setDbValue($row['processed_at']);
        $this->micron->setDbValue($row['micron']);
        $this->length->setDbValue($row['length']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->balance_packets->setDbValue($row['balance_packets']);
        $this->base_product->setDbValue($row['base_product']);
        $this->byproduct_1->setDbValue($row['byproduct_1']);
        $this->byproduct_2->setDbValue($row['byproduct_2']);
        $this->byproduct_3->setDbValue($row['byproduct_3']);
        $this->byproduct_4->setDbValue($row['byproduct_4']);
        $this->in_quantity->setDbValue($row['in_quantity']);
        $this->out_quantity->setDbValue($row['out_quantity']);
        $this->in_packets->setDbValue($row['in_packets']);
        $this->out_packets->setDbValue($row['out_packets']);
        $this->age->setDbValue($row['age']);
        $this->remarks->setDbValue($row['remarks']);
        $this->dated->setDbValue($row['dated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->rid->setDbValue($row['rid']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->raw_qty->setDbValue($row['raw_qty']);
        $this->byproduct_1_in->setDbValue($row['byproduct_1_in']);
        $this->byproduct_2_in->setDbValue($row['byproduct_2_in']);
        $this->byproduct_3_in->setDbValue($row['byproduct_3_in']);
        $this->byproduct_4_in->setDbValue($row['byproduct_4_in']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['processed_at'] = $this->processed_at->DefaultValue;
        $row['micron'] = $this->micron->DefaultValue;
        $row['length'] = $this->length->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['balance_packets'] = $this->balance_packets->DefaultValue;
        $row['base_product'] = $this->base_product->DefaultValue;
        $row['byproduct_1'] = $this->byproduct_1->DefaultValue;
        $row['byproduct_2'] = $this->byproduct_2->DefaultValue;
        $row['byproduct_3'] = $this->byproduct_3->DefaultValue;
        $row['byproduct_4'] = $this->byproduct_4->DefaultValue;
        $row['in_quantity'] = $this->in_quantity->DefaultValue;
        $row['out_quantity'] = $this->out_quantity->DefaultValue;
        $row['in_packets'] = $this->in_packets->DefaultValue;
        $row['out_packets'] = $this->out_packets->DefaultValue;
        $row['age'] = $this->age->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['raw_qty'] = $this->raw_qty->DefaultValue;
        $row['byproduct_1_in'] = $this->byproduct_1_in->DefaultValue;
        $row['byproduct_2_in'] = $this->byproduct_2_in->DefaultValue;
        $row['byproduct_3_in'] = $this->byproduct_3_in->DefaultValue;
        $row['byproduct_4_in'] = $this->byproduct_4_in->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // processed_at
        $this->processed_at->RowCssClass = "row";

        // micron
        $this->micron->RowCssClass = "row";

        // length
        $this->length->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // balance_packets
        $this->balance_packets->RowCssClass = "row";

        // base_product
        $this->base_product->RowCssClass = "row";

        // byproduct_1
        $this->byproduct_1->RowCssClass = "row";

        // byproduct_2
        $this->byproduct_2->RowCssClass = "row";

        // byproduct_3
        $this->byproduct_3->RowCssClass = "row";

        // byproduct_4
        $this->byproduct_4->RowCssClass = "row";

        // in_quantity
        $this->in_quantity->RowCssClass = "row";

        // out_quantity
        $this->out_quantity->RowCssClass = "row";

        // in_packets
        $this->in_packets->RowCssClass = "row";

        // out_packets
        $this->out_packets->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // raw_qty
        $this->raw_qty->RowCssClass = "row";

        // byproduct_1_in
        $this->byproduct_1_in->RowCssClass = "row";

        // byproduct_2_in
        $this->byproduct_2_in->RowCssClass = "row";

        // byproduct_3_in
        $this->byproduct_3_in->RowCssClass = "row";

        // byproduct_4_in
        $this->byproduct_4_in->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // lot_no
            if ($this->lot_no->VirtualValue != "") {
                $this->lot_no->ViewValue = $this->lot_no->VirtualValue;
            } else {
                $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                $curVal = strval($this->lot_no->CurrentValue);
                if ($curVal != "") {
                    $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
                    if ($this->lot_no->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchExpression(), "=", $curVal, $this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchDataType(), "");
                        $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->lot_no->Lookup->renderViewRow($rswrk[0]);
                            $this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
                        } else {
                            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                        }
                    }
                } else {
                    $this->lot_no->ViewValue = null;
                }
            }

            // processed_at
            $curVal = strval($this->processed_at->CurrentValue);
            if ($curVal != "") {
                $this->processed_at->ViewValue = $this->processed_at->lookupCacheOption($curVal);
                if ($this->processed_at->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->processed_at->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->processed_at->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->processed_at->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->processed_at->Lookup->renderViewRow($rswrk[0]);
                        $this->processed_at->ViewValue = $this->processed_at->displayValue($arwrk);
                    } else {
                        $this->processed_at->ViewValue = FormatNumber($this->processed_at->CurrentValue, $this->processed_at->formatPattern());
                    }
                }
            } else {
                $this->processed_at->ViewValue = null;
            }

            // micron
            $this->micron->ViewValue = $this->micron->CurrentValue;

            // length
            $this->length->ViewValue = $this->length->CurrentValue;

            // balance_quantity
            $this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
            $this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, $this->balance_quantity->formatPattern());

            // balance_packets
            $this->balance_packets->ViewValue = $this->balance_packets->CurrentValue;
            $this->balance_packets->ViewValue = FormatNumber($this->balance_packets->ViewValue, $this->balance_packets->formatPattern());

            // base_product
            $this->base_product->ViewValue = $this->base_product->CurrentValue;
            $this->base_product->ViewValue = FormatNumber($this->base_product->ViewValue, $this->base_product->formatPattern());

            // byproduct_1
            $this->byproduct_1->ViewValue = $this->byproduct_1->CurrentValue;
            $this->byproduct_1->ViewValue = FormatNumber($this->byproduct_1->ViewValue, $this->byproduct_1->formatPattern());

            // byproduct_2
            $this->byproduct_2->ViewValue = $this->byproduct_2->CurrentValue;
            $this->byproduct_2->ViewValue = FormatNumber($this->byproduct_2->ViewValue, $this->byproduct_2->formatPattern());

            // byproduct_3
            $this->byproduct_3->ViewValue = $this->byproduct_3->CurrentValue;
            $this->byproduct_3->ViewValue = FormatNumber($this->byproduct_3->ViewValue, $this->byproduct_3->formatPattern());

            // byproduct_4
            $this->byproduct_4->ViewValue = $this->byproduct_4->CurrentValue;
            $this->byproduct_4->ViewValue = FormatNumber($this->byproduct_4->ViewValue, $this->byproduct_4->formatPattern());

            // in_quantity
            $this->in_quantity->ViewValue = $this->in_quantity->CurrentValue;
            $this->in_quantity->ViewValue = FormatNumber($this->in_quantity->ViewValue, $this->in_quantity->formatPattern());

            // out_quantity
            $this->out_quantity->ViewValue = $this->out_quantity->CurrentValue;
            $this->out_quantity->ViewValue = FormatNumber($this->out_quantity->ViewValue, $this->out_quantity->formatPattern());

            // in_packets
            $this->in_packets->ViewValue = $this->in_packets->CurrentValue;
            $this->in_packets->ViewValue = FormatNumber($this->in_packets->ViewValue, $this->in_packets->formatPattern());

            // out_packets
            $this->out_packets->ViewValue = $this->out_packets->CurrentValue;
            $this->out_packets->ViewValue = FormatNumber($this->out_packets->ViewValue, $this->out_packets->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // ref
            $this->ref->HrefValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // lot_no
            $this->lot_no->HrefValue = "";

            // processed_at
            $this->processed_at->HrefValue = "";

            // micron
            $this->micron->HrefValue = "";

            // length
            $this->length->HrefValue = "";

            // balance_quantity
            $this->balance_quantity->HrefValue = "";

            // balance_packets
            $this->balance_packets->HrefValue = "";

            // base_product
            $this->base_product->HrefValue = "";

            // byproduct_1
            $this->byproduct_1->HrefValue = "";

            // byproduct_2
            $this->byproduct_2->HrefValue = "";

            // byproduct_3
            $this->byproduct_3->HrefValue = "";

            // byproduct_4
            $this->byproduct_4->HrefValue = "";

            // in_quantity
            $this->in_quantity->HrefValue = "";

            // out_quantity
            $this->out_quantity->HrefValue = "";

            // in_packets
            $this->in_packets->HrefValue = "";

            // out_packets
            $this->out_packets->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // processed_at
            $this->processed_at->setupEditAttributes();
            $curVal = trim(strval($this->processed_at->CurrentValue));
            if ($curVal != "") {
                $this->processed_at->ViewValue = $this->processed_at->lookupCacheOption($curVal);
            } else {
                $this->processed_at->ViewValue = $this->processed_at->Lookup !== null && is_array($this->processed_at->lookupOptions()) && count($this->processed_at->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->processed_at->ViewValue !== null) { // Load from cache
                $this->processed_at->EditValue = array_values($this->processed_at->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->processed_at->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->processed_at->CurrentValue, $this->processed_at->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->processed_at->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->processed_at->EditValue = $arwrk;
            }
            $this->processed_at->PlaceHolder = RemoveHtml($this->processed_at->caption());

            // micron
            $this->micron->setupEditAttributes();
            if (!$this->micron->Raw) {
                $this->micron->CurrentValue = HtmlDecode($this->micron->CurrentValue);
            }
            $this->micron->EditValue = HtmlEncode($this->micron->CurrentValue);
            $this->micron->PlaceHolder = RemoveHtml($this->micron->caption());

            // length
            $this->length->setupEditAttributes();
            if (!$this->length->Raw) {
                $this->length->CurrentValue = HtmlDecode($this->length->CurrentValue);
            }
            $this->length->EditValue = HtmlEncode($this->length->CurrentValue);
            $this->length->PlaceHolder = RemoveHtml($this->length->caption());

            // balance_quantity
            $this->balance_quantity->setupEditAttributes();
            $this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
            $this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
            if (strval($this->balance_quantity->EditValue) != "" && is_numeric($this->balance_quantity->EditValue)) {
                $this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, null);
            }

            // balance_packets
            $this->balance_packets->setupEditAttributes();
            $this->balance_packets->EditValue = $this->balance_packets->CurrentValue;
            $this->balance_packets->PlaceHolder = RemoveHtml($this->balance_packets->caption());
            if (strval($this->balance_packets->EditValue) != "" && is_numeric($this->balance_packets->EditValue)) {
                $this->balance_packets->EditValue = FormatNumber($this->balance_packets->EditValue, null);
            }

            // base_product
            $this->base_product->setupEditAttributes();
            $this->base_product->EditValue = $this->base_product->CurrentValue;
            $this->base_product->PlaceHolder = RemoveHtml($this->base_product->caption());
            if (strval($this->base_product->EditValue) != "" && is_numeric($this->base_product->EditValue)) {
                $this->base_product->EditValue = FormatNumber($this->base_product->EditValue, null);
            }

            // byproduct_1
            $this->byproduct_1->setupEditAttributes();
            $this->byproduct_1->EditValue = $this->byproduct_1->CurrentValue;
            $this->byproduct_1->PlaceHolder = RemoveHtml($this->byproduct_1->caption());
            if (strval($this->byproduct_1->EditValue) != "" && is_numeric($this->byproduct_1->EditValue)) {
                $this->byproduct_1->EditValue = FormatNumber($this->byproduct_1->EditValue, null);
            }

            // byproduct_2
            $this->byproduct_2->setupEditAttributes();
            $this->byproduct_2->EditValue = $this->byproduct_2->CurrentValue;
            $this->byproduct_2->PlaceHolder = RemoveHtml($this->byproduct_2->caption());
            if (strval($this->byproduct_2->EditValue) != "" && is_numeric($this->byproduct_2->EditValue)) {
                $this->byproduct_2->EditValue = FormatNumber($this->byproduct_2->EditValue, null);
            }

            // byproduct_3
            $this->byproduct_3->setupEditAttributes();
            $this->byproduct_3->EditValue = $this->byproduct_3->CurrentValue;
            $this->byproduct_3->PlaceHolder = RemoveHtml($this->byproduct_3->caption());
            if (strval($this->byproduct_3->EditValue) != "" && is_numeric($this->byproduct_3->EditValue)) {
                $this->byproduct_3->EditValue = FormatNumber($this->byproduct_3->EditValue, null);
            }

            // byproduct_4
            $this->byproduct_4->setupEditAttributes();
            $this->byproduct_4->EditValue = $this->byproduct_4->CurrentValue;
            $this->byproduct_4->PlaceHolder = RemoveHtml($this->byproduct_4->caption());
            if (strval($this->byproduct_4->EditValue) != "" && is_numeric($this->byproduct_4->EditValue)) {
                $this->byproduct_4->EditValue = FormatNumber($this->byproduct_4->EditValue, null);
            }

            // in_quantity
            $this->in_quantity->setupEditAttributes();
            $this->in_quantity->EditValue = $this->in_quantity->CurrentValue;
            $this->in_quantity->PlaceHolder = RemoveHtml($this->in_quantity->caption());
            if (strval($this->in_quantity->EditValue) != "" && is_numeric($this->in_quantity->EditValue)) {
                $this->in_quantity->EditValue = FormatNumber($this->in_quantity->EditValue, null);
            }

            // out_quantity
            $this->out_quantity->setupEditAttributes();
            $this->out_quantity->EditValue = $this->out_quantity->CurrentValue;
            $this->out_quantity->PlaceHolder = RemoveHtml($this->out_quantity->caption());
            if (strval($this->out_quantity->EditValue) != "" && is_numeric($this->out_quantity->EditValue)) {
                $this->out_quantity->EditValue = FormatNumber($this->out_quantity->EditValue, null);
            }

            // in_packets
            $this->in_packets->setupEditAttributes();
            $this->in_packets->EditValue = $this->in_packets->CurrentValue;
            $this->in_packets->PlaceHolder = RemoveHtml($this->in_packets->caption());
            if (strval($this->in_packets->EditValue) != "" && is_numeric($this->in_packets->EditValue)) {
                $this->in_packets->EditValue = FormatNumber($this->in_packets->EditValue, null);
            }

            // out_packets
            $this->out_packets->setupEditAttributes();
            $this->out_packets->EditValue = $this->out_packets->CurrentValue;
            $this->out_packets->PlaceHolder = RemoveHtml($this->out_packets->caption());
            if (strval($this->out_packets->EditValue) != "" && is_numeric($this->out_packets->EditValue)) {
                $this->out_packets->EditValue = FormatNumber($this->out_packets->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // Add refer script

            // ref
            $this->ref->HrefValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // lot_no
            $this->lot_no->HrefValue = "";

            // processed_at
            $this->processed_at->HrefValue = "";

            // micron
            $this->micron->HrefValue = "";

            // length
            $this->length->HrefValue = "";

            // balance_quantity
            $this->balance_quantity->HrefValue = "";

            // balance_packets
            $this->balance_packets->HrefValue = "";

            // base_product
            $this->base_product->HrefValue = "";

            // byproduct_1
            $this->byproduct_1->HrefValue = "";

            // byproduct_2
            $this->byproduct_2->HrefValue = "";

            // byproduct_3
            $this->byproduct_3->HrefValue = "";

            // byproduct_4
            $this->byproduct_4->HrefValue = "";

            // in_quantity
            $this->in_quantity->HrefValue = "";

            // out_quantity
            $this->out_quantity->HrefValue = "";

            // in_packets
            $this->in_packets->HrefValue = "";

            // out_packets
            $this->out_packets->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ref->FormValue)) {
                $this->ref->addErrorMessage($this->ref->getErrorMessage(false));
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->processed_at->Visible && $this->processed_at->Required) {
                if (!$this->processed_at->IsDetailKey && EmptyValue($this->processed_at->FormValue)) {
                    $this->processed_at->addErrorMessage(str_replace("%s", $this->processed_at->caption(), $this->processed_at->RequiredErrorMessage));
                }
            }
            if ($this->micron->Visible && $this->micron->Required) {
                if (!$this->micron->IsDetailKey && EmptyValue($this->micron->FormValue)) {
                    $this->micron->addErrorMessage(str_replace("%s", $this->micron->caption(), $this->micron->RequiredErrorMessage));
                }
            }
            if ($this->length->Visible && $this->length->Required) {
                if (!$this->length->IsDetailKey && EmptyValue($this->length->FormValue)) {
                    $this->length->addErrorMessage(str_replace("%s", $this->length->caption(), $this->length->RequiredErrorMessage));
                }
            }
            if ($this->balance_quantity->Visible && $this->balance_quantity->Required) {
                if (!$this->balance_quantity->IsDetailKey && EmptyValue($this->balance_quantity->FormValue)) {
                    $this->balance_quantity->addErrorMessage(str_replace("%s", $this->balance_quantity->caption(), $this->balance_quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->balance_quantity->FormValue)) {
                $this->balance_quantity->addErrorMessage($this->balance_quantity->getErrorMessage(false));
            }
            if ($this->balance_packets->Visible && $this->balance_packets->Required) {
                if (!$this->balance_packets->IsDetailKey && EmptyValue($this->balance_packets->FormValue)) {
                    $this->balance_packets->addErrorMessage(str_replace("%s", $this->balance_packets->caption(), $this->balance_packets->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->balance_packets->FormValue)) {
                $this->balance_packets->addErrorMessage($this->balance_packets->getErrorMessage(false));
            }
            if ($this->base_product->Visible && $this->base_product->Required) {
                if (!$this->base_product->IsDetailKey && EmptyValue($this->base_product->FormValue)) {
                    $this->base_product->addErrorMessage(str_replace("%s", $this->base_product->caption(), $this->base_product->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->base_product->FormValue)) {
                $this->base_product->addErrorMessage($this->base_product->getErrorMessage(false));
            }
            if ($this->byproduct_1->Visible && $this->byproduct_1->Required) {
                if (!$this->byproduct_1->IsDetailKey && EmptyValue($this->byproduct_1->FormValue)) {
                    $this->byproduct_1->addErrorMessage(str_replace("%s", $this->byproduct_1->caption(), $this->byproduct_1->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->byproduct_1->FormValue)) {
                $this->byproduct_1->addErrorMessage($this->byproduct_1->getErrorMessage(false));
            }
            if ($this->byproduct_2->Visible && $this->byproduct_2->Required) {
                if (!$this->byproduct_2->IsDetailKey && EmptyValue($this->byproduct_2->FormValue)) {
                    $this->byproduct_2->addErrorMessage(str_replace("%s", $this->byproduct_2->caption(), $this->byproduct_2->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->byproduct_2->FormValue)) {
                $this->byproduct_2->addErrorMessage($this->byproduct_2->getErrorMessage(false));
            }
            if ($this->byproduct_3->Visible && $this->byproduct_3->Required) {
                if (!$this->byproduct_3->IsDetailKey && EmptyValue($this->byproduct_3->FormValue)) {
                    $this->byproduct_3->addErrorMessage(str_replace("%s", $this->byproduct_3->caption(), $this->byproduct_3->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->byproduct_3->FormValue)) {
                $this->byproduct_3->addErrorMessage($this->byproduct_3->getErrorMessage(false));
            }
            if ($this->byproduct_4->Visible && $this->byproduct_4->Required) {
                if (!$this->byproduct_4->IsDetailKey && EmptyValue($this->byproduct_4->FormValue)) {
                    $this->byproduct_4->addErrorMessage(str_replace("%s", $this->byproduct_4->caption(), $this->byproduct_4->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->byproduct_4->FormValue)) {
                $this->byproduct_4->addErrorMessage($this->byproduct_4->getErrorMessage(false));
            }
            if ($this->in_quantity->Visible && $this->in_quantity->Required) {
                if (!$this->in_quantity->IsDetailKey && EmptyValue($this->in_quantity->FormValue)) {
                    $this->in_quantity->addErrorMessage(str_replace("%s", $this->in_quantity->caption(), $this->in_quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->in_quantity->FormValue)) {
                $this->in_quantity->addErrorMessage($this->in_quantity->getErrorMessage(false));
            }
            if ($this->out_quantity->Visible && $this->out_quantity->Required) {
                if (!$this->out_quantity->IsDetailKey && EmptyValue($this->out_quantity->FormValue)) {
                    $this->out_quantity->addErrorMessage(str_replace("%s", $this->out_quantity->caption(), $this->out_quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->out_quantity->FormValue)) {
                $this->out_quantity->addErrorMessage($this->out_quantity->getErrorMessage(false));
            }
            if ($this->in_packets->Visible && $this->in_packets->Required) {
                if (!$this->in_packets->IsDetailKey && EmptyValue($this->in_packets->FormValue)) {
                    $this->in_packets->addErrorMessage(str_replace("%s", $this->in_packets->caption(), $this->in_packets->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->in_packets->FormValue)) {
                $this->in_packets->addErrorMessage($this->in_packets->getErrorMessage(false));
            }
            if ($this->out_packets->Visible && $this->out_packets->Required) {
                if (!$this->out_packets->IsDetailKey && EmptyValue($this->out_packets->FormValue)) {
                    $this->out_packets->addErrorMessage(str_replace("%s", $this->out_packets->caption(), $this->out_packets->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->out_packets->FormValue)) {
                $this->out_packets->addErrorMessage($this->out_packets->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, false);

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, false);

        // processed_at
        $this->processed_at->setDbValueDef($rsnew, $this->processed_at->CurrentValue, false);

        // micron
        $this->micron->setDbValueDef($rsnew, $this->micron->CurrentValue, false);

        // length
        $this->length->setDbValueDef($rsnew, $this->length->CurrentValue, false);

        // balance_quantity
        $this->balance_quantity->setDbValueDef($rsnew, $this->balance_quantity->CurrentValue, strval($this->balance_quantity->CurrentValue) == "");

        // balance_packets
        $this->balance_packets->setDbValueDef($rsnew, $this->balance_packets->CurrentValue, strval($this->balance_packets->CurrentValue) == "");

        // base_product
        $this->base_product->setDbValueDef($rsnew, $this->base_product->CurrentValue, strval($this->base_product->CurrentValue) == "");

        // byproduct_1
        $this->byproduct_1->setDbValueDef($rsnew, $this->byproduct_1->CurrentValue, strval($this->byproduct_1->CurrentValue) == "");

        // byproduct_2
        $this->byproduct_2->setDbValueDef($rsnew, $this->byproduct_2->CurrentValue, strval($this->byproduct_2->CurrentValue) == "");

        // byproduct_3
        $this->byproduct_3->setDbValueDef($rsnew, $this->byproduct_3->CurrentValue, strval($this->byproduct_3->CurrentValue) == "");

        // byproduct_4
        $this->byproduct_4->setDbValueDef($rsnew, $this->byproduct_4->CurrentValue, strval($this->byproduct_4->CurrentValue) == "");

        // in_quantity
        $this->in_quantity->setDbValueDef($rsnew, $this->in_quantity->CurrentValue, false);

        // out_quantity
        $this->out_quantity->setDbValueDef($rsnew, $this->out_quantity->CurrentValue, strval($this->out_quantity->CurrentValue) == "");

        // in_packets
        $this->in_packets->setDbValueDef($rsnew, $this->in_packets->CurrentValue, false);

        // out_packets
        $this->out_packets->setDbValueDef($rsnew, $this->out_packets->CurrentValue, strval($this->out_packets->CurrentValue) == "");

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['ref'])) { // ref
            $this->ref->setFormValue($row['ref']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['processed_at'])) { // processed_at
            $this->processed_at->setFormValue($row['processed_at']);
        }
        if (isset($row['micron'])) { // micron
            $this->micron->setFormValue($row['micron']);
        }
        if (isset($row['length'])) { // length
            $this->length->setFormValue($row['length']);
        }
        if (isset($row['balance_quantity'])) { // balance_quantity
            $this->balance_quantity->setFormValue($row['balance_quantity']);
        }
        if (isset($row['balance_packets'])) { // balance_packets
            $this->balance_packets->setFormValue($row['balance_packets']);
        }
        if (isset($row['base_product'])) { // base_product
            $this->base_product->setFormValue($row['base_product']);
        }
        if (isset($row['byproduct_1'])) { // byproduct_1
            $this->byproduct_1->setFormValue($row['byproduct_1']);
        }
        if (isset($row['byproduct_2'])) { // byproduct_2
            $this->byproduct_2->setFormValue($row['byproduct_2']);
        }
        if (isset($row['byproduct_3'])) { // byproduct_3
            $this->byproduct_3->setFormValue($row['byproduct_3']);
        }
        if (isset($row['byproduct_4'])) { // byproduct_4
            $this->byproduct_4->setFormValue($row['byproduct_4']);
        }
        if (isset($row['in_quantity'])) { // in_quantity
            $this->in_quantity->setFormValue($row['in_quantity']);
        }
        if (isset($row['out_quantity'])) { // out_quantity
            $this->out_quantity->setFormValue($row['out_quantity']);
        }
        if (isset($row['in_packets'])) { // in_packets
            $this->in_packets->setFormValue($row['in_packets']);
        }
        if (isset($row['out_packets'])) { // out_packets
            $this->out_packets->setFormValue($row['out_packets']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lotnodetailslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lot_no":
                    break;
                case "x_processed_at":
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
