<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for lot_no_details
 */
class LotNoDetails extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $s_grp;
    public $product;
    public $ref;
    public $packing_type;
    public $lot_no;
    public $processed_at;
    public $micron;
    public $length;
    public $balance_quantity;
    public $balance_packets;
    public $base_product;
    public $byproduct_1;
    public $byproduct_2;
    public $byproduct_3;
    public $byproduct_4;
    public $in_quantity;
    public $out_quantity;
    public $in_packets;
    public $out_packets;
    public $age;
    public $remarks;
    public $dated;
    public $operator;
    public $datetime;
    public $rid;
    public $employee_id;
    public $jc_no;
    public $raw_qty;
    public $byproduct_1_in;
    public $byproduct_2_in;
    public $byproduct_3_in;
    public $byproduct_4_in;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "lot_no_details";
        $this->TableName = 'lot_no_details';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "lot_no_details";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->grp->addMethod("getDefault", fn() => ((isset($_GET["grp"])) ? $_GET["grp"] : ((isset($_COOKIE["grp"]))? $_COOKIE["grp"]:'')));
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Required = true; // Required field
        $this->grp->Sortable = false; // Allow sort
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->s_grp->addMethod("getDefault", fn() => ((isset($_GET["s_grp"])) ? $_GET["s_grp"] : ((isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:'')));
        $this->s_grp->addMethod("getLinkPrefix", fn() => "purchasellist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Required = true; // Required field
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getDefault", fn() => ((isset($_GET["product"])) ? $_GET["product"] : ((isset($_COOKIE["product"]))? $_COOKIE["product"]:'')));
        $this->product->addMethod("getLinkPrefix", fn() => "purchasellist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Required = true; // Required field
        $this->product->Sortable = false; // Allow sort
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_view2', false, 'id', ["product","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->InputTextType = "text";
        $this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ref'] = &$this->ref;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`status` =1");
        $this->packing_type->addMethod("getDefault", fn() => (isset($_COOKIE["pk"]))? $_COOKIE["pk"]:'');
        $this->packing_type->addMethod("getLinkPrefix", fn() => "purchasellist?x_packing_type=");
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Required = true; // Required field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', true, 'id', ["packing","code","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`code`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__lot_no', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->addMethod("getDefault", fn() => 'NA');
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Nullable = false; // NOT NULL field
        $this->lot_no->Required = true; // Required field
        $this->lot_no->Lookup = new Lookup($this->lot_no, 'purchase_l', true, 'lot_no', ["lot_no","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`lot_no`");
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // processed_at
        $this->processed_at = new DbField(
            $this, // Table
            'x_processed_at', // Variable name
            'processed_at', // Name
            '`processed_at`', // Expression
            '`processed_at`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`processed_at`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->processed_at->InputTextType = "text";
        $this->processed_at->Raw = true;
        $this->processed_at->setSelectMultiple(false); // Select one
        $this->processed_at->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->processed_at->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->processed_at->Lookup = new Lookup($this->processed_at, 'buyer_seller_view', true, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->processed_at->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->processed_at->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['processed_at'] = &$this->processed_at;

        // micron
        $this->micron = new DbField(
            $this, // Table
            'x_micron', // Variable name
            'micron', // Name
            '`micron`', // Expression
            '`micron`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`micron`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->micron->InputTextType = "text";
        $this->micron->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['micron'] = &$this->micron;

        // length
        $this->length = new DbField(
            $this, // Table
            'x_length', // Variable name
            'length', // Name
            '`length`', // Expression
            '`length`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`length`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->length->InputTextType = "text";
        $this->length->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['length'] = &$this->length;

        // balance_quantity
        $this->balance_quantity = new DbField(
            $this, // Table
            'x_balance_quantity', // Variable name
            'balance_quantity', // Name
            '`balance_quantity`', // Expression
            '`balance_quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`balance_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->balance_quantity->addMethod("getDefault", fn() => 0.000);
        $this->balance_quantity->InputTextType = "text";
        $this->balance_quantity->Raw = true;
        $this->balance_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->balance_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['balance_quantity'] = &$this->balance_quantity;

        // balance_packets
        $this->balance_packets = new DbField(
            $this, // Table
            'x_balance_packets', // Variable name
            'balance_packets', // Name
            '`balance_packets`', // Expression
            '`balance_packets`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`balance_packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->balance_packets->addMethod("getDefault", fn() => 0.00);
        $this->balance_packets->InputTextType = "text";
        $this->balance_packets->Raw = true;
        $this->balance_packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->balance_packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['balance_packets'] = &$this->balance_packets;

        // base_product
        $this->base_product = new DbField(
            $this, // Table
            'x_base_product', // Variable name
            'base_product', // Name
            '`base_product`', // Expression
            '`base_product`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`base_product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->base_product->addMethod("getDefault", fn() => 0.00);
        $this->base_product->InputTextType = "text";
        $this->base_product->Raw = true;
        $this->base_product->Required = true; // Required field
        $this->base_product->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->base_product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['base_product'] = &$this->base_product;

        // byproduct_1
        $this->byproduct_1 = new DbField(
            $this, // Table
            'x_byproduct_1', // Variable name
            'byproduct_1', // Name
            '`byproduct_1`', // Expression
            '`byproduct_1`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_1->addMethod("getDefault", fn() => 0.00);
        $this->byproduct_1->InputTextType = "text";
        $this->byproduct_1->Raw = true;
        $this->byproduct_1->Required = true; // Required field
        $this->byproduct_1->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_1->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['byproduct_1'] = &$this->byproduct_1;

        // byproduct_2
        $this->byproduct_2 = new DbField(
            $this, // Table
            'x_byproduct_2', // Variable name
            'byproduct_2', // Name
            '`byproduct_2`', // Expression
            '`byproduct_2`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_2->addMethod("getDefault", fn() => 0.00);
        $this->byproduct_2->InputTextType = "text";
        $this->byproduct_2->Raw = true;
        $this->byproduct_2->Required = true; // Required field
        $this->byproduct_2->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_2->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['byproduct_2'] = &$this->byproduct_2;

        // byproduct_3
        $this->byproduct_3 = new DbField(
            $this, // Table
            'x_byproduct_3', // Variable name
            'byproduct_3', // Name
            '`byproduct_3`', // Expression
            '`byproduct_3`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_3`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_3->addMethod("getDefault", fn() => 0.00);
        $this->byproduct_3->InputTextType = "text";
        $this->byproduct_3->Raw = true;
        $this->byproduct_3->Required = true; // Required field
        $this->byproduct_3->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_3->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['byproduct_3'] = &$this->byproduct_3;

        // byproduct_4
        $this->byproduct_4 = new DbField(
            $this, // Table
            'x_byproduct_4', // Variable name
            'byproduct_4', // Name
            '`byproduct_4`', // Expression
            '`byproduct_4`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_4`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_4->addMethod("getDefault", fn() => 0.00);
        $this->byproduct_4->InputTextType = "text";
        $this->byproduct_4->Raw = true;
        $this->byproduct_4->Required = true; // Required field
        $this->byproduct_4->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_4->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['byproduct_4'] = &$this->byproduct_4;

        // in_quantity
        $this->in_quantity = new DbField(
            $this, // Table
            'x_in_quantity', // Variable name
            'in_quantity', // Name
            '`in_quantity`', // Expression
            '`in_quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`in_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->in_quantity->InputTextType = "text";
        $this->in_quantity->Raw = true;
        $this->in_quantity->Nullable = false; // NOT NULL field
        $this->in_quantity->Required = true; // Required field
        $this->in_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->in_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['in_quantity'] = &$this->in_quantity;

        // out_quantity
        $this->out_quantity = new DbField(
            $this, // Table
            'x_out_quantity', // Variable name
            'out_quantity', // Name
            '`out_quantity`', // Expression
            '`out_quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`out_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->out_quantity->addMethod("getDefault", fn() => 0.000);
        $this->out_quantity->InputTextType = "text";
        $this->out_quantity->Raw = true;
        $this->out_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->out_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['out_quantity'] = &$this->out_quantity;

        // in_packets
        $this->in_packets = new DbField(
            $this, // Table
            'x_in_packets', // Variable name
            'in_packets', // Name
            '`in_packets`', // Expression
            '`in_packets`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`in_packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->in_packets->InputTextType = "text";
        $this->in_packets->Raw = true;
        $this->in_packets->Nullable = false; // NOT NULL field
        $this->in_packets->Required = true; // Required field
        $this->in_packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->in_packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['in_packets'] = &$this->in_packets;

        // out_packets
        $this->out_packets = new DbField(
            $this, // Table
            'x_out_packets', // Variable name
            'out_packets', // Name
            '`out_packets`', // Expression
            '`out_packets`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`out_packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->out_packets->addMethod("getDefault", fn() => 0.00);
        $this->out_packets->InputTextType = "text";
        $this->out_packets->Raw = true;
        $this->out_packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->out_packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['out_packets'] = &$this->out_packets;

        // age
        $this->age = new DbField(
            $this, // Table
            'x_age', // Variable name
            'age', // Name
            '`age`', // Expression
            '`age`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->age->InputTextType = "text";
        $this->age->Raw = true;
        $this->age->Sortable = false; // Allow sort
        $this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['age'] = &$this->age;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->Required = true; // Required field
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dated'] = &$this->dated;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getSelectFilter", fn() => "`activated` = 1");
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Sortable = false; // Allow sort
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Sortable = false; // Allow sort
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Sortable = false; // Allow sort
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // employee_id
        $this->employee_id = new DbField(
            $this, // Table
            'x_employee_id', // Variable name
            'employee_id', // Name
            '`employee_id`', // Expression
            '`employee_id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->employee_id->InputTextType = "text";
        $this->employee_id->Raw = true;
        $this->employee_id->Nullable = false; // NOT NULL field
        $this->employee_id->Required = true; // Required field
        $this->employee_id->Sortable = false; // Allow sort
        $this->employee_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->employee_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['employee_id'] = &$this->employee_id;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->addMethod("getDefault", fn() => 0);
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->Sortable = false; // Allow sort
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // raw_qty
        $this->raw_qty = new DbField(
            $this, // Table
            'x_raw_qty', // Variable name
            'raw_qty', // Name
            '`raw_qty`', // Expression
            '`raw_qty`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`raw_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->raw_qty->addMethod("getDefault", fn() => 0.000);
        $this->raw_qty->InputTextType = "text";
        $this->raw_qty->Raw = true;
        $this->raw_qty->Sortable = false; // Allow sort
        $this->raw_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->raw_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['raw_qty'] = &$this->raw_qty;

        // byproduct_1_in
        $this->byproduct_1_in = new DbField(
            $this, // Table
            'x_byproduct_1_in', // Variable name
            'byproduct_1_in', // Name
            '`byproduct_1_in`', // Expression
            '`byproduct_1_in`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_1_in`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_1_in->addMethod("getDefault", fn() => 0.000);
        $this->byproduct_1_in->InputTextType = "text";
        $this->byproduct_1_in->Raw = true;
        $this->byproduct_1_in->Nullable = false; // NOT NULL field
        $this->byproduct_1_in->Sortable = false; // Allow sort
        $this->byproduct_1_in->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_1_in->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['byproduct_1_in'] = &$this->byproduct_1_in;

        // byproduct_2_in
        $this->byproduct_2_in = new DbField(
            $this, // Table
            'x_byproduct_2_in', // Variable name
            'byproduct_2_in', // Name
            '`byproduct_2_in`', // Expression
            '`byproduct_2_in`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_2_in`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_2_in->addMethod("getDefault", fn() => 0.000);
        $this->byproduct_2_in->InputTextType = "text";
        $this->byproduct_2_in->Raw = true;
        $this->byproduct_2_in->Nullable = false; // NOT NULL field
        $this->byproduct_2_in->Sortable = false; // Allow sort
        $this->byproduct_2_in->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_2_in->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['byproduct_2_in'] = &$this->byproduct_2_in;

        // byproduct_3_in
        $this->byproduct_3_in = new DbField(
            $this, // Table
            'x_byproduct_3_in', // Variable name
            'byproduct_3_in', // Name
            '`byproduct_3_in`', // Expression
            '`byproduct_3_in`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_3_in`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_3_in->addMethod("getDefault", fn() => 0.000);
        $this->byproduct_3_in->InputTextType = "text";
        $this->byproduct_3_in->Raw = true;
        $this->byproduct_3_in->Nullable = false; // NOT NULL field
        $this->byproduct_3_in->Sortable = false; // Allow sort
        $this->byproduct_3_in->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_3_in->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['byproduct_3_in'] = &$this->byproduct_3_in;

        // byproduct_4_in
        $this->byproduct_4_in = new DbField(
            $this, // Table
            'x_byproduct_4_in', // Variable name
            'byproduct_4_in', // Name
            '`byproduct_4_in`', // Expression
            '`byproduct_4_in`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`byproduct_4_in`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->byproduct_4_in->addMethod("getDefault", fn() => 0.000);
        $this->byproduct_4_in->InputTextType = "text";
        $this->byproduct_4_in->Raw = true;
        $this->byproduct_4_in->Nullable = false; // NOT NULL field
        $this->byproduct_4_in->Sortable = false; // Allow sort
        $this->byproduct_4_in->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->byproduct_4_in->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['byproduct_4_in'] = &$this->byproduct_4_in;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "lot_no_details";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT DISTINCT `lot_no` FROM purchase_l TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.lot_no = lot_no_details.lot_no LIMIT 1) AS EV__lot_no FROM lot_no_details)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->lot_no->AdvancedSearch->SearchValue != "" ||
            $this->lot_no->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->lot_no->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->lot_no->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->ref->DbValue = $row['ref'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->processed_at->DbValue = $row['processed_at'];
        $this->micron->DbValue = $row['micron'];
        $this->length->DbValue = $row['length'];
        $this->balance_quantity->DbValue = $row['balance_quantity'];
        $this->balance_packets->DbValue = $row['balance_packets'];
        $this->base_product->DbValue = $row['base_product'];
        $this->byproduct_1->DbValue = $row['byproduct_1'];
        $this->byproduct_2->DbValue = $row['byproduct_2'];
        $this->byproduct_3->DbValue = $row['byproduct_3'];
        $this->byproduct_4->DbValue = $row['byproduct_4'];
        $this->in_quantity->DbValue = $row['in_quantity'];
        $this->out_quantity->DbValue = $row['out_quantity'];
        $this->in_packets->DbValue = $row['in_packets'];
        $this->out_packets->DbValue = $row['out_packets'];
        $this->age->DbValue = $row['age'];
        $this->remarks->DbValue = $row['remarks'];
        $this->dated->DbValue = $row['dated'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->rid->DbValue = $row['rid'];
        $this->employee_id->DbValue = $row['employee_id'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->raw_qty->DbValue = $row['raw_qty'];
        $this->byproduct_1_in->DbValue = $row['byproduct_1_in'];
        $this->byproduct_2_in->DbValue = $row['byproduct_2_in'];
        $this->byproduct_3_in->DbValue = $row['byproduct_3_in'];
        $this->byproduct_4_in->DbValue = $row['byproduct_4_in'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("lotnodetailslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "lotnodetailsview" => $Language->phrase("View"),
            "lotnodetailsedit" => $Language->phrase("Edit"),
            "lotnodetailsadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "lotnodetailslist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "LotNoDetailsView",
            Config("API_ADD_ACTION") => "LotNoDetailsAdd",
            Config("API_EDIT_ACTION") => "LotNoDetailsEdit",
            Config("API_DELETE_ACTION") => "LotNoDetailsDelete",
            Config("API_LIST_ACTION") => "LotNoDetailsList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "lotnodetailslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("lotnodetailsview", $parm);
        } else {
            $url = $this->keyUrl("lotnodetailsview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "lotnodetailsadd?" . $parm;
        } else {
            $url = "lotnodetailsadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("lotnodetailsedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("lotnodetailslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("lotnodetailsadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("lotnodetailslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("lotnodetailsdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->ref->setDbValue($row['ref']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->processed_at->setDbValue($row['processed_at']);
        $this->micron->setDbValue($row['micron']);
        $this->length->setDbValue($row['length']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->balance_packets->setDbValue($row['balance_packets']);
        $this->base_product->setDbValue($row['base_product']);
        $this->byproduct_1->setDbValue($row['byproduct_1']);
        $this->byproduct_2->setDbValue($row['byproduct_2']);
        $this->byproduct_3->setDbValue($row['byproduct_3']);
        $this->byproduct_4->setDbValue($row['byproduct_4']);
        $this->in_quantity->setDbValue($row['in_quantity']);
        $this->out_quantity->setDbValue($row['out_quantity']);
        $this->in_packets->setDbValue($row['in_packets']);
        $this->out_packets->setDbValue($row['out_packets']);
        $this->age->setDbValue($row['age']);
        $this->remarks->setDbValue($row['remarks']);
        $this->dated->setDbValue($row['dated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->rid->setDbValue($row['rid']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->raw_qty->setDbValue($row['raw_qty']);
        $this->byproduct_1_in->setDbValue($row['byproduct_1_in']);
        $this->byproduct_2_in->setDbValue($row['byproduct_2_in']);
        $this->byproduct_3_in->setDbValue($row['byproduct_3_in']);
        $this->byproduct_4_in->setDbValue($row['byproduct_4_in']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "LotNoDetailsList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // ref

        // packing_type

        // lot_no

        // processed_at

        // micron

        // length

        // balance_quantity

        // balance_packets

        // base_product

        // byproduct_1

        // byproduct_2

        // byproduct_3

        // byproduct_4

        // in_quantity

        // out_quantity

        // in_packets

        // out_packets

        // age
        $this->age->CellCssStyle = "white-space: nowrap;";

        // remarks

        // dated

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // employee_id
        $this->employee_id->CellCssStyle = "white-space: nowrap;";

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // raw_qty
        $this->raw_qty->CellCssStyle = "white-space: nowrap;";

        // byproduct_1_in
        $this->byproduct_1_in->CellCssStyle = "white-space: nowrap;";

        // byproduct_2_in
        $this->byproduct_2_in->CellCssStyle = "white-space: nowrap;";

        // byproduct_3_in
        $this->byproduct_3_in->CellCssStyle = "white-space: nowrap;";

        // byproduct_4_in
        $this->byproduct_4_in->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // lot_no
        if ($this->lot_no->VirtualValue != "") {
            $this->lot_no->ViewValue = $this->lot_no->VirtualValue;
        } else {
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
            $curVal = strval($this->lot_no->CurrentValue);
            if ($curVal != "") {
                $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
                if ($this->lot_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchExpression(), "=", $curVal, $this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchDataType(), "");
                    $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lot_no->Lookup->renderViewRow($rswrk[0]);
                        $this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
                    } else {
                        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                    }
                }
            } else {
                $this->lot_no->ViewValue = null;
            }
        }

        // processed_at
        $curVal = strval($this->processed_at->CurrentValue);
        if ($curVal != "") {
            $this->processed_at->ViewValue = $this->processed_at->lookupCacheOption($curVal);
            if ($this->processed_at->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->processed_at->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->processed_at->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->processed_at->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->processed_at->Lookup->renderViewRow($rswrk[0]);
                    $this->processed_at->ViewValue = $this->processed_at->displayValue($arwrk);
                } else {
                    $this->processed_at->ViewValue = FormatNumber($this->processed_at->CurrentValue, $this->processed_at->formatPattern());
                }
            }
        } else {
            $this->processed_at->ViewValue = null;
        }

        // micron
        $this->micron->ViewValue = $this->micron->CurrentValue;

        // length
        $this->length->ViewValue = $this->length->CurrentValue;

        // balance_quantity
        $this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
        $this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, $this->balance_quantity->formatPattern());

        // balance_packets
        $this->balance_packets->ViewValue = $this->balance_packets->CurrentValue;
        $this->balance_packets->ViewValue = FormatNumber($this->balance_packets->ViewValue, $this->balance_packets->formatPattern());

        // base_product
        $this->base_product->ViewValue = $this->base_product->CurrentValue;
        $this->base_product->ViewValue = FormatNumber($this->base_product->ViewValue, $this->base_product->formatPattern());

        // byproduct_1
        $this->byproduct_1->ViewValue = $this->byproduct_1->CurrentValue;
        $this->byproduct_1->ViewValue = FormatNumber($this->byproduct_1->ViewValue, $this->byproduct_1->formatPattern());

        // byproduct_2
        $this->byproduct_2->ViewValue = $this->byproduct_2->CurrentValue;
        $this->byproduct_2->ViewValue = FormatNumber($this->byproduct_2->ViewValue, $this->byproduct_2->formatPattern());

        // byproduct_3
        $this->byproduct_3->ViewValue = $this->byproduct_3->CurrentValue;
        $this->byproduct_3->ViewValue = FormatNumber($this->byproduct_3->ViewValue, $this->byproduct_3->formatPattern());

        // byproduct_4
        $this->byproduct_4->ViewValue = $this->byproduct_4->CurrentValue;
        $this->byproduct_4->ViewValue = FormatNumber($this->byproduct_4->ViewValue, $this->byproduct_4->formatPattern());

        // in_quantity
        $this->in_quantity->ViewValue = $this->in_quantity->CurrentValue;
        $this->in_quantity->ViewValue = FormatNumber($this->in_quantity->ViewValue, $this->in_quantity->formatPattern());

        // out_quantity
        $this->out_quantity->ViewValue = $this->out_quantity->CurrentValue;
        $this->out_quantity->ViewValue = FormatNumber($this->out_quantity->ViewValue, $this->out_quantity->formatPattern());

        // in_packets
        $this->in_packets->ViewValue = $this->in_packets->CurrentValue;
        $this->in_packets->ViewValue = FormatNumber($this->in_packets->ViewValue, $this->in_packets->formatPattern());

        // out_packets
        $this->out_packets->ViewValue = $this->out_packets->CurrentValue;
        $this->out_packets->ViewValue = FormatNumber($this->out_packets->ViewValue, $this->out_packets->formatPattern());

        // age
        $this->age->ViewValue = $this->age->CurrentValue;
        $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());

        // employee_id
        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
        $this->employee_id->ViewValue = FormatNumber($this->employee_id->ViewValue, $this->employee_id->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // raw_qty
        $this->raw_qty->ViewValue = $this->raw_qty->CurrentValue;
        $this->raw_qty->ViewValue = FormatNumber($this->raw_qty->ViewValue, $this->raw_qty->formatPattern());

        // byproduct_1_in
        $this->byproduct_1_in->ViewValue = $this->byproduct_1_in->CurrentValue;
        $this->byproduct_1_in->ViewValue = FormatNumber($this->byproduct_1_in->ViewValue, $this->byproduct_1_in->formatPattern());

        // byproduct_2_in
        $this->byproduct_2_in->ViewValue = $this->byproduct_2_in->CurrentValue;
        $this->byproduct_2_in->ViewValue = FormatNumber($this->byproduct_2_in->ViewValue, $this->byproduct_2_in->formatPattern());

        // byproduct_3_in
        $this->byproduct_3_in->ViewValue = $this->byproduct_3_in->CurrentValue;
        $this->byproduct_3_in->ViewValue = FormatNumber($this->byproduct_3_in->ViewValue, $this->byproduct_3_in->formatPattern());

        // byproduct_4_in
        $this->byproduct_4_in->ViewValue = $this->byproduct_4_in->CurrentValue;
        $this->byproduct_4_in->ViewValue = FormatNumber($this->byproduct_4_in->ViewValue, $this->byproduct_4_in->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // packing_type
        if (!EmptyValue($this->packing_type->CurrentValue)) {
            $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
            $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
            }
        } else {
            $this->packing_type->HrefValue = "";
        }
        $this->packing_type->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // processed_at
        $this->processed_at->HrefValue = "";
        $this->processed_at->TooltipValue = "";

        // micron
        $this->micron->HrefValue = "";
        $this->micron->TooltipValue = "";

        // length
        $this->length->HrefValue = "";
        $this->length->TooltipValue = "";

        // balance_quantity
        $this->balance_quantity->HrefValue = "";
        $this->balance_quantity->TooltipValue = "";

        // balance_packets
        $this->balance_packets->HrefValue = "";
        $this->balance_packets->TooltipValue = "";

        // base_product
        $this->base_product->HrefValue = "";
        $this->base_product->TooltipValue = "";

        // byproduct_1
        $this->byproduct_1->HrefValue = "";
        $this->byproduct_1->TooltipValue = "";

        // byproduct_2
        $this->byproduct_2->HrefValue = "";
        $this->byproduct_2->TooltipValue = "";

        // byproduct_3
        $this->byproduct_3->HrefValue = "";
        $this->byproduct_3->TooltipValue = "";

        // byproduct_4
        $this->byproduct_4->HrefValue = "";
        $this->byproduct_4->TooltipValue = "";

        // in_quantity
        $this->in_quantity->HrefValue = "";
        $this->in_quantity->TooltipValue = "";

        // out_quantity
        $this->out_quantity->HrefValue = "";
        $this->out_quantity->TooltipValue = "";

        // in_packets
        $this->in_packets->HrefValue = "";
        $this->in_packets->TooltipValue = "";

        // out_packets
        $this->out_packets->HrefValue = "";
        $this->out_packets->TooltipValue = "";

        // age
        $this->age->HrefValue = "";
        $this->age->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // dated
        $this->dated->HrefValue = "";
        $this->dated->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // employee_id
        $this->employee_id->HrefValue = "";
        $this->employee_id->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // raw_qty
        $this->raw_qty->HrefValue = "";
        $this->raw_qty->TooltipValue = "";

        // byproduct_1_in
        $this->byproduct_1_in->HrefValue = "";
        $this->byproduct_1_in->TooltipValue = "";

        // byproduct_2_in
        $this->byproduct_2_in->HrefValue = "";
        $this->byproduct_2_in->TooltipValue = "";

        // byproduct_3_in
        $this->byproduct_3_in->HrefValue = "";
        $this->byproduct_3_in->TooltipValue = "";

        // byproduct_4_in
        $this->byproduct_4_in->HrefValue = "";
        $this->byproduct_4_in->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // ref
        $this->ref->setupEditAttributes();
        if (!$this->ref->Raw) {
            $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
        }
        $this->ref->EditValue = $this->ref->CurrentValue;
        $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // lot_no
        $this->lot_no->setupEditAttributes();
        if (!$this->lot_no->Raw) {
            $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
        }
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

        // processed_at
        $this->processed_at->setupEditAttributes();
        $this->processed_at->PlaceHolder = RemoveHtml($this->processed_at->caption());

        // micron
        $this->micron->setupEditAttributes();
        if (!$this->micron->Raw) {
            $this->micron->CurrentValue = HtmlDecode($this->micron->CurrentValue);
        }
        $this->micron->EditValue = $this->micron->CurrentValue;
        $this->micron->PlaceHolder = RemoveHtml($this->micron->caption());

        // length
        $this->length->setupEditAttributes();
        if (!$this->length->Raw) {
            $this->length->CurrentValue = HtmlDecode($this->length->CurrentValue);
        }
        $this->length->EditValue = $this->length->CurrentValue;
        $this->length->PlaceHolder = RemoveHtml($this->length->caption());

        // balance_quantity
        $this->balance_quantity->setupEditAttributes();
        $this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
        $this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
        if (strval($this->balance_quantity->EditValue) != "" && is_numeric($this->balance_quantity->EditValue)) {
            $this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, null);
        }

        // balance_packets
        $this->balance_packets->setupEditAttributes();
        $this->balance_packets->EditValue = $this->balance_packets->CurrentValue;
        $this->balance_packets->PlaceHolder = RemoveHtml($this->balance_packets->caption());
        if (strval($this->balance_packets->EditValue) != "" && is_numeric($this->balance_packets->EditValue)) {
            $this->balance_packets->EditValue = FormatNumber($this->balance_packets->EditValue, null);
        }

        // base_product
        $this->base_product->setupEditAttributes();
        $this->base_product->EditValue = $this->base_product->CurrentValue;
        $this->base_product->PlaceHolder = RemoveHtml($this->base_product->caption());
        if (strval($this->base_product->EditValue) != "" && is_numeric($this->base_product->EditValue)) {
            $this->base_product->EditValue = FormatNumber($this->base_product->EditValue, null);
        }

        // byproduct_1
        $this->byproduct_1->setupEditAttributes();
        $this->byproduct_1->EditValue = $this->byproduct_1->CurrentValue;
        $this->byproduct_1->PlaceHolder = RemoveHtml($this->byproduct_1->caption());
        if (strval($this->byproduct_1->EditValue) != "" && is_numeric($this->byproduct_1->EditValue)) {
            $this->byproduct_1->EditValue = FormatNumber($this->byproduct_1->EditValue, null);
        }

        // byproduct_2
        $this->byproduct_2->setupEditAttributes();
        $this->byproduct_2->EditValue = $this->byproduct_2->CurrentValue;
        $this->byproduct_2->PlaceHolder = RemoveHtml($this->byproduct_2->caption());
        if (strval($this->byproduct_2->EditValue) != "" && is_numeric($this->byproduct_2->EditValue)) {
            $this->byproduct_2->EditValue = FormatNumber($this->byproduct_2->EditValue, null);
        }

        // byproduct_3
        $this->byproduct_3->setupEditAttributes();
        $this->byproduct_3->EditValue = $this->byproduct_3->CurrentValue;
        $this->byproduct_3->PlaceHolder = RemoveHtml($this->byproduct_3->caption());
        if (strval($this->byproduct_3->EditValue) != "" && is_numeric($this->byproduct_3->EditValue)) {
            $this->byproduct_3->EditValue = FormatNumber($this->byproduct_3->EditValue, null);
        }

        // byproduct_4
        $this->byproduct_4->setupEditAttributes();
        $this->byproduct_4->EditValue = $this->byproduct_4->CurrentValue;
        $this->byproduct_4->PlaceHolder = RemoveHtml($this->byproduct_4->caption());
        if (strval($this->byproduct_4->EditValue) != "" && is_numeric($this->byproduct_4->EditValue)) {
            $this->byproduct_4->EditValue = FormatNumber($this->byproduct_4->EditValue, null);
        }

        // in_quantity
        $this->in_quantity->setupEditAttributes();
        $this->in_quantity->EditValue = $this->in_quantity->CurrentValue;
        $this->in_quantity->PlaceHolder = RemoveHtml($this->in_quantity->caption());
        if (strval($this->in_quantity->EditValue) != "" && is_numeric($this->in_quantity->EditValue)) {
            $this->in_quantity->EditValue = FormatNumber($this->in_quantity->EditValue, null);
        }

        // out_quantity
        $this->out_quantity->setupEditAttributes();
        $this->out_quantity->EditValue = $this->out_quantity->CurrentValue;
        $this->out_quantity->PlaceHolder = RemoveHtml($this->out_quantity->caption());
        if (strval($this->out_quantity->EditValue) != "" && is_numeric($this->out_quantity->EditValue)) {
            $this->out_quantity->EditValue = FormatNumber($this->out_quantity->EditValue, null);
        }

        // in_packets
        $this->in_packets->setupEditAttributes();
        $this->in_packets->EditValue = $this->in_packets->CurrentValue;
        $this->in_packets->PlaceHolder = RemoveHtml($this->in_packets->caption());
        if (strval($this->in_packets->EditValue) != "" && is_numeric($this->in_packets->EditValue)) {
            $this->in_packets->EditValue = FormatNumber($this->in_packets->EditValue, null);
        }

        // out_packets
        $this->out_packets->setupEditAttributes();
        $this->out_packets->EditValue = $this->out_packets->CurrentValue;
        $this->out_packets->PlaceHolder = RemoveHtml($this->out_packets->caption());
        if (strval($this->out_packets->EditValue) != "" && is_numeric($this->out_packets->EditValue)) {
            $this->out_packets->EditValue = FormatNumber($this->out_packets->EditValue, null);
        }

        // age
        $this->age->setupEditAttributes();
        $this->age->EditValue = $this->age->CurrentValue;
        $this->age->PlaceHolder = RemoveHtml($this->age->caption());
        if (strval($this->age->EditValue) != "" && is_numeric($this->age->EditValue)) {
            $this->age->EditValue = FormatNumber($this->age->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // dated
        $this->dated->setupEditAttributes();
        $this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

        // operator

        // datetime

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
        if (strval($this->rid->EditValue) != "" && is_numeric($this->rid->EditValue)) {
            $this->rid->EditValue = FormatNumber($this->rid->EditValue, null);
        }

        // employee_id
        $this->employee_id->setupEditAttributes();
        $this->employee_id->EditValue = $this->employee_id->CurrentValue;
        $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());
        if (strval($this->employee_id->EditValue) != "" && is_numeric($this->employee_id->EditValue)) {
            $this->employee_id->EditValue = FormatNumber($this->employee_id->EditValue, null);
        }

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // raw_qty
        $this->raw_qty->setupEditAttributes();
        $this->raw_qty->EditValue = $this->raw_qty->CurrentValue;
        $this->raw_qty->PlaceHolder = RemoveHtml($this->raw_qty->caption());
        if (strval($this->raw_qty->EditValue) != "" && is_numeric($this->raw_qty->EditValue)) {
            $this->raw_qty->EditValue = FormatNumber($this->raw_qty->EditValue, null);
        }

        // byproduct_1_in
        $this->byproduct_1_in->setupEditAttributes();
        $this->byproduct_1_in->EditValue = $this->byproduct_1_in->CurrentValue;
        $this->byproduct_1_in->PlaceHolder = RemoveHtml($this->byproduct_1_in->caption());
        if (strval($this->byproduct_1_in->EditValue) != "" && is_numeric($this->byproduct_1_in->EditValue)) {
            $this->byproduct_1_in->EditValue = FormatNumber($this->byproduct_1_in->EditValue, null);
        }

        // byproduct_2_in
        $this->byproduct_2_in->setupEditAttributes();
        $this->byproduct_2_in->EditValue = $this->byproduct_2_in->CurrentValue;
        $this->byproduct_2_in->PlaceHolder = RemoveHtml($this->byproduct_2_in->caption());
        if (strval($this->byproduct_2_in->EditValue) != "" && is_numeric($this->byproduct_2_in->EditValue)) {
            $this->byproduct_2_in->EditValue = FormatNumber($this->byproduct_2_in->EditValue, null);
        }

        // byproduct_3_in
        $this->byproduct_3_in->setupEditAttributes();
        $this->byproduct_3_in->EditValue = $this->byproduct_3_in->CurrentValue;
        $this->byproduct_3_in->PlaceHolder = RemoveHtml($this->byproduct_3_in->caption());
        if (strval($this->byproduct_3_in->EditValue) != "" && is_numeric($this->byproduct_3_in->EditValue)) {
            $this->byproduct_3_in->EditValue = FormatNumber($this->byproduct_3_in->EditValue, null);
        }

        // byproduct_4_in
        $this->byproduct_4_in->setupEditAttributes();
        $this->byproduct_4_in->EditValue = $this->byproduct_4_in->CurrentValue;
        $this->byproduct_4_in->PlaceHolder = RemoveHtml($this->byproduct_4_in->caption());
        if (strval($this->byproduct_4_in->EditValue) != "" && is_numeric($this->byproduct_4_in->EditValue)) {
            $this->byproduct_4_in->EditValue = FormatNumber($this->byproduct_4_in->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->processed_at);
                    $doc->exportCaption($this->micron);
                    $doc->exportCaption($this->length);
                    $doc->exportCaption($this->balance_quantity);
                    $doc->exportCaption($this->balance_packets);
                    $doc->exportCaption($this->base_product);
                    $doc->exportCaption($this->byproduct_1);
                    $doc->exportCaption($this->byproduct_2);
                    $doc->exportCaption($this->byproduct_3);
                    $doc->exportCaption($this->byproduct_4);
                    $doc->exportCaption($this->in_quantity);
                    $doc->exportCaption($this->out_quantity);
                    $doc->exportCaption($this->in_packets);
                    $doc->exportCaption($this->out_packets);
                    $doc->exportCaption($this->age);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->byproduct_1_in);
                    $doc->exportCaption($this->byproduct_2_in);
                    $doc->exportCaption($this->byproduct_3_in);
                    $doc->exportCaption($this->byproduct_4_in);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->processed_at);
                    $doc->exportCaption($this->micron);
                    $doc->exportCaption($this->length);
                    $doc->exportCaption($this->balance_quantity);
                    $doc->exportCaption($this->balance_packets);
                    $doc->exportCaption($this->base_product);
                    $doc->exportCaption($this->byproduct_1);
                    $doc->exportCaption($this->byproduct_2);
                    $doc->exportCaption($this->byproduct_3);
                    $doc->exportCaption($this->byproduct_4);
                    $doc->exportCaption($this->in_quantity);
                    $doc->exportCaption($this->out_quantity);
                    $doc->exportCaption($this->in_packets);
                    $doc->exportCaption($this->out_packets);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->dated);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->processed_at);
                        $doc->exportField($this->micron);
                        $doc->exportField($this->length);
                        $doc->exportField($this->balance_quantity);
                        $doc->exportField($this->balance_packets);
                        $doc->exportField($this->base_product);
                        $doc->exportField($this->byproduct_1);
                        $doc->exportField($this->byproduct_2);
                        $doc->exportField($this->byproduct_3);
                        $doc->exportField($this->byproduct_4);
                        $doc->exportField($this->in_quantity);
                        $doc->exportField($this->out_quantity);
                        $doc->exportField($this->in_packets);
                        $doc->exportField($this->out_packets);
                        $doc->exportField($this->age);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->byproduct_1_in);
                        $doc->exportField($this->byproduct_2_in);
                        $doc->exportField($this->byproduct_3_in);
                        $doc->exportField($this->byproduct_4_in);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->processed_at);
                        $doc->exportField($this->micron);
                        $doc->exportField($this->length);
                        $doc->exportField($this->balance_quantity);
                        $doc->exportField($this->balance_packets);
                        $doc->exportField($this->base_product);
                        $doc->exportField($this->byproduct_1);
                        $doc->exportField($this->byproduct_2);
                        $doc->exportField($this->byproduct_3);
                        $doc->exportField($this->byproduct_4);
                        $doc->exportField($this->in_quantity);
                        $doc->exportField($this->out_quantity);
                        $doc->exportField($this->in_packets);
                        $doc->exportField($this->out_packets);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->dated);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
