<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for ledger
 */
class Ledger extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $uid;
    public $dated;
    public $ref_account;
    public $Balance;
    public $cumulative_sum;
    public $type;
    public $remarks;
    public $r_from;
    public $name;
    public $ref;
    public $uploads;
    public $id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "ledger";
        $this->TableName = 'ledger';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "ledger";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'NO' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Raw = true;
        $this->uid->IsAutoIncrement = true; // Autoincrement field
        $this->uid->IsPrimaryKey = true; // Primary key field
        $this->uid->Nullable = false; // NOT NULL field
        $this->uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['uid'] = &$this->uid;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->addMethod("getDefault", fn() => "0000-00-00");
        $this->dated->addMethod("getLinkPrefix", fn() => "ledgerlist?x_dated=");
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->Nullable = false; // NOT NULL field
        $this->dated->Required = true; // Required field
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['dated'] = &$this->dated;

        // ref_account
        $this->ref_account = new DbField(
            $this, // Table
            'x_ref_account', // Variable name
            'ref_account', // Name
            '`ref_account`', // Expression
            '`ref_account`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref_account`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ref_account->addMethod("getLinkPrefix", fn() => "ledgerlist?ID=");
        $this->ref_account->InputTextType = "text";
        $this->ref_account->Raw = true;
        $this->ref_account->setSelectMultiple(false); // Select one
        $this->ref_account->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ref_account->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ref_account->Lookup = new Lookup($this->ref_account, 'buyer_seller_employee', false, 'id', ["name","id","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->ref_account) . "',COALESCE(`id`,''))");
        $this->ref_account->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ref_account->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ref_account'] = &$this->ref_account;

        // Balance
        $this->Balance = new DbField(
            $this, // Table
            'x_Balance', // Variable name
            'Balance', // Name
            '`Balance`', // Expression
            '`Balance`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Balance->InputTextType = "text";
        $this->Balance->Raw = true;
        $this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Balance'] = &$this->Balance;

        // cumulative_sum
        $this->cumulative_sum = new DbField(
            $this, // Table
            'x_cumulative_sum', // Variable name
            'cumulative_sum', // Name
            '`cumulative_sum`', // Expression
            '`cumulative_sum`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cumulative_sum`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cumulative_sum->InputTextType = "text";
        $this->cumulative_sum->Raw = true;
        $this->cumulative_sum->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cumulative_sum->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cumulative_sum'] = &$this->cumulative_sum;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->type->addMethod("getDefault", fn() => 0);
        $this->type->addMethod("getLinkPrefix", fn() => "ledgerlist?x_type=");
        $this->type->InputTextType = "text";
        $this->type->Nullable = false; // NOT NULL field
        $this->type->Required = true; // Required field
        $this->type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['type'] = &$this->type;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // r_from
        $this->r_from = new DbField(
            $this, // Table
            'x_r_from', // Variable name
            'r_from', // Name
            '`r_from`', // Expression
            '`r_from`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_from`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_from->InputTextType = "text";
        $this->r_from->Raw = true;
        $this->r_from->Sortable = false; // Allow sort
        $this->r_from->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->r_from->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_from'] = &$this->r_from;

        // name
        $this->name = new DbField(
            $this, // Table
            'x_name', // Variable name
            'name', // Name
            '`name`', // Expression
            '`name`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->name->addMethod("getLinkPrefix", fn() => "ledgerlist?x_r_from=");
        $this->name->InputTextType = "text";
        $this->name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['name'] = &$this->name;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->addMethod("getLinkPrefix", fn() => "ledgerlist?x_ref=");
        $this->ref->addMethod("getLinkSuffix", fn() => "&z_ref=LIKE&cmd=search");
        $this->ref->InputTextType = "text";
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ref'] = &$this->ref;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->addMethod("getUploadPath", fn() => '.p_uploads/account_info/' . $this->type->CurrentValue . '/');
        $this->uploads->InputTextType = "text";
        $this->uploads->ImageResize = true;
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->addMethod("getDefault", fn() => 0);
        $this->id->InputTextType = "text";
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "ledger";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (CurrentUserLevel() == 999) ? "FIND_IN_SET(`r_from`, '" . getAccountAadhaar() . "') and `Balance` != 0" : "`Balance` != 0";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->uid->setDbValue($conn->lastInsertId());
            $rs['uid'] = $this->uid->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['uid']) && !EmptyValue($this->uid->CurrentValue)) {
                $rs['uid'] = $this->uid->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('uid', $rs)) {
                AddFilter($where, QuotedName('uid', $this->Dbid) . '=' . QuotedValue($rs['uid'], $this->uid->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->uid->DbValue = $row['uid'];
        $this->dated->DbValue = $row['dated'];
        $this->ref_account->DbValue = $row['ref_account'];
        $this->Balance->DbValue = $row['Balance'];
        $this->cumulative_sum->DbValue = $row['cumulative_sum'];
        $this->type->DbValue = $row['type'];
        $this->remarks->DbValue = $row['remarks'];
        $this->r_from->DbValue = $row['r_from'];
        $this->name->DbValue = $row['name'];
        $this->ref->DbValue = $row['ref'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->id->DbValue = $row['id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`uid` = @uid@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->uid->CurrentValue : $this->uid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->uid->CurrentValue = $keys[0];
            } else {
                $this->uid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('uid', $row) ? $row['uid'] : null;
        } else {
            $val = !EmptyValue($this->uid->OldValue) && !$current ? $this->uid->OldValue : $this->uid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@uid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ledgerlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ledgerview" => $Language->phrase("View"),
            "ledgeredit" => $Language->phrase("Edit"),
            "ledgeradd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ledgerlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "LedgerView",
            Config("API_ADD_ACTION") => "LedgerAdd",
            Config("API_EDIT_ACTION") => "LedgerEdit",
            Config("API_DELETE_ACTION") => "LedgerDelete",
            Config("API_LIST_ACTION") => "LedgerList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ledgerlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ledgerview", $parm);
        } else {
            $url = $this->keyUrl("ledgerview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ledgeradd?" . $parm;
        } else {
            $url = "ledgeradd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ledgeredit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ledgerlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ledgeradd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ledgerlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ledgerdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"uid\":" . VarToJson($this->uid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->uid->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->uid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("uid") ?? Route("uid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->uid->CurrentValue = $key;
            } else {
                $this->uid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->uid->setDbValue($row['uid']);
        $this->dated->setDbValue($row['dated']);
        $this->ref_account->setDbValue($row['ref_account']);
        $this->Balance->setDbValue($row['Balance']);
        $this->cumulative_sum->setDbValue($row['cumulative_sum']);
        $this->type->setDbValue($row['type']);
        $this->remarks->setDbValue($row['remarks']);
        $this->r_from->setDbValue($row['r_from']);
        $this->name->setDbValue($row['name']);
        $this->ref->setDbValue($row['ref']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->id->setDbValue($row['id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "LedgerList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // uid

        // dated

        // ref_account

        // Balance

        // cumulative_sum

        // type

        // remarks

        // r_from
        $this->r_from->CellCssStyle = "white-space: nowrap;";

        // name

        // ref

        // uploads

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // ref_account
        $curVal = strval($this->ref_account->CurrentValue);
        if ($curVal != "") {
            $this->ref_account->ViewValue = $this->ref_account->lookupCacheOption($curVal);
            if ($this->ref_account->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ref_account->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ref_account->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->ref_account->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ref_account->Lookup->renderViewRow($rswrk[0]);
                    $this->ref_account->ViewValue = $this->ref_account->displayValue($arwrk);
                } else {
                    $this->ref_account->ViewValue = FormatNumber($this->ref_account->CurrentValue, $this->ref_account->formatPattern());
                }
            }
        } else {
            $this->ref_account->ViewValue = null;
        }

        // Balance
        $this->Balance->ViewValue = $this->Balance->CurrentValue;
        $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());

        // cumulative_sum
        $this->cumulative_sum->ViewValue = $this->cumulative_sum->CurrentValue;
        $this->cumulative_sum->ViewValue = FormatNumber($this->cumulative_sum->ViewValue, $this->cumulative_sum->formatPattern());

        // type
        $this->type->ViewValue = $this->type->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // r_from
        $this->r_from->ViewValue = $this->r_from->CurrentValue;
        $this->r_from->ViewValue = FormatNumber($this->r_from->ViewValue, $this->r_from->formatPattern());

        // name
        $this->name->ViewValue = $this->name->CurrentValue;

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // dated
        if (!EmptyValue($this->dated->CurrentValue)) {
            $this->dated->HrefValue = $this->dated->getLinkPrefix() . $this->dated->CurrentValue; // Add prefix/suffix
            $this->dated->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->dated->HrefValue = FullUrl($this->dated->HrefValue, "href");
            }
        } else {
            $this->dated->HrefValue = "";
        }
        $this->dated->TooltipValue = "";

        // ref_account
        if (!EmptyValue($this->ref_account->CurrentValue)) {
            $this->ref_account->HrefValue = $this->ref_account->getLinkPrefix() . $this->ref_account->CurrentValue; // Add prefix/suffix
            $this->ref_account->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->ref_account->HrefValue = FullUrl($this->ref_account->HrefValue, "href");
            }
        } else {
            $this->ref_account->HrefValue = "";
        }
        $this->ref_account->TooltipValue = "";

        // Balance
        $this->Balance->HrefValue = "";
        $this->Balance->TooltipValue = "";

        // cumulative_sum
        $this->cumulative_sum->HrefValue = "";
        $this->cumulative_sum->TooltipValue = "";

        // type
        if (!EmptyValue($this->type->CurrentValue)) {
            $this->type->HrefValue = $this->type->getLinkPrefix() . $this->type->CurrentValue; // Add prefix/suffix
            $this->type->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
            }
        } else {
            $this->type->HrefValue = "";
        }
        $this->type->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // r_from
        $this->r_from->HrefValue = "";
        $this->r_from->TooltipValue = "";

        // name
        if (!EmptyValue($this->r_from->CurrentValue)) {
            $this->name->HrefValue = $this->name->getLinkPrefix() . $this->r_from->CurrentValue; // Add prefix/suffix
            $this->name->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->name->HrefValue = FullUrl($this->name->HrefValue, "href");
            }
        } else {
            $this->name->HrefValue = "";
        }
        $this->name->TooltipValue = "";

        // ref
        if (!EmptyValue($this->ref->CurrentValue)) {
            $this->ref->HrefValue = $this->ref->getLinkPrefix() . (!empty($this->ref->ViewValue) && !is_array($this->ref->ViewValue) ? RemoveHtml($this->ref->ViewValue) : $this->ref->CurrentValue) . $this->ref->getLinkSuffix(); // Add prefix/suffix
            $this->ref->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
            }
        } else {
            $this->ref->HrefValue = "";
        }
        $this->ref->TooltipValue = "";

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = "%u"; // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "ledger_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // uid
        $this->uid->setupEditAttributes();
        $this->uid->EditValue = $this->uid->CurrentValue;

        // dated
        $this->dated->setupEditAttributes();
        $this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

        // ref_account
        $this->ref_account->setupEditAttributes();
        $this->ref_account->PlaceHolder = RemoveHtml($this->ref_account->caption());

        // Balance
        $this->Balance->setupEditAttributes();
        $this->Balance->EditValue = $this->Balance->CurrentValue;
        $this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
        if (strval($this->Balance->EditValue) != "" && is_numeric($this->Balance->EditValue)) {
            $this->Balance->EditValue = FormatNumber($this->Balance->EditValue, null);
        }

        // cumulative_sum
        $this->cumulative_sum->setupEditAttributes();
        $this->cumulative_sum->EditValue = $this->cumulative_sum->CurrentValue;
        $this->cumulative_sum->PlaceHolder = RemoveHtml($this->cumulative_sum->caption());
        if (strval($this->cumulative_sum->EditValue) != "" && is_numeric($this->cumulative_sum->EditValue)) {
            $this->cumulative_sum->EditValue = FormatNumber($this->cumulative_sum->EditValue, null);
        }

        // type
        $this->type->setupEditAttributes();
        if (!$this->type->Raw) {
            $this->type->CurrentValue = HtmlDecode($this->type->CurrentValue);
        }
        $this->type->EditValue = $this->type->CurrentValue;
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // r_from
        $this->r_from->setupEditAttributes();
        $this->r_from->EditValue = $this->r_from->CurrentValue;
        $this->r_from->PlaceHolder = RemoveHtml($this->r_from->caption());
        if (strval($this->r_from->EditValue) != "" && is_numeric($this->r_from->EditValue)) {
            $this->r_from->EditValue = FormatNumber($this->r_from->EditValue, null);
        }

        // name
        $this->name->setupEditAttributes();
        if (!$this->name->Raw) {
            $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
        }
        $this->name->EditValue = $this->name->CurrentValue;
        $this->name->PlaceHolder = RemoveHtml($this->name->caption());

        // ref
        $this->ref->setupEditAttributes();
        if (!$this->ref->Raw) {
            $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
        }
        $this->ref->EditValue = $this->ref->CurrentValue;
        $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // id
        $this->id->setupEditAttributes();
        if (!$this->id->Raw) {
            $this->id->CurrentValue = HtmlDecode($this->id->CurrentValue);
        }
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->Balance->CurrentValue)) {
                $this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->Balance->CurrentValue = $this->Balance->Total;
            $this->Balance->ViewValue = $this->Balance->CurrentValue;
            $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());
            $this->Balance->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->uid);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->ref_account);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->cumulative_sum);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->name);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->id);
                } else {
                    $doc->exportCaption($this->uid);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->ref_account);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->cumulative_sum);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->name);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->uid);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->ref_account);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->cumulative_sum);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->name);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->id);
                    } else {
                        $doc->exportField($this->uid);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->ref_account);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->cumulative_sum);
                        $doc->exportField($this->type);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->name);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->uid, '');
                $doc->exportAggregate($this->dated, '');
                $doc->exportAggregate($this->ref_account, '');
                $doc->exportAggregate($this->Balance, 'TOTAL');
                $doc->exportAggregate($this->cumulative_sum, '');
                $doc->exportAggregate($this->type, '');
                $doc->exportAggregate($this->remarks, '');
                $doc->exportAggregate($this->name, '');
                $doc->exportAggregate($this->ref, '');
                $doc->exportAggregate($this->id, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->uid->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
