<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LExaminationTypeEdit extends LExaminationType
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LExaminationTypeEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lexaminationtypeedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->report_grp->setVisibility();
        $this->name->setVisibility();
        $this->ex_grp->setVisibility();
        $this->price->setVisibility();
        $this->max_discount->setVisibility();
        $this->code->setVisibility();
        $this->standard_min->setVisibility();
        $this->standard_max->setVisibility();
        $this->standard_unit->setVisibility();
        $this->header->setVisibility();
        $this->footer->setVisibility();
        $this->process_time_hours->setVisibility();
        $this->status->setVisibility();
        $this->diagnosis_code->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'l_examination_type';
        $this->TableName = 'l_examination_type';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (l_examination_type)
        if (!isset($GLOBALS["l_examination_type"]) || $GLOBALS["l_examination_type"]::class == PROJECT_NAMESPACE . "l_examination_type") {
            $GLOBALS["l_examination_type"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination_type');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "lexaminationtypeview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->report_grp);
        $this->setupLookupOptions($this->ex_grp);
        $this->setupLookupOptions($this->status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("lexaminationtypelist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "lexaminationtypelist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "lexaminationtypelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "lexaminationtypelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'report_grp' first before field var 'x_report_grp'
        $val = $CurrentForm->hasValue("report_grp") ? $CurrentForm->getValue("report_grp") : $CurrentForm->getValue("x_report_grp");
        if (!$this->report_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->report_grp->Visible = false; // Disable update for API request
            } else {
                $this->report_grp->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'ex_grp' first before field var 'x_ex_grp'
        $val = $CurrentForm->hasValue("ex_grp") ? $CurrentForm->getValue("ex_grp") : $CurrentForm->getValue("x_ex_grp");
        if (!$this->ex_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ex_grp->Visible = false; // Disable update for API request
            } else {
                $this->ex_grp->setFormValue($val);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'max_discount' first before field var 'x_max_discount'
        $val = $CurrentForm->hasValue("max_discount") ? $CurrentForm->getValue("max_discount") : $CurrentForm->getValue("x_max_discount");
        if (!$this->max_discount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->max_discount->Visible = false; // Disable update for API request
            } else {
                $this->max_discount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val);
            }
        }

        // Check field name 'standard_min' first before field var 'x_standard_min'
        $val = $CurrentForm->hasValue("standard_min") ? $CurrentForm->getValue("standard_min") : $CurrentForm->getValue("x_standard_min");
        if (!$this->standard_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->standard_min->Visible = false; // Disable update for API request
            } else {
                $this->standard_min->setFormValue($val);
            }
        }

        // Check field name 'standard_max' first before field var 'x_standard_max'
        $val = $CurrentForm->hasValue("standard_max") ? $CurrentForm->getValue("standard_max") : $CurrentForm->getValue("x_standard_max");
        if (!$this->standard_max->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->standard_max->Visible = false; // Disable update for API request
            } else {
                $this->standard_max->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'standard_unit' first before field var 'x_standard_unit'
        $val = $CurrentForm->hasValue("standard_unit") ? $CurrentForm->getValue("standard_unit") : $CurrentForm->getValue("x_standard_unit");
        if (!$this->standard_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->standard_unit->Visible = false; // Disable update for API request
            } else {
                $this->standard_unit->setFormValue($val);
            }
        }

        // Check field name 'header' first before field var 'x_header'
        $val = $CurrentForm->hasValue("header") ? $CurrentForm->getValue("header") : $CurrentForm->getValue("x_header");
        if (!$this->header->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->header->Visible = false; // Disable update for API request
            } else {
                $this->header->setFormValue($val);
            }
        }

        // Check field name 'footer' first before field var 'x_footer'
        $val = $CurrentForm->hasValue("footer") ? $CurrentForm->getValue("footer") : $CurrentForm->getValue("x_footer");
        if (!$this->footer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->footer->Visible = false; // Disable update for API request
            } else {
                $this->footer->setFormValue($val);
            }
        }

        // Check field name 'process_time_hours' first before field var 'x_process_time_hours'
        $val = $CurrentForm->hasValue("process_time_hours") ? $CurrentForm->getValue("process_time_hours") : $CurrentForm->getValue("x_process_time_hours");
        if (!$this->process_time_hours->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_time_hours->Visible = false; // Disable update for API request
            } else {
                $this->process_time_hours->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'diagnosis_code' first before field var 'x_diagnosis_code'
        $val = $CurrentForm->hasValue("diagnosis_code") ? $CurrentForm->getValue("diagnosis_code") : $CurrentForm->getValue("x_diagnosis_code");
        if (!$this->diagnosis_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diagnosis_code->Visible = false; // Disable update for API request
            } else {
                $this->diagnosis_code->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->report_grp->CurrentValue = $this->report_grp->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->ex_grp->CurrentValue = $this->ex_grp->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->max_discount->CurrentValue = $this->max_discount->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->standard_min->CurrentValue = $this->standard_min->FormValue;
        $this->standard_max->CurrentValue = $this->standard_max->FormValue;
        $this->standard_unit->CurrentValue = $this->standard_unit->FormValue;
        $this->header->CurrentValue = $this->header->FormValue;
        $this->footer->CurrentValue = $this->footer->FormValue;
        $this->process_time_hours->CurrentValue = $this->process_time_hours->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->diagnosis_code->CurrentValue = $this->diagnosis_code->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->report_grp->setDbValue($row['report_grp']);
        $this->name->setDbValue($row['name']);
        $this->ex_grp->setDbValue($row['ex_grp']);
        $this->price->setDbValue($row['price']);
        $this->max_discount->setDbValue($row['max_discount']);
        $this->code->setDbValue($row['code']);
        $this->standard_min->setDbValue($row['standard_min']);
        $this->standard_max->setDbValue($row['standard_max']);
        $this->standard_unit->setDbValue($row['standard_unit']);
        $this->header->setDbValue($row['header']);
        $this->footer->setDbValue($row['footer']);
        $this->process_time_hours->setDbValue($row['process_time_hours']);
        $this->status->setDbValue($row['status']);
        $this->diagnosis_code->setDbValue($row['diagnosis_code']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['report_grp'] = $this->report_grp->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['ex_grp'] = $this->ex_grp->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['max_discount'] = $this->max_discount->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['standard_min'] = $this->standard_min->DefaultValue;
        $row['standard_max'] = $this->standard_max->DefaultValue;
        $row['standard_unit'] = $this->standard_unit->DefaultValue;
        $row['header'] = $this->header->DefaultValue;
        $row['footer'] = $this->footer->DefaultValue;
        $row['process_time_hours'] = $this->process_time_hours->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['diagnosis_code'] = $this->diagnosis_code->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // report_grp
        $this->report_grp->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // ex_grp
        $this->ex_grp->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // max_discount
        $this->max_discount->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // standard_min
        $this->standard_min->RowCssClass = "row";

        // standard_max
        $this->standard_max->RowCssClass = "row";

        // standard_unit
        $this->standard_unit->RowCssClass = "row";

        // header
        $this->header->RowCssClass = "row";

        // footer
        $this->footer->RowCssClass = "row";

        // process_time_hours
        $this->process_time_hours->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // diagnosis_code
        $this->diagnosis_code->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // report_grp
            $curVal = strval($this->report_grp->CurrentValue);
            if ($curVal != "") {
                $this->report_grp->ViewValue = $this->report_grp->lookupCacheOption($curVal);
                if ($this->report_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->report_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->report_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->report_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->report_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->report_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->report_grp->ViewValue = $this->report_grp->displayValue($arwrk);
                    } else {
                        $this->report_grp->ViewValue = FormatNumber($this->report_grp->CurrentValue, $this->report_grp->formatPattern());
                    }
                }
            } else {
                $this->report_grp->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // ex_grp
            $curVal = strval($this->ex_grp->CurrentValue);
            if ($curVal != "") {
                $this->ex_grp->ViewValue = $this->ex_grp->lookupCacheOption($curVal);
                if ($this->ex_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_grp->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->ex_grp->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->ex_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ex_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->ex_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->ex_grp->Lookup->renderViewRow($row);
                            $this->ex_grp->ViewValue->add($this->ex_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->ex_grp->ViewValue = $this->ex_grp->CurrentValue;
                    }
                }
            } else {
                $this->ex_grp->ViewValue = null;
            }

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // max_discount
            $this->max_discount->ViewValue = $this->max_discount->CurrentValue;
            $this->max_discount->ViewValue = FormatNumber($this->max_discount->ViewValue, $this->max_discount->formatPattern());

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // standard_min
            $this->standard_min->ViewValue = $this->standard_min->CurrentValue;

            // standard_max
            $this->standard_max->ViewValue = $this->standard_max->CurrentValue;

            // standard_unit
            $this->standard_unit->ViewValue = $this->standard_unit->CurrentValue;

            // header
            $this->header->ViewValue = $this->header->CurrentValue;

            // footer
            $this->footer->ViewValue = $this->footer->CurrentValue;

            // process_time_hours
            $this->process_time_hours->ViewValue = $this->process_time_hours->CurrentValue;
            $this->process_time_hours->ViewValue = FormatNumber($this->process_time_hours->ViewValue, $this->process_time_hours->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // diagnosis_code
            $this->diagnosis_code->ViewValue = $this->diagnosis_code->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // report_grp
            $this->report_grp->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // ex_grp
            $this->ex_grp->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // max_discount
            $this->max_discount->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // standard_min
            $this->standard_min->HrefValue = "";

            // standard_max
            $this->standard_max->HrefValue = "";

            // standard_unit
            $this->standard_unit->HrefValue = "";

            // header
            $this->header->HrefValue = "";

            // footer
            $this->footer->HrefValue = "";

            // process_time_hours
            $this->process_time_hours->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // diagnosis_code
            $this->diagnosis_code->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // report_grp
            $this->report_grp->setupEditAttributes();
            $curVal = trim(strval($this->report_grp->CurrentValue));
            if ($curVal != "") {
                $this->report_grp->ViewValue = $this->report_grp->lookupCacheOption($curVal);
            } else {
                $this->report_grp->ViewValue = $this->report_grp->Lookup !== null && is_array($this->report_grp->lookupOptions()) && count($this->report_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->report_grp->ViewValue !== null) { // Load from cache
                $this->report_grp->EditValue = array_values($this->report_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->report_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->report_grp->CurrentValue, $this->report_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->report_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->report_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->report_grp->EditValue = $arwrk;
            }
            $this->report_grp->PlaceHolder = RemoveHtml($this->report_grp->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // ex_grp
            $curVal = trim(strval($this->ex_grp->CurrentValue));
            if ($curVal != "") {
                $this->ex_grp->ViewValue = $this->ex_grp->lookupCacheOption($curVal);
            } else {
                $this->ex_grp->ViewValue = $this->ex_grp->Lookup !== null && is_array($this->ex_grp->lookupOptions()) && count($this->ex_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ex_grp->ViewValue !== null) { // Load from cache
                $this->ex_grp->EditValue = array_values($this->ex_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_grp->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->ex_grp->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->ex_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->ex_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ex_grp->EditValue = $arwrk;
            }
            $this->ex_grp->PlaceHolder = RemoveHtml($this->ex_grp->caption());

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // max_discount
            $this->max_discount->setupEditAttributes();
            $this->max_discount->EditValue = $this->max_discount->CurrentValue;
            $this->max_discount->PlaceHolder = RemoveHtml($this->max_discount->caption());
            if (strval($this->max_discount->EditValue) != "" && is_numeric($this->max_discount->EditValue)) {
                $this->max_discount->EditValue = FormatNumber($this->max_discount->EditValue, null);
            }

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // standard_min
            $this->standard_min->setupEditAttributes();
            if (!$this->standard_min->Raw) {
                $this->standard_min->CurrentValue = HtmlDecode($this->standard_min->CurrentValue);
            }
            $this->standard_min->EditValue = HtmlEncode($this->standard_min->CurrentValue);
            $this->standard_min->PlaceHolder = RemoveHtml($this->standard_min->caption());

            // standard_max
            $this->standard_max->setupEditAttributes();
            if (!$this->standard_max->Raw) {
                $this->standard_max->CurrentValue = HtmlDecode($this->standard_max->CurrentValue);
            }
            $this->standard_max->EditValue = HtmlEncode($this->standard_max->CurrentValue);
            $this->standard_max->PlaceHolder = RemoveHtml($this->standard_max->caption());

            // standard_unit
            $this->standard_unit->setupEditAttributes();
            if (!$this->standard_unit->Raw) {
                $this->standard_unit->CurrentValue = HtmlDecode($this->standard_unit->CurrentValue);
            }
            $this->standard_unit->EditValue = HtmlEncode($this->standard_unit->CurrentValue);
            $this->standard_unit->PlaceHolder = RemoveHtml($this->standard_unit->caption());

            // header
            $this->header->setupEditAttributes();
            $this->header->EditValue = HtmlEncode($this->header->CurrentValue);
            $this->header->PlaceHolder = RemoveHtml($this->header->caption());

            // footer
            $this->footer->setupEditAttributes();
            $this->footer->EditValue = HtmlEncode($this->footer->CurrentValue);
            $this->footer->PlaceHolder = RemoveHtml($this->footer->caption());

            // process_time_hours
            $this->process_time_hours->setupEditAttributes();
            $this->process_time_hours->EditValue = $this->process_time_hours->CurrentValue;
            $this->process_time_hours->PlaceHolder = RemoveHtml($this->process_time_hours->caption());
            if (strval($this->process_time_hours->EditValue) != "" && is_numeric($this->process_time_hours->EditValue)) {
                $this->process_time_hours->EditValue = FormatNumber($this->process_time_hours->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // diagnosis_code
            $this->diagnosis_code->setupEditAttributes();
            $this->diagnosis_code->EditValue = HtmlEncode($this->diagnosis_code->CurrentValue);
            $this->diagnosis_code->PlaceHolder = RemoveHtml($this->diagnosis_code->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // report_grp
            $this->report_grp->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // ex_grp
            $this->ex_grp->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // max_discount
            $this->max_discount->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // standard_min
            $this->standard_min->HrefValue = "";

            // standard_max
            $this->standard_max->HrefValue = "";

            // standard_unit
            $this->standard_unit->HrefValue = "";

            // header
            $this->header->HrefValue = "";

            // footer
            $this->footer->HrefValue = "";

            // process_time_hours
            $this->process_time_hours->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // diagnosis_code
            $this->diagnosis_code->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->report_grp->Visible && $this->report_grp->Required) {
                if (!$this->report_grp->IsDetailKey && EmptyValue($this->report_grp->FormValue)) {
                    $this->report_grp->addErrorMessage(str_replace("%s", $this->report_grp->caption(), $this->report_grp->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->ex_grp->Visible && $this->ex_grp->Required) {
                if ($this->ex_grp->FormValue == "") {
                    $this->ex_grp->addErrorMessage(str_replace("%s", $this->ex_grp->caption(), $this->ex_grp->RequiredErrorMessage));
                }
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->max_discount->Visible && $this->max_discount->Required) {
                if (!$this->max_discount->IsDetailKey && EmptyValue($this->max_discount->FormValue)) {
                    $this->max_discount->addErrorMessage(str_replace("%s", $this->max_discount->caption(), $this->max_discount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->max_discount->FormValue)) {
                $this->max_discount->addErrorMessage($this->max_discount->getErrorMessage(false));
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->standard_min->Visible && $this->standard_min->Required) {
                if (!$this->standard_min->IsDetailKey && EmptyValue($this->standard_min->FormValue)) {
                    $this->standard_min->addErrorMessage(str_replace("%s", $this->standard_min->caption(), $this->standard_min->RequiredErrorMessage));
                }
            }
            if ($this->standard_max->Visible && $this->standard_max->Required) {
                if (!$this->standard_max->IsDetailKey && EmptyValue($this->standard_max->FormValue)) {
                    $this->standard_max->addErrorMessage(str_replace("%s", $this->standard_max->caption(), $this->standard_max->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->standard_max->FormValue)) {
                $this->standard_max->addErrorMessage($this->standard_max->getErrorMessage(false));
            }
            if ($this->standard_unit->Visible && $this->standard_unit->Required) {
                if (!$this->standard_unit->IsDetailKey && EmptyValue($this->standard_unit->FormValue)) {
                    $this->standard_unit->addErrorMessage(str_replace("%s", $this->standard_unit->caption(), $this->standard_unit->RequiredErrorMessage));
                }
            }
            if ($this->header->Visible && $this->header->Required) {
                if (!$this->header->IsDetailKey && EmptyValue($this->header->FormValue)) {
                    $this->header->addErrorMessage(str_replace("%s", $this->header->caption(), $this->header->RequiredErrorMessage));
                }
            }
            if ($this->footer->Visible && $this->footer->Required) {
                if (!$this->footer->IsDetailKey && EmptyValue($this->footer->FormValue)) {
                    $this->footer->addErrorMessage(str_replace("%s", $this->footer->caption(), $this->footer->RequiredErrorMessage));
                }
            }
            if ($this->process_time_hours->Visible && $this->process_time_hours->Required) {
                if (!$this->process_time_hours->IsDetailKey && EmptyValue($this->process_time_hours->FormValue)) {
                    $this->process_time_hours->addErrorMessage(str_replace("%s", $this->process_time_hours->caption(), $this->process_time_hours->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->process_time_hours->FormValue)) {
                $this->process_time_hours->addErrorMessage($this->process_time_hours->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->diagnosis_code->Visible && $this->diagnosis_code->Required) {
                if (!$this->diagnosis_code->IsDetailKey && EmptyValue($this->diagnosis_code->FormValue)) {
                    $this->diagnosis_code->addErrorMessage(str_replace("%s", $this->diagnosis_code->caption(), $this->diagnosis_code->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // report_grp
        $this->report_grp->setDbValueDef($rsnew, $this->report_grp->CurrentValue, $this->report_grp->ReadOnly);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // ex_grp
        $this->ex_grp->setDbValueDef($rsnew, $this->ex_grp->CurrentValue, $this->ex_grp->ReadOnly);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly);

        // max_discount
        $this->max_discount->setDbValueDef($rsnew, $this->max_discount->CurrentValue, $this->max_discount->ReadOnly);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, $this->code->ReadOnly);

        // standard_min
        $this->standard_min->setDbValueDef($rsnew, $this->standard_min->CurrentValue, $this->standard_min->ReadOnly);

        // standard_max
        $this->standard_max->setDbValueDef($rsnew, $this->standard_max->CurrentValue, $this->standard_max->ReadOnly);

        // standard_unit
        $this->standard_unit->setDbValueDef($rsnew, $this->standard_unit->CurrentValue, $this->standard_unit->ReadOnly);

        // header
        $this->header->setDbValueDef($rsnew, $this->header->CurrentValue, $this->header->ReadOnly);

        // footer
        $this->footer->setDbValueDef($rsnew, $this->footer->CurrentValue, $this->footer->ReadOnly);

        // process_time_hours
        $this->process_time_hours->setDbValueDef($rsnew, $this->process_time_hours->CurrentValue, $this->process_time_hours->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // diagnosis_code
        $this->diagnosis_code->setDbValueDef($rsnew, $this->diagnosis_code->CurrentValue, $this->diagnosis_code->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['report_grp'])) { // report_grp
            $this->report_grp->CurrentValue = $row['report_grp'];
        }
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['ex_grp'])) { // ex_grp
            $this->ex_grp->CurrentValue = $row['ex_grp'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['max_discount'])) { // max_discount
            $this->max_discount->CurrentValue = $row['max_discount'];
        }
        if (isset($row['code'])) { // code
            $this->code->CurrentValue = $row['code'];
        }
        if (isset($row['standard_min'])) { // standard_min
            $this->standard_min->CurrentValue = $row['standard_min'];
        }
        if (isset($row['standard_max'])) { // standard_max
            $this->standard_max->CurrentValue = $row['standard_max'];
        }
        if (isset($row['standard_unit'])) { // standard_unit
            $this->standard_unit->CurrentValue = $row['standard_unit'];
        }
        if (isset($row['header'])) { // header
            $this->header->CurrentValue = $row['header'];
        }
        if (isset($row['footer'])) { // footer
            $this->footer->CurrentValue = $row['footer'];
        }
        if (isset($row['process_time_hours'])) { // process_time_hours
            $this->process_time_hours->CurrentValue = $row['process_time_hours'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['diagnosis_code'])) { // diagnosis_code
            $this->diagnosis_code->CurrentValue = $row['diagnosis_code'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lexaminationtypelist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_report_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ex_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
