<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LExaminationSearch extends LExamination
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LExaminationSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lexaminationsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->mobile->setVisibility();
        $this->user->setVisibility();
        $this->category->setVisibility();
        $this->name->setVisibility();
        $this->age->setVisibility();
        $this->sex->setVisibility();
        $this->referral->setVisibility();
        $this->examination_grp->setVisibility();
        $this->examination_type->setVisibility();
        $this->total_amount->setVisibility();
        $this->discount_percent->setVisibility();
        $this->discount_amount->setVisibility();
        $this->final_amount->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->receipt->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'l_examination';
        $this->TableName = 'l_examination';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (l_examination)
        if (!isset($GLOBALS["l_examination"]) || $GLOBALS["l_examination"]::class == PROJECT_NAMESPACE . "l_examination") {
            $GLOBALS["l_examination"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "lexaminationview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->mobile);
        $this->setupLookupOptions($this->user);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->sex);
        $this->setupLookupOptions($this->referral);
        $this->setupLookupOptions($this->examination_grp);
        $this->setupLookupOptions($this->examination_type);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "lexaminationlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->user); // user
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->age); // age
        $this->buildSearchUrl($srchUrl, $this->sex); // sex
        $this->buildSearchUrl($srchUrl, $this->referral); // referral
        $this->buildSearchUrl($srchUrl, $this->examination_grp); // examination_grp
        $this->buildSearchUrl($srchUrl, $this->examination_type); // examination_type
        $this->buildSearchUrl($srchUrl, $this->total_amount); // total_amount
        $this->buildSearchUrl($srchUrl, $this->discount_percent); // discount_percent
        $this->buildSearchUrl($srchUrl, $this->discount_amount); // discount_amount
        $this->buildSearchUrl($srchUrl, $this->final_amount); // final_amount
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->receipt); // receipt
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // user
        if ($this->user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // age
        if ($this->age->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sex
        if ($this->sex->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // referral
        if ($this->referral->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // examination_grp
        if ($this->examination_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->examination_grp->AdvancedSearch->SearchValue)) {
            $this->examination_grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->examination_grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->examination_grp->AdvancedSearch->SearchValue2)) {
            $this->examination_grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->examination_grp->AdvancedSearch->SearchValue2);
        }

        // examination_type
        if ($this->examination_type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->examination_type->AdvancedSearch->SearchValue)) {
            $this->examination_type->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->examination_type->AdvancedSearch->SearchValue);
        }
        if (is_array($this->examination_type->AdvancedSearch->SearchValue2)) {
            $this->examination_type->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->examination_type->AdvancedSearch->SearchValue2);
        }

        // total_amount
        if ($this->total_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // discount_percent
        if ($this->discount_percent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // discount_amount
        if ($this->discount_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // final_amount
        if ($this->final_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // receipt
        if ($this->receipt->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // user
        $this->user->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // sex
        $this->sex->RowCssClass = "row";

        // referral
        $this->referral->RowCssClass = "row";

        // examination_grp
        $this->examination_grp->RowCssClass = "row";

        // examination_type
        $this->examination_type->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // discount_percent
        $this->discount_percent->RowCssClass = "row";

        // discount_amount
        $this->discount_amount->RowCssClass = "row";

        // final_amount
        $this->final_amount->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // receipt
        $this->receipt->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $curVal = strval($this->mobile->CurrentValue);
            if ($curVal != "") {
                $this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->ViewValue = $this->mobile->CurrentValue;
                    }
                }
            } else {
                $this->mobile->ViewValue = null;
            }

            // user
            $this->user->ViewValue = $this->user->CurrentValue;
            $curVal = strval($this->user->CurrentValue);
            if ($curVal != "") {
                $this->user->ViewValue = $this->user->lookupCacheOption($curVal);
                if ($this->user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                        $this->user->ViewValue = $this->user->displayValue($arwrk);
                    } else {
                        $this->user->ViewValue = FormatNumber($this->user->CurrentValue, $this->user->formatPattern());
                    }
                }
            } else {
                $this->user->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // age
            $this->age->ViewValue = $this->age->CurrentValue;
            $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

            // sex
            if (strval($this->sex->CurrentValue) != "") {
                $this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
            } else {
                $this->sex->ViewValue = null;
            }

            // referral
            $this->referral->ViewValue = $this->referral->CurrentValue;
            $curVal = strval($this->referral->CurrentValue);
            if ($curVal != "") {
                $this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->ViewValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->ViewValue = FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern());
                    }
                }
            } else {
                $this->referral->ViewValue = null;
            }

            // examination_grp
            $curVal = strval($this->examination_grp->CurrentValue);
            if ($curVal != "") {
                $this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
                if ($this->examination_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->examination_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->examination_grp->Lookup->renderViewRow($row);
                            $this->examination_grp->ViewValue->add($this->examination_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->examination_grp->ViewValue = $this->examination_grp->CurrentValue;
                    }
                }
            } else {
                $this->examination_grp->ViewValue = null;
            }

            // examination_type
            $curVal = strval($this->examination_type->CurrentValue);
            if ($curVal != "") {
                $this->examination_type->ViewValue = $this->examination_type->lookupCacheOption($curVal);
                if ($this->examination_type->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->examination_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->examination_type->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->examination_type->Lookup->renderViewRow($row);
                            $this->examination_type->ViewValue->add($this->examination_type->displayValue($arwrk));
                        }
                    } else {
                        $this->examination_type->ViewValue = $this->examination_type->CurrentValue;
                    }
                }
            } else {
                $this->examination_type->ViewValue = null;
            }

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // discount_percent
            $this->discount_percent->ViewValue = $this->discount_percent->CurrentValue;
            $this->discount_percent->ViewValue = FormatNumber($this->discount_percent->ViewValue, $this->discount_percent->formatPattern());

            // discount_amount
            $this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
            $this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, $this->discount_amount->formatPattern());

            // final_amount
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // receipt
            $this->receipt->ViewValue = $this->receipt->CurrentValue;
            $this->receipt->ViewValue = FormatNumber($this->receipt->ViewValue, $this->receipt->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // user
            $this->user->HrefValue = "";
            $this->user->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // age
            $this->age->HrefValue = "";
            $this->age->TooltipValue = "";

            // sex
            $this->sex->HrefValue = "";
            $this->sex->TooltipValue = "";

            // referral
            $this->referral->HrefValue = "";
            $this->referral->TooltipValue = "";

            // examination_grp
            $this->examination_grp->HrefValue = "";
            $this->examination_grp->TooltipValue = "";

            // examination_type
            $this->examination_type->HrefValue = "";
            $this->examination_type->TooltipValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";
            $this->total_amount->TooltipValue = "";

            // discount_percent
            $this->discount_percent->HrefValue = "";
            $this->discount_percent->TooltipValue = "";

            // discount_amount
            $this->discount_amount->HrefValue = "";
            $this->discount_amount->TooltipValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";
            $this->final_amount->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // receipt
            $this->receipt->HrefValue = "";
            $this->receipt->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $curVal = strval($this->mobile->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->EditValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->mobile->EditValue = null;
            }
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // user
            $this->user->setupEditAttributes();
            $this->user->EditCustomAttributes = $this->user->getEditCustomAttributes(); // PHP
            $this->user->EditValue = $this->user->AdvancedSearch->SearchValue;
            $curVal = strval($this->user->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->user->EditValue = $this->user->lookupCacheOption($curVal);
                if ($this->user->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                        $this->user->EditValue = $this->user->displayValue($arwrk);
                    } else {
                        $this->user->EditValue = HtmlEncode(FormatNumber($this->user->AdvancedSearch->SearchValue, $this->user->formatPattern()));
                    }
                }
            } else {
                $this->user->EditValue = null;
            }
            $this->user->PlaceHolder = RemoveHtml($this->user->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->name->CurrentValue;
            $arwrk["df"] = $this->name->CurrentValue;
            $arwrk = $this->name->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->name->displayValue($arwrk);
            if ($dispVal != "") {
                $this->name->EditValue = $dispVal;
            }
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // age
            $this->age->setupEditAttributes();
            $this->age->EditValue = $this->age->AdvancedSearch->SearchValue;
            $this->age->PlaceHolder = RemoveHtml($this->age->caption());

            // sex
            $this->sex->EditValue = $this->sex->options(false);
            $this->sex->PlaceHolder = RemoveHtml($this->sex->caption());

            // referral
            $this->referral->setupEditAttributes();
            $this->referral->EditValue = $this->referral->AdvancedSearch->SearchValue;
            $curVal = strval($this->referral->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->referral->EditValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->EditValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->EditValue = HtmlEncode(FormatNumber($this->referral->AdvancedSearch->SearchValue, $this->referral->formatPattern()));
                    }
                }
            } else {
                $this->referral->EditValue = null;
            }
            $this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

            // examination_grp
            $curVal = trim(strval($this->examination_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->examination_grp->AdvancedSearch->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
            } else {
                $this->examination_grp->AdvancedSearch->ViewValue = $this->examination_grp->Lookup !== null && is_array($this->examination_grp->lookupOptions()) && count($this->examination_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->examination_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->examination_grp->EditValue = array_values($this->examination_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->examination_grp->EditValue = $arwrk;
            }
            $this->examination_grp->PlaceHolder = RemoveHtml($this->examination_grp->caption());

            // examination_type
            $curVal = trim(strval($this->examination_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->examination_type->AdvancedSearch->ViewValue = $this->examination_type->lookupCacheOption($curVal);
            } else {
                $this->examination_type->AdvancedSearch->ViewValue = $this->examination_type->Lookup !== null && is_array($this->examination_type->lookupOptions()) && count($this->examination_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->examination_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->examination_type->EditValue = array_values($this->examination_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->examination_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->examination_type->Lookup->renderViewRow($row);
                }
                $this->examination_type->EditValue = $arwrk;
            }
            $this->examination_type->PlaceHolder = RemoveHtml($this->examination_type->caption());

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->AdvancedSearch->SearchValue;
            $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());

            // discount_percent
            $this->discount_percent->setupEditAttributes();
            $this->discount_percent->EditValue = $this->discount_percent->AdvancedSearch->SearchValue;
            $this->discount_percent->PlaceHolder = RemoveHtml($this->discount_percent->caption());

            // discount_amount
            $this->discount_amount->setupEditAttributes();
            $this->discount_amount->EditValue = $this->discount_amount->AdvancedSearch->SearchValue;
            $this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());

            // final_amount
            $this->final_amount->setupEditAttributes();
            $this->final_amount->EditCustomAttributes = $this->final_amount->getEditCustomAttributes(); // PHP
            $this->final_amount->EditValue = $this->final_amount->AdvancedSearch->SearchValue;
            $this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // receipt
            $this->receipt->setupEditAttributes();
            $this->receipt->EditValue = $this->receipt->AdvancedSearch->SearchValue;
            $this->receipt->PlaceHolder = RemoveHtml($this->receipt->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckDate($this->id->AdvancedSearch->SearchValue, $this->id->formatPattern())) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->user->AdvancedSearch->SearchValue)) {
            $this->user->addErrorMessage($this->user->getErrorMessage(false));
        }
        if (!CheckInteger($this->age->AdvancedSearch->SearchValue)) {
            $this->age->addErrorMessage($this->age->getErrorMessage(false));
        }
        if (!CheckInteger($this->referral->AdvancedSearch->SearchValue)) {
            $this->referral->addErrorMessage($this->referral->getErrorMessage(false));
        }
        if (!CheckNumber($this->total_amount->AdvancedSearch->SearchValue)) {
            $this->total_amount->addErrorMessage($this->total_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->discount_percent->AdvancedSearch->SearchValue)) {
            $this->discount_percent->addErrorMessage($this->discount_percent->getErrorMessage(false));
        }
        if (!CheckNumber($this->discount_amount->AdvancedSearch->SearchValue)) {
            $this->discount_amount->addErrorMessage($this->discount_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->final_amount->AdvancedSearch->SearchValue)) {
            $this->final_amount->addErrorMessage($this->final_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckNumber($this->receipt->AdvancedSearch->SearchValue)) {
            $this->receipt->addErrorMessage($this->receipt->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->user->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->age->AdvancedSearch->load();
        $this->sex->AdvancedSearch->load();
        $this->referral->AdvancedSearch->load();
        $this->examination_grp->AdvancedSearch->load();
        $this->examination_type->AdvancedSearch->load();
        $this->total_amount->AdvancedSearch->load();
        $this->discount_percent->AdvancedSearch->load();
        $this->discount_amount->AdvancedSearch->load();
        $this->final_amount->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->receipt->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lexaminationlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_mobile":
                    break;
                case "x_user":
                    break;
                case "x_category":
                    break;
                case "x_name":
                    break;
                case "x_sex":
                    break;
                case "x_referral":
                    break;
                case "x_examination_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_examination_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
