<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LExaminationReportSearch extends LExaminationReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LExaminationReportSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lexaminationreportsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->d_id->setVisibility();
        $this->mobile->setVisibility();
        $this->name->setVisibility();
        $this->examination_code->setVisibility();
        $this->diagnosis_value->setVisibility();
        $this->diagnosis_st_min->setVisibility();
        $this->diagnosis_st_max->setVisibility();
        $this->diagnosis_unit->setVisibility();
        $this->balance_amount->setVisibility();
        $this->age->setVisibility();
        $this->sex->setVisibility();
        $this->referral->setVisibility();
        $this->remarks->setVisibility();
        $this->examination_grp->setVisibility();
        $this->diagnosis_datetime->setVisibility();
        $this->import_value->setVisibility();
        $this->total_amount->setVisibility();
        $this->discount_amount->setVisibility();
        $this->received_amount->setVisibility();
        $this->examination_id->setVisibility();
        $this->examination_name->setVisibility();
        $this->uid->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->user->setVisibility();
        $this->report_grp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'l_examination_report';
        $this->TableName = 'l_examination_report';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (l_examination_report)
        if (!isset($GLOBALS["l_examination_report"]) || $GLOBALS["l_examination_report"]::class == PROJECT_NAMESPACE . "l_examination_report") {
            $GLOBALS["l_examination_report"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination_report');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "lexaminationreportview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['uid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->mobile);
        $this->setupLookupOptions($this->name);
        $this->setupLookupOptions($this->sex);
        $this->setupLookupOptions($this->referral);
        $this->setupLookupOptions($this->examination_grp);
        $this->setupLookupOptions($this->user);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "lexaminationreportlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->d_id); // d_id
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->examination_code); // examination_code
        $this->buildSearchUrl($srchUrl, $this->diagnosis_value); // diagnosis_value
        $this->buildSearchUrl($srchUrl, $this->diagnosis_st_min); // diagnosis_st_min
        $this->buildSearchUrl($srchUrl, $this->diagnosis_st_max); // diagnosis_st_max
        $this->buildSearchUrl($srchUrl, $this->diagnosis_unit); // diagnosis_unit
        $this->buildSearchUrl($srchUrl, $this->balance_amount); // balance_amount
        $this->buildSearchUrl($srchUrl, $this->age); // age
        $this->buildSearchUrl($srchUrl, $this->sex); // sex
        $this->buildSearchUrl($srchUrl, $this->referral); // referral
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->examination_grp); // examination_grp
        $this->buildSearchUrl($srchUrl, $this->diagnosis_datetime); // diagnosis_datetime
        $this->buildSearchUrl($srchUrl, $this->import_value); // import_value
        $this->buildSearchUrl($srchUrl, $this->total_amount); // total_amount
        $this->buildSearchUrl($srchUrl, $this->discount_amount); // discount_amount
        $this->buildSearchUrl($srchUrl, $this->received_amount); // received_amount
        $this->buildSearchUrl($srchUrl, $this->examination_id); // examination_id
        $this->buildSearchUrl($srchUrl, $this->examination_name); // examination_name
        $this->buildSearchUrl($srchUrl, $this->uid); // uid
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->user); // user
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // d_id
        if ($this->d_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // examination_code
        if ($this->examination_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diagnosis_value
        if ($this->diagnosis_value->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diagnosis_st_min
        if ($this->diagnosis_st_min->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diagnosis_st_max
        if ($this->diagnosis_st_max->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diagnosis_unit
        if ($this->diagnosis_unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // balance_amount
        if ($this->balance_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // age
        if ($this->age->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sex
        if ($this->sex->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // referral
        if ($this->referral->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // examination_grp
        if ($this->examination_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diagnosis_datetime
        if ($this->diagnosis_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // import_value
        if ($this->import_value->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // total_amount
        if ($this->total_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // discount_amount
        if ($this->discount_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // received_amount
        if ($this->received_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // examination_id
        if ($this->examination_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // examination_name
        if ($this->examination_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // uid
        if ($this->uid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // user
        if ($this->user->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // d_id
        $this->d_id->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // examination_code
        $this->examination_code->RowCssClass = "row";

        // diagnosis_value
        $this->diagnosis_value->RowCssClass = "row";

        // diagnosis_st_min
        $this->diagnosis_st_min->RowCssClass = "row";

        // diagnosis_st_max
        $this->diagnosis_st_max->RowCssClass = "row";

        // diagnosis_unit
        $this->diagnosis_unit->RowCssClass = "row";

        // balance_amount
        $this->balance_amount->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // sex
        $this->sex->RowCssClass = "row";

        // referral
        $this->referral->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // examination_grp
        $this->examination_grp->RowCssClass = "row";

        // diagnosis_datetime
        $this->diagnosis_datetime->RowCssClass = "row";

        // import_value
        $this->import_value->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // discount_amount
        $this->discount_amount->RowCssClass = "row";

        // received_amount
        $this->received_amount->RowCssClass = "row";

        // examination_id
        $this->examination_id->RowCssClass = "row";

        // examination_name
        $this->examination_name->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // user
        $this->user->RowCssClass = "row";

        // report_grp
        $this->report_grp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // d_id
            $this->d_id->ViewValue = $this->d_id->CurrentValue;
            $this->d_id->ViewValue = FormatNumber($this->d_id->ViewValue, $this->d_id->formatPattern());

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $curVal = strval($this->mobile->CurrentValue);
            if ($curVal != "") {
                $this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->ViewValue = $this->mobile->CurrentValue;
                    }
                }
            } else {
                $this->mobile->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;
            $curVal = strval($this->name->CurrentValue);
            if ($curVal != "") {
                $this->name->ViewValue = $this->name->lookupCacheOption($curVal);
                if ($this->name->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->name->Lookup->getTable()->Fields["name"]->searchExpression(), "=", $curVal, $this->name->Lookup->getTable()->Fields["name"]->searchDataType(), "");
                    $sqlWrk = $this->name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->name->Lookup->renderViewRow($rswrk[0]);
                        $this->name->ViewValue = $this->name->displayValue($arwrk);
                    } else {
                        $this->name->ViewValue = $this->name->CurrentValue;
                    }
                }
            } else {
                $this->name->ViewValue = null;
            }

            // examination_code
            $this->examination_code->ViewValue = $this->examination_code->CurrentValue;

            // diagnosis_value
            $this->diagnosis_value->ViewValue = $this->diagnosis_value->CurrentValue;

            // diagnosis_st_min
            $this->diagnosis_st_min->ViewValue = $this->diagnosis_st_min->CurrentValue;
            $this->diagnosis_st_min->ViewValue = FormatNumber($this->diagnosis_st_min->ViewValue, $this->diagnosis_st_min->formatPattern());

            // diagnosis_st_max
            $this->diagnosis_st_max->ViewValue = $this->diagnosis_st_max->CurrentValue;
            $this->diagnosis_st_max->ViewValue = FormatNumber($this->diagnosis_st_max->ViewValue, $this->diagnosis_st_max->formatPattern());

            // diagnosis_unit
            $this->diagnosis_unit->ViewValue = $this->diagnosis_unit->CurrentValue;

            // balance_amount
            $this->balance_amount->ViewValue = $this->balance_amount->CurrentValue;
            $this->balance_amount->ViewValue = FormatNumber($this->balance_amount->ViewValue, $this->balance_amount->formatPattern());

            // age
            $this->age->ViewValue = $this->age->CurrentValue;
            $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

            // sex
            if (strval($this->sex->CurrentValue) != "") {
                $this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
            } else {
                $this->sex->ViewValue = null;
            }

            // referral
            $this->referral->ViewValue = $this->referral->CurrentValue;
            $curVal = strval($this->referral->CurrentValue);
            if ($curVal != "") {
                $this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->ViewValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->ViewValue = FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern());
                    }
                }
            } else {
                $this->referral->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // examination_grp
            $curVal = strval($this->examination_grp->CurrentValue);
            if ($curVal != "") {
                $this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
                if ($this->examination_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->examination_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->examination_grp->ViewValue = $this->examination_grp->displayValue($arwrk);
                    } else {
                        $this->examination_grp->ViewValue = FormatNumber($this->examination_grp->CurrentValue, $this->examination_grp->formatPattern());
                    }
                }
            } else {
                $this->examination_grp->ViewValue = null;
            }

            // diagnosis_datetime
            $this->diagnosis_datetime->ViewValue = $this->diagnosis_datetime->CurrentValue;
            $this->diagnosis_datetime->ViewValue = FormatDateTime($this->diagnosis_datetime->ViewValue, $this->diagnosis_datetime->formatPattern());

            // import_value
            $this->import_value->ViewValue = $this->import_value->CurrentValue;

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // discount_amount
            $this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
            $this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, $this->discount_amount->formatPattern());

            // received_amount
            $this->received_amount->ViewValue = $this->received_amount->CurrentValue;
            $this->received_amount->ViewValue = FormatNumber($this->received_amount->ViewValue, $this->received_amount->formatPattern());

            // examination_id
            $this->examination_id->ViewValue = $this->examination_id->CurrentValue;
            $this->examination_id->ViewValue = FormatNumber($this->examination_id->ViewValue, $this->examination_id->formatPattern());

            // examination_name
            $this->examination_name->ViewValue = $this->examination_name->CurrentValue;

            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // user
            $this->user->ViewValue = $this->user->CurrentValue;
            $curVal = strval($this->user->CurrentValue);
            if ($curVal != "") {
                $this->user->ViewValue = $this->user->lookupCacheOption($curVal);
                if ($this->user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                        $this->user->ViewValue = $this->user->displayValue($arwrk);
                    } else {
                        $this->user->ViewValue = FormatNumber($this->user->CurrentValue, $this->user->formatPattern());
                    }
                }
            } else {
                $this->user->ViewValue = null;
            }

            // d_id
            $this->d_id->HrefValue = "";
            $this->d_id->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // examination_code
            $this->examination_code->HrefValue = "";
            $this->examination_code->TooltipValue = "";

            // diagnosis_value
            $this->diagnosis_value->HrefValue = "";
            $this->diagnosis_value->TooltipValue = "";

            // diagnosis_st_min
            $this->diagnosis_st_min->HrefValue = "";
            $this->diagnosis_st_min->TooltipValue = "";

            // diagnosis_st_max
            $this->diagnosis_st_max->HrefValue = "";
            $this->diagnosis_st_max->TooltipValue = "";

            // diagnosis_unit
            $this->diagnosis_unit->HrefValue = "";
            $this->diagnosis_unit->TooltipValue = "";

            // balance_amount
            $this->balance_amount->HrefValue = "";
            $this->balance_amount->TooltipValue = "";

            // age
            $this->age->HrefValue = "";
            $this->age->TooltipValue = "";

            // sex
            $this->sex->HrefValue = "";
            $this->sex->TooltipValue = "";

            // referral
            $this->referral->HrefValue = "";
            $this->referral->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // examination_grp
            $this->examination_grp->HrefValue = "";
            $this->examination_grp->TooltipValue = "";

            // diagnosis_datetime
            $this->diagnosis_datetime->HrefValue = "";
            $this->diagnosis_datetime->TooltipValue = "";

            // import_value
            $this->import_value->HrefValue = "";
            $this->import_value->TooltipValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";
            $this->total_amount->TooltipValue = "";

            // discount_amount
            $this->discount_amount->HrefValue = "";
            $this->discount_amount->TooltipValue = "";

            // received_amount
            $this->received_amount->HrefValue = "";
            $this->received_amount->TooltipValue = "";

            // examination_id
            $this->examination_id->HrefValue = "";
            $this->examination_id->TooltipValue = "";

            // examination_name
            $this->examination_name->HrefValue = "";
            $this->examination_name->TooltipValue = "";

            // uid
            $this->uid->HrefValue = "";
            $this->uid->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // user
            $this->user->HrefValue = "";
            $this->user->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // d_id
            $this->d_id->setupEditAttributes();
            $this->d_id->EditValue = $this->d_id->AdvancedSearch->SearchValue;
            $this->d_id->PlaceHolder = RemoveHtml($this->d_id->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $curVal = strval($this->mobile->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->EditValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->mobile->EditValue = null;
            }
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $curVal = strval($this->name->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->name->EditValue = $this->name->lookupCacheOption($curVal);
                if ($this->name->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->name->Lookup->getTable()->Fields["name"]->searchExpression(), "=", $curVal, $this->name->Lookup->getTable()->Fields["name"]->searchDataType(), "");
                    $sqlWrk = $this->name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->name->Lookup->renderViewRow($rswrk[0]);
                        $this->name->EditValue = $this->name->displayValue($arwrk);
                    } else {
                        $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->name->EditValue = null;
            }
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // examination_code
            $this->examination_code->setupEditAttributes();
            if (!$this->examination_code->Raw) {
                $this->examination_code->AdvancedSearch->SearchValue = HtmlDecode($this->examination_code->AdvancedSearch->SearchValue);
            }
            $this->examination_code->EditValue = HtmlEncode($this->examination_code->AdvancedSearch->SearchValue);
            $this->examination_code->PlaceHolder = RemoveHtml($this->examination_code->caption());

            // diagnosis_value
            $this->diagnosis_value->setupEditAttributes();
            if (!$this->diagnosis_value->Raw) {
                $this->diagnosis_value->AdvancedSearch->SearchValue = HtmlDecode($this->diagnosis_value->AdvancedSearch->SearchValue);
            }
            $this->diagnosis_value->EditValue = HtmlEncode($this->diagnosis_value->AdvancedSearch->SearchValue);
            $this->diagnosis_value->PlaceHolder = RemoveHtml($this->diagnosis_value->caption());

            // diagnosis_st_min
            $this->diagnosis_st_min->setupEditAttributes();
            $this->diagnosis_st_min->EditValue = $this->diagnosis_st_min->AdvancedSearch->SearchValue;
            $this->diagnosis_st_min->PlaceHolder = RemoveHtml($this->diagnosis_st_min->caption());

            // diagnosis_st_max
            $this->diagnosis_st_max->setupEditAttributes();
            $this->diagnosis_st_max->EditValue = $this->diagnosis_st_max->AdvancedSearch->SearchValue;
            $this->diagnosis_st_max->PlaceHolder = RemoveHtml($this->diagnosis_st_max->caption());

            // diagnosis_unit
            $this->diagnosis_unit->setupEditAttributes();
            if (!$this->diagnosis_unit->Raw) {
                $this->diagnosis_unit->AdvancedSearch->SearchValue = HtmlDecode($this->diagnosis_unit->AdvancedSearch->SearchValue);
            }
            $this->diagnosis_unit->EditValue = HtmlEncode($this->diagnosis_unit->AdvancedSearch->SearchValue);
            $this->diagnosis_unit->PlaceHolder = RemoveHtml($this->diagnosis_unit->caption());

            // balance_amount
            $this->balance_amount->setupEditAttributes();
            $this->balance_amount->EditValue = $this->balance_amount->AdvancedSearch->SearchValue;
            $this->balance_amount->PlaceHolder = RemoveHtml($this->balance_amount->caption());

            // age
            $this->age->setupEditAttributes();
            $this->age->EditValue = $this->age->AdvancedSearch->SearchValue;
            $this->age->PlaceHolder = RemoveHtml($this->age->caption());

            // sex
            $this->sex->EditValue = $this->sex->options(false);
            $this->sex->PlaceHolder = RemoveHtml($this->sex->caption());

            // referral
            $this->referral->setupEditAttributes();
            $this->referral->EditValue = $this->referral->AdvancedSearch->SearchValue;
            $curVal = strval($this->referral->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->referral->EditValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->EditValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->EditValue = HtmlEncode(FormatNumber($this->referral->AdvancedSearch->SearchValue, $this->referral->formatPattern()));
                    }
                }
            } else {
                $this->referral->EditValue = null;
            }
            $this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // examination_grp
            $this->examination_grp->setupEditAttributes();
            $curVal = trim(strval($this->examination_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->examination_grp->AdvancedSearch->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
            } else {
                $this->examination_grp->AdvancedSearch->ViewValue = $this->examination_grp->Lookup !== null && is_array($this->examination_grp->lookupOptions()) && count($this->examination_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->examination_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->examination_grp->EditValue = array_values($this->examination_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->examination_grp->AdvancedSearch->SearchValue, $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->examination_grp->EditValue = $arwrk;
            }
            $this->examination_grp->PlaceHolder = RemoveHtml($this->examination_grp->caption());

            // diagnosis_datetime
            $this->diagnosis_datetime->setupEditAttributes();
            $this->diagnosis_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->diagnosis_datetime->AdvancedSearch->SearchValue, $this->diagnosis_datetime->formatPattern()), $this->diagnosis_datetime->formatPattern()));
            $this->diagnosis_datetime->PlaceHolder = RemoveHtml($this->diagnosis_datetime->caption());

            // import_value
            $this->import_value->setupEditAttributes();
            $this->import_value->EditValue = HtmlEncode($this->import_value->AdvancedSearch->SearchValue);
            $this->import_value->PlaceHolder = RemoveHtml($this->import_value->caption());

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->AdvancedSearch->SearchValue;
            $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());

            // discount_amount
            $this->discount_amount->setupEditAttributes();
            $this->discount_amount->EditValue = $this->discount_amount->AdvancedSearch->SearchValue;
            $this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());

            // received_amount
            $this->received_amount->setupEditAttributes();
            $this->received_amount->EditValue = $this->received_amount->AdvancedSearch->SearchValue;
            $this->received_amount->PlaceHolder = RemoveHtml($this->received_amount->caption());

            // examination_id
            $this->examination_id->setupEditAttributes();
            $this->examination_id->EditValue = $this->examination_id->AdvancedSearch->SearchValue;
            $this->examination_id->PlaceHolder = RemoveHtml($this->examination_id->caption());

            // examination_name
            $this->examination_name->setupEditAttributes();
            if (!$this->examination_name->Raw) {
                $this->examination_name->AdvancedSearch->SearchValue = HtmlDecode($this->examination_name->AdvancedSearch->SearchValue);
            }
            $this->examination_name->EditValue = HtmlEncode($this->examination_name->AdvancedSearch->SearchValue);
            $this->examination_name->PlaceHolder = RemoveHtml($this->examination_name->caption());

            // uid
            $this->uid->setupEditAttributes();
            if (!$this->uid->Raw) {
                $this->uid->AdvancedSearch->SearchValue = HtmlDecode($this->uid->AdvancedSearch->SearchValue);
            }
            $this->uid->EditValue = HtmlEncode($this->uid->AdvancedSearch->SearchValue);
            $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // user
            $this->user->setupEditAttributes();
            $this->user->EditValue = $this->user->AdvancedSearch->SearchValue;
            $curVal = strval($this->user->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->user->EditValue = $this->user->lookupCacheOption($curVal);
                if ($this->user->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                        $this->user->EditValue = $this->user->displayValue($arwrk);
                    } else {
                        $this->user->EditValue = HtmlEncode(FormatNumber($this->user->AdvancedSearch->SearchValue, $this->user->formatPattern()));
                    }
                }
            } else {
                $this->user->EditValue = null;
            }
            $this->user->PlaceHolder = RemoveHtml($this->user->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->d_id->AdvancedSearch->SearchValue)) {
            $this->d_id->addErrorMessage($this->d_id->getErrorMessage(false));
        }
        if (!CheckNumber($this->diagnosis_st_max->AdvancedSearch->SearchValue)) {
            $this->diagnosis_st_max->addErrorMessage($this->diagnosis_st_max->getErrorMessage(false));
        }
        if (!CheckInteger($this->balance_amount->AdvancedSearch->SearchValue)) {
            $this->balance_amount->addErrorMessage($this->balance_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->age->AdvancedSearch->SearchValue)) {
            $this->age->addErrorMessage($this->age->getErrorMessage(false));
        }
        if (!CheckInteger($this->referral->AdvancedSearch->SearchValue)) {
            $this->referral->addErrorMessage($this->referral->getErrorMessage(false));
        }
        if (!CheckDate($this->diagnosis_datetime->AdvancedSearch->SearchValue, $this->diagnosis_datetime->formatPattern())) {
            $this->diagnosis_datetime->addErrorMessage($this->diagnosis_datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->total_amount->AdvancedSearch->SearchValue)) {
            $this->total_amount->addErrorMessage($this->total_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->discount_amount->AdvancedSearch->SearchValue)) {
            $this->discount_amount->addErrorMessage($this->discount_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->received_amount->AdvancedSearch->SearchValue)) {
            $this->received_amount->addErrorMessage($this->received_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->examination_id->AdvancedSearch->SearchValue)) {
            $this->examination_id->addErrorMessage($this->examination_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->user->AdvancedSearch->SearchValue)) {
            $this->user->addErrorMessage($this->user->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->d_id->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->examination_code->AdvancedSearch->load();
        $this->diagnosis_value->AdvancedSearch->load();
        $this->diagnosis_st_min->AdvancedSearch->load();
        $this->diagnosis_st_max->AdvancedSearch->load();
        $this->diagnosis_unit->AdvancedSearch->load();
        $this->balance_amount->AdvancedSearch->load();
        $this->age->AdvancedSearch->load();
        $this->sex->AdvancedSearch->load();
        $this->referral->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->examination_grp->AdvancedSearch->load();
        $this->diagnosis_datetime->AdvancedSearch->load();
        $this->import_value->AdvancedSearch->load();
        $this->total_amount->AdvancedSearch->load();
        $this->discount_amount->AdvancedSearch->load();
        $this->received_amount->AdvancedSearch->load();
        $this->examination_id->AdvancedSearch->load();
        $this->examination_name->AdvancedSearch->load();
        $this->uid->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->user->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lexaminationreportlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_mobile":
                    break;
                case "x_name":
                    break;
                case "x_sex":
                    break;
                case "x_referral":
                    break;
                case "x_examination_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_user":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
