<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LExaminationReportEdit extends LExaminationReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LExaminationReportEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lexaminationreportedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->d_id->setVisibility();
        $this->mobile->setVisibility();
        $this->name->setVisibility();
        $this->examination_code->setVisibility();
        $this->diagnosis_value->setVisibility();
        $this->diagnosis_st_min->setVisibility();
        $this->diagnosis_st_max->setVisibility();
        $this->diagnosis_unit->setVisibility();
        $this->balance_amount->setVisibility();
        $this->age->setVisibility();
        $this->sex->setVisibility();
        $this->referral->setVisibility();
        $this->remarks->setVisibility();
        $this->examination_grp->setVisibility();
        $this->diagnosis_datetime->setVisibility();
        $this->import_value->setVisibility();
        $this->total_amount->setVisibility();
        $this->discount_amount->setVisibility();
        $this->received_amount->setVisibility();
        $this->examination_id->setVisibility();
        $this->examination_name->setVisibility();
        $this->uid->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->user->Visible = false;
        $this->report_grp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'l_examination_report';
        $this->TableName = 'l_examination_report';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (l_examination_report)
        if (!isset($GLOBALS["l_examination_report"]) || $GLOBALS["l_examination_report"]::class == PROJECT_NAMESPACE . "l_examination_report") {
            $GLOBALS["l_examination_report"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination_report');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "lexaminationreportview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['uid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->d_id->Required = false;
        $this->mobile->Required = false;
        $this->examination_code->Required = false;
        $this->examination_grp->Required = false;
        $this->import_value->Required = false;
        $this->examination_name->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->mobile);
        $this->setupLookupOptions($this->name);
        $this->setupLookupOptions($this->sex);
        $this->setupLookupOptions($this->referral);
        $this->setupLookupOptions($this->examination_grp);
        $this->setupLookupOptions($this->user);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("uid") ?? Key(0) ?? Route(2)) !== null) {
                $this->uid->setQueryStringValue($keyValue);
                $this->uid->setOldValue($this->uid->QueryStringValue);
            } elseif (Post("uid") !== null) {
                $this->uid->setFormValue(Post("uid"));
                $this->uid->setOldValue($this->uid->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("uid") ?? Route("uid")) !== null) {
                    $this->uid->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->uid->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("lexaminationreportlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "lexaminationreportlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "lexaminationreportlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "lexaminationreportlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'd_id' first before field var 'x_d_id'
        $val = $CurrentForm->hasValue("d_id") ? $CurrentForm->getValue("d_id") : $CurrentForm->getValue("x_d_id");
        if (!$this->d_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_id->Visible = false; // Disable update for API request
            } else {
                $this->d_id->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'examination_code' first before field var 'x_examination_code'
        $val = $CurrentForm->hasValue("examination_code") ? $CurrentForm->getValue("examination_code") : $CurrentForm->getValue("x_examination_code");
        if (!$this->examination_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->examination_code->Visible = false; // Disable update for API request
            } else {
                $this->examination_code->setFormValue($val);
            }
        }

        // Check field name 'diagnosis_value' first before field var 'x_diagnosis_value'
        $val = $CurrentForm->hasValue("diagnosis_value") ? $CurrentForm->getValue("diagnosis_value") : $CurrentForm->getValue("x_diagnosis_value");
        if (!$this->diagnosis_value->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diagnosis_value->Visible = false; // Disable update for API request
            } else {
                $this->diagnosis_value->setFormValue($val);
            }
        }

        // Check field name 'diagnosis_st_min' first before field var 'x_diagnosis_st_min'
        $val = $CurrentForm->hasValue("diagnosis_st_min") ? $CurrentForm->getValue("diagnosis_st_min") : $CurrentForm->getValue("x_diagnosis_st_min");
        if (!$this->diagnosis_st_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diagnosis_st_min->Visible = false; // Disable update for API request
            } else {
                $this->diagnosis_st_min->setFormValue($val);
            }
        }

        // Check field name 'diagnosis_st_max' first before field var 'x_diagnosis_st_max'
        $val = $CurrentForm->hasValue("diagnosis_st_max") ? $CurrentForm->getValue("diagnosis_st_max") : $CurrentForm->getValue("x_diagnosis_st_max");
        if (!$this->diagnosis_st_max->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diagnosis_st_max->Visible = false; // Disable update for API request
            } else {
                $this->diagnosis_st_max->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'diagnosis_unit' first before field var 'x_diagnosis_unit'
        $val = $CurrentForm->hasValue("diagnosis_unit") ? $CurrentForm->getValue("diagnosis_unit") : $CurrentForm->getValue("x_diagnosis_unit");
        if (!$this->diagnosis_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diagnosis_unit->Visible = false; // Disable update for API request
            } else {
                $this->diagnosis_unit->setFormValue($val);
            }
        }

        // Check field name 'balance_amount' first before field var 'x_balance_amount'
        $val = $CurrentForm->hasValue("balance_amount") ? $CurrentForm->getValue("balance_amount") : $CurrentForm->getValue("x_balance_amount");
        if (!$this->balance_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->balance_amount->Visible = false; // Disable update for API request
            } else {
                $this->balance_amount->setFormValue($val);
            }
        }

        // Check field name 'age' first before field var 'x_age'
        $val = $CurrentForm->hasValue("age") ? $CurrentForm->getValue("age") : $CurrentForm->getValue("x_age");
        if (!$this->age->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->age->Visible = false; // Disable update for API request
            } else {
                $this->age->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sex' first before field var 'x_sex'
        $val = $CurrentForm->hasValue("sex") ? $CurrentForm->getValue("sex") : $CurrentForm->getValue("x_sex");
        if (!$this->sex->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sex->Visible = false; // Disable update for API request
            } else {
                $this->sex->setFormValue($val);
            }
        }

        // Check field name 'referral' first before field var 'x_referral'
        $val = $CurrentForm->hasValue("referral") ? $CurrentForm->getValue("referral") : $CurrentForm->getValue("x_referral");
        if (!$this->referral->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->referral->Visible = false; // Disable update for API request
            } else {
                $this->referral->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'examination_grp' first before field var 'x_examination_grp'
        $val = $CurrentForm->hasValue("examination_grp") ? $CurrentForm->getValue("examination_grp") : $CurrentForm->getValue("x_examination_grp");
        if (!$this->examination_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->examination_grp->Visible = false; // Disable update for API request
            } else {
                $this->examination_grp->setFormValue($val);
            }
        }

        // Check field name 'diagnosis_datetime' first before field var 'x_diagnosis_datetime'
        $val = $CurrentForm->hasValue("diagnosis_datetime") ? $CurrentForm->getValue("diagnosis_datetime") : $CurrentForm->getValue("x_diagnosis_datetime");
        if (!$this->diagnosis_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diagnosis_datetime->Visible = false; // Disable update for API request
            } else {
                $this->diagnosis_datetime->setFormValue($val);
            }
            $this->diagnosis_datetime->CurrentValue = UnFormatDateTime($this->diagnosis_datetime->CurrentValue, $this->diagnosis_datetime->formatPattern());
        }

        // Check field name 'import_value' first before field var 'x_import_value'
        $val = $CurrentForm->hasValue("import_value") ? $CurrentForm->getValue("import_value") : $CurrentForm->getValue("x_import_value");
        if (!$this->import_value->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->import_value->Visible = false; // Disable update for API request
            } else {
                $this->import_value->setFormValue($val);
            }
        }

        // Check field name 'total_amount' first before field var 'x_total_amount'
        $val = $CurrentForm->hasValue("total_amount") ? $CurrentForm->getValue("total_amount") : $CurrentForm->getValue("x_total_amount");
        if (!$this->total_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total_amount->Visible = false; // Disable update for API request
            } else {
                $this->total_amount->setFormValue($val);
            }
        }

        // Check field name 'discount_amount' first before field var 'x_discount_amount'
        $val = $CurrentForm->hasValue("discount_amount") ? $CurrentForm->getValue("discount_amount") : $CurrentForm->getValue("x_discount_amount");
        if (!$this->discount_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->discount_amount->Visible = false; // Disable update for API request
            } else {
                $this->discount_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'received_amount' first before field var 'x_received_amount'
        $val = $CurrentForm->hasValue("received_amount") ? $CurrentForm->getValue("received_amount") : $CurrentForm->getValue("x_received_amount");
        if (!$this->received_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->received_amount->Visible = false; // Disable update for API request
            } else {
                $this->received_amount->setFormValue($val);
            }
        }

        // Check field name 'examination_id' first before field var 'x_examination_id'
        $val = $CurrentForm->hasValue("examination_id") ? $CurrentForm->getValue("examination_id") : $CurrentForm->getValue("x_examination_id");
        if (!$this->examination_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->examination_id->Visible = false; // Disable update for API request
            } else {
                $this->examination_id->setFormValue($val);
            }
        }

        // Check field name 'examination_name' first before field var 'x_examination_name'
        $val = $CurrentForm->hasValue("examination_name") ? $CurrentForm->getValue("examination_name") : $CurrentForm->getValue("x_examination_name");
        if (!$this->examination_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->examination_name->Visible = false; // Disable update for API request
            } else {
                $this->examination_name->setFormValue($val);
            }
        }

        // Check field name 'uid' first before field var 'x_uid'
        $val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
        if (!$this->uid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->uid->Visible = false; // Disable update for API request
            } else {
                $this->uid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_uid")) {
            $this->uid->setOldValue($CurrentForm->getValue("o_uid"));
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->d_id->CurrentValue = $this->d_id->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->examination_code->CurrentValue = $this->examination_code->FormValue;
        $this->diagnosis_value->CurrentValue = $this->diagnosis_value->FormValue;
        $this->diagnosis_st_min->CurrentValue = $this->diagnosis_st_min->FormValue;
        $this->diagnosis_st_max->CurrentValue = $this->diagnosis_st_max->FormValue;
        $this->diagnosis_unit->CurrentValue = $this->diagnosis_unit->FormValue;
        $this->balance_amount->CurrentValue = $this->balance_amount->FormValue;
        $this->age->CurrentValue = $this->age->FormValue;
        $this->sex->CurrentValue = $this->sex->FormValue;
        $this->referral->CurrentValue = $this->referral->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->examination_grp->CurrentValue = $this->examination_grp->FormValue;
        $this->diagnosis_datetime->CurrentValue = $this->diagnosis_datetime->FormValue;
        $this->diagnosis_datetime->CurrentValue = UnFormatDateTime($this->diagnosis_datetime->CurrentValue, $this->diagnosis_datetime->formatPattern());
        $this->import_value->CurrentValue = $this->import_value->FormValue;
        $this->total_amount->CurrentValue = $this->total_amount->FormValue;
        $this->discount_amount->CurrentValue = $this->discount_amount->FormValue;
        $this->received_amount->CurrentValue = $this->received_amount->FormValue;
        $this->examination_id->CurrentValue = $this->examination_id->FormValue;
        $this->examination_name->CurrentValue = $this->examination_name->FormValue;
        $this->uid->CurrentValue = $this->uid->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->d_id->setDbValue($row['d_id']);
        $this->mobile->setDbValue($row['mobile']);
        $this->name->setDbValue($row['name']);
        $this->examination_code->setDbValue($row['examination_code']);
        $this->diagnosis_value->setDbValue($row['diagnosis_value']);
        $this->diagnosis_st_min->setDbValue($row['diagnosis_st_min']);
        $this->diagnosis_st_max->setDbValue($row['diagnosis_st_max']);
        $this->diagnosis_unit->setDbValue($row['diagnosis_unit']);
        $this->balance_amount->setDbValue($row['balance_amount']);
        $this->age->setDbValue($row['age']);
        $this->sex->setDbValue($row['sex']);
        $this->referral->setDbValue($row['referral']);
        $this->remarks->setDbValue($row['remarks']);
        $this->examination_grp->setDbValue($row['examination_grp']);
        $this->diagnosis_datetime->setDbValue($row['diagnosis_datetime']);
        $this->import_value->setDbValue($row['import_value']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->discount_amount->setDbValue($row['discount_amount']);
        $this->received_amount->setDbValue($row['received_amount']);
        $this->examination_id->setDbValue($row['examination_id']);
        $this->examination_name->setDbValue($row['examination_name']);
        $this->uid->setDbValue($row['uid']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->user->setDbValue($row['user']);
        $this->report_grp->setDbValue($row['report_grp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['d_id'] = $this->d_id->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['examination_code'] = $this->examination_code->DefaultValue;
        $row['diagnosis_value'] = $this->diagnosis_value->DefaultValue;
        $row['diagnosis_st_min'] = $this->diagnosis_st_min->DefaultValue;
        $row['diagnosis_st_max'] = $this->diagnosis_st_max->DefaultValue;
        $row['diagnosis_unit'] = $this->diagnosis_unit->DefaultValue;
        $row['balance_amount'] = $this->balance_amount->DefaultValue;
        $row['age'] = $this->age->DefaultValue;
        $row['sex'] = $this->sex->DefaultValue;
        $row['referral'] = $this->referral->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['examination_grp'] = $this->examination_grp->DefaultValue;
        $row['diagnosis_datetime'] = $this->diagnosis_datetime->DefaultValue;
        $row['import_value'] = $this->import_value->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['discount_amount'] = $this->discount_amount->DefaultValue;
        $row['received_amount'] = $this->received_amount->DefaultValue;
        $row['examination_id'] = $this->examination_id->DefaultValue;
        $row['examination_name'] = $this->examination_name->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['user'] = $this->user->DefaultValue;
        $row['report_grp'] = $this->report_grp->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // d_id
        $this->d_id->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // examination_code
        $this->examination_code->RowCssClass = "row";

        // diagnosis_value
        $this->diagnosis_value->RowCssClass = "row";

        // diagnosis_st_min
        $this->diagnosis_st_min->RowCssClass = "row";

        // diagnosis_st_max
        $this->diagnosis_st_max->RowCssClass = "row";

        // diagnosis_unit
        $this->diagnosis_unit->RowCssClass = "row";

        // balance_amount
        $this->balance_amount->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // sex
        $this->sex->RowCssClass = "row";

        // referral
        $this->referral->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // examination_grp
        $this->examination_grp->RowCssClass = "row";

        // diagnosis_datetime
        $this->diagnosis_datetime->RowCssClass = "row";

        // import_value
        $this->import_value->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // discount_amount
        $this->discount_amount->RowCssClass = "row";

        // received_amount
        $this->received_amount->RowCssClass = "row";

        // examination_id
        $this->examination_id->RowCssClass = "row";

        // examination_name
        $this->examination_name->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // user
        $this->user->RowCssClass = "row";

        // report_grp
        $this->report_grp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // d_id
            $this->d_id->ViewValue = $this->d_id->CurrentValue;
            $this->d_id->ViewValue = FormatNumber($this->d_id->ViewValue, $this->d_id->formatPattern());

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $curVal = strval($this->mobile->CurrentValue);
            if ($curVal != "") {
                $this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->ViewValue = $this->mobile->CurrentValue;
                    }
                }
            } else {
                $this->mobile->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;
            $curVal = strval($this->name->CurrentValue);
            if ($curVal != "") {
                $this->name->ViewValue = $this->name->lookupCacheOption($curVal);
                if ($this->name->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->name->Lookup->getTable()->Fields["name"]->searchExpression(), "=", $curVal, $this->name->Lookup->getTable()->Fields["name"]->searchDataType(), "");
                    $sqlWrk = $this->name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->name->Lookup->renderViewRow($rswrk[0]);
                        $this->name->ViewValue = $this->name->displayValue($arwrk);
                    } else {
                        $this->name->ViewValue = $this->name->CurrentValue;
                    }
                }
            } else {
                $this->name->ViewValue = null;
            }

            // examination_code
            $this->examination_code->ViewValue = $this->examination_code->CurrentValue;

            // diagnosis_value
            $this->diagnosis_value->ViewValue = $this->diagnosis_value->CurrentValue;

            // diagnosis_st_min
            $this->diagnosis_st_min->ViewValue = $this->diagnosis_st_min->CurrentValue;
            $this->diagnosis_st_min->ViewValue = FormatNumber($this->diagnosis_st_min->ViewValue, $this->diagnosis_st_min->formatPattern());

            // diagnosis_st_max
            $this->diagnosis_st_max->ViewValue = $this->diagnosis_st_max->CurrentValue;
            $this->diagnosis_st_max->ViewValue = FormatNumber($this->diagnosis_st_max->ViewValue, $this->diagnosis_st_max->formatPattern());

            // diagnosis_unit
            $this->diagnosis_unit->ViewValue = $this->diagnosis_unit->CurrentValue;

            // balance_amount
            $this->balance_amount->ViewValue = $this->balance_amount->CurrentValue;
            $this->balance_amount->ViewValue = FormatNumber($this->balance_amount->ViewValue, $this->balance_amount->formatPattern());

            // age
            $this->age->ViewValue = $this->age->CurrentValue;
            $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

            // sex
            if (strval($this->sex->CurrentValue) != "") {
                $this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
            } else {
                $this->sex->ViewValue = null;
            }

            // referral
            $this->referral->ViewValue = $this->referral->CurrentValue;
            $curVal = strval($this->referral->CurrentValue);
            if ($curVal != "") {
                $this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->ViewValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->ViewValue = FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern());
                    }
                }
            } else {
                $this->referral->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // examination_grp
            $curVal = strval($this->examination_grp->CurrentValue);
            if ($curVal != "") {
                $this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
                if ($this->examination_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->examination_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->examination_grp->ViewValue = $this->examination_grp->displayValue($arwrk);
                    } else {
                        $this->examination_grp->ViewValue = FormatNumber($this->examination_grp->CurrentValue, $this->examination_grp->formatPattern());
                    }
                }
            } else {
                $this->examination_grp->ViewValue = null;
            }

            // diagnosis_datetime
            $this->diagnosis_datetime->ViewValue = $this->diagnosis_datetime->CurrentValue;
            $this->diagnosis_datetime->ViewValue = FormatDateTime($this->diagnosis_datetime->ViewValue, $this->diagnosis_datetime->formatPattern());

            // import_value
            $this->import_value->ViewValue = $this->import_value->CurrentValue;

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // discount_amount
            $this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
            $this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, $this->discount_amount->formatPattern());

            // received_amount
            $this->received_amount->ViewValue = $this->received_amount->CurrentValue;
            $this->received_amount->ViewValue = FormatNumber($this->received_amount->ViewValue, $this->received_amount->formatPattern());

            // examination_id
            $this->examination_id->ViewValue = $this->examination_id->CurrentValue;
            $this->examination_id->ViewValue = FormatNumber($this->examination_id->ViewValue, $this->examination_id->formatPattern());

            // examination_name
            $this->examination_name->ViewValue = $this->examination_name->CurrentValue;

            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // user
            $this->user->ViewValue = $this->user->CurrentValue;
            $curVal = strval($this->user->CurrentValue);
            if ($curVal != "") {
                $this->user->ViewValue = $this->user->lookupCacheOption($curVal);
                if ($this->user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                        $this->user->ViewValue = $this->user->displayValue($arwrk);
                    } else {
                        $this->user->ViewValue = FormatNumber($this->user->CurrentValue, $this->user->formatPattern());
                    }
                }
            } else {
                $this->user->ViewValue = null;
            }

            // d_id
            $this->d_id->HrefValue = "";
            $this->d_id->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // name
            $this->name->HrefValue = "";

            // examination_code
            $this->examination_code->HrefValue = "";
            $this->examination_code->TooltipValue = "";

            // diagnosis_value
            $this->diagnosis_value->HrefValue = "";

            // diagnosis_st_min
            $this->diagnosis_st_min->HrefValue = "";

            // diagnosis_st_max
            $this->diagnosis_st_max->HrefValue = "";

            // diagnosis_unit
            $this->diagnosis_unit->HrefValue = "";

            // balance_amount
            $this->balance_amount->HrefValue = "";
            $this->balance_amount->TooltipValue = "";

            // age
            $this->age->HrefValue = "";

            // sex
            $this->sex->HrefValue = "";

            // referral
            $this->referral->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // examination_grp
            $this->examination_grp->HrefValue = "";
            $this->examination_grp->TooltipValue = "";

            // diagnosis_datetime
            $this->diagnosis_datetime->HrefValue = "";
            $this->diagnosis_datetime->TooltipValue = "";

            // import_value
            $this->import_value->HrefValue = "";
            $this->import_value->TooltipValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";
            $this->total_amount->TooltipValue = "";

            // discount_amount
            $this->discount_amount->HrefValue = "";

            // received_amount
            $this->received_amount->HrefValue = "";
            $this->received_amount->TooltipValue = "";

            // examination_id
            $this->examination_id->HrefValue = "";
            $this->examination_id->TooltipValue = "";

            // examination_name
            $this->examination_name->HrefValue = "";
            $this->examination_name->TooltipValue = "";

            // uid
            $this->uid->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // d_id
            $this->d_id->setupEditAttributes();
            $this->d_id->EditValue = $this->d_id->CurrentValue;
            $this->d_id->EditValue = FormatNumber($this->d_id->EditValue, $this->d_id->formatPattern());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $curVal = strval($this->mobile->CurrentValue);
            if ($curVal != "") {
                $this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->EditValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->EditValue = $this->mobile->CurrentValue;
                    }
                }
            } else {
                $this->mobile->EditValue = null;
            }

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $curVal = strval($this->name->CurrentValue);
            if ($curVal != "") {
                $this->name->EditValue = $this->name->lookupCacheOption($curVal);
                if ($this->name->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->name->Lookup->getTable()->Fields["name"]->searchExpression(), "=", $curVal, $this->name->Lookup->getTable()->Fields["name"]->searchDataType(), "");
                    $sqlWrk = $this->name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->name->Lookup->renderViewRow($rswrk[0]);
                        $this->name->EditValue = $this->name->displayValue($arwrk);
                    } else {
                        $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
                    }
                }
            } else {
                $this->name->EditValue = null;
            }
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // examination_code
            $this->examination_code->setupEditAttributes();
            $this->examination_code->EditValue = $this->examination_code->CurrentValue;

            // diagnosis_value
            $this->diagnosis_value->setupEditAttributes();
            if (!$this->diagnosis_value->Raw) {
                $this->diagnosis_value->CurrentValue = HtmlDecode($this->diagnosis_value->CurrentValue);
            }
            $this->diagnosis_value->EditValue = HtmlEncode($this->diagnosis_value->CurrentValue);
            $this->diagnosis_value->PlaceHolder = RemoveHtml($this->diagnosis_value->caption());

            // diagnosis_st_min
            $this->diagnosis_st_min->setupEditAttributes();
            $this->diagnosis_st_min->EditValue = $this->diagnosis_st_min->CurrentValue;
            $this->diagnosis_st_min->PlaceHolder = RemoveHtml($this->diagnosis_st_min->caption());
            if (strval($this->diagnosis_st_min->EditValue) != "" && is_numeric($this->diagnosis_st_min->EditValue)) {
                $this->diagnosis_st_min->EditValue = FormatNumber($this->diagnosis_st_min->EditValue, null);
            }

            // diagnosis_st_max
            $this->diagnosis_st_max->setupEditAttributes();
            $this->diagnosis_st_max->EditValue = $this->diagnosis_st_max->CurrentValue;
            $this->diagnosis_st_max->PlaceHolder = RemoveHtml($this->diagnosis_st_max->caption());
            if (strval($this->diagnosis_st_max->EditValue) != "" && is_numeric($this->diagnosis_st_max->EditValue)) {
                $this->diagnosis_st_max->EditValue = FormatNumber($this->diagnosis_st_max->EditValue, null);
            }

            // diagnosis_unit
            $this->diagnosis_unit->setupEditAttributes();
            if (!$this->diagnosis_unit->Raw) {
                $this->diagnosis_unit->CurrentValue = HtmlDecode($this->diagnosis_unit->CurrentValue);
            }
            $this->diagnosis_unit->EditValue = HtmlEncode($this->diagnosis_unit->CurrentValue);
            $this->diagnosis_unit->PlaceHolder = RemoveHtml($this->diagnosis_unit->caption());

            // balance_amount
            $this->balance_amount->setupEditAttributes();
            $this->balance_amount->EditValue = $this->balance_amount->CurrentValue;
            $this->balance_amount->EditValue = FormatNumber($this->balance_amount->EditValue, $this->balance_amount->formatPattern());

            // age
            $this->age->setupEditAttributes();
            $this->age->EditValue = $this->age->CurrentValue;
            $this->age->PlaceHolder = RemoveHtml($this->age->caption());
            if (strval($this->age->EditValue) != "" && is_numeric($this->age->EditValue)) {
                $this->age->EditValue = FormatNumber($this->age->EditValue, null);
            }

            // sex
            $this->sex->EditValue = $this->sex->options(false);
            $this->sex->PlaceHolder = RemoveHtml($this->sex->caption());

            // referral
            $this->referral->setupEditAttributes();
            $this->referral->EditValue = $this->referral->CurrentValue;
            $curVal = strval($this->referral->CurrentValue);
            if ($curVal != "") {
                $this->referral->EditValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->EditValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->EditValue = HtmlEncode(FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern()));
                    }
                }
            } else {
                $this->referral->EditValue = null;
            }
            $this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = $this->remarks->CurrentValue;

            // examination_grp
            $this->examination_grp->setupEditAttributes();
            $curVal = strval($this->examination_grp->CurrentValue);
            if ($curVal != "") {
                $this->examination_grp->EditValue = $this->examination_grp->lookupCacheOption($curVal);
                if ($this->examination_grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->examination_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->examination_grp->EditValue = $this->examination_grp->displayValue($arwrk);
                    } else {
                        $this->examination_grp->EditValue = FormatNumber($this->examination_grp->CurrentValue, $this->examination_grp->formatPattern());
                    }
                }
            } else {
                $this->examination_grp->EditValue = null;
            }

            // diagnosis_datetime
            $this->diagnosis_datetime->setupEditAttributes();
            $this->diagnosis_datetime->EditValue = $this->diagnosis_datetime->CurrentValue;
            $this->diagnosis_datetime->EditValue = FormatDateTime($this->diagnosis_datetime->EditValue, $this->diagnosis_datetime->formatPattern());

            // import_value
            $this->import_value->setupEditAttributes();
            $this->import_value->EditValue = $this->import_value->CurrentValue;

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->CurrentValue;
            $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, $this->total_amount->formatPattern());

            // discount_amount
            $this->discount_amount->setupEditAttributes();
            $this->discount_amount->EditValue = $this->discount_amount->CurrentValue;
            $this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());
            if (strval($this->discount_amount->EditValue) != "" && is_numeric($this->discount_amount->EditValue)) {
                $this->discount_amount->EditValue = FormatNumber($this->discount_amount->EditValue, null);
            }

            // received_amount
            $this->received_amount->setupEditAttributes();
            $this->received_amount->EditValue = $this->received_amount->CurrentValue;
            $this->received_amount->EditValue = FormatNumber($this->received_amount->EditValue, $this->received_amount->formatPattern());

            // examination_id
            $this->examination_id->setupEditAttributes();
            $this->examination_id->EditValue = $this->examination_id->CurrentValue;
            $this->examination_id->EditValue = FormatNumber($this->examination_id->EditValue, $this->examination_id->formatPattern());

            // examination_name
            $this->examination_name->setupEditAttributes();
            $this->examination_name->EditValue = $this->examination_name->CurrentValue;

            // uid
            $this->uid->setupEditAttributes();
            if (!$this->uid->Raw) {
                $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
            }
            $this->uid->EditValue = HtmlEncode($this->uid->CurrentValue);
            $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

            // operator

            // datetime

            // Edit refer script

            // d_id
            $this->d_id->HrefValue = "";
            $this->d_id->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // name
            $this->name->HrefValue = "";

            // examination_code
            $this->examination_code->HrefValue = "";
            $this->examination_code->TooltipValue = "";

            // diagnosis_value
            $this->diagnosis_value->HrefValue = "";

            // diagnosis_st_min
            $this->diagnosis_st_min->HrefValue = "";

            // diagnosis_st_max
            $this->diagnosis_st_max->HrefValue = "";

            // diagnosis_unit
            $this->diagnosis_unit->HrefValue = "";

            // balance_amount
            $this->balance_amount->HrefValue = "";
            $this->balance_amount->TooltipValue = "";

            // age
            $this->age->HrefValue = "";

            // sex
            $this->sex->HrefValue = "";

            // referral
            $this->referral->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // examination_grp
            $this->examination_grp->HrefValue = "";
            $this->examination_grp->TooltipValue = "";

            // diagnosis_datetime
            $this->diagnosis_datetime->HrefValue = "";
            $this->diagnosis_datetime->TooltipValue = "";

            // import_value
            $this->import_value->HrefValue = "";
            $this->import_value->TooltipValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";
            $this->total_amount->TooltipValue = "";

            // discount_amount
            $this->discount_amount->HrefValue = "";

            // received_amount
            $this->received_amount->HrefValue = "";
            $this->received_amount->TooltipValue = "";

            // examination_id
            $this->examination_id->HrefValue = "";
            $this->examination_id->TooltipValue = "";

            // examination_name
            $this->examination_name->HrefValue = "";
            $this->examination_name->TooltipValue = "";

            // uid
            $this->uid->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->d_id->Visible && $this->d_id->Required) {
                if (!$this->d_id->IsDetailKey && EmptyValue($this->d_id->FormValue)) {
                    $this->d_id->addErrorMessage(str_replace("%s", $this->d_id->caption(), $this->d_id->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->examination_code->Visible && $this->examination_code->Required) {
                if (!$this->examination_code->IsDetailKey && EmptyValue($this->examination_code->FormValue)) {
                    $this->examination_code->addErrorMessage(str_replace("%s", $this->examination_code->caption(), $this->examination_code->RequiredErrorMessage));
                }
            }
            if ($this->diagnosis_value->Visible && $this->diagnosis_value->Required) {
                if (!$this->diagnosis_value->IsDetailKey && EmptyValue($this->diagnosis_value->FormValue)) {
                    $this->diagnosis_value->addErrorMessage(str_replace("%s", $this->diagnosis_value->caption(), $this->diagnosis_value->RequiredErrorMessage));
                }
            }
            if ($this->diagnosis_st_min->Visible && $this->diagnosis_st_min->Required) {
                if (!$this->diagnosis_st_min->IsDetailKey && EmptyValue($this->diagnosis_st_min->FormValue)) {
                    $this->diagnosis_st_min->addErrorMessage(str_replace("%s", $this->diagnosis_st_min->caption(), $this->diagnosis_st_min->RequiredErrorMessage));
                }
            }
            if ($this->diagnosis_st_max->Visible && $this->diagnosis_st_max->Required) {
                if (!$this->diagnosis_st_max->IsDetailKey && EmptyValue($this->diagnosis_st_max->FormValue)) {
                    $this->diagnosis_st_max->addErrorMessage(str_replace("%s", $this->diagnosis_st_max->caption(), $this->diagnosis_st_max->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->diagnosis_st_max->FormValue)) {
                $this->diagnosis_st_max->addErrorMessage($this->diagnosis_st_max->getErrorMessage(false));
            }
            if ($this->diagnosis_unit->Visible && $this->diagnosis_unit->Required) {
                if (!$this->diagnosis_unit->IsDetailKey && EmptyValue($this->diagnosis_unit->FormValue)) {
                    $this->diagnosis_unit->addErrorMessage(str_replace("%s", $this->diagnosis_unit->caption(), $this->diagnosis_unit->RequiredErrorMessage));
                }
            }
            if ($this->balance_amount->Visible && $this->balance_amount->Required) {
                if (!$this->balance_amount->IsDetailKey && EmptyValue($this->balance_amount->FormValue)) {
                    $this->balance_amount->addErrorMessage(str_replace("%s", $this->balance_amount->caption(), $this->balance_amount->RequiredErrorMessage));
                }
            }
            if ($this->age->Visible && $this->age->Required) {
                if (!$this->age->IsDetailKey && EmptyValue($this->age->FormValue)) {
                    $this->age->addErrorMessage(str_replace("%s", $this->age->caption(), $this->age->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->age->FormValue)) {
                $this->age->addErrorMessage($this->age->getErrorMessage(false));
            }
            if ($this->sex->Visible && $this->sex->Required) {
                if ($this->sex->FormValue == "") {
                    $this->sex->addErrorMessage(str_replace("%s", $this->sex->caption(), $this->sex->RequiredErrorMessage));
                }
            }
            if ($this->referral->Visible && $this->referral->Required) {
                if (!$this->referral->IsDetailKey && EmptyValue($this->referral->FormValue)) {
                    $this->referral->addErrorMessage(str_replace("%s", $this->referral->caption(), $this->referral->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->referral->FormValue)) {
                $this->referral->addErrorMessage($this->referral->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->examination_grp->Visible && $this->examination_grp->Required) {
                if (!$this->examination_grp->IsDetailKey && EmptyValue($this->examination_grp->FormValue)) {
                    $this->examination_grp->addErrorMessage(str_replace("%s", $this->examination_grp->caption(), $this->examination_grp->RequiredErrorMessage));
                }
            }
            if ($this->diagnosis_datetime->Visible && $this->diagnosis_datetime->Required) {
                if (!$this->diagnosis_datetime->IsDetailKey && EmptyValue($this->diagnosis_datetime->FormValue)) {
                    $this->diagnosis_datetime->addErrorMessage(str_replace("%s", $this->diagnosis_datetime->caption(), $this->diagnosis_datetime->RequiredErrorMessage));
                }
            }
            if ($this->import_value->Visible && $this->import_value->Required) {
                if (!$this->import_value->IsDetailKey && EmptyValue($this->import_value->FormValue)) {
                    $this->import_value->addErrorMessage(str_replace("%s", $this->import_value->caption(), $this->import_value->RequiredErrorMessage));
                }
            }
            if ($this->total_amount->Visible && $this->total_amount->Required) {
                if (!$this->total_amount->IsDetailKey && EmptyValue($this->total_amount->FormValue)) {
                    $this->total_amount->addErrorMessage(str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
                }
            }
            if ($this->discount_amount->Visible && $this->discount_amount->Required) {
                if (!$this->discount_amount->IsDetailKey && EmptyValue($this->discount_amount->FormValue)) {
                    $this->discount_amount->addErrorMessage(str_replace("%s", $this->discount_amount->caption(), $this->discount_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->discount_amount->FormValue)) {
                $this->discount_amount->addErrorMessage($this->discount_amount->getErrorMessage(false));
            }
            if ($this->received_amount->Visible && $this->received_amount->Required) {
                if (!$this->received_amount->IsDetailKey && EmptyValue($this->received_amount->FormValue)) {
                    $this->received_amount->addErrorMessage(str_replace("%s", $this->received_amount->caption(), $this->received_amount->RequiredErrorMessage));
                }
            }
            if ($this->examination_id->Visible && $this->examination_id->Required) {
                if (!$this->examination_id->IsDetailKey && EmptyValue($this->examination_id->FormValue)) {
                    $this->examination_id->addErrorMessage(str_replace("%s", $this->examination_id->caption(), $this->examination_id->RequiredErrorMessage));
                }
            }
            if ($this->examination_name->Visible && $this->examination_name->Required) {
                if (!$this->examination_name->IsDetailKey && EmptyValue($this->examination_name->FormValue)) {
                    $this->examination_name->addErrorMessage(str_replace("%s", $this->examination_name->caption(), $this->examination_name->RequiredErrorMessage));
                }
            }
            if ($this->uid->Visible && $this->uid->Required) {
                if (!$this->uid->IsDetailKey && EmptyValue($this->uid->FormValue)) {
                    $this->uid->addErrorMessage(str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (uid)
        if ($this->uid->CurrentValue != "") {
            $filterChk = "(`uid` = '" . AdjustSql($this->uid->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->uid->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->uid->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);

        // Check for duplicate key when key changed
        if ($updateRow) {
            $newKeyFilter = $this->getRecordFilter($rsnew);
            if ($newKeyFilter != $oldKeyFilter) {
                $rsChk = $this->loadRs($newKeyFilter)->fetch();
                if ($rsChk !== false) {
                    $keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
                    $this->setFailureMessage($keyErrMsg);
                    $updateRow = false;
                }
            }
        }
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // diagnosis_value
        $this->diagnosis_value->setDbValueDef($rsnew, $this->diagnosis_value->CurrentValue, $this->diagnosis_value->ReadOnly);

        // diagnosis_st_min
        $this->diagnosis_st_min->setDbValueDef($rsnew, $this->diagnosis_st_min->CurrentValue, $this->diagnosis_st_min->ReadOnly);

        // diagnosis_st_max
        $this->diagnosis_st_max->setDbValueDef($rsnew, $this->diagnosis_st_max->CurrentValue, $this->diagnosis_st_max->ReadOnly);

        // diagnosis_unit
        $this->diagnosis_unit->setDbValueDef($rsnew, $this->diagnosis_unit->CurrentValue, $this->diagnosis_unit->ReadOnly);

        // age
        $this->age->setDbValueDef($rsnew, $this->age->CurrentValue, $this->age->ReadOnly);

        // sex
        $this->sex->setDbValueDef($rsnew, $this->sex->CurrentValue, $this->sex->ReadOnly);

        // referral
        $this->referral->setDbValueDef($rsnew, $this->referral->CurrentValue, $this->referral->ReadOnly);

        // discount_amount
        $this->discount_amount->setDbValueDef($rsnew, $this->discount_amount->CurrentValue, $this->discount_amount->ReadOnly);

        // uid
        $this->uid->setDbValueDef($rsnew, $this->uid->CurrentValue, $this->uid->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['diagnosis_value'])) { // diagnosis_value
            $this->diagnosis_value->CurrentValue = $row['diagnosis_value'];
        }
        if (isset($row['diagnosis_st_min'])) { // diagnosis_st_min
            $this->diagnosis_st_min->CurrentValue = $row['diagnosis_st_min'];
        }
        if (isset($row['diagnosis_st_max'])) { // diagnosis_st_max
            $this->diagnosis_st_max->CurrentValue = $row['diagnosis_st_max'];
        }
        if (isset($row['diagnosis_unit'])) { // diagnosis_unit
            $this->diagnosis_unit->CurrentValue = $row['diagnosis_unit'];
        }
        if (isset($row['age'])) { // age
            $this->age->CurrentValue = $row['age'];
        }
        if (isset($row['sex'])) { // sex
            $this->sex->CurrentValue = $row['sex'];
        }
        if (isset($row['referral'])) { // referral
            $this->referral->CurrentValue = $row['referral'];
        }
        if (isset($row['discount_amount'])) { // discount_amount
            $this->discount_amount->CurrentValue = $row['discount_amount'];
        }
        if (isset($row['uid'])) { // uid
            $this->uid->CurrentValue = $row['uid'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lexaminationreportlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_mobile":
                    break;
                case "x_name":
                    break;
                case "x_sex":
                    break;
                case "x_referral":
                    break;
                case "x_examination_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_user":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
