<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for l_examination_report
 */
class LExaminationReport extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = true;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $d_id;
    public $mobile;
    public $name;
    public $examination_code;
    public $diagnosis_value;
    public $diagnosis_st_min;
    public $diagnosis_st_max;
    public $diagnosis_unit;
    public $balance_amount;
    public $age;
    public $sex;
    public $referral;
    public $remarks;
    public $examination_grp;
    public $diagnosis_datetime;
    public $import_value;
    public $total_amount;
    public $discount_amount;
    public $received_amount;
    public $examination_id;
    public $examination_name;
    public $uid;
    public $operator;
    public $datetime;
    public $user;
    public $report_grp;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "l_examination_report";
        $this->TableName = 'l_examination_report';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "l_examination_report";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // d_id
        $this->d_id = new DbField(
            $this, // Table
            'x_d_id', // Variable name
            'd_id', // Name
            '`d_id`', // Expression
            '`d_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_id->InputTextType = "text";
        $this->d_id->Raw = true;
        $this->d_id->Nullable = false; // NOT NULL field
        $this->d_id->Required = true; // Required field
        $this->d_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_id'] = &$this->d_id;

        // mobile
        $this->mobile = new DbField(
            $this, // Table
            'x_mobile', // Variable name
            'mobile', // Name
            '`mobile`', // Expression
            '`mobile`', // Basic search expression
            200, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mobile`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mobile->InputTextType = "text";
        $this->mobile->Required = true; // Required field
        $this->mobile->Lookup = new Lookup($this->mobile, 'user', true, 'mobile', ["mobile","","",""], '', '', [], ["x_name"], [], [], ["name"], ["x_name"], true, '`mobile` ASC', '', "`mobile`");
        $this->mobile->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['mobile'] = &$this->mobile;

        // name
        $this->name = new DbField(
            $this, // Table
            'x_name', // Variable name
            'name', // Name
            '`name`', // Expression
            '`name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->name->InputTextType = "text";
        $this->name->Required = true; // Required field
        $this->name->Lookup = new Lookup($this->name, 'l_examination', true, 'name', ["name","","",""], '', '', ["x_mobile"], [], ["mobile"], ["x_mobile"], ["mobile"], ["x_mobile"], true, '`name` ASC', '', "`name`");
        $this->name->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['name'] = &$this->name;

        // examination_code
        $this->examination_code = new DbField(
            $this, // Table
            'x_examination_code', // Variable name
            'examination_code', // Name
            '`examination_code`', // Expression
            '`examination_code`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`examination_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->examination_code->InputTextType = "text";
        $this->examination_code->Nullable = false; // NOT NULL field
        $this->examination_code->Required = true; // Required field
        $this->examination_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['examination_code'] = &$this->examination_code;

        // diagnosis_value
        $this->diagnosis_value = new DbField(
            $this, // Table
            'x_diagnosis_value', // Variable name
            'diagnosis_value', // Name
            '`diagnosis_value`', // Expression
            '`diagnosis_value`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diagnosis_value`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diagnosis_value->InputTextType = "text";
        $this->diagnosis_value->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['diagnosis_value'] = &$this->diagnosis_value;

        // diagnosis_st_min
        $this->diagnosis_st_min = new DbField(
            $this, // Table
            'x_diagnosis_st_min', // Variable name
            'diagnosis_st_min', // Name
            '`diagnosis_st_min`', // Expression
            '`diagnosis_st_min`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diagnosis_st_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diagnosis_st_min->InputTextType = "text";
        $this->diagnosis_st_min->Raw = true;
        $this->diagnosis_st_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['diagnosis_st_min'] = &$this->diagnosis_st_min;

        // diagnosis_st_max
        $this->diagnosis_st_max = new DbField(
            $this, // Table
            'x_diagnosis_st_max', // Variable name
            'diagnosis_st_max', // Name
            '`diagnosis_st_max`', // Expression
            '`diagnosis_st_max`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diagnosis_st_max`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diagnosis_st_max->InputTextType = "text";
        $this->diagnosis_st_max->Raw = true;
        $this->diagnosis_st_max->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->diagnosis_st_max->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['diagnosis_st_max'] = &$this->diagnosis_st_max;

        // diagnosis_unit
        $this->diagnosis_unit = new DbField(
            $this, // Table
            'x_diagnosis_unit', // Variable name
            'diagnosis_unit', // Name
            '`diagnosis_unit`', // Expression
            '`diagnosis_unit`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diagnosis_unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diagnosis_unit->InputTextType = "text";
        $this->diagnosis_unit->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['diagnosis_unit'] = &$this->diagnosis_unit;

        // balance_amount
        $this->balance_amount = new DbField(
            $this, // Table
            'x_balance_amount', // Variable name
            'balance_amount', // Name
            '`balance_amount`', // Expression
            '`balance_amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`balance_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->balance_amount->InputTextType = "text";
        $this->balance_amount->Raw = true;
        $this->balance_amount->Nullable = false; // NOT NULL field
        $this->balance_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->balance_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['balance_amount'] = &$this->balance_amount;

        // age
        $this->age = new DbField(
            $this, // Table
            'x_age', // Variable name
            'age', // Name
            '`age`', // Expression
            '`age`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->age->InputTextType = "text";
        $this->age->Raw = true;
        $this->age->Nullable = false; // NOT NULL field
        $this->age->Required = true; // Required field
        $this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['age'] = &$this->age;

        // sex
        $this->sex = new DbField(
            $this, // Table
            'x_sex', // Variable name
            'sex', // Name
            '`sex`', // Expression
            '`sex`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sex`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->sex->InputTextType = "text";
        $this->sex->Raw = true;
        $this->sex->Nullable = false; // NOT NULL field
        $this->sex->Required = true; // Required field
        $this->sex->Lookup = new Lookup($this->sex, 'l_examination_report', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->sex->OptionCount = 3;
        $this->sex->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sex->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sex'] = &$this->sex;

        // referral
        $this->referral = new DbField(
            $this, // Table
            'x_referral', // Variable name
            'referral', // Name
            '`referral`', // Expression
            '`referral`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`referral`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->referral->InputTextType = "text";
        $this->referral->Raw = true;
        $this->referral->Lookup = new Lookup($this->referral, 'l_referral', false, 'id', ["name","mobile","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->referral) . "',COALESCE(`mobile`,''))");
        $this->referral->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->referral->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['referral'] = &$this->referral;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // examination_grp
        $this->examination_grp = new DbField(
            $this, // Table
            'x_examination_grp', // Variable name
            'examination_grp', // Name
            '`examination_grp`', // Expression
            '`examination_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`examination_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->examination_grp->addMethod("getSelectFilter", fn() => "`status`=1 and `grp` = 2");
        $this->examination_grp->InputTextType = "text";
        $this->examination_grp->Raw = true;
        $this->examination_grp->Nullable = false; // NOT NULL field
        $this->examination_grp->Required = true; // Required field
        $this->examination_grp->setSelectMultiple(false); // Select one
        $this->examination_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->examination_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->examination_grp->Lookup = new Lookup($this->examination_grp, 'l_examination_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->examination_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->examination_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['examination_grp'] = &$this->examination_grp;

        // diagnosis_datetime
        $this->diagnosis_datetime = new DbField(
            $this, // Table
            'x_diagnosis_datetime', // Variable name
            'diagnosis_datetime', // Name
            '`diagnosis_datetime`', // Expression
            CastDateFieldForLike("`diagnosis_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`diagnosis_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diagnosis_datetime->InputTextType = "text";
        $this->diagnosis_datetime->Raw = true;
        $this->diagnosis_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->diagnosis_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['diagnosis_datetime'] = &$this->diagnosis_datetime;

        // import_value
        $this->import_value = new DbField(
            $this, // Table
            'x_import_value', // Variable name
            'import_value', // Name
            '`import_value`', // Expression
            '`import_value`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`import_value`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->import_value->InputTextType = "text";
        $this->import_value->Nullable = false; // NOT NULL field
        $this->import_value->Required = true; // Required field
        $this->import_value->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['import_value'] = &$this->import_value;

        // total_amount
        $this->total_amount = new DbField(
            $this, // Table
            'x_total_amount', // Variable name
            'total_amount', // Name
            '`total_amount`', // Expression
            '`total_amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`total_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->total_amount->InputTextType = "text";
        $this->total_amount->Raw = true;
        $this->total_amount->Nullable = false; // NOT NULL field
        $this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->total_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['total_amount'] = &$this->total_amount;

        // discount_amount
        $this->discount_amount = new DbField(
            $this, // Table
            'x_discount_amount', // Variable name
            'discount_amount', // Name
            '`discount_amount`', // Expression
            '`discount_amount`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`discount_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->discount_amount->addMethod("getDefault", fn() => 0.00);
        $this->discount_amount->InputTextType = "text";
        $this->discount_amount->Raw = true;
        $this->discount_amount->Nullable = false; // NOT NULL field
        $this->discount_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->discount_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['discount_amount'] = &$this->discount_amount;

        // received_amount
        $this->received_amount = new DbField(
            $this, // Table
            'x_received_amount', // Variable name
            'received_amount', // Name
            '`received_amount`', // Expression
            '`received_amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`received_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->received_amount->InputTextType = "text";
        $this->received_amount->Raw = true;
        $this->received_amount->Nullable = false; // NOT NULL field
        $this->received_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->received_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['received_amount'] = &$this->received_amount;

        // examination_id
        $this->examination_id = new DbField(
            $this, // Table
            'x_examination_id', // Variable name
            'examination_id', // Name
            '`examination_id`', // Expression
            '`examination_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`examination_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->examination_id->InputTextType = "text";
        $this->examination_id->Raw = true;
        $this->examination_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->examination_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['examination_id'] = &$this->examination_id;

        // examination_name
        $this->examination_name = new DbField(
            $this, // Table
            'x_examination_name', // Variable name
            'examination_name', // Name
            '`examination_name`', // Expression
            '`examination_name`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`examination_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->examination_name->InputTextType = "text";
        $this->examination_name->Nullable = false; // NOT NULL field
        $this->examination_name->Required = true; // Required field
        $this->examination_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['examination_name'] = &$this->examination_name;

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Raw = true;
        $this->uid->IsPrimaryKey = true; // Primary key field
        $this->uid->Nullable = false; // NOT NULL field
        $this->uid->Required = true; // Required field
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['uid'] = &$this->uid;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // user
        $this->user = new DbField(
            $this, // Table
            'x_user', // Variable name
            'user', // Name
            '`user`', // Expression
            '`user`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->user->InputTextType = "text";
        $this->user->Raw = true;
        $this->user->Nullable = false; // NOT NULL field
        $this->user->Required = true; // Required field
        $this->user->Lookup = new Lookup($this->user, 'user', true, 'id', ["mobile","id","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`mobile`, ''),'" . ValueSeparator(1, $this->user) . "',COALESCE(`id`,''))");
        $this->user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->user->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['user'] = &$this->user;

        // report_grp
        $this->report_grp = new DbField(
            $this, // Table
            'x_report_grp', // Variable name
            'report_grp', // Name
            '`report_grp`', // Expression
            '`report_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`report_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->report_grp->addMethod("getDefault", fn() => 0);
        $this->report_grp->InputTextType = "text";
        $this->report_grp->Raw = true;
        $this->report_grp->Sortable = false; // Allow sort
        $this->report_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->report_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['report_grp'] = &$this->report_grp;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "l_examination_report";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('uid', $rs)) {
                AddFilter($where, QuotedName('uid', $this->Dbid) . '=' . QuotedValue($rs['uid'], $this->uid->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->d_id->DbValue = $row['d_id'];
        $this->mobile->DbValue = $row['mobile'];
        $this->name->DbValue = $row['name'];
        $this->examination_code->DbValue = $row['examination_code'];
        $this->diagnosis_value->DbValue = $row['diagnosis_value'];
        $this->diagnosis_st_min->DbValue = $row['diagnosis_st_min'];
        $this->diagnosis_st_max->DbValue = $row['diagnosis_st_max'];
        $this->diagnosis_unit->DbValue = $row['diagnosis_unit'];
        $this->balance_amount->DbValue = $row['balance_amount'];
        $this->age->DbValue = $row['age'];
        $this->sex->DbValue = $row['sex'];
        $this->referral->DbValue = $row['referral'];
        $this->remarks->DbValue = $row['remarks'];
        $this->examination_grp->DbValue = $row['examination_grp'];
        $this->diagnosis_datetime->DbValue = $row['diagnosis_datetime'];
        $this->import_value->DbValue = $row['import_value'];
        $this->total_amount->DbValue = $row['total_amount'];
        $this->discount_amount->DbValue = $row['discount_amount'];
        $this->received_amount->DbValue = $row['received_amount'];
        $this->examination_id->DbValue = $row['examination_id'];
        $this->examination_name->DbValue = $row['examination_name'];
        $this->uid->DbValue = $row['uid'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->user->DbValue = $row['user'];
        $this->report_grp->DbValue = $row['report_grp'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`uid` = '@uid@'";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->uid->CurrentValue : $this->uid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->uid->CurrentValue = $keys[0];
            } else {
                $this->uid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('uid', $row) ? $row['uid'] : null;
        } else {
            $val = !EmptyValue($this->uid->OldValue) && !$current ? $this->uid->OldValue : $this->uid->CurrentValue;
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@uid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("lexaminationreportlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "lexaminationreportview" => $Language->phrase("View"),
            "lexaminationreportedit" => $Language->phrase("Edit"),
            "lexaminationreportadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "lexaminationreportlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "LExaminationReportView",
            Config("API_ADD_ACTION") => "LExaminationReportAdd",
            Config("API_EDIT_ACTION") => "LExaminationReportEdit",
            Config("API_DELETE_ACTION") => "LExaminationReportDelete",
            Config("API_LIST_ACTION") => "LExaminationReportList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "lexaminationreportlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("lexaminationreportview", $parm);
        } else {
            $url = $this->keyUrl("lexaminationreportview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "lexaminationreportadd?" . $parm;
        } else {
            $url = "lexaminationreportadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("lexaminationreportedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("lexaminationreportlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("lexaminationreportadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("lexaminationreportlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("lexaminationreportdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"uid\":" . VarToJson($this->uid->CurrentValue, "string");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->uid->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->uid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("uid") ?? Route("uid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->uid->CurrentValue = $key;
            } else {
                $this->uid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->d_id->setDbValue($row['d_id']);
        $this->mobile->setDbValue($row['mobile']);
        $this->name->setDbValue($row['name']);
        $this->examination_code->setDbValue($row['examination_code']);
        $this->diagnosis_value->setDbValue($row['diagnosis_value']);
        $this->diagnosis_st_min->setDbValue($row['diagnosis_st_min']);
        $this->diagnosis_st_max->setDbValue($row['diagnosis_st_max']);
        $this->diagnosis_unit->setDbValue($row['diagnosis_unit']);
        $this->balance_amount->setDbValue($row['balance_amount']);
        $this->age->setDbValue($row['age']);
        $this->sex->setDbValue($row['sex']);
        $this->referral->setDbValue($row['referral']);
        $this->remarks->setDbValue($row['remarks']);
        $this->examination_grp->setDbValue($row['examination_grp']);
        $this->diagnosis_datetime->setDbValue($row['diagnosis_datetime']);
        $this->import_value->setDbValue($row['import_value']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->discount_amount->setDbValue($row['discount_amount']);
        $this->received_amount->setDbValue($row['received_amount']);
        $this->examination_id->setDbValue($row['examination_id']);
        $this->examination_name->setDbValue($row['examination_name']);
        $this->uid->setDbValue($row['uid']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->user->setDbValue($row['user']);
        $this->report_grp->setDbValue($row['report_grp']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "LExaminationReportList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // d_id

        // mobile

        // name

        // examination_code

        // diagnosis_value

        // diagnosis_st_min

        // diagnosis_st_max

        // diagnosis_unit

        // balance_amount

        // age

        // sex

        // referral

        // remarks

        // examination_grp

        // diagnosis_datetime

        // import_value

        // total_amount

        // discount_amount

        // received_amount

        // examination_id

        // examination_name

        // uid

        // operator

        // datetime

        // user

        // report_grp
        $this->report_grp->CellCssStyle = "white-space: nowrap;";

        // d_id
        $this->d_id->ViewValue = $this->d_id->CurrentValue;
        $this->d_id->ViewValue = FormatNumber($this->d_id->ViewValue, $this->d_id->formatPattern());

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;
        $curVal = strval($this->mobile->CurrentValue);
        if ($curVal != "") {
            $this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
            if ($this->mobile->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                    $this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
                } else {
                    $this->mobile->ViewValue = $this->mobile->CurrentValue;
                }
            }
        } else {
            $this->mobile->ViewValue = null;
        }

        // name
        $this->name->ViewValue = $this->name->CurrentValue;
        $curVal = strval($this->name->CurrentValue);
        if ($curVal != "") {
            $this->name->ViewValue = $this->name->lookupCacheOption($curVal);
            if ($this->name->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->name->Lookup->getTable()->Fields["name"]->searchExpression(), "=", $curVal, $this->name->Lookup->getTable()->Fields["name"]->searchDataType(), "");
                $sqlWrk = $this->name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->name->Lookup->renderViewRow($rswrk[0]);
                    $this->name->ViewValue = $this->name->displayValue($arwrk);
                } else {
                    $this->name->ViewValue = $this->name->CurrentValue;
                }
            }
        } else {
            $this->name->ViewValue = null;
        }

        // examination_code
        $this->examination_code->ViewValue = $this->examination_code->CurrentValue;

        // diagnosis_value
        $this->diagnosis_value->ViewValue = $this->diagnosis_value->CurrentValue;

        // diagnosis_st_min
        $this->diagnosis_st_min->ViewValue = $this->diagnosis_st_min->CurrentValue;
        $this->diagnosis_st_min->ViewValue = FormatNumber($this->diagnosis_st_min->ViewValue, $this->diagnosis_st_min->formatPattern());

        // diagnosis_st_max
        $this->diagnosis_st_max->ViewValue = $this->diagnosis_st_max->CurrentValue;
        $this->diagnosis_st_max->ViewValue = FormatNumber($this->diagnosis_st_max->ViewValue, $this->diagnosis_st_max->formatPattern());

        // diagnosis_unit
        $this->diagnosis_unit->ViewValue = $this->diagnosis_unit->CurrentValue;

        // balance_amount
        $this->balance_amount->ViewValue = $this->balance_amount->CurrentValue;
        $this->balance_amount->ViewValue = FormatNumber($this->balance_amount->ViewValue, $this->balance_amount->formatPattern());

        // age
        $this->age->ViewValue = $this->age->CurrentValue;
        $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

        // sex
        if (strval($this->sex->CurrentValue) != "") {
            $this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
        } else {
            $this->sex->ViewValue = null;
        }

        // referral
        $this->referral->ViewValue = $this->referral->CurrentValue;
        $curVal = strval($this->referral->CurrentValue);
        if ($curVal != "") {
            $this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
            if ($this->referral->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                    $this->referral->ViewValue = $this->referral->displayValue($arwrk);
                } else {
                    $this->referral->ViewValue = FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern());
                }
            }
        } else {
            $this->referral->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // examination_grp
        $curVal = strval($this->examination_grp->CurrentValue);
        if ($curVal != "") {
            $this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
            if ($this->examination_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->examination_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->examination_grp->ViewValue = $this->examination_grp->displayValue($arwrk);
                } else {
                    $this->examination_grp->ViewValue = FormatNumber($this->examination_grp->CurrentValue, $this->examination_grp->formatPattern());
                }
            }
        } else {
            $this->examination_grp->ViewValue = null;
        }

        // diagnosis_datetime
        $this->diagnosis_datetime->ViewValue = $this->diagnosis_datetime->CurrentValue;
        $this->diagnosis_datetime->ViewValue = FormatDateTime($this->diagnosis_datetime->ViewValue, $this->diagnosis_datetime->formatPattern());

        // import_value
        $this->import_value->ViewValue = $this->import_value->CurrentValue;

        // total_amount
        $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
        $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

        // discount_amount
        $this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
        $this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, $this->discount_amount->formatPattern());

        // received_amount
        $this->received_amount->ViewValue = $this->received_amount->CurrentValue;
        $this->received_amount->ViewValue = FormatNumber($this->received_amount->ViewValue, $this->received_amount->formatPattern());

        // examination_id
        $this->examination_id->ViewValue = $this->examination_id->CurrentValue;
        $this->examination_id->ViewValue = FormatNumber($this->examination_id->ViewValue, $this->examination_id->formatPattern());

        // examination_name
        $this->examination_name->ViewValue = $this->examination_name->CurrentValue;

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // user
        $this->user->ViewValue = $this->user->CurrentValue;
        $curVal = strval($this->user->CurrentValue);
        if ($curVal != "") {
            $this->user->ViewValue = $this->user->lookupCacheOption($curVal);
            if ($this->user->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                    $this->user->ViewValue = $this->user->displayValue($arwrk);
                } else {
                    $this->user->ViewValue = FormatNumber($this->user->CurrentValue, $this->user->formatPattern());
                }
            }
        } else {
            $this->user->ViewValue = null;
        }

        // report_grp
        $this->report_grp->ViewValue = $this->report_grp->CurrentValue;
        $this->report_grp->ViewValue = FormatNumber($this->report_grp->ViewValue, $this->report_grp->formatPattern());

        // d_id
        $this->d_id->HrefValue = "";
        $this->d_id->TooltipValue = "";

        // mobile
        $this->mobile->HrefValue = "";
        $this->mobile->TooltipValue = "";

        // name
        $this->name->HrefValue = "";
        $this->name->TooltipValue = "";

        // examination_code
        $this->examination_code->HrefValue = "";
        $this->examination_code->TooltipValue = "";

        // diagnosis_value
        $this->diagnosis_value->HrefValue = "";
        $this->diagnosis_value->TooltipValue = "";

        // diagnosis_st_min
        $this->diagnosis_st_min->HrefValue = "";
        $this->diagnosis_st_min->TooltipValue = "";

        // diagnosis_st_max
        $this->diagnosis_st_max->HrefValue = "";
        $this->diagnosis_st_max->TooltipValue = "";

        // diagnosis_unit
        $this->diagnosis_unit->HrefValue = "";
        $this->diagnosis_unit->TooltipValue = "";

        // balance_amount
        $this->balance_amount->HrefValue = "";
        $this->balance_amount->TooltipValue = "";

        // age
        $this->age->HrefValue = "";
        $this->age->TooltipValue = "";

        // sex
        $this->sex->HrefValue = "";
        $this->sex->TooltipValue = "";

        // referral
        $this->referral->HrefValue = "";
        $this->referral->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // examination_grp
        $this->examination_grp->HrefValue = "";
        $this->examination_grp->TooltipValue = "";

        // diagnosis_datetime
        $this->diagnosis_datetime->HrefValue = "";
        $this->diagnosis_datetime->TooltipValue = "";

        // import_value
        $this->import_value->HrefValue = "";
        $this->import_value->TooltipValue = "";

        // total_amount
        $this->total_amount->HrefValue = "";
        $this->total_amount->TooltipValue = "";

        // discount_amount
        $this->discount_amount->HrefValue = "";
        $this->discount_amount->TooltipValue = "";

        // received_amount
        $this->received_amount->HrefValue = "";
        $this->received_amount->TooltipValue = "";

        // examination_id
        $this->examination_id->HrefValue = "";
        $this->examination_id->TooltipValue = "";

        // examination_name
        $this->examination_name->HrefValue = "";
        $this->examination_name->TooltipValue = "";

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // user
        $this->user->HrefValue = "";
        $this->user->TooltipValue = "";

        // report_grp
        $this->report_grp->HrefValue = "";
        $this->report_grp->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // d_id
        $this->d_id->setupEditAttributes();
        $this->d_id->EditValue = $this->d_id->CurrentValue;
        $this->d_id->EditValue = FormatNumber($this->d_id->EditValue, $this->d_id->formatPattern());

        // mobile
        $this->mobile->setupEditAttributes();
        $this->mobile->EditValue = $this->mobile->CurrentValue;
        $curVal = strval($this->mobile->CurrentValue);
        if ($curVal != "") {
            $this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
            if ($this->mobile->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                    $this->mobile->EditValue = $this->mobile->displayValue($arwrk);
                } else {
                    $this->mobile->EditValue = $this->mobile->CurrentValue;
                }
            }
        } else {
            $this->mobile->EditValue = null;
        }

        // name
        $this->name->setupEditAttributes();
        if (!$this->name->Raw) {
            $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
        }
        $this->name->EditValue = $this->name->CurrentValue;
        $this->name->PlaceHolder = RemoveHtml($this->name->caption());

        // examination_code
        $this->examination_code->setupEditAttributes();
        $this->examination_code->EditValue = $this->examination_code->CurrentValue;

        // diagnosis_value
        $this->diagnosis_value->setupEditAttributes();
        if (!$this->diagnosis_value->Raw) {
            $this->diagnosis_value->CurrentValue = HtmlDecode($this->diagnosis_value->CurrentValue);
        }
        $this->diagnosis_value->EditValue = $this->diagnosis_value->CurrentValue;
        $this->diagnosis_value->PlaceHolder = RemoveHtml($this->diagnosis_value->caption());

        // diagnosis_st_min
        $this->diagnosis_st_min->setupEditAttributes();
        $this->diagnosis_st_min->EditValue = $this->diagnosis_st_min->CurrentValue;
        $this->diagnosis_st_min->PlaceHolder = RemoveHtml($this->diagnosis_st_min->caption());
        if (strval($this->diagnosis_st_min->EditValue) != "" && is_numeric($this->diagnosis_st_min->EditValue)) {
            $this->diagnosis_st_min->EditValue = FormatNumber($this->diagnosis_st_min->EditValue, null);
        }

        // diagnosis_st_max
        $this->diagnosis_st_max->setupEditAttributes();
        $this->diagnosis_st_max->EditValue = $this->diagnosis_st_max->CurrentValue;
        $this->diagnosis_st_max->PlaceHolder = RemoveHtml($this->diagnosis_st_max->caption());
        if (strval($this->diagnosis_st_max->EditValue) != "" && is_numeric($this->diagnosis_st_max->EditValue)) {
            $this->diagnosis_st_max->EditValue = FormatNumber($this->diagnosis_st_max->EditValue, null);
        }

        // diagnosis_unit
        $this->diagnosis_unit->setupEditAttributes();
        if (!$this->diagnosis_unit->Raw) {
            $this->diagnosis_unit->CurrentValue = HtmlDecode($this->diagnosis_unit->CurrentValue);
        }
        $this->diagnosis_unit->EditValue = $this->diagnosis_unit->CurrentValue;
        $this->diagnosis_unit->PlaceHolder = RemoveHtml($this->diagnosis_unit->caption());

        // balance_amount
        $this->balance_amount->setupEditAttributes();
        $this->balance_amount->EditValue = $this->balance_amount->CurrentValue;
        $this->balance_amount->EditValue = FormatNumber($this->balance_amount->EditValue, $this->balance_amount->formatPattern());

        // age
        $this->age->setupEditAttributes();
        $this->age->EditValue = $this->age->CurrentValue;
        $this->age->PlaceHolder = RemoveHtml($this->age->caption());
        if (strval($this->age->EditValue) != "" && is_numeric($this->age->EditValue)) {
            $this->age->EditValue = FormatNumber($this->age->EditValue, null);
        }

        // sex
        $this->sex->EditValue = $this->sex->options(false);
        $this->sex->PlaceHolder = RemoveHtml($this->sex->caption());

        // referral
        $this->referral->setupEditAttributes();
        $this->referral->EditValue = $this->referral->CurrentValue;
        $this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;

        // examination_grp
        $this->examination_grp->setupEditAttributes();
        $curVal = strval($this->examination_grp->CurrentValue);
        if ($curVal != "") {
            $this->examination_grp->EditValue = $this->examination_grp->lookupCacheOption($curVal);
            if ($this->examination_grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->examination_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->examination_grp->EditValue = $this->examination_grp->displayValue($arwrk);
                } else {
                    $this->examination_grp->EditValue = FormatNumber($this->examination_grp->CurrentValue, $this->examination_grp->formatPattern());
                }
            }
        } else {
            $this->examination_grp->EditValue = null;
        }

        // diagnosis_datetime
        $this->diagnosis_datetime->setupEditAttributes();
        $this->diagnosis_datetime->EditValue = $this->diagnosis_datetime->CurrentValue;
        $this->diagnosis_datetime->EditValue = FormatDateTime($this->diagnosis_datetime->EditValue, $this->diagnosis_datetime->formatPattern());

        // import_value
        $this->import_value->setupEditAttributes();
        $this->import_value->EditValue = $this->import_value->CurrentValue;

        // total_amount
        $this->total_amount->setupEditAttributes();
        $this->total_amount->EditValue = $this->total_amount->CurrentValue;
        $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, $this->total_amount->formatPattern());

        // discount_amount
        $this->discount_amount->setupEditAttributes();
        $this->discount_amount->EditValue = $this->discount_amount->CurrentValue;
        $this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());
        if (strval($this->discount_amount->EditValue) != "" && is_numeric($this->discount_amount->EditValue)) {
            $this->discount_amount->EditValue = FormatNumber($this->discount_amount->EditValue, null);
        }

        // received_amount
        $this->received_amount->setupEditAttributes();
        $this->received_amount->EditValue = $this->received_amount->CurrentValue;
        $this->received_amount->EditValue = FormatNumber($this->received_amount->EditValue, $this->received_amount->formatPattern());

        // examination_id
        $this->examination_id->setupEditAttributes();
        $this->examination_id->EditValue = $this->examination_id->CurrentValue;
        $this->examination_id->EditValue = FormatNumber($this->examination_id->EditValue, $this->examination_id->formatPattern());

        // examination_name
        $this->examination_name->setupEditAttributes();
        $this->examination_name->EditValue = $this->examination_name->CurrentValue;

        // uid
        $this->uid->setupEditAttributes();
        if (!$this->uid->Raw) {
            $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
        }
        $this->uid->EditValue = $this->uid->CurrentValue;
        $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

        // operator

        // datetime

        // user
        $this->user->setupEditAttributes();
        $this->user->EditValue = $this->user->CurrentValue;
        $curVal = strval($this->user->CurrentValue);
        if ($curVal != "") {
            $this->user->EditValue = $this->user->lookupCacheOption($curVal);
            if ($this->user->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                    $this->user->EditValue = $this->user->displayValue($arwrk);
                } else {
                    $this->user->EditValue = FormatNumber($this->user->CurrentValue, $this->user->formatPattern());
                }
            }
        } else {
            $this->user->EditValue = null;
        }

        // report_grp
        $this->report_grp->setupEditAttributes();
        $this->report_grp->EditValue = $this->report_grp->CurrentValue;
        $this->report_grp->PlaceHolder = RemoveHtml($this->report_grp->caption());
        if (strval($this->report_grp->EditValue) != "" && is_numeric($this->report_grp->EditValue)) {
            $this->report_grp->EditValue = FormatNumber($this->report_grp->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->d_id);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->name);
                    $doc->exportCaption($this->examination_code);
                    $doc->exportCaption($this->diagnosis_value);
                    $doc->exportCaption($this->diagnosis_st_min);
                    $doc->exportCaption($this->diagnosis_st_max);
                    $doc->exportCaption($this->diagnosis_unit);
                    $doc->exportCaption($this->balance_amount);
                    $doc->exportCaption($this->age);
                    $doc->exportCaption($this->sex);
                    $doc->exportCaption($this->referral);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->examination_grp);
                    $doc->exportCaption($this->diagnosis_datetime);
                    $doc->exportCaption($this->import_value);
                    $doc->exportCaption($this->total_amount);
                    $doc->exportCaption($this->discount_amount);
                    $doc->exportCaption($this->received_amount);
                    $doc->exportCaption($this->examination_id);
                    $doc->exportCaption($this->examination_name);
                    $doc->exportCaption($this->uid);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->user);
                } else {
                    $doc->exportCaption($this->d_id);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->name);
                    $doc->exportCaption($this->examination_code);
                    $doc->exportCaption($this->diagnosis_value);
                    $doc->exportCaption($this->diagnosis_st_min);
                    $doc->exportCaption($this->diagnosis_st_max);
                    $doc->exportCaption($this->diagnosis_unit);
                    $doc->exportCaption($this->balance_amount);
                    $doc->exportCaption($this->age);
                    $doc->exportCaption($this->sex);
                    $doc->exportCaption($this->referral);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->examination_grp);
                    $doc->exportCaption($this->diagnosis_datetime);
                    $doc->exportCaption($this->total_amount);
                    $doc->exportCaption($this->discount_amount);
                    $doc->exportCaption($this->received_amount);
                    $doc->exportCaption($this->examination_id);
                    $doc->exportCaption($this->examination_name);
                    $doc->exportCaption($this->uid);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->user);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->d_id);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->name);
                        $doc->exportField($this->examination_code);
                        $doc->exportField($this->diagnosis_value);
                        $doc->exportField($this->diagnosis_st_min);
                        $doc->exportField($this->diagnosis_st_max);
                        $doc->exportField($this->diagnosis_unit);
                        $doc->exportField($this->balance_amount);
                        $doc->exportField($this->age);
                        $doc->exportField($this->sex);
                        $doc->exportField($this->referral);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->examination_grp);
                        $doc->exportField($this->diagnosis_datetime);
                        $doc->exportField($this->import_value);
                        $doc->exportField($this->total_amount);
                        $doc->exportField($this->discount_amount);
                        $doc->exportField($this->received_amount);
                        $doc->exportField($this->examination_id);
                        $doc->exportField($this->examination_name);
                        $doc->exportField($this->uid);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->user);
                    } else {
                        $doc->exportField($this->d_id);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->name);
                        $doc->exportField($this->examination_code);
                        $doc->exportField($this->diagnosis_value);
                        $doc->exportField($this->diagnosis_st_min);
                        $doc->exportField($this->diagnosis_st_max);
                        $doc->exportField($this->diagnosis_unit);
                        $doc->exportField($this->balance_amount);
                        $doc->exportField($this->age);
                        $doc->exportField($this->sex);
                        $doc->exportField($this->referral);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->examination_grp);
                        $doc->exportField($this->diagnosis_datetime);
                        $doc->exportField($this->total_amount);
                        $doc->exportField($this->discount_amount);
                        $doc->exportField($this->received_amount);
                        $doc->exportField($this->examination_id);
                        $doc->exportField($this->examination_name);
                        $doc->exportField($this->uid);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->user);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
