<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class LExaminationEdit extends LExamination
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "LExaminationEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "lexaminationedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->mobile->setVisibility();
        $this->user->Visible = false;
        $this->category->setVisibility();
        $this->name->setVisibility();
        $this->age->setVisibility();
        $this->sex->setVisibility();
        $this->referral->setVisibility();
        $this->examination_grp->setVisibility();
        $this->examination_type->setVisibility();
        $this->total_amount->setVisibility();
        $this->discount_percent->setVisibility();
        $this->discount_amount->setVisibility();
        $this->final_amount->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->receipt->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'l_examination';
        $this->TableName = 'l_examination';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (l_examination)
        if (!isset($GLOBALS["l_examination"]) || $GLOBALS["l_examination"]::class == PROJECT_NAMESPACE . "l_examination") {
            $GLOBALS["l_examination"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "lexaminationview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->mobile);
        $this->setupLookupOptions($this->user);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->sex);
        $this->setupLookupOptions($this->referral);
        $this->setupLookupOptions($this->examination_grp);
        $this->setupLookupOptions($this->examination_type);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("lexaminationlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "lexaminationlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "lexaminationlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "lexaminationlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'age' first before field var 'x_age'
        $val = $CurrentForm->hasValue("age") ? $CurrentForm->getValue("age") : $CurrentForm->getValue("x_age");
        if (!$this->age->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->age->Visible = false; // Disable update for API request
            } else {
                $this->age->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sex' first before field var 'x_sex'
        $val = $CurrentForm->hasValue("sex") ? $CurrentForm->getValue("sex") : $CurrentForm->getValue("x_sex");
        if (!$this->sex->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sex->Visible = false; // Disable update for API request
            } else {
                $this->sex->setFormValue($val);
            }
        }

        // Check field name 'referral' first before field var 'x_referral'
        $val = $CurrentForm->hasValue("referral") ? $CurrentForm->getValue("referral") : $CurrentForm->getValue("x_referral");
        if (!$this->referral->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->referral->Visible = false; // Disable update for API request
            } else {
                $this->referral->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'examination_grp' first before field var 'x_examination_grp'
        $val = $CurrentForm->hasValue("examination_grp") ? $CurrentForm->getValue("examination_grp") : $CurrentForm->getValue("x_examination_grp");
        if (!$this->examination_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->examination_grp->Visible = false; // Disable update for API request
            } else {
                $this->examination_grp->setFormValue($val);
            }
        }

        // Check field name 'examination_type' first before field var 'x_examination_type'
        $val = $CurrentForm->hasValue("examination_type") ? $CurrentForm->getValue("examination_type") : $CurrentForm->getValue("x_examination_type");
        if (!$this->examination_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->examination_type->Visible = false; // Disable update for API request
            } else {
                $this->examination_type->setFormValue($val);
            }
        }

        // Check field name 'total_amount' first before field var 'x_total_amount'
        $val = $CurrentForm->hasValue("total_amount") ? $CurrentForm->getValue("total_amount") : $CurrentForm->getValue("x_total_amount");
        if (!$this->total_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total_amount->Visible = false; // Disable update for API request
            } else {
                $this->total_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'discount_percent' first before field var 'x_discount_percent'
        $val = $CurrentForm->hasValue("discount_percent") ? $CurrentForm->getValue("discount_percent") : $CurrentForm->getValue("x_discount_percent");
        if (!$this->discount_percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->discount_percent->Visible = false; // Disable update for API request
            } else {
                $this->discount_percent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'discount_amount' first before field var 'x_discount_amount'
        $val = $CurrentForm->hasValue("discount_amount") ? $CurrentForm->getValue("discount_amount") : $CurrentForm->getValue("x_discount_amount");
        if (!$this->discount_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->discount_amount->Visible = false; // Disable update for API request
            } else {
                $this->discount_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'final_amount' first before field var 'x_final_amount'
        $val = $CurrentForm->hasValue("final_amount") ? $CurrentForm->getValue("final_amount") : $CurrentForm->getValue("x_final_amount");
        if (!$this->final_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->final_amount->Visible = false; // Disable update for API request
            } else {
                $this->final_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'receipt' first before field var 'x_receipt'
        $val = $CurrentForm->hasValue("receipt") ? $CurrentForm->getValue("receipt") : $CurrentForm->getValue("x_receipt");
        if (!$this->receipt->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->receipt->Visible = false; // Disable update for API request
            } else {
                $this->receipt->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->age->CurrentValue = $this->age->FormValue;
        $this->sex->CurrentValue = $this->sex->FormValue;
        $this->referral->CurrentValue = $this->referral->FormValue;
        $this->examination_grp->CurrentValue = $this->examination_grp->FormValue;
        $this->examination_type->CurrentValue = $this->examination_type->FormValue;
        $this->total_amount->CurrentValue = $this->total_amount->FormValue;
        $this->discount_percent->CurrentValue = $this->discount_percent->FormValue;
        $this->discount_amount->CurrentValue = $this->discount_amount->FormValue;
        $this->final_amount->CurrentValue = $this->final_amount->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->receipt->CurrentValue = $this->receipt->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->mobile->setDbValue($row['mobile']);
        $this->user->setDbValue($row['user']);
        $this->category->setDbValue($row['category']);
        $this->name->setDbValue($row['name']);
        $this->age->setDbValue($row['age']);
        $this->sex->setDbValue($row['sex']);
        $this->referral->setDbValue($row['referral']);
        $this->examination_grp->setDbValue($row['examination_grp']);
        $this->examination_type->setDbValue($row['examination_type']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->discount_percent->setDbValue($row['discount_percent']);
        $this->discount_amount->setDbValue($row['discount_amount']);
        $this->final_amount->setDbValue($row['final_amount']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->receipt->setDbValue($row['receipt']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['user'] = $this->user->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['age'] = $this->age->DefaultValue;
        $row['sex'] = $this->sex->DefaultValue;
        $row['referral'] = $this->referral->DefaultValue;
        $row['examination_grp'] = $this->examination_grp->DefaultValue;
        $row['examination_type'] = $this->examination_type->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['discount_percent'] = $this->discount_percent->DefaultValue;
        $row['discount_amount'] = $this->discount_amount->DefaultValue;
        $row['final_amount'] = $this->final_amount->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['receipt'] = $this->receipt->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // user
        $this->user->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // sex
        $this->sex->RowCssClass = "row";

        // referral
        $this->referral->RowCssClass = "row";

        // examination_grp
        $this->examination_grp->RowCssClass = "row";

        // examination_type
        $this->examination_type->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // discount_percent
        $this->discount_percent->RowCssClass = "row";

        // discount_amount
        $this->discount_amount->RowCssClass = "row";

        // final_amount
        $this->final_amount->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // receipt
        $this->receipt->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $curVal = strval($this->mobile->CurrentValue);
            if ($curVal != "") {
                $this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->ViewValue = $this->mobile->CurrentValue;
                    }
                }
            } else {
                $this->mobile->ViewValue = null;
            }

            // user
            $this->user->ViewValue = $this->user->CurrentValue;
            $curVal = strval($this->user->CurrentValue);
            if ($curVal != "") {
                $this->user->ViewValue = $this->user->lookupCacheOption($curVal);
                if ($this->user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->user->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user->Lookup->renderViewRow($rswrk[0]);
                        $this->user->ViewValue = $this->user->displayValue($arwrk);
                    } else {
                        $this->user->ViewValue = FormatNumber($this->user->CurrentValue, $this->user->formatPattern());
                    }
                }
            } else {
                $this->user->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // age
            $this->age->ViewValue = $this->age->CurrentValue;
            $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

            // sex
            if (strval($this->sex->CurrentValue) != "") {
                $this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
            } else {
                $this->sex->ViewValue = null;
            }

            // referral
            $this->referral->ViewValue = $this->referral->CurrentValue;
            $curVal = strval($this->referral->CurrentValue);
            if ($curVal != "") {
                $this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->ViewValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->ViewValue = FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern());
                    }
                }
            } else {
                $this->referral->ViewValue = null;
            }

            // examination_grp
            $curVal = strval($this->examination_grp->CurrentValue);
            if ($curVal != "") {
                $this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
                if ($this->examination_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->examination_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->examination_grp->Lookup->renderViewRow($row);
                            $this->examination_grp->ViewValue->add($this->examination_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->examination_grp->ViewValue = $this->examination_grp->CurrentValue;
                    }
                }
            } else {
                $this->examination_grp->ViewValue = null;
            }

            // examination_type
            $curVal = strval($this->examination_type->CurrentValue);
            if ($curVal != "") {
                $this->examination_type->ViewValue = $this->examination_type->lookupCacheOption($curVal);
                if ($this->examination_type->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->examination_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->examination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->examination_type->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->examination_type->Lookup->renderViewRow($row);
                            $this->examination_type->ViewValue->add($this->examination_type->displayValue($arwrk));
                        }
                    } else {
                        $this->examination_type->ViewValue = $this->examination_type->CurrentValue;
                    }
                }
            } else {
                $this->examination_type->ViewValue = null;
            }

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // discount_percent
            $this->discount_percent->ViewValue = $this->discount_percent->CurrentValue;
            $this->discount_percent->ViewValue = FormatNumber($this->discount_percent->ViewValue, $this->discount_percent->formatPattern());

            // discount_amount
            $this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
            $this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, $this->discount_amount->formatPattern());

            // final_amount
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // receipt
            $this->receipt->ViewValue = $this->receipt->CurrentValue;
            $this->receipt->ViewValue = FormatNumber($this->receipt->ViewValue, $this->receipt->formatPattern());

            // mobile
            $this->mobile->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // age
            $this->age->HrefValue = "";

            // sex
            $this->sex->HrefValue = "";

            // referral
            $this->referral->HrefValue = "";

            // examination_grp
            $this->examination_grp->HrefValue = "";

            // examination_type
            $this->examination_type->HrefValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";

            // discount_percent
            $this->discount_percent->HrefValue = "";

            // discount_amount
            $this->discount_amount->HrefValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // receipt
            $this->receipt->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $curVal = strval($this->mobile->CurrentValue);
            if ($curVal != "") {
                $this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
                if ($this->mobile->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->mobile->Lookup->getTable()->Fields["mobile"]->searchExpression(), "=", $curVal, $this->mobile->Lookup->getTable()->Fields["mobile"]->searchDataType(), "");
                    $sqlWrk = $this->mobile->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->mobile->Lookup->renderViewRow($rswrk[0]);
                        $this->mobile->EditValue = $this->mobile->displayValue($arwrk);
                    } else {
                        $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
                    }
                }
            } else {
                $this->mobile->EditValue = null;
            }
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $arwrk = [];
            $arwrk["lf"] = $this->name->CurrentValue;
            $arwrk["df"] = $this->name->CurrentValue;
            $arwrk = $this->name->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->name->displayValue($arwrk);
            if ($dispVal != "") {
                $this->name->EditValue = $dispVal;
            }
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // age
            $this->age->setupEditAttributes();
            $this->age->EditValue = $this->age->CurrentValue;
            $this->age->PlaceHolder = RemoveHtml($this->age->caption());
            if (strval($this->age->EditValue) != "" && is_numeric($this->age->EditValue)) {
                $this->age->EditValue = FormatNumber($this->age->EditValue, null);
            }

            // sex
            $this->sex->EditValue = $this->sex->options(false);
            $this->sex->PlaceHolder = RemoveHtml($this->sex->caption());

            // referral
            $this->referral->setupEditAttributes();
            $this->referral->EditValue = $this->referral->CurrentValue;
            $curVal = strval($this->referral->CurrentValue);
            if ($curVal != "") {
                $this->referral->EditValue = $this->referral->lookupCacheOption($curVal);
                if ($this->referral->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->referral->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->referral->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->referral->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->referral->Lookup->renderViewRow($rswrk[0]);
                        $this->referral->EditValue = $this->referral->displayValue($arwrk);
                    } else {
                        $this->referral->EditValue = HtmlEncode(FormatNumber($this->referral->CurrentValue, $this->referral->formatPattern()));
                    }
                }
            } else {
                $this->referral->EditValue = null;
            }
            $this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

            // examination_grp
            $curVal = trim(strval($this->examination_grp->CurrentValue));
            if ($curVal != "") {
                $this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
            } else {
                $this->examination_grp->ViewValue = $this->examination_grp->Lookup !== null && is_array($this->examination_grp->lookupOptions()) && count($this->examination_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->examination_grp->ViewValue !== null) { // Load from cache
                $this->examination_grp->EditValue = array_values($this->examination_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->examination_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->examination_grp->EditValue = $arwrk;
            }
            $this->examination_grp->PlaceHolder = RemoveHtml($this->examination_grp->caption());

            // examination_type
            $curVal = trim(strval($this->examination_type->CurrentValue));
            if ($curVal != "") {
                $this->examination_type->ViewValue = $this->examination_type->lookupCacheOption($curVal);
            } else {
                $this->examination_type->ViewValue = $this->examination_type->Lookup !== null && is_array($this->examination_type->lookupOptions()) && count($this->examination_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->examination_type->ViewValue !== null) { // Load from cache
                $this->examination_type->EditValue = array_values($this->examination_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->examination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->examination_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->examination_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->examination_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->examination_type->Lookup->renderViewRow($row);
                }
                $this->examination_type->EditValue = $arwrk;
            }
            $this->examination_type->PlaceHolder = RemoveHtml($this->examination_type->caption());

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->CurrentValue;
            $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
            if (strval($this->total_amount->EditValue) != "" && is_numeric($this->total_amount->EditValue)) {
                $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, null);
            }

            // discount_percent
            $this->discount_percent->setupEditAttributes();
            $this->discount_percent->EditValue = $this->discount_percent->CurrentValue;
            $this->discount_percent->PlaceHolder = RemoveHtml($this->discount_percent->caption());
            if (strval($this->discount_percent->EditValue) != "" && is_numeric($this->discount_percent->EditValue)) {
                $this->discount_percent->EditValue = FormatNumber($this->discount_percent->EditValue, null);
            }

            // discount_amount
            $this->discount_amount->setupEditAttributes();
            $this->discount_amount->EditValue = $this->discount_amount->CurrentValue;
            $this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());
            if (strval($this->discount_amount->EditValue) != "" && is_numeric($this->discount_amount->EditValue)) {
                $this->discount_amount->EditValue = FormatNumber($this->discount_amount->EditValue, null);
            }

            // final_amount
            $this->final_amount->setupEditAttributes();
            $this->final_amount->EditCustomAttributes = $this->final_amount->getEditCustomAttributes(); // PHP
            $this->final_amount->EditValue = $this->final_amount->CurrentValue;
            $this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());
            if (strval($this->final_amount->EditValue) != "" && is_numeric($this->final_amount->EditValue)) {
                $this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // receipt
            $this->receipt->setupEditAttributes();
            $this->receipt->EditValue = $this->receipt->CurrentValue;
            $this->receipt->PlaceHolder = RemoveHtml($this->receipt->caption());
            if (strval($this->receipt->EditValue) != "" && is_numeric($this->receipt->EditValue)) {
                $this->receipt->EditValue = FormatNumber($this->receipt->EditValue, null);
            }

            // Edit refer script

            // mobile
            $this->mobile->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // age
            $this->age->HrefValue = "";

            // sex
            $this->sex->HrefValue = "";

            // referral
            $this->referral->HrefValue = "";

            // examination_grp
            $this->examination_grp->HrefValue = "";

            // examination_type
            $this->examination_type->HrefValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";

            // discount_percent
            $this->discount_percent->HrefValue = "";

            // discount_amount
            $this->discount_amount->HrefValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // receipt
            $this->receipt->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->age->Visible && $this->age->Required) {
                if (!$this->age->IsDetailKey && EmptyValue($this->age->FormValue)) {
                    $this->age->addErrorMessage(str_replace("%s", $this->age->caption(), $this->age->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->age->FormValue)) {
                $this->age->addErrorMessage($this->age->getErrorMessage(false));
            }
            if ($this->sex->Visible && $this->sex->Required) {
                if ($this->sex->FormValue == "") {
                    $this->sex->addErrorMessage(str_replace("%s", $this->sex->caption(), $this->sex->RequiredErrorMessage));
                }
            }
            if ($this->referral->Visible && $this->referral->Required) {
                if (!$this->referral->IsDetailKey && EmptyValue($this->referral->FormValue)) {
                    $this->referral->addErrorMessage(str_replace("%s", $this->referral->caption(), $this->referral->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->referral->FormValue)) {
                $this->referral->addErrorMessage($this->referral->getErrorMessage(false));
            }
            if ($this->examination_grp->Visible && $this->examination_grp->Required) {
                if ($this->examination_grp->FormValue == "") {
                    $this->examination_grp->addErrorMessage(str_replace("%s", $this->examination_grp->caption(), $this->examination_grp->RequiredErrorMessage));
                }
            }
            if ($this->examination_type->Visible && $this->examination_type->Required) {
                if ($this->examination_type->FormValue == "") {
                    $this->examination_type->addErrorMessage(str_replace("%s", $this->examination_type->caption(), $this->examination_type->RequiredErrorMessage));
                }
            }
            if ($this->total_amount->Visible && $this->total_amount->Required) {
                if (!$this->total_amount->IsDetailKey && EmptyValue($this->total_amount->FormValue)) {
                    $this->total_amount->addErrorMessage(str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->total_amount->FormValue)) {
                $this->total_amount->addErrorMessage($this->total_amount->getErrorMessage(false));
            }
            if ($this->discount_percent->Visible && $this->discount_percent->Required) {
                if (!$this->discount_percent->IsDetailKey && EmptyValue($this->discount_percent->FormValue)) {
                    $this->discount_percent->addErrorMessage(str_replace("%s", $this->discount_percent->caption(), $this->discount_percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->discount_percent->FormValue)) {
                $this->discount_percent->addErrorMessage($this->discount_percent->getErrorMessage(false));
            }
            if ($this->discount_amount->Visible && $this->discount_amount->Required) {
                if (!$this->discount_amount->IsDetailKey && EmptyValue($this->discount_amount->FormValue)) {
                    $this->discount_amount->addErrorMessage(str_replace("%s", $this->discount_amount->caption(), $this->discount_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->discount_amount->FormValue)) {
                $this->discount_amount->addErrorMessage($this->discount_amount->getErrorMessage(false));
            }
            if ($this->final_amount->Visible && $this->final_amount->Required) {
                if (!$this->final_amount->IsDetailKey && EmptyValue($this->final_amount->FormValue)) {
                    $this->final_amount->addErrorMessage(str_replace("%s", $this->final_amount->caption(), $this->final_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->final_amount->FormValue)) {
                $this->final_amount->addErrorMessage($this->final_amount->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->receipt->Visible && $this->receipt->Required) {
                if (!$this->receipt->IsDetailKey && EmptyValue($this->receipt->FormValue)) {
                    $this->receipt->addErrorMessage(str_replace("%s", $this->receipt->caption(), $this->receipt->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->receipt->FormValue)) {
                $this->receipt->addErrorMessage($this->receipt->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, $this->mobile->ReadOnly);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, $this->category->ReadOnly);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // age
        $this->age->setDbValueDef($rsnew, $this->age->CurrentValue, $this->age->ReadOnly);

        // sex
        $this->sex->setDbValueDef($rsnew, $this->sex->CurrentValue, $this->sex->ReadOnly);

        // referral
        $this->referral->setDbValueDef($rsnew, $this->referral->CurrentValue, $this->referral->ReadOnly);

        // examination_grp
        $this->examination_grp->setDbValueDef($rsnew, $this->examination_grp->CurrentValue, $this->examination_grp->ReadOnly);

        // examination_type
        $this->examination_type->setDbValueDef($rsnew, $this->examination_type->CurrentValue, $this->examination_type->ReadOnly);

        // total_amount
        $this->total_amount->setDbValueDef($rsnew, $this->total_amount->CurrentValue, $this->total_amount->ReadOnly);

        // discount_percent
        $this->discount_percent->setDbValueDef($rsnew, $this->discount_percent->CurrentValue, $this->discount_percent->ReadOnly);

        // discount_amount
        $this->discount_amount->setDbValueDef($rsnew, $this->discount_amount->CurrentValue, $this->discount_amount->ReadOnly);

        // final_amount
        $this->final_amount->setDbValueDef($rsnew, $this->final_amount->CurrentValue, $this->final_amount->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // receipt
        $this->receipt->setDbValueDef($rsnew, $this->receipt->CurrentValue, $this->receipt->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['mobile'])) { // mobile
            $this->mobile->CurrentValue = $row['mobile'];
        }
        if (isset($row['category'])) { // category
            $this->category->CurrentValue = $row['category'];
        }
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['age'])) { // age
            $this->age->CurrentValue = $row['age'];
        }
        if (isset($row['sex'])) { // sex
            $this->sex->CurrentValue = $row['sex'];
        }
        if (isset($row['referral'])) { // referral
            $this->referral->CurrentValue = $row['referral'];
        }
        if (isset($row['examination_grp'])) { // examination_grp
            $this->examination_grp->CurrentValue = $row['examination_grp'];
        }
        if (isset($row['examination_type'])) { // examination_type
            $this->examination_type->CurrentValue = $row['examination_type'];
        }
        if (isset($row['total_amount'])) { // total_amount
            $this->total_amount->CurrentValue = $row['total_amount'];
        }
        if (isset($row['discount_percent'])) { // discount_percent
            $this->discount_percent->CurrentValue = $row['discount_percent'];
        }
        if (isset($row['discount_amount'])) { // discount_amount
            $this->discount_amount->CurrentValue = $row['discount_amount'];
        }
        if (isset($row['final_amount'])) { // final_amount
            $this->final_amount->CurrentValue = $row['final_amount'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['receipt'])) { // receipt
            $this->receipt->CurrentValue = $row['receipt'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("lexaminationlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_mobile":
                    break;
                case "x_user":
                    break;
                case "x_category":
                    break;
                case "x_name":
                    break;
                case "x_sex":
                    break;
                case "x_referral":
                    break;
                case "x_examination_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_examination_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
