<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class JobCardSearch extends JobCard
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "JobCardSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "jobcardsearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->jc_no->setVisibility();
        $this->company_id->setVisibility();
        $this->buyer_id->setVisibility();
        $this->works->Visible = false;
        $this->issue_to_internal->setVisibility();
        $this->issue_to_external->setVisibility();
        $this->issue_to->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->packing_type->setVisibility();
        $this->product_code->setVisibility();
        $this->item->setVisibility();
        $this->poid->setVisibility();
        $this->po->Visible = false;
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->lot_no->Visible = false;
        $this->pro_unit->setVisibility();
        $this->employee_id->setVisibility();
        $this->_1->setVisibility();
        $this->_2->setVisibility();
        $this->_3->setVisibility();
        $this->_4->setVisibility();
        $this->_5->setVisibility();
        $this->_6->setVisibility();
        $this->_7->setVisibility();
        $this->_8->setVisibility();
        $this->other1->setVisibility();
        $this->other2->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
        $this->in_id->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->product->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'job_card';
        $this->TableName = 'job_card';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (job_card)
        if (!isset($GLOBALS["job_card"]) || $GLOBALS["job_card"]::class == PROJECT_NAMESPACE . "job_card") {
            $GLOBALS["job_card"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "jobcardview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->works);
        $this->setupLookupOptions($this->issue_to_internal);
        $this->setupLookupOptions($this->issue_to_external);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code);
        $this->setupLookupOptions($this->item);
        $this->setupLookupOptions($this->poid);
        $this->setupLookupOptions($this->po);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->pro_unit);
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "jobcardlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
        $this->buildSearchUrl($srchUrl, $this->issue_to_internal); // issue_to_internal
        $this->buildSearchUrl($srchUrl, $this->issue_to_external); // issue_to_external
        $this->buildSearchUrl($srchUrl, $this->issue_to); // issue_to
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->product_code); // product_code
        $this->buildSearchUrl($srchUrl, $this->item); // item
        $this->buildSearchUrl($srchUrl, $this->poid); // poid
        $this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->pro_unit); // pro_unit
        $this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
        $this->buildSearchUrl($srchUrl, $this->_1); // 1
        $this->buildSearchUrl($srchUrl, $this->_2); // 2
        $this->buildSearchUrl($srchUrl, $this->_3); // 3
        $this->buildSearchUrl($srchUrl, $this->_4); // 4
        $this->buildSearchUrl($srchUrl, $this->_5); // 5
        $this->buildSearchUrl($srchUrl, $this->_6); // 6
        $this->buildSearchUrl($srchUrl, $this->_7); // 7
        $this->buildSearchUrl($srchUrl, $this->_8); // 8
        $this->buildSearchUrl($srchUrl, $this->other1); // other1
        $this->buildSearchUrl($srchUrl, $this->other2); // other2
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_id
        if ($this->buyer_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // works
        if ($this->works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // issue_to_internal
        if ($this->issue_to_internal->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // issue_to_external
        if ($this->issue_to_external->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // issue_to
        if ($this->issue_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // item
        if ($this->item->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // poid
        if ($this->poid->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->poid->AdvancedSearch->SearchValue)) {
            $this->poid->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->poid->AdvancedSearch->SearchValue);
        }
        if (is_array($this->poid->AdvancedSearch->SearchValue2)) {
            $this->poid->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->poid->AdvancedSearch->SearchValue2);
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pro_unit
        if ($this->pro_unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_id
        if ($this->employee_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->employee_id->AdvancedSearch->SearchValue)) {
            $this->employee_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->employee_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->employee_id->AdvancedSearch->SearchValue2)) {
            $this->employee_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->employee_id->AdvancedSearch->SearchValue2);
        }

        // 1
        if ($this->_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 2
        if ($this->_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 3
        if ($this->_3->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 4
        if ($this->_4->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 5
        if ($this->_5->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 6
        if ($this->_6->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 7
        if ($this->_7->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 8
        if ($this->_8->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other1
        if ($this->other1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other2
        if ($this->other2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // works
        $this->works->RowCssClass = "row";

        // issue_to_internal
        $this->issue_to_internal->RowCssClass = "row";

        // issue_to_external
        $this->issue_to_external->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // pro_unit
        $this->pro_unit->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // other1
        $this->other1->RowCssClass = "row";

        // other2
        $this->other2->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // in_id
        $this->in_id->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // works
            if (strval($this->works->CurrentValue) != "") {
                $this->works->ViewValue = $this->works->optionCaption($this->works->CurrentValue);
            } else {
                $this->works->ViewValue = null;
            }

            // issue_to_internal
            $curVal = strval($this->issue_to_internal->CurrentValue);
            if ($curVal != "") {
                $this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
                if ($this->issue_to_internal->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to_internal->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to_internal->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to_internal->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to_internal->ViewValue = $this->issue_to_internal->displayValue($arwrk);
                    } else {
                        $this->issue_to_internal->ViewValue = FormatNumber($this->issue_to_internal->CurrentValue, $this->issue_to_internal->formatPattern());
                    }
                }
            } else {
                $this->issue_to_internal->ViewValue = null;
            }

            // issue_to_external
            $curVal = strval($this->issue_to_external->CurrentValue);
            if ($curVal != "") {
                $this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
                if ($this->issue_to_external->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to_external->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_external->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to_external->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to_external->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to_external->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to_external->ViewValue = $this->issue_to_external->displayValue($arwrk);
                    } else {
                        $this->issue_to_external->ViewValue = FormatNumber($this->issue_to_external->CurrentValue, $this->issue_to_external->formatPattern());
                    }
                }
            } else {
                $this->issue_to_external->ViewValue = null;
            }

            // issue_to
            $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->ViewValue = FormatNumber($this->issue_to->CurrentValue, $this->issue_to->formatPattern());
                    }
                }
            } else {
                $this->issue_to->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_code
            $curVal = strval($this->product_code->CurrentValue);
            if ($curVal != "") {
                $this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
                if ($this->product_code->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_code->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_code->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_code->Lookup->renderViewRow($rswrk[0]);
                        $this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
                    } else {
                        $this->product_code->ViewValue = $this->product_code->CurrentValue;
                    }
                }
            } else {
                $this->product_code->ViewValue = null;
            }

            // item
            if ($this->item->VirtualValue != "") {
                $this->item->ViewValue = $this->item->VirtualValue;
            } else {
                $this->item->ViewValue = $this->item->CurrentValue;
                $curVal = strval($this->item->CurrentValue);
                if ($curVal != "") {
                    $this->item->ViewValue = $this->item->lookupCacheOption($curVal);
                    if ($this->item->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->item->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->item->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->item->Lookup->renderViewRow($rswrk[0]);
                            $this->item->ViewValue = $this->item->displayValue($arwrk);
                        } else {
                            $this->item->ViewValue = $this->item->CurrentValue;
                        }
                    }
                } else {
                    $this->item->ViewValue = null;
                }
            }

            // poid
            $curVal = strval($this->poid->CurrentValue);
            if ($curVal != "") {
                $this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
                if ($this->poid->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->poid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->poid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->poid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->poid->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->poid->Lookup->renderViewRow($row);
                            $this->poid->ViewValue->add($this->poid->displayValue($arwrk));
                        }
                    } else {
                        $this->poid->ViewValue = $this->poid->CurrentValue;
                    }
                }
            } else {
                $this->poid->ViewValue = null;
            }

            // po
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->po->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->po->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->po->Lookup->renderViewRow($row);
                            $this->po->ViewValue->add($this->po->displayValue($arwrk));
                        }
                    } else {
                        $this->po->ViewValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->ViewValue = null;
            }
            $this->po->CellCssStyle .= "text-align: left;";

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pro_unit
            $curVal = strval($this->pro_unit->CurrentValue);
            if ($curVal != "") {
                $this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
                if ($this->pro_unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pro_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pro_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pro_unit->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pro_unit->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pro_unit->Lookup->renderViewRow($rswrk[0]);
                        $this->pro_unit->ViewValue = $this->pro_unit->displayValue($arwrk);
                    } else {
                        $this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;
                    }
                }
            } else {
                $this->pro_unit->ViewValue = null;
            }

            // employee_id
            if ($this->employee_id->VirtualValue != "") {
                $this->employee_id->ViewValue = $this->employee_id->VirtualValue;
            } else {
                $curVal = strval($this->employee_id->CurrentValue);
                if ($curVal != "") {
                    $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                    if ($this->employee_id->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->employee_id->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                                $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                            }
                        } else {
                            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                        }
                    }
                } else {
                    $this->employee_id->ViewValue = null;
                }
            }

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // other1
            $this->other1->ViewValue = $this->other1->CurrentValue;

            // other2
            $this->other2->ViewValue = $this->other2->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // issue_to_internal
            $this->issue_to_internal->HrefValue = "";
            $this->issue_to_internal->TooltipValue = "";

            // issue_to_external
            $this->issue_to_external->HrefValue = "";
            $this->issue_to_external->TooltipValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";
            $this->issue_to->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }
            $this->item->TooltipValue = "";

            // poid
            if (!EmptyValue($this->poid->CurrentValue)) {
                $this->poid->HrefValue = $this->poid->getLinkPrefix() . $this->poid->CurrentValue; // Add prefix/suffix
                $this->poid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
                }
            } else {
                $this->poid->HrefValue = "";
            }
            $this->poid->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // quantity
            if (!EmptyValue($this->quantity->CurrentValue)) {
                $this->quantity->HrefValue = $this->quantity->getLinkPrefix() . $this->quantity->CurrentValue; // Add prefix/suffix
                $this->quantity->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
                }
            } else {
                $this->quantity->HrefValue = "";
            }
            $this->quantity->TooltipValue = "";

            // pro_unit
            $this->pro_unit->HrefValue = "";
            $this->pro_unit->TooltipValue = "";

            // employee_id
            if (!EmptyValue($this->employee_id->CurrentValue)) {
                $this->employee_id->HrefValue = $this->employee_id->getLinkPrefix() . $this->employee_id->CurrentValue; // Add prefix/suffix
                $this->employee_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
                }
            } else {
                $this->employee_id->HrefValue = "";
            }
            $this->employee_id->TooltipValue = "";

            // 1
            $this->_1->HrefValue = "";
            $this->_1->TooltipValue = "";

            // 2
            $this->_2->HrefValue = "";
            $this->_2->TooltipValue = "";

            // 3
            $this->_3->HrefValue = "";
            $this->_3->TooltipValue = "";

            // 4
            $this->_4->HrefValue = "";
            $this->_4->TooltipValue = "";

            // 5
            $this->_5->HrefValue = "";
            $this->_5->TooltipValue = "";

            // 6
            $this->_6->HrefValue = "";
            $this->_6->TooltipValue = "";

            // 7
            $this->_7->HrefValue = "";
            $this->_7->TooltipValue = "";

            // 8
            $this->_8->HrefValue = "";
            $this->_8->TooltipValue = "";

            // other1
            $this->other1->HrefValue = "";
            $this->other1->TooltipValue = "";

            // other2
            $this->other2->HrefValue = "";
            $this->other2->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->AdvancedSearch->SearchValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // buyer_id
            $curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
                if ($this->buyer_id->AdvancedSearch->ViewValue == "") {
                    $this->buyer_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->AdvancedSearch->SearchValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // issue_to_internal
            $this->issue_to_internal->setupEditAttributes();
            $curVal = trim(strval($this->issue_to_internal->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->issue_to_internal->AdvancedSearch->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
            } else {
                $this->issue_to_internal->AdvancedSearch->ViewValue = $this->issue_to_internal->Lookup !== null && is_array($this->issue_to_internal->lookupOptions()) && count($this->issue_to_internal->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to_internal->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->issue_to_internal->EditValue = array_values($this->issue_to_internal->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to_internal->AdvancedSearch->SearchValue, $this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to_internal->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_internal->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to_internal->EditValue = $arwrk;
            }
            $this->issue_to_internal->PlaceHolder = RemoveHtml($this->issue_to_internal->caption());

            // issue_to_external
            $this->issue_to_external->setupEditAttributes();
            $curVal = trim(strval($this->issue_to_external->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->issue_to_external->AdvancedSearch->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
            } else {
                $this->issue_to_external->AdvancedSearch->ViewValue = $this->issue_to_external->Lookup !== null && is_array($this->issue_to_external->lookupOptions()) && count($this->issue_to_external->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to_external->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->issue_to_external->EditValue = array_values($this->issue_to_external->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to_external->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to_external->AdvancedSearch->SearchValue, $this->issue_to_external->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to_external->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_external->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to_external->EditValue = $arwrk;
            }
            $this->issue_to_external->PlaceHolder = RemoveHtml($this->issue_to_external->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $this->issue_to->EditCustomAttributes = $this->issue_to->getEditCustomAttributes(); // PHP
            $this->issue_to->EditValue = $this->issue_to->AdvancedSearch->SearchValue;
            $curVal = strval($this->issue_to->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->issue_to->EditValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->EditValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->EditValue = HtmlEncode(FormatNumber($this->issue_to->AdvancedSearch->SearchValue, $this->issue_to->formatPattern()));
                    }
                }
            } else {
                $this->issue_to->EditValue = null;
            }
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // product_code
            $curVal = trim(strval($this->product_code->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product_code->AdvancedSearch->ViewValue = $this->product_code->lookupCacheOption($curVal);
            } else {
                $this->product_code->AdvancedSearch->ViewValue = $this->product_code->Lookup !== null && is_array($this->product_code->lookupOptions()) && count($this->product_code->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_code->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product_code->EditValue = array_values($this->product_code->lookupOptions());
                if ($this->product_code->AdvancedSearch->ViewValue == "") {
                    $this->product_code->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_code->AdvancedSearch->SearchValue, $this->product_code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_code->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_code->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_code->Lookup->renderViewRow($rswrk[0]);
                    $this->product_code->AdvancedSearch->ViewValue = $this->product_code->displayValue($arwrk);
                } else {
                    $this->product_code->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->product_code->Lookup->renderViewRow($row);
                }
                $this->product_code->EditValue = $arwrk;
            }
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // item
            $this->item->setupEditAttributes();
            $this->item->EditCustomAttributes = $this->item->getEditCustomAttributes(); // PHP
            $this->item->EditValue = $this->item->AdvancedSearch->SearchValue;
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // poid
            $curVal = trim(strval($this->poid->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->poid->AdvancedSearch->ViewValue = $this->poid->lookupCacheOption($curVal);
            } else {
                $this->poid->AdvancedSearch->ViewValue = $this->poid->Lookup !== null && is_array($this->poid->lookupOptions()) && count($this->poid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->poid->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->poid->EditValue = array_values($this->poid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->poid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->poid->getSelectFilter($this); // PHP
                $sqlWrk = $this->poid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->poid->Lookup->renderViewRow($row);
                }
                $this->poid->EditValue = $arwrk;
            }
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->AdvancedSearch->ViewValue == "") {
                    $this->batch_no->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->AdvancedSearch->SearchValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // pro_unit
            $this->pro_unit->setupEditAttributes();
            $curVal = trim(strval($this->pro_unit->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pro_unit->AdvancedSearch->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
            } else {
                $this->pro_unit->AdvancedSearch->ViewValue = $this->pro_unit->Lookup !== null && is_array($this->pro_unit->lookupOptions()) && count($this->pro_unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pro_unit->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pro_unit->EditValue = array_values($this->pro_unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pro_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pro_unit->AdvancedSearch->SearchValue, $this->pro_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pro_unit->getSelectFilter($this); // PHP
                $sqlWrk = $this->pro_unit->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pro_unit->EditValue = $arwrk;
            }
            $this->pro_unit->PlaceHolder = RemoveHtml($this->pro_unit->caption());

            // employee_id
            $this->employee_id->setupEditAttributes();
            if (!$this->employee_id->Raw) {
                $this->employee_id->AdvancedSearch->SearchValue = HtmlDecode($this->employee_id->AdvancedSearch->SearchValue);
            }
            $this->employee_id->EditValue = HtmlEncode($this->employee_id->AdvancedSearch->SearchValue);
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // other1
            $this->other1->setupEditAttributes();
            if (!$this->other1->Raw) {
                $this->other1->AdvancedSearch->SearchValue = HtmlDecode($this->other1->AdvancedSearch->SearchValue);
            }
            $this->other1->EditValue = HtmlEncode($this->other1->AdvancedSearch->SearchValue);
            $this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

            // other2
            $this->other2->setupEditAttributes();
            if (!$this->other2->Raw) {
                $this->other2->AdvancedSearch->SearchValue = HtmlDecode($this->other2->AdvancedSearch->SearchValue);
            }
            $this->other2->EditValue = HtmlEncode($this->other2->AdvancedSearch->SearchValue);
            $this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
            $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->issue_to->AdvancedSearch->SearchValue)) {
            $this->issue_to->addErrorMessage($this->issue_to->getErrorMessage(false));
        }
        if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->works->AdvancedSearch->load();
        $this->issue_to_internal->AdvancedSearch->load();
        $this->issue_to_external->AdvancedSearch->load();
        $this->issue_to->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->poid->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->pro_unit->AdvancedSearch->load();
        $this->employee_id->AdvancedSearch->load();
        $this->_1->AdvancedSearch->load();
        $this->_2->AdvancedSearch->load();
        $this->_3->AdvancedSearch->load();
        $this->_4->AdvancedSearch->load();
        $this->_5->AdvancedSearch->load();
        $this->_6->AdvancedSearch->load();
        $this->_7->AdvancedSearch->load();
        $this->_8->AdvancedSearch->load();
        $this->other1->AdvancedSearch->load();
        $this->other2->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("jobcardlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to_internal":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to_external":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_item":
                    break;
                case "x_poid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pro_unit":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_id":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
