<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class JobCardPendingQuerySearch extends JobCardPendingQuery
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "JobCardPendingQuerySearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "jobcardpendingquerysearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->works->setVisibility();
        $this->po->setVisibility();
        $this->jc_no->setVisibility();
        $this->datetime->setVisibility();
        $this->emp_name->setVisibility();
        $this->tqty->setVisibility();
        $this->count->setVisibility();
        $this->tsqm->setVisibility();
        $this->psqm->setVisibility();
        $this->pending_days->setVisibility();
        $this->design_size->setVisibility();
        $this->_barcode->setVisibility();
        $this->buyers_id->setVisibility();
        $this->plan_week->setVisibility();
        $this->dispatch_date->setVisibility();
        $this->loom_no->setVisibility();
        $this->operator->setVisibility();
        $this->completed->setVisibility();
        $this->status->setVisibility();
        $this->id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'job_card_pending_query';
        $this->TableName = 'job_card_pending_query';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (job_card_pending_query)
        if (!isset($GLOBALS["job_card_pending_query"]) || $GLOBALS["job_card_pending_query"]::class == PROJECT_NAMESPACE . "job_card_pending_query") {
            $GLOBALS["job_card_pending_query"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_pending_query');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "jobcardpendingqueryview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->tqty->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->count->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->tsqm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->psqm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->pending_days->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_barcode->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->completed->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->status->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->works);
        $this->setupLookupOptions($this->emp_name);
        $this->setupLookupOptions($this->_barcode);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->dispatch_date);
        $this->setupLookupOptions($this->loom_no);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->status);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "jobcardpendingquerylist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->works); // works
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->emp_name); // emp_name
        $this->buildSearchUrl($srchUrl, $this->tqty); // tqty
        $this->buildSearchUrl($srchUrl, $this->count); // count
        $this->buildSearchUrl($srchUrl, $this->tsqm); // tsqm
        $this->buildSearchUrl($srchUrl, $this->psqm); // psqm
        $this->buildSearchUrl($srchUrl, $this->pending_days); // pending_days
        $this->buildSearchUrl($srchUrl, $this->design_size); // design_size
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
        $this->buildSearchUrl($srchUrl, $this->plan_week); // plan_week
        $this->buildSearchUrl($srchUrl, $this->dispatch_date); // dispatch_date
        $this->buildSearchUrl($srchUrl, $this->loom_no); // loom_no
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->completed); // completed
        $this->buildSearchUrl($srchUrl, $this->status); // status
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // works
        if ($this->works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emp_name
        if ($this->emp_name->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->emp_name->AdvancedSearch->SearchValue)) {
            $this->emp_name->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->emp_name->AdvancedSearch->SearchValue);
        }
        if (is_array($this->emp_name->AdvancedSearch->SearchValue2)) {
            $this->emp_name->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->emp_name->AdvancedSearch->SearchValue2);
        }

        // tqty
        if ($this->tqty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // count
        if ($this->count->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // tsqm
        if ($this->tsqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // psqm
        if ($this->psqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pending_days
        if ($this->pending_days->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_size
        if ($this->design_size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->_barcode->AdvancedSearch->SearchValue)) {
            $this->_barcode->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->_barcode->AdvancedSearch->SearchValue);
        }
        if (is_array($this->_barcode->AdvancedSearch->SearchValue2)) {
            $this->_barcode->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->_barcode->AdvancedSearch->SearchValue2);
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // plan_week
        if ($this->plan_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dispatch_date
        if ($this->dispatch_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // loom_no
        if ($this->loom_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // completed
        if ($this->completed->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->status->AdvancedSearch->SearchValue)) {
            $this->status->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->status->AdvancedSearch->SearchValue);
        }
        if (is_array($this->status->AdvancedSearch->SearchValue2)) {
            $this->status->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->status->AdvancedSearch->SearchValue2);
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // works
        $this->works->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // emp_name
        $this->emp_name->RowCssClass = "row";

        // tqty
        $this->tqty->RowCssClass = "row";

        // count
        $this->count->RowCssClass = "row";

        // tsqm
        $this->tsqm->RowCssClass = "row";

        // psqm
        $this->psqm->RowCssClass = "row";

        // pending_days
        $this->pending_days->RowCssClass = "row";

        // design_size
        $this->design_size->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // plan_week
        $this->plan_week->RowCssClass = "row";

        // dispatch_date
        $this->dispatch_date->RowCssClass = "row";

        // loom_no
        $this->loom_no->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // works
            $curVal = strval($this->works->CurrentValue);
            if ($curVal != "") {
                $this->works->ViewValue = $this->works->lookupCacheOption($curVal);
                if ($this->works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->works->Lookup->renderViewRow($rswrk[0]);
                        $this->works->ViewValue = $this->works->displayValue($arwrk);
                    } else {
                        $this->works->ViewValue = FormatNumber($this->works->CurrentValue, $this->works->formatPattern());
                    }
                }
            } else {
                $this->works->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // emp_name
            $curVal = strval($this->emp_name->CurrentValue);
            if ($curVal != "") {
                $this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
                if ($this->emp_name->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->emp_name->getSelectFilter($this); // PHP
                    $sqlWrk = $this->emp_name->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->emp_name->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->emp_name->Lookup->renderViewRow($row);
                            $this->emp_name->ViewValue->add($this->emp_name->displayValue($arwrk));
                        }
                    } else {
                        $this->emp_name->ViewValue = $this->emp_name->CurrentValue;
                    }
                }
            } else {
                $this->emp_name->ViewValue = null;
            }

            // tqty
            $this->tqty->ViewValue = $this->tqty->CurrentValue;
            $this->tqty->ViewValue = FormatNumber($this->tqty->ViewValue, $this->tqty->formatPattern());

            // count
            $this->count->ViewValue = $this->count->CurrentValue;
            $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());

            // tsqm
            $this->tsqm->ViewValue = $this->tsqm->CurrentValue;
            $this->tsqm->ViewValue = FormatNumber($this->tsqm->ViewValue, $this->tsqm->formatPattern());

            // psqm
            $this->psqm->ViewValue = $this->psqm->CurrentValue;
            $this->psqm->ViewValue = FormatNumber($this->psqm->ViewValue, $this->psqm->formatPattern());

            // pending_days
            $this->pending_days->ViewValue = $this->pending_days->CurrentValue;
            $this->pending_days->ViewValue = FormatNumber($this->pending_days->ViewValue, $this->pending_days->formatPattern());

            // design_size
            $this->design_size->ViewValue = $this->design_size->CurrentValue;

            // barcode
            $curVal = strval($this->_barcode->CurrentValue);
            if ($curVal != "") {
                $this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
                if ($this->_barcode->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->_barcode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->_barcode->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                            $this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
                        }
                    } else {
                        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
                    }
                }
            } else {
                $this->_barcode->ViewValue = null;
            }

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // plan_week
            $this->plan_week->ViewValue = $this->plan_week->CurrentValue;
            $this->plan_week->ViewValue = FormatNumber($this->plan_week->ViewValue, $this->plan_week->formatPattern());

            // dispatch_date
            $curVal = strval($this->dispatch_date->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_date->ViewValue = $this->dispatch_date->lookupCacheOption($curVal);
                if ($this->dispatch_date->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_date->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_date->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_date->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_date->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_date->ViewValue = $this->dispatch_date->displayValue($arwrk);
                    } else {
                        $this->dispatch_date->ViewValue = $this->dispatch_date->CurrentValue;
                    }
                }
            } else {
                $this->dispatch_date->ViewValue = null;
            }

            // loom_no
            $curVal = strval($this->loom_no->CurrentValue);
            if ($curVal != "") {
                $this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
                if ($this->loom_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->loom_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->loom_no->Lookup->renderViewRow($rswrk[0]);
                        $this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
                    } else {
                        $this->loom_no->ViewValue = FormatNumber($this->loom_no->CurrentValue, $this->loom_no->formatPattern());
                    }
                }
            } else {
                $this->loom_no->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->status->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->status->Lookup->renderViewRow($row);
                            $this->status->ViewValue->add($this->status->displayValue($arwrk));
                        }
                    } else {
                        $this->status->ViewValue = $this->status->CurrentValue;
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // works
            $this->works->HrefValue = "";
            $this->works->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // jc_no
            if (!EmptyValue($this->jc_no->CurrentValue)) {
                $this->jc_no->HrefValue = $this->jc_no->getLinkPrefix() . $this->jc_no->CurrentValue; // Add prefix/suffix
                $this->jc_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
                }
            } else {
                $this->jc_no->HrefValue = "";
            }
            $this->jc_no->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // emp_name
            $this->emp_name->HrefValue = "";
            $this->emp_name->TooltipValue = "";

            // tqty
            $this->tqty->HrefValue = "";
            $this->tqty->TooltipValue = "";

            // count
            $this->count->HrefValue = "";
            $this->count->TooltipValue = "";

            // tsqm
            $this->tsqm->HrefValue = "";
            $this->tsqm->TooltipValue = "";

            // psqm
            $this->psqm->HrefValue = "";
            $this->psqm->TooltipValue = "";

            // pending_days
            $this->pending_days->HrefValue = "";
            $this->pending_days->TooltipValue = "";

            // design_size
            $this->design_size->HrefValue = "";
            $this->design_size->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // buyers_id
            $this->buyers_id->HrefValue = "";
            $this->buyers_id->TooltipValue = "";

            // plan_week
            $this->plan_week->HrefValue = "";
            $this->plan_week->TooltipValue = "";

            // dispatch_date
            $this->dispatch_date->HrefValue = "";
            $this->dispatch_date->TooltipValue = "";

            // loom_no
            $this->loom_no->HrefValue = "";
            $this->loom_no->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // works
            $this->works->setupEditAttributes();
            $curVal = trim(strval($this->works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->works->AdvancedSearch->ViewValue = $this->works->lookupCacheOption($curVal);
            } else {
                $this->works->AdvancedSearch->ViewValue = $this->works->Lookup !== null && is_array($this->works->lookupOptions()) && count($this->works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->works->EditValue = array_values($this->works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->works->AdvancedSearch->SearchValue, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->works->getSelectFilter($this); // PHP
                $sqlWrk = $this->works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->works->EditValue = $arwrk;
            }
            $this->works->PlaceHolder = RemoveHtml($this->works->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->AdvancedSearch->SearchValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // emp_name
            $this->emp_name->setupEditAttributes();
            $curVal = trim(strval($this->emp_name->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->emp_name->AdvancedSearch->ViewValue = $this->emp_name->lookupCacheOption($curVal);
            } else {
                $this->emp_name->AdvancedSearch->ViewValue = $this->emp_name->Lookup !== null && is_array($this->emp_name->lookupOptions()) && count($this->emp_name->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->emp_name->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->emp_name->EditValue = array_values($this->emp_name->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->emp_name->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_name->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->emp_name->Lookup->renderViewRow($row);
                }
                $this->emp_name->EditValue = $arwrk;
            }
            $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

            // tqty
            $this->tqty->setupEditAttributes();
            $this->tqty->EditValue = $this->tqty->AdvancedSearch->SearchValue;
            $this->tqty->PlaceHolder = RemoveHtml($this->tqty->caption());

            // count
            $this->count->setupEditAttributes();
            $this->count->EditValue = $this->count->AdvancedSearch->SearchValue;
            $this->count->PlaceHolder = RemoveHtml($this->count->caption());

            // tsqm
            $this->tsqm->setupEditAttributes();
            $this->tsqm->EditValue = $this->tsqm->AdvancedSearch->SearchValue;
            $this->tsqm->PlaceHolder = RemoveHtml($this->tsqm->caption());

            // psqm
            $this->psqm->setupEditAttributes();
            $this->psqm->EditValue = $this->psqm->AdvancedSearch->SearchValue;
            $this->psqm->PlaceHolder = RemoveHtml($this->psqm->caption());

            // pending_days
            $this->pending_days->setupEditAttributes();
            $this->pending_days->EditValue = $this->pending_days->AdvancedSearch->SearchValue;
            $this->pending_days->PlaceHolder = RemoveHtml($this->pending_days->caption());

            // design_size
            $this->design_size->setupEditAttributes();
            if (!$this->design_size->Raw) {
                $this->design_size->AdvancedSearch->SearchValue = HtmlDecode($this->design_size->AdvancedSearch->SearchValue);
            }
            $this->design_size->EditValue = HtmlEncode($this->design_size->AdvancedSearch->SearchValue);
            $this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $curVal = trim(strval($this->_barcode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->_barcode->AdvancedSearch->ViewValue = $this->_barcode->lookupCacheOption($curVal);
            } else {
                $this->_barcode->AdvancedSearch->ViewValue = $this->_barcode->Lookup !== null && is_array($this->_barcode->lookupOptions()) && count($this->_barcode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_barcode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->_barcode->EditValue = array_values($this->_barcode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->_barcode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->_barcode->EditValue = $arwrk;
            }
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            } else {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== null && is_array($this->buyers_id->lookupOptions()) && count($this->buyers_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyers_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyers_id->EditValue = array_values($this->buyers_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyers_id->AdvancedSearch->SearchValue, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyers_id->EditValue = $arwrk;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // plan_week
            $this->plan_week->setupEditAttributes();
            $this->plan_week->EditValue = $this->plan_week->AdvancedSearch->SearchValue;
            $this->plan_week->PlaceHolder = RemoveHtml($this->plan_week->caption());

            // dispatch_date
            $this->dispatch_date->setupEditAttributes();
            $curVal = trim(strval($this->dispatch_date->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->dispatch_date->AdvancedSearch->ViewValue = $this->dispatch_date->lookupCacheOption($curVal);
            } else {
                $this->dispatch_date->AdvancedSearch->ViewValue = $this->dispatch_date->Lookup !== null && is_array($this->dispatch_date->lookupOptions()) && count($this->dispatch_date->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->dispatch_date->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->dispatch_date->EditValue = array_values($this->dispatch_date->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->dispatch_date->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->dispatch_date->AdvancedSearch->SearchValue, $this->dispatch_date->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->dispatch_date->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->dispatch_date->EditValue = $arwrk;
            }
            $this->dispatch_date->PlaceHolder = RemoveHtml($this->dispatch_date->caption());

            // loom_no
            $this->loom_no->setupEditAttributes();
            $curVal = trim(strval($this->loom_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->loom_no->AdvancedSearch->ViewValue = $this->loom_no->lookupCacheOption($curVal);
            } else {
                $this->loom_no->AdvancedSearch->ViewValue = $this->loom_no->Lookup !== null && is_array($this->loom_no->lookupOptions()) && count($this->loom_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->loom_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->loom_no->EditValue = array_values($this->loom_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->loom_no->AdvancedSearch->SearchValue, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->loom_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->loom_no->EditValue = $arwrk;
            }
            $this->loom_no->PlaceHolder = RemoveHtml($this->loom_no->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
            $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->tqty->AdvancedSearch->SearchValue)) {
            $this->tqty->addErrorMessage($this->tqty->getErrorMessage(false));
        }
        if (!CheckInteger($this->count->AdvancedSearch->SearchValue)) {
            $this->count->addErrorMessage($this->count->getErrorMessage(false));
        }
        if (!CheckNumber($this->tsqm->AdvancedSearch->SearchValue)) {
            $this->tsqm->addErrorMessage($this->tsqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->psqm->AdvancedSearch->SearchValue)) {
            $this->psqm->addErrorMessage($this->psqm->getErrorMessage(false));
        }
        if (!CheckInteger($this->pending_days->AdvancedSearch->SearchValue)) {
            $this->pending_days->addErrorMessage($this->pending_days->getErrorMessage(false));
        }
        if (!CheckInteger($this->plan_week->AdvancedSearch->SearchValue)) {
            $this->plan_week->addErrorMessage($this->plan_week->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->works->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->emp_name->AdvancedSearch->load();
        $this->tqty->AdvancedSearch->load();
        $this->count->AdvancedSearch->load();
        $this->tsqm->AdvancedSearch->load();
        $this->psqm->AdvancedSearch->load();
        $this->pending_days->AdvancedSearch->load();
        $this->design_size->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->plan_week->AdvancedSearch->load();
        $this->dispatch_date->AdvancedSearch->load();
        $this->loom_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("jobcardpendingquerylist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_emp_name":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__barcode":
                    break;
                case "x_buyers_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_dispatch_date":
                    break;
                case "x_loom_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_completed":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
