<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for job_card_pending_query
 */
class JobCardPendingQuery extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $works;
    public $po;
    public $jc_no;
    public $datetime;
    public $emp_name;
    public $tqty;
    public $count;
    public $tsqm;
    public $psqm;
    public $pending_days;
    public $design_size;
    public $_barcode;
    public $buyers_id;
    public $plan_week;
    public $dispatch_date;
    public $loom_no;
    public $operator;
    public $completed;
    public $status;
    public $id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "job_card_pending_query";
        $this->TableName = 'job_card_pending_query';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "job_card_pending_query";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // works
        $this->works = new DbField(
            $this, // Table
            'x_works', // Variable name
            'works', // Name
            '`works`', // Expression
            '`works`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->works->InputTextType = "text";
        $this->works->Raw = true;
        $this->works->Required = true; // Required field
        $this->works->setSelectMultiple(false); // Select one
        $this->works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->works->Lookup = new Lookup($this->works, 'godown', true, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->works) . "',COALESCE(`code`,''))");
        $this->works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['works'] = &$this->works;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->addMethod("getDefault", fn() => 0);
        $this->jc_no->addMethod("getLinkPrefix", fn() => "printjobcardbc?id=0&jc=");
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->Required = true; // Required field
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // emp_name
        $this->emp_name = new DbField(
            $this, // Table
            'x_emp_name', // Variable name
            'emp_name', // Name
            '`emp_name`', // Expression
            '`emp_name`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->emp_name->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->emp_name->InputTextType = "text";
        $this->emp_name->setSelectMultiple(true); // Select multiple
        $this->emp_name->Lookup = new Lookup($this->emp_name, 'production_employee_view2', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->emp_name) . "',COALESCE(`user_name`,''))");
        $this->emp_name->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['emp_name'] = &$this->emp_name;

        // tqty
        $this->tqty = new DbField(
            $this, // Table
            'x_tqty', // Variable name
            'tqty', // Name
            '`tqty`', // Expression
            '`tqty`', // Basic search expression
            20, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tqty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tqty->InputTextType = "text";
        $this->tqty->Raw = true;
        $this->tqty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->tqty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tqty'] = &$this->tqty;

        // count
        $this->count = new DbField(
            $this, // Table
            'x_count', // Variable name
            'count', // Name
            '`count`', // Expression
            '`count`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`count`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->count->addMethod("getDefault", fn() => 0);
        $this->count->InputTextType = "text";
        $this->count->Raw = true;
        $this->count->Nullable = false; // NOT NULL field
        $this->count->Required = true; // Required field
        $this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->count->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['count'] = &$this->count;

        // tsqm
        $this->tsqm = new DbField(
            $this, // Table
            'x_tsqm', // Variable name
            'tsqm', // Name
            '`tsqm`', // Expression
            '`tsqm`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tsqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tsqm->InputTextType = "text";
        $this->tsqm->Raw = true;
        $this->tsqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tsqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tsqm'] = &$this->tsqm;

        // psqm
        $this->psqm = new DbField(
            $this, // Table
            'x_psqm', // Variable name
            'psqm', // Name
            '`psqm`', // Expression
            '`psqm`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`psqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->psqm->addMethod("getDefault", fn() => 0);
        $this->psqm->InputTextType = "text";
        $this->psqm->Raw = true;
        $this->psqm->Nullable = false; // NOT NULL field
        $this->psqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->psqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['psqm'] = &$this->psqm;

        // pending_days
        $this->pending_days = new DbField(
            $this, // Table
            'x_pending_days', // Variable name
            'pending_days', // Name
            '`pending_days`', // Expression
            '`pending_days`', // Basic search expression
            3, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending_days`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending_days->InputTextType = "text";
        $this->pending_days->Raw = true;
        $this->pending_days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pending_days->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pending_days'] = &$this->pending_days;

        // design_size
        $this->design_size = new DbField(
            $this, // Table
            'x_design_size', // Variable name
            'design_size', // Name
            '`design_size`', // Expression
            '`design_size`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design_size->InputTextType = "text";
        $this->design_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_size'] = &$this->design_size;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->_barcode->addMethod("getDefault", fn() => 0);
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Required = true; // Required field
        $this->_barcode->setSelectMultiple(true); // Select multiple
        $this->_barcode->Lookup = new Lookup($this->_barcode, 'bcode', false, 'barcode', ["barcode","","",""], '', '', [], [], [], [], [], [], false, '`barcode` ASC', '', "`barcode`");
        $this->_barcode->MemoMaxLength = 300;
        $this->_barcode->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyers_id->addMethod("getSelectFilter", fn() => "`partner_type` = 2");
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->setSelectMultiple(false); // Select one
        $this->buyers_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer_seller_view', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // plan_week
        $this->plan_week = new DbField(
            $this, // Table
            'x_plan_week', // Variable name
            'plan_week', // Name
            '`plan_week`', // Expression
            '`plan_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`plan_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->plan_week->InputTextType = "text";
        $this->plan_week->Raw = true;
        $this->plan_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->plan_week->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['plan_week'] = &$this->plan_week;

        // dispatch_date
        $this->dispatch_date = new DbField(
            $this, // Table
            'x_dispatch_date', // Variable name
            'dispatch_date', // Name
            '`dispatch_date`', // Expression
            '`dispatch_date`', // Basic search expression
            18, // Type
            5, // Size
            7, // Date/Time format
            false, // Is upload field
            '`dispatch_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->dispatch_date->InputTextType = "text";
        $this->dispatch_date->Raw = true;
        $this->dispatch_date->Required = true; // Required field
        $this->dispatch_date->setSelectMultiple(false); // Select one
        $this->dispatch_date->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->dispatch_date->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->dispatch_date->Lookup = new Lookup($this->dispatch_date, 'not_week', false, 'id', ["week","","",""], '', '', [], [], [], [], [], [], false, '`week` ASC', '', "`week`");
        $this->dispatch_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->dispatch_date->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dispatch_date'] = &$this->dispatch_date;

        // loom_no
        $this->loom_no = new DbField(
            $this, // Table
            'x_loom_no', // Variable name
            'loom_no', // Name
            '`loom_no`', // Expression
            '`loom_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`loom_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->loom_no->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->loom_no->InputTextType = "text";
        $this->loom_no->Raw = true;
        $this->loom_no->setSelectMultiple(false); // Select one
        $this->loom_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->loom_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->loom_no->Lookup = new Lookup($this->loom_no, 'loom_info', false, 'id', ["id","item","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->loom_no) . "',COALESCE(`item`,''))");
        $this->loom_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->loom_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['loom_no'] = &$this->loom_no;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Sortable = false; // Allow sort
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // completed
        $this->completed = new DbField(
            $this, // Table
            'x_completed', // Variable name
            'completed', // Name
            '`completed`', // Expression
            '`completed`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`completed`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->completed->InputTextType = "text";
        $this->completed->setSelectMultiple(false); // Select one
        $this->completed->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->completed->Lookup = new Lookup($this->completed, 'job_card_pending_query', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->completed->OptionCount = 2;
        $this->completed->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['completed'] = &$this->completed;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->setSelectMultiple(true); // Select multiple
        $this->status->Lookup = new Lookup($this->status, 'status', true, 'id', ["item","","",""], 'grp', '`grp`', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->status->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Sortable = false; // Allow sort
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "job_card_pending_query";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Site()  == 0)? "" : "FIND_IN_SET(`works`, " . User_Site() . ")";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->works->DbValue = $row['works'];
        $this->po->DbValue = $row['po'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->datetime->DbValue = $row['datetime'];
        $this->emp_name->DbValue = $row['emp_name'];
        $this->tqty->DbValue = $row['tqty'];
        $this->count->DbValue = $row['count'];
        $this->tsqm->DbValue = $row['tsqm'];
        $this->psqm->DbValue = $row['psqm'];
        $this->pending_days->DbValue = $row['pending_days'];
        $this->design_size->DbValue = $row['design_size'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->plan_week->DbValue = $row['plan_week'];
        $this->dispatch_date->DbValue = $row['dispatch_date'];
        $this->loom_no->DbValue = $row['loom_no'];
        $this->operator->DbValue = $row['operator'];
        $this->completed->DbValue = $row['completed'];
        $this->status->DbValue = $row['status'];
        $this->id->DbValue = $row['id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("jobcardpendingquerylist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "jobcardpendingqueryview" => $Language->phrase("View"),
            "jobcardpendingqueryedit" => $Language->phrase("Edit"),
            "jobcardpendingqueryadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "jobcardpendingquerylist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "JobCardPendingQueryView",
            Config("API_ADD_ACTION") => "JobCardPendingQueryAdd",
            Config("API_EDIT_ACTION") => "JobCardPendingQueryEdit",
            Config("API_DELETE_ACTION") => "JobCardPendingQueryDelete",
            Config("API_LIST_ACTION") => "JobCardPendingQueryList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "jobcardpendingquerylist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("jobcardpendingqueryview", $parm);
        } else {
            $url = $this->keyUrl("jobcardpendingqueryview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "jobcardpendingqueryadd?" . $parm;
        } else {
            $url = "jobcardpendingqueryadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("jobcardpendingqueryedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("jobcardpendingquerylist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("jobcardpendingqueryadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("jobcardpendingquerylist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("jobcardpendingquerydelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->works->setDbValue($row['works']);
        $this->po->setDbValue($row['po']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->datetime->setDbValue($row['datetime']);
        $this->emp_name->setDbValue($row['emp_name']);
        $this->tqty->setDbValue($row['tqty']);
        $this->count->setDbValue($row['count']);
        $this->tsqm->setDbValue($row['tsqm']);
        $this->psqm->setDbValue($row['psqm']);
        $this->pending_days->setDbValue($row['pending_days']);
        $this->design_size->setDbValue($row['design_size']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->plan_week->setDbValue($row['plan_week']);
        $this->dispatch_date->setDbValue($row['dispatch_date']);
        $this->loom_no->setDbValue($row['loom_no']);
        $this->operator->setDbValue($row['operator']);
        $this->completed->setDbValue($row['completed']);
        $this->status->setDbValue($row['status']);
        $this->id->setDbValue($row['id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "JobCardPendingQueryList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // works

        // po

        // jc_no

        // datetime

        // emp_name

        // tqty

        // count

        // tsqm

        // psqm

        // pending_days

        // design_size

        // barcode

        // buyers_id

        // plan_week

        // dispatch_date

        // loom_no

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // completed

        // status

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // works
        $curVal = strval($this->works->CurrentValue);
        if ($curVal != "") {
            $this->works->ViewValue = $this->works->lookupCacheOption($curVal);
            if ($this->works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->works->getSelectFilter($this); // PHP
                $sqlWrk = $this->works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->works->Lookup->renderViewRow($rswrk[0]);
                    $this->works->ViewValue = $this->works->displayValue($arwrk);
                } else {
                    $this->works->ViewValue = FormatNumber($this->works->CurrentValue, $this->works->formatPattern());
                }
            }
        } else {
            $this->works->ViewValue = null;
        }

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // emp_name
        $curVal = strval($this->emp_name->CurrentValue);
        if ($curVal != "") {
            $this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
            if ($this->emp_name->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->emp_name->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_name->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->emp_name->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->emp_name->Lookup->renderViewRow($row);
                        $this->emp_name->ViewValue->add($this->emp_name->displayValue($arwrk));
                    }
                } else {
                    $this->emp_name->ViewValue = $this->emp_name->CurrentValue;
                }
            }
        } else {
            $this->emp_name->ViewValue = null;
        }

        // tqty
        $this->tqty->ViewValue = $this->tqty->CurrentValue;
        $this->tqty->ViewValue = FormatNumber($this->tqty->ViewValue, $this->tqty->formatPattern());

        // count
        $this->count->ViewValue = $this->count->CurrentValue;
        $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());

        // tsqm
        $this->tsqm->ViewValue = $this->tsqm->CurrentValue;
        $this->tsqm->ViewValue = FormatNumber($this->tsqm->ViewValue, $this->tsqm->formatPattern());

        // psqm
        $this->psqm->ViewValue = $this->psqm->CurrentValue;
        $this->psqm->ViewValue = FormatNumber($this->psqm->ViewValue, $this->psqm->formatPattern());

        // pending_days
        $this->pending_days->ViewValue = $this->pending_days->CurrentValue;
        $this->pending_days->ViewValue = FormatNumber($this->pending_days->ViewValue, $this->pending_days->formatPattern());

        // design_size
        $this->design_size->ViewValue = $this->design_size->CurrentValue;

        // barcode
        $curVal = strval($this->_barcode->CurrentValue);
        if ($curVal != "") {
            $this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
            if ($this->_barcode->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->_barcode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->_barcode->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                        $this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
                    }
                } else {
                    $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
                }
            }
        } else {
            $this->_barcode->ViewValue = null;
        }

        // buyers_id
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // plan_week
        $this->plan_week->ViewValue = $this->plan_week->CurrentValue;
        $this->plan_week->ViewValue = FormatNumber($this->plan_week->ViewValue, $this->plan_week->formatPattern());

        // dispatch_date
        $curVal = strval($this->dispatch_date->CurrentValue);
        if ($curVal != "") {
            $this->dispatch_date->ViewValue = $this->dispatch_date->lookupCacheOption($curVal);
            if ($this->dispatch_date->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->dispatch_date->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_date->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->dispatch_date->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->dispatch_date->Lookup->renderViewRow($rswrk[0]);
                    $this->dispatch_date->ViewValue = $this->dispatch_date->displayValue($arwrk);
                } else {
                    $this->dispatch_date->ViewValue = $this->dispatch_date->CurrentValue;
                }
            }
        } else {
            $this->dispatch_date->ViewValue = null;
        }

        // loom_no
        $curVal = strval($this->loom_no->CurrentValue);
        if ($curVal != "") {
            $this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
            if ($this->loom_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->loom_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->loom_no->Lookup->renderViewRow($rswrk[0]);
                    $this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
                } else {
                    $this->loom_no->ViewValue = FormatNumber($this->loom_no->CurrentValue, $this->loom_no->formatPattern());
                }
            }
        } else {
            $this->loom_no->ViewValue = null;
        }

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // completed
        if (strval($this->completed->CurrentValue) != "") {
            $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
        } else {
            $this->completed->ViewValue = null;
        }

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->status->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->status->Lookup->renderViewRow($row);
                        $this->status->ViewValue->add($this->status->displayValue($arwrk));
                    }
                } else {
                    $this->status->ViewValue = $this->status->CurrentValue;
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // works
        $this->works->HrefValue = "";
        $this->works->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // jc_no
        if (!EmptyValue($this->jc_no->CurrentValue)) {
            $this->jc_no->HrefValue = $this->jc_no->getLinkPrefix() . $this->jc_no->CurrentValue; // Add prefix/suffix
            $this->jc_no->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
            }
        } else {
            $this->jc_no->HrefValue = "";
        }
        $this->jc_no->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // emp_name
        $this->emp_name->HrefValue = "";
        $this->emp_name->TooltipValue = "";

        // tqty
        $this->tqty->HrefValue = "";
        $this->tqty->TooltipValue = "";

        // count
        $this->count->HrefValue = "";
        $this->count->TooltipValue = "";

        // tsqm
        $this->tsqm->HrefValue = "";
        $this->tsqm->TooltipValue = "";

        // psqm
        $this->psqm->HrefValue = "";
        $this->psqm->TooltipValue = "";

        // pending_days
        $this->pending_days->HrefValue = "";
        $this->pending_days->TooltipValue = "";

        // design_size
        $this->design_size->HrefValue = "";
        $this->design_size->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // buyers_id
        $this->buyers_id->HrefValue = "";
        $this->buyers_id->TooltipValue = "";

        // plan_week
        $this->plan_week->HrefValue = "";
        $this->plan_week->TooltipValue = "";

        // dispatch_date
        $this->dispatch_date->HrefValue = "";
        $this->dispatch_date->TooltipValue = "";

        // loom_no
        $this->loom_no->HrefValue = "";
        $this->loom_no->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // completed
        $this->completed->HrefValue = "";
        $this->completed->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // works
        $this->works->setupEditAttributes();
        $this->works->PlaceHolder = RemoveHtml($this->works->caption());

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());
        if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
            $this->po->EditValue = FormatNumber($this->po->EditValue, null);
        }

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // datetime
        $this->datetime->setupEditAttributes();
        $this->datetime->EditValue = $this->datetime->CurrentValue;
        $this->datetime->EditValue = FormatDateTime($this->datetime->EditValue, $this->datetime->formatPattern());

        // emp_name
        $this->emp_name->setupEditAttributes();
        $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

        // tqty
        $this->tqty->setupEditAttributes();
        $this->tqty->EditValue = $this->tqty->CurrentValue;
        $this->tqty->PlaceHolder = RemoveHtml($this->tqty->caption());
        if (strval($this->tqty->EditValue) != "" && is_numeric($this->tqty->EditValue)) {
            $this->tqty->EditValue = FormatNumber($this->tqty->EditValue, null);
        }

        // count
        $this->count->setupEditAttributes();
        $this->count->EditValue = $this->count->CurrentValue;
        $this->count->PlaceHolder = RemoveHtml($this->count->caption());
        if (strval($this->count->EditValue) != "" && is_numeric($this->count->EditValue)) {
            $this->count->EditValue = FormatNumber($this->count->EditValue, null);
        }

        // tsqm
        $this->tsqm->setupEditAttributes();
        $this->tsqm->EditValue = $this->tsqm->CurrentValue;
        $this->tsqm->PlaceHolder = RemoveHtml($this->tsqm->caption());
        if (strval($this->tsqm->EditValue) != "" && is_numeric($this->tsqm->EditValue)) {
            $this->tsqm->EditValue = FormatNumber($this->tsqm->EditValue, null);
        }

        // psqm
        $this->psqm->setupEditAttributes();
        $this->psqm->EditValue = $this->psqm->CurrentValue;
        $this->psqm->PlaceHolder = RemoveHtml($this->psqm->caption());
        if (strval($this->psqm->EditValue) != "" && is_numeric($this->psqm->EditValue)) {
            $this->psqm->EditValue = FormatNumber($this->psqm->EditValue, null);
        }

        // pending_days
        $this->pending_days->setupEditAttributes();
        $this->pending_days->EditValue = $this->pending_days->CurrentValue;
        $this->pending_days->PlaceHolder = RemoveHtml($this->pending_days->caption());
        if (strval($this->pending_days->EditValue) != "" && is_numeric($this->pending_days->EditValue)) {
            $this->pending_days->EditValue = FormatNumber($this->pending_days->EditValue, null);
        }

        // design_size
        $this->design_size->setupEditAttributes();
        if (!$this->design_size->Raw) {
            $this->design_size->CurrentValue = HtmlDecode($this->design_size->CurrentValue);
        }
        $this->design_size->EditValue = $this->design_size->CurrentValue;
        $this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

        // barcode
        $this->_barcode->setupEditAttributes();
        $curVal = strval($this->_barcode->CurrentValue);
        if ($curVal != "") {
            $this->_barcode->EditValue = $this->_barcode->lookupCacheOption($curVal);
            if ($this->_barcode->EditValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->_barcode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->_barcode->EditValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                        $this->_barcode->EditValue->add($this->_barcode->displayValue($arwrk));
                    }
                } else {
                    $this->_barcode->EditValue = $this->_barcode->CurrentValue;
                }
            }
        } else {
            $this->_barcode->EditValue = null;
        }

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

        // plan_week
        $this->plan_week->setupEditAttributes();
        $this->plan_week->EditValue = $this->plan_week->CurrentValue;
        $this->plan_week->PlaceHolder = RemoveHtml($this->plan_week->caption());
        if (strval($this->plan_week->EditValue) != "" && is_numeric($this->plan_week->EditValue)) {
            $this->plan_week->EditValue = FormatNumber($this->plan_week->EditValue, null);
        }

        // dispatch_date
        $this->dispatch_date->setupEditAttributes();
        $this->dispatch_date->PlaceHolder = RemoveHtml($this->dispatch_date->caption());

        // loom_no
        $this->loom_no->setupEditAttributes();
        $this->loom_no->PlaceHolder = RemoveHtml($this->loom_no->caption());

        // operator
        $this->operator->setupEditAttributes();
        $this->operator->EditValue = $this->operator->CurrentValue;
        $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
        if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
            $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
        }

        // completed
        $this->completed->setupEditAttributes();
        $this->completed->EditValue = $this->completed->options(true);
        $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->tqty->CurrentValue)) {
                $this->tqty->Total += $this->tqty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->count->CurrentValue)) {
                $this->count->Total += $this->count->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->tsqm->CurrentValue)) {
                $this->tsqm->Total += $this->tsqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->psqm->CurrentValue)) {
                $this->psqm->Total += $this->psqm->CurrentValue; // Accumulate total
            }
            $this->pending_days->Count++; // Increment count
            if (is_numeric($this->pending_days->CurrentValue)) {
                $this->pending_days->Total += $this->pending_days->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->tqty->CurrentValue = $this->tqty->Total;
            $this->tqty->ViewValue = $this->tqty->CurrentValue;
            $this->tqty->ViewValue = FormatNumber($this->tqty->ViewValue, $this->tqty->formatPattern());
            $this->tqty->HrefValue = ""; // Clear href value
            $this->count->CurrentValue = $this->count->Total;
            $this->count->ViewValue = $this->count->CurrentValue;
            $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());
            $this->count->HrefValue = ""; // Clear href value
            $this->tsqm->CurrentValue = $this->tsqm->Total;
            $this->tsqm->ViewValue = $this->tsqm->CurrentValue;
            $this->tsqm->ViewValue = FormatNumber($this->tsqm->ViewValue, $this->tsqm->formatPattern());
            $this->tsqm->HrefValue = ""; // Clear href value
            $this->psqm->CurrentValue = $this->psqm->Total;
            $this->psqm->ViewValue = $this->psqm->CurrentValue;
            $this->psqm->ViewValue = FormatNumber($this->psqm->ViewValue, $this->psqm->formatPattern());
            $this->psqm->HrefValue = ""; // Clear href value
            if ($this->pending_days->Count > 0) {
                $this->pending_days->CurrentValue = $this->pending_days->Total / $this->pending_days->Count;
            }
            $this->pending_days->ViewValue = $this->pending_days->CurrentValue;
            $this->pending_days->ViewValue = FormatNumber($this->pending_days->ViewValue, $this->pending_days->formatPattern());
            $this->pending_days->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->works);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->emp_name);
                    $doc->exportCaption($this->tqty);
                    $doc->exportCaption($this->count);
                    $doc->exportCaption($this->tsqm);
                    $doc->exportCaption($this->psqm);
                    $doc->exportCaption($this->pending_days);
                    $doc->exportCaption($this->design_size);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->plan_week);
                    $doc->exportCaption($this->dispatch_date);
                    $doc->exportCaption($this->loom_no);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->status);
                } else {
                    $doc->exportCaption($this->works);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->emp_name);
                    $doc->exportCaption($this->tqty);
                    $doc->exportCaption($this->count);
                    $doc->exportCaption($this->tsqm);
                    $doc->exportCaption($this->psqm);
                    $doc->exportCaption($this->pending_days);
                    $doc->exportCaption($this->design_size);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->plan_week);
                    $doc->exportCaption($this->dispatch_date);
                    $doc->exportCaption($this->loom_no);
                    $doc->exportCaption($this->operator);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->works);
                        $doc->exportField($this->po);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->emp_name);
                        $doc->exportField($this->tqty);
                        $doc->exportField($this->count);
                        $doc->exportField($this->tsqm);
                        $doc->exportField($this->psqm);
                        $doc->exportField($this->pending_days);
                        $doc->exportField($this->design_size);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->plan_week);
                        $doc->exportField($this->dispatch_date);
                        $doc->exportField($this->loom_no);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->status);
                    } else {
                        $doc->exportField($this->works);
                        $doc->exportField($this->po);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->emp_name);
                        $doc->exportField($this->tqty);
                        $doc->exportField($this->count);
                        $doc->exportField($this->tsqm);
                        $doc->exportField($this->psqm);
                        $doc->exportField($this->pending_days);
                        $doc->exportField($this->design_size);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->plan_week);
                        $doc->exportField($this->dispatch_date);
                        $doc->exportField($this->loom_no);
                        $doc->exportField($this->operator);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->works, '');
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->jc_no, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->exportAggregate($this->emp_name, '');
                $doc->exportAggregate($this->tqty, 'TOTAL');
                $doc->exportAggregate($this->count, 'TOTAL');
                $doc->exportAggregate($this->tsqm, 'TOTAL');
                $doc->exportAggregate($this->psqm, 'TOTAL');
                $doc->exportAggregate($this->pending_days, 'AVERAGE');
                $doc->exportAggregate($this->design_size, '');
                $doc->exportAggregate($this->_barcode, '');
                $doc->exportAggregate($this->buyers_id, '');
                $doc->exportAggregate($this->plan_week, '');
                $doc->exportAggregate($this->dispatch_date, '');
                $doc->exportAggregate($this->loom_no, '');
                $doc->exportAggregate($this->operator, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
