<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class JobCardFAdd extends JobCardF
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "JobCardFAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "jobcardfadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->works->Visible = false;
        $this->grp->setVisibility();
        $this->po->Visible = false;
        $this->employee_id->setVisibility();
        $this->lot_no->Visible = false;
        $this->_1->setVisibility();
        $this->_2->setVisibility();
        $this->_3->setVisibility();
        $this->_4->setVisibility();
        $this->_5->setVisibility();
        $this->_6->setVisibility();
        $this->_7->setVisibility();
        $this->_8->setVisibility();
        $this->other1->setVisibility();
        $this->other2->setVisibility();
        $this->operator->setVisibility();
        $this->updated->Visible = false;
        $this->datetime->setVisibility();
        $this->jc_no->setVisibility();
        $this->s_grp->setVisibility();
        $this->item->setVisibility();
        $this->batch_no->setVisibility();
        $this->poid->setVisibility();
        $this->quantity->setVisibility();
        $this->pro_unit->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'job_card_f';
        $this->TableName = 'job_card_f';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (job_card_f)
        if (!isset($GLOBALS["job_card_f"]) || $GLOBALS["job_card_f"]::class == PROJECT_NAMESPACE . "job_card_f") {
            $GLOBALS["job_card_f"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_f');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "jobcardfview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->works);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("jobcardflist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "jobcardflist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "jobcardfview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "jobcardflist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "jobcardflist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->employee_id->DefaultValue = $this->employee_id->getDefault(); // PHP
        $this->employee_id->OldValue = $this->employee_id->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'employee_id' first before field var 'x_employee_id'
        $val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
        if (!$this->employee_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_id->setFormValue($val);
            }
        }

        // Check field name '1' first before field var 'x__1'
        $val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
        if (!$this->_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_1->Visible = false; // Disable update for API request
            } else {
                $this->_1->setFormValue($val);
            }
        }

        // Check field name '2' first before field var 'x__2'
        $val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
        if (!$this->_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2->Visible = false; // Disable update for API request
            } else {
                $this->_2->setFormValue($val);
            }
        }

        // Check field name '3' first before field var 'x__3'
        $val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
        if (!$this->_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_3->Visible = false; // Disable update for API request
            } else {
                $this->_3->setFormValue($val);
            }
        }

        // Check field name '4' first before field var 'x__4'
        $val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
        if (!$this->_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4->Visible = false; // Disable update for API request
            } else {
                $this->_4->setFormValue($val);
            }
        }

        // Check field name '5' first before field var 'x__5'
        $val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
        if (!$this->_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_5->Visible = false; // Disable update for API request
            } else {
                $this->_5->setFormValue($val);
            }
        }

        // Check field name '6' first before field var 'x__6'
        $val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
        if (!$this->_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_6->Visible = false; // Disable update for API request
            } else {
                $this->_6->setFormValue($val);
            }
        }

        // Check field name '7' first before field var 'x__7'
        $val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
        if (!$this->_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_7->Visible = false; // Disable update for API request
            } else {
                $this->_7->setFormValue($val);
            }
        }

        // Check field name '8' first before field var 'x__8'
        $val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
        if (!$this->_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_8->Visible = false; // Disable update for API request
            } else {
                $this->_8->setFormValue($val);
            }
        }

        // Check field name 'other1' first before field var 'x_other1'
        $val = $CurrentForm->hasValue("other1") ? $CurrentForm->getValue("other1") : $CurrentForm->getValue("x_other1");
        if (!$this->other1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other1->Visible = false; // Disable update for API request
            } else {
                $this->other1->setFormValue($val);
            }
        }

        // Check field name 'other2' first before field var 'x_other2'
        $val = $CurrentForm->hasValue("other2") ? $CurrentForm->getValue("other2") : $CurrentForm->getValue("x_other2");
        if (!$this->other2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other2->Visible = false; // Disable update for API request
            } else {
                $this->other2->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pro_unit' first before field var 'x_pro_unit'
        $val = $CurrentForm->hasValue("pro_unit") ? $CurrentForm->getValue("pro_unit") : $CurrentForm->getValue("x_pro_unit");
        if (!$this->pro_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pro_unit->Visible = false; // Disable update for API request
            } else {
                $this->pro_unit->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->employee_id->CurrentValue = $this->employee_id->FormValue;
        $this->_1->CurrentValue = $this->_1->FormValue;
        $this->_2->CurrentValue = $this->_2->FormValue;
        $this->_3->CurrentValue = $this->_3->FormValue;
        $this->_4->CurrentValue = $this->_4->FormValue;
        $this->_5->CurrentValue = $this->_5->FormValue;
        $this->_6->CurrentValue = $this->_6->FormValue;
        $this->_7->CurrentValue = $this->_7->FormValue;
        $this->_8->CurrentValue = $this->_8->FormValue;
        $this->other1->CurrentValue = $this->other1->FormValue;
        $this->other2->CurrentValue = $this->other2->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->item->CurrentValue = $this->item->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->pro_unit->CurrentValue = $this->pro_unit->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->works->setDbValue($row['works']);
        $this->grp->setDbValue($row['grp']);
        $this->po->setDbValue($row['po']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->other1->setDbValue($row['other1']);
        $this->other2->setDbValue($row['other2']);
        $this->operator->setDbValue($row['operator']);
        $this->updated->setDbValue($row['updated']);
        $this->datetime->setDbValue($row['datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->item->setDbValue($row['item']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->poid->setDbValue($row['poid']);
        $this->quantity->setDbValue($row['quantity']);
        $this->pro_unit->setDbValue($row['pro_unit']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['works'] = $this->works->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['other1'] = $this->other1->DefaultValue;
        $row['other2'] = $this->other2->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['pro_unit'] = $this->pro_unit->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // works
        $this->works->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // other1
        $this->other1->RowCssClass = "row";

        // other2
        $this->other2->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // pro_unit
        $this->pro_unit->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // works
            $curVal = strval($this->works->CurrentValue);
            if ($curVal != "") {
                $this->works->ViewValue = $this->works->lookupCacheOption($curVal);
                if ($this->works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->works->Lookup->renderViewRow($rswrk[0]);
                        $this->works->ViewValue = $this->works->displayValue($arwrk);
                    } else {
                        $this->works->ViewValue = FormatNumber($this->works->CurrentValue, $this->works->formatPattern());
                    }
                }
            } else {
                $this->works->ViewValue = null;
            }

            // grp
            if (strval($this->grp->CurrentValue) != "") {
                $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
            } else {
                $this->grp->ViewValue = null;
            }

            // employee_id
            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // other1
            $this->other1->ViewValue = $this->other1->CurrentValue;

            // other2
            $this->other2->ViewValue = $this->other2->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // s_grp
            $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
            $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pro_unit
            $this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;

            // grp
            $this->grp->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // 1
            $this->_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // other1
            $this->other1->HrefValue = "";

            // other2
            $this->other2->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // item
            $this->item->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // poid
            $this->poid->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // pro_unit
            $this->pro_unit->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->options(true);
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // employee_id
            $this->employee_id->setupEditAttributes();
            if (!$this->employee_id->Raw) {
                $this->employee_id->CurrentValue = HtmlDecode($this->employee_id->CurrentValue);
            }
            $this->employee_id->EditValue = HtmlEncode($this->employee_id->CurrentValue);
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // other1
            $this->other1->setupEditAttributes();
            if (!$this->other1->Raw) {
                $this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
            }
            $this->other1->EditValue = HtmlEncode($this->other1->CurrentValue);
            $this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

            // other2
            $this->other2->setupEditAttributes();
            if (!$this->other2->Raw) {
                $this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
            }
            $this->other2->EditValue = HtmlEncode($this->other2->CurrentValue);
            $this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

            // operator

            // datetime

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->CurrentValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
            if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
                $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
            }

            // s_grp
            $this->s_grp->setupEditAttributes();
            $this->s_grp->EditValue = $this->s_grp->CurrentValue;
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
            if (strval($this->s_grp->EditValue) != "" && is_numeric($this->s_grp->EditValue)) {
                $this->s_grp->EditValue = FormatNumber($this->s_grp->EditValue, null);
            }

            // item
            $this->item->setupEditAttributes();
            $this->item->EditValue = $this->item->CurrentValue;
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());
            if (strval($this->item->EditValue) != "" && is_numeric($this->item->EditValue)) {
                $this->item->EditValue = $this->item->EditValue;
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            if (!$this->batch_no->Raw) {
                $this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
            }
            $this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // poid
            $this->poid->setupEditAttributes();
            if (!$this->poid->Raw) {
                $this->poid->CurrentValue = HtmlDecode($this->poid->CurrentValue);
            }
            $this->poid->EditValue = HtmlEncode($this->poid->CurrentValue);
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // pro_unit
            $this->pro_unit->setupEditAttributes();
            if (!$this->pro_unit->Raw) {
                $this->pro_unit->CurrentValue = HtmlDecode($this->pro_unit->CurrentValue);
            }
            $this->pro_unit->EditValue = HtmlEncode($this->pro_unit->CurrentValue);
            $this->pro_unit->PlaceHolder = RemoveHtml($this->pro_unit->caption());

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // 1
            $this->_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // other1
            $this->other1->HrefValue = "";

            // other2
            $this->other2->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // item
            $this->item->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // poid
            $this->poid->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // pro_unit
            $this->pro_unit->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->employee_id->Visible && $this->employee_id->Required) {
                if (!$this->employee_id->IsDetailKey && EmptyValue($this->employee_id->FormValue)) {
                    $this->employee_id->addErrorMessage(str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
                }
            }
            if ($this->_1->Visible && $this->_1->Required) {
                if (!$this->_1->IsDetailKey && EmptyValue($this->_1->FormValue)) {
                    $this->_1->addErrorMessage(str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
                }
            }
            if ($this->_2->Visible && $this->_2->Required) {
                if (!$this->_2->IsDetailKey && EmptyValue($this->_2->FormValue)) {
                    $this->_2->addErrorMessage(str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
                }
            }
            if ($this->_3->Visible && $this->_3->Required) {
                if (!$this->_3->IsDetailKey && EmptyValue($this->_3->FormValue)) {
                    $this->_3->addErrorMessage(str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
                }
            }
            if ($this->_4->Visible && $this->_4->Required) {
                if (!$this->_4->IsDetailKey && EmptyValue($this->_4->FormValue)) {
                    $this->_4->addErrorMessage(str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
                }
            }
            if ($this->_5->Visible && $this->_5->Required) {
                if (!$this->_5->IsDetailKey && EmptyValue($this->_5->FormValue)) {
                    $this->_5->addErrorMessage(str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
                }
            }
            if ($this->_6->Visible && $this->_6->Required) {
                if (!$this->_6->IsDetailKey && EmptyValue($this->_6->FormValue)) {
                    $this->_6->addErrorMessage(str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
                }
            }
            if ($this->_7->Visible && $this->_7->Required) {
                if (!$this->_7->IsDetailKey && EmptyValue($this->_7->FormValue)) {
                    $this->_7->addErrorMessage(str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
                }
            }
            if ($this->_8->Visible && $this->_8->Required) {
                if (!$this->_8->IsDetailKey && EmptyValue($this->_8->FormValue)) {
                    $this->_8->addErrorMessage(str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
                }
            }
            if ($this->other1->Visible && $this->other1->Required) {
                if (!$this->other1->IsDetailKey && EmptyValue($this->other1->FormValue)) {
                    $this->other1->addErrorMessage(str_replace("%s", $this->other1->caption(), $this->other1->RequiredErrorMessage));
                }
            }
            if ($this->other2->Visible && $this->other2->Required) {
                if (!$this->other2->IsDetailKey && EmptyValue($this->other2->FormValue)) {
                    $this->other2->addErrorMessage(str_replace("%s", $this->other2->caption(), $this->other2->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_no->FormValue)) {
                $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->s_grp->FormValue)) {
                $this->s_grp->addErrorMessage($this->s_grp->getErrorMessage(false));
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->poid->Visible && $this->poid->Required) {
                if (!$this->poid->IsDetailKey && EmptyValue($this->poid->FormValue)) {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->pro_unit->Visible && $this->pro_unit->Required) {
                if (!$this->pro_unit->IsDetailKey && EmptyValue($this->pro_unit->FormValue)) {
                    $this->pro_unit->addErrorMessage(str_replace("%s", $this->pro_unit->caption(), $this->pro_unit->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // employee_id
        $this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, false);

        // 1
        $this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, false);

        // 2
        $this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, false);

        // 3
        $this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, false);

        // 4
        $this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, false);

        // 5
        $this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, false);

        // 6
        $this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, false);

        // 7
        $this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, false);

        // 8
        $this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, false);

        // other1
        $this->other1->setDbValueDef($rsnew, $this->other1->CurrentValue, false);

        // other2
        $this->other2->setDbValueDef($rsnew, $this->other2->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // item
        $this->item->setDbValueDef($rsnew, $this->item->CurrentValue, false);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // poid
        $this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // pro_unit
        $this->pro_unit->setDbValueDef($rsnew, $this->pro_unit->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['employee_id'])) { // employee_id
            $this->employee_id->setFormValue($row['employee_id']);
        }
        if (isset($row['1'])) { // 1
            $this->_1->setFormValue($row['1']);
        }
        if (isset($row['2'])) { // 2
            $this->_2->setFormValue($row['2']);
        }
        if (isset($row['3'])) { // 3
            $this->_3->setFormValue($row['3']);
        }
        if (isset($row['4'])) { // 4
            $this->_4->setFormValue($row['4']);
        }
        if (isset($row['5'])) { // 5
            $this->_5->setFormValue($row['5']);
        }
        if (isset($row['6'])) { // 6
            $this->_6->setFormValue($row['6']);
        }
        if (isset($row['7'])) { // 7
            $this->_7->setFormValue($row['7']);
        }
        if (isset($row['8'])) { // 8
            $this->_8->setFormValue($row['8']);
        }
        if (isset($row['other1'])) { // other1
            $this->other1->setFormValue($row['other1']);
        }
        if (isset($row['other2'])) { // other2
            $this->other2->setFormValue($row['other2']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->setFormValue($row['jc_no']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['item'])) { // item
            $this->item->setFormValue($row['item']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['poid'])) { // poid
            $this->poid->setFormValue($row['poid']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['pro_unit'])) { // pro_unit
            $this->pro_unit->setFormValue($row['pro_unit']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("jobcardflist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    		$this->grp->ReadOnly = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
