<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class JobCardEdit extends JobCard
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "JobCardEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "jobcardedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->jc_no->Visible = false;
        $this->company_id->setVisibility();
        $this->buyer_id->setVisibility();
        $this->works->setVisibility();
        $this->issue_to_internal->setVisibility();
        $this->issue_to_external->setVisibility();
        $this->issue_to->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->packing_type->setVisibility();
        $this->product_code->setVisibility();
        $this->item->setVisibility();
        $this->poid->setVisibility();
        $this->po->Visible = false;
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->lot_no->Visible = false;
        $this->pro_unit->setVisibility();
        $this->employee_id->setVisibility();
        $this->_1->setVisibility();
        $this->_2->setVisibility();
        $this->_3->setVisibility();
        $this->_4->setVisibility();
        $this->_5->setVisibility();
        $this->_6->setVisibility();
        $this->_7->setVisibility();
        $this->_8->setVisibility();
        $this->other1->setVisibility();
        $this->other2->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
        $this->in_id->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->product->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'job_card';
        $this->TableName = 'job_card';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (job_card)
        if (!isset($GLOBALS["job_card"]) || $GLOBALS["job_card"]::class == PROJECT_NAMESPACE . "job_card") {
            $GLOBALS["job_card"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "jobcardview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->works);
        $this->setupLookupOptions($this->issue_to_internal);
        $this->setupLookupOptions($this->issue_to_external);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code);
        $this->setupLookupOptions($this->item);
        $this->setupLookupOptions($this->poid);
        $this->setupLookupOptions($this->po);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->pro_unit);
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("jobcardlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "jobcardlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "jobcardlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "jobcardlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }

        // Check field name 'works' first before field var 'x_works'
        $val = $CurrentForm->hasValue("works") ? $CurrentForm->getValue("works") : $CurrentForm->getValue("x_works");
        if (!$this->works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->works->Visible = false; // Disable update for API request
            } else {
                $this->works->setFormValue($val);
            }
        }

        // Check field name 'issue_to_internal' first before field var 'x_issue_to_internal'
        $val = $CurrentForm->hasValue("issue_to_internal") ? $CurrentForm->getValue("issue_to_internal") : $CurrentForm->getValue("x_issue_to_internal");
        if (!$this->issue_to_internal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to_internal->Visible = false; // Disable update for API request
            } else {
                $this->issue_to_internal->setFormValue($val);
            }
        }

        // Check field name 'issue_to_external' first before field var 'x_issue_to_external'
        $val = $CurrentForm->hasValue("issue_to_external") ? $CurrentForm->getValue("issue_to_external") : $CurrentForm->getValue("x_issue_to_external");
        if (!$this->issue_to_external->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to_external->Visible = false; // Disable update for API request
            } else {
                $this->issue_to_external->setFormValue($val);
            }
        }

        // Check field name 'issue_to' first before field var 'x_issue_to'
        $val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
        if (!$this->issue_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to->Visible = false; // Disable update for API request
            } else {
                $this->issue_to->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code->Visible = false; // Disable update for API request
            } else {
                $this->product_code->setFormValue($val);
            }
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pro_unit' first before field var 'x_pro_unit'
        $val = $CurrentForm->hasValue("pro_unit") ? $CurrentForm->getValue("pro_unit") : $CurrentForm->getValue("x_pro_unit");
        if (!$this->pro_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pro_unit->Visible = false; // Disable update for API request
            } else {
                $this->pro_unit->setFormValue($val);
            }
        }

        // Check field name 'employee_id' first before field var 'x_employee_id'
        $val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
        if (!$this->employee_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_id->setFormValue($val);
            }
        }

        // Check field name '1' first before field var 'x__1'
        $val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
        if (!$this->_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_1->Visible = false; // Disable update for API request
            } else {
                $this->_1->setFormValue($val);
            }
        }

        // Check field name '2' first before field var 'x__2'
        $val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
        if (!$this->_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2->Visible = false; // Disable update for API request
            } else {
                $this->_2->setFormValue($val);
            }
        }

        // Check field name '3' first before field var 'x__3'
        $val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
        if (!$this->_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_3->Visible = false; // Disable update for API request
            } else {
                $this->_3->setFormValue($val);
            }
        }

        // Check field name '4' first before field var 'x__4'
        $val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
        if (!$this->_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4->Visible = false; // Disable update for API request
            } else {
                $this->_4->setFormValue($val);
            }
        }

        // Check field name '5' first before field var 'x__5'
        $val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
        if (!$this->_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_5->Visible = false; // Disable update for API request
            } else {
                $this->_5->setFormValue($val);
            }
        }

        // Check field name '6' first before field var 'x__6'
        $val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
        if (!$this->_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_6->Visible = false; // Disable update for API request
            } else {
                $this->_6->setFormValue($val);
            }
        }

        // Check field name '7' first before field var 'x__7'
        $val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
        if (!$this->_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_7->Visible = false; // Disable update for API request
            } else {
                $this->_7->setFormValue($val);
            }
        }

        // Check field name '8' first before field var 'x__8'
        $val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
        if (!$this->_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_8->Visible = false; // Disable update for API request
            } else {
                $this->_8->setFormValue($val);
            }
        }

        // Check field name 'other1' first before field var 'x_other1'
        $val = $CurrentForm->hasValue("other1") ? $CurrentForm->getValue("other1") : $CurrentForm->getValue("x_other1");
        if (!$this->other1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other1->Visible = false; // Disable update for API request
            } else {
                $this->other1->setFormValue($val);
            }
        }

        // Check field name 'other2' first before field var 'x_other2'
        $val = $CurrentForm->hasValue("other2") ? $CurrentForm->getValue("other2") : $CurrentForm->getValue("x_other2");
        if (!$this->other2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other2->Visible = false; // Disable update for API request
            } else {
                $this->other2->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->works->CurrentValue = $this->works->FormValue;
        $this->issue_to_internal->CurrentValue = $this->issue_to_internal->FormValue;
        $this->issue_to_external->CurrentValue = $this->issue_to_external->FormValue;
        $this->issue_to->CurrentValue = $this->issue_to->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->product_code->CurrentValue = $this->product_code->FormValue;
        $this->item->CurrentValue = $this->item->FormValue;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->pro_unit->CurrentValue = $this->pro_unit->FormValue;
        $this->employee_id->CurrentValue = $this->employee_id->FormValue;
        $this->_1->CurrentValue = $this->_1->FormValue;
        $this->_2->CurrentValue = $this->_2->FormValue;
        $this->_3->CurrentValue = $this->_3->FormValue;
        $this->_4->CurrentValue = $this->_4->FormValue;
        $this->_5->CurrentValue = $this->_5->FormValue;
        $this->_6->CurrentValue = $this->_6->FormValue;
        $this->_7->CurrentValue = $this->_7->FormValue;
        $this->_8->CurrentValue = $this->_8->FormValue;
        $this->other1->CurrentValue = $this->other1->FormValue;
        $this->other2->CurrentValue = $this->other2->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->company_id->setDbValue($row['company_id']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->works->setDbValue($row['works']);
        $this->issue_to_internal->setDbValue($row['issue_to_internal']);
        $this->issue_to_external->setDbValue($row['issue_to_external']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->item->setDbValue($row['item']);
        if (array_key_exists('EV__item', $row)) {
            $this->item->VirtualValue = $row['EV__item']; // Set up virtual field value
        } else {
            $this->item->VirtualValue = ""; // Clear value
        }
        $this->poid->setDbValue($row['poid']);
        $this->po->setDbValue($row['po']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->pro_unit->setDbValue($row['pro_unit']);
        $this->employee_id->setDbValue($row['employee_id']);
        if (array_key_exists('EV__employee_id', $row)) {
            $this->employee_id->VirtualValue = $row['EV__employee_id']; // Set up virtual field value
        } else {
            $this->employee_id->VirtualValue = ""; // Clear value
        }
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->other1->setDbValue($row['other1']);
        $this->other2->setDbValue($row['other2']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->in_id->setDbValue($row['in_id']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->product->setDbValue($row['product']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['works'] = $this->works->DefaultValue;
        $row['issue_to_internal'] = $this->issue_to_internal->DefaultValue;
        $row['issue_to_external'] = $this->issue_to_external->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['pro_unit'] = $this->pro_unit->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['other1'] = $this->other1->DefaultValue;
        $row['other2'] = $this->other2->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['in_id'] = $this->in_id->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // works
        $this->works->RowCssClass = "row";

        // issue_to_internal
        $this->issue_to_internal->RowCssClass = "row";

        // issue_to_external
        $this->issue_to_external->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // pro_unit
        $this->pro_unit->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // other1
        $this->other1->RowCssClass = "row";

        // other2
        $this->other2->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // in_id
        $this->in_id->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // works
            if (strval($this->works->CurrentValue) != "") {
                $this->works->ViewValue = $this->works->optionCaption($this->works->CurrentValue);
            } else {
                $this->works->ViewValue = null;
            }

            // issue_to_internal
            $curVal = strval($this->issue_to_internal->CurrentValue);
            if ($curVal != "") {
                $this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
                if ($this->issue_to_internal->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to_internal->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to_internal->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to_internal->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to_internal->ViewValue = $this->issue_to_internal->displayValue($arwrk);
                    } else {
                        $this->issue_to_internal->ViewValue = FormatNumber($this->issue_to_internal->CurrentValue, $this->issue_to_internal->formatPattern());
                    }
                }
            } else {
                $this->issue_to_internal->ViewValue = null;
            }

            // issue_to_external
            $curVal = strval($this->issue_to_external->CurrentValue);
            if ($curVal != "") {
                $this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
                if ($this->issue_to_external->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to_external->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_external->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to_external->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to_external->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to_external->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to_external->ViewValue = $this->issue_to_external->displayValue($arwrk);
                    } else {
                        $this->issue_to_external->ViewValue = FormatNumber($this->issue_to_external->CurrentValue, $this->issue_to_external->formatPattern());
                    }
                }
            } else {
                $this->issue_to_external->ViewValue = null;
            }

            // issue_to
            $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->ViewValue = FormatNumber($this->issue_to->CurrentValue, $this->issue_to->formatPattern());
                    }
                }
            } else {
                $this->issue_to->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_code
            $curVal = strval($this->product_code->CurrentValue);
            if ($curVal != "") {
                $this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
                if ($this->product_code->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_code->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_code->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_code->Lookup->renderViewRow($rswrk[0]);
                        $this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
                    } else {
                        $this->product_code->ViewValue = $this->product_code->CurrentValue;
                    }
                }
            } else {
                $this->product_code->ViewValue = null;
            }

            // item
            if ($this->item->VirtualValue != "") {
                $this->item->ViewValue = $this->item->VirtualValue;
            } else {
                $this->item->ViewValue = $this->item->CurrentValue;
                $curVal = strval($this->item->CurrentValue);
                if ($curVal != "") {
                    $this->item->ViewValue = $this->item->lookupCacheOption($curVal);
                    if ($this->item->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->item->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->item->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->item->Lookup->renderViewRow($rswrk[0]);
                            $this->item->ViewValue = $this->item->displayValue($arwrk);
                        } else {
                            $this->item->ViewValue = $this->item->CurrentValue;
                        }
                    }
                } else {
                    $this->item->ViewValue = null;
                }
            }

            // poid
            $curVal = strval($this->poid->CurrentValue);
            if ($curVal != "") {
                $this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
                if ($this->poid->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->poid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->poid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->poid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->poid->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->poid->Lookup->renderViewRow($row);
                            $this->poid->ViewValue->add($this->poid->displayValue($arwrk));
                        }
                    } else {
                        $this->poid->ViewValue = $this->poid->CurrentValue;
                    }
                }
            } else {
                $this->poid->ViewValue = null;
            }

            // po
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->po->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->po->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->po->Lookup->renderViewRow($row);
                            $this->po->ViewValue->add($this->po->displayValue($arwrk));
                        }
                    } else {
                        $this->po->ViewValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->ViewValue = null;
            }
            $this->po->CellCssStyle .= "text-align: left;";

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pro_unit
            $curVal = strval($this->pro_unit->CurrentValue);
            if ($curVal != "") {
                $this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
                if ($this->pro_unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pro_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pro_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pro_unit->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pro_unit->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pro_unit->Lookup->renderViewRow($rswrk[0]);
                        $this->pro_unit->ViewValue = $this->pro_unit->displayValue($arwrk);
                    } else {
                        $this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;
                    }
                }
            } else {
                $this->pro_unit->ViewValue = null;
            }

            // employee_id
            if ($this->employee_id->VirtualValue != "") {
                $this->employee_id->ViewValue = $this->employee_id->VirtualValue;
            } else {
                $curVal = strval($this->employee_id->CurrentValue);
                if ($curVal != "") {
                    $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                    if ($this->employee_id->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->employee_id->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                                $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                            }
                        } else {
                            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                        }
                    }
                } else {
                    $this->employee_id->ViewValue = null;
                }
            }

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // other1
            $this->other1->ViewValue = $this->other1->CurrentValue;

            // other2
            $this->other2->ViewValue = $this->other2->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // works
            if (!EmptyValue($this->works->CurrentValue)) {
                $this->works->HrefValue = $this->works->getLinkPrefix() . $this->works->CurrentValue; // Add prefix/suffix
                $this->works->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->works->HrefValue = FullUrl($this->works->HrefValue, "href");
                }
            } else {
                $this->works->HrefValue = "";
            }

            // issue_to_internal
            $this->issue_to_internal->HrefValue = "";

            // issue_to_external
            $this->issue_to_external->HrefValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // packing_type
            $this->packing_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }

            // poid
            if (!EmptyValue($this->poid->CurrentValue)) {
                $this->poid->HrefValue = $this->poid->getLinkPrefix() . $this->poid->CurrentValue; // Add prefix/suffix
                $this->poid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
                }
            } else {
                $this->poid->HrefValue = "";
            }

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }

            // quantity
            if (!EmptyValue($this->quantity->CurrentValue)) {
                $this->quantity->HrefValue = $this->quantity->getLinkPrefix() . $this->quantity->CurrentValue; // Add prefix/suffix
                $this->quantity->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
                }
            } else {
                $this->quantity->HrefValue = "";
            }

            // pro_unit
            $this->pro_unit->HrefValue = "";

            // employee_id
            if (!EmptyValue($this->employee_id->CurrentValue)) {
                $this->employee_id->HrefValue = $this->employee_id->getLinkPrefix() . $this->employee_id->CurrentValue; // Add prefix/suffix
                $this->employee_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
                }
            } else {
                $this->employee_id->HrefValue = "";
            }

            // 1
            $this->_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // other1
            $this->other1->HrefValue = "";

            // other2
            $this->other2->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // buyer_id
            $curVal = trim(strval($this->buyer_id->CurrentValue));
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
                if ($this->buyer_id->ViewValue == "") {
                    $this->buyer_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->CurrentValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // works
            $this->works->setupEditAttributes();
            $this->works->EditValue = $this->works->options(true);
            $this->works->PlaceHolder = RemoveHtml($this->works->caption());

            // issue_to_internal
            $this->issue_to_internal->setupEditAttributes();
            $curVal = trim(strval($this->issue_to_internal->CurrentValue));
            if ($curVal != "") {
                $this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
            } else {
                $this->issue_to_internal->ViewValue = $this->issue_to_internal->Lookup !== null && is_array($this->issue_to_internal->lookupOptions()) && count($this->issue_to_internal->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to_internal->ViewValue !== null) { // Load from cache
                $this->issue_to_internal->EditValue = array_values($this->issue_to_internal->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to_internal->CurrentValue, $this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to_internal->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_internal->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to_internal->EditValue = $arwrk;
            }
            $this->issue_to_internal->PlaceHolder = RemoveHtml($this->issue_to_internal->caption());

            // issue_to_external
            $this->issue_to_external->setupEditAttributes();
            $curVal = trim(strval($this->issue_to_external->CurrentValue));
            if ($curVal != "") {
                $this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
            } else {
                $this->issue_to_external->ViewValue = $this->issue_to_external->Lookup !== null && is_array($this->issue_to_external->lookupOptions()) && count($this->issue_to_external->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to_external->ViewValue !== null) { // Load from cache
                $this->issue_to_external->EditValue = array_values($this->issue_to_external->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to_external->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to_external->CurrentValue, $this->issue_to_external->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to_external->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_external->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to_external->EditValue = $arwrk;
            }
            $this->issue_to_external->PlaceHolder = RemoveHtml($this->issue_to_external->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $this->issue_to->EditCustomAttributes = $this->issue_to->getEditCustomAttributes(); // PHP
            $this->issue_to->EditValue = $this->issue_to->CurrentValue;
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->EditValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->EditValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->EditValue = HtmlEncode(FormatNumber($this->issue_to->CurrentValue, $this->issue_to->formatPattern()));
                    }
                }
            } else {
                $this->issue_to->EditValue = null;
            }
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // product_code
            $curVal = trim(strval($this->product_code->CurrentValue));
            if ($curVal != "") {
                $this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
            } else {
                $this->product_code->ViewValue = $this->product_code->Lookup !== null && is_array($this->product_code->lookupOptions()) && count($this->product_code->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_code->ViewValue !== null) { // Load from cache
                $this->product_code->EditValue = array_values($this->product_code->lookupOptions());
                if ($this->product_code->ViewValue == "") {
                    $this->product_code->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_code->CurrentValue, $this->product_code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_code->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_code->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_code->Lookup->renderViewRow($rswrk[0]);
                    $this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
                } else {
                    $this->product_code->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->product_code->Lookup->renderViewRow($row);
                }
                $this->product_code->EditValue = $arwrk;
            }
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // item
            $this->item->setupEditAttributes();
            $this->item->EditCustomAttributes = $this->item->getEditCustomAttributes(); // PHP
            $this->item->EditValue = $this->item->CurrentValue;
            $curVal = strval($this->item->CurrentValue);
            if ($curVal != "") {
                $this->item->EditValue = $this->item->lookupCacheOption($curVal);
                if ($this->item->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->item->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->item->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->item->Lookup->renderViewRow($rswrk[0]);
                        $this->item->EditValue = $this->item->displayValue($arwrk);
                    } else {
                        $this->item->EditValue = HtmlEncode($this->item->CurrentValue);
                    }
                }
            } else {
                $this->item->EditValue = null;
            }
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // poid
            $curVal = trim(strval($this->poid->CurrentValue));
            if ($curVal != "") {
                $this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
            } else {
                $this->poid->ViewValue = $this->poid->Lookup !== null && is_array($this->poid->lookupOptions()) && count($this->poid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->poid->ViewValue !== null) { // Load from cache
                $this->poid->EditValue = array_values($this->poid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->poid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->poid->getSelectFilter($this); // PHP
                $sqlWrk = $this->poid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->poid->Lookup->renderViewRow($row);
                }
                $this->poid->EditValue = $arwrk;
            }
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->ViewValue == "") {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // pro_unit
            $this->pro_unit->setupEditAttributes();
            $curVal = trim(strval($this->pro_unit->CurrentValue));
            if ($curVal != "") {
                $this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
            } else {
                $this->pro_unit->ViewValue = $this->pro_unit->Lookup !== null && is_array($this->pro_unit->lookupOptions()) && count($this->pro_unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pro_unit->ViewValue !== null) { // Load from cache
                $this->pro_unit->EditValue = array_values($this->pro_unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pro_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pro_unit->CurrentValue, $this->pro_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pro_unit->getSelectFilter($this); // PHP
                $sqlWrk = $this->pro_unit->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pro_unit->EditValue = $arwrk;
            }
            $this->pro_unit->PlaceHolder = RemoveHtml($this->pro_unit->caption());

            // employee_id
            $curVal = trim(strval($this->employee_id->CurrentValue));
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
            } else {
                $this->employee_id->ViewValue = $this->employee_id->Lookup !== null && is_array($this->employee_id->lookupOptions()) && count($this->employee_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_id->ViewValue !== null) { // Load from cache
                $this->employee_id->EditValue = array_values($this->employee_id->lookupOptions());
                if ($this->employee_id->ViewValue == "") {
                    $this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->employee_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->employee_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                        $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_id->Lookup->renderViewRow($row);
                }
                $this->employee_id->EditValue = $arwrk;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // other1
            $this->other1->setupEditAttributes();
            if (!$this->other1->Raw) {
                $this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
            }
            $this->other1->EditValue = HtmlEncode($this->other1->CurrentValue);
            $this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

            // other2
            $this->other2->setupEditAttributes();
            if (!$this->other2->Raw) {
                $this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
            }
            $this->other2->EditValue = HtmlEncode($this->other2->CurrentValue);
            $this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // works
            if (!EmptyValue($this->works->CurrentValue)) {
                $this->works->HrefValue = $this->works->getLinkPrefix() . $this->works->CurrentValue; // Add prefix/suffix
                $this->works->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->works->HrefValue = FullUrl($this->works->HrefValue, "href");
                }
            } else {
                $this->works->HrefValue = "";
            }

            // issue_to_internal
            $this->issue_to_internal->HrefValue = "";

            // issue_to_external
            $this->issue_to_external->HrefValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // packing_type
            $this->packing_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }

            // poid
            if (!EmptyValue($this->poid->CurrentValue)) {
                $this->poid->HrefValue = $this->poid->getLinkPrefix() . $this->poid->CurrentValue; // Add prefix/suffix
                $this->poid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
                }
            } else {
                $this->poid->HrefValue = "";
            }

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }

            // quantity
            if (!EmptyValue($this->quantity->CurrentValue)) {
                $this->quantity->HrefValue = $this->quantity->getLinkPrefix() . $this->quantity->CurrentValue; // Add prefix/suffix
                $this->quantity->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
                }
            } else {
                $this->quantity->HrefValue = "";
            }

            // pro_unit
            $this->pro_unit->HrefValue = "";

            // employee_id
            if (!EmptyValue($this->employee_id->CurrentValue)) {
                $this->employee_id->HrefValue = $this->employee_id->getLinkPrefix() . $this->employee_id->CurrentValue; // Add prefix/suffix
                $this->employee_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
                }
            } else {
                $this->employee_id->HrefValue = "";
            }

            // 1
            $this->_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // other1
            $this->other1->HrefValue = "";

            // other2
            $this->other2->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->works->Visible && $this->works->Required) {
                if (!$this->works->IsDetailKey && EmptyValue($this->works->FormValue)) {
                    $this->works->addErrorMessage(str_replace("%s", $this->works->caption(), $this->works->RequiredErrorMessage));
                }
            }
            if ($this->issue_to_internal->Visible && $this->issue_to_internal->Required) {
                if (!$this->issue_to_internal->IsDetailKey && EmptyValue($this->issue_to_internal->FormValue)) {
                    $this->issue_to_internal->addErrorMessage(str_replace("%s", $this->issue_to_internal->caption(), $this->issue_to_internal->RequiredErrorMessage));
                }
            }
            if ($this->issue_to_external->Visible && $this->issue_to_external->Required) {
                if (!$this->issue_to_external->IsDetailKey && EmptyValue($this->issue_to_external->FormValue)) {
                    $this->issue_to_external->addErrorMessage(str_replace("%s", $this->issue_to_external->caption(), $this->issue_to_external->RequiredErrorMessage));
                }
            }
            if ($this->issue_to->Visible && $this->issue_to->Required) {
                if (!$this->issue_to->IsDetailKey && EmptyValue($this->issue_to->FormValue)) {
                    $this->issue_to->addErrorMessage(str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->issue_to->FormValue)) {
                $this->issue_to->addErrorMessage($this->issue_to->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->poid->Visible && $this->poid->Required) {
                if ($this->poid->FormValue == "") {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->pro_unit->Visible && $this->pro_unit->Required) {
                if (!$this->pro_unit->IsDetailKey && EmptyValue($this->pro_unit->FormValue)) {
                    $this->pro_unit->addErrorMessage(str_replace("%s", $this->pro_unit->caption(), $this->pro_unit->RequiredErrorMessage));
                }
            }
            if ($this->employee_id->Visible && $this->employee_id->Required) {
                if ($this->employee_id->FormValue == "") {
                    $this->employee_id->addErrorMessage(str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
                }
            }
            if ($this->_1->Visible && $this->_1->Required) {
                if (!$this->_1->IsDetailKey && EmptyValue($this->_1->FormValue)) {
                    $this->_1->addErrorMessage(str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
                }
            }
            if ($this->_2->Visible && $this->_2->Required) {
                if (!$this->_2->IsDetailKey && EmptyValue($this->_2->FormValue)) {
                    $this->_2->addErrorMessage(str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
                }
            }
            if ($this->_3->Visible && $this->_3->Required) {
                if (!$this->_3->IsDetailKey && EmptyValue($this->_3->FormValue)) {
                    $this->_3->addErrorMessage(str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
                }
            }
            if ($this->_4->Visible && $this->_4->Required) {
                if (!$this->_4->IsDetailKey && EmptyValue($this->_4->FormValue)) {
                    $this->_4->addErrorMessage(str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
                }
            }
            if ($this->_5->Visible && $this->_5->Required) {
                if (!$this->_5->IsDetailKey && EmptyValue($this->_5->FormValue)) {
                    $this->_5->addErrorMessage(str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
                }
            }
            if ($this->_6->Visible && $this->_6->Required) {
                if (!$this->_6->IsDetailKey && EmptyValue($this->_6->FormValue)) {
                    $this->_6->addErrorMessage(str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
                }
            }
            if ($this->_7->Visible && $this->_7->Required) {
                if (!$this->_7->IsDetailKey && EmptyValue($this->_7->FormValue)) {
                    $this->_7->addErrorMessage(str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
                }
            }
            if ($this->_8->Visible && $this->_8->Required) {
                if (!$this->_8->IsDetailKey && EmptyValue($this->_8->FormValue)) {
                    $this->_8->addErrorMessage(str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
                }
            }
            if ($this->other1->Visible && $this->other1->Required) {
                if (!$this->other1->IsDetailKey && EmptyValue($this->other1->FormValue)) {
                    $this->other1->addErrorMessage(str_replace("%s", $this->other1->caption(), $this->other1->RequiredErrorMessage));
                }
            }
            if ($this->other2->Visible && $this->other2->Required) {
                if (!$this->other2->IsDetailKey && EmptyValue($this->other2->FormValue)) {
                    $this->other2->addErrorMessage(str_replace("%s", $this->other2->caption(), $this->other2->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, $this->buyer_id->ReadOnly);

        // works
        $this->works->setDbValueDef($rsnew, $this->works->CurrentValue, $this->works->ReadOnly);

        // issue_to_internal
        $this->issue_to_internal->setDbValueDef($rsnew, $this->issue_to_internal->CurrentValue, $this->issue_to_internal->ReadOnly);

        // issue_to_external
        $this->issue_to_external->setDbValueDef($rsnew, $this->issue_to_external->CurrentValue, $this->issue_to_external->ReadOnly);

        // issue_to
        $this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, $this->issue_to->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // product_code
        $this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, $this->product_code->ReadOnly);

        // item
        $this->item->setDbValueDef($rsnew, $this->item->CurrentValue, $this->item->ReadOnly);

        // poid
        $this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, $this->poid->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, $this->quantity->ReadOnly);

        // pro_unit
        $this->pro_unit->setDbValueDef($rsnew, $this->pro_unit->CurrentValue, $this->pro_unit->ReadOnly);

        // employee_id
        $this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, $this->employee_id->ReadOnly);

        // 1
        $this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, $this->_1->ReadOnly);

        // 2
        $this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, $this->_2->ReadOnly);

        // 3
        $this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, $this->_3->ReadOnly);

        // 4
        $this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, $this->_4->ReadOnly);

        // 5
        $this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, $this->_5->ReadOnly);

        // 6
        $this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, $this->_6->ReadOnly);

        // 7
        $this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, $this->_7->ReadOnly);

        // 8
        $this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, $this->_8->ReadOnly);

        // other1
        $this->other1->setDbValueDef($rsnew, $this->other1->CurrentValue, $this->other1->ReadOnly);

        // other2
        $this->other2->setDbValueDef($rsnew, $this->other2->CurrentValue, $this->other2->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->CurrentValue = $row['buyer_id'];
        }
        if (isset($row['works'])) { // works
            $this->works->CurrentValue = $row['works'];
        }
        if (isset($row['issue_to_internal'])) { // issue_to_internal
            $this->issue_to_internal->CurrentValue = $row['issue_to_internal'];
        }
        if (isset($row['issue_to_external'])) { // issue_to_external
            $this->issue_to_external->CurrentValue = $row['issue_to_external'];
        }
        if (isset($row['issue_to'])) { // issue_to
            $this->issue_to->CurrentValue = $row['issue_to'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['product_code'])) { // product_code
            $this->product_code->CurrentValue = $row['product_code'];
        }
        if (isset($row['item'])) { // item
            $this->item->CurrentValue = $row['item'];
        }
        if (isset($row['poid'])) { // poid
            $this->poid->CurrentValue = $row['poid'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->CurrentValue = $row['quantity'];
        }
        if (isset($row['pro_unit'])) { // pro_unit
            $this->pro_unit->CurrentValue = $row['pro_unit'];
        }
        if (isset($row['employee_id'])) { // employee_id
            $this->employee_id->CurrentValue = $row['employee_id'];
        }
        if (isset($row['1'])) { // 1
            $this->_1->CurrentValue = $row['1'];
        }
        if (isset($row['2'])) { // 2
            $this->_2->CurrentValue = $row['2'];
        }
        if (isset($row['3'])) { // 3
            $this->_3->CurrentValue = $row['3'];
        }
        if (isset($row['4'])) { // 4
            $this->_4->CurrentValue = $row['4'];
        }
        if (isset($row['5'])) { // 5
            $this->_5->CurrentValue = $row['5'];
        }
        if (isset($row['6'])) { // 6
            $this->_6->CurrentValue = $row['6'];
        }
        if (isset($row['7'])) { // 7
            $this->_7->CurrentValue = $row['7'];
        }
        if (isset($row['8'])) { // 8
            $this->_8->CurrentValue = $row['8'];
        }
        if (isset($row['other1'])) { // other1
            $this->other1->CurrentValue = $row['other1'];
        }
        if (isset($row['other2'])) { // other2
            $this->other2->CurrentValue = $row['other2'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("jobcardlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to_internal":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to_external":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_item":
                    break;
                case "x_poid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pro_unit":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_id":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'job_card');
    	if ($this->PageID == "add" || $this->PageID == "edit")
    	{
    		$this->item->ReadOnly = true;
    	}	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        extract($_POST,EXTR_OVERWRITE);
        $_SESSION[SESSION_WARNING_MESSAGE] == '';
        IF  (($x_works == '1') && ( ($x_issue_to == null) || ($x_issue_to == '0') || ($x_issue_to = '') )  )
        {
        $_SESSION[SESSION_WARNING_MESSAGE].= 'Select Issued To is Mandatory for Processing Outside<BR>';
        }
        $batch= ExecuteScalar("SELECT `pd_byepass` FROM `portal_setup` Limit 1");
    	if  ( ($batch < 2) && ($x_batch_no == null))
    	{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Batch No.<br>";
    	}	
        if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    	    {return TRUE;}
    	else
    		{return false;}
    }
}
