<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class JobCardBcOldSearch extends JobCardBcOld
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "JobCardBcOldSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "jobcardbcoldsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->Visible = false;
        $this->po->setVisibility();
        $this->no->setVisibility();
        $this->works->setVisibility();
        $this->issue_to->setVisibility();
        $this->design_size->Visible = false;
        $this->size_wl->Visible = false;
        $this->loom_no->setVisibility();
        $this->employee_1->Visible = false;
        $this->employee_2->Visible = false;
        $this->employee_3->Visible = false;
        $this->employee_id->setVisibility();
        $this->_barcode->setVisibility();
        $this->lot_no->Visible = false;
        $this->deduction->setVisibility();
        $this->ded_remarks->setVisibility();
        $this->datetime->setVisibility();
        $this->operator->setVisibility();
        $this->updated->Visible = false;
        $this->other1->setVisibility();
        $this->other2->setVisibility();
        $this->_1->setVisibility();
        $this->_2->setVisibility();
        $this->_3->setVisibility();
        $this->_4->setVisibility();
        $this->_5->setVisibility();
        $this->_6->setVisibility();
        $this->_7->setVisibility();
        $this->_8->setVisibility();
        $this->r_date->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'job_card_bc_old';
        $this->TableName = 'job_card_bc_old';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (job_card_bc_old)
        if (!isset($GLOBALS["job_card_bc_old"]) || $GLOBALS["job_card_bc_old"]::class == PROJECT_NAMESPACE . "job_card_bc_old") {
            $GLOBALS["job_card_bc_old"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_bc_old');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "jobcardbcoldview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->po);
        $this->setupLookupOptions($this->works);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->design_size);
        $this->setupLookupOptions($this->loom_no);
        $this->setupLookupOptions($this->employee_1);
        $this->setupLookupOptions($this->employee_2);
        $this->setupLookupOptions($this->employee_3);
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->_barcode);
        $this->setupLookupOptions($this->lot_no);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "jobcardbcoldlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->no); // no
        $this->buildSearchUrl($srchUrl, $this->works); // works
        $this->buildSearchUrl($srchUrl, $this->issue_to); // issue_to
        $this->buildSearchUrl($srchUrl, $this->loom_no); // loom_no
        $this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->deduction); // deduction
        $this->buildSearchUrl($srchUrl, $this->ded_remarks); // ded_remarks
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->other1); // other1
        $this->buildSearchUrl($srchUrl, $this->other2); // other2
        $this->buildSearchUrl($srchUrl, $this->_1); // 1
        $this->buildSearchUrl($srchUrl, $this->_2); // 2
        $this->buildSearchUrl($srchUrl, $this->_3); // 3
        $this->buildSearchUrl($srchUrl, $this->_4); // 4
        $this->buildSearchUrl($srchUrl, $this->_5); // 5
        $this->buildSearchUrl($srchUrl, $this->_6); // 6
        $this->buildSearchUrl($srchUrl, $this->_7); // 7
        $this->buildSearchUrl($srchUrl, $this->_8); // 8
        $this->buildSearchUrl($srchUrl, $this->r_date); // r_date
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // no
        if ($this->no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // works
        if ($this->works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // issue_to
        if ($this->issue_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // loom_no
        if ($this->loom_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_id
        if ($this->employee_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->employee_id->AdvancedSearch->SearchValue)) {
            $this->employee_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->employee_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->employee_id->AdvancedSearch->SearchValue2)) {
            $this->employee_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->employee_id->AdvancedSearch->SearchValue2);
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->_barcode->AdvancedSearch->SearchValue)) {
            $this->_barcode->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->_barcode->AdvancedSearch->SearchValue);
        }
        if (is_array($this->_barcode->AdvancedSearch->SearchValue2)) {
            $this->_barcode->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->_barcode->AdvancedSearch->SearchValue2);
        }

        // deduction
        if ($this->deduction->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ded_remarks
        if ($this->ded_remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other1
        if ($this->other1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other2
        if ($this->other2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 1
        if ($this->_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 2
        if ($this->_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 3
        if ($this->_3->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 4
        if ($this->_4->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 5
        if ($this->_5->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 6
        if ($this->_6->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 7
        if ($this->_7->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 8
        if ($this->_8->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_date
        if ($this->r_date->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // no
        $this->no->RowCssClass = "row";

        // works
        $this->works->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // design_size
        $this->design_size->RowCssClass = "row";

        // size_wl
        $this->size_wl->RowCssClass = "row";

        // loom_no
        $this->loom_no->RowCssClass = "row";

        // employee_1
        $this->employee_1->RowCssClass = "row";

        // employee_2
        $this->employee_2->RowCssClass = "row";

        // employee_3
        $this->employee_3->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // deduction
        $this->deduction->RowCssClass = "row";

        // ded_remarks
        $this->ded_remarks->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // other1
        $this->other1->RowCssClass = "row";

        // other2
        $this->other2->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // r_date
        $this->r_date->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // po
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                    $lookupFilter = $this->po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                        $this->po->ViewValue = $this->po->displayValue($arwrk);
                    } else {
                        $this->po->ViewValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->ViewValue = null;
            }

            // no
            $this->no->ViewValue = $this->no->CurrentValue;
            $this->no->ViewValue = FormatNumber($this->no->ViewValue, $this->no->formatPattern());

            // works
            $curVal = strval($this->works->CurrentValue);
            if ($curVal != "") {
                $this->works->ViewValue = $this->works->lookupCacheOption($curVal);
                if ($this->works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->works->Lookup->renderViewRow($rswrk[0]);
                        $this->works->ViewValue = $this->works->displayValue($arwrk);
                    } else {
                        $this->works->ViewValue = FormatNumber($this->works->CurrentValue, $this->works->formatPattern());
                    }
                }
            } else {
                $this->works->ViewValue = null;
            }

            // issue_to
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->ViewValue = FormatNumber($this->issue_to->CurrentValue, $this->issue_to->formatPattern());
                    }
                }
            } else {
                $this->issue_to->ViewValue = null;
            }

            // loom_no
            $curVal = strval($this->loom_no->CurrentValue);
            if ($curVal != "") {
                $this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
                if ($this->loom_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->loom_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->loom_no->Lookup->renderViewRow($rswrk[0]);
                        $this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
                    } else {
                        $this->loom_no->ViewValue = FormatNumber($this->loom_no->CurrentValue, $this->loom_no->formatPattern());
                    }
                }
            } else {
                $this->loom_no->ViewValue = null;
            }

            // employee_id
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->employee_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                            $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        }
                    } else {
                        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // barcode
            $curVal = strval($this->_barcode->CurrentValue);
            if ($curVal != "") {
                $this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
                if ($this->_barcode->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->_barcode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->_barcode->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                            $this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
                        }
                    } else {
                        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
                    }
                }
            } else {
                $this->_barcode->ViewValue = null;
            }

            // lot_no
            $curVal = strval($this->lot_no->CurrentValue);
            if ($curVal != "") {
                $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
                if ($this->lot_no->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->lot_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->lot_no->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->lot_no->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->lot_no->Lookup->renderViewRow($row);
                            $this->lot_no->ViewValue->add($this->lot_no->displayValue($arwrk));
                        }
                    } else {
                        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                    }
                }
            } else {
                $this->lot_no->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // ded_remarks
            $this->ded_remarks->ViewValue = $this->ded_remarks->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // other1
            $this->other1->ViewValue = $this->other1->CurrentValue;

            // other2
            $this->other2->ViewValue = $this->other2->CurrentValue;

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // r_date
            $this->r_date->ViewValue = $this->r_date->CurrentValue;
            $this->r_date->ViewValue = FormatDateTime($this->r_date->ViewValue, $this->r_date->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // no
            if (!EmptyValue($this->no->CurrentValue)) {
                $this->no->HrefValue = $this->no->getLinkPrefix() . $this->no->CurrentValue; // Add prefix/suffix
                $this->no->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->no->HrefValue = FullUrl($this->no->HrefValue, "href");
                }
            } else {
                $this->no->HrefValue = "";
            }
            $this->no->TooltipValue = "";

            // works
            $this->works->HrefValue = "";
            $this->works->TooltipValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";
            $this->issue_to->TooltipValue = "";

            // loom_no
            $this->loom_no->HrefValue = "";
            $this->loom_no->TooltipValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";
            $this->employee_id->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // deduction
            $this->deduction->HrefValue = "";
            $this->deduction->TooltipValue = "";

            // ded_remarks
            $this->ded_remarks->HrefValue = "";
            $this->ded_remarks->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // other1
            $this->other1->HrefValue = "";
            $this->other1->TooltipValue = "";

            // other2
            $this->other2->HrefValue = "";
            $this->other2->TooltipValue = "";

            // 1
            $this->_1->HrefValue = "";
            $this->_1->TooltipValue = "";

            // 2
            $this->_2->HrefValue = "";
            $this->_2->TooltipValue = "";

            // 3
            $this->_3->HrefValue = "";
            $this->_3->TooltipValue = "";

            // 4
            $this->_4->HrefValue = "";
            $this->_4->TooltipValue = "";

            // 5
            $this->_5->HrefValue = "";
            $this->_5->TooltipValue = "";

            // 6
            $this->_6->HrefValue = "";
            $this->_6->TooltipValue = "";

            // 7
            $this->_7->HrefValue = "";
            $this->_7->TooltipValue = "";

            // 8
            $this->_8->HrefValue = "";
            $this->_8->TooltipValue = "";

            // r_date
            $this->r_date->HrefValue = "";
            $this->r_date->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // po
            $this->po->setupEditAttributes();
            $curVal = trim(strval($this->po->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->po->AdvancedSearch->ViewValue = $this->po->lookupCacheOption($curVal);
            } else {
                $this->po->AdvancedSearch->ViewValue = $this->po->Lookup !== null && is_array($this->po->lookupOptions()) && count($this->po->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->po->EditValue = array_values($this->po->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $this->po->AdvancedSearch->SearchValue, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                }
                $lookupFilter = $this->po->getSelectFilter($this); // PHP
                $sqlWrk = $this->po->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->po->EditValue = $arwrk;
            }
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $curVal = trim(strval($this->po->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->po->AdvancedSearch->ViewValue2 = $this->po->lookupCacheOption($curVal);
            } else {
                $this->po->AdvancedSearch->ViewValue2 = $this->po->Lookup !== null && is_array($this->po->lookupOptions()) && count($this->po->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->po->EditValue2 = array_values($this->po->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $this->po->AdvancedSearch->SearchValue2, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                }
                $lookupFilter = $this->po->getSelectFilter($this); // PHP
                $sqlWrk = $this->po->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->po->EditValue2 = $arwrk;
            }
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // no
            $this->no->setupEditAttributes();
            $this->no->EditValue = $this->no->AdvancedSearch->SearchValue;
            $this->no->PlaceHolder = RemoveHtml($this->no->caption());

            // works
            $this->works->setupEditAttributes();
            $curVal = trim(strval($this->works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->works->AdvancedSearch->ViewValue = $this->works->lookupCacheOption($curVal);
            } else {
                $this->works->AdvancedSearch->ViewValue = $this->works->Lookup !== null && is_array($this->works->lookupOptions()) && count($this->works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->works->EditValue = array_values($this->works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->works->AdvancedSearch->SearchValue, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->works->getSelectFilter($this); // PHP
                $sqlWrk = $this->works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->works->EditValue = $arwrk;
            }
            $this->works->PlaceHolder = RemoveHtml($this->works->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $curVal = trim(strval($this->issue_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->issue_to->AdvancedSearch->ViewValue = $this->issue_to->lookupCacheOption($curVal);
            } else {
                $this->issue_to->AdvancedSearch->ViewValue = $this->issue_to->Lookup !== null && is_array($this->issue_to->lookupOptions()) && count($this->issue_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->issue_to->EditValue = array_values($this->issue_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to->AdvancedSearch->SearchValue, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to->EditValue = $arwrk;
            }
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // loom_no
            $this->loom_no->setupEditAttributes();
            $curVal = trim(strval($this->loom_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->loom_no->AdvancedSearch->ViewValue = $this->loom_no->lookupCacheOption($curVal);
            } else {
                $this->loom_no->AdvancedSearch->ViewValue = $this->loom_no->Lookup !== null && is_array($this->loom_no->lookupOptions()) && count($this->loom_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->loom_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->loom_no->EditValue = array_values($this->loom_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->loom_no->AdvancedSearch->SearchValue, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->loom_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->loom_no->Lookup->renderViewRow($row);
                }
                $this->loom_no->EditValue = $arwrk;
            }
            $this->loom_no->PlaceHolder = RemoveHtml($this->loom_no->caption());

            // employee_id
            $curVal = trim(strval($this->employee_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->lookupCacheOption($curVal);
            } else {
                $this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->Lookup !== null && is_array($this->employee_id->lookupOptions()) && count($this->employee_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->employee_id->EditValue = array_values($this->employee_id->lookupOptions());
                if ($this->employee_id->AdvancedSearch->ViewValue == "") {
                    $this->employee_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->employee_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->employee_id->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                        $this->employee_id->AdvancedSearch->ViewValue->add($this->employee_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->employee_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_id->Lookup->renderViewRow($row);
                }
                $this->employee_id->EditValue = $arwrk;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // barcode
            $curVal = trim(strval($this->_barcode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->_barcode->AdvancedSearch->ViewValue = $this->_barcode->lookupCacheOption($curVal);
            } else {
                $this->_barcode->AdvancedSearch->ViewValue = $this->_barcode->Lookup !== null && is_array($this->_barcode->lookupOptions()) && count($this->_barcode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_barcode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->_barcode->EditValue = array_values($this->_barcode->lookupOptions());
                if ($this->_barcode->AdvancedSearch->ViewValue == "") {
                    $this->_barcode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->_barcode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->_barcode->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                        $this->_barcode->AdvancedSearch->ViewValue->add($this->_barcode->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->_barcode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->_barcode->Lookup->renderViewRow($row);
                }
                $this->_barcode->EditValue = $arwrk;
            }
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // deduction
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue = $this->deduction->AdvancedSearch->SearchValue;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());

            // ded_remarks
            $this->ded_remarks->setupEditAttributes();
            if (!$this->ded_remarks->Raw) {
                $this->ded_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->ded_remarks->AdvancedSearch->SearchValue);
            }
            $this->ded_remarks->EditValue = HtmlEncode($this->ded_remarks->AdvancedSearch->SearchValue);
            $this->ded_remarks->PlaceHolder = RemoveHtml($this->ded_remarks->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // other1
            $this->other1->setupEditAttributes();
            if (!$this->other1->Raw) {
                $this->other1->AdvancedSearch->SearchValue = HtmlDecode($this->other1->AdvancedSearch->SearchValue);
            }
            $this->other1->EditValue = HtmlEncode($this->other1->AdvancedSearch->SearchValue);
            $this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

            // other2
            $this->other2->setupEditAttributes();
            if (!$this->other2->Raw) {
                $this->other2->AdvancedSearch->SearchValue = HtmlDecode($this->other2->AdvancedSearch->SearchValue);
            }
            $this->other2->EditValue = HtmlEncode($this->other2->AdvancedSearch->SearchValue);
            $this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // r_date
            $this->r_date->setupEditAttributes();
            $this->r_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->r_date->AdvancedSearch->SearchValue, $this->r_date->formatPattern()), $this->r_date->formatPattern()));
            $this->r_date->PlaceHolder = RemoveHtml($this->r_date->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->no->AdvancedSearch->SearchValue)) {
            $this->no->addErrorMessage($this->no->getErrorMessage(false));
        }
        if (!CheckNumber($this->deduction->AdvancedSearch->SearchValue)) {
            $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->r_date->AdvancedSearch->SearchValue, $this->r_date->formatPattern())) {
            $this->r_date->addErrorMessage($this->r_date->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->no->AdvancedSearch->load();
        $this->works->AdvancedSearch->load();
        $this->issue_to->AdvancedSearch->load();
        $this->loom_no->AdvancedSearch->load();
        $this->employee_id->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->deduction->AdvancedSearch->load();
        $this->ded_remarks->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->other1->AdvancedSearch->load();
        $this->other2->AdvancedSearch->load();
        $this->_1->AdvancedSearch->load();
        $this->_2->AdvancedSearch->load();
        $this->_3->AdvancedSearch->load();
        $this->_4->AdvancedSearch->load();
        $this->_5->AdvancedSearch->load();
        $this->_6->AdvancedSearch->load();
        $this->_7->AdvancedSearch->load();
        $this->_8->AdvancedSearch->load();
        $this->r_date->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("jobcardbcoldlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design_size":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_loom_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_2":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_3":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__barcode":
                    break;
                case "x_lot_no":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
