<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class JobCardBcAdd extends JobCardBc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "JobCardBcAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "jobcardbcadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->no->setVisibility();
        $this->works->setVisibility();
        $this->issue_to->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->po->setVisibility();
        $this->design_size_1->Visible = false;
        $this->design_size->setVisibility();
        $this->size_wl->setVisibility();
        $this->loom_no->setVisibility();
        $this->employee_1->setVisibility();
        $this->employee_2->setVisibility();
        $this->employee_3->setVisibility();
        $this->employee_id->Visible = false;
        $this->_barcode->setVisibility();
        $this->r_date->setVisibility();
        $this->lot_no->setVisibility();
        $this->deduction->setVisibility();
        $this->ded_remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
        $this->_1->setVisibility();
        $this->_2->setVisibility();
        $this->_3->setVisibility();
        $this->_4->setVisibility();
        $this->_5->setVisibility();
        $this->_6->setVisibility();
        $this->_7->setVisibility();
        $this->_8->setVisibility();
        $this->other1->setVisibility();
        $this->other2->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'job_card_bc';
        $this->TableName = 'job_card_bc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (job_card_bc)
        if (!isset($GLOBALS["job_card_bc"]) || $GLOBALS["job_card_bc"]::class == PROJECT_NAMESPACE . "job_card_bc") {
            $GLOBALS["job_card_bc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'job_card_bc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "jobcardbcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->works);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->po);
        $this->setupLookupOptions($this->design_size);
        $this->setupLookupOptions($this->loom_no);
        $this->setupLookupOptions($this->employee_1);
        $this->setupLookupOptions($this->employee_2);
        $this->setupLookupOptions($this->employee_3);
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->_barcode);
        $this->setupLookupOptions($this->lot_no);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("jobcardbclist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "jobcardbclist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "jobcardbcview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "jobcardbclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "jobcardbclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->no->DefaultValue = $this->no->getDefault(); // PHP
        $this->no->OldValue = $this->no->DefaultValue;
        $this->works->DefaultValue = $this->works->getDefault(); // PHP
        $this->works->OldValue = $this->works->DefaultValue;
        $this->issue_to->DefaultValue = $this->issue_to->getDefault(); // PHP
        $this->issue_to->OldValue = $this->issue_to->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->po->DefaultValue = $this->po->getDefault(); // PHP
        $this->po->OldValue = $this->po->DefaultValue;
        $this->employee_2->DefaultValue = $this->employee_2->getDefault(); // PHP
        $this->employee_2->OldValue = $this->employee_2->DefaultValue;
        $this->employee_3->DefaultValue = $this->employee_3->getDefault(); // PHP
        $this->employee_3->OldValue = $this->employee_3->DefaultValue;
        $this->deduction->DefaultValue = $this->deduction->getDefault(); // PHP
        $this->deduction->OldValue = $this->deduction->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'no' first before field var 'x_no'
        $val = $CurrentForm->hasValue("no") ? $CurrentForm->getValue("no") : $CurrentForm->getValue("x_no");
        if (!$this->no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->no->Visible = false; // Disable update for API request
            } else {
                $this->no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'works' first before field var 'x_works'
        $val = $CurrentForm->hasValue("works") ? $CurrentForm->getValue("works") : $CurrentForm->getValue("x_works");
        if (!$this->works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->works->Visible = false; // Disable update for API request
            } else {
                $this->works->setFormValue($val);
            }
        }

        // Check field name 'issue_to' first before field var 'x_issue_to'
        $val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
        if (!$this->issue_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to->Visible = false; // Disable update for API request
            } else {
                $this->issue_to->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'design_size' first before field var 'x_design_size'
        $val = $CurrentForm->hasValue("design_size") ? $CurrentForm->getValue("design_size") : $CurrentForm->getValue("x_design_size");
        if (!$this->design_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design_size->Visible = false; // Disable update for API request
            } else {
                $this->design_size->setFormValue($val);
            }
        }

        // Check field name 'size_wl' first before field var 'x_size_wl'
        $val = $CurrentForm->hasValue("size_wl") ? $CurrentForm->getValue("size_wl") : $CurrentForm->getValue("x_size_wl");
        if (!$this->size_wl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_wl->Visible = false; // Disable update for API request
            } else {
                $this->size_wl->setFormValue($val);
            }
        }

        // Check field name 'loom_no' first before field var 'x_loom_no'
        $val = $CurrentForm->hasValue("loom_no") ? $CurrentForm->getValue("loom_no") : $CurrentForm->getValue("x_loom_no");
        if (!$this->loom_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->loom_no->Visible = false; // Disable update for API request
            } else {
                $this->loom_no->setFormValue($val);
            }
        }

        // Check field name 'employee_1' first before field var 'x_employee_1'
        $val = $CurrentForm->hasValue("employee_1") ? $CurrentForm->getValue("employee_1") : $CurrentForm->getValue("x_employee_1");
        if (!$this->employee_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_1->Visible = false; // Disable update for API request
            } else {
                $this->employee_1->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'employee_2' first before field var 'x_employee_2'
        $val = $CurrentForm->hasValue("employee_2") ? $CurrentForm->getValue("employee_2") : $CurrentForm->getValue("x_employee_2");
        if (!$this->employee_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_2->Visible = false; // Disable update for API request
            } else {
                $this->employee_2->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'employee_3' first before field var 'x_employee_3'
        $val = $CurrentForm->hasValue("employee_3") ? $CurrentForm->getValue("employee_3") : $CurrentForm->getValue("x_employee_3");
        if (!$this->employee_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_3->Visible = false; // Disable update for API request
            } else {
                $this->employee_3->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val);
            }
        }

        // Check field name 'r_date' first before field var 'x_r_date'
        $val = $CurrentForm->hasValue("r_date") ? $CurrentForm->getValue("r_date") : $CurrentForm->getValue("x_r_date");
        if (!$this->r_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_date->Visible = false; // Disable update for API request
            } else {
                $this->r_date->setFormValue($val, true, $validate);
            }
            $this->r_date->CurrentValue = UnFormatDateTime($this->r_date->CurrentValue, $this->r_date->formatPattern());
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'deduction' first before field var 'x_deduction'
        $val = $CurrentForm->hasValue("deduction") ? $CurrentForm->getValue("deduction") : $CurrentForm->getValue("x_deduction");
        if (!$this->deduction->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->deduction->Visible = false; // Disable update for API request
            } else {
                $this->deduction->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ded_remarks' first before field var 'x_ded_remarks'
        $val = $CurrentForm->hasValue("ded_remarks") ? $CurrentForm->getValue("ded_remarks") : $CurrentForm->getValue("x_ded_remarks");
        if (!$this->ded_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ded_remarks->Visible = false; // Disable update for API request
            } else {
                $this->ded_remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name '1' first before field var 'x__1'
        $val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
        if (!$this->_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_1->Visible = false; // Disable update for API request
            } else {
                $this->_1->setFormValue($val);
            }
        }

        // Check field name '2' first before field var 'x__2'
        $val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
        if (!$this->_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2->Visible = false; // Disable update for API request
            } else {
                $this->_2->setFormValue($val);
            }
        }

        // Check field name '3' first before field var 'x__3'
        $val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
        if (!$this->_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_3->Visible = false; // Disable update for API request
            } else {
                $this->_3->setFormValue($val);
            }
        }

        // Check field name '4' first before field var 'x__4'
        $val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
        if (!$this->_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4->Visible = false; // Disable update for API request
            } else {
                $this->_4->setFormValue($val);
            }
        }

        // Check field name '5' first before field var 'x__5'
        $val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
        if (!$this->_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_5->Visible = false; // Disable update for API request
            } else {
                $this->_5->setFormValue($val);
            }
        }

        // Check field name '6' first before field var 'x__6'
        $val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
        if (!$this->_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_6->Visible = false; // Disable update for API request
            } else {
                $this->_6->setFormValue($val);
            }
        }

        // Check field name '7' first before field var 'x__7'
        $val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
        if (!$this->_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_7->Visible = false; // Disable update for API request
            } else {
                $this->_7->setFormValue($val);
            }
        }

        // Check field name '8' first before field var 'x__8'
        $val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
        if (!$this->_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_8->Visible = false; // Disable update for API request
            } else {
                $this->_8->setFormValue($val);
            }
        }

        // Check field name 'other1' first before field var 'x_other1'
        $val = $CurrentForm->hasValue("other1") ? $CurrentForm->getValue("other1") : $CurrentForm->getValue("x_other1");
        if (!$this->other1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other1->Visible = false; // Disable update for API request
            } else {
                $this->other1->setFormValue($val);
            }
        }

        // Check field name 'other2' first before field var 'x_other2'
        $val = $CurrentForm->hasValue("other2") ? $CurrentForm->getValue("other2") : $CurrentForm->getValue("x_other2");
        if (!$this->other2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other2->Visible = false; // Disable update for API request
            } else {
                $this->other2->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->no->CurrentValue = $this->no->FormValue;
        $this->works->CurrentValue = $this->works->FormValue;
        $this->issue_to->CurrentValue = $this->issue_to->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->design_size->CurrentValue = $this->design_size->FormValue;
        $this->size_wl->CurrentValue = $this->size_wl->FormValue;
        $this->loom_no->CurrentValue = $this->loom_no->FormValue;
        $this->employee_1->CurrentValue = $this->employee_1->FormValue;
        $this->employee_2->CurrentValue = $this->employee_2->FormValue;
        $this->employee_3->CurrentValue = $this->employee_3->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->r_date->CurrentValue = $this->r_date->FormValue;
        $this->r_date->CurrentValue = UnFormatDateTime($this->r_date->CurrentValue, $this->r_date->formatPattern());
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->deduction->CurrentValue = $this->deduction->FormValue;
        $this->ded_remarks->CurrentValue = $this->ded_remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->_1->CurrentValue = $this->_1->FormValue;
        $this->_2->CurrentValue = $this->_2->FormValue;
        $this->_3->CurrentValue = $this->_3->FormValue;
        $this->_4->CurrentValue = $this->_4->FormValue;
        $this->_5->CurrentValue = $this->_5->FormValue;
        $this->_6->CurrentValue = $this->_6->FormValue;
        $this->_7->CurrentValue = $this->_7->FormValue;
        $this->_8->CurrentValue = $this->_8->FormValue;
        $this->other1->CurrentValue = $this->other1->FormValue;
        $this->other2->CurrentValue = $this->other2->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->no->setDbValue($row['no']);
        $this->works->setDbValue($row['works']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->po->setDbValue($row['po']);
        $this->design_size_1->setDbValue($row['design_size_1']);
        $this->design_size->setDbValue($row['design_size']);
        $this->size_wl->setDbValue($row['size_wl']);
        $this->loom_no->setDbValue($row['loom_no']);
        $this->employee_1->setDbValue($row['employee_1']);
        $this->employee_2->setDbValue($row['employee_2']);
        $this->employee_3->setDbValue($row['employee_3']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->r_date->setDbValue($row['r_date']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->deduction->setDbValue($row['deduction']);
        $this->ded_remarks->setDbValue($row['ded_remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->other1->setDbValue($row['other1']);
        $this->other2->setDbValue($row['other2']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['no'] = $this->no->DefaultValue;
        $row['works'] = $this->works->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['design_size_1'] = $this->design_size_1->DefaultValue;
        $row['design_size'] = $this->design_size->DefaultValue;
        $row['size_wl'] = $this->size_wl->DefaultValue;
        $row['loom_no'] = $this->loom_no->DefaultValue;
        $row['employee_1'] = $this->employee_1->DefaultValue;
        $row['employee_2'] = $this->employee_2->DefaultValue;
        $row['employee_3'] = $this->employee_3->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['r_date'] = $this->r_date->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['deduction'] = $this->deduction->DefaultValue;
        $row['ded_remarks'] = $this->ded_remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['other1'] = $this->other1->DefaultValue;
        $row['other2'] = $this->other2->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // no
        $this->no->RowCssClass = "row";

        // works
        $this->works->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // design_size_1
        $this->design_size_1->RowCssClass = "row";

        // design_size
        $this->design_size->RowCssClass = "row";

        // size_wl
        $this->size_wl->RowCssClass = "row";

        // loom_no
        $this->loom_no->RowCssClass = "row";

        // employee_1
        $this->employee_1->RowCssClass = "row";

        // employee_2
        $this->employee_2->RowCssClass = "row";

        // employee_3
        $this->employee_3->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // r_date
        $this->r_date->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // deduction
        $this->deduction->RowCssClass = "row";

        // ded_remarks
        $this->ded_remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // other1
        $this->other1->RowCssClass = "row";

        // other2
        $this->other2->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // no
            $this->no->ViewValue = $this->no->CurrentValue;
            $this->no->ViewValue = FormatNumber($this->no->ViewValue, $this->no->formatPattern());

            // works
            $curVal = strval($this->works->CurrentValue);
            if ($curVal != "") {
                $this->works->ViewValue = $this->works->lookupCacheOption($curVal);
                if ($this->works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->works->Lookup->renderViewRow($rswrk[0]);
                        $this->works->ViewValue = $this->works->displayValue($arwrk);
                    } else {
                        $this->works->ViewValue = FormatNumber($this->works->CurrentValue, $this->works->formatPattern());
                    }
                }
            } else {
                $this->works->ViewValue = null;
            }

            // issue_to
            $curVal = strval($this->issue_to->CurrentValue);
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
                if ($this->issue_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                        $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                    } else {
                        $this->issue_to->ViewValue = FormatNumber($this->issue_to->CurrentValue, $this->issue_to->formatPattern());
                    }
                }
            } else {
                $this->issue_to->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // po
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                    $lookupFilter = $this->po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                        $this->po->ViewValue = $this->po->displayValue($arwrk);
                    } else {
                        $this->po->ViewValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->ViewValue = null;
            }

            // design_size_1
            $this->design_size_1->ViewValue = $this->design_size_1->CurrentValue;

            // design_size
            $curVal = strval($this->design_size->CurrentValue);
            if ($curVal != "") {
                $this->design_size->ViewValue = $this->design_size->lookupCacheOption($curVal);
                if ($this->design_size->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_size->Lookup->getTable()->Fields["design_size"]->searchExpression(), "=", $curVal, $this->design_size->Lookup->getTable()->Fields["design_size"]->searchDataType(), "");
                    $lookupFilter = $this->design_size->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_size->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_size->Lookup->renderViewRow($rswrk[0]);
                        $this->design_size->ViewValue = $this->design_size->displayValue($arwrk);
                    } else {
                        $this->design_size->ViewValue = $this->design_size->CurrentValue;
                    }
                }
            } else {
                $this->design_size->ViewValue = null;
            }

            // size_wl
            $this->size_wl->ViewValue = $this->size_wl->CurrentValue;

            // loom_no
            $curVal = strval($this->loom_no->CurrentValue);
            if ($curVal != "") {
                $this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
                if ($this->loom_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->loom_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->loom_no->Lookup->renderViewRow($rswrk[0]);
                        $this->loom_no->ViewValue = $this->loom_no->displayValue($arwrk);
                    } else {
                        $this->loom_no->ViewValue = FormatNumber($this->loom_no->CurrentValue, $this->loom_no->formatPattern());
                    }
                }
            } else {
                $this->loom_no->ViewValue = null;
            }

            // employee_1
            $this->employee_1->ViewValue = $this->employee_1->CurrentValue;
            $curVal = strval($this->employee_1->CurrentValue);
            if ($curVal != "") {
                $this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
                if ($this->employee_1->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_1->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
                    } else {
                        $this->employee_1->ViewValue = FormatNumber($this->employee_1->CurrentValue, $this->employee_1->formatPattern());
                    }
                }
            } else {
                $this->employee_1->ViewValue = null;
            }

            // employee_2
            $this->employee_2->ViewValue = $this->employee_2->CurrentValue;
            $curVal = strval($this->employee_2->CurrentValue);
            if ($curVal != "") {
                $this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
                if ($this->employee_2->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_2->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_2->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_2->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
                    } else {
                        $this->employee_2->ViewValue = FormatNumber($this->employee_2->CurrentValue, $this->employee_2->formatPattern());
                    }
                }
            } else {
                $this->employee_2->ViewValue = null;
            }

            // employee_3
            $this->employee_3->ViewValue = $this->employee_3->CurrentValue;
            $curVal = strval($this->employee_3->CurrentValue);
            if ($curVal != "") {
                $this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
                if ($this->employee_3->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_3->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_3->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_3->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
                    } else {
                        $this->employee_3->ViewValue = FormatNumber($this->employee_3->CurrentValue, $this->employee_3->formatPattern());
                    }
                }
            } else {
                $this->employee_3->ViewValue = null;
            }

            // employee_id
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->employee_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                            $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        }
                    } else {
                        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // barcode
            $curVal = strval($this->_barcode->CurrentValue);
            if ($curVal != "") {
                $this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
                if ($this->_barcode->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->_barcode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->_barcode->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                            $this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
                        }
                    } else {
                        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
                    }
                }
            } else {
                $this->_barcode->ViewValue = null;
            }

            // r_date
            $this->r_date->ViewValue = $this->r_date->CurrentValue;
            $this->r_date->ViewValue = FormatDateTime($this->r_date->ViewValue, $this->r_date->formatPattern());

            // lot_no
            $curVal = strval($this->lot_no->CurrentValue);
            if ($curVal != "") {
                $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
                if ($this->lot_no->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->lot_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->lot_no->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->lot_no->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->lot_no->Lookup->renderViewRow($row);
                            $this->lot_no->ViewValue->add($this->lot_no->displayValue($arwrk));
                        }
                    } else {
                        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                    }
                }
            } else {
                $this->lot_no->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // ded_remarks
            $this->ded_remarks->ViewValue = $this->ded_remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // other1
            $this->other1->ViewValue = $this->other1->CurrentValue;

            // other2
            $this->other2->ViewValue = $this->other2->CurrentValue;

            // no
            if (!EmptyValue($this->no->CurrentValue)) {
                $this->no->HrefValue = $this->no->getLinkPrefix() . $this->no->CurrentValue; // Add prefix/suffix
                $this->no->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->no->HrefValue = FullUrl($this->no->HrefValue, "href");
                }
            } else {
                $this->no->HrefValue = "";
            }

            // works
            $this->works->HrefValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // design_size
            $this->design_size->HrefValue = "";

            // size_wl
            $this->size_wl->HrefValue = "";

            // loom_no
            $this->loom_no->HrefValue = "";

            // employee_1
            $this->employee_1->HrefValue = "";

            // employee_2
            $this->employee_2->HrefValue = "";

            // employee_3
            $this->employee_3->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // r_date
            $this->r_date->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // deduction
            $this->deduction->HrefValue = "";

            // ded_remarks
            $this->ded_remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // 1
            $this->_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // other1
            $this->other1->HrefValue = "";

            // other2
            $this->other2->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // no
            $this->no->setupEditAttributes();
            $this->no->EditValue = $this->no->CurrentValue;
            $this->no->PlaceHolder = RemoveHtml($this->no->caption());
            if (strval($this->no->EditValue) != "" && is_numeric($this->no->EditValue)) {
                $this->no->EditValue = FormatNumber($this->no->EditValue, null);
            }

            // works
            $this->works->setupEditAttributes();
            $curVal = trim(strval($this->works->CurrentValue));
            if ($curVal != "") {
                $this->works->ViewValue = $this->works->lookupCacheOption($curVal);
            } else {
                $this->works->ViewValue = $this->works->Lookup !== null && is_array($this->works->lookupOptions()) && count($this->works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->works->ViewValue !== null) { // Load from cache
                $this->works->EditValue = array_values($this->works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->works->CurrentValue, $this->works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->works->getSelectFilter($this); // PHP
                $sqlWrk = $this->works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->works->EditValue = $arwrk;
            }
            $this->works->PlaceHolder = RemoveHtml($this->works->caption());

            // issue_to
            $this->issue_to->setupEditAttributes();
            $curVal = trim(strval($this->issue_to->CurrentValue));
            if ($curVal != "") {
                $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
            } else {
                $this->issue_to->ViewValue = $this->issue_to->Lookup !== null && is_array($this->issue_to->lookupOptions()) && count($this->issue_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->issue_to->ViewValue !== null) { // Load from cache
                $this->issue_to->EditValue = array_values($this->issue_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->issue_to->CurrentValue, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->issue_to->EditValue = $arwrk;
            }
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // po
            $this->po->setupEditAttributes();
            $curVal = trim(strval($this->po->CurrentValue));
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
            } else {
                $this->po->ViewValue = $this->po->Lookup !== null && is_array($this->po->lookupOptions()) && count($this->po->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po->ViewValue !== null) { // Load from cache
                $this->po->EditValue = array_values($this->po->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $this->po->CurrentValue, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                }
                $lookupFilter = $this->po->getSelectFilter($this); // PHP
                $sqlWrk = $this->po->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->po->EditValue = $arwrk;
            }
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // design_size
            $this->design_size->setupEditAttributes();
            $curVal = trim(strval($this->design_size->CurrentValue));
            if ($curVal != "") {
                $this->design_size->ViewValue = $this->design_size->lookupCacheOption($curVal);
            } else {
                $this->design_size->ViewValue = $this->design_size->Lookup !== null && is_array($this->design_size->lookupOptions()) && count($this->design_size->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_size->ViewValue !== null) { // Load from cache
                $this->design_size->EditValue = array_values($this->design_size->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_size->Lookup->getTable()->Fields["design_size"]->searchExpression(), "=", $this->design_size->CurrentValue, $this->design_size->Lookup->getTable()->Fields["design_size"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_size->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_size->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->design_size->EditValue = $arwrk;
            }
            $this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

            // size_wl
            $this->size_wl->setupEditAttributes();
            $this->size_wl->EditCustomAttributes = $this->size_wl->getEditCustomAttributes(); // PHP
            if (!$this->size_wl->Raw) {
                $this->size_wl->CurrentValue = HtmlDecode($this->size_wl->CurrentValue);
            }
            $this->size_wl->EditValue = HtmlEncode($this->size_wl->CurrentValue);
            $this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

            // loom_no
            $this->loom_no->setupEditAttributes();
            $curVal = trim(strval($this->loom_no->CurrentValue));
            if ($curVal != "") {
                $this->loom_no->ViewValue = $this->loom_no->lookupCacheOption($curVal);
            } else {
                $this->loom_no->ViewValue = $this->loom_no->Lookup !== null && is_array($this->loom_no->lookupOptions()) && count($this->loom_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->loom_no->ViewValue !== null) { // Load from cache
                $this->loom_no->EditValue = array_values($this->loom_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->loom_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->loom_no->CurrentValue, $this->loom_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->loom_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->loom_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->loom_no->Lookup->renderViewRow($row);
                }
                $this->loom_no->EditValue = $arwrk;
            }
            $this->loom_no->PlaceHolder = RemoveHtml($this->loom_no->caption());

            // employee_1
            $this->employee_1->setupEditAttributes();
            $this->employee_1->EditValue = $this->employee_1->CurrentValue;
            $curVal = strval($this->employee_1->CurrentValue);
            if ($curVal != "") {
                $this->employee_1->EditValue = $this->employee_1->lookupCacheOption($curVal);
                if ($this->employee_1->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_1->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_1->EditValue = $this->employee_1->displayValue($arwrk);
                    } else {
                        $this->employee_1->EditValue = HtmlEncode(FormatNumber($this->employee_1->CurrentValue, $this->employee_1->formatPattern()));
                    }
                }
            } else {
                $this->employee_1->EditValue = null;
            }
            $this->employee_1->PlaceHolder = RemoveHtml($this->employee_1->caption());

            // employee_2
            $this->employee_2->setupEditAttributes();
            $this->employee_2->EditValue = $this->employee_2->CurrentValue;
            $curVal = strval($this->employee_2->CurrentValue);
            if ($curVal != "") {
                $this->employee_2->EditValue = $this->employee_2->lookupCacheOption($curVal);
                if ($this->employee_2->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_2->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_2->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_2->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_2->EditValue = $this->employee_2->displayValue($arwrk);
                    } else {
                        $this->employee_2->EditValue = HtmlEncode(FormatNumber($this->employee_2->CurrentValue, $this->employee_2->formatPattern()));
                    }
                }
            } else {
                $this->employee_2->EditValue = null;
            }
            $this->employee_2->PlaceHolder = RemoveHtml($this->employee_2->caption());

            // employee_3
            $this->employee_3->setupEditAttributes();
            $this->employee_3->EditValue = $this->employee_3->CurrentValue;
            $curVal = strval($this->employee_3->CurrentValue);
            if ($curVal != "") {
                $this->employee_3->EditValue = $this->employee_3->lookupCacheOption($curVal);
                if ($this->employee_3->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_3->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_3->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_3->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_3->EditValue = $this->employee_3->displayValue($arwrk);
                    } else {
                        $this->employee_3->EditValue = HtmlEncode(FormatNumber($this->employee_3->CurrentValue, $this->employee_3->formatPattern()));
                    }
                }
            } else {
                $this->employee_3->EditValue = null;
            }
            $this->employee_3->PlaceHolder = RemoveHtml($this->employee_3->caption());

            // barcode
            $curVal = trim(strval($this->_barcode->CurrentValue));
            if ($curVal != "") {
                $this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
            } else {
                $this->_barcode->ViewValue = $this->_barcode->Lookup !== null && is_array($this->_barcode->lookupOptions()) && count($this->_barcode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_barcode->ViewValue !== null) { // Load from cache
                $this->_barcode->EditValue = array_values($this->_barcode->lookupOptions());
                if ($this->_barcode->ViewValue == "") {
                    $this->_barcode->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->_barcode->Lookup->getTable()->Fields["barcode"]->searchExpression(), "=", trim($wrk), $this->_barcode->Lookup->getTable()->Fields["barcode"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->_barcode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->_barcode->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->_barcode->Lookup->renderViewRow($row);
                        $this->_barcode->ViewValue->add($this->_barcode->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->_barcode->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->_barcode->Lookup->renderViewRow($row);
                }
                $this->_barcode->EditValue = $arwrk;
            }
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // r_date
            $this->r_date->setupEditAttributes();
            $this->r_date->EditValue = HtmlEncode(FormatDateTime($this->r_date->CurrentValue, $this->r_date->formatPattern()));
            $this->r_date->PlaceHolder = RemoveHtml($this->r_date->caption());

            // lot_no
            $curVal = trim(strval($this->lot_no->CurrentValue));
            if ($curVal != "") {
                $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
            } else {
                $this->lot_no->ViewValue = $this->lot_no->Lookup !== null && is_array($this->lot_no->lookupOptions()) && count($this->lot_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lot_no->ViewValue !== null) { // Load from cache
                $this->lot_no->EditValue = array_values($this->lot_no->lookupOptions());
                if ($this->lot_no->ViewValue == "") {
                    $this->lot_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->lot_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->lot_no->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->lot_no->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->lot_no->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->lot_no->Lookup->renderViewRow($row);
                        $this->lot_no->ViewValue->add($this->lot_no->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->lot_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->lot_no->Lookup->renderViewRow($row);
                }
                $this->lot_no->EditValue = $arwrk;
            }
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // deduction
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue = $this->deduction->CurrentValue;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
            if (strval($this->deduction->EditValue) != "" && is_numeric($this->deduction->EditValue)) {
                $this->deduction->EditValue = FormatNumber($this->deduction->EditValue, null);
            }

            // ded_remarks
            $this->ded_remarks->setupEditAttributes();
            if (!$this->ded_remarks->Raw) {
                $this->ded_remarks->CurrentValue = HtmlDecode($this->ded_remarks->CurrentValue);
            }
            $this->ded_remarks->EditValue = HtmlEncode($this->ded_remarks->CurrentValue);
            $this->ded_remarks->PlaceHolder = RemoveHtml($this->ded_remarks->caption());

            // operator

            // datetime

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // other1
            $this->other1->setupEditAttributes();
            if (!$this->other1->Raw) {
                $this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
            }
            $this->other1->EditValue = HtmlEncode($this->other1->CurrentValue);
            $this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

            // other2
            $this->other2->setupEditAttributes();
            if (!$this->other2->Raw) {
                $this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
            }
            $this->other2->EditValue = HtmlEncode($this->other2->CurrentValue);
            $this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

            // Add refer script

            // no
            if (!EmptyValue($this->no->CurrentValue)) {
                $this->no->HrefValue = $this->no->getLinkPrefix() . $this->no->CurrentValue; // Add prefix/suffix
                $this->no->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->no->HrefValue = FullUrl($this->no->HrefValue, "href");
                }
            } else {
                $this->no->HrefValue = "";
            }

            // works
            $this->works->HrefValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // design_size
            $this->design_size->HrefValue = "";

            // size_wl
            $this->size_wl->HrefValue = "";

            // loom_no
            $this->loom_no->HrefValue = "";

            // employee_1
            $this->employee_1->HrefValue = "";

            // employee_2
            $this->employee_2->HrefValue = "";

            // employee_3
            $this->employee_3->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // r_date
            $this->r_date->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // deduction
            $this->deduction->HrefValue = "";

            // ded_remarks
            $this->ded_remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // 1
            $this->_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // other1
            $this->other1->HrefValue = "";

            // other2
            $this->other2->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->no->Visible && $this->no->Required) {
                if (!$this->no->IsDetailKey && EmptyValue($this->no->FormValue)) {
                    $this->no->addErrorMessage(str_replace("%s", $this->no->caption(), $this->no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->no->FormValue)) {
                $this->no->addErrorMessage($this->no->getErrorMessage(false));
            }
            if ($this->works->Visible && $this->works->Required) {
                if (!$this->works->IsDetailKey && EmptyValue($this->works->FormValue)) {
                    $this->works->addErrorMessage(str_replace("%s", $this->works->caption(), $this->works->RequiredErrorMessage));
                }
            }
            if ($this->issue_to->Visible && $this->issue_to->Required) {
                if (!$this->issue_to->IsDetailKey && EmptyValue($this->issue_to->FormValue)) {
                    $this->issue_to->addErrorMessage(str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->design_size->Visible && $this->design_size->Required) {
                if (!$this->design_size->IsDetailKey && EmptyValue($this->design_size->FormValue)) {
                    $this->design_size->addErrorMessage(str_replace("%s", $this->design_size->caption(), $this->design_size->RequiredErrorMessage));
                }
            }
            if ($this->size_wl->Visible && $this->size_wl->Required) {
                if (!$this->size_wl->IsDetailKey && EmptyValue($this->size_wl->FormValue)) {
                    $this->size_wl->addErrorMessage(str_replace("%s", $this->size_wl->caption(), $this->size_wl->RequiredErrorMessage));
                }
            }
            if ($this->loom_no->Visible && $this->loom_no->Required) {
                if (!$this->loom_no->IsDetailKey && EmptyValue($this->loom_no->FormValue)) {
                    $this->loom_no->addErrorMessage(str_replace("%s", $this->loom_no->caption(), $this->loom_no->RequiredErrorMessage));
                }
            }
            if ($this->employee_1->Visible && $this->employee_1->Required) {
                if (!$this->employee_1->IsDetailKey && EmptyValue($this->employee_1->FormValue)) {
                    $this->employee_1->addErrorMessage(str_replace("%s", $this->employee_1->caption(), $this->employee_1->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_1->FormValue)) {
                $this->employee_1->addErrorMessage($this->employee_1->getErrorMessage(false));
            }
            if ($this->employee_2->Visible && $this->employee_2->Required) {
                if (!$this->employee_2->IsDetailKey && EmptyValue($this->employee_2->FormValue)) {
                    $this->employee_2->addErrorMessage(str_replace("%s", $this->employee_2->caption(), $this->employee_2->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_2->FormValue)) {
                $this->employee_2->addErrorMessage($this->employee_2->getErrorMessage(false));
            }
            if ($this->employee_3->Visible && $this->employee_3->Required) {
                if (!$this->employee_3->IsDetailKey && EmptyValue($this->employee_3->FormValue)) {
                    $this->employee_3->addErrorMessage(str_replace("%s", $this->employee_3->caption(), $this->employee_3->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_3->FormValue)) {
                $this->employee_3->addErrorMessage($this->employee_3->getErrorMessage(false));
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if ($this->_barcode->FormValue == "") {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->r_date->Visible && $this->r_date->Required) {
                if (!$this->r_date->IsDetailKey && EmptyValue($this->r_date->FormValue)) {
                    $this->r_date->addErrorMessage(str_replace("%s", $this->r_date->caption(), $this->r_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->r_date->FormValue, $this->r_date->formatPattern())) {
                $this->r_date->addErrorMessage($this->r_date->getErrorMessage(false));
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if ($this->lot_no->FormValue == "") {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->deduction->Visible && $this->deduction->Required) {
                if (!$this->deduction->IsDetailKey && EmptyValue($this->deduction->FormValue)) {
                    $this->deduction->addErrorMessage(str_replace("%s", $this->deduction->caption(), $this->deduction->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->deduction->FormValue)) {
                $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
            }
            if ($this->ded_remarks->Visible && $this->ded_remarks->Required) {
                if (!$this->ded_remarks->IsDetailKey && EmptyValue($this->ded_remarks->FormValue)) {
                    $this->ded_remarks->addErrorMessage(str_replace("%s", $this->ded_remarks->caption(), $this->ded_remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->_1->Visible && $this->_1->Required) {
                if (!$this->_1->IsDetailKey && EmptyValue($this->_1->FormValue)) {
                    $this->_1->addErrorMessage(str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
                }
            }
            if ($this->_2->Visible && $this->_2->Required) {
                if (!$this->_2->IsDetailKey && EmptyValue($this->_2->FormValue)) {
                    $this->_2->addErrorMessage(str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
                }
            }
            if ($this->_3->Visible && $this->_3->Required) {
                if (!$this->_3->IsDetailKey && EmptyValue($this->_3->FormValue)) {
                    $this->_3->addErrorMessage(str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
                }
            }
            if ($this->_4->Visible && $this->_4->Required) {
                if (!$this->_4->IsDetailKey && EmptyValue($this->_4->FormValue)) {
                    $this->_4->addErrorMessage(str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
                }
            }
            if ($this->_5->Visible && $this->_5->Required) {
                if (!$this->_5->IsDetailKey && EmptyValue($this->_5->FormValue)) {
                    $this->_5->addErrorMessage(str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
                }
            }
            if ($this->_6->Visible && $this->_6->Required) {
                if (!$this->_6->IsDetailKey && EmptyValue($this->_6->FormValue)) {
                    $this->_6->addErrorMessage(str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
                }
            }
            if ($this->_7->Visible && $this->_7->Required) {
                if (!$this->_7->IsDetailKey && EmptyValue($this->_7->FormValue)) {
                    $this->_7->addErrorMessage(str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
                }
            }
            if ($this->_8->Visible && $this->_8->Required) {
                if (!$this->_8->IsDetailKey && EmptyValue($this->_8->FormValue)) {
                    $this->_8->addErrorMessage(str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
                }
            }
            if ($this->other1->Visible && $this->other1->Required) {
                if (!$this->other1->IsDetailKey && EmptyValue($this->other1->FormValue)) {
                    $this->other1->addErrorMessage(str_replace("%s", $this->other1->caption(), $this->other1->RequiredErrorMessage));
                }
            }
            if ($this->other2->Visible && $this->other2->Required) {
                if (!$this->other2->IsDetailKey && EmptyValue($this->other2->FormValue)) {
                    $this->other2->addErrorMessage(str_replace("%s", $this->other2->caption(), $this->other2->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->_barcode->CurrentValue != "") { // Check field with unique index
            $filter = "(`barcode` = '" . AdjustSql($this->_barcode->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->_barcode->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->_barcode->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // no
        $this->no->setDbValueDef($rsnew, $this->no->CurrentValue, strval($this->no->CurrentValue) == "");

        // works
        $this->works->setDbValueDef($rsnew, $this->works->CurrentValue, false);

        // issue_to
        $this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, strval($this->issue_to->CurrentValue) == "");

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // po
        $this->po->setDbValueDef($rsnew, $this->po->CurrentValue, false);

        // design_size
        $this->design_size->setDbValueDef($rsnew, $this->design_size->CurrentValue, false);

        // size_wl
        $this->size_wl->setDbValueDef($rsnew, $this->size_wl->CurrentValue, false);

        // loom_no
        $this->loom_no->setDbValueDef($rsnew, $this->loom_no->CurrentValue, false);

        // employee_1
        $this->employee_1->setDbValueDef($rsnew, $this->employee_1->CurrentValue, false);

        // employee_2
        $this->employee_2->setDbValueDef($rsnew, $this->employee_2->CurrentValue, false);

        // employee_3
        $this->employee_3->setDbValueDef($rsnew, $this->employee_3->CurrentValue, false);

        // barcode
        $this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, false);

        // r_date
        $this->r_date->setDbValueDef($rsnew, UnFormatDateTime($this->r_date->CurrentValue, $this->r_date->formatPattern()), false);

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, false);

        // deduction
        $this->deduction->setDbValueDef($rsnew, $this->deduction->CurrentValue, strval($this->deduction->CurrentValue) == "");

        // ded_remarks
        $this->ded_remarks->setDbValueDef($rsnew, $this->ded_remarks->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // 1
        $this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, false);

        // 2
        $this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, false);

        // 3
        $this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, false);

        // 4
        $this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, false);

        // 5
        $this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, false);

        // 6
        $this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, false);

        // 7
        $this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, false);

        // 8
        $this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, false);

        // other1
        $this->other1->setDbValueDef($rsnew, $this->other1->CurrentValue, false);

        // other2
        $this->other2->setDbValueDef($rsnew, $this->other2->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['no'])) { // no
            $this->no->setFormValue($row['no']);
        }
        if (isset($row['works'])) { // works
            $this->works->setFormValue($row['works']);
        }
        if (isset($row['issue_to'])) { // issue_to
            $this->issue_to->setFormValue($row['issue_to']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['po'])) { // po
            $this->po->setFormValue($row['po']);
        }
        if (isset($row['design_size'])) { // design_size
            $this->design_size->setFormValue($row['design_size']);
        }
        if (isset($row['size_wl'])) { // size_wl
            $this->size_wl->setFormValue($row['size_wl']);
        }
        if (isset($row['loom_no'])) { // loom_no
            $this->loom_no->setFormValue($row['loom_no']);
        }
        if (isset($row['employee_1'])) { // employee_1
            $this->employee_1->setFormValue($row['employee_1']);
        }
        if (isset($row['employee_2'])) { // employee_2
            $this->employee_2->setFormValue($row['employee_2']);
        }
        if (isset($row['employee_3'])) { // employee_3
            $this->employee_3->setFormValue($row['employee_3']);
        }
        if (isset($row['barcode'])) { // barcode
            $this->_barcode->setFormValue($row['barcode']);
        }
        if (isset($row['r_date'])) { // r_date
            $this->r_date->setFormValue($row['r_date']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['deduction'])) { // deduction
            $this->deduction->setFormValue($row['deduction']);
        }
        if (isset($row['ded_remarks'])) { // ded_remarks
            $this->ded_remarks->setFormValue($row['ded_remarks']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['1'])) { // 1
            $this->_1->setFormValue($row['1']);
        }
        if (isset($row['2'])) { // 2
            $this->_2->setFormValue($row['2']);
        }
        if (isset($row['3'])) { // 3
            $this->_3->setFormValue($row['3']);
        }
        if (isset($row['4'])) { // 4
            $this->_4->setFormValue($row['4']);
        }
        if (isset($row['5'])) { // 5
            $this->_5->setFormValue($row['5']);
        }
        if (isset($row['6'])) { // 6
            $this->_6->setFormValue($row['6']);
        }
        if (isset($row['7'])) { // 7
            $this->_7->setFormValue($row['7']);
        }
        if (isset($row['8'])) { // 8
            $this->_8->setFormValue($row['8']);
        }
        if (isset($row['other1'])) { // other1
            $this->other1->setFormValue($row['other1']);
        }
        if (isset($row['other2'])) { // other2
            $this->other2->setFormValue($row['other2']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("jobcardbclist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design_size":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_loom_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_2":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_3":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__barcode":
                    break;
                case "x_lot_no":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    	$jc_material_issue = ExecuteScalar("SELECT `jc_material_issue` FROM `carpet_setup`  order by `id` asc limit 1");
    	setcookie('checkmat', $jc_material_issue);
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'job_card_bc');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) 
    	{
    	// Return error message in CustomError
    	extract($_POST,EXTR_OVERWRITE);
    	$_SESSION[SESSION_WARNING_MESSAGE] = '';
    	$row = ExecuteRow("SELECT concat_ws(' - ',`bcode`.`design`,`bcode`.`size_cm`,ifnull(`ppr`.`partner_ref`,NULL)) as design_size from `bcode` left join `partner_product_ref` `ppr` on((`ppr`.`id` = `bcode`.`buyer_ref`)) where `bcode`.`barcode` IN ($x__barcode[0])");
        $mjc = ExecuteScalar("SELECT `max_jobcard` FROM `carpet_setup`"); 
        $emp1 = ExecuteScalar("select count(DISTINCT `job_card_bc`.`no`) as `jc` from ((`bcode` left join `job_card_bc` on((`job_card_bc`.`no` = `bcode`.`jc_no`))) ) where ((`bcode`.`jc_no` <> 0) and (isnull(`bcode`.`process_c`) or (`bcode`.`process_c` = ''))) and FIND_IN_SET($x_employee_1, job_card_bc.employee_id) and $x_works != 1");
        $emp2 = ExecuteScalar("select count(DISTINCT `job_card_bc`.`no`) as `jc` from ((`bcode` left join `job_card_bc` on((`job_card_bc`.`no` = `bcode`.`jc_no`))) ) where ((`bcode`.`jc_no` <> 0) and (isnull(`bcode`.`process_c`) or (`bcode`.`process_c` = ''))) and FIND_IN_SET($x_employee_2, job_card_bc.employee_id) and $x_works != 1");
        $emp3 = ExecuteScalar("select count(DISTINCT `job_card_bc`.`no`) as `jc` from ((`bcode` left join `job_card_bc` on((`job_card_bc`.`no` = `bcode`.`jc_no`))) ) where ((`bcode`.`jc_no` <> 0) and (isnull(`bcode`.`process_c`) or (`bcode`.`process_c` = ''))) and FIND_IN_SET($x_employee_3, job_card_bc.employee_id) and $x_works != 1");
        if ($emp1 >= $mjc)
            {
    			$_SESSION[SESSION_WARNING_MESSAGE].= $x_employee_1 .' जॉब कार्ड की सीमा समाप्त<br>';
            }
        if ($emp2 >= $mjc)
            {
    			$_SESSION[SESSION_WARNING_MESSAGE].= $x_employee_2 .' जॉब कार्ड की सीमा समाप्त<br>';
            }    
            if ($emp3 >= $mjc)
            {
    			$_SESSION[SESSION_WARNING_MESSAGE].= $x_employee_3 .' जॉब कार्ड की सीमा समाप्त<br>';
            }
    	if ($row['design_size'] != $x_design_size)
    		{
    			$_SESSION[SESSION_WARNING_MESSAGE].= 'Data Mismatch';
    		}							
        if ($x_works == 1 and $x_issue_to == NULL)
        	{
    			$_SESSION[SESSION_WARNING_MESSAGE].= 'Please Fill *Issue to* Field';
    		}
        if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    		{
    			return true;
    		}	
    	else
    		{
    		    return false;
    		}
    	}
}
