<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for job_card
 */
class JobCard extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $jc_no;
    public $company_id;
    public $buyer_id;
    public $works;
    public $issue_to_internal;
    public $issue_to_external;
    public $issue_to;
    public $grp;
    public $s_grp;
    public $packing_type;
    public $product_code;
    public $item;
    public $poid;
    public $po;
    public $batch_no;
    public $quantity;
    public $lot_no;
    public $pro_unit;
    public $employee_id;
    public $_1;
    public $_2;
    public $_3;
    public $_4;
    public $_5;
    public $_6;
    public $_7;
    public $_8;
    public $other1;
    public $other2;
    public $operator;
    public $datetime;
    public $updated;
    public $in_id;
    public $balance_quantity;
    public $product;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "job_card";
        $this->TableName = 'job_card';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "job_card";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Required = true; // Required field
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`category`=1 and `partner_type` = 1 and `status` = 1");
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Required = true; // Required field
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_id->addMethod("getSelectFilter", fn() => "(`status` = 1 AND (`category` = 902 OR `category` = 1))");
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->setSelectMultiple(false); // Select one
        $this->buyer_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // works
        $this->works = new DbField(
            $this, // Table
            'x_works', // Variable name
            'works', // Name
            '`works`', // Expression
            '`works`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->works->addMethod("getSelectFilter", fn() => "`status`=1 and `id` > 0 and (FIND_IN_SET('0', `type`) || FIND_IN_SET('1', `type`))");
        $this->works->addMethod("getDefault", fn() => 0);
        $this->works->addMethod("getLinkPrefix", fn() => "jobcardlist?x_works=");
        $this->works->InputTextType = "text";
        $this->works->Raw = true;
        $this->works->Required = true; // Required field
        $this->works->setSelectMultiple(false); // Select one
        $this->works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->works->Lookup = new Lookup($this->works, 'godown_table', true, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->works) . "',COALESCE(`code`,''))");
        $this->works->OptionCount = 2;
        $this->works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['works'] = &$this->works;

        // issue_to_internal
        $this->issue_to_internal = new DbField(
            $this, // Table
            'x_issue_to_internal', // Variable name
            'issue_to_internal', // Name
            '0', // Expression
            '0', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '0', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->issue_to_internal->addMethod("getSelectFilter", fn() => "`mo_type` = 201");
        $this->issue_to_internal->InputTextType = "text";
        $this->issue_to_internal->Raw = true;
        $this->issue_to_internal->IsCustom = true; // Custom field
        $this->issue_to_internal->setSelectMultiple(false); // Select one
        $this->issue_to_internal->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->issue_to_internal->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->issue_to_internal->Lookup = new Lookup($this->issue_to_internal, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], ["id"], ["x_issue_to"], false, '`name` ASC', '', "`name`");
        $this->issue_to_internal->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->issue_to_internal->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issue_to_internal'] = &$this->issue_to_internal;

        // issue_to_external
        $this->issue_to_external = new DbField(
            $this, // Table
            'x_issue_to_external', // Variable name
            'issue_to_external', // Name
            '0', // Expression
            '0', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '0', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->issue_to_external->addMethod("getSelectFilter", fn() => "`category`=999");
        $this->issue_to_external->InputTextType = "text";
        $this->issue_to_external->Raw = true;
        $this->issue_to_external->IsCustom = true; // Custom field
        $this->issue_to_external->setSelectMultiple(false); // Select one
        $this->issue_to_external->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->issue_to_external->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->issue_to_external->Lookup = new Lookup($this->issue_to_external, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], ["id"], ["x_issue_to"], false, '`name` ASC', '', "`name`");
        $this->issue_to_external->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->issue_to_external->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issue_to_external'] = &$this->issue_to_external;

        // issue_to
        $this->issue_to = new DbField(
            $this, // Table
            'x_issue_to', // Variable name
            'issue_to', // Name
            '`issue_to`', // Expression
            '`issue_to`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`issue_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->issue_to->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->issue_to->InputTextType = "text";
        $this->issue_to->Raw = true;
        $this->issue_to->Lookup = new Lookup($this->issue_to, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "`name`");
        $this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->issue_to->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issue_to'] = &$this->issue_to;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->grp->addMethod("getDefault", fn() => (isset($_GET["grp"]))? $_GET["grp"]:'2');
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp","x_product_code","x_pro_unit"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getDefault", fn() => (isset($_GET["s_grp"]))? $_GET["s_grp"]:'');
        $this->s_grp->addMethod("getLinkPrefix", fn() => "jobcardlist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product_code"], ["grp"], ["x_grp"], [], [], false, '', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->packing_type->addMethod("getDefault", fn() => (isset($_GET["pt"]))? $_GET["pt"]:'');
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->Required = true; // Required field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type_table', false, 'id', ["code","packing","",""], '', '', [], ["x_product_code","x_poid[]","x_batch_no"], [], [], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`packing`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_code->addMethod("getSelectFilter", fn() => "`pending_qty` > 0");
        $this->product_code->addMethod("getDefault", fn() => (isset($_GET["rid"]))? $_GET["rid"]:'');
        $this->product_code->InputTextType = "text";
        $this->product_code->Raw = true;
        $this->product_code->Required = true; // Required field
        $this->product_code->setSelectMultiple(false); // Select one
        $this->product_code->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_code->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_code->Lookup = new Lookup($this->product_code, 'po_pending_wbc', true, 'id', ["product_code","pending_qty","",""], '', '', ["x_grp","x_s_grp","x_packing_type"], [], ["grp","s_grp","packing_type"], ["x_grp","x_s_grp","x_packing_type"], ["rid","batch_no"], ["x_item","x_batch_no"], true, '`product_code` ASC', '', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->product_code) . "',COALESCE(`pending_qty`,''))");
        $this->product_code->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // item
        $this->item = new DbField(
            $this, // Table
            'x_item', // Variable name
            'item', // Name
            '`item`', // Expression
            '`item`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__item', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->item->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->item->addMethod("getLinkPrefix", fn() => "jobcardlist?x_item=");
        $this->item->InputTextType = "text";
        $this->item->Raw = true;
        $this->item->Sortable = false; // Allow sort
        $this->item->Lookup = new Lookup($this->item, 'ref', false, 'id', ["product_code","","",""], '', '', [], ["x_poid[]","x_batch_no"], [], [], [], [], true, '`product_code` ASC', '', "`product_code`");
        $this->item->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['item'] = &$this->item;

        // poid
        $this->poid = new DbField(
            $this, // Table
            'x_poid', // Variable name
            'poid', // Name
            '`poid`', // Expression
            '`poid`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`poid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->poid->addMethod("getSelectFilter", fn() => "`pending_qty`>0 and `po`!='0'");
        $this->poid->addMethod("getLinkPrefix", fn() => "jobcardlist?x_poid=");
        $this->poid->InputTextType = "text";
        $this->poid->Nullable = false; // NOT NULL field
        $this->poid->Required = true; // Required field
        $this->poid->Sortable = false; // Allow sort
        $this->poid->Lookup = new Lookup($this->poid, 'po_pending_wbc', true, 'id', ["po","product_code","pending_qty","jc_no"], '', '', ["x_item","x_packing_type"], [], ["rid","packing_type"], ["x_rid","x_packing_type"], ["rid"], ["x_product_code"], false, '`po` ASC', '<div><span class="text-info">PO : {{:df}}, Code : {{:df2}}, Qty : {{:df3}}, <span style="color:red">JC# : {{:df4}}</span></span></div>', "CONCAT(COALESCE(`po`, ''),'" . ValueSeparator(1, $this->poid) . "',COALESCE(`product_code`,''),'" . ValueSeparator(2, $this->poid) . "',COALESCE(`pending_qty`,''),'" . ValueSeparator(3, $this->poid) . "',COALESCE(`jc_no`,''))");
        $this->poid->SearchOperators = ["=", "<>"];
        $this->Fields['poid'] = &$this->poid;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->po->addMethod("getLinkPrefix", fn() => "jobcardlist?x_po='");
        $this->po->InputTextType = "text";
        $this->po->Lookup = new Lookup($this->po, 'po_pending_wbc', true, 'id', ["po","","",""], '', '', [], [], [], [], [], [], false, '`po` ASC', '', "`po`");
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            200, // Type
            89, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->batch_no->addMethod("getLinkPrefix", fn() => "jobcardlist?x_batch_no=");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', true, 'id', ["id","batch_no","",""], '', '', ["x_item","x_packing_type"], [], ["rid","packing_type"], ["x_rid","x_packing_type"], ["process"], ["x_pro_unit"], true, '`batch_no` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->batch_no) . "',COALESCE(`batch_no`,''))");
        $this->batch_no->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getLinkPrefix", fn() => "jobcardlist?x_quantity=");
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Sortable = false; // Allow sort
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // pro_unit
        $this->pro_unit = new DbField(
            $this, // Table
            'x_pro_unit', // Variable name
            'pro_unit', // Name
            '`pro_unit`', // Expression
            '`pro_unit`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pro_unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pro_unit->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->pro_unit->InputTextType = "text";
        $this->pro_unit->Required = true; // Required field
        $this->pro_unit->setSelectMultiple(false); // Select one
        $this->pro_unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pro_unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pro_unit->Lookup = new Lookup($this->pro_unit, 'sub_process_type_view2', true, 'id', ["name","","",""], '', '', ["x_grp"], ["x_employee_id[]"], ["grp"], ["x_grp"], [], [], true, '`process` ASC', '', "`name`");
        $this->pro_unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pro_unit->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pro_unit'] = &$this->pro_unit;

        // employee_id
        $this->employee_id = new DbField(
            $this, // Table
            'x_employee_id', // Variable name
            'employee_id', // Name
            '`employee_id`', // Expression
            '`employee_id`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__employee_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->employee_id->addMethod("getDefault", fn() => 1001);
        $this->employee_id->addMethod("getLinkPrefix", fn() => "jobcardlist?x_employee_id=");
        $this->employee_id->InputTextType = "text";
        $this->employee_id->Nullable = false; // NOT NULL field
        $this->employee_id->Required = true; // Required field
        $this->employee_id->Lookup = new Lookup($this->employee_id, 'production_employee_view_pw', true, 'id', ["id","user_name","",""], '', '', ["x_pro_unit"], [], ["process"], ["x_process"], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_id) . "',COALESCE(`user_name`,''))");
        $this->employee_id->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['employee_id'] = &$this->employee_id;

        // 1
        $this->_1 = new DbField(
            $this, // Table
            'x__1', // Variable name
            '1', // Name
            '`1`', // Expression
            '`1`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_1->InputTextType = "text";
        $this->_1->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['1'] = &$this->_1;

        // 2
        $this->_2 = new DbField(
            $this, // Table
            'x__2', // Variable name
            '2', // Name
            '`2`', // Expression
            '`2`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2->InputTextType = "text";
        $this->_2->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['2'] = &$this->_2;

        // 3
        $this->_3 = new DbField(
            $this, // Table
            'x__3', // Variable name
            '3', // Name
            '`3`', // Expression
            '`3`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`3`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_3->InputTextType = "text";
        $this->_3->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['3'] = &$this->_3;

        // 4
        $this->_4 = new DbField(
            $this, // Table
            'x__4', // Variable name
            '4', // Name
            '`4`', // Expression
            '`4`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4->InputTextType = "text";
        $this->_4->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['4'] = &$this->_4;

        // 5
        $this->_5 = new DbField(
            $this, // Table
            'x__5', // Variable name
            '5', // Name
            '`5`', // Expression
            '`5`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`5`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_5->InputTextType = "text";
        $this->_5->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['5'] = &$this->_5;

        // 6
        $this->_6 = new DbField(
            $this, // Table
            'x__6', // Variable name
            '6', // Name
            '`6`', // Expression
            '`6`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`6`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_6->InputTextType = "text";
        $this->_6->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['6'] = &$this->_6;

        // 7
        $this->_7 = new DbField(
            $this, // Table
            'x__7', // Variable name
            '7', // Name
            '`7`', // Expression
            '`7`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`7`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_7->InputTextType = "text";
        $this->_7->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['7'] = &$this->_7;

        // 8
        $this->_8 = new DbField(
            $this, // Table
            'x__8', // Variable name
            '8', // Name
            '`8`', // Expression
            '`8`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`8`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_8->InputTextType = "text";
        $this->_8->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['8'] = &$this->_8;

        // other1
        $this->other1 = new DbField(
            $this, // Table
            'x_other1', // Variable name
            'other1', // Name
            '`other1`', // Expression
            '`other1`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`other1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->other1->InputTextType = "text";
        $this->other1->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['other1'] = &$this->other1;

        // other2
        $this->other2 = new DbField(
            $this, // Table
            'x_other2', // Variable name
            'other2', // Name
            '`other2`', // Expression
            '`other2`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`other2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->other2->InputTextType = "text";
        $this->other2->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['other2'] = &$this->other2;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // updated
        $this->updated = new DbField(
            $this, // Table
            'x_updated', // Variable name
            'updated', // Name
            '`updated`', // Expression
            '`updated`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`updated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->updated->addMethod("getDefault", fn() => 0);
        $this->updated->InputTextType = "text";
        $this->updated->Raw = true;
        $this->updated->Sortable = false; // Allow sort
        $this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->updated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['updated'] = &$this->updated;

        // in_id
        $this->in_id = new DbField(
            $this, // Table
            'x_in_id', // Variable name
            'in_id', // Name
            '`in_id`', // Expression
            '`in_id`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`in_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->in_id->InputTextType = "text";
        $this->in_id->Sortable = false; // Allow sort
        $this->in_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['in_id'] = &$this->in_id;

        // balance_quantity
        $this->balance_quantity = new DbField(
            $this, // Table
            'x_balance_quantity', // Variable name
            'balance_quantity', // Name
            '`balance_quantity`', // Expression
            '`balance_quantity`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`balance_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->balance_quantity->addMethod("getDefault", fn() => 0);
        $this->balance_quantity->InputTextType = "text";
        $this->balance_quantity->Raw = true;
        $this->balance_quantity->Nullable = false; // NOT NULL field
        $this->balance_quantity->Sortable = false; // Allow sort
        $this->balance_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->balance_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['balance_quantity'] = &$this->balance_quantity;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Sortable = false; // Allow sort
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "job_card";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, 0 AS `issue_to_internal`, 0 AS `issue_to_external`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = job_card.item LIMIT 1) AS EV__item FROM job_card)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if (
            $this->item->AdvancedSearch->SearchValue != "" ||
            $this->item->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->item->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->item->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->employee_id->AdvancedSearch->SearchValue != "" ||
            $this->employee_id->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->employee_id->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->employee_id->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->company_id->DbValue = $row['company_id'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->works->DbValue = $row['works'];
        $this->issue_to_internal->DbValue = $row['issue_to_internal'];
        $this->issue_to_external->DbValue = $row['issue_to_external'];
        $this->issue_to->DbValue = $row['issue_to'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->product_code->DbValue = $row['product_code'];
        $this->item->DbValue = $row['item'];
        $this->poid->DbValue = $row['poid'];
        $this->po->DbValue = $row['po'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->quantity->DbValue = $row['quantity'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->pro_unit->DbValue = $row['pro_unit'];
        $this->employee_id->DbValue = $row['employee_id'];
        $this->_1->DbValue = $row['1'];
        $this->_2->DbValue = $row['2'];
        $this->_3->DbValue = $row['3'];
        $this->_4->DbValue = $row['4'];
        $this->_5->DbValue = $row['5'];
        $this->_6->DbValue = $row['6'];
        $this->_7->DbValue = $row['7'];
        $this->_8->DbValue = $row['8'];
        $this->other1->DbValue = $row['other1'];
        $this->other2->DbValue = $row['other2'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->updated->DbValue = $row['updated'];
        $this->in_id->DbValue = $row['in_id'];
        $this->balance_quantity->DbValue = $row['balance_quantity'];
        $this->product->DbValue = $row['product'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("jobcardlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "jobcardview" => $Language->phrase("View"),
            "jobcardedit" => $Language->phrase("Edit"),
            "jobcardadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "jobcardlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "JobCardView",
            Config("API_ADD_ACTION") => "JobCardAdd",
            Config("API_EDIT_ACTION") => "JobCardEdit",
            Config("API_DELETE_ACTION") => "JobCardDelete",
            Config("API_LIST_ACTION") => "JobCardList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "jobcardlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("jobcardview", $parm);
        } else {
            $url = $this->keyUrl("jobcardview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "jobcardadd?" . $parm;
        } else {
            $url = "jobcardadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("jobcardedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("jobcardlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("jobcardadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("jobcardlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("jobcarddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->company_id->setDbValue($row['company_id']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->works->setDbValue($row['works']);
        $this->issue_to_internal->setDbValue($row['issue_to_internal']);
        $this->issue_to_external->setDbValue($row['issue_to_external']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->item->setDbValue($row['item']);
        $this->poid->setDbValue($row['poid']);
        $this->po->setDbValue($row['po']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->pro_unit->setDbValue($row['pro_unit']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->other1->setDbValue($row['other1']);
        $this->other2->setDbValue($row['other2']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->in_id->setDbValue($row['in_id']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->product->setDbValue($row['product']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "JobCardList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // jc_no

        // company_id

        // buyer_id

        // works

        // issue_to_internal

        // issue_to_external

        // issue_to

        // grp

        // s_grp

        // packing_type

        // product_code

        // item
        $this->item->CellCssStyle = "white-space: nowrap;";

        // poid
        $this->poid->CellCssStyle = "white-space: nowrap;";

        // po

        // batch_no

        // quantity

        // lot_no
        $this->lot_no->CellCssStyle = "white-space: nowrap;";

        // pro_unit

        // employee_id

        // 1

        // 2

        // 3

        // 4

        // 5

        // 6

        // 7

        // 8

        // other1

        // other2

        // operator

        // datetime

        // updated
        $this->updated->CellCssStyle = "white-space: nowrap;";

        // in_id
        $this->in_id->CellCssStyle = "white-space: nowrap;";

        // balance_quantity
        $this->balance_quantity->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // buyer_id
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // works
        if (strval($this->works->CurrentValue) != "") {
            $this->works->ViewValue = $this->works->optionCaption($this->works->CurrentValue);
        } else {
            $this->works->ViewValue = null;
        }

        // issue_to_internal
        $curVal = strval($this->issue_to_internal->CurrentValue);
        if ($curVal != "") {
            $this->issue_to_internal->ViewValue = $this->issue_to_internal->lookupCacheOption($curVal);
            if ($this->issue_to_internal->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_internal->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->issue_to_internal->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_internal->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_to_internal->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_to_internal->ViewValue = $this->issue_to_internal->displayValue($arwrk);
                } else {
                    $this->issue_to_internal->ViewValue = FormatNumber($this->issue_to_internal->CurrentValue, $this->issue_to_internal->formatPattern());
                }
            }
        } else {
            $this->issue_to_internal->ViewValue = null;
        }

        // issue_to_external
        $curVal = strval($this->issue_to_external->CurrentValue);
        if ($curVal != "") {
            $this->issue_to_external->ViewValue = $this->issue_to_external->lookupCacheOption($curVal);
            if ($this->issue_to_external->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->issue_to_external->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to_external->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->issue_to_external->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to_external->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_to_external->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_to_external->ViewValue = $this->issue_to_external->displayValue($arwrk);
                } else {
                    $this->issue_to_external->ViewValue = FormatNumber($this->issue_to_external->CurrentValue, $this->issue_to_external->formatPattern());
                }
            }
        } else {
            $this->issue_to_external->ViewValue = null;
        }

        // issue_to
        $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
        $curVal = strval($this->issue_to->CurrentValue);
        if ($curVal != "") {
            $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
            if ($this->issue_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                } else {
                    $this->issue_to->ViewValue = FormatNumber($this->issue_to->CurrentValue, $this->issue_to->formatPattern());
                }
            }
        } else {
            $this->issue_to->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // product_code
        $curVal = strval($this->product_code->CurrentValue);
        if ($curVal != "") {
            $this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
            if ($this->product_code->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product_code->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_code->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_code->Lookup->renderViewRow($rswrk[0]);
                    $this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
                } else {
                    $this->product_code->ViewValue = $this->product_code->CurrentValue;
                }
            }
        } else {
            $this->product_code->ViewValue = null;
        }

        // item
        if ($this->item->VirtualValue != "") {
            $this->item->ViewValue = $this->item->VirtualValue;
        } else {
            $this->item->ViewValue = $this->item->CurrentValue;
            $curVal = strval($this->item->CurrentValue);
            if ($curVal != "") {
                $this->item->ViewValue = $this->item->lookupCacheOption($curVal);
                if ($this->item->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->item->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->item->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->item->Lookup->renderViewRow($rswrk[0]);
                        $this->item->ViewValue = $this->item->displayValue($arwrk);
                    } else {
                        $this->item->ViewValue = $this->item->CurrentValue;
                    }
                }
            } else {
                $this->item->ViewValue = null;
            }
        }

        // poid
        $curVal = strval($this->poid->CurrentValue);
        if ($curVal != "") {
            $this->poid->ViewValue = $this->poid->lookupCacheOption($curVal);
            if ($this->poid->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->poid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->poid->getSelectFilter($this); // PHP
                $sqlWrk = $this->poid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->poid->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->poid->Lookup->renderViewRow($row);
                        $this->poid->ViewValue->add($this->poid->displayValue($arwrk));
                    }
                } else {
                    $this->poid->ViewValue = $this->poid->CurrentValue;
                }
            }
        } else {
            $this->poid->ViewValue = null;
        }

        // po
        $curVal = strval($this->po->CurrentValue);
        if ($curVal != "") {
            $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
            if ($this->po->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->po->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->po->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->po->Lookup->renderViewRow($row);
                        $this->po->ViewValue->add($this->po->displayValue($arwrk));
                    }
                } else {
                    $this->po->ViewValue = $this->po->CurrentValue;
                }
            }
        } else {
            $this->po->ViewValue = null;
        }
        $this->po->CellCssStyle .= "text-align: left;";

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // pro_unit
        $curVal = strval($this->pro_unit->CurrentValue);
        if ($curVal != "") {
            $this->pro_unit->ViewValue = $this->pro_unit->lookupCacheOption($curVal);
            if ($this->pro_unit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pro_unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pro_unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pro_unit->getSelectFilter($this); // PHP
                $sqlWrk = $this->pro_unit->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pro_unit->Lookup->renderViewRow($rswrk[0]);
                    $this->pro_unit->ViewValue = $this->pro_unit->displayValue($arwrk);
                } else {
                    $this->pro_unit->ViewValue = $this->pro_unit->CurrentValue;
                }
            }
        } else {
            $this->pro_unit->ViewValue = null;
        }

        // employee_id
        if ($this->employee_id->VirtualValue != "") {
            $this->employee_id->ViewValue = $this->employee_id->VirtualValue;
        } else {
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->employee_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                            $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        }
                    } else {
                        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }
        }

        // 1
        $this->_1->ViewValue = $this->_1->CurrentValue;

        // 2
        $this->_2->ViewValue = $this->_2->CurrentValue;

        // 3
        $this->_3->ViewValue = $this->_3->CurrentValue;

        // 4
        $this->_4->ViewValue = $this->_4->CurrentValue;

        // 5
        $this->_5->ViewValue = $this->_5->CurrentValue;

        // 6
        $this->_6->ViewValue = $this->_6->CurrentValue;

        // 7
        $this->_7->ViewValue = $this->_7->CurrentValue;

        // 8
        $this->_8->ViewValue = $this->_8->CurrentValue;

        // other1
        $this->other1->ViewValue = $this->other1->CurrentValue;

        // other2
        $this->other2->ViewValue = $this->other2->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // updated
        $this->updated->ViewValue = $this->updated->CurrentValue;
        $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

        // in_id
        $this->in_id->ViewValue = $this->in_id->CurrentValue;

        // balance_quantity
        $this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
        $this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, $this->balance_quantity->formatPattern());

        // product
        $this->product->ViewValue = $this->product->CurrentValue;
        $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // buyer_id
        $this->buyer_id->HrefValue = "";
        $this->buyer_id->TooltipValue = "";

        // works
        if (!EmptyValue($this->works->CurrentValue)) {
            $this->works->HrefValue = $this->works->getLinkPrefix() . $this->works->CurrentValue; // Add prefix/suffix
            $this->works->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->works->HrefValue = FullUrl($this->works->HrefValue, "href");
            }
        } else {
            $this->works->HrefValue = "";
        }
        $this->works->TooltipValue = "";

        // issue_to_internal
        $this->issue_to_internal->HrefValue = "";
        $this->issue_to_internal->TooltipValue = "";

        // issue_to_external
        $this->issue_to_external->HrefValue = "";
        $this->issue_to_external->TooltipValue = "";

        // issue_to
        $this->issue_to->HrefValue = "";
        $this->issue_to->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_parent"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // product_code
        $this->product_code->HrefValue = "";
        $this->product_code->TooltipValue = "";

        // item
        if (!EmptyValue($this->item->CurrentValue)) {
            $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
            $this->item->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
            }
        } else {
            $this->item->HrefValue = "";
        }
        $this->item->TooltipValue = "";

        // poid
        if (!EmptyValue($this->poid->CurrentValue)) {
            $this->poid->HrefValue = $this->poid->getLinkPrefix() . $this->poid->CurrentValue; // Add prefix/suffix
            $this->poid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->poid->HrefValue = FullUrl($this->poid->HrefValue, "href");
            }
        } else {
            $this->poid->HrefValue = "";
        }
        $this->poid->TooltipValue = "";

        // po
        if (!EmptyValue($this->po->CurrentValue)) {
            $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
            $this->po->LinkAttrs["target"] = "_parent"; // Add target
            if ($this->isExport()) {
                $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
            }
        } else {
            $this->po->HrefValue = "";
        }
        $this->po->TooltipValue = "";

        // batch_no
        if (!EmptyValue($this->batch_no->CurrentValue)) {
            $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
            $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
            }
        } else {
            $this->batch_no->HrefValue = "";
        }
        $this->batch_no->TooltipValue = "";

        // quantity
        if (!EmptyValue($this->quantity->CurrentValue)) {
            $this->quantity->HrefValue = $this->quantity->getLinkPrefix() . $this->quantity->CurrentValue; // Add prefix/suffix
            $this->quantity->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->quantity->HrefValue = FullUrl($this->quantity->HrefValue, "href");
            }
        } else {
            $this->quantity->HrefValue = "";
        }
        $this->quantity->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // pro_unit
        $this->pro_unit->HrefValue = "";
        $this->pro_unit->TooltipValue = "";

        // employee_id
        if (!EmptyValue($this->employee_id->CurrentValue)) {
            $this->employee_id->HrefValue = $this->employee_id->getLinkPrefix() . $this->employee_id->CurrentValue; // Add prefix/suffix
            $this->employee_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
            }
        } else {
            $this->employee_id->HrefValue = "";
        }
        $this->employee_id->TooltipValue = "";

        // 1
        $this->_1->HrefValue = "";
        $this->_1->TooltipValue = "";

        // 2
        $this->_2->HrefValue = "";
        $this->_2->TooltipValue = "";

        // 3
        $this->_3->HrefValue = "";
        $this->_3->TooltipValue = "";

        // 4
        $this->_4->HrefValue = "";
        $this->_4->TooltipValue = "";

        // 5
        $this->_5->HrefValue = "";
        $this->_5->TooltipValue = "";

        // 6
        $this->_6->HrefValue = "";
        $this->_6->TooltipValue = "";

        // 7
        $this->_7->HrefValue = "";
        $this->_7->TooltipValue = "";

        // 8
        $this->_8->HrefValue = "";
        $this->_8->TooltipValue = "";

        // other1
        $this->other1->HrefValue = "";
        $this->other1->TooltipValue = "";

        // other2
        $this->other2->HrefValue = "";
        $this->other2->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // updated
        $this->updated->HrefValue = "";
        $this->updated->TooltipValue = "";

        // in_id
        $this->in_id->HrefValue = "";
        $this->in_id->TooltipValue = "";

        // balance_quantity
        $this->balance_quantity->HrefValue = "";
        $this->balance_quantity->TooltipValue = "";

        // product
        $this->product->HrefValue = "";
        $this->product->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

        // works
        $this->works->setupEditAttributes();
        $this->works->EditValue = $this->works->options(true);
        $this->works->PlaceHolder = RemoveHtml($this->works->caption());

        // issue_to_internal
        $this->issue_to_internal->setupEditAttributes();
        $this->issue_to_internal->PlaceHolder = RemoveHtml($this->issue_to_internal->caption());

        // issue_to_external
        $this->issue_to_external->setupEditAttributes();
        $this->issue_to_external->PlaceHolder = RemoveHtml($this->issue_to_external->caption());

        // issue_to
        $this->issue_to->setupEditAttributes();
        $this->issue_to->EditCustomAttributes = $this->issue_to->getEditCustomAttributes(); // PHP
        $this->issue_to->EditValue = $this->issue_to->CurrentValue;
        $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // item
        $this->item->setupEditAttributes();
        $this->item->EditCustomAttributes = $this->item->getEditCustomAttributes(); // PHP
        $this->item->EditValue = $this->item->CurrentValue;
        $this->item->PlaceHolder = RemoveHtml($this->item->caption());

        // poid
        $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

        // po
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // lot_no
        $this->lot_no->setupEditAttributes();
        if (!$this->lot_no->Raw) {
            $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
        }
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

        // pro_unit
        $this->pro_unit->setupEditAttributes();
        $this->pro_unit->PlaceHolder = RemoveHtml($this->pro_unit->caption());

        // employee_id
        $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

        // 1
        $this->_1->setupEditAttributes();
        if (!$this->_1->Raw) {
            $this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
        }
        $this->_1->EditValue = $this->_1->CurrentValue;
        $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

        // 2
        $this->_2->setupEditAttributes();
        if (!$this->_2->Raw) {
            $this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
        }
        $this->_2->EditValue = $this->_2->CurrentValue;
        $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

        // 3
        $this->_3->setupEditAttributes();
        if (!$this->_3->Raw) {
            $this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
        }
        $this->_3->EditValue = $this->_3->CurrentValue;
        $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

        // 4
        $this->_4->setupEditAttributes();
        if (!$this->_4->Raw) {
            $this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
        }
        $this->_4->EditValue = $this->_4->CurrentValue;
        $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

        // 5
        $this->_5->setupEditAttributes();
        if (!$this->_5->Raw) {
            $this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
        }
        $this->_5->EditValue = $this->_5->CurrentValue;
        $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

        // 6
        $this->_6->setupEditAttributes();
        if (!$this->_6->Raw) {
            $this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
        }
        $this->_6->EditValue = $this->_6->CurrentValue;
        $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

        // 7
        $this->_7->setupEditAttributes();
        if (!$this->_7->Raw) {
            $this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
        }
        $this->_7->EditValue = $this->_7->CurrentValue;
        $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

        // 8
        $this->_8->setupEditAttributes();
        if (!$this->_8->Raw) {
            $this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
        }
        $this->_8->EditValue = $this->_8->CurrentValue;
        $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

        // other1
        $this->other1->setupEditAttributes();
        if (!$this->other1->Raw) {
            $this->other1->CurrentValue = HtmlDecode($this->other1->CurrentValue);
        }
        $this->other1->EditValue = $this->other1->CurrentValue;
        $this->other1->PlaceHolder = RemoveHtml($this->other1->caption());

        // other2
        $this->other2->setupEditAttributes();
        if (!$this->other2->Raw) {
            $this->other2->CurrentValue = HtmlDecode($this->other2->CurrentValue);
        }
        $this->other2->EditValue = $this->other2->CurrentValue;
        $this->other2->PlaceHolder = RemoveHtml($this->other2->caption());

        // operator

        // datetime

        // updated
        $this->updated->setupEditAttributes();
        $this->updated->EditValue = $this->updated->CurrentValue;
        $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
        if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
            $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
        }

        // in_id
        $this->in_id->setupEditAttributes();
        if (!$this->in_id->Raw) {
            $this->in_id->CurrentValue = HtmlDecode($this->in_id->CurrentValue);
        }
        $this->in_id->EditValue = $this->in_id->CurrentValue;
        $this->in_id->PlaceHolder = RemoveHtml($this->in_id->caption());

        // balance_quantity
        $this->balance_quantity->setupEditAttributes();
        $this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
        $this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
        if (strval($this->balance_quantity->EditValue) != "" && is_numeric($this->balance_quantity->EditValue)) {
            $this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, null);
        }

        // product
        $this->product->setupEditAttributes();
        $this->product->EditValue = $this->product->CurrentValue;
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());
        if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
            $this->product->EditValue = FormatNumber($this->product->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->works);
                    $doc->exportCaption($this->issue_to_internal);
                    $doc->exportCaption($this->issue_to_external);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->pro_unit);
                    $doc->exportCaption($this->employee_id);
                    $doc->exportCaption($this->_1);
                    $doc->exportCaption($this->_2);
                    $doc->exportCaption($this->_3);
                    $doc->exportCaption($this->_4);
                    $doc->exportCaption($this->_5);
                    $doc->exportCaption($this->_6);
                    $doc->exportCaption($this->_7);
                    $doc->exportCaption($this->_8);
                    $doc->exportCaption($this->other1);
                    $doc->exportCaption($this->other2);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->works);
                    $doc->exportCaption($this->issue_to_internal);
                    $doc->exportCaption($this->issue_to_external);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->pro_unit);
                    $doc->exportCaption($this->employee_id);
                    $doc->exportCaption($this->_1);
                    $doc->exportCaption($this->_2);
                    $doc->exportCaption($this->_3);
                    $doc->exportCaption($this->_4);
                    $doc->exportCaption($this->_5);
                    $doc->exportCaption($this->_6);
                    $doc->exportCaption($this->_7);
                    $doc->exportCaption($this->_8);
                    $doc->exportCaption($this->other1);
                    $doc->exportCaption($this->other2);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->works);
                        $doc->exportField($this->issue_to_internal);
                        $doc->exportField($this->issue_to_external);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->po);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->pro_unit);
                        $doc->exportField($this->employee_id);
                        $doc->exportField($this->_1);
                        $doc->exportField($this->_2);
                        $doc->exportField($this->_3);
                        $doc->exportField($this->_4);
                        $doc->exportField($this->_5);
                        $doc->exportField($this->_6);
                        $doc->exportField($this->_7);
                        $doc->exportField($this->_8);
                        $doc->exportField($this->other1);
                        $doc->exportField($this->other2);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->works);
                        $doc->exportField($this->issue_to_internal);
                        $doc->exportField($this->issue_to_external);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->po);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->pro_unit);
                        $doc->exportField($this->employee_id);
                        $doc->exportField($this->_1);
                        $doc->exportField($this->_2);
                        $doc->exportField($this->_3);
                        $doc->exportField($this->_4);
                        $doc->exportField($this->_5);
                        $doc->exportField($this->_6);
                        $doc->exportField($this->_7);
                        $doc->exportField($this->_8);
                        $doc->exportField($this->other1);
                        $doc->exportField($this->other2);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->jc_no, '');
                $doc->exportAggregate($this->company_id, '');
                $doc->exportAggregate($this->buyer_id, '');
                $doc->exportAggregate($this->works, '');
                $doc->exportAggregate($this->issue_to_internal, '');
                $doc->exportAggregate($this->issue_to_external, '');
                $doc->exportAggregate($this->issue_to, '');
                $doc->exportAggregate($this->grp, '');
                $doc->exportAggregate($this->s_grp, '');
                $doc->exportAggregate($this->packing_type, '');
                $doc->exportAggregate($this->product_code, '');
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->batch_no, '');
                $doc->exportAggregate($this->quantity, 'TOTAL');
                $doc->exportAggregate($this->pro_unit, '');
                $doc->exportAggregate($this->employee_id, '');
                $doc->exportAggregate($this->_1, '');
                $doc->exportAggregate($this->_2, '');
                $doc->exportAggregate($this->_3, '');
                $doc->exportAggregate($this->_4, '');
                $doc->exportAggregate($this->_5, '');
                $doc->exportAggregate($this->_6, '');
                $doc->exportAggregate($this->_7, '');
                $doc->exportAggregate($this->_8, '');
                $doc->exportAggregate($this->other1, '');
                $doc->exportAggregate($this->other2, '');
                $doc->exportAggregate($this->operator, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'job_card');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'job_card', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'job_card', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'job_card', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
