<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class InvoiceDetailsSearch extends InvoiceDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InvoiceDetailsSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "invoicedetailssearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->_barcode->setVisibility();
        $this->exporter->setVisibility();
        $this->consignee->setVisibility();
        $this->consignee_other->setVisibility();
        $this->packing_list_no->setVisibility();
        $this->d_11->setVisibility();
        $this->description_11->setVisibility();
        $this->in_template->setVisibility();
        $this->pl_template->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->po_no->setVisibility();
        $this->other_reference->setVisibility();
        $this->origin->setVisibility();
        $this->final_destination->setVisibility();
        $this->payment_terms->setVisibility();
        $this->pre_carriage_receipt->setVisibility();
        $this->place_of_receipt->setVisibility();
        $this->loading_port->setVisibility();
        $this->port_discharge->setVisibility();
        $this->d_01->setVisibility();
        $this->description_01->setVisibility();
        $this->d_02->setVisibility();
        $this->description_02->setVisibility();
        $this->gross_weight->setVisibility();
        $this->nett_weight->setVisibility();
        $this->cbm->setVisibility();
        $this->exporter_bank_details->setVisibility();
        $this->intermediary_bank->setVisibility();
        $this->shipment_mode->setVisibility();
        $this->ex_factory_date->setVisibility();
        $this->sailing_date->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->delivery_terms->Visible = false;
        $this->po_date->Visible = false;
        $this->cart_lines->setVisibility();
        $this->pl_lines->setVisibility();
        $this->freezed->setVisibility();
        $this->pl_pdf->Visible = false;
        $this->in_pdf->Visible = false;
        $this->a_operator->setVisibility();
        $this->port_delivery->setVisibility();
        $this->dispatch_details->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'invoice_details';
        $this->TableName = 'invoice_details';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (invoice_details)
        if (!isset($GLOBALS["invoice_details"]) || $GLOBALS["invoice_details"]::class == PROJECT_NAMESPACE . "invoice_details") {
            $GLOBALS["invoice_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "invoicedetailsview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->exporter);
        $this->setupLookupOptions($this->consignee);
        $this->setupLookupOptions($this->consignee_other);
        $this->setupLookupOptions($this->packing_list_no);
        $this->setupLookupOptions($this->in_template);
        $this->setupLookupOptions($this->pl_template);
        $this->setupLookupOptions($this->shipment_mode);
        $this->setupLookupOptions($this->freezed);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "invoicedetailslist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->exporter); // exporter
        $this->buildSearchUrl($srchUrl, $this->consignee); // consignee
        $this->buildSearchUrl($srchUrl, $this->consignee_other); // consignee_other
        $this->buildSearchUrl($srchUrl, $this->packing_list_no); // packing_list_no
        $this->buildSearchUrl($srchUrl, $this->d_11); // d_11
        $this->buildSearchUrl($srchUrl, $this->description_11); // description_11
        $this->buildSearchUrl($srchUrl, $this->in_template); // in_template
        $this->buildSearchUrl($srchUrl, $this->pl_template); // pl_template
        $this->buildSearchUrl($srchUrl, $this->invoice_no); // invoice_no
        $this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
        $this->buildSearchUrl($srchUrl, $this->po_no); // po_no
        $this->buildSearchUrl($srchUrl, $this->other_reference); // other_reference
        $this->buildSearchUrl($srchUrl, $this->origin); // origin
        $this->buildSearchUrl($srchUrl, $this->final_destination); // final_destination
        $this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
        $this->buildSearchUrl($srchUrl, $this->pre_carriage_receipt); // pre_carriage_receipt
        $this->buildSearchUrl($srchUrl, $this->place_of_receipt); // place_of_receipt
        $this->buildSearchUrl($srchUrl, $this->loading_port); // loading_port
        $this->buildSearchUrl($srchUrl, $this->port_discharge); // port_discharge
        $this->buildSearchUrl($srchUrl, $this->d_01); // d_01
        $this->buildSearchUrl($srchUrl, $this->description_01); // description_01
        $this->buildSearchUrl($srchUrl, $this->d_02); // d_02
        $this->buildSearchUrl($srchUrl, $this->description_02); // description_02
        $this->buildSearchUrl($srchUrl, $this->gross_weight); // gross_weight
        $this->buildSearchUrl($srchUrl, $this->nett_weight); // nett_weight
        $this->buildSearchUrl($srchUrl, $this->cbm); // cbm
        $this->buildSearchUrl($srchUrl, $this->exporter_bank_details); // exporter_bank_details
        $this->buildSearchUrl($srchUrl, $this->intermediary_bank); // intermediary_bank
        $this->buildSearchUrl($srchUrl, $this->shipment_mode); // shipment_mode
        $this->buildSearchUrl($srchUrl, $this->ex_factory_date); // ex_factory_date
        $this->buildSearchUrl($srchUrl, $this->sailing_date); // sailing_date
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->cart_lines); // cart_lines
        $this->buildSearchUrl($srchUrl, $this->pl_lines); // pl_lines
        $this->buildSearchUrl($srchUrl, $this->freezed); // freezed
        $this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
        $this->buildSearchUrl($srchUrl, $this->port_delivery); // port_delivery
        $this->buildSearchUrl($srchUrl, $this->dispatch_details); // dispatch_details
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // exporter
        if ($this->exporter->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // consignee
        if ($this->consignee->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // consignee_other
        if ($this->consignee_other->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_list_no
        if ($this->packing_list_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_11
        if ($this->d_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_11
        if ($this->description_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // in_template
        if ($this->in_template->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_template
        if ($this->pl_template->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_no
        if ($this->invoice_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_no
        if ($this->po_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other_reference
        if ($this->other_reference->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // origin
        if ($this->origin->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // final_destination
        if ($this->final_destination->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pre_carriage_receipt
        if ($this->pre_carriage_receipt->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // place_of_receipt
        if ($this->place_of_receipt->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // loading_port
        if ($this->loading_port->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_discharge
        if ($this->port_discharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_01
        if ($this->d_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_01
        if ($this->description_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_02
        if ($this->d_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_02
        if ($this->description_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gross_weight
        if ($this->gross_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // nett_weight
        if ($this->nett_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // exporter_bank_details
        if ($this->exporter_bank_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // intermediary_bank
        if ($this->intermediary_bank->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipment_mode
        if ($this->shipment_mode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ex_factory_date
        if ($this->ex_factory_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sailing_date
        if ($this->sailing_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cart_lines
        if ($this->cart_lines->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_lines
        if ($this->pl_lines->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // freezed
        if ($this->freezed->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_delivery
        if ($this->port_delivery->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dispatch_details
        if ($this->dispatch_details->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // exporter
        $this->exporter->RowCssClass = "row";

        // consignee
        $this->consignee->RowCssClass = "row";

        // consignee_other
        $this->consignee_other->RowCssClass = "row";

        // packing_list_no
        $this->packing_list_no->RowCssClass = "row";

        // d_11
        $this->d_11->RowCssClass = "row";

        // description_11
        $this->description_11->RowCssClass = "row";

        // in_template
        $this->in_template->RowCssClass = "row";

        // pl_template
        $this->pl_template->RowCssClass = "row";

        // invoice_no
        $this->invoice_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // po_no
        $this->po_no->RowCssClass = "row";

        // other_reference
        $this->other_reference->RowCssClass = "row";

        // origin
        $this->origin->RowCssClass = "row";

        // final_destination
        $this->final_destination->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // pre_carriage_receipt
        $this->pre_carriage_receipt->RowCssClass = "row";

        // place_of_receipt
        $this->place_of_receipt->RowCssClass = "row";

        // loading_port
        $this->loading_port->RowCssClass = "row";

        // port_discharge
        $this->port_discharge->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // gross_weight
        $this->gross_weight->RowCssClass = "row";

        // nett_weight
        $this->nett_weight->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // exporter_bank_details
        $this->exporter_bank_details->RowCssClass = "row";

        // intermediary_bank
        $this->intermediary_bank->RowCssClass = "row";

        // shipment_mode
        $this->shipment_mode->RowCssClass = "row";

        // ex_factory_date
        $this->ex_factory_date->RowCssClass = "row";

        // sailing_date
        $this->sailing_date->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // delivery_terms
        $this->delivery_terms->RowCssClass = "row";

        // po_date
        $this->po_date->RowCssClass = "row";

        // cart_lines
        $this->cart_lines->RowCssClass = "row";

        // pl_lines
        $this->pl_lines->RowCssClass = "row";

        // freezed
        $this->freezed->RowCssClass = "row";

        // pl_pdf
        $this->pl_pdf->RowCssClass = "row";

        // in_pdf
        $this->in_pdf->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // port_delivery
        $this->port_delivery->RowCssClass = "row";

        // dispatch_details
        $this->dispatch_details->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // exporter
            $curVal = strval($this->exporter->CurrentValue);
            if ($curVal != "") {
                $this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
                if ($this->exporter->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                    $sqlWrk = $this->exporter->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->exporter->Lookup->renderViewRow($rswrk[0]);
                        $this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
                    } else {
                        $this->exporter->ViewValue = $this->exporter->CurrentValue;
                    }
                }
            } else {
                $this->exporter->ViewValue = null;
            }

            // consignee
            $curVal = strval($this->consignee->CurrentValue);
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
                if ($this->consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                    } else {
                        $this->consignee->ViewValue = $this->consignee->CurrentValue;
                    }
                }
            } else {
                $this->consignee->ViewValue = null;
            }

            // consignee_other
            $curVal = strval($this->consignee_other->CurrentValue);
            if ($curVal != "") {
                $this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
                if ($this->consignee_other->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee_other->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
                    } else {
                        $this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
                    }
                }
            } else {
                $this->consignee_other->ViewValue = null;
            }

            // packing_list_no
            $curVal = strval($this->packing_list_no->CurrentValue);
            if ($curVal != "") {
                $this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
                if ($this->packing_list_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $curVal, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                    $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_list_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_list_no->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
                    } else {
                        $this->packing_list_no->ViewValue = FormatNumber($this->packing_list_no->CurrentValue, $this->packing_list_no->formatPattern());
                    }
                }
            } else {
                $this->packing_list_no->ViewValue = null;
            }

            // d_11
            $this->d_11->ViewValue = $this->d_11->CurrentValue;

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // in_template
            $curVal = strval($this->in_template->CurrentValue);
            if ($curVal != "") {
                $this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
                if ($this->in_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->in_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->in_template->Lookup->renderViewRow($rswrk[0]);
                        $this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
                    } else {
                        $this->in_template->ViewValue = $this->in_template->CurrentValue;
                    }
                }
            } else {
                $this->in_template->ViewValue = null;
            }

            // pl_template
            $curVal = strval($this->pl_template->CurrentValue);
            if ($curVal != "") {
                $this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
                if ($this->pl_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_template->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
                    } else {
                        $this->pl_template->ViewValue = $this->pl_template->CurrentValue;
                    }
                }
            } else {
                $this->pl_template->ViewValue = null;
            }

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // po_no
            $this->po_no->ViewValue = $this->po_no->CurrentValue;

            // other_reference
            $this->other_reference->ViewValue = $this->other_reference->CurrentValue;

            // origin
            $this->origin->ViewValue = $this->origin->CurrentValue;

            // final_destination
            $this->final_destination->ViewValue = $this->final_destination->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // pre_carriage_receipt
            $this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;

            // place_of_receipt
            $this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;

            // loading_port
            $this->loading_port->ViewValue = $this->loading_port->CurrentValue;

            // port_discharge
            $this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // description_01
            $this->description_01->ViewValue = $this->description_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // description_02
            $this->description_02->ViewValue = $this->description_02->CurrentValue;

            // gross_weight
            $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;

            // nett_weight
            $this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // exporter_bank_details
            $this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;

            // intermediary_bank
            $this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;

            // shipment_mode
            if (strval($this->shipment_mode->CurrentValue) != "") {
                $this->shipment_mode->ViewValue = $this->shipment_mode->optionCaption($this->shipment_mode->CurrentValue);
            } else {
                $this->shipment_mode->ViewValue = null;
            }

            // ex_factory_date
            $this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
            $this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, $this->ex_factory_date->formatPattern());

            // sailing_date
            $this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
            $this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, $this->sailing_date->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // cart_lines
            $this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;

            // pl_lines
            $this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;

            // freezed
            if (strval($this->freezed->CurrentValue) != "") {
                $this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
            } else {
                $this->freezed->ViewValue = null;
            }

            // a_operator
            $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
            $this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, $this->a_operator->formatPattern());

            // port_delivery
            $this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;

            // dispatch_details
            $this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // exporter
            $this->exporter->HrefValue = "";
            $this->exporter->TooltipValue = "";

            // consignee
            $this->consignee->HrefValue = "";
            $this->consignee->TooltipValue = "";

            // consignee_other
            $this->consignee_other->HrefValue = "";
            $this->consignee_other->TooltipValue = "";

            // packing_list_no
            $this->packing_list_no->HrefValue = "";
            $this->packing_list_no->TooltipValue = "";

            // d_11
            $this->d_11->HrefValue = "";
            $this->d_11->TooltipValue = "";

            // description_11
            $this->description_11->HrefValue = "";
            $this->description_11->TooltipValue = "";

            // in_template
            $this->in_template->HrefValue = "";
            $this->in_template->TooltipValue = "";

            // pl_template
            $this->pl_template->HrefValue = "";
            $this->pl_template->TooltipValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // po_no
            $this->po_no->HrefValue = "";
            $this->po_no->TooltipValue = "";

            // other_reference
            $this->other_reference->HrefValue = "";
            $this->other_reference->TooltipValue = "";

            // origin
            $this->origin->HrefValue = "";
            $this->origin->TooltipValue = "";

            // final_destination
            $this->final_destination->HrefValue = "";
            $this->final_destination->TooltipValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // pre_carriage_receipt
            $this->pre_carriage_receipt->HrefValue = "";
            $this->pre_carriage_receipt->TooltipValue = "";

            // place_of_receipt
            $this->place_of_receipt->HrefValue = "";
            $this->place_of_receipt->TooltipValue = "";

            // loading_port
            $this->loading_port->HrefValue = "";
            $this->loading_port->TooltipValue = "";

            // port_discharge
            $this->port_discharge->HrefValue = "";
            $this->port_discharge->TooltipValue = "";

            // d_01
            $this->d_01->HrefValue = "";
            $this->d_01->TooltipValue = "";

            // description_01
            $this->description_01->HrefValue = "";
            $this->description_01->TooltipValue = "";

            // d_02
            $this->d_02->HrefValue = "";
            $this->d_02->TooltipValue = "";

            // description_02
            $this->description_02->HrefValue = "";
            $this->description_02->TooltipValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";
            $this->gross_weight->TooltipValue = "";

            // nett_weight
            $this->nett_weight->HrefValue = "";
            $this->nett_weight->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // exporter_bank_details
            $this->exporter_bank_details->HrefValue = "";
            $this->exporter_bank_details->TooltipValue = "";

            // intermediary_bank
            $this->intermediary_bank->HrefValue = "";
            $this->intermediary_bank->TooltipValue = "";

            // shipment_mode
            $this->shipment_mode->HrefValue = "";
            $this->shipment_mode->TooltipValue = "";

            // ex_factory_date
            $this->ex_factory_date->HrefValue = "";
            $this->ex_factory_date->TooltipValue = "";

            // sailing_date
            $this->sailing_date->HrefValue = "";
            $this->sailing_date->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // cart_lines
            $this->cart_lines->HrefValue = "";
            $this->cart_lines->TooltipValue = "";

            // pl_lines
            $this->pl_lines->HrefValue = "";
            $this->pl_lines->TooltipValue = "";

            // freezed
            $this->freezed->HrefValue = "";
            $this->freezed->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // port_delivery
            $this->port_delivery->HrefValue = "";
            $this->port_delivery->TooltipValue = "";

            // dispatch_details
            $this->dispatch_details->HrefValue = "";
            $this->dispatch_details->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // exporter
            $this->exporter->setupEditAttributes();
            $curVal = trim(strval($this->exporter->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->exporter->AdvancedSearch->ViewValue = $this->exporter->lookupCacheOption($curVal);
            } else {
                $this->exporter->AdvancedSearch->ViewValue = $this->exporter->Lookup !== null && is_array($this->exporter->lookupOptions()) && count($this->exporter->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->exporter->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->exporter->EditValue = array_values($this->exporter->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->exporter->AdvancedSearch->SearchValue, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                $sqlWrk = $this->exporter->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->exporter->EditValue = $arwrk;
            }
            $this->exporter->PlaceHolder = RemoveHtml($this->exporter->caption());

            // consignee
            $this->consignee->setupEditAttributes();
            $curVal = trim(strval($this->consignee->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->consignee->AdvancedSearch->ViewValue = $this->consignee->lookupCacheOption($curVal);
            } else {
                $this->consignee->AdvancedSearch->ViewValue = $this->consignee->Lookup !== null && is_array($this->consignee->lookupOptions()) && count($this->consignee->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->consignee->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->consignee->EditValue = array_values($this->consignee->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->consignee->AdvancedSearch->SearchValue, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->consignee->EditValue = $arwrk;
            }
            $this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());

            // consignee_other
            $this->consignee_other->setupEditAttributes();
            $curVal = trim(strval($this->consignee_other->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->consignee_other->AdvancedSearch->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
            } else {
                $this->consignee_other->AdvancedSearch->ViewValue = $this->consignee_other->Lookup !== null && is_array($this->consignee_other->lookupOptions()) && count($this->consignee_other->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->consignee_other->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->consignee_other->EditValue = array_values($this->consignee_other->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->consignee_other->AdvancedSearch->SearchValue, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee_other->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->consignee_other->EditValue = $arwrk;
            }
            $this->consignee_other->PlaceHolder = RemoveHtml($this->consignee_other->caption());

            // packing_list_no
            $this->packing_list_no->setupEditAttributes();
            $curVal = trim(strval($this->packing_list_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_list_no->AdvancedSearch->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
            } else {
                $this->packing_list_no->AdvancedSearch->ViewValue = $this->packing_list_no->Lookup !== null && is_array($this->packing_list_no->lookupOptions()) && count($this->packing_list_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_list_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_list_no->EditValue = array_values($this->packing_list_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $this->packing_list_no->AdvancedSearch->SearchValue, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_list_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->packing_list_no->Lookup->renderViewRow($row);
                }
                $this->packing_list_no->EditValue = $arwrk;
            }
            $this->packing_list_no->PlaceHolder = RemoveHtml($this->packing_list_no->caption());

            // d_11
            $this->d_11->setupEditAttributes();
            if (!$this->d_11->Raw) {
                $this->d_11->AdvancedSearch->SearchValue = HtmlDecode($this->d_11->AdvancedSearch->SearchValue);
            }
            $this->d_11->EditValue = HtmlEncode($this->d_11->AdvancedSearch->SearchValue);
            $this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

            // description_11
            $this->description_11->setupEditAttributes();
            $this->description_11->EditValue = HtmlEncode($this->description_11->AdvancedSearch->SearchValue);
            $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

            // in_template
            $this->in_template->setupEditAttributes();
            $curVal = trim(strval($this->in_template->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->in_template->AdvancedSearch->ViewValue = $this->in_template->lookupCacheOption($curVal);
            } else {
                $this->in_template->AdvancedSearch->ViewValue = $this->in_template->Lookup !== null && is_array($this->in_template->lookupOptions()) && count($this->in_template->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->in_template->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->in_template->EditValue = array_values($this->in_template->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->in_template->AdvancedSearch->SearchValue, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                $sqlWrk = $this->in_template->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->in_template->EditValue = $arwrk;
            }
            $this->in_template->PlaceHolder = RemoveHtml($this->in_template->caption());

            // pl_template
            $this->pl_template->setupEditAttributes();
            $curVal = trim(strval($this->pl_template->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pl_template->AdvancedSearch->ViewValue = $this->pl_template->lookupCacheOption($curVal);
            } else {
                $this->pl_template->AdvancedSearch->ViewValue = $this->pl_template->Lookup !== null && is_array($this->pl_template->lookupOptions()) && count($this->pl_template->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_template->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pl_template->EditValue = array_values($this->pl_template->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_template->AdvancedSearch->SearchValue, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_template->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_template->EditValue = $arwrk;
            }
            $this->pl_template->PlaceHolder = RemoveHtml($this->pl_template->caption());

            // invoice_no
            $this->invoice_no->setupEditAttributes();
            if (!$this->invoice_no->Raw) {
                $this->invoice_no->AdvancedSearch->SearchValue = HtmlDecode($this->invoice_no->AdvancedSearch->SearchValue);
            }
            $this->invoice_no->EditValue = HtmlEncode($this->invoice_no->AdvancedSearch->SearchValue);
            $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern()), $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // po_no
            $this->po_no->setupEditAttributes();
            $this->po_no->EditValue = HtmlEncode($this->po_no->AdvancedSearch->SearchValue);
            $this->po_no->PlaceHolder = RemoveHtml($this->po_no->caption());

            // other_reference
            $this->other_reference->setupEditAttributes();
            if (!$this->other_reference->Raw) {
                $this->other_reference->AdvancedSearch->SearchValue = HtmlDecode($this->other_reference->AdvancedSearch->SearchValue);
            }
            $this->other_reference->EditValue = HtmlEncode($this->other_reference->AdvancedSearch->SearchValue);
            $this->other_reference->PlaceHolder = RemoveHtml($this->other_reference->caption());

            // origin
            $this->origin->setupEditAttributes();
            if (!$this->origin->Raw) {
                $this->origin->AdvancedSearch->SearchValue = HtmlDecode($this->origin->AdvancedSearch->SearchValue);
            }
            $this->origin->EditValue = HtmlEncode($this->origin->AdvancedSearch->SearchValue);
            $this->origin->PlaceHolder = RemoveHtml($this->origin->caption());

            // final_destination
            $this->final_destination->setupEditAttributes();
            if (!$this->final_destination->Raw) {
                $this->final_destination->AdvancedSearch->SearchValue = HtmlDecode($this->final_destination->AdvancedSearch->SearchValue);
            }
            $this->final_destination->EditValue = HtmlEncode($this->final_destination->AdvancedSearch->SearchValue);
            $this->final_destination->PlaceHolder = RemoveHtml($this->final_destination->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $this->payment_terms->EditValue = HtmlEncode($this->payment_terms->AdvancedSearch->SearchValue);
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // pre_carriage_receipt
            $this->pre_carriage_receipt->setupEditAttributes();
            if (!$this->pre_carriage_receipt->Raw) {
                $this->pre_carriage_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->pre_carriage_receipt->AdvancedSearch->SearchValue);
            }
            $this->pre_carriage_receipt->EditValue = HtmlEncode($this->pre_carriage_receipt->AdvancedSearch->SearchValue);
            $this->pre_carriage_receipt->PlaceHolder = RemoveHtml($this->pre_carriage_receipt->caption());

            // place_of_receipt
            $this->place_of_receipt->setupEditAttributes();
            if (!$this->place_of_receipt->Raw) {
                $this->place_of_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->place_of_receipt->AdvancedSearch->SearchValue);
            }
            $this->place_of_receipt->EditValue = HtmlEncode($this->place_of_receipt->AdvancedSearch->SearchValue);
            $this->place_of_receipt->PlaceHolder = RemoveHtml($this->place_of_receipt->caption());

            // loading_port
            $this->loading_port->setupEditAttributes();
            if (!$this->loading_port->Raw) {
                $this->loading_port->AdvancedSearch->SearchValue = HtmlDecode($this->loading_port->AdvancedSearch->SearchValue);
            }
            $this->loading_port->EditValue = HtmlEncode($this->loading_port->AdvancedSearch->SearchValue);
            $this->loading_port->PlaceHolder = RemoveHtml($this->loading_port->caption());

            // port_discharge
            $this->port_discharge->setupEditAttributes();
            if (!$this->port_discharge->Raw) {
                $this->port_discharge->AdvancedSearch->SearchValue = HtmlDecode($this->port_discharge->AdvancedSearch->SearchValue);
            }
            $this->port_discharge->EditValue = HtmlEncode($this->port_discharge->AdvancedSearch->SearchValue);
            $this->port_discharge->PlaceHolder = RemoveHtml($this->port_discharge->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->AdvancedSearch->SearchValue = HtmlDecode($this->d_01->AdvancedSearch->SearchValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->AdvancedSearch->SearchValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // description_01
            $this->description_01->setupEditAttributes();
            if (!$this->description_01->Raw) {
                $this->description_01->AdvancedSearch->SearchValue = HtmlDecode($this->description_01->AdvancedSearch->SearchValue);
            }
            $this->description_01->EditValue = HtmlEncode($this->description_01->AdvancedSearch->SearchValue);
            $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->AdvancedSearch->SearchValue = HtmlDecode($this->d_02->AdvancedSearch->SearchValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->AdvancedSearch->SearchValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // description_02
            $this->description_02->setupEditAttributes();
            if (!$this->description_02->Raw) {
                $this->description_02->AdvancedSearch->SearchValue = HtmlDecode($this->description_02->AdvancedSearch->SearchValue);
            }
            $this->description_02->EditValue = HtmlEncode($this->description_02->AdvancedSearch->SearchValue);
            $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

            // gross_weight
            $this->gross_weight->setupEditAttributes();
            if (!$this->gross_weight->Raw) {
                $this->gross_weight->AdvancedSearch->SearchValue = HtmlDecode($this->gross_weight->AdvancedSearch->SearchValue);
            }
            $this->gross_weight->EditValue = HtmlEncode($this->gross_weight->AdvancedSearch->SearchValue);
            $this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

            // nett_weight
            $this->nett_weight->setupEditAttributes();
            if (!$this->nett_weight->Raw) {
                $this->nett_weight->AdvancedSearch->SearchValue = HtmlDecode($this->nett_weight->AdvancedSearch->SearchValue);
            }
            $this->nett_weight->EditValue = HtmlEncode($this->nett_weight->AdvancedSearch->SearchValue);
            $this->nett_weight->PlaceHolder = RemoveHtml($this->nett_weight->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            if (!$this->cbm->Raw) {
                $this->cbm->AdvancedSearch->SearchValue = HtmlDecode($this->cbm->AdvancedSearch->SearchValue);
            }
            $this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // exporter_bank_details
            $this->exporter_bank_details->setupEditAttributes();
            $this->exporter_bank_details->EditValue = HtmlEncode($this->exporter_bank_details->AdvancedSearch->SearchValue);
            $this->exporter_bank_details->PlaceHolder = RemoveHtml($this->exporter_bank_details->caption());

            // intermediary_bank
            $this->intermediary_bank->setupEditAttributes();
            $this->intermediary_bank->EditValue = HtmlEncode($this->intermediary_bank->AdvancedSearch->SearchValue);
            $this->intermediary_bank->PlaceHolder = RemoveHtml($this->intermediary_bank->caption());

            // shipment_mode
            $this->shipment_mode->setupEditAttributes();
            $this->shipment_mode->EditValue = $this->shipment_mode->options(true);
            $this->shipment_mode->PlaceHolder = RemoveHtml($this->shipment_mode->caption());

            // ex_factory_date
            $this->ex_factory_date->setupEditAttributes();
            $this->ex_factory_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->ex_factory_date->AdvancedSearch->SearchValue, $this->ex_factory_date->formatPattern()), $this->ex_factory_date->formatPattern()));
            $this->ex_factory_date->PlaceHolder = RemoveHtml($this->ex_factory_date->caption());

            // sailing_date
            $this->sailing_date->setupEditAttributes();
            $this->sailing_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->sailing_date->AdvancedSearch->SearchValue, $this->sailing_date->formatPattern()), $this->sailing_date->formatPattern()));
            $this->sailing_date->PlaceHolder = RemoveHtml($this->sailing_date->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // cart_lines
            $this->cart_lines->setupEditAttributes();
            if (!$this->cart_lines->Raw) {
                $this->cart_lines->AdvancedSearch->SearchValue = HtmlDecode($this->cart_lines->AdvancedSearch->SearchValue);
            }
            $this->cart_lines->EditValue = HtmlEncode($this->cart_lines->AdvancedSearch->SearchValue);
            $this->cart_lines->PlaceHolder = RemoveHtml($this->cart_lines->caption());

            // pl_lines
            $this->pl_lines->setupEditAttributes();
            if (!$this->pl_lines->Raw) {
                $this->pl_lines->AdvancedSearch->SearchValue = HtmlDecode($this->pl_lines->AdvancedSearch->SearchValue);
            }
            $this->pl_lines->EditValue = HtmlEncode($this->pl_lines->AdvancedSearch->SearchValue);
            $this->pl_lines->PlaceHolder = RemoveHtml($this->pl_lines->caption());

            // freezed
            $this->freezed->setupEditAttributes();
            $this->freezed->EditValue = $this->freezed->options(true);
            $this->freezed->PlaceHolder = RemoveHtml($this->freezed->caption());

            // a_operator
            $this->a_operator->setupEditAttributes();
            $this->a_operator->EditValue = $this->a_operator->AdvancedSearch->SearchValue;
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

            // port_delivery
            $this->port_delivery->setupEditAttributes();
            if (!$this->port_delivery->Raw) {
                $this->port_delivery->AdvancedSearch->SearchValue = HtmlDecode($this->port_delivery->AdvancedSearch->SearchValue);
            }
            $this->port_delivery->EditValue = HtmlEncode($this->port_delivery->AdvancedSearch->SearchValue);
            $this->port_delivery->PlaceHolder = RemoveHtml($this->port_delivery->caption());

            // dispatch_details
            $this->dispatch_details->setupEditAttributes();
            if (!$this->dispatch_details->Raw) {
                $this->dispatch_details->AdvancedSearch->SearchValue = HtmlDecode($this->dispatch_details->AdvancedSearch->SearchValue);
            }
            $this->dispatch_details->EditValue = HtmlEncode($this->dispatch_details->AdvancedSearch->SearchValue);
            $this->dispatch_details->PlaceHolder = RemoveHtml($this->dispatch_details->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern())) {
            $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
        }
        if (!CheckDate($this->ex_factory_date->AdvancedSearch->SearchValue, $this->ex_factory_date->formatPattern())) {
            $this->ex_factory_date->addErrorMessage($this->ex_factory_date->getErrorMessage(false));
        }
        if (!CheckDate($this->sailing_date->AdvancedSearch->SearchValue, $this->sailing_date->formatPattern())) {
            $this->sailing_date->addErrorMessage($this->sailing_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->a_operator->AdvancedSearch->SearchValue)) {
            $this->a_operator->addErrorMessage($this->a_operator->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->exporter->AdvancedSearch->load();
        $this->consignee->AdvancedSearch->load();
        $this->consignee_other->AdvancedSearch->load();
        $this->packing_list_no->AdvancedSearch->load();
        $this->d_11->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->in_template->AdvancedSearch->load();
        $this->pl_template->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->po_no->AdvancedSearch->load();
        $this->other_reference->AdvancedSearch->load();
        $this->origin->AdvancedSearch->load();
        $this->final_destination->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->pre_carriage_receipt->AdvancedSearch->load();
        $this->place_of_receipt->AdvancedSearch->load();
        $this->loading_port->AdvancedSearch->load();
        $this->port_discharge->AdvancedSearch->load();
        $this->d_01->AdvancedSearch->load();
        $this->description_01->AdvancedSearch->load();
        $this->d_02->AdvancedSearch->load();
        $this->description_02->AdvancedSearch->load();
        $this->gross_weight->AdvancedSearch->load();
        $this->nett_weight->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->exporter_bank_details->AdvancedSearch->load();
        $this->intermediary_bank->AdvancedSearch->load();
        $this->shipment_mode->AdvancedSearch->load();
        $this->ex_factory_date->AdvancedSearch->load();
        $this->sailing_date->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->cart_lines->AdvancedSearch->load();
        $this->pl_lines->AdvancedSearch->load();
        $this->freezed->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->port_delivery->AdvancedSearch->load();
        $this->dispatch_details->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("invoicedetailslist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_exporter":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee_other":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_list_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_in_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipment_mode":
                    break;
                case "x_freezed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
