<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class InvoiceDetailsList extends InvoiceDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InvoiceDetailsList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "finvoice_detailslist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "invoicedetailslist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->_barcode->Visible = false;
        $this->exporter->setVisibility();
        $this->consignee->setVisibility();
        $this->consignee_other->setVisibility();
        $this->packing_list_no->setVisibility();
        $this->d_11->setVisibility();
        $this->description_11->Visible = false;
        $this->in_template->setVisibility();
        $this->pl_template->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->po_no->setVisibility();
        $this->other_reference->setVisibility();
        $this->origin->setVisibility();
        $this->final_destination->setVisibility();
        $this->payment_terms->setVisibility();
        $this->pre_carriage_receipt->setVisibility();
        $this->place_of_receipt->setVisibility();
        $this->loading_port->setVisibility();
        $this->port_discharge->setVisibility();
        $this->d_01->setVisibility();
        $this->description_01->setVisibility();
        $this->d_02->setVisibility();
        $this->description_02->setVisibility();
        $this->gross_weight->setVisibility();
        $this->nett_weight->setVisibility();
        $this->cbm->setVisibility();
        $this->exporter_bank_details->Visible = false;
        $this->intermediary_bank->Visible = false;
        $this->shipment_mode->setVisibility();
        $this->ex_factory_date->setVisibility();
        $this->sailing_date->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->delivery_terms->Visible = false;
        $this->po_date->Visible = false;
        $this->cart_lines->setVisibility();
        $this->pl_lines->setVisibility();
        $this->freezed->setVisibility();
        $this->pl_pdf->Visible = false;
        $this->in_pdf->Visible = false;
        $this->a_operator->setVisibility();
        $this->port_delivery->setVisibility();
        $this->dispatch_details->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'invoice_details';
        $this->TableName = 'invoice_details';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (invoice_details)
        if (!isset($GLOBALS["invoice_details"]) || $GLOBALS["invoice_details"]::class == PROJECT_NAMESPACE . "invoice_details") {
            $GLOBALS["invoice_details"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "invoicedetailsadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "invoicedetailsdelete";
        $this->MultiUpdateUrl = "invoicedetailsupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "invoicedetailsview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->exporter);
        $this->setupLookupOptions($this->consignee);
        $this->setupLookupOptions($this->consignee_other);
        $this->setupLookupOptions($this->packing_list_no);
        $this->setupLookupOptions($this->in_template);
        $this->setupLookupOptions($this->pl_template);
        $this->setupLookupOptions($this->shipment_mode);
        $this->setupLookupOptions($this->freezed);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "finvoice_detailsgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("finvoice_detailssrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
        $filterList = Concat($filterList, $this->exporter->AdvancedSearch->toJson(), ","); // Field exporter
        $filterList = Concat($filterList, $this->consignee->AdvancedSearch->toJson(), ","); // Field consignee
        $filterList = Concat($filterList, $this->consignee_other->AdvancedSearch->toJson(), ","); // Field consignee_other
        $filterList = Concat($filterList, $this->packing_list_no->AdvancedSearch->toJson(), ","); // Field packing_list_no
        $filterList = Concat($filterList, $this->d_11->AdvancedSearch->toJson(), ","); // Field d_11
        $filterList = Concat($filterList, $this->description_11->AdvancedSearch->toJson(), ","); // Field description_11
        $filterList = Concat($filterList, $this->in_template->AdvancedSearch->toJson(), ","); // Field in_template
        $filterList = Concat($filterList, $this->pl_template->AdvancedSearch->toJson(), ","); // Field pl_template
        $filterList = Concat($filterList, $this->invoice_no->AdvancedSearch->toJson(), ","); // Field invoice_no
        $filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
        $filterList = Concat($filterList, $this->po_no->AdvancedSearch->toJson(), ","); // Field po_no
        $filterList = Concat($filterList, $this->other_reference->AdvancedSearch->toJson(), ","); // Field other_reference
        $filterList = Concat($filterList, $this->origin->AdvancedSearch->toJson(), ","); // Field origin
        $filterList = Concat($filterList, $this->final_destination->AdvancedSearch->toJson(), ","); // Field final_destination
        $filterList = Concat($filterList, $this->payment_terms->AdvancedSearch->toJson(), ","); // Field payment_terms
        $filterList = Concat($filterList, $this->pre_carriage_receipt->AdvancedSearch->toJson(), ","); // Field pre_carriage_receipt
        $filterList = Concat($filterList, $this->place_of_receipt->AdvancedSearch->toJson(), ","); // Field place_of_receipt
        $filterList = Concat($filterList, $this->loading_port->AdvancedSearch->toJson(), ","); // Field loading_port
        $filterList = Concat($filterList, $this->port_discharge->AdvancedSearch->toJson(), ","); // Field port_discharge
        $filterList = Concat($filterList, $this->d_01->AdvancedSearch->toJson(), ","); // Field d_01
        $filterList = Concat($filterList, $this->description_01->AdvancedSearch->toJson(), ","); // Field description_01
        $filterList = Concat($filterList, $this->d_02->AdvancedSearch->toJson(), ","); // Field d_02
        $filterList = Concat($filterList, $this->description_02->AdvancedSearch->toJson(), ","); // Field description_02
        $filterList = Concat($filterList, $this->gross_weight->AdvancedSearch->toJson(), ","); // Field gross_weight
        $filterList = Concat($filterList, $this->nett_weight->AdvancedSearch->toJson(), ","); // Field nett_weight
        $filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
        $filterList = Concat($filterList, $this->exporter_bank_details->AdvancedSearch->toJson(), ","); // Field exporter_bank_details
        $filterList = Concat($filterList, $this->intermediary_bank->AdvancedSearch->toJson(), ","); // Field intermediary_bank
        $filterList = Concat($filterList, $this->shipment_mode->AdvancedSearch->toJson(), ","); // Field shipment_mode
        $filterList = Concat($filterList, $this->ex_factory_date->AdvancedSearch->toJson(), ","); // Field ex_factory_date
        $filterList = Concat($filterList, $this->sailing_date->AdvancedSearch->toJson(), ","); // Field sailing_date
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->cart_lines->AdvancedSearch->toJson(), ","); // Field cart_lines
        $filterList = Concat($filterList, $this->pl_lines->AdvancedSearch->toJson(), ","); // Field pl_lines
        $filterList = Concat($filterList, $this->freezed->AdvancedSearch->toJson(), ","); // Field freezed
        $filterList = Concat($filterList, $this->a_operator->AdvancedSearch->toJson(), ","); // Field a_operator
        $filterList = Concat($filterList, $this->port_delivery->AdvancedSearch->toJson(), ","); // Field port_delivery
        $filterList = Concat($filterList, $this->dispatch_details->AdvancedSearch->toJson(), ","); // Field dispatch_details
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("finvoice_detailssrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field barcode
        $this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
        $this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
        $this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
        $this->_barcode->AdvancedSearch->save();

        // Field exporter
        $this->exporter->AdvancedSearch->SearchValue = @$filter["x_exporter"];
        $this->exporter->AdvancedSearch->SearchOperator = @$filter["z_exporter"];
        $this->exporter->AdvancedSearch->SearchCondition = @$filter["v_exporter"];
        $this->exporter->AdvancedSearch->SearchValue2 = @$filter["y_exporter"];
        $this->exporter->AdvancedSearch->SearchOperator2 = @$filter["w_exporter"];
        $this->exporter->AdvancedSearch->save();

        // Field consignee
        $this->consignee->AdvancedSearch->SearchValue = @$filter["x_consignee"];
        $this->consignee->AdvancedSearch->SearchOperator = @$filter["z_consignee"];
        $this->consignee->AdvancedSearch->SearchCondition = @$filter["v_consignee"];
        $this->consignee->AdvancedSearch->SearchValue2 = @$filter["y_consignee"];
        $this->consignee->AdvancedSearch->SearchOperator2 = @$filter["w_consignee"];
        $this->consignee->AdvancedSearch->save();

        // Field consignee_other
        $this->consignee_other->AdvancedSearch->SearchValue = @$filter["x_consignee_other"];
        $this->consignee_other->AdvancedSearch->SearchOperator = @$filter["z_consignee_other"];
        $this->consignee_other->AdvancedSearch->SearchCondition = @$filter["v_consignee_other"];
        $this->consignee_other->AdvancedSearch->SearchValue2 = @$filter["y_consignee_other"];
        $this->consignee_other->AdvancedSearch->SearchOperator2 = @$filter["w_consignee_other"];
        $this->consignee_other->AdvancedSearch->save();

        // Field packing_list_no
        $this->packing_list_no->AdvancedSearch->SearchValue = @$filter["x_packing_list_no"];
        $this->packing_list_no->AdvancedSearch->SearchOperator = @$filter["z_packing_list_no"];
        $this->packing_list_no->AdvancedSearch->SearchCondition = @$filter["v_packing_list_no"];
        $this->packing_list_no->AdvancedSearch->SearchValue2 = @$filter["y_packing_list_no"];
        $this->packing_list_no->AdvancedSearch->SearchOperator2 = @$filter["w_packing_list_no"];
        $this->packing_list_no->AdvancedSearch->save();

        // Field d_11
        $this->d_11->AdvancedSearch->SearchValue = @$filter["x_d_11"];
        $this->d_11->AdvancedSearch->SearchOperator = @$filter["z_d_11"];
        $this->d_11->AdvancedSearch->SearchCondition = @$filter["v_d_11"];
        $this->d_11->AdvancedSearch->SearchValue2 = @$filter["y_d_11"];
        $this->d_11->AdvancedSearch->SearchOperator2 = @$filter["w_d_11"];
        $this->d_11->AdvancedSearch->save();

        // Field description_11
        $this->description_11->AdvancedSearch->SearchValue = @$filter["x_description_11"];
        $this->description_11->AdvancedSearch->SearchOperator = @$filter["z_description_11"];
        $this->description_11->AdvancedSearch->SearchCondition = @$filter["v_description_11"];
        $this->description_11->AdvancedSearch->SearchValue2 = @$filter["y_description_11"];
        $this->description_11->AdvancedSearch->SearchOperator2 = @$filter["w_description_11"];
        $this->description_11->AdvancedSearch->save();

        // Field in_template
        $this->in_template->AdvancedSearch->SearchValue = @$filter["x_in_template"];
        $this->in_template->AdvancedSearch->SearchOperator = @$filter["z_in_template"];
        $this->in_template->AdvancedSearch->SearchCondition = @$filter["v_in_template"];
        $this->in_template->AdvancedSearch->SearchValue2 = @$filter["y_in_template"];
        $this->in_template->AdvancedSearch->SearchOperator2 = @$filter["w_in_template"];
        $this->in_template->AdvancedSearch->save();

        // Field pl_template
        $this->pl_template->AdvancedSearch->SearchValue = @$filter["x_pl_template"];
        $this->pl_template->AdvancedSearch->SearchOperator = @$filter["z_pl_template"];
        $this->pl_template->AdvancedSearch->SearchCondition = @$filter["v_pl_template"];
        $this->pl_template->AdvancedSearch->SearchValue2 = @$filter["y_pl_template"];
        $this->pl_template->AdvancedSearch->SearchOperator2 = @$filter["w_pl_template"];
        $this->pl_template->AdvancedSearch->save();

        // Field invoice_no
        $this->invoice_no->AdvancedSearch->SearchValue = @$filter["x_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchOperator = @$filter["z_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchCondition = @$filter["v_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchValue2 = @$filter["y_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_no"];
        $this->invoice_no->AdvancedSearch->save();

        // Field invoice_date
        $this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
        $this->invoice_date->AdvancedSearch->save();

        // Field po_no
        $this->po_no->AdvancedSearch->SearchValue = @$filter["x_po_no"];
        $this->po_no->AdvancedSearch->SearchOperator = @$filter["z_po_no"];
        $this->po_no->AdvancedSearch->SearchCondition = @$filter["v_po_no"];
        $this->po_no->AdvancedSearch->SearchValue2 = @$filter["y_po_no"];
        $this->po_no->AdvancedSearch->SearchOperator2 = @$filter["w_po_no"];
        $this->po_no->AdvancedSearch->save();

        // Field other_reference
        $this->other_reference->AdvancedSearch->SearchValue = @$filter["x_other_reference"];
        $this->other_reference->AdvancedSearch->SearchOperator = @$filter["z_other_reference"];
        $this->other_reference->AdvancedSearch->SearchCondition = @$filter["v_other_reference"];
        $this->other_reference->AdvancedSearch->SearchValue2 = @$filter["y_other_reference"];
        $this->other_reference->AdvancedSearch->SearchOperator2 = @$filter["w_other_reference"];
        $this->other_reference->AdvancedSearch->save();

        // Field origin
        $this->origin->AdvancedSearch->SearchValue = @$filter["x_origin"];
        $this->origin->AdvancedSearch->SearchOperator = @$filter["z_origin"];
        $this->origin->AdvancedSearch->SearchCondition = @$filter["v_origin"];
        $this->origin->AdvancedSearch->SearchValue2 = @$filter["y_origin"];
        $this->origin->AdvancedSearch->SearchOperator2 = @$filter["w_origin"];
        $this->origin->AdvancedSearch->save();

        // Field final_destination
        $this->final_destination->AdvancedSearch->SearchValue = @$filter["x_final_destination"];
        $this->final_destination->AdvancedSearch->SearchOperator = @$filter["z_final_destination"];
        $this->final_destination->AdvancedSearch->SearchCondition = @$filter["v_final_destination"];
        $this->final_destination->AdvancedSearch->SearchValue2 = @$filter["y_final_destination"];
        $this->final_destination->AdvancedSearch->SearchOperator2 = @$filter["w_final_destination"];
        $this->final_destination->AdvancedSearch->save();

        // Field payment_terms
        $this->payment_terms->AdvancedSearch->SearchValue = @$filter["x_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator = @$filter["z_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchCondition = @$filter["v_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchValue2 = @$filter["y_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator2 = @$filter["w_payment_terms"];
        $this->payment_terms->AdvancedSearch->save();

        // Field pre_carriage_receipt
        $this->pre_carriage_receipt->AdvancedSearch->SearchValue = @$filter["x_pre_carriage_receipt"];
        $this->pre_carriage_receipt->AdvancedSearch->SearchOperator = @$filter["z_pre_carriage_receipt"];
        $this->pre_carriage_receipt->AdvancedSearch->SearchCondition = @$filter["v_pre_carriage_receipt"];
        $this->pre_carriage_receipt->AdvancedSearch->SearchValue2 = @$filter["y_pre_carriage_receipt"];
        $this->pre_carriage_receipt->AdvancedSearch->SearchOperator2 = @$filter["w_pre_carriage_receipt"];
        $this->pre_carriage_receipt->AdvancedSearch->save();

        // Field place_of_receipt
        $this->place_of_receipt->AdvancedSearch->SearchValue = @$filter["x_place_of_receipt"];
        $this->place_of_receipt->AdvancedSearch->SearchOperator = @$filter["z_place_of_receipt"];
        $this->place_of_receipt->AdvancedSearch->SearchCondition = @$filter["v_place_of_receipt"];
        $this->place_of_receipt->AdvancedSearch->SearchValue2 = @$filter["y_place_of_receipt"];
        $this->place_of_receipt->AdvancedSearch->SearchOperator2 = @$filter["w_place_of_receipt"];
        $this->place_of_receipt->AdvancedSearch->save();

        // Field loading_port
        $this->loading_port->AdvancedSearch->SearchValue = @$filter["x_loading_port"];
        $this->loading_port->AdvancedSearch->SearchOperator = @$filter["z_loading_port"];
        $this->loading_port->AdvancedSearch->SearchCondition = @$filter["v_loading_port"];
        $this->loading_port->AdvancedSearch->SearchValue2 = @$filter["y_loading_port"];
        $this->loading_port->AdvancedSearch->SearchOperator2 = @$filter["w_loading_port"];
        $this->loading_port->AdvancedSearch->save();

        // Field port_discharge
        $this->port_discharge->AdvancedSearch->SearchValue = @$filter["x_port_discharge"];
        $this->port_discharge->AdvancedSearch->SearchOperator = @$filter["z_port_discharge"];
        $this->port_discharge->AdvancedSearch->SearchCondition = @$filter["v_port_discharge"];
        $this->port_discharge->AdvancedSearch->SearchValue2 = @$filter["y_port_discharge"];
        $this->port_discharge->AdvancedSearch->SearchOperator2 = @$filter["w_port_discharge"];
        $this->port_discharge->AdvancedSearch->save();

        // Field d_01
        $this->d_01->AdvancedSearch->SearchValue = @$filter["x_d_01"];
        $this->d_01->AdvancedSearch->SearchOperator = @$filter["z_d_01"];
        $this->d_01->AdvancedSearch->SearchCondition = @$filter["v_d_01"];
        $this->d_01->AdvancedSearch->SearchValue2 = @$filter["y_d_01"];
        $this->d_01->AdvancedSearch->SearchOperator2 = @$filter["w_d_01"];
        $this->d_01->AdvancedSearch->save();

        // Field description_01
        $this->description_01->AdvancedSearch->SearchValue = @$filter["x_description_01"];
        $this->description_01->AdvancedSearch->SearchOperator = @$filter["z_description_01"];
        $this->description_01->AdvancedSearch->SearchCondition = @$filter["v_description_01"];
        $this->description_01->AdvancedSearch->SearchValue2 = @$filter["y_description_01"];
        $this->description_01->AdvancedSearch->SearchOperator2 = @$filter["w_description_01"];
        $this->description_01->AdvancedSearch->save();

        // Field d_02
        $this->d_02->AdvancedSearch->SearchValue = @$filter["x_d_02"];
        $this->d_02->AdvancedSearch->SearchOperator = @$filter["z_d_02"];
        $this->d_02->AdvancedSearch->SearchCondition = @$filter["v_d_02"];
        $this->d_02->AdvancedSearch->SearchValue2 = @$filter["y_d_02"];
        $this->d_02->AdvancedSearch->SearchOperator2 = @$filter["w_d_02"];
        $this->d_02->AdvancedSearch->save();

        // Field description_02
        $this->description_02->AdvancedSearch->SearchValue = @$filter["x_description_02"];
        $this->description_02->AdvancedSearch->SearchOperator = @$filter["z_description_02"];
        $this->description_02->AdvancedSearch->SearchCondition = @$filter["v_description_02"];
        $this->description_02->AdvancedSearch->SearchValue2 = @$filter["y_description_02"];
        $this->description_02->AdvancedSearch->SearchOperator2 = @$filter["w_description_02"];
        $this->description_02->AdvancedSearch->save();

        // Field gross_weight
        $this->gross_weight->AdvancedSearch->SearchValue = @$filter["x_gross_weight"];
        $this->gross_weight->AdvancedSearch->SearchOperator = @$filter["z_gross_weight"];
        $this->gross_weight->AdvancedSearch->SearchCondition = @$filter["v_gross_weight"];
        $this->gross_weight->AdvancedSearch->SearchValue2 = @$filter["y_gross_weight"];
        $this->gross_weight->AdvancedSearch->SearchOperator2 = @$filter["w_gross_weight"];
        $this->gross_weight->AdvancedSearch->save();

        // Field nett_weight
        $this->nett_weight->AdvancedSearch->SearchValue = @$filter["x_nett_weight"];
        $this->nett_weight->AdvancedSearch->SearchOperator = @$filter["z_nett_weight"];
        $this->nett_weight->AdvancedSearch->SearchCondition = @$filter["v_nett_weight"];
        $this->nett_weight->AdvancedSearch->SearchValue2 = @$filter["y_nett_weight"];
        $this->nett_weight->AdvancedSearch->SearchOperator2 = @$filter["w_nett_weight"];
        $this->nett_weight->AdvancedSearch->save();

        // Field cbm
        $this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
        $this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
        $this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
        $this->cbm->AdvancedSearch->save();

        // Field exporter_bank_details
        $this->exporter_bank_details->AdvancedSearch->SearchValue = @$filter["x_exporter_bank_details"];
        $this->exporter_bank_details->AdvancedSearch->SearchOperator = @$filter["z_exporter_bank_details"];
        $this->exporter_bank_details->AdvancedSearch->SearchCondition = @$filter["v_exporter_bank_details"];
        $this->exporter_bank_details->AdvancedSearch->SearchValue2 = @$filter["y_exporter_bank_details"];
        $this->exporter_bank_details->AdvancedSearch->SearchOperator2 = @$filter["w_exporter_bank_details"];
        $this->exporter_bank_details->AdvancedSearch->save();

        // Field intermediary_bank
        $this->intermediary_bank->AdvancedSearch->SearchValue = @$filter["x_intermediary_bank"];
        $this->intermediary_bank->AdvancedSearch->SearchOperator = @$filter["z_intermediary_bank"];
        $this->intermediary_bank->AdvancedSearch->SearchCondition = @$filter["v_intermediary_bank"];
        $this->intermediary_bank->AdvancedSearch->SearchValue2 = @$filter["y_intermediary_bank"];
        $this->intermediary_bank->AdvancedSearch->SearchOperator2 = @$filter["w_intermediary_bank"];
        $this->intermediary_bank->AdvancedSearch->save();

        // Field shipment_mode
        $this->shipment_mode->AdvancedSearch->SearchValue = @$filter["x_shipment_mode"];
        $this->shipment_mode->AdvancedSearch->SearchOperator = @$filter["z_shipment_mode"];
        $this->shipment_mode->AdvancedSearch->SearchCondition = @$filter["v_shipment_mode"];
        $this->shipment_mode->AdvancedSearch->SearchValue2 = @$filter["y_shipment_mode"];
        $this->shipment_mode->AdvancedSearch->SearchOperator2 = @$filter["w_shipment_mode"];
        $this->shipment_mode->AdvancedSearch->save();

        // Field ex_factory_date
        $this->ex_factory_date->AdvancedSearch->SearchValue = @$filter["x_ex_factory_date"];
        $this->ex_factory_date->AdvancedSearch->SearchOperator = @$filter["z_ex_factory_date"];
        $this->ex_factory_date->AdvancedSearch->SearchCondition = @$filter["v_ex_factory_date"];
        $this->ex_factory_date->AdvancedSearch->SearchValue2 = @$filter["y_ex_factory_date"];
        $this->ex_factory_date->AdvancedSearch->SearchOperator2 = @$filter["w_ex_factory_date"];
        $this->ex_factory_date->AdvancedSearch->save();

        // Field sailing_date
        $this->sailing_date->AdvancedSearch->SearchValue = @$filter["x_sailing_date"];
        $this->sailing_date->AdvancedSearch->SearchOperator = @$filter["z_sailing_date"];
        $this->sailing_date->AdvancedSearch->SearchCondition = @$filter["v_sailing_date"];
        $this->sailing_date->AdvancedSearch->SearchValue2 = @$filter["y_sailing_date"];
        $this->sailing_date->AdvancedSearch->SearchOperator2 = @$filter["w_sailing_date"];
        $this->sailing_date->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field cart_lines
        $this->cart_lines->AdvancedSearch->SearchValue = @$filter["x_cart_lines"];
        $this->cart_lines->AdvancedSearch->SearchOperator = @$filter["z_cart_lines"];
        $this->cart_lines->AdvancedSearch->SearchCondition = @$filter["v_cart_lines"];
        $this->cart_lines->AdvancedSearch->SearchValue2 = @$filter["y_cart_lines"];
        $this->cart_lines->AdvancedSearch->SearchOperator2 = @$filter["w_cart_lines"];
        $this->cart_lines->AdvancedSearch->save();

        // Field pl_lines
        $this->pl_lines->AdvancedSearch->SearchValue = @$filter["x_pl_lines"];
        $this->pl_lines->AdvancedSearch->SearchOperator = @$filter["z_pl_lines"];
        $this->pl_lines->AdvancedSearch->SearchCondition = @$filter["v_pl_lines"];
        $this->pl_lines->AdvancedSearch->SearchValue2 = @$filter["y_pl_lines"];
        $this->pl_lines->AdvancedSearch->SearchOperator2 = @$filter["w_pl_lines"];
        $this->pl_lines->AdvancedSearch->save();

        // Field freezed
        $this->freezed->AdvancedSearch->SearchValue = @$filter["x_freezed"];
        $this->freezed->AdvancedSearch->SearchOperator = @$filter["z_freezed"];
        $this->freezed->AdvancedSearch->SearchCondition = @$filter["v_freezed"];
        $this->freezed->AdvancedSearch->SearchValue2 = @$filter["y_freezed"];
        $this->freezed->AdvancedSearch->SearchOperator2 = @$filter["w_freezed"];
        $this->freezed->AdvancedSearch->save();

        // Field a_operator
        $this->a_operator->AdvancedSearch->SearchValue = @$filter["x_a_operator"];
        $this->a_operator->AdvancedSearch->SearchOperator = @$filter["z_a_operator"];
        $this->a_operator->AdvancedSearch->SearchCondition = @$filter["v_a_operator"];
        $this->a_operator->AdvancedSearch->SearchValue2 = @$filter["y_a_operator"];
        $this->a_operator->AdvancedSearch->SearchOperator2 = @$filter["w_a_operator"];
        $this->a_operator->AdvancedSearch->save();

        // Field port_delivery
        $this->port_delivery->AdvancedSearch->SearchValue = @$filter["x_port_delivery"];
        $this->port_delivery->AdvancedSearch->SearchOperator = @$filter["z_port_delivery"];
        $this->port_delivery->AdvancedSearch->SearchCondition = @$filter["v_port_delivery"];
        $this->port_delivery->AdvancedSearch->SearchValue2 = @$filter["y_port_delivery"];
        $this->port_delivery->AdvancedSearch->SearchOperator2 = @$filter["w_port_delivery"];
        $this->port_delivery->AdvancedSearch->save();

        // Field dispatch_details
        $this->dispatch_details->AdvancedSearch->SearchValue = @$filter["x_dispatch_details"];
        $this->dispatch_details->AdvancedSearch->SearchOperator = @$filter["z_dispatch_details"];
        $this->dispatch_details->AdvancedSearch->SearchCondition = @$filter["v_dispatch_details"];
        $this->dispatch_details->AdvancedSearch->SearchValue2 = @$filter["y_dispatch_details"];
        $this->dispatch_details->AdvancedSearch->SearchOperator2 = @$filter["w_dispatch_details"];
        $this->dispatch_details->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->_barcode, $default, false); // barcode
        $this->buildSearchSql($where, $this->exporter, $default, false); // exporter
        $this->buildSearchSql($where, $this->consignee, $default, false); // consignee
        $this->buildSearchSql($where, $this->consignee_other, $default, false); // consignee_other
        $this->buildSearchSql($where, $this->packing_list_no, $default, false); // packing_list_no
        $this->buildSearchSql($where, $this->d_11, $default, false); // d_11
        $this->buildSearchSql($where, $this->description_11, $default, false); // description_11
        $this->buildSearchSql($where, $this->in_template, $default, false); // in_template
        $this->buildSearchSql($where, $this->pl_template, $default, false); // pl_template
        $this->buildSearchSql($where, $this->invoice_no, $default, false); // invoice_no
        $this->buildSearchSql($where, $this->invoice_date, $default, false); // invoice_date
        $this->buildSearchSql($where, $this->po_no, $default, false); // po_no
        $this->buildSearchSql($where, $this->other_reference, $default, false); // other_reference
        $this->buildSearchSql($where, $this->origin, $default, false); // origin
        $this->buildSearchSql($where, $this->final_destination, $default, false); // final_destination
        $this->buildSearchSql($where, $this->payment_terms, $default, false); // payment_terms
        $this->buildSearchSql($where, $this->pre_carriage_receipt, $default, false); // pre_carriage_receipt
        $this->buildSearchSql($where, $this->place_of_receipt, $default, false); // place_of_receipt
        $this->buildSearchSql($where, $this->loading_port, $default, false); // loading_port
        $this->buildSearchSql($where, $this->port_discharge, $default, false); // port_discharge
        $this->buildSearchSql($where, $this->d_01, $default, false); // d_01
        $this->buildSearchSql($where, $this->description_01, $default, false); // description_01
        $this->buildSearchSql($where, $this->d_02, $default, false); // d_02
        $this->buildSearchSql($where, $this->description_02, $default, false); // description_02
        $this->buildSearchSql($where, $this->gross_weight, $default, false); // gross_weight
        $this->buildSearchSql($where, $this->nett_weight, $default, false); // nett_weight
        $this->buildSearchSql($where, $this->cbm, $default, false); // cbm
        $this->buildSearchSql($where, $this->exporter_bank_details, $default, false); // exporter_bank_details
        $this->buildSearchSql($where, $this->intermediary_bank, $default, false); // intermediary_bank
        $this->buildSearchSql($where, $this->shipment_mode, $default, false); // shipment_mode
        $this->buildSearchSql($where, $this->ex_factory_date, $default, false); // ex_factory_date
        $this->buildSearchSql($where, $this->sailing_date, $default, false); // sailing_date
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->cart_lines, $default, false); // cart_lines
        $this->buildSearchSql($where, $this->pl_lines, $default, false); // pl_lines
        $this->buildSearchSql($where, $this->freezed, $default, false); // freezed
        $this->buildSearchSql($where, $this->a_operator, $default, false); // a_operator
        $this->buildSearchSql($where, $this->port_delivery, $default, false); // port_delivery
        $this->buildSearchSql($where, $this->dispatch_details, $default, false); // dispatch_details

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->exporter->AdvancedSearch->save(); // exporter
            $this->consignee->AdvancedSearch->save(); // consignee
            $this->consignee_other->AdvancedSearch->save(); // consignee_other
            $this->packing_list_no->AdvancedSearch->save(); // packing_list_no
            $this->d_11->AdvancedSearch->save(); // d_11
            $this->description_11->AdvancedSearch->save(); // description_11
            $this->in_template->AdvancedSearch->save(); // in_template
            $this->pl_template->AdvancedSearch->save(); // pl_template
            $this->invoice_no->AdvancedSearch->save(); // invoice_no
            $this->invoice_date->AdvancedSearch->save(); // invoice_date
            $this->po_no->AdvancedSearch->save(); // po_no
            $this->other_reference->AdvancedSearch->save(); // other_reference
            $this->origin->AdvancedSearch->save(); // origin
            $this->final_destination->AdvancedSearch->save(); // final_destination
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->pre_carriage_receipt->AdvancedSearch->save(); // pre_carriage_receipt
            $this->place_of_receipt->AdvancedSearch->save(); // place_of_receipt
            $this->loading_port->AdvancedSearch->save(); // loading_port
            $this->port_discharge->AdvancedSearch->save(); // port_discharge
            $this->d_01->AdvancedSearch->save(); // d_01
            $this->description_01->AdvancedSearch->save(); // description_01
            $this->d_02->AdvancedSearch->save(); // d_02
            $this->description_02->AdvancedSearch->save(); // description_02
            $this->gross_weight->AdvancedSearch->save(); // gross_weight
            $this->nett_weight->AdvancedSearch->save(); // nett_weight
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->exporter_bank_details->AdvancedSearch->save(); // exporter_bank_details
            $this->intermediary_bank->AdvancedSearch->save(); // intermediary_bank
            $this->shipment_mode->AdvancedSearch->save(); // shipment_mode
            $this->ex_factory_date->AdvancedSearch->save(); // ex_factory_date
            $this->sailing_date->AdvancedSearch->save(); // sailing_date
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->cart_lines->AdvancedSearch->save(); // cart_lines
            $this->pl_lines->AdvancedSearch->save(); // pl_lines
            $this->freezed->AdvancedSearch->save(); // freezed
            $this->a_operator->AdvancedSearch->save(); // a_operator
            $this->port_delivery->AdvancedSearch->save(); // port_delivery
            $this->dispatch_details->AdvancedSearch->save(); // dispatch_details

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->exporter->AdvancedSearch->save(); // exporter
            $this->consignee->AdvancedSearch->save(); // consignee
            $this->consignee_other->AdvancedSearch->save(); // consignee_other
            $this->packing_list_no->AdvancedSearch->save(); // packing_list_no
            $this->d_11->AdvancedSearch->save(); // d_11
            $this->description_11->AdvancedSearch->save(); // description_11
            $this->in_template->AdvancedSearch->save(); // in_template
            $this->pl_template->AdvancedSearch->save(); // pl_template
            $this->invoice_no->AdvancedSearch->save(); // invoice_no
            $this->invoice_date->AdvancedSearch->save(); // invoice_date
            $this->po_no->AdvancedSearch->save(); // po_no
            $this->other_reference->AdvancedSearch->save(); // other_reference
            $this->origin->AdvancedSearch->save(); // origin
            $this->final_destination->AdvancedSearch->save(); // final_destination
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->pre_carriage_receipt->AdvancedSearch->save(); // pre_carriage_receipt
            $this->place_of_receipt->AdvancedSearch->save(); // place_of_receipt
            $this->loading_port->AdvancedSearch->save(); // loading_port
            $this->port_discharge->AdvancedSearch->save(); // port_discharge
            $this->d_01->AdvancedSearch->save(); // d_01
            $this->description_01->AdvancedSearch->save(); // description_01
            $this->d_02->AdvancedSearch->save(); // d_02
            $this->description_02->AdvancedSearch->save(); // description_02
            $this->gross_weight->AdvancedSearch->save(); // gross_weight
            $this->nett_weight->AdvancedSearch->save(); // nett_weight
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->exporter_bank_details->AdvancedSearch->save(); // exporter_bank_details
            $this->intermediary_bank->AdvancedSearch->save(); // intermediary_bank
            $this->shipment_mode->AdvancedSearch->save(); // shipment_mode
            $this->ex_factory_date->AdvancedSearch->save(); // ex_factory_date
            $this->sailing_date->AdvancedSearch->save(); // sailing_date
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->cart_lines->AdvancedSearch->save(); // cart_lines
            $this->pl_lines->AdvancedSearch->save(); // pl_lines
            $this->freezed->AdvancedSearch->save(); // freezed
            $this->a_operator->AdvancedSearch->save(); // a_operator
            $this->port_delivery->AdvancedSearch->save(); // port_delivery
            $this->dispatch_details->AdvancedSearch->save(); // dispatch_details
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field exporter
        $filter = $this->queryBuilderWhere("exporter");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->exporter, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->exporter->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field consignee
        $filter = $this->queryBuilderWhere("consignee");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->consignee, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->consignee->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field consignee_other
        $filter = $this->queryBuilderWhere("consignee_other");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->consignee_other, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->consignee_other->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packing_list_no
        $filter = $this->queryBuilderWhere("packing_list_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packing_list_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packing_list_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field d_11
        $filter = $this->queryBuilderWhere("d_11");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->d_11, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->d_11->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field in_template
        $filter = $this->queryBuilderWhere("in_template");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->in_template, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->in_template->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_template
        $filter = $this->queryBuilderWhere("pl_template");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_template, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_template->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field invoice_no
        $filter = $this->queryBuilderWhere("invoice_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->invoice_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->invoice_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field invoice_date
        $filter = $this->queryBuilderWhere("invoice_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->invoice_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->invoice_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_no
        $filter = $this->queryBuilderWhere("po_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field other_reference
        $filter = $this->queryBuilderWhere("other_reference");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->other_reference, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->other_reference->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field origin
        $filter = $this->queryBuilderWhere("origin");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->origin, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->origin->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field final_destination
        $filter = $this->queryBuilderWhere("final_destination");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->final_destination, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->final_destination->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field payment_terms
        $filter = $this->queryBuilderWhere("payment_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->payment_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->payment_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pre_carriage_receipt
        $filter = $this->queryBuilderWhere("pre_carriage_receipt");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pre_carriage_receipt, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pre_carriage_receipt->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field place_of_receipt
        $filter = $this->queryBuilderWhere("place_of_receipt");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->place_of_receipt, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->place_of_receipt->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field loading_port
        $filter = $this->queryBuilderWhere("loading_port");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->loading_port, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->loading_port->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field port_discharge
        $filter = $this->queryBuilderWhere("port_discharge");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->port_discharge, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->port_discharge->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field d_01
        $filter = $this->queryBuilderWhere("d_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->d_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->d_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_01
        $filter = $this->queryBuilderWhere("description_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field d_02
        $filter = $this->queryBuilderWhere("d_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->d_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->d_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_02
        $filter = $this->queryBuilderWhere("description_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field gross_weight
        $filter = $this->queryBuilderWhere("gross_weight");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->gross_weight, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->gross_weight->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field nett_weight
        $filter = $this->queryBuilderWhere("nett_weight");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->nett_weight, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->nett_weight->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cbm
        $filter = $this->queryBuilderWhere("cbm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cbm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cbm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shipment_mode
        $filter = $this->queryBuilderWhere("shipment_mode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shipment_mode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shipment_mode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ex_factory_date
        $filter = $this->queryBuilderWhere("ex_factory_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ex_factory_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ex_factory_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sailing_date
        $filter = $this->queryBuilderWhere("sailing_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sailing_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sailing_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cart_lines
        $filter = $this->queryBuilderWhere("cart_lines");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cart_lines, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cart_lines->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_lines
        $filter = $this->queryBuilderWhere("pl_lines");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_lines, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_lines->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field freezed
        $filter = $this->queryBuilderWhere("freezed");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->freezed, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->freezed->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field a_operator
        $filter = $this->queryBuilderWhere("a_operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->a_operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->a_operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field port_delivery
        $filter = $this->queryBuilderWhere("port_delivery");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->port_delivery, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->port_delivery->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dispatch_details
        $filter = $this->queryBuilderWhere("dispatch_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dispatch_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dispatch_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->_barcode;
        $searchFlds[] = &$this->exporter;
        $searchFlds[] = &$this->consignee;
        $searchFlds[] = &$this->consignee_other;
        $searchFlds[] = &$this->d_11;
        $searchFlds[] = &$this->description_11;
        $searchFlds[] = &$this->invoice_no;
        $searchFlds[] = &$this->po_no;
        $searchFlds[] = &$this->other_reference;
        $searchFlds[] = &$this->origin;
        $searchFlds[] = &$this->final_destination;
        $searchFlds[] = &$this->payment_terms;
        $searchFlds[] = &$this->pre_carriage_receipt;
        $searchFlds[] = &$this->place_of_receipt;
        $searchFlds[] = &$this->loading_port;
        $searchFlds[] = &$this->port_discharge;
        $searchFlds[] = &$this->d_01;
        $searchFlds[] = &$this->description_01;
        $searchFlds[] = &$this->d_02;
        $searchFlds[] = &$this->description_02;
        $searchFlds[] = &$this->gross_weight;
        $searchFlds[] = &$this->nett_weight;
        $searchFlds[] = &$this->cbm;
        $searchFlds[] = &$this->exporter_bank_details;
        $searchFlds[] = &$this->intermediary_bank;
        $searchFlds[] = &$this->port_delivery;
        $searchFlds[] = &$this->dispatch_details;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_barcode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->exporter->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->consignee->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->consignee_other->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packing_list_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->in_template->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_template->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->invoice_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->invoice_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->other_reference->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->origin->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->final_destination->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->payment_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pre_carriage_receipt->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->place_of_receipt->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->loading_port->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->port_discharge->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->gross_weight->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->nett_weight->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->exporter_bank_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->intermediary_bank->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shipment_mode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ex_factory_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sailing_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cart_lines->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_lines->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->freezed->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->a_operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->port_delivery->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dispatch_details->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->_barcode->AdvancedSearch->unsetSession();
        $this->exporter->AdvancedSearch->unsetSession();
        $this->consignee->AdvancedSearch->unsetSession();
        $this->consignee_other->AdvancedSearch->unsetSession();
        $this->packing_list_no->AdvancedSearch->unsetSession();
        $this->d_11->AdvancedSearch->unsetSession();
        $this->description_11->AdvancedSearch->unsetSession();
        $this->in_template->AdvancedSearch->unsetSession();
        $this->pl_template->AdvancedSearch->unsetSession();
        $this->invoice_no->AdvancedSearch->unsetSession();
        $this->invoice_date->AdvancedSearch->unsetSession();
        $this->po_no->AdvancedSearch->unsetSession();
        $this->other_reference->AdvancedSearch->unsetSession();
        $this->origin->AdvancedSearch->unsetSession();
        $this->final_destination->AdvancedSearch->unsetSession();
        $this->payment_terms->AdvancedSearch->unsetSession();
        $this->pre_carriage_receipt->AdvancedSearch->unsetSession();
        $this->place_of_receipt->AdvancedSearch->unsetSession();
        $this->loading_port->AdvancedSearch->unsetSession();
        $this->port_discharge->AdvancedSearch->unsetSession();
        $this->d_01->AdvancedSearch->unsetSession();
        $this->description_01->AdvancedSearch->unsetSession();
        $this->d_02->AdvancedSearch->unsetSession();
        $this->description_02->AdvancedSearch->unsetSession();
        $this->gross_weight->AdvancedSearch->unsetSession();
        $this->nett_weight->AdvancedSearch->unsetSession();
        $this->cbm->AdvancedSearch->unsetSession();
        $this->exporter_bank_details->AdvancedSearch->unsetSession();
        $this->intermediary_bank->AdvancedSearch->unsetSession();
        $this->shipment_mode->AdvancedSearch->unsetSession();
        $this->ex_factory_date->AdvancedSearch->unsetSession();
        $this->sailing_date->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->cart_lines->AdvancedSearch->unsetSession();
        $this->pl_lines->AdvancedSearch->unsetSession();
        $this->freezed->AdvancedSearch->unsetSession();
        $this->a_operator->AdvancedSearch->unsetSession();
        $this->port_delivery->AdvancedSearch->unsetSession();
        $this->dispatch_details->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->exporter->AdvancedSearch->load();
        $this->consignee->AdvancedSearch->load();
        $this->consignee_other->AdvancedSearch->load();
        $this->packing_list_no->AdvancedSearch->load();
        $this->d_11->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->in_template->AdvancedSearch->load();
        $this->pl_template->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->po_no->AdvancedSearch->load();
        $this->other_reference->AdvancedSearch->load();
        $this->origin->AdvancedSearch->load();
        $this->final_destination->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->pre_carriage_receipt->AdvancedSearch->load();
        $this->place_of_receipt->AdvancedSearch->load();
        $this->loading_port->AdvancedSearch->load();
        $this->port_discharge->AdvancedSearch->load();
        $this->d_01->AdvancedSearch->load();
        $this->description_01->AdvancedSearch->load();
        $this->d_02->AdvancedSearch->load();
        $this->description_02->AdvancedSearch->load();
        $this->gross_weight->AdvancedSearch->load();
        $this->nett_weight->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->exporter_bank_details->AdvancedSearch->load();
        $this->intermediary_bank->AdvancedSearch->load();
        $this->shipment_mode->AdvancedSearch->load();
        $this->ex_factory_date->AdvancedSearch->load();
        $this->sailing_date->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->cart_lines->AdvancedSearch->load();
        $this->pl_lines->AdvancedSearch->load();
        $this->freezed->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->port_delivery->AdvancedSearch->load();
        $this->dispatch_details->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->exporter, $ctrl); // exporter
            $this->updateSort($this->consignee, $ctrl); // consignee
            $this->updateSort($this->consignee_other, $ctrl); // consignee_other
            $this->updateSort($this->packing_list_no, $ctrl); // packing_list_no
            $this->updateSort($this->d_11, $ctrl); // d_11
            $this->updateSort($this->in_template, $ctrl); // in_template
            $this->updateSort($this->pl_template, $ctrl); // pl_template
            $this->updateSort($this->invoice_no, $ctrl); // invoice_no
            $this->updateSort($this->invoice_date, $ctrl); // invoice_date
            $this->updateSort($this->po_no, $ctrl); // po_no
            $this->updateSort($this->other_reference, $ctrl); // other_reference
            $this->updateSort($this->origin, $ctrl); // origin
            $this->updateSort($this->final_destination, $ctrl); // final_destination
            $this->updateSort($this->payment_terms, $ctrl); // payment_terms
            $this->updateSort($this->pre_carriage_receipt, $ctrl); // pre_carriage_receipt
            $this->updateSort($this->place_of_receipt, $ctrl); // place_of_receipt
            $this->updateSort($this->loading_port, $ctrl); // loading_port
            $this->updateSort($this->port_discharge, $ctrl); // port_discharge
            $this->updateSort($this->d_01, $ctrl); // d_01
            $this->updateSort($this->description_01, $ctrl); // description_01
            $this->updateSort($this->d_02, $ctrl); // d_02
            $this->updateSort($this->description_02, $ctrl); // description_02
            $this->updateSort($this->gross_weight, $ctrl); // gross_weight
            $this->updateSort($this->nett_weight, $ctrl); // nett_weight
            $this->updateSort($this->cbm, $ctrl); // cbm
            $this->updateSort($this->shipment_mode, $ctrl); // shipment_mode
            $this->updateSort($this->ex_factory_date, $ctrl); // ex_factory_date
            $this->updateSort($this->sailing_date, $ctrl); // sailing_date
            $this->updateSort($this->operator, $ctrl); // operator
            $this->updateSort($this->datetime, $ctrl); // datetime
            $this->updateSort($this->cart_lines, $ctrl); // cart_lines
            $this->updateSort($this->pl_lines, $ctrl); // pl_lines
            $this->updateSort($this->freezed, $ctrl); // freezed
            $this->updateSort($this->a_operator, $ctrl); // a_operator
            $this->updateSort($this->port_delivery, $ctrl); // port_delivery
            $this->updateSort($this->dispatch_details, $ctrl); // dispatch_details
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->_barcode->setSort("");
                $this->exporter->setSort("");
                $this->consignee->setSort("");
                $this->consignee_other->setSort("");
                $this->packing_list_no->setSort("");
                $this->d_11->setSort("");
                $this->description_11->setSort("");
                $this->in_template->setSort("");
                $this->pl_template->setSort("");
                $this->invoice_no->setSort("");
                $this->invoice_date->setSort("");
                $this->po_no->setSort("");
                $this->other_reference->setSort("");
                $this->origin->setSort("");
                $this->final_destination->setSort("");
                $this->payment_terms->setSort("");
                $this->pre_carriage_receipt->setSort("");
                $this->place_of_receipt->setSort("");
                $this->loading_port->setSort("");
                $this->port_discharge->setSort("");
                $this->d_01->setSort("");
                $this->description_01->setSort("");
                $this->d_02->setSort("");
                $this->description_02->setSort("");
                $this->gross_weight->setSort("");
                $this->nett_weight->setSort("");
                $this->cbm->setSort("");
                $this->exporter_bank_details->setSort("");
                $this->intermediary_bank->setSort("");
                $this->shipment_mode->setSort("");
                $this->ex_factory_date->setSort("");
                $this->sailing_date->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->delivery_terms->setSort("");
                $this->po_date->setSort("");
                $this->cart_lines->setSort("");
                $this->pl_lines->setSort("");
                $this->freezed->setSort("");
                $this->pl_pdf->setSort("");
                $this->in_pdf->setSort("");
                $this->a_operator->setSort("");
                $this->port_delivery->setSort("");
                $this->dispatch_details->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"invoice_details\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"invoice_details\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"invoice_details\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"finvoice_detailslist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"finvoice_detailslist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"invoice_details\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "exporter");
            $this->createColumnOption($option, "consignee");
            $this->createColumnOption($option, "consignee_other");
            $this->createColumnOption($option, "packing_list_no");
            $this->createColumnOption($option, "d_11");
            $this->createColumnOption($option, "in_template");
            $this->createColumnOption($option, "pl_template");
            $this->createColumnOption($option, "invoice_no");
            $this->createColumnOption($option, "invoice_date");
            $this->createColumnOption($option, "po_no");
            $this->createColumnOption($option, "other_reference");
            $this->createColumnOption($option, "origin");
            $this->createColumnOption($option, "final_destination");
            $this->createColumnOption($option, "payment_terms");
            $this->createColumnOption($option, "pre_carriage_receipt");
            $this->createColumnOption($option, "place_of_receipt");
            $this->createColumnOption($option, "loading_port");
            $this->createColumnOption($option, "port_discharge");
            $this->createColumnOption($option, "d_01");
            $this->createColumnOption($option, "description_01");
            $this->createColumnOption($option, "d_02");
            $this->createColumnOption($option, "description_02");
            $this->createColumnOption($option, "gross_weight");
            $this->createColumnOption($option, "nett_weight");
            $this->createColumnOption($option, "cbm");
            $this->createColumnOption($option, "shipment_mode");
            $this->createColumnOption($option, "ex_factory_date");
            $this->createColumnOption($option, "sailing_date");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
            $this->createColumnOption($option, "cart_lines");
            $this->createColumnOption($option, "pl_lines");
            $this->createColumnOption($option, "freezed");
            $this->createColumnOption($option, "a_operator");
            $this->createColumnOption($option, "port_delivery");
            $this->createColumnOption($option, "dispatch_details");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"finvoice_detailssrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"finvoice_detailssrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="finvoice_detailslist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_invoice_details", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_invoice_details",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_barcode->AdvancedSearch->SearchValue != "" || $this->_barcode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // exporter
        if ($this->exporter->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->exporter->AdvancedSearch->SearchValue != "" || $this->exporter->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // consignee
        if ($this->consignee->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->consignee->AdvancedSearch->SearchValue != "" || $this->consignee->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // consignee_other
        if ($this->consignee_other->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->consignee_other->AdvancedSearch->SearchValue != "" || $this->consignee_other->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packing_list_no
        if ($this->packing_list_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packing_list_no->AdvancedSearch->SearchValue != "" || $this->packing_list_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_11
        if ($this->d_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_11->AdvancedSearch->SearchValue != "" || $this->d_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_11
        if ($this->description_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_11->AdvancedSearch->SearchValue != "" || $this->description_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // in_template
        if ($this->in_template->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->in_template->AdvancedSearch->SearchValue != "" || $this->in_template->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_template
        if ($this->pl_template->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_template->AdvancedSearch->SearchValue != "" || $this->pl_template->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // invoice_no
        if ($this->invoice_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->invoice_no->AdvancedSearch->SearchValue != "" || $this->invoice_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->invoice_date->AdvancedSearch->SearchValue != "" || $this->invoice_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_no
        if ($this->po_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_no->AdvancedSearch->SearchValue != "" || $this->po_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // other_reference
        if ($this->other_reference->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->other_reference->AdvancedSearch->SearchValue != "" || $this->other_reference->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // origin
        if ($this->origin->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->origin->AdvancedSearch->SearchValue != "" || $this->origin->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // final_destination
        if ($this->final_destination->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->final_destination->AdvancedSearch->SearchValue != "" || $this->final_destination->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->payment_terms->AdvancedSearch->SearchValue != "" || $this->payment_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pre_carriage_receipt
        if ($this->pre_carriage_receipt->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pre_carriage_receipt->AdvancedSearch->SearchValue != "" || $this->pre_carriage_receipt->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // place_of_receipt
        if ($this->place_of_receipt->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->place_of_receipt->AdvancedSearch->SearchValue != "" || $this->place_of_receipt->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // loading_port
        if ($this->loading_port->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->loading_port->AdvancedSearch->SearchValue != "" || $this->loading_port->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // port_discharge
        if ($this->port_discharge->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->port_discharge->AdvancedSearch->SearchValue != "" || $this->port_discharge->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_01
        if ($this->d_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_01->AdvancedSearch->SearchValue != "" || $this->d_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_01
        if ($this->description_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_01->AdvancedSearch->SearchValue != "" || $this->description_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_02
        if ($this->d_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_02->AdvancedSearch->SearchValue != "" || $this->d_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_02
        if ($this->description_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_02->AdvancedSearch->SearchValue != "" || $this->description_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // gross_weight
        if ($this->gross_weight->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->gross_weight->AdvancedSearch->SearchValue != "" || $this->gross_weight->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // nett_weight
        if ($this->nett_weight->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->nett_weight->AdvancedSearch->SearchValue != "" || $this->nett_weight->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cbm->AdvancedSearch->SearchValue != "" || $this->cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // exporter_bank_details
        if ($this->exporter_bank_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->exporter_bank_details->AdvancedSearch->SearchValue != "" || $this->exporter_bank_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // intermediary_bank
        if ($this->intermediary_bank->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->intermediary_bank->AdvancedSearch->SearchValue != "" || $this->intermediary_bank->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shipment_mode
        if ($this->shipment_mode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shipment_mode->AdvancedSearch->SearchValue != "" || $this->shipment_mode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ex_factory_date
        if ($this->ex_factory_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ex_factory_date->AdvancedSearch->SearchValue != "" || $this->ex_factory_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sailing_date
        if ($this->sailing_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sailing_date->AdvancedSearch->SearchValue != "" || $this->sailing_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cart_lines
        if ($this->cart_lines->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cart_lines->AdvancedSearch->SearchValue != "" || $this->cart_lines->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_lines
        if ($this->pl_lines->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_lines->AdvancedSearch->SearchValue != "" || $this->pl_lines->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // freezed
        if ($this->freezed->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->freezed->AdvancedSearch->SearchValue != "" || $this->freezed->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->a_operator->AdvancedSearch->SearchValue != "" || $this->a_operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // port_delivery
        if ($this->port_delivery->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->port_delivery->AdvancedSearch->SearchValue != "" || $this->port_delivery->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dispatch_details
        if ($this->dispatch_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dispatch_details->AdvancedSearch->SearchValue != "" || $this->dispatch_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->exporter->setDbValue($row['exporter']);
        $this->consignee->setDbValue($row['consignee']);
        $this->consignee_other->setDbValue($row['consignee_other']);
        $this->packing_list_no->setDbValue($row['packing_list_no']);
        $this->d_11->setDbValue($row['d_11']);
        $this->description_11->setDbValue($row['description_11']);
        $this->in_template->setDbValue($row['in_template']);
        $this->pl_template->setDbValue($row['pl_template']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->po_no->setDbValue($row['po_no']);
        $this->other_reference->setDbValue($row['other_reference']);
        $this->origin->setDbValue($row['origin']);
        $this->final_destination->setDbValue($row['final_destination']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
        $this->place_of_receipt->setDbValue($row['place_of_receipt']);
        $this->loading_port->setDbValue($row['loading_port']);
        $this->port_discharge->setDbValue($row['port_discharge']);
        $this->d_01->setDbValue($row['d_01']);
        $this->description_01->setDbValue($row['description_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->description_02->setDbValue($row['description_02']);
        $this->gross_weight->setDbValue($row['gross_weight']);
        $this->nett_weight->setDbValue($row['nett_weight']);
        $this->cbm->setDbValue($row['cbm']);
        $this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
        $this->intermediary_bank->setDbValue($row['intermediary_bank']);
        $this->shipment_mode->setDbValue($row['shipment_mode']);
        $this->ex_factory_date->setDbValue($row['ex_factory_date']);
        $this->sailing_date->setDbValue($row['sailing_date']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->po_date->setDbValue($row['po_date']);
        $this->cart_lines->setDbValue($row['cart_lines']);
        $this->pl_lines->setDbValue($row['pl_lines']);
        $this->freezed->setDbValue($row['freezed']);
        $this->pl_pdf->setDbValue($row['pl_pdf']);
        $this->in_pdf->setDbValue($row['in_pdf']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->port_delivery->setDbValue($row['port_delivery']);
        $this->dispatch_details->setDbValue($row['dispatch_details']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['exporter'] = $this->exporter->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['consignee_other'] = $this->consignee_other->DefaultValue;
        $row['packing_list_no'] = $this->packing_list_no->DefaultValue;
        $row['d_11'] = $this->d_11->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['in_template'] = $this->in_template->DefaultValue;
        $row['pl_template'] = $this->pl_template->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['po_no'] = $this->po_no->DefaultValue;
        $row['other_reference'] = $this->other_reference->DefaultValue;
        $row['origin'] = $this->origin->DefaultValue;
        $row['final_destination'] = $this->final_destination->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['pre_carriage_receipt'] = $this->pre_carriage_receipt->DefaultValue;
        $row['place_of_receipt'] = $this->place_of_receipt->DefaultValue;
        $row['loading_port'] = $this->loading_port->DefaultValue;
        $row['port_discharge'] = $this->port_discharge->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['gross_weight'] = $this->gross_weight->DefaultValue;
        $row['nett_weight'] = $this->nett_weight->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['exporter_bank_details'] = $this->exporter_bank_details->DefaultValue;
        $row['intermediary_bank'] = $this->intermediary_bank->DefaultValue;
        $row['shipment_mode'] = $this->shipment_mode->DefaultValue;
        $row['ex_factory_date'] = $this->ex_factory_date->DefaultValue;
        $row['sailing_date'] = $this->sailing_date->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['po_date'] = $this->po_date->DefaultValue;
        $row['cart_lines'] = $this->cart_lines->DefaultValue;
        $row['pl_lines'] = $this->pl_lines->DefaultValue;
        $row['freezed'] = $this->freezed->DefaultValue;
        $row['pl_pdf'] = $this->pl_pdf->DefaultValue;
        $row['in_pdf'] = $this->in_pdf->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['port_delivery'] = $this->port_delivery->DefaultValue;
        $row['dispatch_details'] = $this->dispatch_details->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // barcode

        // exporter

        // consignee

        // consignee_other

        // packing_list_no

        // d_11

        // description_11

        // in_template

        // pl_template

        // invoice_no

        // invoice_date

        // po_no

        // other_reference

        // origin

        // final_destination

        // payment_terms

        // pre_carriage_receipt

        // place_of_receipt

        // loading_port

        // port_discharge

        // d_01

        // description_01

        // d_02

        // description_02

        // gross_weight

        // nett_weight

        // cbm

        // exporter_bank_details

        // intermediary_bank

        // shipment_mode

        // ex_factory_date

        // sailing_date

        // operator

        // datetime

        // delivery_terms
        $this->delivery_terms->CellCssStyle = "white-space: nowrap;";

        // po_date
        $this->po_date->CellCssStyle = "white-space: nowrap;";

        // cart_lines

        // pl_lines

        // freezed

        // pl_pdf
        $this->pl_pdf->CellCssStyle = "white-space: nowrap;";

        // in_pdf
        $this->in_pdf->CellCssStyle = "white-space: nowrap;";

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // port_delivery

        // dispatch_details

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // exporter
            $curVal = strval($this->exporter->CurrentValue);
            if ($curVal != "") {
                $this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
                if ($this->exporter->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                    $sqlWrk = $this->exporter->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->exporter->Lookup->renderViewRow($rswrk[0]);
                        $this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
                    } else {
                        $this->exporter->ViewValue = $this->exporter->CurrentValue;
                    }
                }
            } else {
                $this->exporter->ViewValue = null;
            }

            // consignee
            $curVal = strval($this->consignee->CurrentValue);
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
                if ($this->consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                    } else {
                        $this->consignee->ViewValue = $this->consignee->CurrentValue;
                    }
                }
            } else {
                $this->consignee->ViewValue = null;
            }

            // consignee_other
            $curVal = strval($this->consignee_other->CurrentValue);
            if ($curVal != "") {
                $this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
                if ($this->consignee_other->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee_other->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
                    } else {
                        $this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
                    }
                }
            } else {
                $this->consignee_other->ViewValue = null;
            }

            // packing_list_no
            $curVal = strval($this->packing_list_no->CurrentValue);
            if ($curVal != "") {
                $this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
                if ($this->packing_list_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $curVal, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                    $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_list_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_list_no->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
                    } else {
                        $this->packing_list_no->ViewValue = FormatNumber($this->packing_list_no->CurrentValue, $this->packing_list_no->formatPattern());
                    }
                }
            } else {
                $this->packing_list_no->ViewValue = null;
            }

            // d_11
            $this->d_11->ViewValue = $this->d_11->CurrentValue;

            // in_template
            $curVal = strval($this->in_template->CurrentValue);
            if ($curVal != "") {
                $this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
                if ($this->in_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->in_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->in_template->Lookup->renderViewRow($rswrk[0]);
                        $this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
                    } else {
                        $this->in_template->ViewValue = $this->in_template->CurrentValue;
                    }
                }
            } else {
                $this->in_template->ViewValue = null;
            }

            // pl_template
            $curVal = strval($this->pl_template->CurrentValue);
            if ($curVal != "") {
                $this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
                if ($this->pl_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_template->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
                    } else {
                        $this->pl_template->ViewValue = $this->pl_template->CurrentValue;
                    }
                }
            } else {
                $this->pl_template->ViewValue = null;
            }

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // po_no
            $this->po_no->ViewValue = $this->po_no->CurrentValue;

            // other_reference
            $this->other_reference->ViewValue = $this->other_reference->CurrentValue;

            // origin
            $this->origin->ViewValue = $this->origin->CurrentValue;

            // final_destination
            $this->final_destination->ViewValue = $this->final_destination->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // pre_carriage_receipt
            $this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;

            // place_of_receipt
            $this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;

            // loading_port
            $this->loading_port->ViewValue = $this->loading_port->CurrentValue;

            // port_discharge
            $this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // description_01
            $this->description_01->ViewValue = $this->description_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // description_02
            $this->description_02->ViewValue = $this->description_02->CurrentValue;

            // gross_weight
            $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;

            // nett_weight
            $this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // shipment_mode
            if (strval($this->shipment_mode->CurrentValue) != "") {
                $this->shipment_mode->ViewValue = $this->shipment_mode->optionCaption($this->shipment_mode->CurrentValue);
            } else {
                $this->shipment_mode->ViewValue = null;
            }

            // ex_factory_date
            $this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
            $this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, $this->ex_factory_date->formatPattern());

            // sailing_date
            $this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
            $this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, $this->sailing_date->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // cart_lines
            $this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;

            // pl_lines
            $this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;

            // freezed
            if (strval($this->freezed->CurrentValue) != "") {
                $this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
            } else {
                $this->freezed->ViewValue = null;
            }

            // a_operator
            $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
            $this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, $this->a_operator->formatPattern());

            // port_delivery
            $this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;

            // dispatch_details
            $this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // exporter
            $this->exporter->HrefValue = "";
            $this->exporter->TooltipValue = "";

            // consignee
            $this->consignee->HrefValue = "";
            $this->consignee->TooltipValue = "";

            // consignee_other
            $this->consignee_other->HrefValue = "";
            $this->consignee_other->TooltipValue = "";

            // packing_list_no
            $this->packing_list_no->HrefValue = "";
            $this->packing_list_no->TooltipValue = "";

            // d_11
            $this->d_11->HrefValue = "";
            $this->d_11->TooltipValue = "";
            if (!$this->isExport()) {
                $this->d_11->ViewValue = $this->highlightValue($this->d_11);
            }

            // in_template
            $this->in_template->HrefValue = "";
            $this->in_template->TooltipValue = "";

            // pl_template
            $this->pl_template->HrefValue = "";
            $this->pl_template->TooltipValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->invoice_no->ViewValue = $this->highlightValue($this->invoice_no);
            }

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->invoice_date->ViewValue = $this->highlightValue($this->invoice_date);
            }

            // po_no
            $this->po_no->HrefValue = "";
            $this->po_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_no->ViewValue = $this->highlightValue($this->po_no);
            }

            // other_reference
            $this->other_reference->HrefValue = "";
            $this->other_reference->TooltipValue = "";
            if (!$this->isExport()) {
                $this->other_reference->ViewValue = $this->highlightValue($this->other_reference);
            }

            // origin
            $this->origin->HrefValue = "";
            $this->origin->TooltipValue = "";
            if (!$this->isExport()) {
                $this->origin->ViewValue = $this->highlightValue($this->origin);
            }

            // final_destination
            $this->final_destination->HrefValue = "";
            $this->final_destination->TooltipValue = "";
            if (!$this->isExport()) {
                $this->final_destination->ViewValue = $this->highlightValue($this->final_destination);
            }

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";
            if (!$this->isExport()) {
                $this->payment_terms->ViewValue = $this->highlightValue($this->payment_terms);
            }

            // pre_carriage_receipt
            $this->pre_carriage_receipt->HrefValue = "";
            $this->pre_carriage_receipt->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pre_carriage_receipt->ViewValue = $this->highlightValue($this->pre_carriage_receipt);
            }

            // place_of_receipt
            $this->place_of_receipt->HrefValue = "";
            $this->place_of_receipt->TooltipValue = "";
            if (!$this->isExport()) {
                $this->place_of_receipt->ViewValue = $this->highlightValue($this->place_of_receipt);
            }

            // loading_port
            $this->loading_port->HrefValue = "";
            $this->loading_port->TooltipValue = "";
            if (!$this->isExport()) {
                $this->loading_port->ViewValue = $this->highlightValue($this->loading_port);
            }

            // port_discharge
            $this->port_discharge->HrefValue = "";
            $this->port_discharge->TooltipValue = "";
            if (!$this->isExport()) {
                $this->port_discharge->ViewValue = $this->highlightValue($this->port_discharge);
            }

            // d_01
            $this->d_01->HrefValue = "";
            $this->d_01->TooltipValue = "";
            if (!$this->isExport()) {
                $this->d_01->ViewValue = $this->highlightValue($this->d_01);
            }

            // description_01
            $this->description_01->HrefValue = "";
            $this->description_01->TooltipValue = "";
            if (!$this->isExport()) {
                $this->description_01->ViewValue = $this->highlightValue($this->description_01);
            }

            // d_02
            $this->d_02->HrefValue = "";
            $this->d_02->TooltipValue = "";
            if (!$this->isExport()) {
                $this->d_02->ViewValue = $this->highlightValue($this->d_02);
            }

            // description_02
            $this->description_02->HrefValue = "";
            $this->description_02->TooltipValue = "";
            if (!$this->isExport()) {
                $this->description_02->ViewValue = $this->highlightValue($this->description_02);
            }

            // gross_weight
            $this->gross_weight->HrefValue = "";
            $this->gross_weight->TooltipValue = "";
            if (!$this->isExport()) {
                $this->gross_weight->ViewValue = $this->highlightValue($this->gross_weight);
            }

            // nett_weight
            $this->nett_weight->HrefValue = "";
            $this->nett_weight->TooltipValue = "";
            if (!$this->isExport()) {
                $this->nett_weight->ViewValue = $this->highlightValue($this->nett_weight);
            }

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cbm->ViewValue = $this->highlightValue($this->cbm);
            }

            // shipment_mode
            $this->shipment_mode->HrefValue = "";
            $this->shipment_mode->TooltipValue = "";

            // ex_factory_date
            $this->ex_factory_date->HrefValue = "";
            $this->ex_factory_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ex_factory_date->ViewValue = $this->highlightValue($this->ex_factory_date);
            }

            // sailing_date
            $this->sailing_date->HrefValue = "";
            $this->sailing_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sailing_date->ViewValue = $this->highlightValue($this->sailing_date);
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }

            // cart_lines
            $this->cart_lines->HrefValue = "";
            $this->cart_lines->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cart_lines->ViewValue = $this->highlightValue($this->cart_lines);
            }

            // pl_lines
            $this->pl_lines->HrefValue = "";
            $this->pl_lines->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pl_lines->ViewValue = $this->highlightValue($this->pl_lines);
            }

            // freezed
            $this->freezed->HrefValue = "";
            $this->freezed->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // port_delivery
            $this->port_delivery->HrefValue = "";
            $this->port_delivery->TooltipValue = "";
            if (!$this->isExport()) {
                $this->port_delivery->ViewValue = $this->highlightValue($this->port_delivery);
            }

            // dispatch_details
            $this->dispatch_details->HrefValue = "";
            $this->dispatch_details->TooltipValue = "";
            if (!$this->isExport()) {
                $this->dispatch_details->ViewValue = $this->highlightValue($this->dispatch_details);
            }
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->exporter->AdvancedSearch->load();
        $this->consignee->AdvancedSearch->load();
        $this->consignee_other->AdvancedSearch->load();
        $this->packing_list_no->AdvancedSearch->load();
        $this->d_11->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->in_template->AdvancedSearch->load();
        $this->pl_template->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->po_no->AdvancedSearch->load();
        $this->other_reference->AdvancedSearch->load();
        $this->origin->AdvancedSearch->load();
        $this->final_destination->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->pre_carriage_receipt->AdvancedSearch->load();
        $this->place_of_receipt->AdvancedSearch->load();
        $this->loading_port->AdvancedSearch->load();
        $this->port_discharge->AdvancedSearch->load();
        $this->d_01->AdvancedSearch->load();
        $this->description_01->AdvancedSearch->load();
        $this->d_02->AdvancedSearch->load();
        $this->description_02->AdvancedSearch->load();
        $this->gross_weight->AdvancedSearch->load();
        $this->nett_weight->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->exporter_bank_details->AdvancedSearch->load();
        $this->intermediary_bank->AdvancedSearch->load();
        $this->shipment_mode->AdvancedSearch->load();
        $this->ex_factory_date->AdvancedSearch->load();
        $this->sailing_date->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->cart_lines->AdvancedSearch->load();
        $this->pl_lines->AdvancedSearch->load();
        $this->freezed->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->port_delivery->AdvancedSearch->load();
        $this->dispatch_details->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"finvoice_detailslist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"finvoice_detailslist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"finvoice_detailslist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="finvoice_detailslist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"invoice_details\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"invoicedetailssearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"invoicedetailssearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"finvoice_detailssrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_exporter":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee_other":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_list_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_in_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipment_mode":
                    break;
                case "x_freezed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	$infile = '.p_uploads/aW52b2ljZQ/' . $this->in_pdf->CurrentValue;
    	if (($this->in_pdf->CurrentValue == null))
    	{
    		$this->ListOptions->Add("Generate Invoice"); // Replace abclink with your name of the link
    		$this->ListOptions->Items["Generate Invoice"]->Body ='<a href="autoprogramme?apcid='.$this->in_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-bs-original-title ="Generate Invoice"><i data-phrase="Generate Invoice" style="color:red" class="fa fa-print fa-2x ew-icon"></i></a>'; 
    	}
    	else
    	{
    		$this->ListOptions->Add("ReGenerate Invoice"); // Replace abclink with your name of the link
    		$this->ListOptions->Items["ReGenerate Invoice"]->Body ='<a href="autoprogramme?apcid='.$this->in_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-bs-original-title ="ReGenerate Invoice"><i data-phrase="ReGenerate Invoice" style="color:red" class="fa fa-print fa-2x ew-icon"></i></a>';
    	}
    	IF (file_exists($infile))
    	{
    	$this->ListOptions->Add("Download Invoice");
    	$this->ListOptions->Items["Download Invoice"]->Body =
    		'<a href="'.$infile.'" data-bs-original-title ="Download Invoice"><i data-phrase="Download Invoice" style="font-size: 16px; color:red" class="fa fa-file-pdf-o"></i></a>';
    	}
    	$plfile = '.p_uploads/aW52b2ljZQ/' . $this->pl_pdf->CurrentValue;
    	if (($this->pl_pdf->CurrentValue == null))
    	{
    		$this->ListOptions->Add("Generate Packing List"); // Replace abclink with your name of the link
    		$this->ListOptions->Items["Generate Packing List"]->Body ='<a href="autoprogramme?apcid='.$this->pl_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-bs-original-title ="Generate Packing List"><i data-phrase="Generate Packing List" style="color:green" class="fa fa-print fa-2x ew-icon" ></i></a>'; 
    	}
    	else
    	{
    		$this->ListOptions->Add("ReGenerate Packing List"); // Replace abclink with your name of the link
    		$this->ListOptions->Items["ReGenerate Packing List"]->Body ='<a href="autoprogramme?apcid='.$this->pl_template->CurrentValue.'&ID=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s&action=generate" data-bs-original-title ="ReGenerate Packing List"><i data-phrase="ReGenerate Packing List" style="color:green" class="fa fa-print fa-2x ew-icon" ></i></a>'; 
    	}
    	IF (file_exists($plfile))
    	{
    	$this->ListOptions->Add("Download Packing List");
    	$this->ListOptions->Items["Download Packing List"]->Body =
    		'<a href="'.$plfile.'" download data-bs-original-title ="Download Packing List"><i data-phrase="Download Packing List" style="font-size: 16px; color:green" class="fa fa-file-pdf-o"></i></a>';
    	}	
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
