<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class InvoiceDetailsEdit extends InvoiceDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InvoiceDetailsEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "invoicedetailsedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->_barcode->setVisibility();
        $this->exporter->setVisibility();
        $this->consignee->setVisibility();
        $this->consignee_other->setVisibility();
        $this->packing_list_no->setVisibility();
        $this->d_11->setVisibility();
        $this->description_11->setVisibility();
        $this->in_template->setVisibility();
        $this->pl_template->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->po_no->setVisibility();
        $this->other_reference->setVisibility();
        $this->origin->setVisibility();
        $this->final_destination->setVisibility();
        $this->payment_terms->setVisibility();
        $this->pre_carriage_receipt->setVisibility();
        $this->place_of_receipt->setVisibility();
        $this->loading_port->setVisibility();
        $this->port_discharge->setVisibility();
        $this->d_01->setVisibility();
        $this->description_01->setVisibility();
        $this->d_02->setVisibility();
        $this->description_02->setVisibility();
        $this->gross_weight->setVisibility();
        $this->nett_weight->setVisibility();
        $this->cbm->setVisibility();
        $this->exporter_bank_details->setVisibility();
        $this->intermediary_bank->setVisibility();
        $this->shipment_mode->setVisibility();
        $this->ex_factory_date->setVisibility();
        $this->sailing_date->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->delivery_terms->Visible = false;
        $this->po_date->Visible = false;
        $this->cart_lines->setVisibility();
        $this->pl_lines->setVisibility();
        $this->freezed->setVisibility();
        $this->pl_pdf->Visible = false;
        $this->in_pdf->Visible = false;
        $this->a_operator->Visible = false;
        $this->port_delivery->setVisibility();
        $this->dispatch_details->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'invoice_details';
        $this->TableName = 'invoice_details';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (invoice_details)
        if (!isset($GLOBALS["invoice_details"]) || $GLOBALS["invoice_details"]::class == PROJECT_NAMESPACE . "invoice_details") {
            $GLOBALS["invoice_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "invoicedetailsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->exporter);
        $this->setupLookupOptions($this->consignee);
        $this->setupLookupOptions($this->consignee_other);
        $this->setupLookupOptions($this->packing_list_no);
        $this->setupLookupOptions($this->in_template);
        $this->setupLookupOptions($this->pl_template);
        $this->setupLookupOptions($this->shipment_mode);
        $this->setupLookupOptions($this->freezed);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("invoicedetailslist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "invoicedetailslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "invoicedetailslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "invoicedetailslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val);
            }
        }

        // Check field name 'exporter' first before field var 'x_exporter'
        $val = $CurrentForm->hasValue("exporter") ? $CurrentForm->getValue("exporter") : $CurrentForm->getValue("x_exporter");
        if (!$this->exporter->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->exporter->Visible = false; // Disable update for API request
            } else {
                $this->exporter->setFormValue($val);
            }
        }

        // Check field name 'consignee' first before field var 'x_consignee'
        $val = $CurrentForm->hasValue("consignee") ? $CurrentForm->getValue("consignee") : $CurrentForm->getValue("x_consignee");
        if (!$this->consignee->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->consignee->Visible = false; // Disable update for API request
            } else {
                $this->consignee->setFormValue($val);
            }
        }

        // Check field name 'consignee_other' first before field var 'x_consignee_other'
        $val = $CurrentForm->hasValue("consignee_other") ? $CurrentForm->getValue("consignee_other") : $CurrentForm->getValue("x_consignee_other");
        if (!$this->consignee_other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->consignee_other->Visible = false; // Disable update for API request
            } else {
                $this->consignee_other->setFormValue($val);
            }
        }

        // Check field name 'packing_list_no' first before field var 'x_packing_list_no'
        $val = $CurrentForm->hasValue("packing_list_no") ? $CurrentForm->getValue("packing_list_no") : $CurrentForm->getValue("x_packing_list_no");
        if (!$this->packing_list_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_list_no->Visible = false; // Disable update for API request
            } else {
                $this->packing_list_no->setFormValue($val);
            }
        }

        // Check field name 'd_11' first before field var 'x_d_11'
        $val = $CurrentForm->hasValue("d_11") ? $CurrentForm->getValue("d_11") : $CurrentForm->getValue("x_d_11");
        if (!$this->d_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_11->Visible = false; // Disable update for API request
            } else {
                $this->d_11->setFormValue($val);
            }
        }

        // Check field name 'description_11' first before field var 'x_description_11'
        $val = $CurrentForm->hasValue("description_11") ? $CurrentForm->getValue("description_11") : $CurrentForm->getValue("x_description_11");
        if (!$this->description_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_11->Visible = false; // Disable update for API request
            } else {
                $this->description_11->setFormValue($val);
            }
        }

        // Check field name 'in_template' first before field var 'x_in_template'
        $val = $CurrentForm->hasValue("in_template") ? $CurrentForm->getValue("in_template") : $CurrentForm->getValue("x_in_template");
        if (!$this->in_template->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_template->Visible = false; // Disable update for API request
            } else {
                $this->in_template->setFormValue($val);
            }
        }

        // Check field name 'pl_template' first before field var 'x_pl_template'
        $val = $CurrentForm->hasValue("pl_template") ? $CurrentForm->getValue("pl_template") : $CurrentForm->getValue("x_pl_template");
        if (!$this->pl_template->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_template->Visible = false; // Disable update for API request
            } else {
                $this->pl_template->setFormValue($val);
            }
        }

        // Check field name 'invoice_no' first before field var 'x_invoice_no'
        $val = $CurrentForm->hasValue("invoice_no") ? $CurrentForm->getValue("invoice_no") : $CurrentForm->getValue("x_invoice_no");
        if (!$this->invoice_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_no->Visible = false; // Disable update for API request
            } else {
                $this->invoice_no->setFormValue($val);
            }
        }

        // Check field name 'invoice_date' first before field var 'x_invoice_date'
        $val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
        if (!$this->invoice_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_date->Visible = false; // Disable update for API request
            } else {
                $this->invoice_date->setFormValue($val, true, $validate);
            }
            $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        }

        // Check field name 'po_no' first before field var 'x_po_no'
        $val = $CurrentForm->hasValue("po_no") ? $CurrentForm->getValue("po_no") : $CurrentForm->getValue("x_po_no");
        if (!$this->po_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_no->Visible = false; // Disable update for API request
            } else {
                $this->po_no->setFormValue($val);
            }
        }

        // Check field name 'other_reference' first before field var 'x_other_reference'
        $val = $CurrentForm->hasValue("other_reference") ? $CurrentForm->getValue("other_reference") : $CurrentForm->getValue("x_other_reference");
        if (!$this->other_reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_reference->Visible = false; // Disable update for API request
            } else {
                $this->other_reference->setFormValue($val);
            }
        }

        // Check field name 'origin' first before field var 'x_origin'
        $val = $CurrentForm->hasValue("origin") ? $CurrentForm->getValue("origin") : $CurrentForm->getValue("x_origin");
        if (!$this->origin->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->origin->Visible = false; // Disable update for API request
            } else {
                $this->origin->setFormValue($val);
            }
        }

        // Check field name 'final_destination' first before field var 'x_final_destination'
        $val = $CurrentForm->hasValue("final_destination") ? $CurrentForm->getValue("final_destination") : $CurrentForm->getValue("x_final_destination");
        if (!$this->final_destination->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->final_destination->Visible = false; // Disable update for API request
            } else {
                $this->final_destination->setFormValue($val);
            }
        }

        // Check field name 'payment_terms' first before field var 'x_payment_terms'
        $val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
        if (!$this->payment_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_terms->Visible = false; // Disable update for API request
            } else {
                $this->payment_terms->setFormValue($val);
            }
        }

        // Check field name 'pre_carriage_receipt' first before field var 'x_pre_carriage_receipt'
        $val = $CurrentForm->hasValue("pre_carriage_receipt") ? $CurrentForm->getValue("pre_carriage_receipt") : $CurrentForm->getValue("x_pre_carriage_receipt");
        if (!$this->pre_carriage_receipt->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pre_carriage_receipt->Visible = false; // Disable update for API request
            } else {
                $this->pre_carriage_receipt->setFormValue($val);
            }
        }

        // Check field name 'place_of_receipt' first before field var 'x_place_of_receipt'
        $val = $CurrentForm->hasValue("place_of_receipt") ? $CurrentForm->getValue("place_of_receipt") : $CurrentForm->getValue("x_place_of_receipt");
        if (!$this->place_of_receipt->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->place_of_receipt->Visible = false; // Disable update for API request
            } else {
                $this->place_of_receipt->setFormValue($val);
            }
        }

        // Check field name 'loading_port' first before field var 'x_loading_port'
        $val = $CurrentForm->hasValue("loading_port") ? $CurrentForm->getValue("loading_port") : $CurrentForm->getValue("x_loading_port");
        if (!$this->loading_port->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->loading_port->Visible = false; // Disable update for API request
            } else {
                $this->loading_port->setFormValue($val);
            }
        }

        // Check field name 'port_discharge' first before field var 'x_port_discharge'
        $val = $CurrentForm->hasValue("port_discharge") ? $CurrentForm->getValue("port_discharge") : $CurrentForm->getValue("x_port_discharge");
        if (!$this->port_discharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_discharge->Visible = false; // Disable update for API request
            } else {
                $this->port_discharge->setFormValue($val);
            }
        }

        // Check field name 'd_01' first before field var 'x_d_01'
        $val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
        if (!$this->d_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_01->Visible = false; // Disable update for API request
            } else {
                $this->d_01->setFormValue($val);
            }
        }

        // Check field name 'description_01' first before field var 'x_description_01'
        $val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
        if (!$this->description_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_01->Visible = false; // Disable update for API request
            } else {
                $this->description_01->setFormValue($val);
            }
        }

        // Check field name 'd_02' first before field var 'x_d_02'
        $val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
        if (!$this->d_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_02->Visible = false; // Disable update for API request
            } else {
                $this->d_02->setFormValue($val);
            }
        }

        // Check field name 'description_02' first before field var 'x_description_02'
        $val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
        if (!$this->description_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_02->Visible = false; // Disable update for API request
            } else {
                $this->description_02->setFormValue($val);
            }
        }

        // Check field name 'gross_weight' first before field var 'x_gross_weight'
        $val = $CurrentForm->hasValue("gross_weight") ? $CurrentForm->getValue("gross_weight") : $CurrentForm->getValue("x_gross_weight");
        if (!$this->gross_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gross_weight->Visible = false; // Disable update for API request
            } else {
                $this->gross_weight->setFormValue($val);
            }
        }

        // Check field name 'nett_weight' first before field var 'x_nett_weight'
        $val = $CurrentForm->hasValue("nett_weight") ? $CurrentForm->getValue("nett_weight") : $CurrentForm->getValue("x_nett_weight");
        if (!$this->nett_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nett_weight->Visible = false; // Disable update for API request
            } else {
                $this->nett_weight->setFormValue($val);
            }
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val);
            }
        }

        // Check field name 'exporter_bank_details' first before field var 'x_exporter_bank_details'
        $val = $CurrentForm->hasValue("exporter_bank_details") ? $CurrentForm->getValue("exporter_bank_details") : $CurrentForm->getValue("x_exporter_bank_details");
        if (!$this->exporter_bank_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->exporter_bank_details->Visible = false; // Disable update for API request
            } else {
                $this->exporter_bank_details->setFormValue($val);
            }
        }

        // Check field name 'intermediary_bank' first before field var 'x_intermediary_bank'
        $val = $CurrentForm->hasValue("intermediary_bank") ? $CurrentForm->getValue("intermediary_bank") : $CurrentForm->getValue("x_intermediary_bank");
        if (!$this->intermediary_bank->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->intermediary_bank->Visible = false; // Disable update for API request
            } else {
                $this->intermediary_bank->setFormValue($val);
            }
        }

        // Check field name 'shipment_mode' first before field var 'x_shipment_mode'
        $val = $CurrentForm->hasValue("shipment_mode") ? $CurrentForm->getValue("shipment_mode") : $CurrentForm->getValue("x_shipment_mode");
        if (!$this->shipment_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipment_mode->Visible = false; // Disable update for API request
            } else {
                $this->shipment_mode->setFormValue($val);
            }
        }

        // Check field name 'ex_factory_date' first before field var 'x_ex_factory_date'
        $val = $CurrentForm->hasValue("ex_factory_date") ? $CurrentForm->getValue("ex_factory_date") : $CurrentForm->getValue("x_ex_factory_date");
        if (!$this->ex_factory_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ex_factory_date->Visible = false; // Disable update for API request
            } else {
                $this->ex_factory_date->setFormValue($val, true, $validate);
            }
            $this->ex_factory_date->CurrentValue = UnFormatDateTime($this->ex_factory_date->CurrentValue, $this->ex_factory_date->formatPattern());
        }

        // Check field name 'sailing_date' first before field var 'x_sailing_date'
        $val = $CurrentForm->hasValue("sailing_date") ? $CurrentForm->getValue("sailing_date") : $CurrentForm->getValue("x_sailing_date");
        if (!$this->sailing_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sailing_date->Visible = false; // Disable update for API request
            } else {
                $this->sailing_date->setFormValue($val, true, $validate);
            }
            $this->sailing_date->CurrentValue = UnFormatDateTime($this->sailing_date->CurrentValue, $this->sailing_date->formatPattern());
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'cart_lines' first before field var 'x_cart_lines'
        $val = $CurrentForm->hasValue("cart_lines") ? $CurrentForm->getValue("cart_lines") : $CurrentForm->getValue("x_cart_lines");
        if (!$this->cart_lines->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cart_lines->Visible = false; // Disable update for API request
            } else {
                $this->cart_lines->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pl_lines' first before field var 'x_pl_lines'
        $val = $CurrentForm->hasValue("pl_lines") ? $CurrentForm->getValue("pl_lines") : $CurrentForm->getValue("x_pl_lines");
        if (!$this->pl_lines->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_lines->Visible = false; // Disable update for API request
            } else {
                $this->pl_lines->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'freezed' first before field var 'x_freezed'
        $val = $CurrentForm->hasValue("freezed") ? $CurrentForm->getValue("freezed") : $CurrentForm->getValue("x_freezed");
        if (!$this->freezed->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->freezed->Visible = false; // Disable update for API request
            } else {
                $this->freezed->setFormValue($val);
            }
        }

        // Check field name 'port_delivery' first before field var 'x_port_delivery'
        $val = $CurrentForm->hasValue("port_delivery") ? $CurrentForm->getValue("port_delivery") : $CurrentForm->getValue("x_port_delivery");
        if (!$this->port_delivery->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_delivery->Visible = false; // Disable update for API request
            } else {
                $this->port_delivery->setFormValue($val);
            }
        }

        // Check field name 'dispatch_details' first before field var 'x_dispatch_details'
        $val = $CurrentForm->hasValue("dispatch_details") ? $CurrentForm->getValue("dispatch_details") : $CurrentForm->getValue("x_dispatch_details");
        if (!$this->dispatch_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dispatch_details->Visible = false; // Disable update for API request
            } else {
                $this->dispatch_details->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->exporter->CurrentValue = $this->exporter->FormValue;
        $this->consignee->CurrentValue = $this->consignee->FormValue;
        $this->consignee_other->CurrentValue = $this->consignee_other->FormValue;
        $this->packing_list_no->CurrentValue = $this->packing_list_no->FormValue;
        $this->d_11->CurrentValue = $this->d_11->FormValue;
        $this->description_11->CurrentValue = $this->description_11->FormValue;
        $this->in_template->CurrentValue = $this->in_template->FormValue;
        $this->pl_template->CurrentValue = $this->pl_template->FormValue;
        $this->invoice_no->CurrentValue = $this->invoice_no->FormValue;
        $this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
        $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->po_no->CurrentValue = $this->po_no->FormValue;
        $this->other_reference->CurrentValue = $this->other_reference->FormValue;
        $this->origin->CurrentValue = $this->origin->FormValue;
        $this->final_destination->CurrentValue = $this->final_destination->FormValue;
        $this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
        $this->pre_carriage_receipt->CurrentValue = $this->pre_carriage_receipt->FormValue;
        $this->place_of_receipt->CurrentValue = $this->place_of_receipt->FormValue;
        $this->loading_port->CurrentValue = $this->loading_port->FormValue;
        $this->port_discharge->CurrentValue = $this->port_discharge->FormValue;
        $this->d_01->CurrentValue = $this->d_01->FormValue;
        $this->description_01->CurrentValue = $this->description_01->FormValue;
        $this->d_02->CurrentValue = $this->d_02->FormValue;
        $this->description_02->CurrentValue = $this->description_02->FormValue;
        $this->gross_weight->CurrentValue = $this->gross_weight->FormValue;
        $this->nett_weight->CurrentValue = $this->nett_weight->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->exporter_bank_details->CurrentValue = $this->exporter_bank_details->FormValue;
        $this->intermediary_bank->CurrentValue = $this->intermediary_bank->FormValue;
        $this->shipment_mode->CurrentValue = $this->shipment_mode->FormValue;
        $this->ex_factory_date->CurrentValue = $this->ex_factory_date->FormValue;
        $this->ex_factory_date->CurrentValue = UnFormatDateTime($this->ex_factory_date->CurrentValue, $this->ex_factory_date->formatPattern());
        $this->sailing_date->CurrentValue = $this->sailing_date->FormValue;
        $this->sailing_date->CurrentValue = UnFormatDateTime($this->sailing_date->CurrentValue, $this->sailing_date->formatPattern());
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->cart_lines->CurrentValue = $this->cart_lines->FormValue;
        $this->pl_lines->CurrentValue = $this->pl_lines->FormValue;
        $this->freezed->CurrentValue = $this->freezed->FormValue;
        $this->port_delivery->CurrentValue = $this->port_delivery->FormValue;
        $this->dispatch_details->CurrentValue = $this->dispatch_details->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->exporter->setDbValue($row['exporter']);
        $this->consignee->setDbValue($row['consignee']);
        $this->consignee_other->setDbValue($row['consignee_other']);
        $this->packing_list_no->setDbValue($row['packing_list_no']);
        $this->d_11->setDbValue($row['d_11']);
        $this->description_11->setDbValue($row['description_11']);
        $this->in_template->setDbValue($row['in_template']);
        $this->pl_template->setDbValue($row['pl_template']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->po_no->setDbValue($row['po_no']);
        $this->other_reference->setDbValue($row['other_reference']);
        $this->origin->setDbValue($row['origin']);
        $this->final_destination->setDbValue($row['final_destination']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
        $this->place_of_receipt->setDbValue($row['place_of_receipt']);
        $this->loading_port->setDbValue($row['loading_port']);
        $this->port_discharge->setDbValue($row['port_discharge']);
        $this->d_01->setDbValue($row['d_01']);
        $this->description_01->setDbValue($row['description_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->description_02->setDbValue($row['description_02']);
        $this->gross_weight->setDbValue($row['gross_weight']);
        $this->nett_weight->setDbValue($row['nett_weight']);
        $this->cbm->setDbValue($row['cbm']);
        $this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
        $this->intermediary_bank->setDbValue($row['intermediary_bank']);
        $this->shipment_mode->setDbValue($row['shipment_mode']);
        $this->ex_factory_date->setDbValue($row['ex_factory_date']);
        $this->sailing_date->setDbValue($row['sailing_date']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->po_date->setDbValue($row['po_date']);
        $this->cart_lines->setDbValue($row['cart_lines']);
        $this->pl_lines->setDbValue($row['pl_lines']);
        $this->freezed->setDbValue($row['freezed']);
        $this->pl_pdf->setDbValue($row['pl_pdf']);
        $this->in_pdf->setDbValue($row['in_pdf']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->port_delivery->setDbValue($row['port_delivery']);
        $this->dispatch_details->setDbValue($row['dispatch_details']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['exporter'] = $this->exporter->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['consignee_other'] = $this->consignee_other->DefaultValue;
        $row['packing_list_no'] = $this->packing_list_no->DefaultValue;
        $row['d_11'] = $this->d_11->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['in_template'] = $this->in_template->DefaultValue;
        $row['pl_template'] = $this->pl_template->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['po_no'] = $this->po_no->DefaultValue;
        $row['other_reference'] = $this->other_reference->DefaultValue;
        $row['origin'] = $this->origin->DefaultValue;
        $row['final_destination'] = $this->final_destination->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['pre_carriage_receipt'] = $this->pre_carriage_receipt->DefaultValue;
        $row['place_of_receipt'] = $this->place_of_receipt->DefaultValue;
        $row['loading_port'] = $this->loading_port->DefaultValue;
        $row['port_discharge'] = $this->port_discharge->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['gross_weight'] = $this->gross_weight->DefaultValue;
        $row['nett_weight'] = $this->nett_weight->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['exporter_bank_details'] = $this->exporter_bank_details->DefaultValue;
        $row['intermediary_bank'] = $this->intermediary_bank->DefaultValue;
        $row['shipment_mode'] = $this->shipment_mode->DefaultValue;
        $row['ex_factory_date'] = $this->ex_factory_date->DefaultValue;
        $row['sailing_date'] = $this->sailing_date->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['po_date'] = $this->po_date->DefaultValue;
        $row['cart_lines'] = $this->cart_lines->DefaultValue;
        $row['pl_lines'] = $this->pl_lines->DefaultValue;
        $row['freezed'] = $this->freezed->DefaultValue;
        $row['pl_pdf'] = $this->pl_pdf->DefaultValue;
        $row['in_pdf'] = $this->in_pdf->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['port_delivery'] = $this->port_delivery->DefaultValue;
        $row['dispatch_details'] = $this->dispatch_details->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // exporter
        $this->exporter->RowCssClass = "row";

        // consignee
        $this->consignee->RowCssClass = "row";

        // consignee_other
        $this->consignee_other->RowCssClass = "row";

        // packing_list_no
        $this->packing_list_no->RowCssClass = "row";

        // d_11
        $this->d_11->RowCssClass = "row";

        // description_11
        $this->description_11->RowCssClass = "row";

        // in_template
        $this->in_template->RowCssClass = "row";

        // pl_template
        $this->pl_template->RowCssClass = "row";

        // invoice_no
        $this->invoice_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // po_no
        $this->po_no->RowCssClass = "row";

        // other_reference
        $this->other_reference->RowCssClass = "row";

        // origin
        $this->origin->RowCssClass = "row";

        // final_destination
        $this->final_destination->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // pre_carriage_receipt
        $this->pre_carriage_receipt->RowCssClass = "row";

        // place_of_receipt
        $this->place_of_receipt->RowCssClass = "row";

        // loading_port
        $this->loading_port->RowCssClass = "row";

        // port_discharge
        $this->port_discharge->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // gross_weight
        $this->gross_weight->RowCssClass = "row";

        // nett_weight
        $this->nett_weight->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // exporter_bank_details
        $this->exporter_bank_details->RowCssClass = "row";

        // intermediary_bank
        $this->intermediary_bank->RowCssClass = "row";

        // shipment_mode
        $this->shipment_mode->RowCssClass = "row";

        // ex_factory_date
        $this->ex_factory_date->RowCssClass = "row";

        // sailing_date
        $this->sailing_date->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // delivery_terms
        $this->delivery_terms->RowCssClass = "row";

        // po_date
        $this->po_date->RowCssClass = "row";

        // cart_lines
        $this->cart_lines->RowCssClass = "row";

        // pl_lines
        $this->pl_lines->RowCssClass = "row";

        // freezed
        $this->freezed->RowCssClass = "row";

        // pl_pdf
        $this->pl_pdf->RowCssClass = "row";

        // in_pdf
        $this->in_pdf->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // port_delivery
        $this->port_delivery->RowCssClass = "row";

        // dispatch_details
        $this->dispatch_details->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // exporter
            $curVal = strval($this->exporter->CurrentValue);
            if ($curVal != "") {
                $this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
                if ($this->exporter->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                    $sqlWrk = $this->exporter->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->exporter->Lookup->renderViewRow($rswrk[0]);
                        $this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
                    } else {
                        $this->exporter->ViewValue = $this->exporter->CurrentValue;
                    }
                }
            } else {
                $this->exporter->ViewValue = null;
            }

            // consignee
            $curVal = strval($this->consignee->CurrentValue);
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
                if ($this->consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                    } else {
                        $this->consignee->ViewValue = $this->consignee->CurrentValue;
                    }
                }
            } else {
                $this->consignee->ViewValue = null;
            }

            // consignee_other
            $curVal = strval($this->consignee_other->CurrentValue);
            if ($curVal != "") {
                $this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
                if ($this->consignee_other->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee_other->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
                    } else {
                        $this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
                    }
                }
            } else {
                $this->consignee_other->ViewValue = null;
            }

            // packing_list_no
            $curVal = strval($this->packing_list_no->CurrentValue);
            if ($curVal != "") {
                $this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
                if ($this->packing_list_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $curVal, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                    $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_list_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_list_no->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
                    } else {
                        $this->packing_list_no->ViewValue = FormatNumber($this->packing_list_no->CurrentValue, $this->packing_list_no->formatPattern());
                    }
                }
            } else {
                $this->packing_list_no->ViewValue = null;
            }

            // d_11
            $this->d_11->ViewValue = $this->d_11->CurrentValue;

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // in_template
            $curVal = strval($this->in_template->CurrentValue);
            if ($curVal != "") {
                $this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
                if ($this->in_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->in_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->in_template->Lookup->renderViewRow($rswrk[0]);
                        $this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
                    } else {
                        $this->in_template->ViewValue = $this->in_template->CurrentValue;
                    }
                }
            } else {
                $this->in_template->ViewValue = null;
            }

            // pl_template
            $curVal = strval($this->pl_template->CurrentValue);
            if ($curVal != "") {
                $this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
                if ($this->pl_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_template->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
                    } else {
                        $this->pl_template->ViewValue = $this->pl_template->CurrentValue;
                    }
                }
            } else {
                $this->pl_template->ViewValue = null;
            }

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // po_no
            $this->po_no->ViewValue = $this->po_no->CurrentValue;

            // other_reference
            $this->other_reference->ViewValue = $this->other_reference->CurrentValue;

            // origin
            $this->origin->ViewValue = $this->origin->CurrentValue;

            // final_destination
            $this->final_destination->ViewValue = $this->final_destination->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // pre_carriage_receipt
            $this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;

            // place_of_receipt
            $this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;

            // loading_port
            $this->loading_port->ViewValue = $this->loading_port->CurrentValue;

            // port_discharge
            $this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // description_01
            $this->description_01->ViewValue = $this->description_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // description_02
            $this->description_02->ViewValue = $this->description_02->CurrentValue;

            // gross_weight
            $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;

            // nett_weight
            $this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // exporter_bank_details
            $this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;

            // intermediary_bank
            $this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;

            // shipment_mode
            if (strval($this->shipment_mode->CurrentValue) != "") {
                $this->shipment_mode->ViewValue = $this->shipment_mode->optionCaption($this->shipment_mode->CurrentValue);
            } else {
                $this->shipment_mode->ViewValue = null;
            }

            // ex_factory_date
            $this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
            $this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, $this->ex_factory_date->formatPattern());

            // sailing_date
            $this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
            $this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, $this->sailing_date->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // cart_lines
            $this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;

            // pl_lines
            $this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;

            // freezed
            if (strval($this->freezed->CurrentValue) != "") {
                $this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
            } else {
                $this->freezed->ViewValue = null;
            }

            // a_operator
            $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
            $this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, $this->a_operator->formatPattern());

            // port_delivery
            $this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;

            // dispatch_details
            $this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // exporter
            $this->exporter->HrefValue = "";

            // consignee
            $this->consignee->HrefValue = "";

            // consignee_other
            $this->consignee_other->HrefValue = "";

            // packing_list_no
            $this->packing_list_no->HrefValue = "";

            // d_11
            $this->d_11->HrefValue = "";

            // description_11
            $this->description_11->HrefValue = "";

            // in_template
            $this->in_template->HrefValue = "";

            // pl_template
            $this->pl_template->HrefValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";

            // po_no
            $this->po_no->HrefValue = "";

            // other_reference
            $this->other_reference->HrefValue = "";

            // origin
            $this->origin->HrefValue = "";

            // final_destination
            $this->final_destination->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // pre_carriage_receipt
            $this->pre_carriage_receipt->HrefValue = "";

            // place_of_receipt
            $this->place_of_receipt->HrefValue = "";

            // loading_port
            $this->loading_port->HrefValue = "";

            // port_discharge
            $this->port_discharge->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // description_01
            $this->description_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // description_02
            $this->description_02->HrefValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";

            // nett_weight
            $this->nett_weight->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // exporter_bank_details
            $this->exporter_bank_details->HrefValue = "";

            // intermediary_bank
            $this->intermediary_bank->HrefValue = "";

            // shipment_mode
            $this->shipment_mode->HrefValue = "";

            // ex_factory_date
            $this->ex_factory_date->HrefValue = "";

            // sailing_date
            $this->sailing_date->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // cart_lines
            $this->cart_lines->HrefValue = "";

            // pl_lines
            $this->pl_lines->HrefValue = "";

            // freezed
            $this->freezed->HrefValue = "";

            // port_delivery
            $this->port_delivery->HrefValue = "";

            // dispatch_details
            $this->dispatch_details->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // exporter
            $this->exporter->setupEditAttributes();
            $curVal = trim(strval($this->exporter->CurrentValue));
            if ($curVal != "") {
                $this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
            } else {
                $this->exporter->ViewValue = $this->exporter->Lookup !== null && is_array($this->exporter->lookupOptions()) && count($this->exporter->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->exporter->ViewValue !== null) { // Load from cache
                $this->exporter->EditValue = array_values($this->exporter->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->exporter->CurrentValue, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                $sqlWrk = $this->exporter->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->exporter->EditValue = $arwrk;
            }
            $this->exporter->PlaceHolder = RemoveHtml($this->exporter->caption());

            // consignee
            $this->consignee->setupEditAttributes();
            $curVal = trim(strval($this->consignee->CurrentValue));
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
            } else {
                $this->consignee->ViewValue = $this->consignee->Lookup !== null && is_array($this->consignee->lookupOptions()) && count($this->consignee->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->consignee->ViewValue !== null) { // Load from cache
                $this->consignee->EditValue = array_values($this->consignee->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->consignee->CurrentValue, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->consignee->EditValue = $arwrk;
            }
            $this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());

            // consignee_other
            $this->consignee_other->setupEditAttributes();
            $curVal = trim(strval($this->consignee_other->CurrentValue));
            if ($curVal != "") {
                $this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
            } else {
                $this->consignee_other->ViewValue = $this->consignee_other->Lookup !== null && is_array($this->consignee_other->lookupOptions()) && count($this->consignee_other->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->consignee_other->ViewValue !== null) { // Load from cache
                $this->consignee_other->EditValue = array_values($this->consignee_other->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->consignee_other->CurrentValue, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee_other->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->consignee_other->EditValue = $arwrk;
            }
            $this->consignee_other->PlaceHolder = RemoveHtml($this->consignee_other->caption());

            // packing_list_no
            $this->packing_list_no->setupEditAttributes();
            $curVal = trim(strval($this->packing_list_no->CurrentValue));
            if ($curVal != "") {
                $this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
            } else {
                $this->packing_list_no->ViewValue = $this->packing_list_no->Lookup !== null && is_array($this->packing_list_no->lookupOptions()) && count($this->packing_list_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_list_no->ViewValue !== null) { // Load from cache
                $this->packing_list_no->EditValue = array_values($this->packing_list_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $this->packing_list_no->CurrentValue, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_list_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->packing_list_no->Lookup->renderViewRow($row);
                }
                $this->packing_list_no->EditValue = $arwrk;
            }
            $this->packing_list_no->PlaceHolder = RemoveHtml($this->packing_list_no->caption());

            // d_11
            $this->d_11->setupEditAttributes();
            if (!$this->d_11->Raw) {
                $this->d_11->CurrentValue = HtmlDecode($this->d_11->CurrentValue);
            }
            $this->d_11->EditValue = HtmlEncode($this->d_11->CurrentValue);
            $this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

            // description_11
            $this->description_11->setupEditAttributes();
            $this->description_11->EditValue = HtmlEncode($this->description_11->CurrentValue);
            $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

            // in_template
            $this->in_template->setupEditAttributes();
            $curVal = trim(strval($this->in_template->CurrentValue));
            if ($curVal != "") {
                $this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
            } else {
                $this->in_template->ViewValue = $this->in_template->Lookup !== null && is_array($this->in_template->lookupOptions()) && count($this->in_template->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->in_template->ViewValue !== null) { // Load from cache
                $this->in_template->EditValue = array_values($this->in_template->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->in_template->CurrentValue, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                $sqlWrk = $this->in_template->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->in_template->EditValue = $arwrk;
            }
            $this->in_template->PlaceHolder = RemoveHtml($this->in_template->caption());

            // pl_template
            $this->pl_template->setupEditAttributes();
            $curVal = trim(strval($this->pl_template->CurrentValue));
            if ($curVal != "") {
                $this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
            } else {
                $this->pl_template->ViewValue = $this->pl_template->Lookup !== null && is_array($this->pl_template->lookupOptions()) && count($this->pl_template->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_template->ViewValue !== null) { // Load from cache
                $this->pl_template->EditValue = array_values($this->pl_template->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_template->CurrentValue, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_template->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_template->EditValue = $arwrk;
            }
            $this->pl_template->PlaceHolder = RemoveHtml($this->pl_template->caption());

            // invoice_no
            $this->invoice_no->setupEditAttributes();
            if (!$this->invoice_no->Raw) {
                $this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
            }
            $this->invoice_no->EditValue = HtmlEncode($this->invoice_no->CurrentValue);
            $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode(FormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // po_no
            $this->po_no->setupEditAttributes();
            $this->po_no->EditValue = HtmlEncode($this->po_no->CurrentValue);
            $this->po_no->PlaceHolder = RemoveHtml($this->po_no->caption());

            // other_reference
            $this->other_reference->setupEditAttributes();
            if (!$this->other_reference->Raw) {
                $this->other_reference->CurrentValue = HtmlDecode($this->other_reference->CurrentValue);
            }
            $this->other_reference->EditValue = HtmlEncode($this->other_reference->CurrentValue);
            $this->other_reference->PlaceHolder = RemoveHtml($this->other_reference->caption());

            // origin
            $this->origin->setupEditAttributes();
            if (!$this->origin->Raw) {
                $this->origin->CurrentValue = HtmlDecode($this->origin->CurrentValue);
            }
            $this->origin->EditValue = HtmlEncode($this->origin->CurrentValue);
            $this->origin->PlaceHolder = RemoveHtml($this->origin->caption());

            // final_destination
            $this->final_destination->setupEditAttributes();
            if (!$this->final_destination->Raw) {
                $this->final_destination->CurrentValue = HtmlDecode($this->final_destination->CurrentValue);
            }
            $this->final_destination->EditValue = HtmlEncode($this->final_destination->CurrentValue);
            $this->final_destination->PlaceHolder = RemoveHtml($this->final_destination->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $this->payment_terms->EditValue = HtmlEncode($this->payment_terms->CurrentValue);
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // pre_carriage_receipt
            $this->pre_carriage_receipt->setupEditAttributes();
            if (!$this->pre_carriage_receipt->Raw) {
                $this->pre_carriage_receipt->CurrentValue = HtmlDecode($this->pre_carriage_receipt->CurrentValue);
            }
            $this->pre_carriage_receipt->EditValue = HtmlEncode($this->pre_carriage_receipt->CurrentValue);
            $this->pre_carriage_receipt->PlaceHolder = RemoveHtml($this->pre_carriage_receipt->caption());

            // place_of_receipt
            $this->place_of_receipt->setupEditAttributes();
            if (!$this->place_of_receipt->Raw) {
                $this->place_of_receipt->CurrentValue = HtmlDecode($this->place_of_receipt->CurrentValue);
            }
            $this->place_of_receipt->EditValue = HtmlEncode($this->place_of_receipt->CurrentValue);
            $this->place_of_receipt->PlaceHolder = RemoveHtml($this->place_of_receipt->caption());

            // loading_port
            $this->loading_port->setupEditAttributes();
            if (!$this->loading_port->Raw) {
                $this->loading_port->CurrentValue = HtmlDecode($this->loading_port->CurrentValue);
            }
            $this->loading_port->EditValue = HtmlEncode($this->loading_port->CurrentValue);
            $this->loading_port->PlaceHolder = RemoveHtml($this->loading_port->caption());

            // port_discharge
            $this->port_discharge->setupEditAttributes();
            if (!$this->port_discharge->Raw) {
                $this->port_discharge->CurrentValue = HtmlDecode($this->port_discharge->CurrentValue);
            }
            $this->port_discharge->EditValue = HtmlEncode($this->port_discharge->CurrentValue);
            $this->port_discharge->PlaceHolder = RemoveHtml($this->port_discharge->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // description_01
            $this->description_01->setupEditAttributes();
            if (!$this->description_01->Raw) {
                $this->description_01->CurrentValue = HtmlDecode($this->description_01->CurrentValue);
            }
            $this->description_01->EditValue = HtmlEncode($this->description_01->CurrentValue);
            $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // description_02
            $this->description_02->setupEditAttributes();
            if (!$this->description_02->Raw) {
                $this->description_02->CurrentValue = HtmlDecode($this->description_02->CurrentValue);
            }
            $this->description_02->EditValue = HtmlEncode($this->description_02->CurrentValue);
            $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

            // gross_weight
            $this->gross_weight->setupEditAttributes();
            if (!$this->gross_weight->Raw) {
                $this->gross_weight->CurrentValue = HtmlDecode($this->gross_weight->CurrentValue);
            }
            $this->gross_weight->EditValue = HtmlEncode($this->gross_weight->CurrentValue);
            $this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

            // nett_weight
            $this->nett_weight->setupEditAttributes();
            if (!$this->nett_weight->Raw) {
                $this->nett_weight->CurrentValue = HtmlDecode($this->nett_weight->CurrentValue);
            }
            $this->nett_weight->EditValue = HtmlEncode($this->nett_weight->CurrentValue);
            $this->nett_weight->PlaceHolder = RemoveHtml($this->nett_weight->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            if (!$this->cbm->Raw) {
                $this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
            }
            $this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // exporter_bank_details
            $this->exporter_bank_details->setupEditAttributes();
            $this->exporter_bank_details->EditValue = HtmlEncode($this->exporter_bank_details->CurrentValue);
            $this->exporter_bank_details->PlaceHolder = RemoveHtml($this->exporter_bank_details->caption());

            // intermediary_bank
            $this->intermediary_bank->setupEditAttributes();
            $this->intermediary_bank->EditValue = HtmlEncode($this->intermediary_bank->CurrentValue);
            $this->intermediary_bank->PlaceHolder = RemoveHtml($this->intermediary_bank->caption());

            // shipment_mode
            $this->shipment_mode->setupEditAttributes();
            $this->shipment_mode->EditValue = $this->shipment_mode->options(true);
            $this->shipment_mode->PlaceHolder = RemoveHtml($this->shipment_mode->caption());

            // ex_factory_date
            $this->ex_factory_date->setupEditAttributes();
            $this->ex_factory_date->EditValue = HtmlEncode(FormatDateTime($this->ex_factory_date->CurrentValue, $this->ex_factory_date->formatPattern()));
            $this->ex_factory_date->PlaceHolder = RemoveHtml($this->ex_factory_date->caption());

            // sailing_date
            $this->sailing_date->setupEditAttributes();
            $this->sailing_date->EditValue = HtmlEncode(FormatDateTime($this->sailing_date->CurrentValue, $this->sailing_date->formatPattern()));
            $this->sailing_date->PlaceHolder = RemoveHtml($this->sailing_date->caption());

            // operator

            // datetime

            // cart_lines
            $this->cart_lines->setupEditAttributes();
            if (!$this->cart_lines->Raw) {
                $this->cart_lines->CurrentValue = HtmlDecode($this->cart_lines->CurrentValue);
            }
            $this->cart_lines->EditValue = HtmlEncode($this->cart_lines->CurrentValue);
            $this->cart_lines->PlaceHolder = RemoveHtml($this->cart_lines->caption());

            // pl_lines
            $this->pl_lines->setupEditAttributes();
            if (!$this->pl_lines->Raw) {
                $this->pl_lines->CurrentValue = HtmlDecode($this->pl_lines->CurrentValue);
            }
            $this->pl_lines->EditValue = HtmlEncode($this->pl_lines->CurrentValue);
            $this->pl_lines->PlaceHolder = RemoveHtml($this->pl_lines->caption());

            // freezed
            $this->freezed->setupEditAttributes();
            $this->freezed->EditValue = $this->freezed->options(true);
            $this->freezed->PlaceHolder = RemoveHtml($this->freezed->caption());

            // port_delivery
            $this->port_delivery->setupEditAttributes();
            if (!$this->port_delivery->Raw) {
                $this->port_delivery->CurrentValue = HtmlDecode($this->port_delivery->CurrentValue);
            }
            $this->port_delivery->EditValue = HtmlEncode($this->port_delivery->CurrentValue);
            $this->port_delivery->PlaceHolder = RemoveHtml($this->port_delivery->caption());

            // dispatch_details
            $this->dispatch_details->setupEditAttributes();
            if (!$this->dispatch_details->Raw) {
                $this->dispatch_details->CurrentValue = HtmlDecode($this->dispatch_details->CurrentValue);
            }
            $this->dispatch_details->EditValue = HtmlEncode($this->dispatch_details->CurrentValue);
            $this->dispatch_details->PlaceHolder = RemoveHtml($this->dispatch_details->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // exporter
            $this->exporter->HrefValue = "";

            // consignee
            $this->consignee->HrefValue = "";

            // consignee_other
            $this->consignee_other->HrefValue = "";

            // packing_list_no
            $this->packing_list_no->HrefValue = "";

            // d_11
            $this->d_11->HrefValue = "";

            // description_11
            $this->description_11->HrefValue = "";

            // in_template
            $this->in_template->HrefValue = "";

            // pl_template
            $this->pl_template->HrefValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";

            // po_no
            $this->po_no->HrefValue = "";

            // other_reference
            $this->other_reference->HrefValue = "";

            // origin
            $this->origin->HrefValue = "";

            // final_destination
            $this->final_destination->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // pre_carriage_receipt
            $this->pre_carriage_receipt->HrefValue = "";

            // place_of_receipt
            $this->place_of_receipt->HrefValue = "";

            // loading_port
            $this->loading_port->HrefValue = "";

            // port_discharge
            $this->port_discharge->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // description_01
            $this->description_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // description_02
            $this->description_02->HrefValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";

            // nett_weight
            $this->nett_weight->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // exporter_bank_details
            $this->exporter_bank_details->HrefValue = "";

            // intermediary_bank
            $this->intermediary_bank->HrefValue = "";

            // shipment_mode
            $this->shipment_mode->HrefValue = "";

            // ex_factory_date
            $this->ex_factory_date->HrefValue = "";

            // sailing_date
            $this->sailing_date->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // cart_lines
            $this->cart_lines->HrefValue = "";

            // pl_lines
            $this->pl_lines->HrefValue = "";

            // freezed
            $this->freezed->HrefValue = "";

            // port_delivery
            $this->port_delivery->HrefValue = "";

            // dispatch_details
            $this->dispatch_details->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->exporter->Visible && $this->exporter->Required) {
                if (!$this->exporter->IsDetailKey && EmptyValue($this->exporter->FormValue)) {
                    $this->exporter->addErrorMessage(str_replace("%s", $this->exporter->caption(), $this->exporter->RequiredErrorMessage));
                }
            }
            if ($this->consignee->Visible && $this->consignee->Required) {
                if (!$this->consignee->IsDetailKey && EmptyValue($this->consignee->FormValue)) {
                    $this->consignee->addErrorMessage(str_replace("%s", $this->consignee->caption(), $this->consignee->RequiredErrorMessage));
                }
            }
            if ($this->consignee_other->Visible && $this->consignee_other->Required) {
                if (!$this->consignee_other->IsDetailKey && EmptyValue($this->consignee_other->FormValue)) {
                    $this->consignee_other->addErrorMessage(str_replace("%s", $this->consignee_other->caption(), $this->consignee_other->RequiredErrorMessage));
                }
            }
            if ($this->packing_list_no->Visible && $this->packing_list_no->Required) {
                if (!$this->packing_list_no->IsDetailKey && EmptyValue($this->packing_list_no->FormValue)) {
                    $this->packing_list_no->addErrorMessage(str_replace("%s", $this->packing_list_no->caption(), $this->packing_list_no->RequiredErrorMessage));
                }
            }
            if ($this->d_11->Visible && $this->d_11->Required) {
                if (!$this->d_11->IsDetailKey && EmptyValue($this->d_11->FormValue)) {
                    $this->d_11->addErrorMessage(str_replace("%s", $this->d_11->caption(), $this->d_11->RequiredErrorMessage));
                }
            }
            if ($this->description_11->Visible && $this->description_11->Required) {
                if (!$this->description_11->IsDetailKey && EmptyValue($this->description_11->FormValue)) {
                    $this->description_11->addErrorMessage(str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
                }
            }
            if ($this->in_template->Visible && $this->in_template->Required) {
                if (!$this->in_template->IsDetailKey && EmptyValue($this->in_template->FormValue)) {
                    $this->in_template->addErrorMessage(str_replace("%s", $this->in_template->caption(), $this->in_template->RequiredErrorMessage));
                }
            }
            if ($this->pl_template->Visible && $this->pl_template->Required) {
                if (!$this->pl_template->IsDetailKey && EmptyValue($this->pl_template->FormValue)) {
                    $this->pl_template->addErrorMessage(str_replace("%s", $this->pl_template->caption(), $this->pl_template->RequiredErrorMessage));
                }
            }
            if ($this->invoice_no->Visible && $this->invoice_no->Required) {
                if (!$this->invoice_no->IsDetailKey && EmptyValue($this->invoice_no->FormValue)) {
                    $this->invoice_no->addErrorMessage(str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
                }
            }
            if ($this->invoice_date->Visible && $this->invoice_date->Required) {
                if (!$this->invoice_date->IsDetailKey && EmptyValue($this->invoice_date->FormValue)) {
                    $this->invoice_date->addErrorMessage(str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->invoice_date->FormValue, $this->invoice_date->formatPattern())) {
                $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
            }
            if ($this->po_no->Visible && $this->po_no->Required) {
                if (!$this->po_no->IsDetailKey && EmptyValue($this->po_no->FormValue)) {
                    $this->po_no->addErrorMessage(str_replace("%s", $this->po_no->caption(), $this->po_no->RequiredErrorMessage));
                }
            }
            if ($this->other_reference->Visible && $this->other_reference->Required) {
                if (!$this->other_reference->IsDetailKey && EmptyValue($this->other_reference->FormValue)) {
                    $this->other_reference->addErrorMessage(str_replace("%s", $this->other_reference->caption(), $this->other_reference->RequiredErrorMessage));
                }
            }
            if ($this->origin->Visible && $this->origin->Required) {
                if (!$this->origin->IsDetailKey && EmptyValue($this->origin->FormValue)) {
                    $this->origin->addErrorMessage(str_replace("%s", $this->origin->caption(), $this->origin->RequiredErrorMessage));
                }
            }
            if ($this->final_destination->Visible && $this->final_destination->Required) {
                if (!$this->final_destination->IsDetailKey && EmptyValue($this->final_destination->FormValue)) {
                    $this->final_destination->addErrorMessage(str_replace("%s", $this->final_destination->caption(), $this->final_destination->RequiredErrorMessage));
                }
            }
            if ($this->payment_terms->Visible && $this->payment_terms->Required) {
                if (!$this->payment_terms->IsDetailKey && EmptyValue($this->payment_terms->FormValue)) {
                    $this->payment_terms->addErrorMessage(str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
                }
            }
            if ($this->pre_carriage_receipt->Visible && $this->pre_carriage_receipt->Required) {
                if (!$this->pre_carriage_receipt->IsDetailKey && EmptyValue($this->pre_carriage_receipt->FormValue)) {
                    $this->pre_carriage_receipt->addErrorMessage(str_replace("%s", $this->pre_carriage_receipt->caption(), $this->pre_carriage_receipt->RequiredErrorMessage));
                }
            }
            if ($this->place_of_receipt->Visible && $this->place_of_receipt->Required) {
                if (!$this->place_of_receipt->IsDetailKey && EmptyValue($this->place_of_receipt->FormValue)) {
                    $this->place_of_receipt->addErrorMessage(str_replace("%s", $this->place_of_receipt->caption(), $this->place_of_receipt->RequiredErrorMessage));
                }
            }
            if ($this->loading_port->Visible && $this->loading_port->Required) {
                if (!$this->loading_port->IsDetailKey && EmptyValue($this->loading_port->FormValue)) {
                    $this->loading_port->addErrorMessage(str_replace("%s", $this->loading_port->caption(), $this->loading_port->RequiredErrorMessage));
                }
            }
            if ($this->port_discharge->Visible && $this->port_discharge->Required) {
                if (!$this->port_discharge->IsDetailKey && EmptyValue($this->port_discharge->FormValue)) {
                    $this->port_discharge->addErrorMessage(str_replace("%s", $this->port_discharge->caption(), $this->port_discharge->RequiredErrorMessage));
                }
            }
            if ($this->d_01->Visible && $this->d_01->Required) {
                if (!$this->d_01->IsDetailKey && EmptyValue($this->d_01->FormValue)) {
                    $this->d_01->addErrorMessage(str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
                }
            }
            if ($this->description_01->Visible && $this->description_01->Required) {
                if (!$this->description_01->IsDetailKey && EmptyValue($this->description_01->FormValue)) {
                    $this->description_01->addErrorMessage(str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
                }
            }
            if ($this->d_02->Visible && $this->d_02->Required) {
                if (!$this->d_02->IsDetailKey && EmptyValue($this->d_02->FormValue)) {
                    $this->d_02->addErrorMessage(str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
                }
            }
            if ($this->description_02->Visible && $this->description_02->Required) {
                if (!$this->description_02->IsDetailKey && EmptyValue($this->description_02->FormValue)) {
                    $this->description_02->addErrorMessage(str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
                }
            }
            if ($this->gross_weight->Visible && $this->gross_weight->Required) {
                if (!$this->gross_weight->IsDetailKey && EmptyValue($this->gross_weight->FormValue)) {
                    $this->gross_weight->addErrorMessage(str_replace("%s", $this->gross_weight->caption(), $this->gross_weight->RequiredErrorMessage));
                }
            }
            if ($this->nett_weight->Visible && $this->nett_weight->Required) {
                if (!$this->nett_weight->IsDetailKey && EmptyValue($this->nett_weight->FormValue)) {
                    $this->nett_weight->addErrorMessage(str_replace("%s", $this->nett_weight->caption(), $this->nett_weight->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if ($this->exporter_bank_details->Visible && $this->exporter_bank_details->Required) {
                if (!$this->exporter_bank_details->IsDetailKey && EmptyValue($this->exporter_bank_details->FormValue)) {
                    $this->exporter_bank_details->addErrorMessage(str_replace("%s", $this->exporter_bank_details->caption(), $this->exporter_bank_details->RequiredErrorMessage));
                }
            }
            if ($this->intermediary_bank->Visible && $this->intermediary_bank->Required) {
                if (!$this->intermediary_bank->IsDetailKey && EmptyValue($this->intermediary_bank->FormValue)) {
                    $this->intermediary_bank->addErrorMessage(str_replace("%s", $this->intermediary_bank->caption(), $this->intermediary_bank->RequiredErrorMessage));
                }
            }
            if ($this->shipment_mode->Visible && $this->shipment_mode->Required) {
                if (!$this->shipment_mode->IsDetailKey && EmptyValue($this->shipment_mode->FormValue)) {
                    $this->shipment_mode->addErrorMessage(str_replace("%s", $this->shipment_mode->caption(), $this->shipment_mode->RequiredErrorMessage));
                }
            }
            if ($this->ex_factory_date->Visible && $this->ex_factory_date->Required) {
                if (!$this->ex_factory_date->IsDetailKey && EmptyValue($this->ex_factory_date->FormValue)) {
                    $this->ex_factory_date->addErrorMessage(str_replace("%s", $this->ex_factory_date->caption(), $this->ex_factory_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->ex_factory_date->FormValue, $this->ex_factory_date->formatPattern())) {
                $this->ex_factory_date->addErrorMessage($this->ex_factory_date->getErrorMessage(false));
            }
            if ($this->sailing_date->Visible && $this->sailing_date->Required) {
                if (!$this->sailing_date->IsDetailKey && EmptyValue($this->sailing_date->FormValue)) {
                    $this->sailing_date->addErrorMessage(str_replace("%s", $this->sailing_date->caption(), $this->sailing_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->sailing_date->FormValue, $this->sailing_date->formatPattern())) {
                $this->sailing_date->addErrorMessage($this->sailing_date->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->cart_lines->Visible && $this->cart_lines->Required) {
                if (!$this->cart_lines->IsDetailKey && EmptyValue($this->cart_lines->FormValue)) {
                    $this->cart_lines->addErrorMessage(str_replace("%s", $this->cart_lines->caption(), $this->cart_lines->RequiredErrorMessage));
                }
            }
            if ($this->pl_lines->Visible && $this->pl_lines->Required) {
                if (!$this->pl_lines->IsDetailKey && EmptyValue($this->pl_lines->FormValue)) {
                    $this->pl_lines->addErrorMessage(str_replace("%s", $this->pl_lines->caption(), $this->pl_lines->RequiredErrorMessage));
                }
            }
            if ($this->freezed->Visible && $this->freezed->Required) {
                if (!$this->freezed->IsDetailKey && EmptyValue($this->freezed->FormValue)) {
                    $this->freezed->addErrorMessage(str_replace("%s", $this->freezed->caption(), $this->freezed->RequiredErrorMessage));
                }
            }
            if ($this->port_delivery->Visible && $this->port_delivery->Required) {
                if (!$this->port_delivery->IsDetailKey && EmptyValue($this->port_delivery->FormValue)) {
                    $this->port_delivery->addErrorMessage(str_replace("%s", $this->port_delivery->caption(), $this->port_delivery->RequiredErrorMessage));
                }
            }
            if ($this->dispatch_details->Visible && $this->dispatch_details->Required) {
                if (!$this->dispatch_details->IsDetailKey && EmptyValue($this->dispatch_details->FormValue)) {
                    $this->dispatch_details->addErrorMessage(str_replace("%s", $this->dispatch_details->caption(), $this->dispatch_details->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (packing_list_no)
        if ($this->packing_list_no->CurrentValue != "") {
            $filterChk = "(`packing_list_no` = " . AdjustSql($this->packing_list_no->CurrentValue, $this->Dbid) . ")";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->packing_list_no->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->packing_list_no->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Check field with unique index (invoice_no)
        if ($this->invoice_no->CurrentValue != "") {
            $filterChk = "(`invoice_no` = '" . AdjustSql($this->invoice_no->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->invoice_no->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->invoice_no->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // barcode
        $this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, $this->_barcode->ReadOnly);

        // exporter
        $this->exporter->setDbValueDef($rsnew, $this->exporter->CurrentValue, $this->exporter->ReadOnly);

        // consignee
        $this->consignee->setDbValueDef($rsnew, $this->consignee->CurrentValue, $this->consignee->ReadOnly);

        // consignee_other
        $this->consignee_other->setDbValueDef($rsnew, $this->consignee_other->CurrentValue, $this->consignee_other->ReadOnly);

        // packing_list_no
        $this->packing_list_no->setDbValueDef($rsnew, $this->packing_list_no->CurrentValue, $this->packing_list_no->ReadOnly);

        // d_11
        $this->d_11->setDbValueDef($rsnew, $this->d_11->CurrentValue, $this->d_11->ReadOnly);

        // description_11
        $this->description_11->setDbValueDef($rsnew, $this->description_11->CurrentValue, $this->description_11->ReadOnly);

        // in_template
        $this->in_template->setDbValueDef($rsnew, $this->in_template->CurrentValue, $this->in_template->ReadOnly);

        // pl_template
        $this->pl_template->setDbValueDef($rsnew, $this->pl_template->CurrentValue, $this->pl_template->ReadOnly);

        // invoice_no
        $this->invoice_no->setDbValueDef($rsnew, $this->invoice_no->CurrentValue, $this->invoice_no->ReadOnly);

        // invoice_date
        $this->invoice_date->setDbValueDef($rsnew, UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern()), $this->invoice_date->ReadOnly);

        // po_no
        $this->po_no->setDbValueDef($rsnew, $this->po_no->CurrentValue, $this->po_no->ReadOnly);

        // other_reference
        $this->other_reference->setDbValueDef($rsnew, $this->other_reference->CurrentValue, $this->other_reference->ReadOnly);

        // origin
        $this->origin->setDbValueDef($rsnew, $this->origin->CurrentValue, $this->origin->ReadOnly);

        // final_destination
        $this->final_destination->setDbValueDef($rsnew, $this->final_destination->CurrentValue, $this->final_destination->ReadOnly);

        // payment_terms
        $this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, $this->payment_terms->ReadOnly);

        // pre_carriage_receipt
        $this->pre_carriage_receipt->setDbValueDef($rsnew, $this->pre_carriage_receipt->CurrentValue, $this->pre_carriage_receipt->ReadOnly);

        // place_of_receipt
        $this->place_of_receipt->setDbValueDef($rsnew, $this->place_of_receipt->CurrentValue, $this->place_of_receipt->ReadOnly);

        // loading_port
        $this->loading_port->setDbValueDef($rsnew, $this->loading_port->CurrentValue, $this->loading_port->ReadOnly);

        // port_discharge
        $this->port_discharge->setDbValueDef($rsnew, $this->port_discharge->CurrentValue, $this->port_discharge->ReadOnly);

        // d_01
        $this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, $this->d_01->ReadOnly);

        // description_01
        $this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, $this->description_01->ReadOnly);

        // d_02
        $this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, $this->d_02->ReadOnly);

        // description_02
        $this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, $this->description_02->ReadOnly);

        // gross_weight
        $this->gross_weight->setDbValueDef($rsnew, $this->gross_weight->CurrentValue, $this->gross_weight->ReadOnly);

        // nett_weight
        $this->nett_weight->setDbValueDef($rsnew, $this->nett_weight->CurrentValue, $this->nett_weight->ReadOnly);

        // cbm
        $this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, $this->cbm->ReadOnly);

        // exporter_bank_details
        $this->exporter_bank_details->setDbValueDef($rsnew, $this->exporter_bank_details->CurrentValue, $this->exporter_bank_details->ReadOnly);

        // intermediary_bank
        $this->intermediary_bank->setDbValueDef($rsnew, $this->intermediary_bank->CurrentValue, $this->intermediary_bank->ReadOnly);

        // shipment_mode
        $this->shipment_mode->setDbValueDef($rsnew, $this->shipment_mode->CurrentValue, $this->shipment_mode->ReadOnly);

        // ex_factory_date
        $this->ex_factory_date->setDbValueDef($rsnew, UnFormatDateTime($this->ex_factory_date->CurrentValue, $this->ex_factory_date->formatPattern()), $this->ex_factory_date->ReadOnly);

        // sailing_date
        $this->sailing_date->setDbValueDef($rsnew, UnFormatDateTime($this->sailing_date->CurrentValue, $this->sailing_date->formatPattern()), $this->sailing_date->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // cart_lines
        $this->cart_lines->setDbValueDef($rsnew, $this->cart_lines->CurrentValue, $this->cart_lines->ReadOnly);

        // pl_lines
        $this->pl_lines->setDbValueDef($rsnew, $this->pl_lines->CurrentValue, $this->pl_lines->ReadOnly);

        // freezed
        $this->freezed->setDbValueDef($rsnew, $this->freezed->CurrentValue, $this->freezed->ReadOnly);

        // port_delivery
        $this->port_delivery->setDbValueDef($rsnew, $this->port_delivery->CurrentValue, $this->port_delivery->ReadOnly);

        // dispatch_details
        $this->dispatch_details->setDbValueDef($rsnew, $this->dispatch_details->CurrentValue, $this->dispatch_details->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['barcode'])) { // barcode
            $this->_barcode->CurrentValue = $row['barcode'];
        }
        if (isset($row['exporter'])) { // exporter
            $this->exporter->CurrentValue = $row['exporter'];
        }
        if (isset($row['consignee'])) { // consignee
            $this->consignee->CurrentValue = $row['consignee'];
        }
        if (isset($row['consignee_other'])) { // consignee_other
            $this->consignee_other->CurrentValue = $row['consignee_other'];
        }
        if (isset($row['packing_list_no'])) { // packing_list_no
            $this->packing_list_no->CurrentValue = $row['packing_list_no'];
        }
        if (isset($row['d_11'])) { // d_11
            $this->d_11->CurrentValue = $row['d_11'];
        }
        if (isset($row['description_11'])) { // description_11
            $this->description_11->CurrentValue = $row['description_11'];
        }
        if (isset($row['in_template'])) { // in_template
            $this->in_template->CurrentValue = $row['in_template'];
        }
        if (isset($row['pl_template'])) { // pl_template
            $this->pl_template->CurrentValue = $row['pl_template'];
        }
        if (isset($row['invoice_no'])) { // invoice_no
            $this->invoice_no->CurrentValue = $row['invoice_no'];
        }
        if (isset($row['invoice_date'])) { // invoice_date
            $this->invoice_date->CurrentValue = $row['invoice_date'];
        }
        if (isset($row['po_no'])) { // po_no
            $this->po_no->CurrentValue = $row['po_no'];
        }
        if (isset($row['other_reference'])) { // other_reference
            $this->other_reference->CurrentValue = $row['other_reference'];
        }
        if (isset($row['origin'])) { // origin
            $this->origin->CurrentValue = $row['origin'];
        }
        if (isset($row['final_destination'])) { // final_destination
            $this->final_destination->CurrentValue = $row['final_destination'];
        }
        if (isset($row['payment_terms'])) { // payment_terms
            $this->payment_terms->CurrentValue = $row['payment_terms'];
        }
        if (isset($row['pre_carriage_receipt'])) { // pre_carriage_receipt
            $this->pre_carriage_receipt->CurrentValue = $row['pre_carriage_receipt'];
        }
        if (isset($row['place_of_receipt'])) { // place_of_receipt
            $this->place_of_receipt->CurrentValue = $row['place_of_receipt'];
        }
        if (isset($row['loading_port'])) { // loading_port
            $this->loading_port->CurrentValue = $row['loading_port'];
        }
        if (isset($row['port_discharge'])) { // port_discharge
            $this->port_discharge->CurrentValue = $row['port_discharge'];
        }
        if (isset($row['d_01'])) { // d_01
            $this->d_01->CurrentValue = $row['d_01'];
        }
        if (isset($row['description_01'])) { // description_01
            $this->description_01->CurrentValue = $row['description_01'];
        }
        if (isset($row['d_02'])) { // d_02
            $this->d_02->CurrentValue = $row['d_02'];
        }
        if (isset($row['description_02'])) { // description_02
            $this->description_02->CurrentValue = $row['description_02'];
        }
        if (isset($row['gross_weight'])) { // gross_weight
            $this->gross_weight->CurrentValue = $row['gross_weight'];
        }
        if (isset($row['nett_weight'])) { // nett_weight
            $this->nett_weight->CurrentValue = $row['nett_weight'];
        }
        if (isset($row['cbm'])) { // cbm
            $this->cbm->CurrentValue = $row['cbm'];
        }
        if (isset($row['exporter_bank_details'])) { // exporter_bank_details
            $this->exporter_bank_details->CurrentValue = $row['exporter_bank_details'];
        }
        if (isset($row['intermediary_bank'])) { // intermediary_bank
            $this->intermediary_bank->CurrentValue = $row['intermediary_bank'];
        }
        if (isset($row['shipment_mode'])) { // shipment_mode
            $this->shipment_mode->CurrentValue = $row['shipment_mode'];
        }
        if (isset($row['ex_factory_date'])) { // ex_factory_date
            $this->ex_factory_date->CurrentValue = $row['ex_factory_date'];
        }
        if (isset($row['sailing_date'])) { // sailing_date
            $this->sailing_date->CurrentValue = $row['sailing_date'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['cart_lines'])) { // cart_lines
            $this->cart_lines->CurrentValue = $row['cart_lines'];
        }
        if (isset($row['pl_lines'])) { // pl_lines
            $this->pl_lines->CurrentValue = $row['pl_lines'];
        }
        if (isset($row['freezed'])) { // freezed
            $this->freezed->CurrentValue = $row['freezed'];
        }
        if (isset($row['port_delivery'])) { // port_delivery
            $this->port_delivery->CurrentValue = $row['port_delivery'];
        }
        if (isset($row['dispatch_details'])) { // dispatch_details
            $this->dispatch_details->CurrentValue = $row['dispatch_details'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("invoicedetailslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_exporter":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee_other":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_list_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_in_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipment_mode":
                    break;
                case "x_freezed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
