<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class InvoiceDetailsDelete extends InvoiceDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InvoiceDetailsDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "invoicedetailsdelete";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->_barcode->Visible = false;
        $this->exporter->setVisibility();
        $this->consignee->setVisibility();
        $this->consignee_other->setVisibility();
        $this->packing_list_no->setVisibility();
        $this->d_11->setVisibility();
        $this->description_11->Visible = false;
        $this->in_template->setVisibility();
        $this->pl_template->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->po_no->setVisibility();
        $this->other_reference->setVisibility();
        $this->origin->setVisibility();
        $this->final_destination->setVisibility();
        $this->payment_terms->setVisibility();
        $this->pre_carriage_receipt->setVisibility();
        $this->place_of_receipt->setVisibility();
        $this->loading_port->setVisibility();
        $this->port_discharge->setVisibility();
        $this->d_01->setVisibility();
        $this->description_01->setVisibility();
        $this->d_02->setVisibility();
        $this->description_02->setVisibility();
        $this->gross_weight->setVisibility();
        $this->nett_weight->setVisibility();
        $this->cbm->setVisibility();
        $this->exporter_bank_details->Visible = false;
        $this->intermediary_bank->Visible = false;
        $this->shipment_mode->setVisibility();
        $this->ex_factory_date->setVisibility();
        $this->sailing_date->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->delivery_terms->Visible = false;
        $this->po_date->Visible = false;
        $this->cart_lines->setVisibility();
        $this->pl_lines->setVisibility();
        $this->freezed->setVisibility();
        $this->pl_pdf->Visible = false;
        $this->in_pdf->Visible = false;
        $this->a_operator->setVisibility();
        $this->port_delivery->setVisibility();
        $this->dispatch_details->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'invoice_details';
        $this->TableName = 'invoice_details';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (invoice_details)
        if (!isset($GLOBALS["invoice_details"]) || $GLOBALS["invoice_details"]::class == PROJECT_NAMESPACE . "invoice_details") {
            $GLOBALS["invoice_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->exporter);
        $this->setupLookupOptions($this->consignee);
        $this->setupLookupOptions($this->consignee_other);
        $this->setupLookupOptions($this->packing_list_no);
        $this->setupLookupOptions($this->in_template);
        $this->setupLookupOptions($this->pl_template);
        $this->setupLookupOptions($this->shipment_mode);
        $this->setupLookupOptions($this->freezed);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("invoicedetailslist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("invoicedetailslist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->exporter->setDbValue($row['exporter']);
        $this->consignee->setDbValue($row['consignee']);
        $this->consignee_other->setDbValue($row['consignee_other']);
        $this->packing_list_no->setDbValue($row['packing_list_no']);
        $this->d_11->setDbValue($row['d_11']);
        $this->description_11->setDbValue($row['description_11']);
        $this->in_template->setDbValue($row['in_template']);
        $this->pl_template->setDbValue($row['pl_template']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->po_no->setDbValue($row['po_no']);
        $this->other_reference->setDbValue($row['other_reference']);
        $this->origin->setDbValue($row['origin']);
        $this->final_destination->setDbValue($row['final_destination']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
        $this->place_of_receipt->setDbValue($row['place_of_receipt']);
        $this->loading_port->setDbValue($row['loading_port']);
        $this->port_discharge->setDbValue($row['port_discharge']);
        $this->d_01->setDbValue($row['d_01']);
        $this->description_01->setDbValue($row['description_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->description_02->setDbValue($row['description_02']);
        $this->gross_weight->setDbValue($row['gross_weight']);
        $this->nett_weight->setDbValue($row['nett_weight']);
        $this->cbm->setDbValue($row['cbm']);
        $this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
        $this->intermediary_bank->setDbValue($row['intermediary_bank']);
        $this->shipment_mode->setDbValue($row['shipment_mode']);
        $this->ex_factory_date->setDbValue($row['ex_factory_date']);
        $this->sailing_date->setDbValue($row['sailing_date']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->po_date->setDbValue($row['po_date']);
        $this->cart_lines->setDbValue($row['cart_lines']);
        $this->pl_lines->setDbValue($row['pl_lines']);
        $this->freezed->setDbValue($row['freezed']);
        $this->pl_pdf->setDbValue($row['pl_pdf']);
        $this->in_pdf->setDbValue($row['in_pdf']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->port_delivery->setDbValue($row['port_delivery']);
        $this->dispatch_details->setDbValue($row['dispatch_details']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['exporter'] = $this->exporter->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['consignee_other'] = $this->consignee_other->DefaultValue;
        $row['packing_list_no'] = $this->packing_list_no->DefaultValue;
        $row['d_11'] = $this->d_11->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['in_template'] = $this->in_template->DefaultValue;
        $row['pl_template'] = $this->pl_template->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['po_no'] = $this->po_no->DefaultValue;
        $row['other_reference'] = $this->other_reference->DefaultValue;
        $row['origin'] = $this->origin->DefaultValue;
        $row['final_destination'] = $this->final_destination->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['pre_carriage_receipt'] = $this->pre_carriage_receipt->DefaultValue;
        $row['place_of_receipt'] = $this->place_of_receipt->DefaultValue;
        $row['loading_port'] = $this->loading_port->DefaultValue;
        $row['port_discharge'] = $this->port_discharge->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['gross_weight'] = $this->gross_weight->DefaultValue;
        $row['nett_weight'] = $this->nett_weight->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['exporter_bank_details'] = $this->exporter_bank_details->DefaultValue;
        $row['intermediary_bank'] = $this->intermediary_bank->DefaultValue;
        $row['shipment_mode'] = $this->shipment_mode->DefaultValue;
        $row['ex_factory_date'] = $this->ex_factory_date->DefaultValue;
        $row['sailing_date'] = $this->sailing_date->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['po_date'] = $this->po_date->DefaultValue;
        $row['cart_lines'] = $this->cart_lines->DefaultValue;
        $row['pl_lines'] = $this->pl_lines->DefaultValue;
        $row['freezed'] = $this->freezed->DefaultValue;
        $row['pl_pdf'] = $this->pl_pdf->DefaultValue;
        $row['in_pdf'] = $this->in_pdf->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['port_delivery'] = $this->port_delivery->DefaultValue;
        $row['dispatch_details'] = $this->dispatch_details->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // barcode

        // exporter

        // consignee

        // consignee_other

        // packing_list_no

        // d_11

        // description_11

        // in_template

        // pl_template

        // invoice_no

        // invoice_date

        // po_no

        // other_reference

        // origin

        // final_destination

        // payment_terms

        // pre_carriage_receipt

        // place_of_receipt

        // loading_port

        // port_discharge

        // d_01

        // description_01

        // d_02

        // description_02

        // gross_weight

        // nett_weight

        // cbm

        // exporter_bank_details

        // intermediary_bank

        // shipment_mode

        // ex_factory_date

        // sailing_date

        // operator

        // datetime

        // delivery_terms
        $this->delivery_terms->CellCssStyle = "white-space: nowrap;";

        // po_date
        $this->po_date->CellCssStyle = "white-space: nowrap;";

        // cart_lines

        // pl_lines

        // freezed

        // pl_pdf
        $this->pl_pdf->CellCssStyle = "white-space: nowrap;";

        // in_pdf
        $this->in_pdf->CellCssStyle = "white-space: nowrap;";

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // port_delivery

        // dispatch_details

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // exporter
            $curVal = strval($this->exporter->CurrentValue);
            if ($curVal != "") {
                $this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
                if ($this->exporter->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                    $sqlWrk = $this->exporter->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->exporter->Lookup->renderViewRow($rswrk[0]);
                        $this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
                    } else {
                        $this->exporter->ViewValue = $this->exporter->CurrentValue;
                    }
                }
            } else {
                $this->exporter->ViewValue = null;
            }

            // consignee
            $curVal = strval($this->consignee->CurrentValue);
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
                if ($this->consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                    } else {
                        $this->consignee->ViewValue = $this->consignee->CurrentValue;
                    }
                }
            } else {
                $this->consignee->ViewValue = null;
            }

            // consignee_other
            $curVal = strval($this->consignee_other->CurrentValue);
            if ($curVal != "") {
                $this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
                if ($this->consignee_other->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee_other->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
                    } else {
                        $this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
                    }
                }
            } else {
                $this->consignee_other->ViewValue = null;
            }

            // packing_list_no
            $curVal = strval($this->packing_list_no->CurrentValue);
            if ($curVal != "") {
                $this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
                if ($this->packing_list_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $curVal, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                    $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_list_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_list_no->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
                    } else {
                        $this->packing_list_no->ViewValue = FormatNumber($this->packing_list_no->CurrentValue, $this->packing_list_no->formatPattern());
                    }
                }
            } else {
                $this->packing_list_no->ViewValue = null;
            }

            // d_11
            $this->d_11->ViewValue = $this->d_11->CurrentValue;

            // in_template
            $curVal = strval($this->in_template->CurrentValue);
            if ($curVal != "") {
                $this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
                if ($this->in_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->in_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->in_template->Lookup->renderViewRow($rswrk[0]);
                        $this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
                    } else {
                        $this->in_template->ViewValue = $this->in_template->CurrentValue;
                    }
                }
            } else {
                $this->in_template->ViewValue = null;
            }

            // pl_template
            $curVal = strval($this->pl_template->CurrentValue);
            if ($curVal != "") {
                $this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
                if ($this->pl_template->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_template->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
                    } else {
                        $this->pl_template->ViewValue = $this->pl_template->CurrentValue;
                    }
                }
            } else {
                $this->pl_template->ViewValue = null;
            }

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // po_no
            $this->po_no->ViewValue = $this->po_no->CurrentValue;

            // other_reference
            $this->other_reference->ViewValue = $this->other_reference->CurrentValue;

            // origin
            $this->origin->ViewValue = $this->origin->CurrentValue;

            // final_destination
            $this->final_destination->ViewValue = $this->final_destination->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // pre_carriage_receipt
            $this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;

            // place_of_receipt
            $this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;

            // loading_port
            $this->loading_port->ViewValue = $this->loading_port->CurrentValue;

            // port_discharge
            $this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // description_01
            $this->description_01->ViewValue = $this->description_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // description_02
            $this->description_02->ViewValue = $this->description_02->CurrentValue;

            // gross_weight
            $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;

            // nett_weight
            $this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // shipment_mode
            if (strval($this->shipment_mode->CurrentValue) != "") {
                $this->shipment_mode->ViewValue = $this->shipment_mode->optionCaption($this->shipment_mode->CurrentValue);
            } else {
                $this->shipment_mode->ViewValue = null;
            }

            // ex_factory_date
            $this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
            $this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, $this->ex_factory_date->formatPattern());

            // sailing_date
            $this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
            $this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, $this->sailing_date->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // cart_lines
            $this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;

            // pl_lines
            $this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;

            // freezed
            if (strval($this->freezed->CurrentValue) != "") {
                $this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
            } else {
                $this->freezed->ViewValue = null;
            }

            // a_operator
            $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
            $this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, $this->a_operator->formatPattern());

            // port_delivery
            $this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;

            // dispatch_details
            $this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // exporter
            $this->exporter->HrefValue = "";
            $this->exporter->TooltipValue = "";

            // consignee
            $this->consignee->HrefValue = "";
            $this->consignee->TooltipValue = "";

            // consignee_other
            $this->consignee_other->HrefValue = "";
            $this->consignee_other->TooltipValue = "";

            // packing_list_no
            $this->packing_list_no->HrefValue = "";
            $this->packing_list_no->TooltipValue = "";

            // d_11
            $this->d_11->HrefValue = "";
            $this->d_11->TooltipValue = "";

            // in_template
            $this->in_template->HrefValue = "";
            $this->in_template->TooltipValue = "";

            // pl_template
            $this->pl_template->HrefValue = "";
            $this->pl_template->TooltipValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // po_no
            $this->po_no->HrefValue = "";
            $this->po_no->TooltipValue = "";

            // other_reference
            $this->other_reference->HrefValue = "";
            $this->other_reference->TooltipValue = "";

            // origin
            $this->origin->HrefValue = "";
            $this->origin->TooltipValue = "";

            // final_destination
            $this->final_destination->HrefValue = "";
            $this->final_destination->TooltipValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // pre_carriage_receipt
            $this->pre_carriage_receipt->HrefValue = "";
            $this->pre_carriage_receipt->TooltipValue = "";

            // place_of_receipt
            $this->place_of_receipt->HrefValue = "";
            $this->place_of_receipt->TooltipValue = "";

            // loading_port
            $this->loading_port->HrefValue = "";
            $this->loading_port->TooltipValue = "";

            // port_discharge
            $this->port_discharge->HrefValue = "";
            $this->port_discharge->TooltipValue = "";

            // d_01
            $this->d_01->HrefValue = "";
            $this->d_01->TooltipValue = "";

            // description_01
            $this->description_01->HrefValue = "";
            $this->description_01->TooltipValue = "";

            // d_02
            $this->d_02->HrefValue = "";
            $this->d_02->TooltipValue = "";

            // description_02
            $this->description_02->HrefValue = "";
            $this->description_02->TooltipValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";
            $this->gross_weight->TooltipValue = "";

            // nett_weight
            $this->nett_weight->HrefValue = "";
            $this->nett_weight->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // shipment_mode
            $this->shipment_mode->HrefValue = "";
            $this->shipment_mode->TooltipValue = "";

            // ex_factory_date
            $this->ex_factory_date->HrefValue = "";
            $this->ex_factory_date->TooltipValue = "";

            // sailing_date
            $this->sailing_date->HrefValue = "";
            $this->sailing_date->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // cart_lines
            $this->cart_lines->HrefValue = "";
            $this->cart_lines->TooltipValue = "";

            // pl_lines
            $this->pl_lines->HrefValue = "";
            $this->pl_lines->TooltipValue = "";

            // freezed
            $this->freezed->HrefValue = "";
            $this->freezed->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // port_delivery
            $this->port_delivery->HrefValue = "";
            $this->port_delivery->TooltipValue = "";

            // dispatch_details
            $this->dispatch_details->HrefValue = "";
            $this->dispatch_details->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("invoicedetailslist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_exporter":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee_other":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_list_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_in_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_template":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipment_mode":
                    break;
                case "x_freezed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
