<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for invoice_details
 */
class InvoiceDetails extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $_barcode;
    public $exporter;
    public $consignee;
    public $consignee_other;
    public $packing_list_no;
    public $d_11;
    public $description_11;
    public $in_template;
    public $pl_template;
    public $invoice_no;
    public $invoice_date;
    public $po_no;
    public $other_reference;
    public $origin;
    public $final_destination;
    public $payment_terms;
    public $pre_carriage_receipt;
    public $place_of_receipt;
    public $loading_port;
    public $port_discharge;
    public $d_01;
    public $description_01;
    public $d_02;
    public $description_02;
    public $gross_weight;
    public $nett_weight;
    public $cbm;
    public $exporter_bank_details;
    public $intermediary_bank;
    public $shipment_mode;
    public $ex_factory_date;
    public $sailing_date;
    public $operator;
    public $datetime;
    public $delivery_terms;
    public $po_date;
    public $cart_lines;
    public $pl_lines;
    public $freezed;
    public $pl_pdf;
    public $in_pdf;
    public $a_operator;
    public $port_delivery;
    public $dispatch_details;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "invoice_details";
        $this->TableName = 'invoice_details';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "invoice_details";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // exporter
        $this->exporter = new DbField(
            $this, // Table
            'x_exporter', // Variable name
            'exporter', // Name
            '`exporter`', // Expression
            '`exporter`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`exporter`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->exporter->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->exporter->InputTextType = "text";
        $this->exporter->Required = true; // Required field
        $this->exporter->setSelectMultiple(false); // Select one
        $this->exporter->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->exporter->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->exporter->Lookup = new Lookup($this->exporter, 'production_partner', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->exporter) . "',COALESCE(`code`,''))");
        $this->exporter->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['exporter'] = &$this->exporter;

        // consignee
        $this->consignee = new DbField(
            $this, // Table
            'x_consignee', // Variable name
            'consignee', // Name
            '`consignee`', // Expression
            '`consignee`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consignee`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->consignee->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->consignee->InputTextType = "text";
        $this->consignee->Required = true; // Required field
        $this->consignee->setSelectMultiple(false); // Select one
        $this->consignee->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->consignee->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->consignee->Lookup = new Lookup($this->consignee, 'buyer', false, 'id', ["name","code","",""], '', '', [], ["x_packing_list_no"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->consignee) . "',COALESCE(`code`,''))");
        $this->consignee->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['consignee'] = &$this->consignee;

        // consignee_other
        $this->consignee_other = new DbField(
            $this, // Table
            'x_consignee_other', // Variable name
            'consignee_other', // Name
            '`consignee_other`', // Expression
            '`consignee_other`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consignee_other`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->consignee_other->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->consignee_other->InputTextType = "text";
        $this->consignee_other->setSelectMultiple(false); // Select one
        $this->consignee_other->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->consignee_other->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->consignee_other->Lookup = new Lookup($this->consignee_other, 'buyer', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`grp` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->consignee_other) . "',COALESCE(`code`,''))");
        $this->consignee_other->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['consignee_other'] = &$this->consignee_other;

        // packing_list_no
        $this->packing_list_no = new DbField(
            $this, // Table
            'x_packing_list_no', // Variable name
            'packing_list_no', // Name
            '`packing_list_no`', // Expression
            '`packing_list_no`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_list_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_list_no->addMethod("getSelectFilter", fn() => "`pl_no` != 0");
        $this->packing_list_no->InputTextType = "text";
        $this->packing_list_no->Raw = true;
        $this->packing_list_no->setSelectMultiple(false); // Select one
        $this->packing_list_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_list_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_list_no->Lookup = new Lookup($this->packing_list_no, 'bcode', true, 'pl_no', ["pl_no","","",""], '', '', ["x_consignee"], [], ["buyers_id"], ["x_buyers_id"], [], [], false, '`pl_no` DESC', '', "`pl_no`");
        $this->packing_list_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->packing_list_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_list_no'] = &$this->packing_list_no;

        // d_11
        $this->d_11 = new DbField(
            $this, // Table
            'x_d_11', // Variable name
            'd_11', // Name
            '`d_11`', // Expression
            '`d_11`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_11->InputTextType = "text";
        $this->d_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_11'] = &$this->d_11;

        // description_11
        $this->description_11 = new DbField(
            $this, // Table
            'x_description_11', // Variable name
            'description_11', // Name
            '`description_11`', // Expression
            '`description_11`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->description_11->InputTextType = "text";
        $this->description_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_11'] = &$this->description_11;

        // in_template
        $this->in_template = new DbField(
            $this, // Table
            'x_in_template', // Variable name
            'in_template', // Name
            '`in_template`', // Expression
            '`in_template`', // Basic search expression
            200, // Type
            92, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`in_template`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->in_template->addMethod("getSelectFilter", fn() => "`apcid` between 45501 and 45999");
        $this->in_template->InputTextType = "text";
        $this->in_template->setSelectMultiple(false); // Select one
        $this->in_template->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->in_template->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->in_template->Lookup = new Lookup($this->in_template, 'apc', false, 'id', ["description","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`description`");
        $this->in_template->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->in_template->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['in_template'] = &$this->in_template;

        // pl_template
        $this->pl_template = new DbField(
            $this, // Table
            'x_pl_template', // Variable name
            'pl_template', // Name
            '`pl_template`', // Expression
            '`pl_template`', // Basic search expression
            200, // Type
            92, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_template`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pl_template->addMethod("getSelectFilter", fn() => "`apcid` between 45001 and 45500");
        $this->pl_template->InputTextType = "text";
        $this->pl_template->setSelectMultiple(false); // Select one
        $this->pl_template->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pl_template->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pl_template->Lookup = new Lookup($this->pl_template, 'apc', false, 'id', ["description","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`description`");
        $this->pl_template->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pl_template->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_template'] = &$this->pl_template;

        // invoice_no
        $this->invoice_no = new DbField(
            $this, // Table
            'x_invoice_no', // Variable name
            'invoice_no', // Name
            '`invoice_no`', // Expression
            '`invoice_no`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_no->InputTextType = "text";
        $this->invoice_no->Required = true; // Required field
        $this->invoice_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_no'] = &$this->invoice_no;

        // invoice_date
        $this->invoice_date = new DbField(
            $this, // Table
            'x_invoice_date', // Variable name
            'invoice_date', // Name
            '`invoice_date`', // Expression
            CastDateFieldForLike("`invoice_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`invoice_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_date->addMethod("getDefault", fn() => CurrentDate());
        $this->invoice_date->InputTextType = "text";
        $this->invoice_date->Raw = true;
        $this->invoice_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->invoice_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_date'] = &$this->invoice_date;

        // po_no
        $this->po_no = new DbField(
            $this, // Table
            'x_po_no', // Variable name
            'po_no', // Name
            '`po_no`', // Expression
            '`po_no`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->po_no->InputTextType = "text";
        $this->po_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_no'] = &$this->po_no;

        // other_reference
        $this->other_reference = new DbField(
            $this, // Table
            'x_other_reference', // Variable name
            'other_reference', // Name
            '`other_reference`', // Expression
            '`other_reference`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`other_reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->other_reference->InputTextType = "text";
        $this->other_reference->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['other_reference'] = &$this->other_reference;

        // origin
        $this->origin = new DbField(
            $this, // Table
            'x_origin', // Variable name
            'origin', // Name
            '`origin`', // Expression
            '`origin`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`origin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->origin->InputTextType = "text";
        $this->origin->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['origin'] = &$this->origin;

        // final_destination
        $this->final_destination = new DbField(
            $this, // Table
            'x_final_destination', // Variable name
            'final_destination', // Name
            '`final_destination`', // Expression
            '`final_destination`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`final_destination`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->final_destination->InputTextType = "text";
        $this->final_destination->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['final_destination'] = &$this->final_destination;

        // payment_terms
        $this->payment_terms = new DbField(
            $this, // Table
            'x_payment_terms', // Variable name
            'payment_terms', // Name
            '`payment_terms`', // Expression
            '`payment_terms`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->payment_terms->InputTextType = "text";
        $this->payment_terms->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment_terms'] = &$this->payment_terms;

        // pre_carriage_receipt
        $this->pre_carriage_receipt = new DbField(
            $this, // Table
            'x_pre_carriage_receipt', // Variable name
            'pre_carriage_receipt', // Name
            '`pre_carriage_receipt`', // Expression
            '`pre_carriage_receipt`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pre_carriage_receipt`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pre_carriage_receipt->InputTextType = "text";
        $this->pre_carriage_receipt->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pre_carriage_receipt'] = &$this->pre_carriage_receipt;

        // place_of_receipt
        $this->place_of_receipt = new DbField(
            $this, // Table
            'x_place_of_receipt', // Variable name
            'place_of_receipt', // Name
            '`place_of_receipt`', // Expression
            '`place_of_receipt`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`place_of_receipt`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->place_of_receipt->InputTextType = "text";
        $this->place_of_receipt->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['place_of_receipt'] = &$this->place_of_receipt;

        // loading_port
        $this->loading_port = new DbField(
            $this, // Table
            'x_loading_port', // Variable name
            'loading_port', // Name
            '`loading_port`', // Expression
            '`loading_port`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`loading_port`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->loading_port->InputTextType = "text";
        $this->loading_port->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['loading_port'] = &$this->loading_port;

        // port_discharge
        $this->port_discharge = new DbField(
            $this, // Table
            'x_port_discharge', // Variable name
            'port_discharge', // Name
            '`port_discharge`', // Expression
            '`port_discharge`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`port_discharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->port_discharge->InputTextType = "text";
        $this->port_discharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_discharge'] = &$this->port_discharge;

        // d_01
        $this->d_01 = new DbField(
            $this, // Table
            'x_d_01', // Variable name
            'd_01', // Name
            '`d_01`', // Expression
            '`d_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_01->InputTextType = "text";
        $this->d_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_01'] = &$this->d_01;

        // description_01
        $this->description_01 = new DbField(
            $this, // Table
            'x_description_01', // Variable name
            'description_01', // Name
            '`description_01`', // Expression
            '`description_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_01->InputTextType = "text";
        $this->description_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_01'] = &$this->description_01;

        // d_02
        $this->d_02 = new DbField(
            $this, // Table
            'x_d_02', // Variable name
            'd_02', // Name
            '`d_02`', // Expression
            '`d_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_02->InputTextType = "text";
        $this->d_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_02'] = &$this->d_02;

        // description_02
        $this->description_02 = new DbField(
            $this, // Table
            'x_description_02', // Variable name
            'description_02', // Name
            '`description_02`', // Expression
            '`description_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_02->InputTextType = "text";
        $this->description_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_02'] = &$this->description_02;

        // gross_weight
        $this->gross_weight = new DbField(
            $this, // Table
            'x_gross_weight', // Variable name
            'gross_weight', // Name
            '`gross_weight`', // Expression
            '`gross_weight`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gross_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gross_weight->InputTextType = "text";
        $this->gross_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['gross_weight'] = &$this->gross_weight;

        // nett_weight
        $this->nett_weight = new DbField(
            $this, // Table
            'x_nett_weight', // Variable name
            'nett_weight', // Name
            '`nett_weight`', // Expression
            '`nett_weight`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`nett_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->nett_weight->InputTextType = "text";
        $this->nett_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['nett_weight'] = &$this->nett_weight;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cbm->InputTextType = "text";
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cbm'] = &$this->cbm;

        // exporter_bank_details
        $this->exporter_bank_details = new DbField(
            $this, // Table
            'x_exporter_bank_details', // Variable name
            'exporter_bank_details', // Name
            '`exporter_bank_details`', // Expression
            '`exporter_bank_details`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`exporter_bank_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->exporter_bank_details->InputTextType = "text";
        $this->exporter_bank_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['exporter_bank_details'] = &$this->exporter_bank_details;

        // intermediary_bank
        $this->intermediary_bank = new DbField(
            $this, // Table
            'x_intermediary_bank', // Variable name
            'intermediary_bank', // Name
            '`intermediary_bank`', // Expression
            '`intermediary_bank`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`intermediary_bank`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->intermediary_bank->InputTextType = "text";
        $this->intermediary_bank->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['intermediary_bank'] = &$this->intermediary_bank;

        // shipment_mode
        $this->shipment_mode = new DbField(
            $this, // Table
            'x_shipment_mode', // Variable name
            'shipment_mode', // Name
            '`shipment_mode`', // Expression
            '`shipment_mode`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipment_mode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shipment_mode->InputTextType = "text";
        $this->shipment_mode->Raw = true;
        $this->shipment_mode->setSelectMultiple(false); // Select one
        $this->shipment_mode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shipment_mode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shipment_mode->Lookup = new Lookup($this->shipment_mode, 'invoice_details', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->shipment_mode->OptionCount = 3;
        $this->shipment_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->shipment_mode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipment_mode'] = &$this->shipment_mode;

        // ex_factory_date
        $this->ex_factory_date = new DbField(
            $this, // Table
            'x_ex_factory_date', // Variable name
            'ex_factory_date', // Name
            '`ex_factory_date`', // Expression
            CastDateFieldForLike("`ex_factory_date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`ex_factory_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ex_factory_date->InputTextType = "text";
        $this->ex_factory_date->Raw = true;
        $this->ex_factory_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->ex_factory_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ex_factory_date'] = &$this->ex_factory_date;

        // sailing_date
        $this->sailing_date = new DbField(
            $this, // Table
            'x_sailing_date', // Variable name
            'sailing_date', // Name
            '`sailing_date`', // Expression
            CastDateFieldForLike("`sailing_date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`sailing_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sailing_date->InputTextType = "text";
        $this->sailing_date->Raw = true;
        $this->sailing_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->sailing_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sailing_date'] = &$this->sailing_date;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // delivery_terms
        $this->delivery_terms = new DbField(
            $this, // Table
            'x_delivery_terms', // Variable name
            'delivery_terms', // Name
            '`delivery_terms`', // Expression
            '`delivery_terms`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delivery_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->delivery_terms->InputTextType = "text";
        $this->delivery_terms->Sortable = false; // Allow sort
        $this->delivery_terms->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_terms'] = &$this->delivery_terms;

        // po_date
        $this->po_date = new DbField(
            $this, // Table
            'x_po_date', // Variable name
            'po_date', // Name
            '`po_date`', // Expression
            CastDateFieldForLike("`po_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`po_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_date->InputTextType = "text";
        $this->po_date->Raw = true;
        $this->po_date->Sortable = false; // Allow sort
        $this->po_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->po_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_date'] = &$this->po_date;

        // cart_lines
        $this->cart_lines = new DbField(
            $this, // Table
            'x_cart_lines', // Variable name
            'cart_lines', // Name
            '`cart_lines`', // Expression
            '`cart_lines`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_lines`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_lines->addMethod("getDefault", fn() => '30,40');
        $this->cart_lines->InputTextType = "text";
        $this->cart_lines->Required = true; // Required field
        $this->cart_lines->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->cart_lines->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_lines'] = &$this->cart_lines;

        // pl_lines
        $this->pl_lines = new DbField(
            $this, // Table
            'x_pl_lines', // Variable name
            'pl_lines', // Name
            '`pl_lines`', // Expression
            '`pl_lines`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_lines`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pl_lines->addMethod("getDefault", fn() => '30,50');
        $this->pl_lines->InputTextType = "text";
        $this->pl_lines->Required = true; // Required field
        $this->pl_lines->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->pl_lines->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_lines'] = &$this->pl_lines;

        // freezed
        $this->freezed = new DbField(
            $this, // Table
            'x_freezed', // Variable name
            'freezed', // Name
            '`freezed`', // Expression
            '`freezed`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`freezed`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->freezed->InputTextType = "text";
        $this->freezed->Raw = true;
        $this->freezed->Nullable = false; // NOT NULL field
        $this->freezed->setSelectMultiple(false); // Select one
        $this->freezed->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->freezed->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->freezed->Lookup = new Lookup($this->freezed, 'invoice_details', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->freezed->OptionCount = 2;
        $this->freezed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->freezed->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['freezed'] = &$this->freezed;

        // pl_pdf
        $this->pl_pdf = new DbField(
            $this, // Table
            'x_pl_pdf', // Variable name
            'pl_pdf', // Name
            '`pl_pdf`', // Expression
            '`pl_pdf`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_pdf`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pl_pdf->InputTextType = "text";
        $this->pl_pdf->Sortable = false; // Allow sort
        $this->pl_pdf->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_pdf'] = &$this->pl_pdf;

        // in_pdf
        $this->in_pdf = new DbField(
            $this, // Table
            'x_in_pdf', // Variable name
            'in_pdf', // Name
            '`in_pdf`', // Expression
            '`in_pdf`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`in_pdf`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->in_pdf->InputTextType = "text";
        $this->in_pdf->Sortable = false; // Allow sort
        $this->in_pdf->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['in_pdf'] = &$this->in_pdf;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // port_delivery
        $this->port_delivery = new DbField(
            $this, // Table
            'x_port_delivery', // Variable name
            'port_delivery', // Name
            '`port_delivery`', // Expression
            '`port_delivery`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`port_delivery`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->port_delivery->InputTextType = "text";
        $this->port_delivery->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_delivery'] = &$this->port_delivery;

        // dispatch_details
        $this->dispatch_details = new DbField(
            $this, // Table
            'x_dispatch_details', // Variable name
            'dispatch_details', // Name
            '`dispatch_details`', // Expression
            '`dispatch_details`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`dispatch_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dispatch_details->InputTextType = "text";
        $this->dispatch_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['dispatch_details'] = &$this->dispatch_details;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "invoice_details";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->exporter->DbValue = $row['exporter'];
        $this->consignee->DbValue = $row['consignee'];
        $this->consignee_other->DbValue = $row['consignee_other'];
        $this->packing_list_no->DbValue = $row['packing_list_no'];
        $this->d_11->DbValue = $row['d_11'];
        $this->description_11->DbValue = $row['description_11'];
        $this->in_template->DbValue = $row['in_template'];
        $this->pl_template->DbValue = $row['pl_template'];
        $this->invoice_no->DbValue = $row['invoice_no'];
        $this->invoice_date->DbValue = $row['invoice_date'];
        $this->po_no->DbValue = $row['po_no'];
        $this->other_reference->DbValue = $row['other_reference'];
        $this->origin->DbValue = $row['origin'];
        $this->final_destination->DbValue = $row['final_destination'];
        $this->payment_terms->DbValue = $row['payment_terms'];
        $this->pre_carriage_receipt->DbValue = $row['pre_carriage_receipt'];
        $this->place_of_receipt->DbValue = $row['place_of_receipt'];
        $this->loading_port->DbValue = $row['loading_port'];
        $this->port_discharge->DbValue = $row['port_discharge'];
        $this->d_01->DbValue = $row['d_01'];
        $this->description_01->DbValue = $row['description_01'];
        $this->d_02->DbValue = $row['d_02'];
        $this->description_02->DbValue = $row['description_02'];
        $this->gross_weight->DbValue = $row['gross_weight'];
        $this->nett_weight->DbValue = $row['nett_weight'];
        $this->cbm->DbValue = $row['cbm'];
        $this->exporter_bank_details->DbValue = $row['exporter_bank_details'];
        $this->intermediary_bank->DbValue = $row['intermediary_bank'];
        $this->shipment_mode->DbValue = $row['shipment_mode'];
        $this->ex_factory_date->DbValue = $row['ex_factory_date'];
        $this->sailing_date->DbValue = $row['sailing_date'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->delivery_terms->DbValue = $row['delivery_terms'];
        $this->po_date->DbValue = $row['po_date'];
        $this->cart_lines->DbValue = $row['cart_lines'];
        $this->pl_lines->DbValue = $row['pl_lines'];
        $this->freezed->DbValue = $row['freezed'];
        $this->pl_pdf->DbValue = $row['pl_pdf'];
        $this->in_pdf->DbValue = $row['in_pdf'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->port_delivery->DbValue = $row['port_delivery'];
        $this->dispatch_details->DbValue = $row['dispatch_details'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("invoicedetailslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "invoicedetailsview" => $Language->phrase("View"),
            "invoicedetailsedit" => $Language->phrase("Edit"),
            "invoicedetailsadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "invoicedetailslist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "InvoiceDetailsView",
            Config("API_ADD_ACTION") => "InvoiceDetailsAdd",
            Config("API_EDIT_ACTION") => "InvoiceDetailsEdit",
            Config("API_DELETE_ACTION") => "InvoiceDetailsDelete",
            Config("API_LIST_ACTION") => "InvoiceDetailsList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "invoicedetailslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("invoicedetailsview", $parm);
        } else {
            $url = $this->keyUrl("invoicedetailsview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "invoicedetailsadd?" . $parm;
        } else {
            $url = "invoicedetailsadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("invoicedetailsedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("invoicedetailslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("invoicedetailsadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("invoicedetailslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("invoicedetailsdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->exporter->setDbValue($row['exporter']);
        $this->consignee->setDbValue($row['consignee']);
        $this->consignee_other->setDbValue($row['consignee_other']);
        $this->packing_list_no->setDbValue($row['packing_list_no']);
        $this->d_11->setDbValue($row['d_11']);
        $this->description_11->setDbValue($row['description_11']);
        $this->in_template->setDbValue($row['in_template']);
        $this->pl_template->setDbValue($row['pl_template']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->po_no->setDbValue($row['po_no']);
        $this->other_reference->setDbValue($row['other_reference']);
        $this->origin->setDbValue($row['origin']);
        $this->final_destination->setDbValue($row['final_destination']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
        $this->place_of_receipt->setDbValue($row['place_of_receipt']);
        $this->loading_port->setDbValue($row['loading_port']);
        $this->port_discharge->setDbValue($row['port_discharge']);
        $this->d_01->setDbValue($row['d_01']);
        $this->description_01->setDbValue($row['description_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->description_02->setDbValue($row['description_02']);
        $this->gross_weight->setDbValue($row['gross_weight']);
        $this->nett_weight->setDbValue($row['nett_weight']);
        $this->cbm->setDbValue($row['cbm']);
        $this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
        $this->intermediary_bank->setDbValue($row['intermediary_bank']);
        $this->shipment_mode->setDbValue($row['shipment_mode']);
        $this->ex_factory_date->setDbValue($row['ex_factory_date']);
        $this->sailing_date->setDbValue($row['sailing_date']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->po_date->setDbValue($row['po_date']);
        $this->cart_lines->setDbValue($row['cart_lines']);
        $this->pl_lines->setDbValue($row['pl_lines']);
        $this->freezed->setDbValue($row['freezed']);
        $this->pl_pdf->setDbValue($row['pl_pdf']);
        $this->in_pdf->setDbValue($row['in_pdf']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->port_delivery->setDbValue($row['port_delivery']);
        $this->dispatch_details->setDbValue($row['dispatch_details']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "InvoiceDetailsList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // barcode

        // exporter

        // consignee

        // consignee_other

        // packing_list_no

        // d_11

        // description_11

        // in_template

        // pl_template

        // invoice_no

        // invoice_date

        // po_no

        // other_reference

        // origin

        // final_destination

        // payment_terms

        // pre_carriage_receipt

        // place_of_receipt

        // loading_port

        // port_discharge

        // d_01

        // description_01

        // d_02

        // description_02

        // gross_weight

        // nett_weight

        // cbm

        // exporter_bank_details

        // intermediary_bank

        // shipment_mode

        // ex_factory_date

        // sailing_date

        // operator

        // datetime

        // delivery_terms
        $this->delivery_terms->CellCssStyle = "white-space: nowrap;";

        // po_date
        $this->po_date->CellCssStyle = "white-space: nowrap;";

        // cart_lines

        // pl_lines

        // freezed

        // pl_pdf
        $this->pl_pdf->CellCssStyle = "white-space: nowrap;";

        // in_pdf
        $this->in_pdf->CellCssStyle = "white-space: nowrap;";

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // port_delivery

        // dispatch_details

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // exporter
        $curVal = strval($this->exporter->CurrentValue);
        if ($curVal != "") {
            $this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
            if ($this->exporter->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->exporter->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->exporter->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->exporter->getSelectFilter($this); // PHP
                $sqlWrk = $this->exporter->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->exporter->Lookup->renderViewRow($rswrk[0]);
                    $this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
                } else {
                    $this->exporter->ViewValue = $this->exporter->CurrentValue;
                }
            }
        } else {
            $this->exporter->ViewValue = null;
        }

        // consignee
        $curVal = strval($this->consignee->CurrentValue);
        if ($curVal != "") {
            $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
            if ($this->consignee->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                    $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                } else {
                    $this->consignee->ViewValue = $this->consignee->CurrentValue;
                }
            }
        } else {
            $this->consignee->ViewValue = null;
        }

        // consignee_other
        $curVal = strval($this->consignee_other->CurrentValue);
        if ($curVal != "") {
            $this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
            if ($this->consignee_other->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->consignee_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee_other->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->consignee_other->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->consignee_other->Lookup->renderViewRow($rswrk[0]);
                    $this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
                } else {
                    $this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
                }
            }
        } else {
            $this->consignee_other->ViewValue = null;
        }

        // packing_list_no
        $curVal = strval($this->packing_list_no->CurrentValue);
        if ($curVal != "") {
            $this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
            if ($this->packing_list_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchExpression(), "=", $curVal, $this->packing_list_no->Lookup->getTable()->Fields["pl_no"]->searchDataType(), "");
                $lookupFilter = $this->packing_list_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_list_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_list_no->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
                } else {
                    $this->packing_list_no->ViewValue = FormatNumber($this->packing_list_no->CurrentValue, $this->packing_list_no->formatPattern());
                }
            }
        } else {
            $this->packing_list_no->ViewValue = null;
        }

        // d_11
        $this->d_11->ViewValue = $this->d_11->CurrentValue;

        // description_11
        $this->description_11->ViewValue = $this->description_11->CurrentValue;

        // in_template
        $curVal = strval($this->in_template->CurrentValue);
        if ($curVal != "") {
            $this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
            if ($this->in_template->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->in_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->in_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->in_template->getSelectFilter($this); // PHP
                $sqlWrk = $this->in_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->in_template->Lookup->renderViewRow($rswrk[0]);
                    $this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
                } else {
                    $this->in_template->ViewValue = $this->in_template->CurrentValue;
                }
            }
        } else {
            $this->in_template->ViewValue = null;
        }

        // pl_template
        $curVal = strval($this->pl_template->CurrentValue);
        if ($curVal != "") {
            $this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
            if ($this->pl_template->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pl_template->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_template->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pl_template->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_template->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pl_template->Lookup->renderViewRow($rswrk[0]);
                    $this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
                } else {
                    $this->pl_template->ViewValue = $this->pl_template->CurrentValue;
                }
            }
        } else {
            $this->pl_template->ViewValue = null;
        }

        // invoice_no
        $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

        // invoice_date
        $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

        // po_no
        $this->po_no->ViewValue = $this->po_no->CurrentValue;

        // other_reference
        $this->other_reference->ViewValue = $this->other_reference->CurrentValue;

        // origin
        $this->origin->ViewValue = $this->origin->CurrentValue;

        // final_destination
        $this->final_destination->ViewValue = $this->final_destination->CurrentValue;

        // payment_terms
        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

        // pre_carriage_receipt
        $this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;

        // place_of_receipt
        $this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;

        // loading_port
        $this->loading_port->ViewValue = $this->loading_port->CurrentValue;

        // port_discharge
        $this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;

        // d_01
        $this->d_01->ViewValue = $this->d_01->CurrentValue;

        // description_01
        $this->description_01->ViewValue = $this->description_01->CurrentValue;

        // d_02
        $this->d_02->ViewValue = $this->d_02->CurrentValue;

        // description_02
        $this->description_02->ViewValue = $this->description_02->CurrentValue;

        // gross_weight
        $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;

        // nett_weight
        $this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;

        // exporter_bank_details
        $this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;

        // intermediary_bank
        $this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;

        // shipment_mode
        if (strval($this->shipment_mode->CurrentValue) != "") {
            $this->shipment_mode->ViewValue = $this->shipment_mode->optionCaption($this->shipment_mode->CurrentValue);
        } else {
            $this->shipment_mode->ViewValue = null;
        }

        // ex_factory_date
        $this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
        $this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, $this->ex_factory_date->formatPattern());

        // sailing_date
        $this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
        $this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, $this->sailing_date->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // delivery_terms
        $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

        // po_date
        $this->po_date->ViewValue = $this->po_date->CurrentValue;
        $this->po_date->ViewValue = FormatDateTime($this->po_date->ViewValue, $this->po_date->formatPattern());

        // cart_lines
        $this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;

        // pl_lines
        $this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;

        // freezed
        if (strval($this->freezed->CurrentValue) != "") {
            $this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
        } else {
            $this->freezed->ViewValue = null;
        }

        // pl_pdf
        $this->pl_pdf->ViewValue = $this->pl_pdf->CurrentValue;

        // in_pdf
        $this->in_pdf->ViewValue = $this->in_pdf->CurrentValue;

        // a_operator
        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
        $this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, $this->a_operator->formatPattern());

        // port_delivery
        $this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;

        // dispatch_details
        $this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // exporter
        $this->exporter->HrefValue = "";
        $this->exporter->TooltipValue = "";

        // consignee
        $this->consignee->HrefValue = "";
        $this->consignee->TooltipValue = "";

        // consignee_other
        $this->consignee_other->HrefValue = "";
        $this->consignee_other->TooltipValue = "";

        // packing_list_no
        $this->packing_list_no->HrefValue = "";
        $this->packing_list_no->TooltipValue = "";

        // d_11
        $this->d_11->HrefValue = "";
        $this->d_11->TooltipValue = "";

        // description_11
        $this->description_11->HrefValue = "";
        $this->description_11->TooltipValue = "";

        // in_template
        $this->in_template->HrefValue = "";
        $this->in_template->TooltipValue = "";

        // pl_template
        $this->pl_template->HrefValue = "";
        $this->pl_template->TooltipValue = "";

        // invoice_no
        $this->invoice_no->HrefValue = "";
        $this->invoice_no->TooltipValue = "";

        // invoice_date
        $this->invoice_date->HrefValue = "";
        $this->invoice_date->TooltipValue = "";

        // po_no
        $this->po_no->HrefValue = "";
        $this->po_no->TooltipValue = "";

        // other_reference
        $this->other_reference->HrefValue = "";
        $this->other_reference->TooltipValue = "";

        // origin
        $this->origin->HrefValue = "";
        $this->origin->TooltipValue = "";

        // final_destination
        $this->final_destination->HrefValue = "";
        $this->final_destination->TooltipValue = "";

        // payment_terms
        $this->payment_terms->HrefValue = "";
        $this->payment_terms->TooltipValue = "";

        // pre_carriage_receipt
        $this->pre_carriage_receipt->HrefValue = "";
        $this->pre_carriage_receipt->TooltipValue = "";

        // place_of_receipt
        $this->place_of_receipt->HrefValue = "";
        $this->place_of_receipt->TooltipValue = "";

        // loading_port
        $this->loading_port->HrefValue = "";
        $this->loading_port->TooltipValue = "";

        // port_discharge
        $this->port_discharge->HrefValue = "";
        $this->port_discharge->TooltipValue = "";

        // d_01
        $this->d_01->HrefValue = "";
        $this->d_01->TooltipValue = "";

        // description_01
        $this->description_01->HrefValue = "";
        $this->description_01->TooltipValue = "";

        // d_02
        $this->d_02->HrefValue = "";
        $this->d_02->TooltipValue = "";

        // description_02
        $this->description_02->HrefValue = "";
        $this->description_02->TooltipValue = "";

        // gross_weight
        $this->gross_weight->HrefValue = "";
        $this->gross_weight->TooltipValue = "";

        // nett_weight
        $this->nett_weight->HrefValue = "";
        $this->nett_weight->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // exporter_bank_details
        $this->exporter_bank_details->HrefValue = "";
        $this->exporter_bank_details->TooltipValue = "";

        // intermediary_bank
        $this->intermediary_bank->HrefValue = "";
        $this->intermediary_bank->TooltipValue = "";

        // shipment_mode
        $this->shipment_mode->HrefValue = "";
        $this->shipment_mode->TooltipValue = "";

        // ex_factory_date
        $this->ex_factory_date->HrefValue = "";
        $this->ex_factory_date->TooltipValue = "";

        // sailing_date
        $this->sailing_date->HrefValue = "";
        $this->sailing_date->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // delivery_terms
        $this->delivery_terms->HrefValue = "";
        $this->delivery_terms->TooltipValue = "";

        // po_date
        $this->po_date->HrefValue = "";
        $this->po_date->TooltipValue = "";

        // cart_lines
        $this->cart_lines->HrefValue = "";
        $this->cart_lines->TooltipValue = "";

        // pl_lines
        $this->pl_lines->HrefValue = "";
        $this->pl_lines->TooltipValue = "";

        // freezed
        $this->freezed->HrefValue = "";
        $this->freezed->TooltipValue = "";

        // pl_pdf
        $this->pl_pdf->HrefValue = "";
        $this->pl_pdf->TooltipValue = "";

        // in_pdf
        $this->in_pdf->HrefValue = "";
        $this->in_pdf->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // port_delivery
        $this->port_delivery->HrefValue = "";
        $this->port_delivery->TooltipValue = "";

        // dispatch_details
        $this->dispatch_details->HrefValue = "";
        $this->dispatch_details->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

        // exporter
        $this->exporter->setupEditAttributes();
        $this->exporter->PlaceHolder = RemoveHtml($this->exporter->caption());

        // consignee
        $this->consignee->setupEditAttributes();
        $this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());

        // consignee_other
        $this->consignee_other->setupEditAttributes();
        $this->consignee_other->PlaceHolder = RemoveHtml($this->consignee_other->caption());

        // packing_list_no
        $this->packing_list_no->setupEditAttributes();
        $this->packing_list_no->PlaceHolder = RemoveHtml($this->packing_list_no->caption());

        // d_11
        $this->d_11->setupEditAttributes();
        if (!$this->d_11->Raw) {
            $this->d_11->CurrentValue = HtmlDecode($this->d_11->CurrentValue);
        }
        $this->d_11->EditValue = $this->d_11->CurrentValue;
        $this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

        // description_11
        $this->description_11->setupEditAttributes();
        $this->description_11->EditValue = $this->description_11->CurrentValue;
        $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

        // in_template
        $this->in_template->setupEditAttributes();
        $this->in_template->PlaceHolder = RemoveHtml($this->in_template->caption());

        // pl_template
        $this->pl_template->setupEditAttributes();
        $this->pl_template->PlaceHolder = RemoveHtml($this->pl_template->caption());

        // invoice_no
        $this->invoice_no->setupEditAttributes();
        if (!$this->invoice_no->Raw) {
            $this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
        }
        $this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
        $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

        // invoice_date
        $this->invoice_date->setupEditAttributes();
        $this->invoice_date->EditValue = FormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

        // po_no
        $this->po_no->setupEditAttributes();
        $this->po_no->EditValue = $this->po_no->CurrentValue;
        $this->po_no->PlaceHolder = RemoveHtml($this->po_no->caption());

        // other_reference
        $this->other_reference->setupEditAttributes();
        if (!$this->other_reference->Raw) {
            $this->other_reference->CurrentValue = HtmlDecode($this->other_reference->CurrentValue);
        }
        $this->other_reference->EditValue = $this->other_reference->CurrentValue;
        $this->other_reference->PlaceHolder = RemoveHtml($this->other_reference->caption());

        // origin
        $this->origin->setupEditAttributes();
        if (!$this->origin->Raw) {
            $this->origin->CurrentValue = HtmlDecode($this->origin->CurrentValue);
        }
        $this->origin->EditValue = $this->origin->CurrentValue;
        $this->origin->PlaceHolder = RemoveHtml($this->origin->caption());

        // final_destination
        $this->final_destination->setupEditAttributes();
        if (!$this->final_destination->Raw) {
            $this->final_destination->CurrentValue = HtmlDecode($this->final_destination->CurrentValue);
        }
        $this->final_destination->EditValue = $this->final_destination->CurrentValue;
        $this->final_destination->PlaceHolder = RemoveHtml($this->final_destination->caption());

        // payment_terms
        $this->payment_terms->setupEditAttributes();
        $this->payment_terms->EditValue = $this->payment_terms->CurrentValue;
        $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

        // pre_carriage_receipt
        $this->pre_carriage_receipt->setupEditAttributes();
        if (!$this->pre_carriage_receipt->Raw) {
            $this->pre_carriage_receipt->CurrentValue = HtmlDecode($this->pre_carriage_receipt->CurrentValue);
        }
        $this->pre_carriage_receipt->EditValue = $this->pre_carriage_receipt->CurrentValue;
        $this->pre_carriage_receipt->PlaceHolder = RemoveHtml($this->pre_carriage_receipt->caption());

        // place_of_receipt
        $this->place_of_receipt->setupEditAttributes();
        if (!$this->place_of_receipt->Raw) {
            $this->place_of_receipt->CurrentValue = HtmlDecode($this->place_of_receipt->CurrentValue);
        }
        $this->place_of_receipt->EditValue = $this->place_of_receipt->CurrentValue;
        $this->place_of_receipt->PlaceHolder = RemoveHtml($this->place_of_receipt->caption());

        // loading_port
        $this->loading_port->setupEditAttributes();
        if (!$this->loading_port->Raw) {
            $this->loading_port->CurrentValue = HtmlDecode($this->loading_port->CurrentValue);
        }
        $this->loading_port->EditValue = $this->loading_port->CurrentValue;
        $this->loading_port->PlaceHolder = RemoveHtml($this->loading_port->caption());

        // port_discharge
        $this->port_discharge->setupEditAttributes();
        if (!$this->port_discharge->Raw) {
            $this->port_discharge->CurrentValue = HtmlDecode($this->port_discharge->CurrentValue);
        }
        $this->port_discharge->EditValue = $this->port_discharge->CurrentValue;
        $this->port_discharge->PlaceHolder = RemoveHtml($this->port_discharge->caption());

        // d_01
        $this->d_01->setupEditAttributes();
        if (!$this->d_01->Raw) {
            $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
        }
        $this->d_01->EditValue = $this->d_01->CurrentValue;
        $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

        // description_01
        $this->description_01->setupEditAttributes();
        if (!$this->description_01->Raw) {
            $this->description_01->CurrentValue = HtmlDecode($this->description_01->CurrentValue);
        }
        $this->description_01->EditValue = $this->description_01->CurrentValue;
        $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

        // d_02
        $this->d_02->setupEditAttributes();
        if (!$this->d_02->Raw) {
            $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
        }
        $this->d_02->EditValue = $this->d_02->CurrentValue;
        $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

        // description_02
        $this->description_02->setupEditAttributes();
        if (!$this->description_02->Raw) {
            $this->description_02->CurrentValue = HtmlDecode($this->description_02->CurrentValue);
        }
        $this->description_02->EditValue = $this->description_02->CurrentValue;
        $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

        // gross_weight
        $this->gross_weight->setupEditAttributes();
        if (!$this->gross_weight->Raw) {
            $this->gross_weight->CurrentValue = HtmlDecode($this->gross_weight->CurrentValue);
        }
        $this->gross_weight->EditValue = $this->gross_weight->CurrentValue;
        $this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

        // nett_weight
        $this->nett_weight->setupEditAttributes();
        if (!$this->nett_weight->Raw) {
            $this->nett_weight->CurrentValue = HtmlDecode($this->nett_weight->CurrentValue);
        }
        $this->nett_weight->EditValue = $this->nett_weight->CurrentValue;
        $this->nett_weight->PlaceHolder = RemoveHtml($this->nett_weight->caption());

        // cbm
        $this->cbm->setupEditAttributes();
        if (!$this->cbm->Raw) {
            $this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
        }
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

        // exporter_bank_details
        $this->exporter_bank_details->setupEditAttributes();
        $this->exporter_bank_details->EditValue = $this->exporter_bank_details->CurrentValue;
        $this->exporter_bank_details->PlaceHolder = RemoveHtml($this->exporter_bank_details->caption());

        // intermediary_bank
        $this->intermediary_bank->setupEditAttributes();
        $this->intermediary_bank->EditValue = $this->intermediary_bank->CurrentValue;
        $this->intermediary_bank->PlaceHolder = RemoveHtml($this->intermediary_bank->caption());

        // shipment_mode
        $this->shipment_mode->setupEditAttributes();
        $this->shipment_mode->EditValue = $this->shipment_mode->options(true);
        $this->shipment_mode->PlaceHolder = RemoveHtml($this->shipment_mode->caption());

        // ex_factory_date
        $this->ex_factory_date->setupEditAttributes();
        $this->ex_factory_date->EditValue = FormatDateTime($this->ex_factory_date->CurrentValue, $this->ex_factory_date->formatPattern());
        $this->ex_factory_date->PlaceHolder = RemoveHtml($this->ex_factory_date->caption());

        // sailing_date
        $this->sailing_date->setupEditAttributes();
        $this->sailing_date->EditValue = FormatDateTime($this->sailing_date->CurrentValue, $this->sailing_date->formatPattern());
        $this->sailing_date->PlaceHolder = RemoveHtml($this->sailing_date->caption());

        // operator

        // datetime

        // delivery_terms
        $this->delivery_terms->setupEditAttributes();
        if (!$this->delivery_terms->Raw) {
            $this->delivery_terms->CurrentValue = HtmlDecode($this->delivery_terms->CurrentValue);
        }
        $this->delivery_terms->EditValue = $this->delivery_terms->CurrentValue;
        $this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

        // po_date
        $this->po_date->setupEditAttributes();
        $this->po_date->EditValue = FormatDateTime($this->po_date->CurrentValue, $this->po_date->formatPattern());
        $this->po_date->PlaceHolder = RemoveHtml($this->po_date->caption());

        // cart_lines
        $this->cart_lines->setupEditAttributes();
        if (!$this->cart_lines->Raw) {
            $this->cart_lines->CurrentValue = HtmlDecode($this->cart_lines->CurrentValue);
        }
        $this->cart_lines->EditValue = $this->cart_lines->CurrentValue;
        $this->cart_lines->PlaceHolder = RemoveHtml($this->cart_lines->caption());

        // pl_lines
        $this->pl_lines->setupEditAttributes();
        if (!$this->pl_lines->Raw) {
            $this->pl_lines->CurrentValue = HtmlDecode($this->pl_lines->CurrentValue);
        }
        $this->pl_lines->EditValue = $this->pl_lines->CurrentValue;
        $this->pl_lines->PlaceHolder = RemoveHtml($this->pl_lines->caption());

        // freezed
        $this->freezed->setupEditAttributes();
        $this->freezed->EditValue = $this->freezed->options(true);
        $this->freezed->PlaceHolder = RemoveHtml($this->freezed->caption());

        // pl_pdf
        $this->pl_pdf->setupEditAttributes();
        if (!$this->pl_pdf->Raw) {
            $this->pl_pdf->CurrentValue = HtmlDecode($this->pl_pdf->CurrentValue);
        }
        $this->pl_pdf->EditValue = $this->pl_pdf->CurrentValue;
        $this->pl_pdf->PlaceHolder = RemoveHtml($this->pl_pdf->caption());

        // in_pdf
        $this->in_pdf->setupEditAttributes();
        if (!$this->in_pdf->Raw) {
            $this->in_pdf->CurrentValue = HtmlDecode($this->in_pdf->CurrentValue);
        }
        $this->in_pdf->EditValue = $this->in_pdf->CurrentValue;
        $this->in_pdf->PlaceHolder = RemoveHtml($this->in_pdf->caption());

        // a_operator
        $this->a_operator->setupEditAttributes();
        $this->a_operator->EditValue = $this->a_operator->CurrentValue;
        $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());
        if (strval($this->a_operator->EditValue) != "" && is_numeric($this->a_operator->EditValue)) {
            $this->a_operator->EditValue = FormatNumber($this->a_operator->EditValue, null);
        }

        // port_delivery
        $this->port_delivery->setupEditAttributes();
        if (!$this->port_delivery->Raw) {
            $this->port_delivery->CurrentValue = HtmlDecode($this->port_delivery->CurrentValue);
        }
        $this->port_delivery->EditValue = $this->port_delivery->CurrentValue;
        $this->port_delivery->PlaceHolder = RemoveHtml($this->port_delivery->caption());

        // dispatch_details
        $this->dispatch_details->setupEditAttributes();
        if (!$this->dispatch_details->Raw) {
            $this->dispatch_details->CurrentValue = HtmlDecode($this->dispatch_details->CurrentValue);
        }
        $this->dispatch_details->EditValue = $this->dispatch_details->CurrentValue;
        $this->dispatch_details->PlaceHolder = RemoveHtml($this->dispatch_details->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->exporter);
                    $doc->exportCaption($this->consignee);
                    $doc->exportCaption($this->consignee_other);
                    $doc->exportCaption($this->packing_list_no);
                    $doc->exportCaption($this->d_11);
                    $doc->exportCaption($this->description_11);
                    $doc->exportCaption($this->in_template);
                    $doc->exportCaption($this->pl_template);
                    $doc->exportCaption($this->invoice_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->po_no);
                    $doc->exportCaption($this->other_reference);
                    $doc->exportCaption($this->origin);
                    $doc->exportCaption($this->final_destination);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->pre_carriage_receipt);
                    $doc->exportCaption($this->place_of_receipt);
                    $doc->exportCaption($this->loading_port);
                    $doc->exportCaption($this->port_discharge);
                    $doc->exportCaption($this->d_01);
                    $doc->exportCaption($this->description_01);
                    $doc->exportCaption($this->d_02);
                    $doc->exportCaption($this->description_02);
                    $doc->exportCaption($this->gross_weight);
                    $doc->exportCaption($this->nett_weight);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->exporter_bank_details);
                    $doc->exportCaption($this->intermediary_bank);
                    $doc->exportCaption($this->shipment_mode);
                    $doc->exportCaption($this->ex_factory_date);
                    $doc->exportCaption($this->sailing_date);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->cart_lines);
                    $doc->exportCaption($this->pl_lines);
                    $doc->exportCaption($this->freezed);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->port_delivery);
                    $doc->exportCaption($this->dispatch_details);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->exporter);
                    $doc->exportCaption($this->consignee);
                    $doc->exportCaption($this->consignee_other);
                    $doc->exportCaption($this->packing_list_no);
                    $doc->exportCaption($this->d_11);
                    $doc->exportCaption($this->in_template);
                    $doc->exportCaption($this->pl_template);
                    $doc->exportCaption($this->invoice_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->po_no);
                    $doc->exportCaption($this->other_reference);
                    $doc->exportCaption($this->origin);
                    $doc->exportCaption($this->final_destination);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->pre_carriage_receipt);
                    $doc->exportCaption($this->place_of_receipt);
                    $doc->exportCaption($this->loading_port);
                    $doc->exportCaption($this->port_discharge);
                    $doc->exportCaption($this->d_01);
                    $doc->exportCaption($this->description_01);
                    $doc->exportCaption($this->d_02);
                    $doc->exportCaption($this->description_02);
                    $doc->exportCaption($this->gross_weight);
                    $doc->exportCaption($this->nett_weight);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->shipment_mode);
                    $doc->exportCaption($this->ex_factory_date);
                    $doc->exportCaption($this->sailing_date);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->cart_lines);
                    $doc->exportCaption($this->pl_lines);
                    $doc->exportCaption($this->freezed);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->port_delivery);
                    $doc->exportCaption($this->dispatch_details);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->exporter);
                        $doc->exportField($this->consignee);
                        $doc->exportField($this->consignee_other);
                        $doc->exportField($this->packing_list_no);
                        $doc->exportField($this->d_11);
                        $doc->exportField($this->description_11);
                        $doc->exportField($this->in_template);
                        $doc->exportField($this->pl_template);
                        $doc->exportField($this->invoice_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->po_no);
                        $doc->exportField($this->other_reference);
                        $doc->exportField($this->origin);
                        $doc->exportField($this->final_destination);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->pre_carriage_receipt);
                        $doc->exportField($this->place_of_receipt);
                        $doc->exportField($this->loading_port);
                        $doc->exportField($this->port_discharge);
                        $doc->exportField($this->d_01);
                        $doc->exportField($this->description_01);
                        $doc->exportField($this->d_02);
                        $doc->exportField($this->description_02);
                        $doc->exportField($this->gross_weight);
                        $doc->exportField($this->nett_weight);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->exporter_bank_details);
                        $doc->exportField($this->intermediary_bank);
                        $doc->exportField($this->shipment_mode);
                        $doc->exportField($this->ex_factory_date);
                        $doc->exportField($this->sailing_date);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->cart_lines);
                        $doc->exportField($this->pl_lines);
                        $doc->exportField($this->freezed);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->port_delivery);
                        $doc->exportField($this->dispatch_details);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->exporter);
                        $doc->exportField($this->consignee);
                        $doc->exportField($this->consignee_other);
                        $doc->exportField($this->packing_list_no);
                        $doc->exportField($this->d_11);
                        $doc->exportField($this->in_template);
                        $doc->exportField($this->pl_template);
                        $doc->exportField($this->invoice_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->po_no);
                        $doc->exportField($this->other_reference);
                        $doc->exportField($this->origin);
                        $doc->exportField($this->final_destination);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->pre_carriage_receipt);
                        $doc->exportField($this->place_of_receipt);
                        $doc->exportField($this->loading_port);
                        $doc->exportField($this->port_discharge);
                        $doc->exportField($this->d_01);
                        $doc->exportField($this->description_01);
                        $doc->exportField($this->d_02);
                        $doc->exportField($this->description_02);
                        $doc->exportField($this->gross_weight);
                        $doc->exportField($this->nett_weight);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->shipment_mode);
                        $doc->exportField($this->ex_factory_date);
                        $doc->exportField($this->sailing_date);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->cart_lines);
                        $doc->exportField($this->pl_lines);
                        $doc->exportField($this->freezed);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->port_delivery);
                        $doc->exportField($this->dispatch_details);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'invoice_details');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'invoice_details', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'invoice_details', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'invoice_details', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
