<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class InvestorInfoSearch extends InvestorInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InvestorInfoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "investorinfosearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->qty->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->name->setVisibility();
        $this->gender->setVisibility();
        $this->dob->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->address->setVisibility();
        $this->care_of->setVisibility();
        $this->father_name->setVisibility();
        $this->mother_name->setVisibility();
        $this->nominee_name->setVisibility();
        $this->nominee_relation->setVisibility();
        $this->pan_no->setVisibility();
        $this->uploads->setVisibility();
        $this->image->setVisibility();
        $this->adviser->setVisibility();
        $this->share_no->setVisibility();
        $this->inv_start_date->setVisibility();
        $this->amount->setVisibility();
        $this->gurantee->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->otp->setVisibility();
        $this->pan_response->setVisibility();
        $this->pan_verify_datetime->setVisibility();
        $this->aadhaar_response->setVisibility();
        $this->aadhaar_verify_datetime->setVisibility();
        $this->thumb_data->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'investor_info';
        $this->TableName = 'investor_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (investor_info)
        if (!isset($GLOBALS["investor_info"]) || $GLOBALS["investor_info"]::class == PROJECT_NAMESPACE . "investor_info") {
            $GLOBALS["investor_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'investor_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "investorinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->nominee_relation);
        $this->setupLookupOptions($this->adviser);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "investorinfolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->qty); // qty
        $this->buildSearchUrl($srchUrl, $this->aadhaar_no); // aadhaar_no
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->gender); // gender
        $this->buildSearchUrl($srchUrl, $this->dob); // dob
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->_email); // email
        $this->buildSearchUrl($srchUrl, $this->address); // address
        $this->buildSearchUrl($srchUrl, $this->care_of); // care_of
        $this->buildSearchUrl($srchUrl, $this->father_name); // father_name
        $this->buildSearchUrl($srchUrl, $this->mother_name); // mother_name
        $this->buildSearchUrl($srchUrl, $this->nominee_name); // nominee_name
        $this->buildSearchUrl($srchUrl, $this->nominee_relation); // nominee_relation
        $this->buildSearchUrl($srchUrl, $this->pan_no); // pan_no
        $this->buildSearchUrl($srchUrl, $this->uploads); // uploads
        $this->buildSearchUrl($srchUrl, $this->image); // image
        $this->buildSearchUrl($srchUrl, $this->adviser); // adviser
        $this->buildSearchUrl($srchUrl, $this->share_no); // share_no
        $this->buildSearchUrl($srchUrl, $this->inv_start_date); // inv_start_date
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->gurantee); // gurantee
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->otp); // otp
        $this->buildSearchUrl($srchUrl, $this->pan_response); // pan_response
        $this->buildSearchUrl($srchUrl, $this->pan_verify_datetime); // pan_verify_datetime
        $this->buildSearchUrl($srchUrl, $this->aadhaar_response); // aadhaar_response
        $this->buildSearchUrl($srchUrl, $this->aadhaar_verify_datetime); // aadhaar_verify_datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // aadhaar_no
        if ($this->aadhaar_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gender
        if ($this->gender->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dob
        if ($this->dob->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // care_of
        if ($this->care_of->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // father_name
        if ($this->father_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mother_name
        if ($this->mother_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // nominee_name
        if ($this->nominee_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // nominee_relation
        if ($this->nominee_relation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan_no
        if ($this->pan_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // uploads
        if ($this->uploads->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // adviser
        if ($this->adviser->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // share_no
        if ($this->share_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // inv_start_date
        if ($this->inv_start_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gurantee
        if ($this->gurantee->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // otp
        if ($this->otp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan_response
        if ($this->pan_response->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan_verify_datetime
        if ($this->pan_verify_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // aadhaar_response
        if ($this->aadhaar_response->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // aadhaar_verify_datetime
        if ($this->aadhaar_verify_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // care_of
        $this->care_of->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // mother_name
        $this->mother_name->RowCssClass = "row";

        // nominee_name
        $this->nominee_name->RowCssClass = "row";

        // nominee_relation
        $this->nominee_relation->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // adviser
        $this->adviser->RowCssClass = "row";

        // share_no
        $this->share_no->RowCssClass = "row";

        // inv_start_date
        $this->inv_start_date->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // gurantee
        $this->gurantee->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // otp
        $this->otp->RowCssClass = "row";

        // pan_response
        $this->pan_response->RowCssClass = "row";

        // pan_verify_datetime
        $this->pan_verify_datetime->RowCssClass = "row";

        // aadhaar_response
        $this->aadhaar_response->RowCssClass = "row";

        // aadhaar_verify_datetime
        $this->aadhaar_verify_datetime->RowCssClass = "row";

        // thumb_data
        $this->thumb_data->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // care_of
            $this->care_of->ViewValue = $this->care_of->CurrentValue;

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // mother_name
            $this->mother_name->ViewValue = $this->mother_name->CurrentValue;

            // nominee_name
            $this->nominee_name->ViewValue = $this->nominee_name->CurrentValue;

            // nominee_relation
            if (strval($this->nominee_relation->CurrentValue) != "") {
                $this->nominee_relation->ViewValue = $this->nominee_relation->optionCaption($this->nominee_relation->CurrentValue);
            } else {
                $this->nominee_relation->ViewValue = null;
            }

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // adviser
            $curVal = strval($this->adviser->CurrentValue);
            if ($curVal != "") {
                $this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
                if ($this->adviser->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                    $sqlWrk = $this->adviser->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->adviser->Lookup->renderViewRow($rswrk[0]);
                        $this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
                    } else {
                        $this->adviser->ViewValue = FormatNumber($this->adviser->CurrentValue, $this->adviser->formatPattern());
                    }
                }
            } else {
                $this->adviser->ViewValue = null;
            }

            // share_no
            $this->share_no->ViewValue = $this->share_no->CurrentValue;

            // inv_start_date
            $this->inv_start_date->ViewValue = $this->inv_start_date->CurrentValue;
            $this->inv_start_date->ViewValue = FormatDateTime($this->inv_start_date->ViewValue, $this->inv_start_date->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // gurantee
            $this->gurantee->ViewValue = $this->gurantee->CurrentValue;
            $this->gurantee->ViewValue = FormatNumber($this->gurantee->ViewValue, $this->gurantee->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // otp
            $this->otp->ViewValue = $this->otp->CurrentValue;
            $this->otp->ViewValue = FormatNumber($this->otp->ViewValue, $this->otp->formatPattern());

            // pan_response
            $this->pan_response->ViewValue = $this->pan_response->CurrentValue;

            // pan_verify_datetime
            $this->pan_verify_datetime->ViewValue = $this->pan_verify_datetime->CurrentValue;
            $this->pan_verify_datetime->ViewValue = FormatDateTime($this->pan_verify_datetime->ViewValue, $this->pan_verify_datetime->formatPattern());

            // aadhaar_response
            $this->aadhaar_response->ViewValue = $this->aadhaar_response->CurrentValue;

            // aadhaar_verify_datetime
            $this->aadhaar_verify_datetime->ViewValue = $this->aadhaar_verify_datetime->CurrentValue;
            $this->aadhaar_verify_datetime->ViewValue = FormatDateTime($this->aadhaar_verify_datetime->ViewValue, $this->aadhaar_verify_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // qty
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->qty->HrefValue = $this->qty->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->qty->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->qty->HrefValue = FullUrl($this->qty->HrefValue, "href");
                }
            } else {
                $this->qty->HrefValue = "";
            }
            $this->qty->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // care_of
            $this->care_of->HrefValue = "";
            $this->care_of->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";
            $this->mother_name->TooltipValue = "";

            // nominee_name
            $this->nominee_name->HrefValue = "";
            $this->nominee_name->TooltipValue = "";

            // nominee_relation
            $this->nominee_relation->HrefValue = "";
            $this->nominee_relation->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "investor_info_x_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";
            if ($this->image->UseColorbox) {
                if (EmptyValue($this->image->TooltipValue)) {
                    $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->image->LinkAttrs["data-rel"] = "investor_info_x_image";
                $this->image->LinkAttrs->appendClass("ew-lightbox");
            }

            // adviser
            $this->adviser->HrefValue = "";
            $this->adviser->TooltipValue = "";

            // share_no
            $this->share_no->HrefValue = "";
            $this->share_no->TooltipValue = "";

            // inv_start_date
            $this->inv_start_date->HrefValue = "";
            $this->inv_start_date->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // gurantee
            $this->gurantee->HrefValue = "";
            $this->gurantee->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // otp
            $this->otp->HrefValue = "";
            $this->otp->TooltipValue = "";

            // pan_response
            $this->pan_response->HrefValue = "";
            $this->pan_response->TooltipValue = "";

            // pan_verify_datetime
            $this->pan_verify_datetime->HrefValue = "";
            $this->pan_verify_datetime->TooltipValue = "";

            // aadhaar_response
            $this->aadhaar_response->HrefValue = "";
            $this->aadhaar_response->TooltipValue = "";

            // aadhaar_verify_datetime
            $this->aadhaar_verify_datetime->HrefValue = "";
            $this->aadhaar_verify_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dob->AdvancedSearch->SearchValue, $this->dob->formatPattern()), $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // address
            $this->address->setupEditAttributes();
            if (!$this->address->Raw) {
                $this->address->AdvancedSearch->SearchValue = HtmlDecode($this->address->AdvancedSearch->SearchValue);
            }
            $this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // care_of
            $this->care_of->setupEditAttributes();
            if (!$this->care_of->Raw) {
                $this->care_of->AdvancedSearch->SearchValue = HtmlDecode($this->care_of->AdvancedSearch->SearchValue);
            }
            $this->care_of->EditValue = HtmlEncode($this->care_of->AdvancedSearch->SearchValue);
            $this->care_of->PlaceHolder = RemoveHtml($this->care_of->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->AdvancedSearch->SearchValue = HtmlDecode($this->father_name->AdvancedSearch->SearchValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->AdvancedSearch->SearchValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // mother_name
            $this->mother_name->setupEditAttributes();
            if (!$this->mother_name->Raw) {
                $this->mother_name->AdvancedSearch->SearchValue = HtmlDecode($this->mother_name->AdvancedSearch->SearchValue);
            }
            $this->mother_name->EditValue = HtmlEncode($this->mother_name->AdvancedSearch->SearchValue);
            $this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

            // nominee_name
            $this->nominee_name->setupEditAttributes();
            if (!$this->nominee_name->Raw) {
                $this->nominee_name->AdvancedSearch->SearchValue = HtmlDecode($this->nominee_name->AdvancedSearch->SearchValue);
            }
            $this->nominee_name->EditValue = HtmlEncode($this->nominee_name->AdvancedSearch->SearchValue);
            $this->nominee_name->PlaceHolder = RemoveHtml($this->nominee_name->caption());

            // nominee_relation
            $this->nominee_relation->setupEditAttributes();
            $this->nominee_relation->EditValue = $this->nominee_relation->options(true);
            $this->nominee_relation->PlaceHolder = RemoveHtml($this->nominee_relation->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!$this->uploads->Raw) {
                $this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
            }
            $this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
            $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // adviser
            $this->adviser->setupEditAttributes();
            $curVal = trim(strval($this->adviser->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->adviser->AdvancedSearch->ViewValue = $this->adviser->lookupCacheOption($curVal);
            } else {
                $this->adviser->AdvancedSearch->ViewValue = $this->adviser->Lookup !== null && is_array($this->adviser->lookupOptions()) && count($this->adviser->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->adviser->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->adviser->EditValue = array_values($this->adviser->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->adviser->AdvancedSearch->SearchValue, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                $sqlWrk = $this->adviser->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->adviser->EditValue = $arwrk;
            }
            $this->adviser->PlaceHolder = RemoveHtml($this->adviser->caption());

            // share_no
            $this->share_no->setupEditAttributes();
            $this->share_no->EditCustomAttributes = $this->share_no->getEditCustomAttributes(); // PHP
            $this->share_no->EditValue = HtmlEncode($this->share_no->AdvancedSearch->SearchValue);
            $this->share_no->PlaceHolder = RemoveHtml($this->share_no->caption());

            // inv_start_date
            $this->inv_start_date->setupEditAttributes();
            $this->inv_start_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->inv_start_date->AdvancedSearch->SearchValue, $this->inv_start_date->formatPattern()), $this->inv_start_date->formatPattern()));
            $this->inv_start_date->PlaceHolder = RemoveHtml($this->inv_start_date->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // gurantee
            $this->gurantee->setupEditAttributes();
            $this->gurantee->EditValue = $this->gurantee->AdvancedSearch->SearchValue;
            $this->gurantee->PlaceHolder = RemoveHtml($this->gurantee->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // otp
            $this->otp->setupEditAttributes();
            $this->otp->EditValue = $this->otp->AdvancedSearch->SearchValue;
            $this->otp->PlaceHolder = RemoveHtml($this->otp->caption());

            // pan_response
            $this->pan_response->setupEditAttributes();
            if (!$this->pan_response->Raw) {
                $this->pan_response->AdvancedSearch->SearchValue = HtmlDecode($this->pan_response->AdvancedSearch->SearchValue);
            }
            $this->pan_response->EditValue = HtmlEncode($this->pan_response->AdvancedSearch->SearchValue);
            $this->pan_response->PlaceHolder = RemoveHtml($this->pan_response->caption());

            // pan_verify_datetime
            $this->pan_verify_datetime->setupEditAttributes();
            $this->pan_verify_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->pan_verify_datetime->AdvancedSearch->SearchValue, $this->pan_verify_datetime->formatPattern()), $this->pan_verify_datetime->formatPattern()));
            $this->pan_verify_datetime->PlaceHolder = RemoveHtml($this->pan_verify_datetime->caption());

            // aadhaar_response
            $this->aadhaar_response->setupEditAttributes();
            $this->aadhaar_response->EditValue = HtmlEncode($this->aadhaar_response->AdvancedSearch->SearchValue);
            $this->aadhaar_response->PlaceHolder = RemoveHtml($this->aadhaar_response->caption());

            // aadhaar_verify_datetime
            $this->aadhaar_verify_datetime->setupEditAttributes();
            $this->aadhaar_verify_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->aadhaar_verify_datetime->AdvancedSearch->SearchValue, $this->aadhaar_verify_datetime->formatPattern()), $this->aadhaar_verify_datetime->formatPattern()));
            $this->aadhaar_verify_datetime->PlaceHolder = RemoveHtml($this->aadhaar_verify_datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
            $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->aadhaar_no->AdvancedSearch->SearchValue)) {
            $this->aadhaar_no->addErrorMessage($this->aadhaar_no->getErrorMessage(false));
        }
        if (!CheckDate($this->inv_start_date->AdvancedSearch->SearchValue, $this->inv_start_date->formatPattern())) {
            $this->inv_start_date->addErrorMessage($this->inv_start_date->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->gurantee->AdvancedSearch->SearchValue)) {
            $this->gurantee->addErrorMessage($this->gurantee->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->otp->AdvancedSearch->SearchValue)) {
            $this->otp->addErrorMessage($this->otp->getErrorMessage(false));
        }
        if (!CheckDate($this->pan_response->AdvancedSearch->SearchValue, $this->pan_response->formatPattern())) {
            $this->pan_response->addErrorMessage($this->pan_response->getErrorMessage(false));
        }
        if (!CheckDate($this->pan_verify_datetime->AdvancedSearch->SearchValue, $this->pan_verify_datetime->formatPattern())) {
            $this->pan_verify_datetime->addErrorMessage($this->pan_verify_datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->aadhaar_verify_datetime->AdvancedSearch->SearchValue, $this->aadhaar_verify_datetime->formatPattern())) {
            $this->aadhaar_verify_datetime->addErrorMessage($this->aadhaar_verify_datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->care_of->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->mother_name->AdvancedSearch->load();
        $this->nominee_name->AdvancedSearch->load();
        $this->nominee_relation->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->adviser->AdvancedSearch->load();
        $this->share_no->AdvancedSearch->load();
        $this->inv_start_date->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->gurantee->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->otp->AdvancedSearch->load();
        $this->pan_response->AdvancedSearch->load();
        $this->pan_verify_datetime->AdvancedSearch->load();
        $this->aadhaar_response->AdvancedSearch->load();
        $this->aadhaar_verify_datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("investorinfolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_gender":
                    break;
                case "x_nominee_relation":
                    break;
                case "x_adviser":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
