<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class InvestorInfoAdd extends InvestorInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InvestorInfoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "investorinfoadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->qty->Visible = false;
        $this->aadhaar_no->setVisibility();
        $this->name->setVisibility();
        $this->gender->setVisibility();
        $this->dob->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->address->setVisibility();
        $this->care_of->setVisibility();
        $this->father_name->setVisibility();
        $this->mother_name->setVisibility();
        $this->nominee_name->setVisibility();
        $this->nominee_relation->setVisibility();
        $this->pan_no->setVisibility();
        $this->uploads->setVisibility();
        $this->image->Visible = false;
        $this->adviser->setVisibility();
        $this->share_no->setVisibility();
        $this->inv_start_date->Visible = false;
        $this->amount->Visible = false;
        $this->gurantee->Visible = false;
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->otp->Visible = false;
        $this->pan_response->Visible = false;
        $this->pan_verify_datetime->Visible = false;
        $this->aadhaar_response->Visible = false;
        $this->aadhaar_verify_datetime->Visible = false;
        $this->thumb_data->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'investor_info';
        $this->TableName = 'investor_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (investor_info)
        if (!isset($GLOBALS["investor_info"]) || $GLOBALS["investor_info"]::class == PROJECT_NAMESPACE . "investor_info") {
            $GLOBALS["investor_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'investor_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "investorinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->nominee_relation);
        $this->setupLookupOptions($this->adviser);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("investorinfolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = 'autoprogramme?apcid=6fc6754722b8e76ed6808d9ee828e7e6';

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "investorinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "investorinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->aadhaar_no->Visible = false; // Disable update for API request
            } else {
                $this->aadhaar_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'gender' first before field var 'x_gender'
        $val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
        if (!$this->gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gender->Visible = false; // Disable update for API request
            } else {
                $this->gender->setFormValue($val);
            }
        }

        // Check field name 'dob' first before field var 'x_dob'
        $val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
        if (!$this->dob->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dob->Visible = false; // Disable update for API request
            } else {
                $this->dob->setFormValue($val);
            }
            $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'care_of' first before field var 'x_care_of'
        $val = $CurrentForm->hasValue("care_of") ? $CurrentForm->getValue("care_of") : $CurrentForm->getValue("x_care_of");
        if (!$this->care_of->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->care_of->Visible = false; // Disable update for API request
            } else {
                $this->care_of->setFormValue($val);
            }
        }

        // Check field name 'father_name' first before field var 'x_father_name'
        $val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
        if (!$this->father_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->father_name->Visible = false; // Disable update for API request
            } else {
                $this->father_name->setFormValue($val);
            }
        }

        // Check field name 'mother_name' first before field var 'x_mother_name'
        $val = $CurrentForm->hasValue("mother_name") ? $CurrentForm->getValue("mother_name") : $CurrentForm->getValue("x_mother_name");
        if (!$this->mother_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mother_name->Visible = false; // Disable update for API request
            } else {
                $this->mother_name->setFormValue($val);
            }
        }

        // Check field name 'nominee_name' first before field var 'x_nominee_name'
        $val = $CurrentForm->hasValue("nominee_name") ? $CurrentForm->getValue("nominee_name") : $CurrentForm->getValue("x_nominee_name");
        if (!$this->nominee_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nominee_name->Visible = false; // Disable update for API request
            } else {
                $this->nominee_name->setFormValue($val);
            }
        }

        // Check field name 'nominee_relation' first before field var 'x_nominee_relation'
        $val = $CurrentForm->hasValue("nominee_relation") ? $CurrentForm->getValue("nominee_relation") : $CurrentForm->getValue("x_nominee_relation");
        if (!$this->nominee_relation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nominee_relation->Visible = false; // Disable update for API request
            } else {
                $this->nominee_relation->setFormValue($val);
            }
        }

        // Check field name 'pan_no' first before field var 'x_pan_no'
        $val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
        if (!$this->pan_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pan_no->Visible = false; // Disable update for API request
            } else {
                $this->pan_no->setFormValue($val);
            }
        }

        // Check field name 'adviser' first before field var 'x_adviser'
        $val = $CurrentForm->hasValue("adviser") ? $CurrentForm->getValue("adviser") : $CurrentForm->getValue("x_adviser");
        if (!$this->adviser->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->adviser->Visible = false; // Disable update for API request
            } else {
                $this->adviser->setFormValue($val);
            }
        }

        // Check field name 'share_no' first before field var 'x_share_no'
        $val = $CurrentForm->hasValue("share_no") ? $CurrentForm->getValue("share_no") : $CurrentForm->getValue("x_share_no");
        if (!$this->share_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->share_no->Visible = false; // Disable update for API request
            } else {
                $this->share_no->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->gender->CurrentValue = $this->gender->FormValue;
        $this->dob->CurrentValue = $this->dob->FormValue;
        $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->care_of->CurrentValue = $this->care_of->FormValue;
        $this->father_name->CurrentValue = $this->father_name->FormValue;
        $this->mother_name->CurrentValue = $this->mother_name->FormValue;
        $this->nominee_name->CurrentValue = $this->nominee_name->FormValue;
        $this->nominee_relation->CurrentValue = $this->nominee_relation->FormValue;
        $this->pan_no->CurrentValue = $this->pan_no->FormValue;
        $this->adviser->CurrentValue = $this->adviser->FormValue;
        $this->share_no->CurrentValue = $this->share_no->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->qty->setDbValue($row['qty']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->name->setDbValue($row['name']);
        $this->gender->setDbValue($row['gender']);
        $this->dob->setDbValue($row['dob']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->address->setDbValue($row['address']);
        $this->care_of->setDbValue($row['care_of']);
        $this->father_name->setDbValue($row['father_name']);
        $this->mother_name->setDbValue($row['mother_name']);
        $this->nominee_name->setDbValue($row['nominee_name']);
        $this->nominee_relation->setDbValue($row['nominee_relation']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->adviser->setDbValue($row['adviser']);
        $this->share_no->setDbValue($row['share_no']);
        $this->inv_start_date->setDbValue($row['inv_start_date']);
        $this->amount->setDbValue($row['amount']);
        $this->gurantee->setDbValue($row['gurantee']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->otp->setDbValue($row['otp']);
        $this->pan_response->setDbValue($row['pan_response']);
        $this->pan_verify_datetime->setDbValue($row['pan_verify_datetime']);
        $this->aadhaar_response->setDbValue($row['aadhaar_response']);
        $this->aadhaar_verify_datetime->setDbValue($row['aadhaar_verify_datetime']);
        $this->thumb_data->setDbValue($row['thumb_data']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['care_of'] = $this->care_of->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['mother_name'] = $this->mother_name->DefaultValue;
        $row['nominee_name'] = $this->nominee_name->DefaultValue;
        $row['nominee_relation'] = $this->nominee_relation->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['adviser'] = $this->adviser->DefaultValue;
        $row['share_no'] = $this->share_no->DefaultValue;
        $row['inv_start_date'] = $this->inv_start_date->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['gurantee'] = $this->gurantee->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['otp'] = $this->otp->DefaultValue;
        $row['pan_response'] = $this->pan_response->DefaultValue;
        $row['pan_verify_datetime'] = $this->pan_verify_datetime->DefaultValue;
        $row['aadhaar_response'] = $this->aadhaar_response->DefaultValue;
        $row['aadhaar_verify_datetime'] = $this->aadhaar_verify_datetime->DefaultValue;
        $row['thumb_data'] = $this->thumb_data->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // care_of
        $this->care_of->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // mother_name
        $this->mother_name->RowCssClass = "row";

        // nominee_name
        $this->nominee_name->RowCssClass = "row";

        // nominee_relation
        $this->nominee_relation->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // adviser
        $this->adviser->RowCssClass = "row";

        // share_no
        $this->share_no->RowCssClass = "row";

        // inv_start_date
        $this->inv_start_date->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // gurantee
        $this->gurantee->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // otp
        $this->otp->RowCssClass = "row";

        // pan_response
        $this->pan_response->RowCssClass = "row";

        // pan_verify_datetime
        $this->pan_verify_datetime->RowCssClass = "row";

        // aadhaar_response
        $this->aadhaar_response->RowCssClass = "row";

        // aadhaar_verify_datetime
        $this->aadhaar_verify_datetime->RowCssClass = "row";

        // thumb_data
        $this->thumb_data->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // care_of
            $this->care_of->ViewValue = $this->care_of->CurrentValue;

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // mother_name
            $this->mother_name->ViewValue = $this->mother_name->CurrentValue;

            // nominee_name
            $this->nominee_name->ViewValue = $this->nominee_name->CurrentValue;

            // nominee_relation
            if (strval($this->nominee_relation->CurrentValue) != "") {
                $this->nominee_relation->ViewValue = $this->nominee_relation->optionCaption($this->nominee_relation->CurrentValue);
            } else {
                $this->nominee_relation->ViewValue = null;
            }

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // adviser
            $curVal = strval($this->adviser->CurrentValue);
            if ($curVal != "") {
                $this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
                if ($this->adviser->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                    $sqlWrk = $this->adviser->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->adviser->Lookup->renderViewRow($rswrk[0]);
                        $this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
                    } else {
                        $this->adviser->ViewValue = FormatNumber($this->adviser->CurrentValue, $this->adviser->formatPattern());
                    }
                }
            } else {
                $this->adviser->ViewValue = null;
            }

            // share_no
            $this->share_no->ViewValue = $this->share_no->CurrentValue;

            // inv_start_date
            $this->inv_start_date->ViewValue = $this->inv_start_date->CurrentValue;
            $this->inv_start_date->ViewValue = FormatDateTime($this->inv_start_date->ViewValue, $this->inv_start_date->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // gurantee
            $this->gurantee->ViewValue = $this->gurantee->CurrentValue;
            $this->gurantee->ViewValue = FormatNumber($this->gurantee->ViewValue, $this->gurantee->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // care_of
            $this->care_of->HrefValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";

            // nominee_name
            $this->nominee_name->HrefValue = "";

            // nominee_relation
            $this->nominee_relation->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // adviser
            $this->adviser->HrefValue = "";

            // share_no
            $this->share_no->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // address
            $this->address->setupEditAttributes();
            if (!$this->address->Raw) {
                $this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
            }
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // care_of
            $this->care_of->setupEditAttributes();
            if (!$this->care_of->Raw) {
                $this->care_of->CurrentValue = HtmlDecode($this->care_of->CurrentValue);
            }
            $this->care_of->EditValue = HtmlEncode($this->care_of->CurrentValue);
            $this->care_of->PlaceHolder = RemoveHtml($this->care_of->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // mother_name
            $this->mother_name->setupEditAttributes();
            if (!$this->mother_name->Raw) {
                $this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
            }
            $this->mother_name->EditValue = HtmlEncode($this->mother_name->CurrentValue);
            $this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

            // nominee_name
            $this->nominee_name->setupEditAttributes();
            if (!$this->nominee_name->Raw) {
                $this->nominee_name->CurrentValue = HtmlDecode($this->nominee_name->CurrentValue);
            }
            $this->nominee_name->EditValue = HtmlEncode($this->nominee_name->CurrentValue);
            $this->nominee_name->PlaceHolder = RemoveHtml($this->nominee_name->caption());

            // nominee_relation
            $this->nominee_relation->setupEditAttributes();
            $this->nominee_relation->EditValue = $this->nominee_relation->options(true);
            $this->nominee_relation->PlaceHolder = RemoveHtml($this->nominee_relation->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // adviser
            $this->adviser->setupEditAttributes();
            $curVal = trim(strval($this->adviser->CurrentValue));
            if ($curVal != "") {
                $this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
            } else {
                $this->adviser->ViewValue = $this->adviser->Lookup !== null && is_array($this->adviser->lookupOptions()) && count($this->adviser->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->adviser->ViewValue !== null) { // Load from cache
                $this->adviser->EditValue = array_values($this->adviser->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->adviser->CurrentValue, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                $sqlWrk = $this->adviser->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->adviser->EditValue = $arwrk;
            }
            $this->adviser->PlaceHolder = RemoveHtml($this->adviser->caption());

            // share_no
            $this->share_no->setupEditAttributes();
            $this->share_no->EditCustomAttributes = $this->share_no->getEditCustomAttributes(); // PHP
            $this->share_no->EditValue = HtmlEncode($this->share_no->CurrentValue);
            $this->share_no->PlaceHolder = RemoveHtml($this->share_no->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // Add refer script

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // care_of
            $this->care_of->HrefValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";

            // nominee_name
            $this->nominee_name->HrefValue = "";

            // nominee_relation
            $this->nominee_relation->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // adviser
            $this->adviser->HrefValue = "";

            // share_no
            $this->share_no->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if (!$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->aadhaar_no->FormValue)) {
                $this->aadhaar_no->addErrorMessage($this->aadhaar_no->getErrorMessage(false));
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->gender->Visible && $this->gender->Required) {
                if (!$this->gender->IsDetailKey && EmptyValue($this->gender->FormValue)) {
                    $this->gender->addErrorMessage(str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
                }
            }
            if ($this->dob->Visible && $this->dob->Required) {
                if (!$this->dob->IsDetailKey && EmptyValue($this->dob->FormValue)) {
                    $this->dob->addErrorMessage(str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->care_of->Visible && $this->care_of->Required) {
                if (!$this->care_of->IsDetailKey && EmptyValue($this->care_of->FormValue)) {
                    $this->care_of->addErrorMessage(str_replace("%s", $this->care_of->caption(), $this->care_of->RequiredErrorMessage));
                }
            }
            if ($this->father_name->Visible && $this->father_name->Required) {
                if (!$this->father_name->IsDetailKey && EmptyValue($this->father_name->FormValue)) {
                    $this->father_name->addErrorMessage(str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
                }
            }
            if ($this->mother_name->Visible && $this->mother_name->Required) {
                if (!$this->mother_name->IsDetailKey && EmptyValue($this->mother_name->FormValue)) {
                    $this->mother_name->addErrorMessage(str_replace("%s", $this->mother_name->caption(), $this->mother_name->RequiredErrorMessage));
                }
            }
            if ($this->nominee_name->Visible && $this->nominee_name->Required) {
                if (!$this->nominee_name->IsDetailKey && EmptyValue($this->nominee_name->FormValue)) {
                    $this->nominee_name->addErrorMessage(str_replace("%s", $this->nominee_name->caption(), $this->nominee_name->RequiredErrorMessage));
                }
            }
            if ($this->nominee_relation->Visible && $this->nominee_relation->Required) {
                if (!$this->nominee_relation->IsDetailKey && EmptyValue($this->nominee_relation->FormValue)) {
                    $this->nominee_relation->addErrorMessage(str_replace("%s", $this->nominee_relation->caption(), $this->nominee_relation->RequiredErrorMessage));
                }
            }
            if ($this->pan_no->Visible && $this->pan_no->Required) {
                if (!$this->pan_no->IsDetailKey && EmptyValue($this->pan_no->FormValue)) {
                    $this->pan_no->addErrorMessage(str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->adviser->Visible && $this->adviser->Required) {
                if (!$this->adviser->IsDetailKey && EmptyValue($this->adviser->FormValue)) {
                    $this->adviser->addErrorMessage(str_replace("%s", $this->adviser->caption(), $this->adviser->RequiredErrorMessage));
                }
            }
            if ($this->share_no->Visible && $this->share_no->Required) {
                if (!$this->share_no->IsDetailKey && EmptyValue($this->share_no->FormValue)) {
                    $this->share_no->addErrorMessage(str_replace("%s", $this->share_no->caption(), $this->share_no->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // aadhaar_no
        $this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, false);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, false);

        // gender
        $this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, false);

        // dob
        $this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()), false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // care_of
        $this->care_of->setDbValueDef($rsnew, $this->care_of->CurrentValue, false);

        // father_name
        $this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, false);

        // mother_name
        $this->mother_name->setDbValueDef($rsnew, $this->mother_name->CurrentValue, false);

        // nominee_name
        $this->nominee_name->setDbValueDef($rsnew, $this->nominee_name->CurrentValue, false);

        // nominee_relation
        $this->nominee_relation->setDbValueDef($rsnew, $this->nominee_relation->CurrentValue, false);

        // pan_no
        $this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 640; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // adviser
        $this->adviser->setDbValueDef($rsnew, $this->adviser->CurrentValue, false);

        // share_no
        $this->share_no->setDbValueDef($rsnew, $this->share_no->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['aadhaar_no'])) { // aadhaar_no
            $this->aadhaar_no->setFormValue($row['aadhaar_no']);
        }
        if (isset($row['name'])) { // name
            $this->name->setFormValue($row['name']);
        }
        if (isset($row['gender'])) { // gender
            $this->gender->setFormValue($row['gender']);
        }
        if (isset($row['dob'])) { // dob
            $this->dob->setFormValue($row['dob']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['care_of'])) { // care_of
            $this->care_of->setFormValue($row['care_of']);
        }
        if (isset($row['father_name'])) { // father_name
            $this->father_name->setFormValue($row['father_name']);
        }
        if (isset($row['mother_name'])) { // mother_name
            $this->mother_name->setFormValue($row['mother_name']);
        }
        if (isset($row['nominee_name'])) { // nominee_name
            $this->nominee_name->setFormValue($row['nominee_name']);
        }
        if (isset($row['nominee_relation'])) { // nominee_relation
            $this->nominee_relation->setFormValue($row['nominee_relation']);
        }
        if (isset($row['pan_no'])) { // pan_no
            $this->pan_no->setFormValue($row['pan_no']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['adviser'])) { // adviser
            $this->adviser->setFormValue($row['adviser']);
        }
        if (isset($row['share_no'])) { // share_no
            $this->share_no->setFormValue($row['share_no']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("investorinfolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_gender":
                    break;
                case "x_nominee_relation":
                    break;
                case "x_adviser":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
