<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for int_fibre_message_template_admin
 */
class IntFibreMessageTemplateAdmin extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $description;
    public $subject;
    public $status_email_user;
    public $email_template_user;
    public $mail_to_office;
    public $status_email_office;
    public $email_template_office;
    public $code;
    public $variables;
    public $status_sms_user;
    public $sms_template_user;
    public $status_sms_office;
    public $sms_to_office;
    public $sms_template_office;
    public $wa_status_user;
    public $wa_template_user;
    public $wa_status_office;
    public $wa_to_office;
    public $wa_template_office;
    public $wa_id;
    public $notification_status_user;
    public $notification_template_user;
    public $notification_status_office;
    public $notification_to_office;
    public $notification_template_office;
    public $cron;
    public $next_cycle;
    public $delay;
    public $delay_method;
    public $_visible;
    public $operator;
    public $datetime;
    public $operator_admin;
    public $datetime_admin;
    public $company_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "int_fibre_message_template_admin";
        $this->TableName = 'int_fibre_message_template_admin';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "int_fibre_message_template_admin";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // description
        $this->description = new DbField(
            $this, // Table
            'x_description', // Variable name
            'description', // Name
            '`description`', // Expression
            '`description`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description->InputTextType = "text";
        $this->description->Nullable = false; // NOT NULL field
        $this->description->Required = true; // Required field
        $this->description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['description'] = &$this->description;

        // subject
        $this->subject = new DbField(
            $this, // Table
            'x_subject', // Variable name
            'subject', // Name
            '`subject`', // Expression
            '`subject`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`subject`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->subject->InputTextType = "text";
        $this->subject->Nullable = false; // NOT NULL field
        $this->subject->Required = true; // Required field
        $this->subject->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['subject'] = &$this->subject;

        // status_email_user
        $this->status_email_user = new DbField(
            $this, // Table
            'x_status_email_user', // Variable name
            'status_email_user', // Name
            '`status_email_user`', // Expression
            '`status_email_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_email_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status_email_user->addMethod("getDefault", fn() => 0);
        $this->status_email_user->InputTextType = "text";
        $this->status_email_user->Raw = true;
        $this->status_email_user->Nullable = false; // NOT NULL field
        $this->status_email_user->Required = true; // Required field
        $this->status_email_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_email_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_email_user'] = &$this->status_email_user;

        // email_template_user
        $this->email_template_user = new DbField(
            $this, // Table
            'x_email_template_user', // Variable name
            'email_template_user', // Name
            '`email_template_user`', // Expression
            '`email_template_user`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`email_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->email_template_user->InputTextType = "text";
        $this->email_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['email_template_user'] = &$this->email_template_user;

        // mail_to_office
        $this->mail_to_office = new DbField(
            $this, // Table
            'x_mail_to_office', // Variable name
            'mail_to_office', // Name
            '`mail_to_office`', // Expression
            '`mail_to_office`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mail_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->mail_to_office->InputTextType = "text";
        $this->mail_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['mail_to_office'] = &$this->mail_to_office;

        // status_email_office
        $this->status_email_office = new DbField(
            $this, // Table
            'x_status_email_office', // Variable name
            'status_email_office', // Name
            '`status_email_office`', // Expression
            '`status_email_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_email_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status_email_office->addMethod("getDefault", fn() => 0);
        $this->status_email_office->InputTextType = "text";
        $this->status_email_office->Raw = true;
        $this->status_email_office->Nullable = false; // NOT NULL field
        $this->status_email_office->Required = true; // Required field
        $this->status_email_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_email_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_email_office'] = &$this->status_email_office;

        // email_template_office
        $this->email_template_office = new DbField(
            $this, // Table
            'x_email_template_office', // Variable name
            'email_template_office', // Name
            '`email_template_office`', // Expression
            '`email_template_office`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`email_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->email_template_office->InputTextType = "text";
        $this->email_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['email_template_office'] = &$this->email_template_office;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->code->InputTextType = "text";
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['code'] = &$this->code;

        // variables
        $this->variables = new DbField(
            $this, // Table
            'x_variables', // Variable name
            'variables', // Name
            '`variables`', // Expression
            '`variables`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`variables`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->variables->InputTextType = "text";
        $this->variables->Nullable = false; // NOT NULL field
        $this->variables->Required = true; // Required field
        $this->variables->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['variables'] = &$this->variables;

        // status_sms_user
        $this->status_sms_user = new DbField(
            $this, // Table
            'x_status_sms_user', // Variable name
            'status_sms_user', // Name
            '`status_sms_user`', // Expression
            '`status_sms_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_sms_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status_sms_user->addMethod("getDefault", fn() => 0);
        $this->status_sms_user->InputTextType = "text";
        $this->status_sms_user->Raw = true;
        $this->status_sms_user->Nullable = false; // NOT NULL field
        $this->status_sms_user->Required = true; // Required field
        $this->status_sms_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_sms_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_sms_user'] = &$this->status_sms_user;

        // sms_template_user
        $this->sms_template_user = new DbField(
            $this, // Table
            'x_sms_template_user', // Variable name
            'sms_template_user', // Name
            '`sms_template_user`', // Expression
            '`sms_template_user`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sms_template_user->InputTextType = "text";
        $this->sms_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_template_user'] = &$this->sms_template_user;

        // status_sms_office
        $this->status_sms_office = new DbField(
            $this, // Table
            'x_status_sms_office', // Variable name
            'status_sms_office', // Name
            '`status_sms_office`', // Expression
            '`status_sms_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_sms_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status_sms_office->addMethod("getDefault", fn() => 0);
        $this->status_sms_office->InputTextType = "text";
        $this->status_sms_office->Raw = true;
        $this->status_sms_office->Nullable = false; // NOT NULL field
        $this->status_sms_office->Required = true; // Required field
        $this->status_sms_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_sms_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_sms_office'] = &$this->status_sms_office;

        // sms_to_office
        $this->sms_to_office = new DbField(
            $this, // Table
            'x_sms_to_office', // Variable name
            'sms_to_office', // Name
            '`sms_to_office`', // Expression
            '`sms_to_office`', // Basic search expression
            200, // Type
            44, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sms_to_office->InputTextType = "text";
        $this->sms_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_to_office'] = &$this->sms_to_office;

        // sms_template_office
        $this->sms_template_office = new DbField(
            $this, // Table
            'x_sms_template_office', // Variable name
            'sms_template_office', // Name
            '`sms_template_office`', // Expression
            '`sms_template_office`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sms_template_office->InputTextType = "text";
        $this->sms_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_template_office'] = &$this->sms_template_office;

        // wa_status_user
        $this->wa_status_user = new DbField(
            $this, // Table
            'x_wa_status_user', // Variable name
            'wa_status_user', // Name
            '`wa_status_user`', // Expression
            '`wa_status_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_status_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->wa_status_user->addMethod("getDefault", fn() => 0);
        $this->wa_status_user->InputTextType = "text";
        $this->wa_status_user->Raw = true;
        $this->wa_status_user->Nullable = false; // NOT NULL field
        $this->wa_status_user->Required = true; // Required field
        $this->wa_status_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_status_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['wa_status_user'] = &$this->wa_status_user;

        // wa_template_user
        $this->wa_template_user = new DbField(
            $this, // Table
            'x_wa_template_user', // Variable name
            'wa_template_user', // Name
            '`wa_template_user`', // Expression
            '`wa_template_user`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->wa_template_user->InputTextType = "text";
        $this->wa_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_template_user'] = &$this->wa_template_user;

        // wa_status_office
        $this->wa_status_office = new DbField(
            $this, // Table
            'x_wa_status_office', // Variable name
            'wa_status_office', // Name
            '`wa_status_office`', // Expression
            '`wa_status_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_status_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->wa_status_office->InputTextType = "text";
        $this->wa_status_office->Raw = true;
        $this->wa_status_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_status_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_status_office'] = &$this->wa_status_office;

        // wa_to_office
        $this->wa_to_office = new DbField(
            $this, // Table
            'x_wa_to_office', // Variable name
            'wa_to_office', // Name
            '`wa_to_office`', // Expression
            '`wa_to_office`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->wa_to_office->InputTextType = "text";
        $this->wa_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_to_office'] = &$this->wa_to_office;

        // wa_template_office
        $this->wa_template_office = new DbField(
            $this, // Table
            'x_wa_template_office', // Variable name
            'wa_template_office', // Name
            '`wa_template_office`', // Expression
            '`wa_template_office`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->wa_template_office->InputTextType = "text";
        $this->wa_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_template_office'] = &$this->wa_template_office;

        // wa_id
        $this->wa_id = new DbField(
            $this, // Table
            'x_wa_id', // Variable name
            'wa_id', // Name
            '`wa_id`', // Expression
            '`wa_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->wa_id->addMethod("getDefault", fn() => 1);
        $this->wa_id->InputTextType = "text";
        $this->wa_id->Raw = true;
        $this->wa_id->Nullable = false; // NOT NULL field
        $this->wa_id->Required = true; // Required field
        $this->wa_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['wa_id'] = &$this->wa_id;

        // notification_status_user
        $this->notification_status_user = new DbField(
            $this, // Table
            'x_notification_status_user', // Variable name
            'notification_status_user', // Name
            '`notification_status_user`', // Expression
            '`notification_status_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_status_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->notification_status_user->addMethod("getDefault", fn() => 0);
        $this->notification_status_user->InputTextType = "text";
        $this->notification_status_user->Raw = true;
        $this->notification_status_user->Nullable = false; // NOT NULL field
        $this->notification_status_user->Required = true; // Required field
        $this->notification_status_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->notification_status_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['notification_status_user'] = &$this->notification_status_user;

        // notification_template_user
        $this->notification_template_user = new DbField(
            $this, // Table
            'x_notification_template_user', // Variable name
            'notification_template_user', // Name
            '`notification_template_user`', // Expression
            '`notification_template_user`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->notification_template_user->InputTextType = "text";
        $this->notification_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['notification_template_user'] = &$this->notification_template_user;

        // notification_status_office
        $this->notification_status_office = new DbField(
            $this, // Table
            'x_notification_status_office', // Variable name
            'notification_status_office', // Name
            '`notification_status_office`', // Expression
            '`notification_status_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_status_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->notification_status_office->addMethod("getDefault", fn() => 0);
        $this->notification_status_office->InputTextType = "text";
        $this->notification_status_office->Raw = true;
        $this->notification_status_office->Nullable = false; // NOT NULL field
        $this->notification_status_office->Required = true; // Required field
        $this->notification_status_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->notification_status_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['notification_status_office'] = &$this->notification_status_office;

        // notification_to_office
        $this->notification_to_office = new DbField(
            $this, // Table
            'x_notification_to_office', // Variable name
            'notification_to_office', // Name
            '`notification_to_office`', // Expression
            '`notification_to_office`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->notification_to_office->InputTextType = "text";
        $this->notification_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['notification_to_office'] = &$this->notification_to_office;

        // notification_template_office
        $this->notification_template_office = new DbField(
            $this, // Table
            'x_notification_template_office', // Variable name
            'notification_template_office', // Name
            '`notification_template_office`', // Expression
            '`notification_template_office`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->notification_template_office->InputTextType = "text";
        $this->notification_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['notification_template_office'] = &$this->notification_template_office;

        // cron
        $this->cron = new DbField(
            $this, // Table
            'x_cron', // Variable name
            'cron', // Name
            '`cron`', // Expression
            '`cron`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cron`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cron->addMethod("getDefault", fn() => 0);
        $this->cron->InputTextType = "text";
        $this->cron->Raw = true;
        $this->cron->Nullable = false; // NOT NULL field
        $this->cron->Required = true; // Required field
        $this->cron->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cron->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cron'] = &$this->cron;

        // next_cycle
        $this->next_cycle = new DbField(
            $this, // Table
            'x_next_cycle', // Variable name
            'next_cycle', // Name
            '`next_cycle`', // Expression
            CastDateFieldForLike("`next_cycle`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`next_cycle`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->next_cycle->InputTextType = "text";
        $this->next_cycle->Raw = true;
        $this->next_cycle->Nullable = false; // NOT NULL field
        $this->next_cycle->Required = true; // Required field
        $this->next_cycle->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->next_cycle->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['next_cycle'] = &$this->next_cycle;

        // delay
        $this->delay = new DbField(
            $this, // Table
            'x_delay', // Variable name
            'delay', // Name
            '`delay`', // Expression
            '`delay`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delay`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->delay->addMethod("getDefault", fn() => 255);
        $this->delay->InputTextType = "text";
        $this->delay->Raw = true;
        $this->delay->Nullable = false; // NOT NULL field
        $this->delay->Required = true; // Required field
        $this->delay->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->delay->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['delay'] = &$this->delay;

        // delay_method
        $this->delay_method = new DbField(
            $this, // Table
            'x_delay_method', // Variable name
            'delay_method', // Name
            '`delay_method`', // Expression
            '`delay_method`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delay_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->delay_method->addMethod("getDefault", fn() => 4);
        $this->delay_method->InputTextType = "text";
        $this->delay_method->Raw = true;
        $this->delay_method->Nullable = false; // NOT NULL field
        $this->delay_method->Required = true; // Required field
        $this->delay_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->delay_method->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['delay_method'] = &$this->delay_method;

        // visible
        $this->_visible = new DbField(
            $this, // Table
            'x__visible', // Variable name
            'visible', // Name
            '`visible`', // Expression
            '`visible`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`visible`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_visible->addMethod("getDefault", fn() => 0);
        $this->_visible->InputTextType = "text";
        $this->_visible->Raw = true;
        $this->_visible->Nullable = false; // NOT NULL field
        $this->_visible->Required = true; // Required field
        $this->_visible->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_visible->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['visible'] = &$this->_visible;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // operator_admin
        $this->operator_admin = new DbField(
            $this, // Table
            'x_operator_admin', // Variable name
            'operator_admin', // Name
            '`operator_admin`', // Expression
            '`operator_admin`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator_admin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator_admin->addMethod("getDefault", fn() => -1);
        $this->operator_admin->InputTextType = "text";
        $this->operator_admin->Raw = true;
        $this->operator_admin->Nullable = false; // NOT NULL field
        $this->operator_admin->Required = true; // Required field
        $this->operator_admin->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator_admin->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['operator_admin'] = &$this->operator_admin;

        // datetime_admin
        $this->datetime_admin = new DbField(
            $this, // Table
            'x_datetime_admin', // Variable name
            'datetime_admin', // Name
            '`datetime_admin`', // Expression
            CastDateFieldForLike("`datetime_admin`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime_admin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime_admin->InputTextType = "text";
        $this->datetime_admin->Raw = true;
        $this->datetime_admin->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime_admin->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime_admin'] = &$this->datetime_admin;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->addMethod("getDefault", fn() => 200000);
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Nullable = false; // NOT NULL field
        $this->company_id->Required = true; // Required field
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['company_id'] = &$this->company_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "int_fibre_message_template_admin";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->description->DbValue = $row['description'];
        $this->subject->DbValue = $row['subject'];
        $this->status_email_user->DbValue = $row['status_email_user'];
        $this->email_template_user->DbValue = $row['email_template_user'];
        $this->mail_to_office->DbValue = $row['mail_to_office'];
        $this->status_email_office->DbValue = $row['status_email_office'];
        $this->email_template_office->DbValue = $row['email_template_office'];
        $this->code->DbValue = $row['code'];
        $this->variables->DbValue = $row['variables'];
        $this->status_sms_user->DbValue = $row['status_sms_user'];
        $this->sms_template_user->DbValue = $row['sms_template_user'];
        $this->status_sms_office->DbValue = $row['status_sms_office'];
        $this->sms_to_office->DbValue = $row['sms_to_office'];
        $this->sms_template_office->DbValue = $row['sms_template_office'];
        $this->wa_status_user->DbValue = $row['wa_status_user'];
        $this->wa_template_user->DbValue = $row['wa_template_user'];
        $this->wa_status_office->DbValue = $row['wa_status_office'];
        $this->wa_to_office->DbValue = $row['wa_to_office'];
        $this->wa_template_office->DbValue = $row['wa_template_office'];
        $this->wa_id->DbValue = $row['wa_id'];
        $this->notification_status_user->DbValue = $row['notification_status_user'];
        $this->notification_template_user->DbValue = $row['notification_template_user'];
        $this->notification_status_office->DbValue = $row['notification_status_office'];
        $this->notification_to_office->DbValue = $row['notification_to_office'];
        $this->notification_template_office->DbValue = $row['notification_template_office'];
        $this->cron->DbValue = $row['cron'];
        $this->next_cycle->DbValue = $row['next_cycle'];
        $this->delay->DbValue = $row['delay'];
        $this->delay_method->DbValue = $row['delay_method'];
        $this->_visible->DbValue = $row['visible'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->operator_admin->DbValue = $row['operator_admin'];
        $this->datetime_admin->DbValue = $row['datetime_admin'];
        $this->company_id->DbValue = $row['company_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("intfibremessagetemplateadminlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "intfibremessagetemplateadminview" => $Language->phrase("View"),
            "intfibremessagetemplateadminedit" => $Language->phrase("Edit"),
            "intfibremessagetemplateadminadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "intfibremessagetemplateadminlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "IntFibreMessageTemplateAdminView",
            Config("API_ADD_ACTION") => "IntFibreMessageTemplateAdminAdd",
            Config("API_EDIT_ACTION") => "IntFibreMessageTemplateAdminEdit",
            Config("API_DELETE_ACTION") => "IntFibreMessageTemplateAdminDelete",
            Config("API_LIST_ACTION") => "IntFibreMessageTemplateAdminList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "intfibremessagetemplateadminlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("intfibremessagetemplateadminview", $parm);
        } else {
            $url = $this->keyUrl("intfibremessagetemplateadminview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "intfibremessagetemplateadminadd?" . $parm;
        } else {
            $url = "intfibremessagetemplateadminadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("intfibremessagetemplateadminedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("intfibremessagetemplateadminlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("intfibremessagetemplateadminadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("intfibremessagetemplateadminlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("intfibremessagetemplateadmindelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->description->setDbValue($row['description']);
        $this->subject->setDbValue($row['subject']);
        $this->status_email_user->setDbValue($row['status_email_user']);
        $this->email_template_user->setDbValue($row['email_template_user']);
        $this->mail_to_office->setDbValue($row['mail_to_office']);
        $this->status_email_office->setDbValue($row['status_email_office']);
        $this->email_template_office->setDbValue($row['email_template_office']);
        $this->code->setDbValue($row['code']);
        $this->variables->setDbValue($row['variables']);
        $this->status_sms_user->setDbValue($row['status_sms_user']);
        $this->sms_template_user->setDbValue($row['sms_template_user']);
        $this->status_sms_office->setDbValue($row['status_sms_office']);
        $this->sms_to_office->setDbValue($row['sms_to_office']);
        $this->sms_template_office->setDbValue($row['sms_template_office']);
        $this->wa_status_user->setDbValue($row['wa_status_user']);
        $this->wa_template_user->setDbValue($row['wa_template_user']);
        $this->wa_status_office->setDbValue($row['wa_status_office']);
        $this->wa_to_office->setDbValue($row['wa_to_office']);
        $this->wa_template_office->setDbValue($row['wa_template_office']);
        $this->wa_id->setDbValue($row['wa_id']);
        $this->notification_status_user->setDbValue($row['notification_status_user']);
        $this->notification_template_user->setDbValue($row['notification_template_user']);
        $this->notification_status_office->setDbValue($row['notification_status_office']);
        $this->notification_to_office->setDbValue($row['notification_to_office']);
        $this->notification_template_office->setDbValue($row['notification_template_office']);
        $this->cron->setDbValue($row['cron']);
        $this->next_cycle->setDbValue($row['next_cycle']);
        $this->delay->setDbValue($row['delay']);
        $this->delay_method->setDbValue($row['delay_method']);
        $this->_visible->setDbValue($row['visible']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->operator_admin->setDbValue($row['operator_admin']);
        $this->datetime_admin->setDbValue($row['datetime_admin']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "IntFibreMessageTemplateAdminList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // grp

        // description

        // subject

        // status_email_user

        // email_template_user

        // mail_to_office

        // status_email_office

        // email_template_office

        // code

        // variables

        // status_sms_user

        // sms_template_user

        // status_sms_office

        // sms_to_office

        // sms_template_office

        // wa_status_user

        // wa_template_user

        // wa_status_office

        // wa_to_office

        // wa_template_office

        // wa_id

        // notification_status_user

        // notification_template_user

        // notification_status_office

        // notification_to_office

        // notification_template_office

        // cron

        // next_cycle

        // delay

        // delay_method

        // visible

        // operator

        // datetime

        // operator_admin

        // datetime_admin

        // company_id

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // grp
        $this->grp->ViewValue = $this->grp->CurrentValue;
        $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

        // description
        $this->description->ViewValue = $this->description->CurrentValue;

        // subject
        $this->subject->ViewValue = $this->subject->CurrentValue;

        // status_email_user
        $this->status_email_user->ViewValue = $this->status_email_user->CurrentValue;
        $this->status_email_user->ViewValue = FormatNumber($this->status_email_user->ViewValue, $this->status_email_user->formatPattern());

        // email_template_user
        $this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;

        // mail_to_office
        $this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;

        // status_email_office
        $this->status_email_office->ViewValue = $this->status_email_office->CurrentValue;
        $this->status_email_office->ViewValue = FormatNumber($this->status_email_office->ViewValue, $this->status_email_office->formatPattern());

        // email_template_office
        $this->email_template_office->ViewValue = $this->email_template_office->CurrentValue;

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // variables
        $this->variables->ViewValue = $this->variables->CurrentValue;

        // status_sms_user
        $this->status_sms_user->ViewValue = $this->status_sms_user->CurrentValue;
        $this->status_sms_user->ViewValue = FormatNumber($this->status_sms_user->ViewValue, $this->status_sms_user->formatPattern());

        // sms_template_user
        $this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;

        // status_sms_office
        $this->status_sms_office->ViewValue = $this->status_sms_office->CurrentValue;
        $this->status_sms_office->ViewValue = FormatNumber($this->status_sms_office->ViewValue, $this->status_sms_office->formatPattern());

        // sms_to_office
        $this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;

        // sms_template_office
        $this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;

        // wa_status_user
        $this->wa_status_user->ViewValue = $this->wa_status_user->CurrentValue;
        $this->wa_status_user->ViewValue = FormatNumber($this->wa_status_user->ViewValue, $this->wa_status_user->formatPattern());

        // wa_template_user
        $this->wa_template_user->ViewValue = $this->wa_template_user->CurrentValue;

        // wa_status_office
        $this->wa_status_office->ViewValue = $this->wa_status_office->CurrentValue;
        $this->wa_status_office->ViewValue = FormatNumber($this->wa_status_office->ViewValue, $this->wa_status_office->formatPattern());

        // wa_to_office
        $this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;

        // wa_template_office
        $this->wa_template_office->ViewValue = $this->wa_template_office->CurrentValue;

        // wa_id
        $this->wa_id->ViewValue = $this->wa_id->CurrentValue;
        $this->wa_id->ViewValue = FormatNumber($this->wa_id->ViewValue, $this->wa_id->formatPattern());

        // notification_status_user
        $this->notification_status_user->ViewValue = $this->notification_status_user->CurrentValue;
        $this->notification_status_user->ViewValue = FormatNumber($this->notification_status_user->ViewValue, $this->notification_status_user->formatPattern());

        // notification_template_user
        $this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;

        // notification_status_office
        $this->notification_status_office->ViewValue = $this->notification_status_office->CurrentValue;
        $this->notification_status_office->ViewValue = FormatNumber($this->notification_status_office->ViewValue, $this->notification_status_office->formatPattern());

        // notification_to_office
        $this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;

        // notification_template_office
        $this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;

        // cron
        $this->cron->ViewValue = $this->cron->CurrentValue;
        $this->cron->ViewValue = FormatNumber($this->cron->ViewValue, $this->cron->formatPattern());

        // next_cycle
        $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
        $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

        // delay
        $this->delay->ViewValue = $this->delay->CurrentValue;
        $this->delay->ViewValue = FormatNumber($this->delay->ViewValue, $this->delay->formatPattern());

        // delay_method
        $this->delay_method->ViewValue = $this->delay_method->CurrentValue;
        $this->delay_method->ViewValue = FormatNumber($this->delay_method->ViewValue, $this->delay_method->formatPattern());

        // visible
        $this->_visible->ViewValue = $this->_visible->CurrentValue;
        $this->_visible->ViewValue = FormatNumber($this->_visible->ViewValue, $this->_visible->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // operator_admin
        $this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;
        $this->operator_admin->ViewValue = FormatNumber($this->operator_admin->ViewValue, $this->operator_admin->formatPattern());

        // datetime_admin
        $this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
        $this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, $this->datetime_admin->formatPattern());

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, $this->company_id->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // description
        $this->description->HrefValue = "";
        $this->description->TooltipValue = "";

        // subject
        $this->subject->HrefValue = "";
        $this->subject->TooltipValue = "";

        // status_email_user
        $this->status_email_user->HrefValue = "";
        $this->status_email_user->TooltipValue = "";

        // email_template_user
        $this->email_template_user->HrefValue = "";
        $this->email_template_user->TooltipValue = "";

        // mail_to_office
        $this->mail_to_office->HrefValue = "";
        $this->mail_to_office->TooltipValue = "";

        // status_email_office
        $this->status_email_office->HrefValue = "";
        $this->status_email_office->TooltipValue = "";

        // email_template_office
        $this->email_template_office->HrefValue = "";
        $this->email_template_office->TooltipValue = "";

        // code
        $this->code->HrefValue = "";
        $this->code->TooltipValue = "";

        // variables
        $this->variables->HrefValue = "";
        $this->variables->TooltipValue = "";

        // status_sms_user
        $this->status_sms_user->HrefValue = "";
        $this->status_sms_user->TooltipValue = "";

        // sms_template_user
        $this->sms_template_user->HrefValue = "";
        $this->sms_template_user->TooltipValue = "";

        // status_sms_office
        $this->status_sms_office->HrefValue = "";
        $this->status_sms_office->TooltipValue = "";

        // sms_to_office
        $this->sms_to_office->HrefValue = "";
        $this->sms_to_office->TooltipValue = "";

        // sms_template_office
        $this->sms_template_office->HrefValue = "";
        $this->sms_template_office->TooltipValue = "";

        // wa_status_user
        $this->wa_status_user->HrefValue = "";
        $this->wa_status_user->TooltipValue = "";

        // wa_template_user
        $this->wa_template_user->HrefValue = "";
        $this->wa_template_user->TooltipValue = "";

        // wa_status_office
        $this->wa_status_office->HrefValue = "";
        $this->wa_status_office->TooltipValue = "";

        // wa_to_office
        $this->wa_to_office->HrefValue = "";
        $this->wa_to_office->TooltipValue = "";

        // wa_template_office
        $this->wa_template_office->HrefValue = "";
        $this->wa_template_office->TooltipValue = "";

        // wa_id
        $this->wa_id->HrefValue = "";
        $this->wa_id->TooltipValue = "";

        // notification_status_user
        $this->notification_status_user->HrefValue = "";
        $this->notification_status_user->TooltipValue = "";

        // notification_template_user
        $this->notification_template_user->HrefValue = "";
        $this->notification_template_user->TooltipValue = "";

        // notification_status_office
        $this->notification_status_office->HrefValue = "";
        $this->notification_status_office->TooltipValue = "";

        // notification_to_office
        $this->notification_to_office->HrefValue = "";
        $this->notification_to_office->TooltipValue = "";

        // notification_template_office
        $this->notification_template_office->HrefValue = "";
        $this->notification_template_office->TooltipValue = "";

        // cron
        $this->cron->HrefValue = "";
        $this->cron->TooltipValue = "";

        // next_cycle
        $this->next_cycle->HrefValue = "";
        $this->next_cycle->TooltipValue = "";

        // delay
        $this->delay->HrefValue = "";
        $this->delay->TooltipValue = "";

        // delay_method
        $this->delay_method->HrefValue = "";
        $this->delay_method->TooltipValue = "";

        // visible
        $this->_visible->HrefValue = "";
        $this->_visible->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // operator_admin
        $this->operator_admin->HrefValue = "";
        $this->operator_admin->TooltipValue = "";

        // datetime_admin
        $this->datetime_admin->HrefValue = "";
        $this->datetime_admin->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->CurrentValue;
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
        if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
            $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
        }

        // description
        $this->description->setupEditAttributes();
        if (!$this->description->Raw) {
            $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
        }
        $this->description->EditValue = $this->description->CurrentValue;
        $this->description->PlaceHolder = RemoveHtml($this->description->caption());

        // subject
        $this->subject->setupEditAttributes();
        if (!$this->subject->Raw) {
            $this->subject->CurrentValue = HtmlDecode($this->subject->CurrentValue);
        }
        $this->subject->EditValue = $this->subject->CurrentValue;
        $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

        // status_email_user
        $this->status_email_user->setupEditAttributes();
        $this->status_email_user->EditValue = $this->status_email_user->CurrentValue;
        $this->status_email_user->PlaceHolder = RemoveHtml($this->status_email_user->caption());
        if (strval($this->status_email_user->EditValue) != "" && is_numeric($this->status_email_user->EditValue)) {
            $this->status_email_user->EditValue = FormatNumber($this->status_email_user->EditValue, null);
        }

        // email_template_user
        $this->email_template_user->setupEditAttributes();
        $this->email_template_user->EditValue = $this->email_template_user->CurrentValue;
        $this->email_template_user->PlaceHolder = RemoveHtml($this->email_template_user->caption());

        // mail_to_office
        $this->mail_to_office->setupEditAttributes();
        $this->mail_to_office->EditValue = $this->mail_to_office->CurrentValue;
        $this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

        // status_email_office
        $this->status_email_office->setupEditAttributes();
        $this->status_email_office->EditValue = $this->status_email_office->CurrentValue;
        $this->status_email_office->PlaceHolder = RemoveHtml($this->status_email_office->caption());
        if (strval($this->status_email_office->EditValue) != "" && is_numeric($this->status_email_office->EditValue)) {
            $this->status_email_office->EditValue = FormatNumber($this->status_email_office->EditValue, null);
        }

        // email_template_office
        $this->email_template_office->setupEditAttributes();
        $this->email_template_office->EditValue = $this->email_template_office->CurrentValue;
        $this->email_template_office->PlaceHolder = RemoveHtml($this->email_template_office->caption());

        // code
        $this->code->setupEditAttributes();
        $this->code->EditValue = $this->code->CurrentValue;
        $this->code->PlaceHolder = RemoveHtml($this->code->caption());

        // variables
        $this->variables->setupEditAttributes();
        $this->variables->EditValue = $this->variables->CurrentValue;
        $this->variables->PlaceHolder = RemoveHtml($this->variables->caption());

        // status_sms_user
        $this->status_sms_user->setupEditAttributes();
        $this->status_sms_user->EditValue = $this->status_sms_user->CurrentValue;
        $this->status_sms_user->PlaceHolder = RemoveHtml($this->status_sms_user->caption());
        if (strval($this->status_sms_user->EditValue) != "" && is_numeric($this->status_sms_user->EditValue)) {
            $this->status_sms_user->EditValue = FormatNumber($this->status_sms_user->EditValue, null);
        }

        // sms_template_user
        $this->sms_template_user->setupEditAttributes();
        if (!$this->sms_template_user->Raw) {
            $this->sms_template_user->CurrentValue = HtmlDecode($this->sms_template_user->CurrentValue);
        }
        $this->sms_template_user->EditValue = $this->sms_template_user->CurrentValue;
        $this->sms_template_user->PlaceHolder = RemoveHtml($this->sms_template_user->caption());

        // status_sms_office
        $this->status_sms_office->setupEditAttributes();
        $this->status_sms_office->EditValue = $this->status_sms_office->CurrentValue;
        $this->status_sms_office->PlaceHolder = RemoveHtml($this->status_sms_office->caption());
        if (strval($this->status_sms_office->EditValue) != "" && is_numeric($this->status_sms_office->EditValue)) {
            $this->status_sms_office->EditValue = FormatNumber($this->status_sms_office->EditValue, null);
        }

        // sms_to_office
        $this->sms_to_office->setupEditAttributes();
        if (!$this->sms_to_office->Raw) {
            $this->sms_to_office->CurrentValue = HtmlDecode($this->sms_to_office->CurrentValue);
        }
        $this->sms_to_office->EditValue = $this->sms_to_office->CurrentValue;
        $this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

        // sms_template_office
        $this->sms_template_office->setupEditAttributes();
        if (!$this->sms_template_office->Raw) {
            $this->sms_template_office->CurrentValue = HtmlDecode($this->sms_template_office->CurrentValue);
        }
        $this->sms_template_office->EditValue = $this->sms_template_office->CurrentValue;
        $this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

        // wa_status_user
        $this->wa_status_user->setupEditAttributes();
        $this->wa_status_user->EditValue = $this->wa_status_user->CurrentValue;
        $this->wa_status_user->PlaceHolder = RemoveHtml($this->wa_status_user->caption());
        if (strval($this->wa_status_user->EditValue) != "" && is_numeric($this->wa_status_user->EditValue)) {
            $this->wa_status_user->EditValue = FormatNumber($this->wa_status_user->EditValue, null);
        }

        // wa_template_user
        $this->wa_template_user->setupEditAttributes();
        $this->wa_template_user->EditValue = $this->wa_template_user->CurrentValue;
        $this->wa_template_user->PlaceHolder = RemoveHtml($this->wa_template_user->caption());

        // wa_status_office
        $this->wa_status_office->setupEditAttributes();
        $this->wa_status_office->EditValue = $this->wa_status_office->CurrentValue;
        $this->wa_status_office->PlaceHolder = RemoveHtml($this->wa_status_office->caption());
        if (strval($this->wa_status_office->EditValue) != "" && is_numeric($this->wa_status_office->EditValue)) {
            $this->wa_status_office->EditValue = FormatNumber($this->wa_status_office->EditValue, null);
        }

        // wa_to_office
        $this->wa_to_office->setupEditAttributes();
        if (!$this->wa_to_office->Raw) {
            $this->wa_to_office->CurrentValue = HtmlDecode($this->wa_to_office->CurrentValue);
        }
        $this->wa_to_office->EditValue = $this->wa_to_office->CurrentValue;
        $this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

        // wa_template_office
        $this->wa_template_office->setupEditAttributes();
        $this->wa_template_office->EditValue = $this->wa_template_office->CurrentValue;
        $this->wa_template_office->PlaceHolder = RemoveHtml($this->wa_template_office->caption());

        // wa_id
        $this->wa_id->setupEditAttributes();
        $this->wa_id->EditValue = $this->wa_id->CurrentValue;
        $this->wa_id->PlaceHolder = RemoveHtml($this->wa_id->caption());
        if (strval($this->wa_id->EditValue) != "" && is_numeric($this->wa_id->EditValue)) {
            $this->wa_id->EditValue = FormatNumber($this->wa_id->EditValue, null);
        }

        // notification_status_user
        $this->notification_status_user->setupEditAttributes();
        $this->notification_status_user->EditValue = $this->notification_status_user->CurrentValue;
        $this->notification_status_user->PlaceHolder = RemoveHtml($this->notification_status_user->caption());
        if (strval($this->notification_status_user->EditValue) != "" && is_numeric($this->notification_status_user->EditValue)) {
            $this->notification_status_user->EditValue = FormatNumber($this->notification_status_user->EditValue, null);
        }

        // notification_template_user
        $this->notification_template_user->setupEditAttributes();
        if (!$this->notification_template_user->Raw) {
            $this->notification_template_user->CurrentValue = HtmlDecode($this->notification_template_user->CurrentValue);
        }
        $this->notification_template_user->EditValue = $this->notification_template_user->CurrentValue;
        $this->notification_template_user->PlaceHolder = RemoveHtml($this->notification_template_user->caption());

        // notification_status_office
        $this->notification_status_office->setupEditAttributes();
        $this->notification_status_office->EditValue = $this->notification_status_office->CurrentValue;
        $this->notification_status_office->PlaceHolder = RemoveHtml($this->notification_status_office->caption());
        if (strval($this->notification_status_office->EditValue) != "" && is_numeric($this->notification_status_office->EditValue)) {
            $this->notification_status_office->EditValue = FormatNumber($this->notification_status_office->EditValue, null);
        }

        // notification_to_office
        $this->notification_to_office->setupEditAttributes();
        if (!$this->notification_to_office->Raw) {
            $this->notification_to_office->CurrentValue = HtmlDecode($this->notification_to_office->CurrentValue);
        }
        $this->notification_to_office->EditValue = $this->notification_to_office->CurrentValue;
        $this->notification_to_office->PlaceHolder = RemoveHtml($this->notification_to_office->caption());

        // notification_template_office
        $this->notification_template_office->setupEditAttributes();
        if (!$this->notification_template_office->Raw) {
            $this->notification_template_office->CurrentValue = HtmlDecode($this->notification_template_office->CurrentValue);
        }
        $this->notification_template_office->EditValue = $this->notification_template_office->CurrentValue;
        $this->notification_template_office->PlaceHolder = RemoveHtml($this->notification_template_office->caption());

        // cron
        $this->cron->setupEditAttributes();
        $this->cron->EditValue = $this->cron->CurrentValue;
        $this->cron->PlaceHolder = RemoveHtml($this->cron->caption());
        if (strval($this->cron->EditValue) != "" && is_numeric($this->cron->EditValue)) {
            $this->cron->EditValue = FormatNumber($this->cron->EditValue, null);
        }

        // next_cycle
        $this->next_cycle->setupEditAttributes();
        $this->next_cycle->EditValue = FormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern());
        $this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

        // delay
        $this->delay->setupEditAttributes();
        $this->delay->EditValue = $this->delay->CurrentValue;
        $this->delay->PlaceHolder = RemoveHtml($this->delay->caption());
        if (strval($this->delay->EditValue) != "" && is_numeric($this->delay->EditValue)) {
            $this->delay->EditValue = FormatNumber($this->delay->EditValue, null);
        }

        // delay_method
        $this->delay_method->setupEditAttributes();
        $this->delay_method->EditValue = $this->delay_method->CurrentValue;
        $this->delay_method->PlaceHolder = RemoveHtml($this->delay_method->caption());
        if (strval($this->delay_method->EditValue) != "" && is_numeric($this->delay_method->EditValue)) {
            $this->delay_method->EditValue = FormatNumber($this->delay_method->EditValue, null);
        }

        // visible
        $this->_visible->setupEditAttributes();
        $this->_visible->EditValue = $this->_visible->CurrentValue;
        $this->_visible->PlaceHolder = RemoveHtml($this->_visible->caption());
        if (strval($this->_visible->EditValue) != "" && is_numeric($this->_visible->EditValue)) {
            $this->_visible->EditValue = FormatNumber($this->_visible->EditValue, null);
        }

        // operator
        $this->operator->setupEditAttributes();
        $this->operator->EditValue = $this->operator->CurrentValue;
        $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
        if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
            $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
        }

        // datetime
        $this->datetime->setupEditAttributes();
        $this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

        // operator_admin
        $this->operator_admin->setupEditAttributes();
        $this->operator_admin->EditValue = $this->operator_admin->CurrentValue;
        $this->operator_admin->PlaceHolder = RemoveHtml($this->operator_admin->caption());
        if (strval($this->operator_admin->EditValue) != "" && is_numeric($this->operator_admin->EditValue)) {
            $this->operator_admin->EditValue = FormatNumber($this->operator_admin->EditValue, null);
        }

        // datetime_admin
        $this->datetime_admin->setupEditAttributes();
        $this->datetime_admin->EditValue = FormatDateTime($this->datetime_admin->CurrentValue, $this->datetime_admin->formatPattern());
        $this->datetime_admin->PlaceHolder = RemoveHtml($this->datetime_admin->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        if (strval($this->company_id->EditValue) != "" && is_numeric($this->company_id->EditValue)) {
            $this->company_id->EditValue = FormatNumber($this->company_id->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->subject);
                    $doc->exportCaption($this->status_email_user);
                    $doc->exportCaption($this->email_template_user);
                    $doc->exportCaption($this->mail_to_office);
                    $doc->exportCaption($this->status_email_office);
                    $doc->exportCaption($this->email_template_office);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->variables);
                    $doc->exportCaption($this->status_sms_user);
                    $doc->exportCaption($this->sms_template_user);
                    $doc->exportCaption($this->status_sms_office);
                    $doc->exportCaption($this->sms_to_office);
                    $doc->exportCaption($this->sms_template_office);
                    $doc->exportCaption($this->wa_status_user);
                    $doc->exportCaption($this->wa_template_user);
                    $doc->exportCaption($this->wa_status_office);
                    $doc->exportCaption($this->wa_to_office);
                    $doc->exportCaption($this->wa_template_office);
                    $doc->exportCaption($this->wa_id);
                    $doc->exportCaption($this->notification_status_user);
                    $doc->exportCaption($this->notification_template_user);
                    $doc->exportCaption($this->notification_status_office);
                    $doc->exportCaption($this->notification_to_office);
                    $doc->exportCaption($this->notification_template_office);
                    $doc->exportCaption($this->cron);
                    $doc->exportCaption($this->next_cycle);
                    $doc->exportCaption($this->delay);
                    $doc->exportCaption($this->delay_method);
                    $doc->exportCaption($this->_visible);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->operator_admin);
                    $doc->exportCaption($this->datetime_admin);
                    $doc->exportCaption($this->company_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->subject);
                    $doc->exportCaption($this->status_email_user);
                    $doc->exportCaption($this->status_email_office);
                    $doc->exportCaption($this->status_sms_user);
                    $doc->exportCaption($this->sms_template_user);
                    $doc->exportCaption($this->status_sms_office);
                    $doc->exportCaption($this->sms_to_office);
                    $doc->exportCaption($this->sms_template_office);
                    $doc->exportCaption($this->wa_status_user);
                    $doc->exportCaption($this->wa_status_office);
                    $doc->exportCaption($this->wa_to_office);
                    $doc->exportCaption($this->wa_id);
                    $doc->exportCaption($this->notification_status_user);
                    $doc->exportCaption($this->notification_template_user);
                    $doc->exportCaption($this->notification_status_office);
                    $doc->exportCaption($this->notification_to_office);
                    $doc->exportCaption($this->notification_template_office);
                    $doc->exportCaption($this->cron);
                    $doc->exportCaption($this->next_cycle);
                    $doc->exportCaption($this->delay);
                    $doc->exportCaption($this->delay_method);
                    $doc->exportCaption($this->_visible);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->operator_admin);
                    $doc->exportCaption($this->datetime_admin);
                    $doc->exportCaption($this->company_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->description);
                        $doc->exportField($this->subject);
                        $doc->exportField($this->status_email_user);
                        $doc->exportField($this->email_template_user);
                        $doc->exportField($this->mail_to_office);
                        $doc->exportField($this->status_email_office);
                        $doc->exportField($this->email_template_office);
                        $doc->exportField($this->code);
                        $doc->exportField($this->variables);
                        $doc->exportField($this->status_sms_user);
                        $doc->exportField($this->sms_template_user);
                        $doc->exportField($this->status_sms_office);
                        $doc->exportField($this->sms_to_office);
                        $doc->exportField($this->sms_template_office);
                        $doc->exportField($this->wa_status_user);
                        $doc->exportField($this->wa_template_user);
                        $doc->exportField($this->wa_status_office);
                        $doc->exportField($this->wa_to_office);
                        $doc->exportField($this->wa_template_office);
                        $doc->exportField($this->wa_id);
                        $doc->exportField($this->notification_status_user);
                        $doc->exportField($this->notification_template_user);
                        $doc->exportField($this->notification_status_office);
                        $doc->exportField($this->notification_to_office);
                        $doc->exportField($this->notification_template_office);
                        $doc->exportField($this->cron);
                        $doc->exportField($this->next_cycle);
                        $doc->exportField($this->delay);
                        $doc->exportField($this->delay_method);
                        $doc->exportField($this->_visible);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->operator_admin);
                        $doc->exportField($this->datetime_admin);
                        $doc->exportField($this->company_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->description);
                        $doc->exportField($this->subject);
                        $doc->exportField($this->status_email_user);
                        $doc->exportField($this->status_email_office);
                        $doc->exportField($this->status_sms_user);
                        $doc->exportField($this->sms_template_user);
                        $doc->exportField($this->status_sms_office);
                        $doc->exportField($this->sms_to_office);
                        $doc->exportField($this->sms_template_office);
                        $doc->exportField($this->wa_status_user);
                        $doc->exportField($this->wa_status_office);
                        $doc->exportField($this->wa_to_office);
                        $doc->exportField($this->wa_id);
                        $doc->exportField($this->notification_status_user);
                        $doc->exportField($this->notification_template_user);
                        $doc->exportField($this->notification_status_office);
                        $doc->exportField($this->notification_to_office);
                        $doc->exportField($this->notification_template_office);
                        $doc->exportField($this->cron);
                        $doc->exportField($this->next_cycle);
                        $doc->exportField($this->delay);
                        $doc->exportField($this->delay_method);
                        $doc->exportField($this->_visible);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->operator_admin);
                        $doc->exportField($this->datetime_admin);
                        $doc->exportField($this->company_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
