<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GodownTransferTableSearch extends GodownTransferTable
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GodownTransferTableSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "godowntransfertablesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->product->Visible = false;
        $this->ref->setVisibility();
        $this->rid->setVisibility();
        $this->packets->setVisibility();
        $this->quantity_avg_act->setVisibility();
        $this->quantity->setVisibility();
        $this->packing_type->setVisibility();
        $this->godown->setVisibility();
        $this->dated->setVisibility();
        $this->employee_id->setVisibility();
        $this->next_issue_yn->setVisibility();
        $this->next_process->setVisibility();
        $this->next_godown->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->remarks->setVisibility();
        $this->count_received->Visible = false;
        $this->gp_no->Visible = false;
        $this->po->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'godown_transfer_table';
        $this->TableName = 'godown_transfer_table';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (godown_transfer_table)
        if (!isset($GLOBALS["godown_transfer_table"]) || $GLOBALS["godown_transfer_table"]::class == PROJECT_NAMESPACE . "godown_transfer_table") {
            $GLOBALS["godown_transfer_table"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'godown_transfer_table');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "godowntransfertableview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->quantity_avg_act);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->next_issue_yn);
        $this->setupLookupOptions($this->next_process);
        $this->setupLookupOptions($this->next_godown);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "godowntransfertablelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->rid); // rid
        $this->buildSearchUrl($srchUrl, $this->packets); // packets
        $this->buildSearchUrl($srchUrl, $this->quantity_avg_act); // quantity_avg_act
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->godown); // godown
        $this->buildSearchUrl($srchUrl, $this->dated); // dated
        $this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
        $this->buildSearchUrl($srchUrl, $this->next_issue_yn); // next_issue_yn
        $this->buildSearchUrl($srchUrl, $this->next_process); // next_process
        $this->buildSearchUrl($srchUrl, $this->next_godown); // next_godown
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packets
        if ($this->packets->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity_avg_act
        if ($this->quantity_avg_act->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown
        if ($this->godown->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_id
        if ($this->employee_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // next_issue_yn
        if ($this->next_issue_yn->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // next_process
        if ($this->next_process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // next_godown
        if ($this->next_godown->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // quantity_avg_act
        $this->quantity_avg_act->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // next_issue_yn
        $this->next_issue_yn->RowCssClass = "row";

        // next_process
        $this->next_process->RowCssClass = "row";

        // next_godown
        $this->next_godown->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // count_received
        $this->count_received->RowCssClass = "row";

        // gp_no
        $this->gp_no->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            if (strval($this->grp->CurrentValue) != "") {
                $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
            } else {
                $this->grp->ViewValue = null;
            }

            // product
            $this->product->ViewValue = $this->product->CurrentValue;

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;

            // quantity_avg_act
            if (strval($this->quantity_avg_act->CurrentValue) != "") {
                $this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
            } else {
                $this->quantity_avg_act->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // employee_id
            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;

            // next_issue_yn
            if (strval($this->next_issue_yn->CurrentValue) != "") {
                $this->next_issue_yn->ViewValue = $this->next_issue_yn->optionCaption($this->next_issue_yn->CurrentValue);
            } else {
                $this->next_issue_yn->ViewValue = null;
            }

            // next_process
            $curVal = strval($this->next_process->CurrentValue);
            if ($curVal != "") {
                $this->next_process->ViewValue = $this->next_process->lookupCacheOption($curVal);
                if ($this->next_process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->next_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->next_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->next_process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->next_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->next_process->Lookup->renderViewRow($rswrk[0]);
                        $this->next_process->ViewValue = $this->next_process->displayValue($arwrk);
                    } else {
                        $this->next_process->ViewValue = FormatNumber($this->next_process->CurrentValue, $this->next_process->formatPattern());
                    }
                }
            } else {
                $this->next_process->ViewValue = null;
            }

            // next_godown
            $curVal = strval($this->next_godown->CurrentValue);
            if ($curVal != "") {
                $this->next_godown->ViewValue = $this->next_godown->lookupCacheOption($curVal);
                if ($this->next_godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->next_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->next_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->next_godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->next_godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->next_godown->Lookup->renderViewRow($rswrk[0]);
                        $this->next_godown->ViewValue = $this->next_godown->displayValue($arwrk);
                    } else {
                        $this->next_godown->ViewValue = FormatNumber($this->next_godown->CurrentValue, $this->next_godown->formatPattern());
                    }
                }
            } else {
                $this->next_godown->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // ref
            if (!EmptyValue($this->ref->CurrentValue)) {
                $this->ref->HrefValue = $this->ref->getLinkPrefix() . $this->ref->CurrentValue; // Add prefix/suffix
                $this->ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
                }
            } else {
                $this->ref->HrefValue = "";
            }
            $this->ref->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // quantity_avg_act
            $this->quantity_avg_act->HrefValue = "";
            $this->quantity_avg_act->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }
            $this->packing_type->TooltipValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // employee_id
            if (!EmptyValue($this->employee_id->CurrentValue)) {
                $this->employee_id->HrefValue = $this->employee_id->getLinkPrefix() . $this->employee_id->CurrentValue; // Add prefix/suffix
                $this->employee_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
                }
            } else {
                $this->employee_id->HrefValue = "";
            }
            $this->employee_id->TooltipValue = "";

            // next_issue_yn
            $this->next_issue_yn->HrefValue = "";
            $this->next_issue_yn->TooltipValue = "";

            // next_process
            if (!EmptyValue($this->next_process->CurrentValue)) {
                $this->next_process->HrefValue = $this->next_process->getLinkPrefix() . $this->next_process->CurrentValue; // Add prefix/suffix
                $this->next_process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->next_process->HrefValue = FullUrl($this->next_process->HrefValue, "href");
                }
            } else {
                $this->next_process->HrefValue = "";
            }
            $this->next_process->TooltipValue = "";

            // next_godown
            if (!EmptyValue($this->next_godown->CurrentValue)) {
                $this->next_godown->HrefValue = $this->next_godown->getLinkPrefix() . $this->next_godown->CurrentValue; // Add prefix/suffix
                $this->next_godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->next_godown->HrefValue = FullUrl($this->next_godown->HrefValue, "href");
                }
            } else {
                $this->next_godown->HrefValue = "";
            }
            $this->next_godown->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->options(true);
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // ref
            $this->ref->setupEditAttributes();
            $this->ref->EditValue = $this->ref->AdvancedSearch->SearchValue;
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->AdvancedSearch->SearchValue;
            $curVal = strval($this->rid->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->AdvancedSearch->SearchValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

            // quantity_avg_act
            $this->quantity_avg_act->EditValue = $this->quantity_avg_act->options(false);
            $this->quantity_avg_act->PlaceHolder = RemoveHtml($this->quantity_avg_act->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->AdvancedSearch->SearchValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // employee_id
            $this->employee_id->setupEditAttributes();
            if (!$this->employee_id->Raw) {
                $this->employee_id->AdvancedSearch->SearchValue = HtmlDecode($this->employee_id->AdvancedSearch->SearchValue);
            }
            $this->employee_id->EditValue = HtmlEncode($this->employee_id->AdvancedSearch->SearchValue);
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // next_issue_yn
            $this->next_issue_yn->EditValue = $this->next_issue_yn->options(false);
            $this->next_issue_yn->PlaceHolder = RemoveHtml($this->next_issue_yn->caption());

            // next_process
            $curVal = trim(strval($this->next_process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->next_process->AdvancedSearch->ViewValue = $this->next_process->lookupCacheOption($curVal);
            } else {
                $this->next_process->AdvancedSearch->ViewValue = $this->next_process->Lookup !== null && is_array($this->next_process->lookupOptions()) && count($this->next_process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->next_process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->next_process->EditValue = array_values($this->next_process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->next_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->next_process->AdvancedSearch->SearchValue, $this->next_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->next_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->next_process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->next_process->EditValue = $arwrk;
            }
            $this->next_process->PlaceHolder = RemoveHtml($this->next_process->caption());

            // next_godown
            $this->next_godown->setupEditAttributes();
            $curVal = trim(strval($this->next_godown->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->next_godown->AdvancedSearch->ViewValue = $this->next_godown->lookupCacheOption($curVal);
            } else {
                $this->next_godown->AdvancedSearch->ViewValue = $this->next_godown->Lookup !== null && is_array($this->next_godown->lookupOptions()) && count($this->next_godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->next_godown->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->next_godown->EditValue = array_values($this->next_godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->next_godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->next_godown->AdvancedSearch->SearchValue, $this->next_godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->next_godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->next_godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->next_godown->EditValue = $arwrk;
            }
            $this->next_godown->PlaceHolder = RemoveHtml($this->next_godown->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $curVal = strval($this->operator->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->EditValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->operator->EditValue = null;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->ref->AdvancedSearch->SearchValue)) {
            $this->ref->addErrorMessage($this->ref->getErrorMessage(false));
        }
        if (!CheckInteger($this->rid->AdvancedSearch->SearchValue)) {
            $this->rid->addErrorMessage($this->rid->getErrorMessage(false));
        }
        if (!CheckNumber($this->packets->AdvancedSearch->SearchValue)) {
            $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
        }
        if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckDate($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern())) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->quantity_avg_act->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->godown->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->employee_id->AdvancedSearch->load();
        $this->next_issue_yn->AdvancedSearch->load();
        $this->next_process->AdvancedSearch->load();
        $this->next_godown->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("godowntransfertablelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    break;
                case "x_rid":
                    break;
                case "x_quantity_avg_act":
                    break;
                case "x_packing_type":
                    break;
                case "x_godown":
                    break;
                case "x_next_issue_yn":
                    break;
                case "x_next_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_next_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
