<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GodownTransferNewAdd extends GodownTransferNew
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GodownTransferNewAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "godowntransfernewadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->gp_no->setVisibility();
        $this->_from->setVisibility();
        $this->to->setVisibility();
        $this->attention->setVisibility();
        $this->transfer_nature->setVisibility();
        $this->due_date->setVisibility();
        $this->group->setVisibility();
        $this->item->setVisibility();
        $this->quantity->setVisibility();
        $this->despatchdetails->setVisibility();
        $this->sender_comments->setVisibility();
        $this->t_mode->setVisibility();
        $this->t_distance->setVisibility();
        $this->t_v_no->setVisibility();
        $this->purpose->setVisibility();
        $this->user_id->setVisibility();
        $this->datetime->setVisibility();
        $this->e_user_id->setVisibility();
        $this->e_datetime->setVisibility();
        $this->receiving_condition->setVisibility();
        $this->receiver_comments->setVisibility();
        $this->r_user_id->setVisibility();
        $this->r_datetime->setVisibility();
        $this->updated->setVisibility();
        $this->r_e_user_id->setVisibility();
        $this->r_e_datetime->setVisibility();
        $this->_print->Visible = false;
        $this->jc_no->setVisibility();
        $this->product->setVisibility();
        $this->count_received->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'godown_transfer_new';
        $this->TableName = 'godown_transfer_new';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (godown_transfer_new)
        if (!isset($GLOBALS["godown_transfer_new"]) || $GLOBALS["godown_transfer_new"]::class == PROJECT_NAMESPACE . "godown_transfer_new") {
            $GLOBALS["godown_transfer_new"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'godown_transfer_new');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "godowntransfernewview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->_from);
        $this->setupLookupOptions($this->to);
        $this->setupLookupOptions($this->attention);
        $this->setupLookupOptions($this->transfer_nature);
        $this->setupLookupOptions($this->group);
        $this->setupLookupOptions($this->t_mode);
        $this->setupLookupOptions($this->purpose);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else { // Not post back
            $this->CopyRecord = false;
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("godowntransfernewlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "godowntransfernewlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "godowntransfernewview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "godowntransfernewlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "godowntransfernewlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->_from->DefaultValue = $this->_from->getDefault(); // PHP
        $this->_from->OldValue = $this->_from->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
        $this->_print->DefaultValue = $this->_print->getDefault(); // PHP
        $this->_print->OldValue = $this->_print->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'gp_no' first before field var 'x_gp_no'
        $val = $CurrentForm->hasValue("gp_no") ? $CurrentForm->getValue("gp_no") : $CurrentForm->getValue("x_gp_no");
        if (!$this->gp_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gp_no->Visible = false; // Disable update for API request
            } else {
                $this->gp_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'from' first before field var 'x__from'
        $val = $CurrentForm->hasValue("from") ? $CurrentForm->getValue("from") : $CurrentForm->getValue("x__from");
        if (!$this->_from->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_from->Visible = false; // Disable update for API request
            } else {
                $this->_from->setFormValue($val);
            }
        }

        // Check field name 'to' first before field var 'x_to'
        $val = $CurrentForm->hasValue("to") ? $CurrentForm->getValue("to") : $CurrentForm->getValue("x_to");
        if (!$this->to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->to->Visible = false; // Disable update for API request
            } else {
                $this->to->setFormValue($val);
            }
        }

        // Check field name 'attention' first before field var 'x_attention'
        $val = $CurrentForm->hasValue("attention") ? $CurrentForm->getValue("attention") : $CurrentForm->getValue("x_attention");
        if (!$this->attention->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->attention->Visible = false; // Disable update for API request
            } else {
                $this->attention->setFormValue($val);
            }
        }

        // Check field name 'transfer_nature' first before field var 'x_transfer_nature'
        $val = $CurrentForm->hasValue("transfer_nature") ? $CurrentForm->getValue("transfer_nature") : $CurrentForm->getValue("x_transfer_nature");
        if (!$this->transfer_nature->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transfer_nature->Visible = false; // Disable update for API request
            } else {
                $this->transfer_nature->setFormValue($val);
            }
        }

        // Check field name 'due_date' first before field var 'x_due_date'
        $val = $CurrentForm->hasValue("due_date") ? $CurrentForm->getValue("due_date") : $CurrentForm->getValue("x_due_date");
        if (!$this->due_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->due_date->Visible = false; // Disable update for API request
            } else {
                $this->due_date->setFormValue($val, true, $validate);
            }
            $this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        }

        // Check field name 'group' first before field var 'x_group'
        $val = $CurrentForm->hasValue("group") ? $CurrentForm->getValue("group") : $CurrentForm->getValue("x_group");
        if (!$this->group->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->group->Visible = false; // Disable update for API request
            } else {
                $this->group->setFormValue($val);
            }
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'despatch details' first before field var 'x_despatchdetails'
        $val = $CurrentForm->hasValue("despatch details") ? $CurrentForm->getValue("despatch details") : $CurrentForm->getValue("x_despatchdetails");
        if (!$this->despatchdetails->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatchdetails->Visible = false; // Disable update for API request
            } else {
                $this->despatchdetails->setFormValue($val);
            }
        }

        // Check field name 'sender_comments' first before field var 'x_sender_comments'
        $val = $CurrentForm->hasValue("sender_comments") ? $CurrentForm->getValue("sender_comments") : $CurrentForm->getValue("x_sender_comments");
        if (!$this->sender_comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sender_comments->Visible = false; // Disable update for API request
            } else {
                $this->sender_comments->setFormValue($val);
            }
        }

        // Check field name 't_mode' first before field var 'x_t_mode'
        $val = $CurrentForm->hasValue("t_mode") ? $CurrentForm->getValue("t_mode") : $CurrentForm->getValue("x_t_mode");
        if (!$this->t_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_mode->Visible = false; // Disable update for API request
            } else {
                $this->t_mode->setFormValue($val);
            }
        }

        // Check field name 't_distance' first before field var 'x_t_distance'
        $val = $CurrentForm->hasValue("t_distance") ? $CurrentForm->getValue("t_distance") : $CurrentForm->getValue("x_t_distance");
        if (!$this->t_distance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_distance->Visible = false; // Disable update for API request
            } else {
                $this->t_distance->setFormValue($val, true, $validate);
            }
        }

        // Check field name 't_v_no' first before field var 'x_t_v_no'
        $val = $CurrentForm->hasValue("t_v_no") ? $CurrentForm->getValue("t_v_no") : $CurrentForm->getValue("x_t_v_no");
        if (!$this->t_v_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_v_no->Visible = false; // Disable update for API request
            } else {
                $this->t_v_no->setFormValue($val);
            }
        }

        // Check field name 'purpose' first before field var 'x_purpose'
        $val = $CurrentForm->hasValue("purpose") ? $CurrentForm->getValue("purpose") : $CurrentForm->getValue("x_purpose");
        if (!$this->purpose->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->purpose->Visible = false; // Disable update for API request
            } else {
                $this->purpose->setFormValue($val);
            }
        }

        // Check field name 'user_id' first before field var 'x_user_id'
        $val = $CurrentForm->hasValue("user_id") ? $CurrentForm->getValue("user_id") : $CurrentForm->getValue("x_user_id");
        if (!$this->user_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->user_id->Visible = false; // Disable update for API request
            } else {
                $this->user_id->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'e_user_id' first before field var 'x_e_user_id'
        $val = $CurrentForm->hasValue("e_user_id") ? $CurrentForm->getValue("e_user_id") : $CurrentForm->getValue("x_e_user_id");
        if (!$this->e_user_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->e_user_id->Visible = false; // Disable update for API request
            } else {
                $this->e_user_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'e_datetime' first before field var 'x_e_datetime'
        $val = $CurrentForm->hasValue("e_datetime") ? $CurrentForm->getValue("e_datetime") : $CurrentForm->getValue("x_e_datetime");
        if (!$this->e_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->e_datetime->Visible = false; // Disable update for API request
            } else {
                $this->e_datetime->setFormValue($val, true, $validate);
            }
            $this->e_datetime->CurrentValue = UnFormatDateTime($this->e_datetime->CurrentValue, $this->e_datetime->formatPattern());
        }

        // Check field name 'receiving_condition' first before field var 'x_receiving_condition'
        $val = $CurrentForm->hasValue("receiving_condition") ? $CurrentForm->getValue("receiving_condition") : $CurrentForm->getValue("x_receiving_condition");
        if (!$this->receiving_condition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->receiving_condition->Visible = false; // Disable update for API request
            } else {
                $this->receiving_condition->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'receiver_comments' first before field var 'x_receiver_comments'
        $val = $CurrentForm->hasValue("receiver_comments") ? $CurrentForm->getValue("receiver_comments") : $CurrentForm->getValue("x_receiver_comments");
        if (!$this->receiver_comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->receiver_comments->Visible = false; // Disable update for API request
            } else {
                $this->receiver_comments->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'r_user_id' first before field var 'x_r_user_id'
        $val = $CurrentForm->hasValue("r_user_id") ? $CurrentForm->getValue("r_user_id") : $CurrentForm->getValue("x_r_user_id");
        if (!$this->r_user_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_user_id->Visible = false; // Disable update for API request
            } else {
                $this->r_user_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'r_datetime' first before field var 'x_r_datetime'
        $val = $CurrentForm->hasValue("r_datetime") ? $CurrentForm->getValue("r_datetime") : $CurrentForm->getValue("x_r_datetime");
        if (!$this->r_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_datetime->Visible = false; // Disable update for API request
            } else {
                $this->r_datetime->setFormValue($val, true, $validate);
            }
            $this->r_datetime->CurrentValue = UnFormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern());
        }

        // Check field name 'updated' first before field var 'x_updated'
        $val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
        if (!$this->updated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->updated->Visible = false; // Disable update for API request
            } else {
                $this->updated->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'r_e_user_id' first before field var 'x_r_e_user_id'
        $val = $CurrentForm->hasValue("r_e_user_id") ? $CurrentForm->getValue("r_e_user_id") : $CurrentForm->getValue("x_r_e_user_id");
        if (!$this->r_e_user_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_e_user_id->Visible = false; // Disable update for API request
            } else {
                $this->r_e_user_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'r_e_datetime' first before field var 'x_r_e_datetime'
        $val = $CurrentForm->hasValue("r_e_datetime") ? $CurrentForm->getValue("r_e_datetime") : $CurrentForm->getValue("x_r_e_datetime");
        if (!$this->r_e_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_e_datetime->Visible = false; // Disable update for API request
            } else {
                $this->r_e_datetime->setFormValue($val, true, $validate);
            }
            $this->r_e_datetime->CurrentValue = UnFormatDateTime($this->r_e_datetime->CurrentValue, $this->r_e_datetime->formatPattern());
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'count_received' first before field var 'x_count_received'
        $val = $CurrentForm->hasValue("count_received") ? $CurrentForm->getValue("count_received") : $CurrentForm->getValue("x_count_received");
        if (!$this->count_received->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->count_received->Visible = false; // Disable update for API request
            } else {
                $this->count_received->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->gp_no->CurrentValue = $this->gp_no->FormValue;
        $this->_from->CurrentValue = $this->_from->FormValue;
        $this->to->CurrentValue = $this->to->FormValue;
        $this->attention->CurrentValue = $this->attention->FormValue;
        $this->transfer_nature->CurrentValue = $this->transfer_nature->FormValue;
        $this->due_date->CurrentValue = $this->due_date->FormValue;
        $this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        $this->group->CurrentValue = $this->group->FormValue;
        $this->item->CurrentValue = $this->item->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->despatchdetails->CurrentValue = $this->despatchdetails->FormValue;
        $this->sender_comments->CurrentValue = $this->sender_comments->FormValue;
        $this->t_mode->CurrentValue = $this->t_mode->FormValue;
        $this->t_distance->CurrentValue = $this->t_distance->FormValue;
        $this->t_v_no->CurrentValue = $this->t_v_no->FormValue;
        $this->purpose->CurrentValue = $this->purpose->FormValue;
        $this->user_id->CurrentValue = $this->user_id->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->e_user_id->CurrentValue = $this->e_user_id->FormValue;
        $this->e_datetime->CurrentValue = $this->e_datetime->FormValue;
        $this->e_datetime->CurrentValue = UnFormatDateTime($this->e_datetime->CurrentValue, $this->e_datetime->formatPattern());
        $this->receiving_condition->CurrentValue = $this->receiving_condition->FormValue;
        $this->receiver_comments->CurrentValue = $this->receiver_comments->FormValue;
        $this->r_user_id->CurrentValue = $this->r_user_id->FormValue;
        $this->r_datetime->CurrentValue = $this->r_datetime->FormValue;
        $this->r_datetime->CurrentValue = UnFormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern());
        $this->updated->CurrentValue = $this->updated->FormValue;
        $this->r_e_user_id->CurrentValue = $this->r_e_user_id->FormValue;
        $this->r_e_datetime->CurrentValue = $this->r_e_datetime->FormValue;
        $this->r_e_datetime->CurrentValue = UnFormatDateTime($this->r_e_datetime->CurrentValue, $this->r_e_datetime->formatPattern());
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->count_received->CurrentValue = $this->count_received->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->_from->setDbValue($row['from']);
        $this->to->setDbValue($row['to']);
        $this->attention->setDbValue($row['attention']);
        $this->transfer_nature->setDbValue($row['transfer_nature']);
        $this->due_date->setDbValue($row['due_date']);
        $this->group->setDbValue($row['group']);
        $this->item->setDbValue($row['item']);
        $this->quantity->setDbValue($row['quantity']);
        $this->despatchdetails->setDbValue($row['despatch details']);
        $this->sender_comments->setDbValue($row['sender_comments']);
        $this->t_mode->setDbValue($row['t_mode']);
        $this->t_distance->setDbValue($row['t_distance']);
        $this->t_v_no->setDbValue($row['t_v_no']);
        $this->purpose->setDbValue($row['purpose']);
        $this->user_id->setDbValue($row['user_id']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_user_id->setDbValue($row['e_user_id']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->receiving_condition->setDbValue($row['receiving_condition']);
        $this->receiver_comments->setDbValue($row['receiver_comments']);
        $this->r_user_id->setDbValue($row['r_user_id']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->r_e_user_id->setDbValue($row['r_e_user_id']);
        $this->r_e_datetime->setDbValue($row['r_e_datetime']);
        $this->_print->setDbValue($row['print']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->product->setDbValue($row['product']);
        $this->count_received->setDbValue($row['count_received']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['gp_no'] = $this->gp_no->DefaultValue;
        $row['from'] = $this->_from->DefaultValue;
        $row['to'] = $this->to->DefaultValue;
        $row['attention'] = $this->attention->DefaultValue;
        $row['transfer_nature'] = $this->transfer_nature->DefaultValue;
        $row['due_date'] = $this->due_date->DefaultValue;
        $row['group'] = $this->group->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['despatch details'] = $this->despatchdetails->DefaultValue;
        $row['sender_comments'] = $this->sender_comments->DefaultValue;
        $row['t_mode'] = $this->t_mode->DefaultValue;
        $row['t_distance'] = $this->t_distance->DefaultValue;
        $row['t_v_no'] = $this->t_v_no->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['user_id'] = $this->user_id->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['e_user_id'] = $this->e_user_id->DefaultValue;
        $row['e_datetime'] = $this->e_datetime->DefaultValue;
        $row['receiving_condition'] = $this->receiving_condition->DefaultValue;
        $row['receiver_comments'] = $this->receiver_comments->DefaultValue;
        $row['r_user_id'] = $this->r_user_id->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['r_e_user_id'] = $this->r_e_user_id->DefaultValue;
        $row['r_e_datetime'] = $this->r_e_datetime->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['count_received'] = $this->count_received->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // gp_no
        $this->gp_no->RowCssClass = "row";

        // from
        $this->_from->RowCssClass = "row";

        // to
        $this->to->RowCssClass = "row";

        // attention
        $this->attention->RowCssClass = "row";

        // transfer_nature
        $this->transfer_nature->RowCssClass = "row";

        // due_date
        $this->due_date->RowCssClass = "row";

        // group
        $this->group->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // despatch details
        $this->despatchdetails->RowCssClass = "row";

        // sender_comments
        $this->sender_comments->RowCssClass = "row";

        // t_mode
        $this->t_mode->RowCssClass = "row";

        // t_distance
        $this->t_distance->RowCssClass = "row";

        // t_v_no
        $this->t_v_no->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // user_id
        $this->user_id->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_user_id
        $this->e_user_id->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // receiving_condition
        $this->receiving_condition->RowCssClass = "row";

        // receiver_comments
        $this->receiver_comments->RowCssClass = "row";

        // r_user_id
        $this->r_user_id->RowCssClass = "row";

        // r_datetime
        $this->r_datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // r_e_user_id
        $this->r_e_user_id->RowCssClass = "row";

        // r_e_datetime
        $this->r_e_datetime->RowCssClass = "row";

        // print
        $this->_print->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // count_received
        $this->count_received->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // gp_no
            $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
            $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());

            // from
            $curVal = strval($this->_from->CurrentValue);
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_from->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->ViewValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->ViewValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                    }
                }
            } else {
                $this->_from->ViewValue = null;
            }

            // to
            $curVal = strval($this->to->CurrentValue);
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
                if ($this->to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                        $this->to->ViewValue = $this->to->displayValue($arwrk);
                    } else {
                        $this->to->ViewValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                    }
                }
            } else {
                $this->to->ViewValue = null;
            }

            // attention
            $curVal = strval($this->attention->CurrentValue);
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
                if ($this->attention->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                        $this->attention->ViewValue = $this->attention->displayValue($arwrk);
                    } else {
                        $this->attention->ViewValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                    }
                }
            } else {
                $this->attention->ViewValue = null;
            }

            // transfer_nature
            if (strval($this->transfer_nature->CurrentValue) != "") {
                $this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
            } else {
                $this->transfer_nature->ViewValue = null;
            }

            // due_date
            $this->due_date->ViewValue = $this->due_date->CurrentValue;
            $this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, $this->due_date->formatPattern());

            // group
            if (strval($this->group->CurrentValue) != "") {
                $this->group->ViewValue = $this->group->optionCaption($this->group->CurrentValue);
            } else {
                $this->group->ViewValue = null;
            }

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // despatch details
            $this->despatchdetails->ViewValue = $this->despatchdetails->CurrentValue;

            // sender_comments
            $this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;

            // t_mode
            if (strval($this->t_mode->CurrentValue) != "") {
                $this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
            } else {
                $this->t_mode->ViewValue = null;
            }

            // t_distance
            $this->t_distance->ViewValue = $this->t_distance->CurrentValue;
            $this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, $this->t_distance->formatPattern());

            // t_v_no
            $this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;

            // purpose
            if (strval($this->purpose->CurrentValue) != "") {
                $this->purpose->ViewValue = $this->purpose->optionCaption($this->purpose->CurrentValue);
            } else {
                $this->purpose->ViewValue = null;
            }

            // user_id
            $this->user_id->ViewValue = $this->user_id->CurrentValue;
            $this->user_id->ViewValue = FormatNumber($this->user_id->ViewValue, $this->user_id->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_user_id
            $this->e_user_id->ViewValue = $this->e_user_id->CurrentValue;
            $this->e_user_id->ViewValue = FormatNumber($this->e_user_id->ViewValue, $this->e_user_id->formatPattern());

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // receiving_condition
            $this->receiving_condition->ViewValue = $this->receiving_condition->CurrentValue;
            $this->receiving_condition->ViewValue = FormatNumber($this->receiving_condition->ViewValue, $this->receiving_condition->formatPattern());

            // receiver_comments
            $this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;
            $this->receiver_comments->ViewValue = FormatNumber($this->receiver_comments->ViewValue, $this->receiver_comments->formatPattern());

            // r_user_id
            $this->r_user_id->ViewValue = $this->r_user_id->CurrentValue;
            $this->r_user_id->ViewValue = FormatNumber($this->r_user_id->ViewValue, $this->r_user_id->formatPattern());

            // r_datetime
            $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
            $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // r_e_user_id
            $this->r_e_user_id->ViewValue = $this->r_e_user_id->CurrentValue;
            $this->r_e_user_id->ViewValue = FormatNumber($this->r_e_user_id->ViewValue, $this->r_e_user_id->formatPattern());

            // r_e_datetime
            $this->r_e_datetime->ViewValue = $this->r_e_datetime->CurrentValue;
            $this->r_e_datetime->ViewValue = FormatDateTime($this->r_e_datetime->ViewValue, $this->r_e_datetime->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // product
            $this->product->ViewValue = $this->product->CurrentValue;
            $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

            // count_received
            $this->count_received->ViewValue = $this->count_received->CurrentValue;

            // gp_no
            $this->gp_no->HrefValue = "";

            // from
            $this->_from->HrefValue = "";

            // to
            $this->to->HrefValue = "";

            // attention
            $this->attention->HrefValue = "";

            // transfer_nature
            $this->transfer_nature->HrefValue = "";

            // due_date
            $this->due_date->HrefValue = "";

            // group
            $this->group->HrefValue = "";

            // item
            $this->item->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";

            // t_mode
            $this->t_mode->HrefValue = "";

            // t_distance
            $this->t_distance->HrefValue = "";

            // t_v_no
            $this->t_v_no->HrefValue = "";

            // purpose
            $this->purpose->HrefValue = "";

            // user_id
            $this->user_id->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // e_user_id
            $this->e_user_id->HrefValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";

            // receiving_condition
            $this->receiving_condition->HrefValue = "";

            // receiver_comments
            $this->receiver_comments->HrefValue = "";

            // r_user_id
            $this->r_user_id->HrefValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // r_e_user_id
            $this->r_e_user_id->HrefValue = "";

            // r_e_datetime
            $this->r_e_datetime->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // count_received
            $this->count_received->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // gp_no
            $this->gp_no->setupEditAttributes();
            $this->gp_no->EditValue = $this->gp_no->CurrentValue;
            $this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());
            if (strval($this->gp_no->EditValue) != "" && is_numeric($this->gp_no->EditValue)) {
                $this->gp_no->EditValue = FormatNumber($this->gp_no->EditValue, null);
            }

            // from
            $this->_from->setupEditAttributes();
            $curVal = trim(strval($this->_from->CurrentValue));
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
            } else {
                $this->_from->ViewValue = $this->_from->Lookup !== null && is_array($this->_from->lookupOptions()) && count($this->_from->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_from->ViewValue !== null) { // Load from cache
                $this->_from->EditValue = array_values($this->_from->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->_from->CurrentValue, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->_from->getSelectFilter($this); // PHP
                $sqlWrk = $this->_from->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->_from->EditValue = $arwrk;
            }
            $this->_from->PlaceHolder = RemoveHtml($this->_from->caption());

            // to
            $this->to->setupEditAttributes();
            $curVal = trim(strval($this->to->CurrentValue));
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
            } else {
                $this->to->ViewValue = $this->to->Lookup !== null && is_array($this->to->lookupOptions()) && count($this->to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->to->ViewValue !== null) { // Load from cache
                $this->to->EditValue = array_values($this->to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->to->CurrentValue, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->to->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->to->EditValue = $arwrk;
            }
            $this->to->PlaceHolder = RemoveHtml($this->to->caption());

            // attention
            $this->attention->setupEditAttributes();
            $curVal = trim(strval($this->attention->CurrentValue));
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
            } else {
                $this->attention->ViewValue = $this->attention->Lookup !== null && is_array($this->attention->lookupOptions()) && count($this->attention->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->attention->ViewValue !== null) { // Load from cache
                $this->attention->EditValue = array_values($this->attention->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->attention->CurrentValue, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->attention->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->attention->EditValue = $arwrk;
            }
            $this->attention->PlaceHolder = RemoveHtml($this->attention->caption());

            // transfer_nature
            $this->transfer_nature->setupEditAttributes();
            $this->transfer_nature->EditValue = $this->transfer_nature->options(true);
            $this->transfer_nature->PlaceHolder = RemoveHtml($this->transfer_nature->caption());

            // due_date
            $this->due_date->setupEditAttributes();
            $this->due_date->EditValue = HtmlEncode(FormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern()));
            $this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

            // group
            $this->group->setupEditAttributes();
            $this->group->EditValue = $this->group->options(true);
            $this->group->PlaceHolder = RemoveHtml($this->group->caption());

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->CurrentValue);
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // despatch details
            $this->despatchdetails->setupEditAttributes();
            if (!$this->despatchdetails->Raw) {
                $this->despatchdetails->CurrentValue = HtmlDecode($this->despatchdetails->CurrentValue);
            }
            $this->despatchdetails->EditValue = HtmlEncode($this->despatchdetails->CurrentValue);
            $this->despatchdetails->PlaceHolder = RemoveHtml($this->despatchdetails->caption());

            // sender_comments
            $this->sender_comments->setupEditAttributes();
            if (!$this->sender_comments->Raw) {
                $this->sender_comments->CurrentValue = HtmlDecode($this->sender_comments->CurrentValue);
            }
            $this->sender_comments->EditValue = HtmlEncode($this->sender_comments->CurrentValue);
            $this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

            // t_mode
            $this->t_mode->setupEditAttributes();
            $this->t_mode->EditValue = $this->t_mode->options(true);
            $this->t_mode->PlaceHolder = RemoveHtml($this->t_mode->caption());

            // t_distance
            $this->t_distance->setupEditAttributes();
            $this->t_distance->EditValue = $this->t_distance->CurrentValue;
            $this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());
            if (strval($this->t_distance->EditValue) != "" && is_numeric($this->t_distance->EditValue)) {
                $this->t_distance->EditValue = FormatNumber($this->t_distance->EditValue, null);
            }

            // t_v_no
            $this->t_v_no->setupEditAttributes();
            if (!$this->t_v_no->Raw) {
                $this->t_v_no->CurrentValue = HtmlDecode($this->t_v_no->CurrentValue);
            }
            $this->t_v_no->EditValue = HtmlEncode($this->t_v_no->CurrentValue);
            $this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

            // purpose
            $this->purpose->setupEditAttributes();
            $this->purpose->EditValue = $this->purpose->options(true);
            $this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

            // user_id

            // datetime

            // e_user_id
            $this->e_user_id->setupEditAttributes();
            $this->e_user_id->EditValue = $this->e_user_id->CurrentValue;
            $this->e_user_id->PlaceHolder = RemoveHtml($this->e_user_id->caption());
            if (strval($this->e_user_id->EditValue) != "" && is_numeric($this->e_user_id->EditValue)) {
                $this->e_user_id->EditValue = FormatNumber($this->e_user_id->EditValue, null);
            }

            // e_datetime
            $this->e_datetime->setupEditAttributes();
            $this->e_datetime->EditValue = HtmlEncode(FormatDateTime($this->e_datetime->CurrentValue, $this->e_datetime->formatPattern()));
            $this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

            // receiving_condition
            $this->receiving_condition->setupEditAttributes();
            $this->receiving_condition->EditValue = $this->receiving_condition->CurrentValue;
            $this->receiving_condition->PlaceHolder = RemoveHtml($this->receiving_condition->caption());
            if (strval($this->receiving_condition->EditValue) != "" && is_numeric($this->receiving_condition->EditValue)) {
                $this->receiving_condition->EditValue = FormatNumber($this->receiving_condition->EditValue, null);
            }

            // receiver_comments
            $this->receiver_comments->setupEditAttributes();
            $this->receiver_comments->EditValue = $this->receiver_comments->CurrentValue;
            $this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());
            if (strval($this->receiver_comments->EditValue) != "" && is_numeric($this->receiver_comments->EditValue)) {
                $this->receiver_comments->EditValue = FormatNumber($this->receiver_comments->EditValue, null);
            }

            // r_user_id
            $this->r_user_id->setupEditAttributes();
            $this->r_user_id->EditValue = $this->r_user_id->CurrentValue;
            $this->r_user_id->PlaceHolder = RemoveHtml($this->r_user_id->caption());
            if (strval($this->r_user_id->EditValue) != "" && is_numeric($this->r_user_id->EditValue)) {
                $this->r_user_id->EditValue = FormatNumber($this->r_user_id->EditValue, null);
            }

            // r_datetime
            $this->r_datetime->setupEditAttributes();
            $this->r_datetime->EditValue = HtmlEncode(FormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern()));
            $this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->CurrentValue;
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
            if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
                $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
            }

            // r_e_user_id
            $this->r_e_user_id->setupEditAttributes();
            $this->r_e_user_id->EditValue = $this->r_e_user_id->CurrentValue;
            $this->r_e_user_id->PlaceHolder = RemoveHtml($this->r_e_user_id->caption());
            if (strval($this->r_e_user_id->EditValue) != "" && is_numeric($this->r_e_user_id->EditValue)) {
                $this->r_e_user_id->EditValue = FormatNumber($this->r_e_user_id->EditValue, null);
            }

            // r_e_datetime
            $this->r_e_datetime->setupEditAttributes();
            $this->r_e_datetime->EditValue = HtmlEncode(FormatDateTime($this->r_e_datetime->CurrentValue, $this->r_e_datetime->formatPattern()));
            $this->r_e_datetime->PlaceHolder = RemoveHtml($this->r_e_datetime->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->CurrentValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
            if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
                $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
            }

            // product
            $this->product->setupEditAttributes();
            $this->product->EditValue = $this->product->CurrentValue;
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());
            if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
                $this->product->EditValue = FormatNumber($this->product->EditValue, null);
            }

            // count_received
            $this->count_received->setupEditAttributes();
            if (!$this->count_received->Raw) {
                $this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
            }
            $this->count_received->EditValue = HtmlEncode($this->count_received->CurrentValue);
            $this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

            // Add refer script

            // gp_no
            $this->gp_no->HrefValue = "";

            // from
            $this->_from->HrefValue = "";

            // to
            $this->to->HrefValue = "";

            // attention
            $this->attention->HrefValue = "";

            // transfer_nature
            $this->transfer_nature->HrefValue = "";

            // due_date
            $this->due_date->HrefValue = "";

            // group
            $this->group->HrefValue = "";

            // item
            $this->item->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";

            // t_mode
            $this->t_mode->HrefValue = "";

            // t_distance
            $this->t_distance->HrefValue = "";

            // t_v_no
            $this->t_v_no->HrefValue = "";

            // purpose
            $this->purpose->HrefValue = "";

            // user_id
            $this->user_id->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // e_user_id
            $this->e_user_id->HrefValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";

            // receiving_condition
            $this->receiving_condition->HrefValue = "";

            // receiver_comments
            $this->receiver_comments->HrefValue = "";

            // r_user_id
            $this->r_user_id->HrefValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // r_e_user_id
            $this->r_e_user_id->HrefValue = "";

            // r_e_datetime
            $this->r_e_datetime->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // count_received
            $this->count_received->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->gp_no->Visible && $this->gp_no->Required) {
                if (!$this->gp_no->IsDetailKey && EmptyValue($this->gp_no->FormValue)) {
                    $this->gp_no->addErrorMessage(str_replace("%s", $this->gp_no->caption(), $this->gp_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->gp_no->FormValue)) {
                $this->gp_no->addErrorMessage($this->gp_no->getErrorMessage(false));
            }
            if ($this->_from->Visible && $this->_from->Required) {
                if (!$this->_from->IsDetailKey && EmptyValue($this->_from->FormValue)) {
                    $this->_from->addErrorMessage(str_replace("%s", $this->_from->caption(), $this->_from->RequiredErrorMessage));
                }
            }
            if ($this->to->Visible && $this->to->Required) {
                if (!$this->to->IsDetailKey && EmptyValue($this->to->FormValue)) {
                    $this->to->addErrorMessage(str_replace("%s", $this->to->caption(), $this->to->RequiredErrorMessage));
                }
            }
            if ($this->attention->Visible && $this->attention->Required) {
                if (!$this->attention->IsDetailKey && EmptyValue($this->attention->FormValue)) {
                    $this->attention->addErrorMessage(str_replace("%s", $this->attention->caption(), $this->attention->RequiredErrorMessage));
                }
            }
            if ($this->transfer_nature->Visible && $this->transfer_nature->Required) {
                if (!$this->transfer_nature->IsDetailKey && EmptyValue($this->transfer_nature->FormValue)) {
                    $this->transfer_nature->addErrorMessage(str_replace("%s", $this->transfer_nature->caption(), $this->transfer_nature->RequiredErrorMessage));
                }
            }
            if ($this->due_date->Visible && $this->due_date->Required) {
                if (!$this->due_date->IsDetailKey && EmptyValue($this->due_date->FormValue)) {
                    $this->due_date->addErrorMessage(str_replace("%s", $this->due_date->caption(), $this->due_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->due_date->FormValue, $this->due_date->formatPattern())) {
                $this->due_date->addErrorMessage($this->due_date->getErrorMessage(false));
            }
            if ($this->group->Visible && $this->group->Required) {
                if (!$this->group->IsDetailKey && EmptyValue($this->group->FormValue)) {
                    $this->group->addErrorMessage(str_replace("%s", $this->group->caption(), $this->group->RequiredErrorMessage));
                }
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->despatchdetails->Visible && $this->despatchdetails->Required) {
                if (!$this->despatchdetails->IsDetailKey && EmptyValue($this->despatchdetails->FormValue)) {
                    $this->despatchdetails->addErrorMessage(str_replace("%s", $this->despatchdetails->caption(), $this->despatchdetails->RequiredErrorMessage));
                }
            }
            if ($this->sender_comments->Visible && $this->sender_comments->Required) {
                if (!$this->sender_comments->IsDetailKey && EmptyValue($this->sender_comments->FormValue)) {
                    $this->sender_comments->addErrorMessage(str_replace("%s", $this->sender_comments->caption(), $this->sender_comments->RequiredErrorMessage));
                }
            }
            if ($this->t_mode->Visible && $this->t_mode->Required) {
                if (!$this->t_mode->IsDetailKey && EmptyValue($this->t_mode->FormValue)) {
                    $this->t_mode->addErrorMessage(str_replace("%s", $this->t_mode->caption(), $this->t_mode->RequiredErrorMessage));
                }
            }
            if ($this->t_distance->Visible && $this->t_distance->Required) {
                if (!$this->t_distance->IsDetailKey && EmptyValue($this->t_distance->FormValue)) {
                    $this->t_distance->addErrorMessage(str_replace("%s", $this->t_distance->caption(), $this->t_distance->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->t_distance->FormValue)) {
                $this->t_distance->addErrorMessage($this->t_distance->getErrorMessage(false));
            }
            if ($this->t_v_no->Visible && $this->t_v_no->Required) {
                if (!$this->t_v_no->IsDetailKey && EmptyValue($this->t_v_no->FormValue)) {
                    $this->t_v_no->addErrorMessage(str_replace("%s", $this->t_v_no->caption(), $this->t_v_no->RequiredErrorMessage));
                }
            }
            if ($this->purpose->Visible && $this->purpose->Required) {
                if (!$this->purpose->IsDetailKey && EmptyValue($this->purpose->FormValue)) {
                    $this->purpose->addErrorMessage(str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
                }
            }
            if ($this->user_id->Visible && $this->user_id->Required) {
                if (!$this->user_id->IsDetailKey && EmptyValue($this->user_id->FormValue)) {
                    $this->user_id->addErrorMessage(str_replace("%s", $this->user_id->caption(), $this->user_id->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->e_user_id->Visible && $this->e_user_id->Required) {
                if (!$this->e_user_id->IsDetailKey && EmptyValue($this->e_user_id->FormValue)) {
                    $this->e_user_id->addErrorMessage(str_replace("%s", $this->e_user_id->caption(), $this->e_user_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->e_user_id->FormValue)) {
                $this->e_user_id->addErrorMessage($this->e_user_id->getErrorMessage(false));
            }
            if ($this->e_datetime->Visible && $this->e_datetime->Required) {
                if (!$this->e_datetime->IsDetailKey && EmptyValue($this->e_datetime->FormValue)) {
                    $this->e_datetime->addErrorMessage(str_replace("%s", $this->e_datetime->caption(), $this->e_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->e_datetime->FormValue, $this->e_datetime->formatPattern())) {
                $this->e_datetime->addErrorMessage($this->e_datetime->getErrorMessage(false));
            }
            if ($this->receiving_condition->Visible && $this->receiving_condition->Required) {
                if (!$this->receiving_condition->IsDetailKey && EmptyValue($this->receiving_condition->FormValue)) {
                    $this->receiving_condition->addErrorMessage(str_replace("%s", $this->receiving_condition->caption(), $this->receiving_condition->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->receiving_condition->FormValue)) {
                $this->receiving_condition->addErrorMessage($this->receiving_condition->getErrorMessage(false));
            }
            if ($this->receiver_comments->Visible && $this->receiver_comments->Required) {
                if (!$this->receiver_comments->IsDetailKey && EmptyValue($this->receiver_comments->FormValue)) {
                    $this->receiver_comments->addErrorMessage(str_replace("%s", $this->receiver_comments->caption(), $this->receiver_comments->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->receiver_comments->FormValue)) {
                $this->receiver_comments->addErrorMessage($this->receiver_comments->getErrorMessage(false));
            }
            if ($this->r_user_id->Visible && $this->r_user_id->Required) {
                if (!$this->r_user_id->IsDetailKey && EmptyValue($this->r_user_id->FormValue)) {
                    $this->r_user_id->addErrorMessage(str_replace("%s", $this->r_user_id->caption(), $this->r_user_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->r_user_id->FormValue)) {
                $this->r_user_id->addErrorMessage($this->r_user_id->getErrorMessage(false));
            }
            if ($this->r_datetime->Visible && $this->r_datetime->Required) {
                if (!$this->r_datetime->IsDetailKey && EmptyValue($this->r_datetime->FormValue)) {
                    $this->r_datetime->addErrorMessage(str_replace("%s", $this->r_datetime->caption(), $this->r_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->r_datetime->FormValue, $this->r_datetime->formatPattern())) {
                $this->r_datetime->addErrorMessage($this->r_datetime->getErrorMessage(false));
            }
            if ($this->updated->Visible && $this->updated->Required) {
                if (!$this->updated->IsDetailKey && EmptyValue($this->updated->FormValue)) {
                    $this->updated->addErrorMessage(str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->updated->FormValue)) {
                $this->updated->addErrorMessage($this->updated->getErrorMessage(false));
            }
            if ($this->r_e_user_id->Visible && $this->r_e_user_id->Required) {
                if (!$this->r_e_user_id->IsDetailKey && EmptyValue($this->r_e_user_id->FormValue)) {
                    $this->r_e_user_id->addErrorMessage(str_replace("%s", $this->r_e_user_id->caption(), $this->r_e_user_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->r_e_user_id->FormValue)) {
                $this->r_e_user_id->addErrorMessage($this->r_e_user_id->getErrorMessage(false));
            }
            if ($this->r_e_datetime->Visible && $this->r_e_datetime->Required) {
                if (!$this->r_e_datetime->IsDetailKey && EmptyValue($this->r_e_datetime->FormValue)) {
                    $this->r_e_datetime->addErrorMessage(str_replace("%s", $this->r_e_datetime->caption(), $this->r_e_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->r_e_datetime->FormValue, $this->r_e_datetime->formatPattern())) {
                $this->r_e_datetime->addErrorMessage($this->r_e_datetime->getErrorMessage(false));
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_no->FormValue)) {
                $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product->FormValue)) {
                $this->product->addErrorMessage($this->product->getErrorMessage(false));
            }
            if ($this->count_received->Visible && $this->count_received->Required) {
                if (!$this->count_received->IsDetailKey && EmptyValue($this->count_received->FormValue)) {
                    $this->count_received->addErrorMessage(str_replace("%s", $this->count_received->caption(), $this->count_received->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // gp_no
        $this->gp_no->setDbValueDef($rsnew, $this->gp_no->CurrentValue, false);

        // from
        $this->_from->setDbValueDef($rsnew, $this->_from->CurrentValue, false);

        // to
        $this->to->setDbValueDef($rsnew, $this->to->CurrentValue, false);

        // attention
        $this->attention->setDbValueDef($rsnew, $this->attention->CurrentValue, false);

        // transfer_nature
        $this->transfer_nature->setDbValueDef($rsnew, $this->transfer_nature->CurrentValue, false);

        // due_date
        $this->due_date->setDbValueDef($rsnew, UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern()), false);

        // group
        $this->group->setDbValueDef($rsnew, $this->group->CurrentValue, false);

        // item
        $this->item->setDbValueDef($rsnew, $this->item->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // despatch details
        $this->despatchdetails->setDbValueDef($rsnew, $this->despatchdetails->CurrentValue, false);

        // sender_comments
        $this->sender_comments->setDbValueDef($rsnew, $this->sender_comments->CurrentValue, false);

        // t_mode
        $this->t_mode->setDbValueDef($rsnew, $this->t_mode->CurrentValue, false);

        // t_distance
        $this->t_distance->setDbValueDef($rsnew, $this->t_distance->CurrentValue, false);

        // t_v_no
        $this->t_v_no->setDbValueDef($rsnew, $this->t_v_no->CurrentValue, false);

        // purpose
        $this->purpose->setDbValueDef($rsnew, $this->purpose->CurrentValue, false);

        // user_id
        $this->user_id->CurrentValue = $this->user_id->getAutoUpdateValue(); // PHP
        $this->user_id->setDbValueDef($rsnew, $this->user_id->CurrentValue, false);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // e_user_id
        $this->e_user_id->setDbValueDef($rsnew, $this->e_user_id->CurrentValue, false);

        // e_datetime
        $this->e_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->e_datetime->CurrentValue, $this->e_datetime->formatPattern()), false);

        // receiving_condition
        $this->receiving_condition->setDbValueDef($rsnew, $this->receiving_condition->CurrentValue, false);

        // receiver_comments
        $this->receiver_comments->setDbValueDef($rsnew, $this->receiver_comments->CurrentValue, false);

        // r_user_id
        $this->r_user_id->setDbValueDef($rsnew, $this->r_user_id->CurrentValue, false);

        // r_datetime
        $this->r_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern()), false);

        // updated
        $this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, strval($this->updated->CurrentValue) == "");

        // r_e_user_id
        $this->r_e_user_id->setDbValueDef($rsnew, $this->r_e_user_id->CurrentValue, false);

        // r_e_datetime
        $this->r_e_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->r_e_datetime->CurrentValue, $this->r_e_datetime->formatPattern()), false);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // count_received
        $this->count_received->setDbValueDef($rsnew, $this->count_received->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['gp_no'])) { // gp_no
            $this->gp_no->setFormValue($row['gp_no']);
        }
        if (isset($row['from'])) { // from
            $this->_from->setFormValue($row['from']);
        }
        if (isset($row['to'])) { // to
            $this->to->setFormValue($row['to']);
        }
        if (isset($row['attention'])) { // attention
            $this->attention->setFormValue($row['attention']);
        }
        if (isset($row['transfer_nature'])) { // transfer_nature
            $this->transfer_nature->setFormValue($row['transfer_nature']);
        }
        if (isset($row['due_date'])) { // due_date
            $this->due_date->setFormValue($row['due_date']);
        }
        if (isset($row['group'])) { // group
            $this->group->setFormValue($row['group']);
        }
        if (isset($row['item'])) { // item
            $this->item->setFormValue($row['item']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['despatch details'])) { // despatch details
            $this->despatchdetails->setFormValue($row['despatch details']);
        }
        if (isset($row['sender_comments'])) { // sender_comments
            $this->sender_comments->setFormValue($row['sender_comments']);
        }
        if (isset($row['t_mode'])) { // t_mode
            $this->t_mode->setFormValue($row['t_mode']);
        }
        if (isset($row['t_distance'])) { // t_distance
            $this->t_distance->setFormValue($row['t_distance']);
        }
        if (isset($row['t_v_no'])) { // t_v_no
            $this->t_v_no->setFormValue($row['t_v_no']);
        }
        if (isset($row['purpose'])) { // purpose
            $this->purpose->setFormValue($row['purpose']);
        }
        if (isset($row['user_id'])) { // user_id
            $this->user_id->setFormValue($row['user_id']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['e_user_id'])) { // e_user_id
            $this->e_user_id->setFormValue($row['e_user_id']);
        }
        if (isset($row['e_datetime'])) { // e_datetime
            $this->e_datetime->setFormValue($row['e_datetime']);
        }
        if (isset($row['receiving_condition'])) { // receiving_condition
            $this->receiving_condition->setFormValue($row['receiving_condition']);
        }
        if (isset($row['receiver_comments'])) { // receiver_comments
            $this->receiver_comments->setFormValue($row['receiver_comments']);
        }
        if (isset($row['r_user_id'])) { // r_user_id
            $this->r_user_id->setFormValue($row['r_user_id']);
        }
        if (isset($row['r_datetime'])) { // r_datetime
            $this->r_datetime->setFormValue($row['r_datetime']);
        }
        if (isset($row['updated'])) { // updated
            $this->updated->setFormValue($row['updated']);
        }
        if (isset($row['r_e_user_id'])) { // r_e_user_id
            $this->r_e_user_id->setFormValue($row['r_e_user_id']);
        }
        if (isset($row['r_e_datetime'])) { // r_e_datetime
            $this->r_e_datetime->setFormValue($row['r_e_datetime']);
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->setFormValue($row['jc_no']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['count_received'])) { // count_received
            $this->count_received->setFormValue($row['count_received']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("godowntransfernewlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x__from":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_to":
                    break;
                case "x_attention":
                    break;
                case "x_transfer_nature":
                    break;
                case "x_group":
                    break;
                case "x_t_mode":
                    break;
                case "x_purpose":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
