<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for godown_transfer_new
 */
class GodownTransferNew extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $gp_no;
    public $_from;
    public $to;
    public $attention;
    public $transfer_nature;
    public $due_date;
    public $group;
    public $item;
    public $quantity;
    public $despatchdetails;
    public $sender_comments;
    public $t_mode;
    public $t_distance;
    public $t_v_no;
    public $purpose;
    public $user_id;
    public $datetime;
    public $e_user_id;
    public $e_datetime;
    public $receiving_condition;
    public $receiver_comments;
    public $r_user_id;
    public $r_datetime;
    public $updated;
    public $r_e_user_id;
    public $r_e_datetime;
    public $_print;
    public $jc_no;
    public $product;
    public $count_received;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "godown_transfer_new";
        $this->TableName = 'godown_transfer_new';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "godown_transfer_new";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // gp_no
        $this->gp_no = new DbField(
            $this, // Table
            'x_gp_no', // Variable name
            'gp_no', // Name
            '`gp_no`', // Expression
            '`gp_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gp_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gp_no->InputTextType = "text";
        $this->gp_no->Raw = true;
        $this->gp_no->Nullable = false; // NOT NULL field
        $this->gp_no->Required = true; // Required field
        $this->gp_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gp_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gp_no'] = &$this->gp_no;

        // from
        $this->_from = new DbField(
            $this, // Table
            'x__from', // Variable name
            'from', // Name
            '`from`', // Expression
            '`from`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`from`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->_from->addMethod("getSelectFilter", fn() => (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0");
        $this->_from->addMethod("getDefault", fn() => (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"");
        $this->_from->InputTextType = "text";
        $this->_from->Raw = true;
        $this->_from->Nullable = false; // NOT NULL field
        $this->_from->Required = true; // Required field
        $this->_from->setSelectMultiple(false); // Select one
        $this->_from->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->_from->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->_from->Lookup = new Lookup($this->_from, 'godown_table', false, 'id', ["name","code","location",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->_from) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->_from) . "',COALESCE(`location`,''))");
        $this->_from->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_from->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['from'] = &$this->_from;

        // to
        $this->to = new DbField(
            $this, // Table
            'x_to', // Variable name
            'to', // Name
            '`to`', // Expression
            '`to`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->to->InputTextType = "text";
        $this->to->Raw = true;
        $this->to->Nullable = false; // NOT NULL field
        $this->to->Required = true; // Required field
        $this->to->setSelectMultiple(false); // Select one
        $this->to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->to->Lookup = new Lookup($this->to, 'godown_table', false, 'id', ["name","code","location",""], '', '', [], [], [], [], ["incharge"], ["x_attention"], false, '`id` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->to) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->to) . "',COALESCE(`location`,''))");
        $this->to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['to'] = &$this->to;

        // attention
        $this->attention = new DbField(
            $this, // Table
            'x_attention', // Variable name
            'attention', // Name
            '`attention`', // Expression
            '`attention`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`attention`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->attention->InputTextType = "text";
        $this->attention->Raw = true;
        $this->attention->Nullable = false; // NOT NULL field
        $this->attention->Required = true; // Required field
        $this->attention->setSelectMultiple(false); // Select one
        $this->attention->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->attention->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->attention->Lookup = new Lookup($this->attention, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], true, '`id` ASC', '', "`user_name`");
        $this->attention->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->attention->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['attention'] = &$this->attention;

        // transfer_nature
        $this->transfer_nature = new DbField(
            $this, // Table
            'x_transfer_nature', // Variable name
            'transfer_nature', // Name
            '`transfer_nature`', // Expression
            '`transfer_nature`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`transfer_nature`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->transfer_nature->InputTextType = "text";
        $this->transfer_nature->Raw = true;
        $this->transfer_nature->Nullable = false; // NOT NULL field
        $this->transfer_nature->Required = true; // Required field
        $this->transfer_nature->setSelectMultiple(false); // Select one
        $this->transfer_nature->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->transfer_nature->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->transfer_nature->Lookup = new Lookup($this->transfer_nature, 'godown_transfer_new', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->transfer_nature->OptionCount = 3;
        $this->transfer_nature->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->transfer_nature->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['transfer_nature'] = &$this->transfer_nature;

        // due_date
        $this->due_date = new DbField(
            $this, // Table
            'x_due_date', // Variable name
            'due_date', // Name
            '`due_date`', // Expression
            CastDateFieldForLike("`due_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`due_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->due_date->InputTextType = "text";
        $this->due_date->Raw = true;
        $this->due_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->due_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['due_date'] = &$this->due_date;

        // group
        $this->group = new DbField(
            $this, // Table
            'x_group', // Variable name
            'group', // Name
            '`group`', // Expression
            '`group`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`group`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->group->InputTextType = "text";
        $this->group->Raw = true;
        $this->group->Nullable = false; // NOT NULL field
        $this->group->Required = true; // Required field
        $this->group->setSelectMultiple(false); // Select one
        $this->group->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->group->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->group->Lookup = new Lookup($this->group, 'godown_transfer_new', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->group->OptionCount = 2;
        $this->group->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->group->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['group'] = &$this->group;

        // item
        $this->item = new DbField(
            $this, // Table
            'x_item', // Variable name
            'item', // Name
            '`item`', // Expression
            '`item`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`item`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->item->InputTextType = "text";
        $this->item->Nullable = false; // NOT NULL field
        $this->item->Required = true; // Required field
        $this->item->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['item'] = &$this->item;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // despatch details
        $this->despatchdetails = new DbField(
            $this, // Table
            'x_despatchdetails', // Variable name
            'despatch details', // Name
            '`despatch details`', // Expression
            '`despatch details`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatchdetails->InputTextType = "text";
        $this->despatchdetails->Nullable = false; // NOT NULL field
        $this->despatchdetails->Required = true; // Required field
        $this->despatchdetails->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['despatch details'] = &$this->despatchdetails;

        // sender_comments
        $this->sender_comments = new DbField(
            $this, // Table
            'x_sender_comments', // Variable name
            'sender_comments', // Name
            '`sender_comments`', // Expression
            '`sender_comments`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sender_comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sender_comments->InputTextType = "text";
        $this->sender_comments->Nullable = false; // NOT NULL field
        $this->sender_comments->Required = true; // Required field
        $this->sender_comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['sender_comments'] = &$this->sender_comments;

        // t_mode
        $this->t_mode = new DbField(
            $this, // Table
            'x_t_mode', // Variable name
            't_mode', // Name
            '`t_mode`', // Expression
            '`t_mode`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_mode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->t_mode->InputTextType = "text";
        $this->t_mode->Raw = true;
        $this->t_mode->setSelectMultiple(false); // Select one
        $this->t_mode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->t_mode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->t_mode->Lookup = new Lookup($this->t_mode, 'godown_transfer_new', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->t_mode->OptionCount = 2;
        $this->t_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->t_mode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_mode'] = &$this->t_mode;

        // t_distance
        $this->t_distance = new DbField(
            $this, // Table
            'x_t_distance', // Variable name
            't_distance', // Name
            '`t_distance`', // Expression
            '`t_distance`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_distance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_distance->InputTextType = "text";
        $this->t_distance->Raw = true;
        $this->t_distance->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->t_distance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_distance'] = &$this->t_distance;

        // t_v_no
        $this->t_v_no = new DbField(
            $this, // Table
            'x_t_v_no', // Variable name
            't_v_no', // Name
            '`t_v_no`', // Expression
            '`t_v_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_v_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_v_no->InputTextType = "text";
        $this->t_v_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_v_no'] = &$this->t_v_no;

        // purpose
        $this->purpose = new DbField(
            $this, // Table
            'x_purpose', // Variable name
            'purpose', // Name
            '`purpose`', // Expression
            '`purpose`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`purpose`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->purpose->InputTextType = "text";
        $this->purpose->setSelectMultiple(false); // Select one
        $this->purpose->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->purpose->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->purpose->Lookup = new Lookup($this->purpose, 'godown_transfer_new', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->purpose->OptionCount = 1;
        $this->purpose->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['purpose'] = &$this->purpose;

        // user_id
        $this->user_id = new DbField(
            $this, // Table
            'x_user_id', // Variable name
            'user_id', // Name
            '`user_id`', // Expression
            '`user_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`user_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->user_id->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->user_id->InputTextType = "text";
        $this->user_id->Raw = true;
        $this->user_id->Nullable = false; // NOT NULL field
        $this->user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->user_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['user_id'] = &$this->user_id;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // e_user_id
        $this->e_user_id = new DbField(
            $this, // Table
            'x_e_user_id', // Variable name
            'e_user_id', // Name
            '`e_user_id`', // Expression
            '`e_user_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`e_user_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->e_user_id->InputTextType = "text";
        $this->e_user_id->Raw = true;
        $this->e_user_id->Nullable = false; // NOT NULL field
        $this->e_user_id->Required = true; // Required field
        $this->e_user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->e_user_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['e_user_id'] = &$this->e_user_id;

        // e_datetime
        $this->e_datetime = new DbField(
            $this, // Table
            'x_e_datetime', // Variable name
            'e_datetime', // Name
            '`e_datetime`', // Expression
            CastDateFieldForLike("`e_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`e_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->e_datetime->InputTextType = "text";
        $this->e_datetime->Raw = true;
        $this->e_datetime->Nullable = false; // NOT NULL field
        $this->e_datetime->Required = true; // Required field
        $this->e_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->e_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['e_datetime'] = &$this->e_datetime;

        // receiving_condition
        $this->receiving_condition = new DbField(
            $this, // Table
            'x_receiving_condition', // Variable name
            'receiving_condition', // Name
            '`receiving_condition`', // Expression
            '`receiving_condition`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`receiving_condition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->receiving_condition->InputTextType = "text";
        $this->receiving_condition->Raw = true;
        $this->receiving_condition->Nullable = false; // NOT NULL field
        $this->receiving_condition->Required = true; // Required field
        $this->receiving_condition->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->receiving_condition->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['receiving_condition'] = &$this->receiving_condition;

        // receiver_comments
        $this->receiver_comments = new DbField(
            $this, // Table
            'x_receiver_comments', // Variable name
            'receiver_comments', // Name
            '`receiver_comments`', // Expression
            '`receiver_comments`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`receiver_comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->receiver_comments->InputTextType = "text";
        $this->receiver_comments->Raw = true;
        $this->receiver_comments->Nullable = false; // NOT NULL field
        $this->receiver_comments->Required = true; // Required field
        $this->receiver_comments->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->receiver_comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['receiver_comments'] = &$this->receiver_comments;

        // r_user_id
        $this->r_user_id = new DbField(
            $this, // Table
            'x_r_user_id', // Variable name
            'r_user_id', // Name
            '`r_user_id`', // Expression
            '`r_user_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_user_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_user_id->InputTextType = "text";
        $this->r_user_id->Raw = true;
        $this->r_user_id->Nullable = false; // NOT NULL field
        $this->r_user_id->Required = true; // Required field
        $this->r_user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->r_user_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['r_user_id'] = &$this->r_user_id;

        // r_datetime
        $this->r_datetime = new DbField(
            $this, // Table
            'x_r_datetime', // Variable name
            'r_datetime', // Name
            '`r_datetime`', // Expression
            CastDateFieldForLike("`r_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`r_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_datetime->InputTextType = "text";
        $this->r_datetime->Raw = true;
        $this->r_datetime->Nullable = false; // NOT NULL field
        $this->r_datetime->Required = true; // Required field
        $this->r_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->r_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['r_datetime'] = &$this->r_datetime;

        // updated
        $this->updated = new DbField(
            $this, // Table
            'x_updated', // Variable name
            'updated', // Name
            '`updated`', // Expression
            '`updated`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`updated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->updated->addMethod("getDefault", fn() => 0);
        $this->updated->InputTextType = "text";
        $this->updated->Raw = true;
        $this->updated->Nullable = false; // NOT NULL field
        $this->updated->Required = true; // Required field
        $this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->updated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['updated'] = &$this->updated;

        // r_e_user_id
        $this->r_e_user_id = new DbField(
            $this, // Table
            'x_r_e_user_id', // Variable name
            'r_e_user_id', // Name
            '`r_e_user_id`', // Expression
            '`r_e_user_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_e_user_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_e_user_id->InputTextType = "text";
        $this->r_e_user_id->Raw = true;
        $this->r_e_user_id->Nullable = false; // NOT NULL field
        $this->r_e_user_id->Required = true; // Required field
        $this->r_e_user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->r_e_user_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['r_e_user_id'] = &$this->r_e_user_id;

        // r_e_datetime
        $this->r_e_datetime = new DbField(
            $this, // Table
            'x_r_e_datetime', // Variable name
            'r_e_datetime', // Name
            '`r_e_datetime`', // Expression
            CastDateFieldForLike("`r_e_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`r_e_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_e_datetime->InputTextType = "text";
        $this->r_e_datetime->Raw = true;
        $this->r_e_datetime->Nullable = false; // NOT NULL field
        $this->r_e_datetime->Required = true; // Required field
        $this->r_e_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->r_e_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['r_e_datetime'] = &$this->r_e_datetime;

        // print
        $this->_print = new DbField(
            $this, // Table
            'x__print', // Variable name
            'print', // Name
            '`print`', // Expression
            '`print`', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`print`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_print->addMethod("getDefault", fn() => "Print");
        $this->_print->InputTextType = "text";
        $this->_print->Nullable = false; // NOT NULL field
        $this->_print->Required = true; // Required field
        $this->_print->Sortable = false; // Allow sort
        $this->_print->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['print'] = &$this->_print;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->Required = true; // Required field
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Nullable = false; // NOT NULL field
        $this->product->Required = true; // Required field
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product'] = &$this->product;

        // count_received
        $this->count_received = new DbField(
            $this, // Table
            'x_count_received', // Variable name
            'count_received', // Name
            '`count_received`', // Expression
            '`count_received`', // Basic search expression
            200, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`count_received`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->count_received->InputTextType = "text";
        $this->count_received->Nullable = false; // NOT NULL field
        $this->count_received->Required = true; // Required field
        $this->count_received->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['count_received'] = &$this->count_received;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "godown_transfer_new";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->gp_no->DbValue = $row['gp_no'];
        $this->_from->DbValue = $row['from'];
        $this->to->DbValue = $row['to'];
        $this->attention->DbValue = $row['attention'];
        $this->transfer_nature->DbValue = $row['transfer_nature'];
        $this->due_date->DbValue = $row['due_date'];
        $this->group->DbValue = $row['group'];
        $this->item->DbValue = $row['item'];
        $this->quantity->DbValue = $row['quantity'];
        $this->despatchdetails->DbValue = $row['despatch details'];
        $this->sender_comments->DbValue = $row['sender_comments'];
        $this->t_mode->DbValue = $row['t_mode'];
        $this->t_distance->DbValue = $row['t_distance'];
        $this->t_v_no->DbValue = $row['t_v_no'];
        $this->purpose->DbValue = $row['purpose'];
        $this->user_id->DbValue = $row['user_id'];
        $this->datetime->DbValue = $row['datetime'];
        $this->e_user_id->DbValue = $row['e_user_id'];
        $this->e_datetime->DbValue = $row['e_datetime'];
        $this->receiving_condition->DbValue = $row['receiving_condition'];
        $this->receiver_comments->DbValue = $row['receiver_comments'];
        $this->r_user_id->DbValue = $row['r_user_id'];
        $this->r_datetime->DbValue = $row['r_datetime'];
        $this->updated->DbValue = $row['updated'];
        $this->r_e_user_id->DbValue = $row['r_e_user_id'];
        $this->r_e_datetime->DbValue = $row['r_e_datetime'];
        $this->_print->DbValue = $row['print'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->product->DbValue = $row['product'];
        $this->count_received->DbValue = $row['count_received'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("godowntransfernewlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "godowntransfernewview" => $Language->phrase("View"),
            "godowntransfernewedit" => $Language->phrase("Edit"),
            "godowntransfernewadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "godowntransfernewlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "GodownTransferNewView",
            Config("API_ADD_ACTION") => "GodownTransferNewAdd",
            Config("API_EDIT_ACTION") => "GodownTransferNewEdit",
            Config("API_DELETE_ACTION") => "GodownTransferNewDelete",
            Config("API_LIST_ACTION") => "GodownTransferNewList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "godowntransfernewlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("godowntransfernewview", $parm);
        } else {
            $url = $this->keyUrl("godowntransfernewview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "godowntransfernewadd?" . $parm;
        } else {
            $url = "godowntransfernewadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("godowntransfernewedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("godowntransfernewlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("godowntransfernewadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("godowntransfernewlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("godowntransfernewdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->gp_no->setDbValue($row['gp_no']);
        $this->_from->setDbValue($row['from']);
        $this->to->setDbValue($row['to']);
        $this->attention->setDbValue($row['attention']);
        $this->transfer_nature->setDbValue($row['transfer_nature']);
        $this->due_date->setDbValue($row['due_date']);
        $this->group->setDbValue($row['group']);
        $this->item->setDbValue($row['item']);
        $this->quantity->setDbValue($row['quantity']);
        $this->despatchdetails->setDbValue($row['despatch details']);
        $this->sender_comments->setDbValue($row['sender_comments']);
        $this->t_mode->setDbValue($row['t_mode']);
        $this->t_distance->setDbValue($row['t_distance']);
        $this->t_v_no->setDbValue($row['t_v_no']);
        $this->purpose->setDbValue($row['purpose']);
        $this->user_id->setDbValue($row['user_id']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_user_id->setDbValue($row['e_user_id']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->receiving_condition->setDbValue($row['receiving_condition']);
        $this->receiver_comments->setDbValue($row['receiver_comments']);
        $this->r_user_id->setDbValue($row['r_user_id']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->r_e_user_id->setDbValue($row['r_e_user_id']);
        $this->r_e_datetime->setDbValue($row['r_e_datetime']);
        $this->_print->setDbValue($row['print']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->product->setDbValue($row['product']);
        $this->count_received->setDbValue($row['count_received']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "GodownTransferNewList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // gp_no

        // from

        // to

        // attention

        // transfer_nature

        // due_date

        // group

        // item

        // quantity

        // despatch details

        // sender_comments

        // t_mode

        // t_distance

        // t_v_no

        // purpose

        // user_id

        // datetime

        // e_user_id

        // e_datetime

        // receiving_condition

        // receiver_comments

        // r_user_id

        // r_datetime

        // updated

        // r_e_user_id

        // r_e_datetime

        // print
        $this->_print->CellCssStyle = "white-space: nowrap;";

        // jc_no

        // product

        // count_received

        // gp_no
        $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
        $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());

        // from
        $curVal = strval($this->_from->CurrentValue);
        if ($curVal != "") {
            $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
            if ($this->_from->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->_from->getSelectFilter($this); // PHP
                $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                    $this->_from->ViewValue = $this->_from->displayValue($arwrk);
                } else {
                    $this->_from->ViewValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                }
            }
        } else {
            $this->_from->ViewValue = null;
        }

        // to
        $curVal = strval($this->to->CurrentValue);
        if ($curVal != "") {
            $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
            if ($this->to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                    $this->to->ViewValue = $this->to->displayValue($arwrk);
                } else {
                    $this->to->ViewValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                }
            }
        } else {
            $this->to->ViewValue = null;
        }

        // attention
        $curVal = strval($this->attention->CurrentValue);
        if ($curVal != "") {
            $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
            if ($this->attention->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                    $this->attention->ViewValue = $this->attention->displayValue($arwrk);
                } else {
                    $this->attention->ViewValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                }
            }
        } else {
            $this->attention->ViewValue = null;
        }

        // transfer_nature
        if (strval($this->transfer_nature->CurrentValue) != "") {
            $this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
        } else {
            $this->transfer_nature->ViewValue = null;
        }

        // due_date
        $this->due_date->ViewValue = $this->due_date->CurrentValue;
        $this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, $this->due_date->formatPattern());

        // group
        if (strval($this->group->CurrentValue) != "") {
            $this->group->ViewValue = $this->group->optionCaption($this->group->CurrentValue);
        } else {
            $this->group->ViewValue = null;
        }

        // item
        $this->item->ViewValue = $this->item->CurrentValue;

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // despatch details
        $this->despatchdetails->ViewValue = $this->despatchdetails->CurrentValue;

        // sender_comments
        $this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;

        // t_mode
        if (strval($this->t_mode->CurrentValue) != "") {
            $this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
        } else {
            $this->t_mode->ViewValue = null;
        }

        // t_distance
        $this->t_distance->ViewValue = $this->t_distance->CurrentValue;
        $this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, $this->t_distance->formatPattern());

        // t_v_no
        $this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;

        // purpose
        if (strval($this->purpose->CurrentValue) != "") {
            $this->purpose->ViewValue = $this->purpose->optionCaption($this->purpose->CurrentValue);
        } else {
            $this->purpose->ViewValue = null;
        }

        // user_id
        $this->user_id->ViewValue = $this->user_id->CurrentValue;
        $this->user_id->ViewValue = FormatNumber($this->user_id->ViewValue, $this->user_id->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // e_user_id
        $this->e_user_id->ViewValue = $this->e_user_id->CurrentValue;
        $this->e_user_id->ViewValue = FormatNumber($this->e_user_id->ViewValue, $this->e_user_id->formatPattern());

        // e_datetime
        $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
        $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

        // receiving_condition
        $this->receiving_condition->ViewValue = $this->receiving_condition->CurrentValue;
        $this->receiving_condition->ViewValue = FormatNumber($this->receiving_condition->ViewValue, $this->receiving_condition->formatPattern());

        // receiver_comments
        $this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;
        $this->receiver_comments->ViewValue = FormatNumber($this->receiver_comments->ViewValue, $this->receiver_comments->formatPattern());

        // r_user_id
        $this->r_user_id->ViewValue = $this->r_user_id->CurrentValue;
        $this->r_user_id->ViewValue = FormatNumber($this->r_user_id->ViewValue, $this->r_user_id->formatPattern());

        // r_datetime
        $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
        $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

        // updated
        $this->updated->ViewValue = $this->updated->CurrentValue;
        $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

        // r_e_user_id
        $this->r_e_user_id->ViewValue = $this->r_e_user_id->CurrentValue;
        $this->r_e_user_id->ViewValue = FormatNumber($this->r_e_user_id->ViewValue, $this->r_e_user_id->formatPattern());

        // r_e_datetime
        $this->r_e_datetime->ViewValue = $this->r_e_datetime->CurrentValue;
        $this->r_e_datetime->ViewValue = FormatDateTime($this->r_e_datetime->ViewValue, $this->r_e_datetime->formatPattern());

        // print
        $this->_print->ViewValue = $this->_print->CurrentValue;

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // product
        $this->product->ViewValue = $this->product->CurrentValue;
        $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

        // count_received
        $this->count_received->ViewValue = $this->count_received->CurrentValue;

        // gp_no
        $this->gp_no->HrefValue = "";
        $this->gp_no->TooltipValue = "";

        // from
        $this->_from->HrefValue = "";
        $this->_from->TooltipValue = "";

        // to
        $this->to->HrefValue = "";
        $this->to->TooltipValue = "";

        // attention
        $this->attention->HrefValue = "";
        $this->attention->TooltipValue = "";

        // transfer_nature
        $this->transfer_nature->HrefValue = "";
        $this->transfer_nature->TooltipValue = "";

        // due_date
        $this->due_date->HrefValue = "";
        $this->due_date->TooltipValue = "";

        // group
        $this->group->HrefValue = "";
        $this->group->TooltipValue = "";

        // item
        $this->item->HrefValue = "";
        $this->item->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // despatch details
        $this->despatchdetails->HrefValue = "";
        $this->despatchdetails->TooltipValue = "";

        // sender_comments
        $this->sender_comments->HrefValue = "";
        $this->sender_comments->TooltipValue = "";

        // t_mode
        $this->t_mode->HrefValue = "";
        $this->t_mode->TooltipValue = "";

        // t_distance
        $this->t_distance->HrefValue = "";
        $this->t_distance->TooltipValue = "";

        // t_v_no
        $this->t_v_no->HrefValue = "";
        $this->t_v_no->TooltipValue = "";

        // purpose
        $this->purpose->HrefValue = "";
        $this->purpose->TooltipValue = "";

        // user_id
        $this->user_id->HrefValue = "";
        $this->user_id->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // e_user_id
        $this->e_user_id->HrefValue = "";
        $this->e_user_id->TooltipValue = "";

        // e_datetime
        $this->e_datetime->HrefValue = "";
        $this->e_datetime->TooltipValue = "";

        // receiving_condition
        $this->receiving_condition->HrefValue = "";
        $this->receiving_condition->TooltipValue = "";

        // receiver_comments
        $this->receiver_comments->HrefValue = "";
        $this->receiver_comments->TooltipValue = "";

        // r_user_id
        $this->r_user_id->HrefValue = "";
        $this->r_user_id->TooltipValue = "";

        // r_datetime
        $this->r_datetime->HrefValue = "";
        $this->r_datetime->TooltipValue = "";

        // updated
        $this->updated->HrefValue = "";
        $this->updated->TooltipValue = "";

        // r_e_user_id
        $this->r_e_user_id->HrefValue = "";
        $this->r_e_user_id->TooltipValue = "";

        // r_e_datetime
        $this->r_e_datetime->HrefValue = "";
        $this->r_e_datetime->TooltipValue = "";

        // print
        $this->_print->HrefValue = "";
        $this->_print->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // product
        $this->product->HrefValue = "";
        $this->product->TooltipValue = "";

        // count_received
        $this->count_received->HrefValue = "";
        $this->count_received->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // gp_no
        $this->gp_no->setupEditAttributes();
        $this->gp_no->EditValue = $this->gp_no->CurrentValue;
        $this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());
        if (strval($this->gp_no->EditValue) != "" && is_numeric($this->gp_no->EditValue)) {
            $this->gp_no->EditValue = FormatNumber($this->gp_no->EditValue, null);
        }

        // from
        $this->_from->setupEditAttributes();
        $this->_from->PlaceHolder = RemoveHtml($this->_from->caption());

        // to
        $this->to->setupEditAttributes();
        $this->to->PlaceHolder = RemoveHtml($this->to->caption());

        // attention
        $this->attention->setupEditAttributes();
        $this->attention->PlaceHolder = RemoveHtml($this->attention->caption());

        // transfer_nature
        $this->transfer_nature->setupEditAttributes();
        $this->transfer_nature->EditValue = $this->transfer_nature->options(true);
        $this->transfer_nature->PlaceHolder = RemoveHtml($this->transfer_nature->caption());

        // due_date
        $this->due_date->setupEditAttributes();
        $this->due_date->EditValue = FormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        $this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

        // group
        $this->group->setupEditAttributes();
        $this->group->EditValue = $this->group->options(true);
        $this->group->PlaceHolder = RemoveHtml($this->group->caption());

        // item
        $this->item->setupEditAttributes();
        if (!$this->item->Raw) {
            $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
        }
        $this->item->EditValue = $this->item->CurrentValue;
        $this->item->PlaceHolder = RemoveHtml($this->item->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // despatch details
        $this->despatchdetails->setupEditAttributes();
        if (!$this->despatchdetails->Raw) {
            $this->despatchdetails->CurrentValue = HtmlDecode($this->despatchdetails->CurrentValue);
        }
        $this->despatchdetails->EditValue = $this->despatchdetails->CurrentValue;
        $this->despatchdetails->PlaceHolder = RemoveHtml($this->despatchdetails->caption());

        // sender_comments
        $this->sender_comments->setupEditAttributes();
        if (!$this->sender_comments->Raw) {
            $this->sender_comments->CurrentValue = HtmlDecode($this->sender_comments->CurrentValue);
        }
        $this->sender_comments->EditValue = $this->sender_comments->CurrentValue;
        $this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

        // t_mode
        $this->t_mode->setupEditAttributes();
        $this->t_mode->EditValue = $this->t_mode->options(true);
        $this->t_mode->PlaceHolder = RemoveHtml($this->t_mode->caption());

        // t_distance
        $this->t_distance->setupEditAttributes();
        $this->t_distance->EditValue = $this->t_distance->CurrentValue;
        $this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());
        if (strval($this->t_distance->EditValue) != "" && is_numeric($this->t_distance->EditValue)) {
            $this->t_distance->EditValue = FormatNumber($this->t_distance->EditValue, null);
        }

        // t_v_no
        $this->t_v_no->setupEditAttributes();
        if (!$this->t_v_no->Raw) {
            $this->t_v_no->CurrentValue = HtmlDecode($this->t_v_no->CurrentValue);
        }
        $this->t_v_no->EditValue = $this->t_v_no->CurrentValue;
        $this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

        // purpose
        $this->purpose->setupEditAttributes();
        $this->purpose->EditValue = $this->purpose->options(true);
        $this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

        // user_id

        // datetime

        // e_user_id
        $this->e_user_id->setupEditAttributes();
        $this->e_user_id->EditValue = $this->e_user_id->CurrentValue;
        $this->e_user_id->PlaceHolder = RemoveHtml($this->e_user_id->caption());
        if (strval($this->e_user_id->EditValue) != "" && is_numeric($this->e_user_id->EditValue)) {
            $this->e_user_id->EditValue = FormatNumber($this->e_user_id->EditValue, null);
        }

        // e_datetime
        $this->e_datetime->setupEditAttributes();
        $this->e_datetime->EditValue = FormatDateTime($this->e_datetime->CurrentValue, $this->e_datetime->formatPattern());
        $this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

        // receiving_condition
        $this->receiving_condition->setupEditAttributes();
        $this->receiving_condition->EditValue = $this->receiving_condition->CurrentValue;
        $this->receiving_condition->PlaceHolder = RemoveHtml($this->receiving_condition->caption());
        if (strval($this->receiving_condition->EditValue) != "" && is_numeric($this->receiving_condition->EditValue)) {
            $this->receiving_condition->EditValue = FormatNumber($this->receiving_condition->EditValue, null);
        }

        // receiver_comments
        $this->receiver_comments->setupEditAttributes();
        $this->receiver_comments->EditValue = $this->receiver_comments->CurrentValue;
        $this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());
        if (strval($this->receiver_comments->EditValue) != "" && is_numeric($this->receiver_comments->EditValue)) {
            $this->receiver_comments->EditValue = FormatNumber($this->receiver_comments->EditValue, null);
        }

        // r_user_id
        $this->r_user_id->setupEditAttributes();
        $this->r_user_id->EditValue = $this->r_user_id->CurrentValue;
        $this->r_user_id->PlaceHolder = RemoveHtml($this->r_user_id->caption());
        if (strval($this->r_user_id->EditValue) != "" && is_numeric($this->r_user_id->EditValue)) {
            $this->r_user_id->EditValue = FormatNumber($this->r_user_id->EditValue, null);
        }

        // r_datetime
        $this->r_datetime->setupEditAttributes();
        $this->r_datetime->EditValue = FormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern());
        $this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

        // updated
        $this->updated->setupEditAttributes();
        $this->updated->EditValue = $this->updated->CurrentValue;
        $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
        if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
            $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
        }

        // r_e_user_id
        $this->r_e_user_id->setupEditAttributes();
        $this->r_e_user_id->EditValue = $this->r_e_user_id->CurrentValue;
        $this->r_e_user_id->PlaceHolder = RemoveHtml($this->r_e_user_id->caption());
        if (strval($this->r_e_user_id->EditValue) != "" && is_numeric($this->r_e_user_id->EditValue)) {
            $this->r_e_user_id->EditValue = FormatNumber($this->r_e_user_id->EditValue, null);
        }

        // r_e_datetime
        $this->r_e_datetime->setupEditAttributes();
        $this->r_e_datetime->EditValue = FormatDateTime($this->r_e_datetime->CurrentValue, $this->r_e_datetime->formatPattern());
        $this->r_e_datetime->PlaceHolder = RemoveHtml($this->r_e_datetime->caption());

        // print
        $this->_print->setupEditAttributes();
        if (!$this->_print->Raw) {
            $this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
        }
        $this->_print->EditValue = $this->_print->CurrentValue;
        $this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // product
        $this->product->setupEditAttributes();
        $this->product->EditValue = $this->product->CurrentValue;
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());
        if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
            $this->product->EditValue = FormatNumber($this->product->EditValue, null);
        }

        // count_received
        $this->count_received->setupEditAttributes();
        if (!$this->count_received->Raw) {
            $this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
        }
        $this->count_received->EditValue = $this->count_received->CurrentValue;
        $this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->gp_no);
                    $doc->exportCaption($this->_from);
                    $doc->exportCaption($this->to);
                    $doc->exportCaption($this->attention);
                    $doc->exportCaption($this->transfer_nature);
                    $doc->exportCaption($this->due_date);
                    $doc->exportCaption($this->group);
                    $doc->exportCaption($this->item);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->despatchdetails);
                    $doc->exportCaption($this->sender_comments);
                    $doc->exportCaption($this->t_mode);
                    $doc->exportCaption($this->t_distance);
                    $doc->exportCaption($this->t_v_no);
                    $doc->exportCaption($this->purpose);
                    $doc->exportCaption($this->user_id);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->e_user_id);
                    $doc->exportCaption($this->e_datetime);
                    $doc->exportCaption($this->receiving_condition);
                    $doc->exportCaption($this->receiver_comments);
                    $doc->exportCaption($this->r_user_id);
                    $doc->exportCaption($this->r_datetime);
                    $doc->exportCaption($this->updated);
                    $doc->exportCaption($this->r_e_user_id);
                    $doc->exportCaption($this->r_e_datetime);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->count_received);
                } else {
                    $doc->exportCaption($this->gp_no);
                    $doc->exportCaption($this->_from);
                    $doc->exportCaption($this->to);
                    $doc->exportCaption($this->attention);
                    $doc->exportCaption($this->transfer_nature);
                    $doc->exportCaption($this->due_date);
                    $doc->exportCaption($this->group);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->despatchdetails);
                    $doc->exportCaption($this->sender_comments);
                    $doc->exportCaption($this->t_mode);
                    $doc->exportCaption($this->t_distance);
                    $doc->exportCaption($this->t_v_no);
                    $doc->exportCaption($this->purpose);
                    $doc->exportCaption($this->user_id);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->e_user_id);
                    $doc->exportCaption($this->e_datetime);
                    $doc->exportCaption($this->receiving_condition);
                    $doc->exportCaption($this->receiver_comments);
                    $doc->exportCaption($this->r_user_id);
                    $doc->exportCaption($this->r_datetime);
                    $doc->exportCaption($this->updated);
                    $doc->exportCaption($this->r_e_user_id);
                    $doc->exportCaption($this->r_e_datetime);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->count_received);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->gp_no);
                        $doc->exportField($this->_from);
                        $doc->exportField($this->to);
                        $doc->exportField($this->attention);
                        $doc->exportField($this->transfer_nature);
                        $doc->exportField($this->due_date);
                        $doc->exportField($this->group);
                        $doc->exportField($this->item);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->despatchdetails);
                        $doc->exportField($this->sender_comments);
                        $doc->exportField($this->t_mode);
                        $doc->exportField($this->t_distance);
                        $doc->exportField($this->t_v_no);
                        $doc->exportField($this->purpose);
                        $doc->exportField($this->user_id);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->e_user_id);
                        $doc->exportField($this->e_datetime);
                        $doc->exportField($this->receiving_condition);
                        $doc->exportField($this->receiver_comments);
                        $doc->exportField($this->r_user_id);
                        $doc->exportField($this->r_datetime);
                        $doc->exportField($this->updated);
                        $doc->exportField($this->r_e_user_id);
                        $doc->exportField($this->r_e_datetime);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->product);
                        $doc->exportField($this->count_received);
                    } else {
                        $doc->exportField($this->gp_no);
                        $doc->exportField($this->_from);
                        $doc->exportField($this->to);
                        $doc->exportField($this->attention);
                        $doc->exportField($this->transfer_nature);
                        $doc->exportField($this->due_date);
                        $doc->exportField($this->group);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->despatchdetails);
                        $doc->exportField($this->sender_comments);
                        $doc->exportField($this->t_mode);
                        $doc->exportField($this->t_distance);
                        $doc->exportField($this->t_v_no);
                        $doc->exportField($this->purpose);
                        $doc->exportField($this->user_id);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->e_user_id);
                        $doc->exportField($this->e_datetime);
                        $doc->exportField($this->receiving_condition);
                        $doc->exportField($this->receiver_comments);
                        $doc->exportField($this->r_user_id);
                        $doc->exportField($this->r_datetime);
                        $doc->exportField($this->updated);
                        $doc->exportField($this->r_e_user_id);
                        $doc->exportField($this->r_e_datetime);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->product);
                        $doc->exportField($this->count_received);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
