<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GatePassReceivedView extends GatePassReceived
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GatePassReceivedView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "gatepassreceivedview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->gp_no->setVisibility();
        $this->_print->setVisibility();
        $this->_from->setVisibility();
        $this->to->setVisibility();
        $this->attention->setVisibility();
        $this->transfer_nature->setVisibility();
        $this->due_date->setVisibility();
        $this->group->setVisibility();
        $this->product->setVisibility();
        $this->count_received->setVisibility();
        $this->item->setVisibility();
        $this->gt_id->setVisibility();
        $this->quantity->setVisibility();
        $this->despatchdetails->setVisibility();
        $this->sender_comments->setVisibility();
        $this->t_mode->setVisibility();
        $this->t_distance->setVisibility();
        $this->t_v_no->setVisibility();
        $this->purpose->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->setVisibility();
        $this->e_datetime->setVisibility();
        $this->receiving_condition->setVisibility();
        $this->receiver_comments->setVisibility();
        $this->r_operator->setVisibility();
        $this->r_datetime->setVisibility();
        $this->updated->setVisibility();
        $this->r_e_user_id->setVisibility();
        $this->r_e_datetime->setVisibility();
        $this->jc_no->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'gate_pass_received';
        $this->TableName = 'gate_pass_received';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (gate_pass_received)
        if (!isset($GLOBALS["gate_pass_received"]) || $GLOBALS["gate_pass_received"]::class == PROJECT_NAMESPACE . "gate_pass_received") {
            $GLOBALS["gate_pass_received"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("gp_no") ?? Route("gp_no")) !== null) {
            $this->RecKey["gp_no"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass_received');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "gatepassreceivedview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['gp_no'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->gp_no->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->_from);
        $this->setupLookupOptions($this->to);
        $this->setupLookupOptions($this->attention);
        $this->setupLookupOptions($this->transfer_nature);
        $this->setupLookupOptions($this->group);
        $this->setupLookupOptions($this->t_mode);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->receiving_condition);
        $this->setupLookupOptions($this->r_operator);
        $this->setupLookupOptions($this->jc_no);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("gp_no") ?? Route("gp_no")) !== null) {
            $this->gp_no->setQueryStringValue($keyValue);
            $this->RecKey["gp_no"] = $this->gp_no->QueryStringValue;
        } elseif (Post("gp_no") !== null) {
            $this->gp_no->setFormValue(Post("gp_no"));
            $this->RecKey["gp_no"] = $this->gp_no->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->gp_no->setQueryStringValue($keyValue);
            $this->RecKey["gp_no"] = $this->gp_no->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "gatepassreceivedlist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "gatepassreceivedlist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Edit
        $item = &$option->add("edit");
        $editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = $this->EditUrl != "" && $Security->canEdit() && $this->showOptionLink("edit");

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->_print->setDbValue($row['print']);
        $this->_from->setDbValue($row['from']);
        $this->to->setDbValue($row['to']);
        $this->attention->setDbValue($row['attention']);
        $this->transfer_nature->setDbValue($row['transfer_nature']);
        $this->due_date->setDbValue($row['due_date']);
        $this->group->setDbValue($row['group']);
        $this->product->setDbValue($row['product']);
        $this->count_received->setDbValue($row['count_received']);
        $this->item->setDbValue($row['item']);
        $this->gt_id->setDbValue($row['gt_id']);
        $this->quantity->setDbValue($row['quantity']);
        $this->despatchdetails->setDbValue($row['despatch details']);
        $this->sender_comments->setDbValue($row['sender_comments']);
        $this->t_mode->setDbValue($row['t_mode']);
        $this->t_distance->setDbValue($row['t_distance']);
        $this->t_v_no->setDbValue($row['t_v_no']);
        $this->purpose->setDbValue($row['purpose']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_operator->setDbValue($row['e_operator']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->receiving_condition->setDbValue($row['receiving_condition']);
        $this->receiver_comments->setDbValue($row['receiver_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->r_e_user_id->setDbValue($row['r_e_user_id']);
        $this->r_e_datetime->setDbValue($row['r_e_datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['gp_no'] = $this->gp_no->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['from'] = $this->_from->DefaultValue;
        $row['to'] = $this->to->DefaultValue;
        $row['attention'] = $this->attention->DefaultValue;
        $row['transfer_nature'] = $this->transfer_nature->DefaultValue;
        $row['due_date'] = $this->due_date->DefaultValue;
        $row['group'] = $this->group->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['count_received'] = $this->count_received->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['gt_id'] = $this->gt_id->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['despatch details'] = $this->despatchdetails->DefaultValue;
        $row['sender_comments'] = $this->sender_comments->DefaultValue;
        $row['t_mode'] = $this->t_mode->DefaultValue;
        $row['t_distance'] = $this->t_distance->DefaultValue;
        $row['t_v_no'] = $this->t_v_no->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['e_operator'] = $this->e_operator->DefaultValue;
        $row['e_datetime'] = $this->e_datetime->DefaultValue;
        $row['receiving_condition'] = $this->receiving_condition->DefaultValue;
        $row['receiver_comments'] = $this->receiver_comments->DefaultValue;
        $row['r_operator'] = $this->r_operator->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['r_e_user_id'] = $this->r_e_user_id->DefaultValue;
        $row['r_e_datetime'] = $this->r_e_datetime->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // gp_no

        // print

        // from

        // to

        // attention

        // transfer_nature

        // due_date

        // group

        // product

        // count_received

        // item

        // gt_id

        // quantity

        // despatch details

        // sender_comments

        // t_mode

        // t_distance

        // t_v_no

        // purpose

        // operator

        // datetime

        // e_operator

        // e_datetime

        // receiving_condition

        // receiver_comments

        // r_operator

        // r_datetime

        // updated

        // r_e_user_id

        // r_e_datetime

        // jc_no

        // View row
        if ($this->RowType == RowType::VIEW) {
            // gp_no
            $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
            $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());

            // from
            $this->_from->ViewValue = $this->_from->CurrentValue;
            $curVal = strval($this->_from->CurrentValue);
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->ViewValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->ViewValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                    }
                }
            } else {
                $this->_from->ViewValue = null;
            }

            // to
            $curVal = strval($this->to->CurrentValue);
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
                if ($this->to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                        $this->to->ViewValue = $this->to->displayValue($arwrk);
                    } else {
                        $this->to->ViewValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                    }
                }
            } else {
                $this->to->ViewValue = null;
            }

            // attention
            $curVal = strval($this->attention->CurrentValue);
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
                if ($this->attention->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                        $this->attention->ViewValue = $this->attention->displayValue($arwrk);
                    } else {
                        $this->attention->ViewValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                    }
                }
            } else {
                $this->attention->ViewValue = null;
            }

            // transfer_nature
            if (strval($this->transfer_nature->CurrentValue) != "") {
                $this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
            } else {
                $this->transfer_nature->ViewValue = null;
            }

            // due_date
            $this->due_date->ViewValue = $this->due_date->CurrentValue;
            $this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, $this->due_date->formatPattern());

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // despatch details
            $this->despatchdetails->ViewValue = $this->despatchdetails->CurrentValue;

            // sender_comments
            $this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;

            // t_mode
            if (strval($this->t_mode->CurrentValue) != "") {
                $this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
            } else {
                $this->t_mode->ViewValue = null;
            }

            // t_distance
            $this->t_distance->ViewValue = $this->t_distance->CurrentValue;
            $this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, $this->t_distance->formatPattern());

            // t_v_no
            $this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;

            // purpose
            $this->purpose->ViewValue = $this->purpose->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $this->e_operator->ViewValue = $this->e_operator->CurrentValue;
            $this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, $this->e_operator->formatPattern());

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // receiving_condition
            if (strval($this->receiving_condition->CurrentValue) != "") {
                $this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
            } else {
                $this->receiving_condition->ViewValue = null;
            }

            // receiver_comments
            $this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;

            // r_operator
            $curVal = strval($this->r_operator->CurrentValue);
            if ($curVal != "") {
                $this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
                if ($this->r_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->r_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->r_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->r_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->r_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
                    } else {
                        $this->r_operator->ViewValue = FormatNumber($this->r_operator->CurrentValue, $this->r_operator->formatPattern());
                    }
                }
            } else {
                $this->r_operator->ViewValue = null;
            }

            // r_datetime
            $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
            $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // jc_no
            $curVal = strval($this->jc_no->CurrentValue);
            if ($curVal != "") {
                $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
                if ($this->jc_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->jc_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jc_no->Lookup->renderViewRow($rswrk[0]);
                        $this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
                    } else {
                        $this->jc_no->ViewValue = FormatNumber($this->jc_no->CurrentValue, $this->jc_no->formatPattern());
                    }
                }
            } else {
                $this->jc_no->ViewValue = null;
            }

            // gp_no
            $this->gp_no->HrefValue = "";
            $this->gp_no->TooltipValue = "";

            // from
            if (!EmptyValue($this->_from->CurrentValue)) {
                $this->_from->HrefValue = $this->_from->getLinkPrefix() . $this->_from->CurrentValue; // Add prefix/suffix
                $this->_from->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_from->HrefValue = FullUrl($this->_from->HrefValue, "href");
                }
            } else {
                $this->_from->HrefValue = "";
            }
            $this->_from->TooltipValue = "";

            // to
            if (!EmptyValue($this->to->CurrentValue)) {
                $this->to->HrefValue = $this->to->getLinkPrefix() . $this->to->CurrentValue; // Add prefix/suffix
                $this->to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
                }
            } else {
                $this->to->HrefValue = "";
            }
            $this->to->TooltipValue = "";

            // attention
            if (!EmptyValue($this->attention->CurrentValue)) {
                $this->attention->HrefValue = $this->attention->getLinkPrefix() . $this->attention->CurrentValue; // Add prefix/suffix
                $this->attention->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
                }
            } else {
                $this->attention->HrefValue = "";
            }
            $this->attention->TooltipValue = "";

            // transfer_nature
            if (!EmptyValue($this->transfer_nature->CurrentValue)) {
                $this->transfer_nature->HrefValue = $this->transfer_nature->getLinkPrefix() . $this->transfer_nature->CurrentValue; // Add prefix/suffix
                $this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
                }
            } else {
                $this->transfer_nature->HrefValue = "";
            }
            $this->transfer_nature->TooltipValue = "";

            // due_date
            if (!EmptyValue($this->due_date->CurrentValue)) {
                $this->due_date->HrefValue = $this->due_date->getLinkPrefix() . $this->due_date->CurrentValue; // Add prefix/suffix
                $this->due_date->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
                }
            } else {
                $this->due_date->HrefValue = "";
            }
            $this->due_date->TooltipValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }
            $this->item->TooltipValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";
            $this->despatchdetails->TooltipValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";
            $this->sender_comments->TooltipValue = "";

            // t_mode
            if (!EmptyValue($this->t_mode->CurrentValue)) {
                $this->t_mode->HrefValue = $this->t_mode->getLinkPrefix() . $this->t_mode->CurrentValue; // Add prefix/suffix
                $this->t_mode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
                }
            } else {
                $this->t_mode->HrefValue = "";
            }
            $this->t_mode->TooltipValue = "";

            // t_distance
            $this->t_distance->HrefValue = "";
            $this->t_distance->TooltipValue = "";

            // t_v_no
            $this->t_v_no->HrefValue = "";
            $this->t_v_no->TooltipValue = "";

            // purpose
            $this->purpose->HrefValue = "";
            $this->purpose->TooltipValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // e_operator
            $this->e_operator->HrefValue = "";
            $this->e_operator->TooltipValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";
            $this->e_datetime->TooltipValue = "";

            // receiving_condition
            $this->receiving_condition->HrefValue = "";
            $this->receiving_condition->TooltipValue = "";

            // receiver_comments
            $this->receiver_comments->HrefValue = "";
            $this->receiver_comments->TooltipValue = "";

            // r_operator
            $this->r_operator->HrefValue = "";
            $this->r_operator->TooltipValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";
            $this->r_datetime->TooltipValue = "";

            // updated
            $this->updated->HrefValue = "";
            $this->updated->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->attention->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("gatepassreceivedlist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x__from":
                    break;
                case "x_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_attention":
                    break;
                case "x_transfer_nature":
                    break;
                case "x_group":
                    break;
                case "x_t_mode":
                    break;
                case "x_operator":
                    break;
                case "x_receiving_condition":
                    break;
                case "x_r_operator":
                    break;
                case "x_jc_no":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	if($this->receiving_condition->CurrentValue==2)
    		{
    			$this->OtherOptions["action"]->Items["edit"]->Body = "";
    		}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
