<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GatePassReceivedSearch extends GatePassReceived
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GatePassReceivedSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "gatepassreceivedsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->gp_no->setVisibility();
        $this->_print->Visible = false;
        $this->_from->setVisibility();
        $this->to->setVisibility();
        $this->attention->setVisibility();
        $this->transfer_nature->setVisibility();
        $this->due_date->setVisibility();
        $this->group->setVisibility();
        $this->product->setVisibility();
        $this->count_received->setVisibility();
        $this->item->setVisibility();
        $this->gt_id->setVisibility();
        $this->quantity->Visible = false;
        $this->despatchdetails->setVisibility();
        $this->sender_comments->setVisibility();
        $this->t_mode->setVisibility();
        $this->t_distance->setVisibility();
        $this->t_v_no->setVisibility();
        $this->purpose->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->setVisibility();
        $this->e_datetime->setVisibility();
        $this->receiving_condition->setVisibility();
        $this->receiver_comments->setVisibility();
        $this->r_operator->setVisibility();
        $this->r_datetime->setVisibility();
        $this->updated->setVisibility();
        $this->r_e_user_id->setVisibility();
        $this->r_e_datetime->setVisibility();
        $this->jc_no->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'gate_pass_received';
        $this->TableName = 'gate_pass_received';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (gate_pass_received)
        if (!isset($GLOBALS["gate_pass_received"]) || $GLOBALS["gate_pass_received"]::class == PROJECT_NAMESPACE . "gate_pass_received") {
            $GLOBALS["gate_pass_received"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass_received');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "gatepassreceivedview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['gp_no'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->gp_no->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->_from);
        $this->setupLookupOptions($this->to);
        $this->setupLookupOptions($this->attention);
        $this->setupLookupOptions($this->transfer_nature);
        $this->setupLookupOptions($this->group);
        $this->setupLookupOptions($this->t_mode);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->receiving_condition);
        $this->setupLookupOptions($this->r_operator);
        $this->setupLookupOptions($this->jc_no);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "gatepassreceivedlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->gp_no); // gp_no
        $this->buildSearchUrl($srchUrl, $this->_from); // from
        $this->buildSearchUrl($srchUrl, $this->to); // to
        $this->buildSearchUrl($srchUrl, $this->attention); // attention
        $this->buildSearchUrl($srchUrl, $this->transfer_nature); // transfer_nature
        $this->buildSearchUrl($srchUrl, $this->due_date); // due_date
        $this->buildSearchUrl($srchUrl, $this->group); // group
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->count_received); // count_received
        $this->buildSearchUrl($srchUrl, $this->item); // item
        $this->buildSearchUrl($srchUrl, $this->gt_id); // gt_id
        $this->buildSearchUrl($srchUrl, $this->despatchdetails); // despatch details
        $this->buildSearchUrl($srchUrl, $this->sender_comments); // sender_comments
        $this->buildSearchUrl($srchUrl, $this->t_mode); // t_mode
        $this->buildSearchUrl($srchUrl, $this->t_distance); // t_distance
        $this->buildSearchUrl($srchUrl, $this->t_v_no); // t_v_no
        $this->buildSearchUrl($srchUrl, $this->purpose); // purpose
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->e_operator); // e_operator
        $this->buildSearchUrl($srchUrl, $this->e_datetime); // e_datetime
        $this->buildSearchUrl($srchUrl, $this->receiving_condition); // receiving_condition
        $this->buildSearchUrl($srchUrl, $this->receiver_comments); // receiver_comments
        $this->buildSearchUrl($srchUrl, $this->r_operator); // r_operator
        $this->buildSearchUrl($srchUrl, $this->r_datetime); // r_datetime
        $this->buildSearchUrl($srchUrl, $this->updated); // updated
        $this->buildSearchUrl($srchUrl, $this->r_e_user_id); // r_e_user_id
        $this->buildSearchUrl($srchUrl, $this->r_e_datetime); // r_e_datetime
        $this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // gp_no
        if ($this->gp_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // from
        if ($this->_from->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // to
        if ($this->to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // attention
        if ($this->attention->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // transfer_nature
        if ($this->transfer_nature->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // due_date
        if ($this->due_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // group
        if ($this->group->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // count_received
        if ($this->count_received->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // item
        if ($this->item->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gt_id
        if ($this->gt_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch details
        if ($this->despatchdetails->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sender_comments
        if ($this->sender_comments->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_mode
        if ($this->t_mode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_distance
        if ($this->t_distance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_v_no
        if ($this->t_v_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // purpose
        if ($this->purpose->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // e_operator
        if ($this->e_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // e_datetime
        if ($this->e_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // receiving_condition
        if ($this->receiving_condition->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // receiver_comments
        if ($this->receiver_comments->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_operator
        if ($this->r_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_datetime
        if ($this->r_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // updated
        if ($this->updated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_e_user_id
        if ($this->r_e_user_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_e_datetime
        if ($this->r_e_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // gp_no
        $this->gp_no->RowCssClass = "row";

        // print
        $this->_print->RowCssClass = "row";

        // from
        $this->_from->RowCssClass = "row";

        // to
        $this->to->RowCssClass = "row";

        // attention
        $this->attention->RowCssClass = "row";

        // transfer_nature
        $this->transfer_nature->RowCssClass = "row";

        // due_date
        $this->due_date->RowCssClass = "row";

        // group
        $this->group->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // count_received
        $this->count_received->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // gt_id
        $this->gt_id->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // despatch details
        $this->despatchdetails->RowCssClass = "row";

        // sender_comments
        $this->sender_comments->RowCssClass = "row";

        // t_mode
        $this->t_mode->RowCssClass = "row";

        // t_distance
        $this->t_distance->RowCssClass = "row";

        // t_v_no
        $this->t_v_no->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_operator
        $this->e_operator->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // receiving_condition
        $this->receiving_condition->RowCssClass = "row";

        // receiver_comments
        $this->receiver_comments->RowCssClass = "row";

        // r_operator
        $this->r_operator->RowCssClass = "row";

        // r_datetime
        $this->r_datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // r_e_user_id
        $this->r_e_user_id->RowCssClass = "row";

        // r_e_datetime
        $this->r_e_datetime->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // gp_no
            $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
            $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());

            // from
            $this->_from->ViewValue = $this->_from->CurrentValue;
            $curVal = strval($this->_from->CurrentValue);
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->ViewValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->ViewValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                    }
                }
            } else {
                $this->_from->ViewValue = null;
            }

            // to
            $curVal = strval($this->to->CurrentValue);
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
                if ($this->to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                        $this->to->ViewValue = $this->to->displayValue($arwrk);
                    } else {
                        $this->to->ViewValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                    }
                }
            } else {
                $this->to->ViewValue = null;
            }

            // attention
            $curVal = strval($this->attention->CurrentValue);
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
                if ($this->attention->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                        $this->attention->ViewValue = $this->attention->displayValue($arwrk);
                    } else {
                        $this->attention->ViewValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                    }
                }
            } else {
                $this->attention->ViewValue = null;
            }

            // transfer_nature
            if (strval($this->transfer_nature->CurrentValue) != "") {
                $this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
            } else {
                $this->transfer_nature->ViewValue = null;
            }

            // due_date
            $this->due_date->ViewValue = $this->due_date->CurrentValue;
            $this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, $this->due_date->formatPattern());

            // group
            if (strval($this->group->CurrentValue) != "") {
                $this->group->ViewValue = $this->group->optionCaption($this->group->CurrentValue);
            } else {
                $this->group->ViewValue = null;
            }

            // product
            $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

            // count_received
            $this->count_received->ViewValue = $this->count_received->CurrentValue;

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // gt_id
            $this->gt_id->ViewValue = $this->gt_id->CurrentValue;

            // despatch details
            $this->despatchdetails->ViewValue = $this->despatchdetails->CurrentValue;

            // sender_comments
            $this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;

            // t_mode
            if (strval($this->t_mode->CurrentValue) != "") {
                $this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
            } else {
                $this->t_mode->ViewValue = null;
            }

            // t_distance
            $this->t_distance->ViewValue = $this->t_distance->CurrentValue;
            $this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, $this->t_distance->formatPattern());

            // t_v_no
            $this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;

            // purpose
            $this->purpose->ViewValue = $this->purpose->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $this->e_operator->ViewValue = $this->e_operator->CurrentValue;
            $this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, $this->e_operator->formatPattern());

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // receiving_condition
            if (strval($this->receiving_condition->CurrentValue) != "") {
                $this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
            } else {
                $this->receiving_condition->ViewValue = null;
            }

            // receiver_comments
            $this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;

            // r_operator
            $curVal = strval($this->r_operator->CurrentValue);
            if ($curVal != "") {
                $this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
                if ($this->r_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->r_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->r_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->r_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->r_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
                    } else {
                        $this->r_operator->ViewValue = FormatNumber($this->r_operator->CurrentValue, $this->r_operator->formatPattern());
                    }
                }
            } else {
                $this->r_operator->ViewValue = null;
            }

            // r_datetime
            $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
            $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // r_e_user_id
            $this->r_e_user_id->ViewValue = $this->r_e_user_id->CurrentValue;
            $this->r_e_user_id->ViewValue = FormatNumber($this->r_e_user_id->ViewValue, $this->r_e_user_id->formatPattern());

            // r_e_datetime
            $this->r_e_datetime->ViewValue = $this->r_e_datetime->CurrentValue;
            $this->r_e_datetime->ViewValue = FormatDateTime($this->r_e_datetime->ViewValue, $this->r_e_datetime->formatPattern());

            // jc_no
            $curVal = strval($this->jc_no->CurrentValue);
            if ($curVal != "") {
                $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
                if ($this->jc_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->jc_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jc_no->Lookup->renderViewRow($rswrk[0]);
                        $this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
                    } else {
                        $this->jc_no->ViewValue = FormatNumber($this->jc_no->CurrentValue, $this->jc_no->formatPattern());
                    }
                }
            } else {
                $this->jc_no->ViewValue = null;
            }

            // gp_no
            $this->gp_no->HrefValue = "";
            $this->gp_no->TooltipValue = "";

            // from
            if (!EmptyValue($this->_from->CurrentValue)) {
                $this->_from->HrefValue = $this->_from->getLinkPrefix() . $this->_from->CurrentValue; // Add prefix/suffix
                $this->_from->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_from->HrefValue = FullUrl($this->_from->HrefValue, "href");
                }
            } else {
                $this->_from->HrefValue = "";
            }
            $this->_from->TooltipValue = "";

            // to
            if (!EmptyValue($this->to->CurrentValue)) {
                $this->to->HrefValue = $this->to->getLinkPrefix() . $this->to->CurrentValue; // Add prefix/suffix
                $this->to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
                }
            } else {
                $this->to->HrefValue = "";
            }
            $this->to->TooltipValue = "";

            // attention
            if (!EmptyValue($this->attention->CurrentValue)) {
                $this->attention->HrefValue = $this->attention->getLinkPrefix() . $this->attention->CurrentValue; // Add prefix/suffix
                $this->attention->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
                }
            } else {
                $this->attention->HrefValue = "";
            }
            $this->attention->TooltipValue = "";

            // transfer_nature
            if (!EmptyValue($this->transfer_nature->CurrentValue)) {
                $this->transfer_nature->HrefValue = $this->transfer_nature->getLinkPrefix() . $this->transfer_nature->CurrentValue; // Add prefix/suffix
                $this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
                }
            } else {
                $this->transfer_nature->HrefValue = "";
            }
            $this->transfer_nature->TooltipValue = "";

            // due_date
            if (!EmptyValue($this->due_date->CurrentValue)) {
                $this->due_date->HrefValue = $this->due_date->getLinkPrefix() . $this->due_date->CurrentValue; // Add prefix/suffix
                $this->due_date->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
                }
            } else {
                $this->due_date->HrefValue = "";
            }
            $this->due_date->TooltipValue = "";

            // group
            $this->group->HrefValue = "";
            $this->group->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // count_received
            $this->count_received->HrefValue = "";
            $this->count_received->TooltipValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }
            $this->item->TooltipValue = "";

            // gt_id
            $this->gt_id->HrefValue = "";
            $this->gt_id->TooltipValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";
            $this->despatchdetails->TooltipValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";
            $this->sender_comments->TooltipValue = "";

            // t_mode
            if (!EmptyValue($this->t_mode->CurrentValue)) {
                $this->t_mode->HrefValue = $this->t_mode->getLinkPrefix() . $this->t_mode->CurrentValue; // Add prefix/suffix
                $this->t_mode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
                }
            } else {
                $this->t_mode->HrefValue = "";
            }
            $this->t_mode->TooltipValue = "";

            // t_distance
            $this->t_distance->HrefValue = "";
            $this->t_distance->TooltipValue = "";

            // t_v_no
            $this->t_v_no->HrefValue = "";
            $this->t_v_no->TooltipValue = "";

            // purpose
            $this->purpose->HrefValue = "";
            $this->purpose->TooltipValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // e_operator
            $this->e_operator->HrefValue = "";
            $this->e_operator->TooltipValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";
            $this->e_datetime->TooltipValue = "";

            // receiving_condition
            $this->receiving_condition->HrefValue = "";
            $this->receiving_condition->TooltipValue = "";

            // receiver_comments
            $this->receiver_comments->HrefValue = "";
            $this->receiver_comments->TooltipValue = "";

            // r_operator
            $this->r_operator->HrefValue = "";
            $this->r_operator->TooltipValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";
            $this->r_datetime->TooltipValue = "";

            // updated
            $this->updated->HrefValue = "";
            $this->updated->TooltipValue = "";

            // r_e_user_id
            $this->r_e_user_id->HrefValue = "";
            $this->r_e_user_id->TooltipValue = "";

            // r_e_datetime
            $this->r_e_datetime->HrefValue = "";
            $this->r_e_datetime->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // gp_no
            $this->gp_no->setupEditAttributes();
            $this->gp_no->EditValue = $this->gp_no->AdvancedSearch->SearchValue;
            $this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());

            // from
            $this->_from->setupEditAttributes();
            $this->_from->EditValue = $this->_from->AdvancedSearch->SearchValue;
            $curVal = strval($this->_from->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->_from->EditValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->EditValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->EditValue = HtmlEncode(FormatNumber($this->_from->AdvancedSearch->SearchValue, $this->_from->formatPattern()));
                    }
                }
            } else {
                $this->_from->EditValue = null;
            }
            $this->_from->PlaceHolder = RemoveHtml($this->_from->caption());

            // to
            $this->to->setupEditAttributes();
            $curVal = trim(strval($this->to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->to->AdvancedSearch->ViewValue = $this->to->lookupCacheOption($curVal);
            } else {
                $this->to->AdvancedSearch->ViewValue = $this->to->Lookup !== null && is_array($this->to->lookupOptions()) && count($this->to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->to->EditValue = array_values($this->to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->to->AdvancedSearch->SearchValue, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->to->getSelectFilter($this); // PHP
                $sqlWrk = $this->to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->to->EditValue = $arwrk;
            }
            $this->to->PlaceHolder = RemoveHtml($this->to->caption());

            // attention
            $this->attention->setupEditAttributes();
            $curVal = trim(strval($this->attention->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->attention->AdvancedSearch->ViewValue = $this->attention->lookupCacheOption($curVal);
            } else {
                $this->attention->AdvancedSearch->ViewValue = $this->attention->Lookup !== null && is_array($this->attention->lookupOptions()) && count($this->attention->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->attention->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->attention->EditValue = array_values($this->attention->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->attention->AdvancedSearch->SearchValue, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->attention->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->attention->EditValue = $arwrk;
            }
            $this->attention->PlaceHolder = RemoveHtml($this->attention->caption());

            // transfer_nature
            $this->transfer_nature->setupEditAttributes();
            $this->transfer_nature->EditValue = $this->transfer_nature->options(true);
            $this->transfer_nature->PlaceHolder = RemoveHtml($this->transfer_nature->caption());

            // due_date
            $this->due_date->setupEditAttributes();
            $this->due_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->due_date->AdvancedSearch->SearchValue, $this->due_date->formatPattern()), $this->due_date->formatPattern()));
            $this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

            // group
            $this->group->setupEditAttributes();
            $this->group->EditValue = $this->group->options(true);
            $this->group->PlaceHolder = RemoveHtml($this->group->caption());

            // product
            $this->product->setupEditAttributes();
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // count_received
            $this->count_received->setupEditAttributes();
            if (!$this->count_received->Raw) {
                $this->count_received->AdvancedSearch->SearchValue = HtmlDecode($this->count_received->AdvancedSearch->SearchValue);
            }
            $this->count_received->EditValue = HtmlEncode($this->count_received->AdvancedSearch->SearchValue);
            $this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // gt_id
            $this->gt_id->setupEditAttributes();
            if (!$this->gt_id->Raw) {
                $this->gt_id->AdvancedSearch->SearchValue = HtmlDecode($this->gt_id->AdvancedSearch->SearchValue);
            }
            $this->gt_id->EditValue = HtmlEncode($this->gt_id->AdvancedSearch->SearchValue);
            $this->gt_id->PlaceHolder = RemoveHtml($this->gt_id->caption());

            // despatch details
            $this->despatchdetails->setupEditAttributes();
            if (!$this->despatchdetails->Raw) {
                $this->despatchdetails->AdvancedSearch->SearchValue = HtmlDecode($this->despatchdetails->AdvancedSearch->SearchValue);
            }
            $this->despatchdetails->EditValue = HtmlEncode($this->despatchdetails->AdvancedSearch->SearchValue);
            $this->despatchdetails->PlaceHolder = RemoveHtml($this->despatchdetails->caption());

            // sender_comments
            $this->sender_comments->setupEditAttributes();
            if (!$this->sender_comments->Raw) {
                $this->sender_comments->AdvancedSearch->SearchValue = HtmlDecode($this->sender_comments->AdvancedSearch->SearchValue);
            }
            $this->sender_comments->EditValue = HtmlEncode($this->sender_comments->AdvancedSearch->SearchValue);
            $this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

            // t_mode
            $this->t_mode->setupEditAttributes();
            $this->t_mode->EditValue = $this->t_mode->options(true);
            $this->t_mode->PlaceHolder = RemoveHtml($this->t_mode->caption());

            // t_distance
            $this->t_distance->setupEditAttributes();
            $this->t_distance->EditValue = $this->t_distance->AdvancedSearch->SearchValue;
            $this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());

            // t_v_no
            $this->t_v_no->setupEditAttributes();
            if (!$this->t_v_no->Raw) {
                $this->t_v_no->AdvancedSearch->SearchValue = HtmlDecode($this->t_v_no->AdvancedSearch->SearchValue);
            }
            $this->t_v_no->EditValue = HtmlEncode($this->t_v_no->AdvancedSearch->SearchValue);
            $this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

            // purpose
            $this->purpose->setupEditAttributes();
            if (!$this->purpose->Raw) {
                $this->purpose->AdvancedSearch->SearchValue = HtmlDecode($this->purpose->AdvancedSearch->SearchValue);
            }
            $this->purpose->EditValue = HtmlEncode($this->purpose->AdvancedSearch->SearchValue);
            $this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // e_operator
            $this->e_operator->setupEditAttributes();
            $this->e_operator->EditValue = $this->e_operator->AdvancedSearch->SearchValue;
            $this->e_operator->PlaceHolder = RemoveHtml($this->e_operator->caption());

            // e_datetime
            $this->e_datetime->setupEditAttributes();
            $this->e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->e_datetime->AdvancedSearch->SearchValue, $this->e_datetime->formatPattern()), $this->e_datetime->formatPattern()));
            $this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

            // receiving_condition
            $this->receiving_condition->setupEditAttributes();
            $this->receiving_condition->EditValue = $this->receiving_condition->options(true);
            $this->receiving_condition->PlaceHolder = RemoveHtml($this->receiving_condition->caption());

            // receiver_comments
            $this->receiver_comments->setupEditAttributes();
            $this->receiver_comments->EditValue = HtmlEncode($this->receiver_comments->AdvancedSearch->SearchValue);
            $this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());

            // r_operator
            $this->r_operator->setupEditAttributes();
            $curVal = trim(strval($this->r_operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->r_operator->AdvancedSearch->ViewValue = $this->r_operator->lookupCacheOption($curVal);
            } else {
                $this->r_operator->AdvancedSearch->ViewValue = $this->r_operator->Lookup !== null && is_array($this->r_operator->lookupOptions()) && count($this->r_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->r_operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->r_operator->EditValue = array_values($this->r_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->r_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->r_operator->AdvancedSearch->SearchValue, $this->r_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->r_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->r_operator->EditValue = $arwrk;
            }
            $this->r_operator->PlaceHolder = RemoveHtml($this->r_operator->caption());

            // r_datetime
            $this->r_datetime->setupEditAttributes();
            $this->r_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->r_datetime->AdvancedSearch->SearchValue, $this->r_datetime->formatPattern()), $this->r_datetime->formatPattern()));
            $this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->AdvancedSearch->SearchValue;
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

            // r_e_user_id
            $this->r_e_user_id->setupEditAttributes();
            $this->r_e_user_id->EditValue = $this->r_e_user_id->AdvancedSearch->SearchValue;
            $this->r_e_user_id->PlaceHolder = RemoveHtml($this->r_e_user_id->caption());

            // r_e_datetime
            $this->r_e_datetime->setupEditAttributes();
            $this->r_e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->r_e_datetime->AdvancedSearch->SearchValue, $this->r_e_datetime->formatPattern()), $this->r_e_datetime->formatPattern()));
            $this->r_e_datetime->PlaceHolder = RemoveHtml($this->r_e_datetime->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $curVal = trim(strval($this->jc_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->jc_no->AdvancedSearch->ViewValue = $this->jc_no->lookupCacheOption($curVal);
            } else {
                $this->jc_no->AdvancedSearch->ViewValue = $this->jc_no->Lookup !== null && is_array($this->jc_no->lookupOptions()) && count($this->jc_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->jc_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->jc_no->EditValue = array_values($this->jc_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->jc_no->AdvancedSearch->SearchValue, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->jc_no->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->jc_no->Lookup->renderViewRow($row);
                }
                $this->jc_no->EditValue = $arwrk;
            }
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->gp_no->AdvancedSearch->SearchValue)) {
            $this->gp_no->addErrorMessage($this->gp_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->_from->AdvancedSearch->SearchValue)) {
            $this->_from->addErrorMessage($this->_from->getErrorMessage(false));
        }
        if (!CheckDate($this->due_date->AdvancedSearch->SearchValue, $this->due_date->formatPattern())) {
            $this->due_date->addErrorMessage($this->due_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->t_distance->AdvancedSearch->SearchValue)) {
            $this->t_distance->addErrorMessage($this->t_distance->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->e_operator->AdvancedSearch->SearchValue)) {
            $this->e_operator->addErrorMessage($this->e_operator->getErrorMessage(false));
        }
        if (!CheckDate($this->e_datetime->AdvancedSearch->SearchValue, $this->e_datetime->formatPattern())) {
            $this->e_datetime->addErrorMessage($this->e_datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->r_datetime->AdvancedSearch->SearchValue, $this->r_datetime->formatPattern())) {
            $this->r_datetime->addErrorMessage($this->r_datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->updated->AdvancedSearch->SearchValue)) {
            $this->updated->addErrorMessage($this->updated->getErrorMessage(false));
        }
        if (!CheckInteger($this->r_e_user_id->AdvancedSearch->SearchValue)) {
            $this->r_e_user_id->addErrorMessage($this->r_e_user_id->getErrorMessage(false));
        }
        if (!CheckDate($this->r_e_datetime->AdvancedSearch->SearchValue, $this->r_e_datetime->formatPattern())) {
            $this->r_e_datetime->addErrorMessage($this->r_e_datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->gp_no->AdvancedSearch->load();
        $this->_from->AdvancedSearch->load();
        $this->to->AdvancedSearch->load();
        $this->attention->AdvancedSearch->load();
        $this->transfer_nature->AdvancedSearch->load();
        $this->due_date->AdvancedSearch->load();
        $this->group->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->count_received->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->gt_id->AdvancedSearch->load();
        $this->despatchdetails->AdvancedSearch->load();
        $this->sender_comments->AdvancedSearch->load();
        $this->t_mode->AdvancedSearch->load();
        $this->t_distance->AdvancedSearch->load();
        $this->t_v_no->AdvancedSearch->load();
        $this->purpose->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->e_operator->AdvancedSearch->load();
        $this->e_datetime->AdvancedSearch->load();
        $this->receiving_condition->AdvancedSearch->load();
        $this->receiver_comments->AdvancedSearch->load();
        $this->r_operator->AdvancedSearch->load();
        $this->r_datetime->AdvancedSearch->load();
        $this->updated->AdvancedSearch->load();
        $this->r_e_user_id->AdvancedSearch->load();
        $this->r_e_datetime->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("gatepassreceivedlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x__from":
                    break;
                case "x_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_attention":
                    break;
                case "x_transfer_nature":
                    break;
                case "x_group":
                    break;
                case "x_t_mode":
                    break;
                case "x_operator":
                    break;
                case "x_receiving_condition":
                    break;
                case "x_r_operator":
                    break;
                case "x_jc_no":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
