<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GatePassReceivedEdit extends GatePassReceived
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GatePassReceivedEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "gatepassreceivededit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->gp_no->setVisibility();
        $this->_print->Visible = false;
        $this->_from->setVisibility();
        $this->to->setVisibility();
        $this->attention->setVisibility();
        $this->transfer_nature->setVisibility();
        $this->due_date->setVisibility();
        $this->group->Visible = false;
        $this->product->Visible = false;
        $this->count_received->Visible = false;
        $this->item->setVisibility();
        $this->gt_id->Visible = false;
        $this->quantity->Visible = false;
        $this->despatchdetails->setVisibility();
        $this->sender_comments->setVisibility();
        $this->t_mode->setVisibility();
        $this->t_distance->setVisibility();
        $this->t_v_no->setVisibility();
        $this->purpose->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->e_operator->Visible = false;
        $this->e_datetime->Visible = false;
        $this->receiving_condition->setVisibility();
        $this->receiver_comments->setVisibility();
        $this->r_operator->setVisibility();
        $this->r_datetime->setVisibility();
        $this->updated->Visible = false;
        $this->r_e_user_id->Visible = false;
        $this->r_e_datetime->Visible = false;
        $this->jc_no->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'gate_pass_received';
        $this->TableName = 'gate_pass_received';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (gate_pass_received)
        if (!isset($GLOBALS["gate_pass_received"]) || $GLOBALS["gate_pass_received"]::class == PROJECT_NAMESPACE . "gate_pass_received") {
            $GLOBALS["gate_pass_received"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass_received');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "gatepassreceivedview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['gp_no'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->gp_no->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->_from->Required = false;
        $this->to->Required = false;
        $this->attention->Required = false;
        $this->transfer_nature->Required = false;
        $this->item->Required = false;
        $this->despatchdetails->Required = false;
        $this->sender_comments->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->_from);
        $this->setupLookupOptions($this->to);
        $this->setupLookupOptions($this->attention);
        $this->setupLookupOptions($this->transfer_nature);
        $this->setupLookupOptions($this->group);
        $this->setupLookupOptions($this->t_mode);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->receiving_condition);
        $this->setupLookupOptions($this->r_operator);
        $this->setupLookupOptions($this->jc_no);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("gp_no") ?? Key(0) ?? Route(2)) !== null) {
                $this->gp_no->setQueryStringValue($keyValue);
                $this->gp_no->setOldValue($this->gp_no->QueryStringValue);
            } elseif (Post("gp_no") !== null) {
                $this->gp_no->setFormValue(Post("gp_no"));
                $this->gp_no->setOldValue($this->gp_no->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("gp_no") ?? Route("gp_no")) !== null) {
                    $this->gp_no->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->gp_no->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("gatepassreceivedlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "gatepassreceivedlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "gatepassreceivedlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "gatepassreceivedlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'gp_no' first before field var 'x_gp_no'
        $val = $CurrentForm->hasValue("gp_no") ? $CurrentForm->getValue("gp_no") : $CurrentForm->getValue("x_gp_no");
        if (!$this->gp_no->IsDetailKey) {
            $this->gp_no->setFormValue($val);
        }

        // Check field name 'from' first before field var 'x__from'
        $val = $CurrentForm->hasValue("from") ? $CurrentForm->getValue("from") : $CurrentForm->getValue("x__from");
        if (!$this->_from->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_from->Visible = false; // Disable update for API request
            } else {
                $this->_from->setFormValue($val);
            }
        }

        // Check field name 'to' first before field var 'x_to'
        $val = $CurrentForm->hasValue("to") ? $CurrentForm->getValue("to") : $CurrentForm->getValue("x_to");
        if (!$this->to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->to->Visible = false; // Disable update for API request
            } else {
                $this->to->setFormValue($val);
            }
        }

        // Check field name 'attention' first before field var 'x_attention'
        $val = $CurrentForm->hasValue("attention") ? $CurrentForm->getValue("attention") : $CurrentForm->getValue("x_attention");
        if (!$this->attention->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->attention->Visible = false; // Disable update for API request
            } else {
                $this->attention->setFormValue($val);
            }
        }

        // Check field name 'transfer_nature' first before field var 'x_transfer_nature'
        $val = $CurrentForm->hasValue("transfer_nature") ? $CurrentForm->getValue("transfer_nature") : $CurrentForm->getValue("x_transfer_nature");
        if (!$this->transfer_nature->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transfer_nature->Visible = false; // Disable update for API request
            } else {
                $this->transfer_nature->setFormValue($val);
            }
        }

        // Check field name 'due_date' first before field var 'x_due_date'
        $val = $CurrentForm->hasValue("due_date") ? $CurrentForm->getValue("due_date") : $CurrentForm->getValue("x_due_date");
        if (!$this->due_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->due_date->Visible = false; // Disable update for API request
            } else {
                $this->due_date->setFormValue($val);
            }
            $this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'despatch details' first before field var 'x_despatchdetails'
        $val = $CurrentForm->hasValue("despatch details") ? $CurrentForm->getValue("despatch details") : $CurrentForm->getValue("x_despatchdetails");
        if (!$this->despatchdetails->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatchdetails->Visible = false; // Disable update for API request
            } else {
                $this->despatchdetails->setFormValue($val);
            }
        }

        // Check field name 'sender_comments' first before field var 'x_sender_comments'
        $val = $CurrentForm->hasValue("sender_comments") ? $CurrentForm->getValue("sender_comments") : $CurrentForm->getValue("x_sender_comments");
        if (!$this->sender_comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sender_comments->Visible = false; // Disable update for API request
            } else {
                $this->sender_comments->setFormValue($val);
            }
        }

        // Check field name 't_mode' first before field var 'x_t_mode'
        $val = $CurrentForm->hasValue("t_mode") ? $CurrentForm->getValue("t_mode") : $CurrentForm->getValue("x_t_mode");
        if (!$this->t_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_mode->Visible = false; // Disable update for API request
            } else {
                $this->t_mode->setFormValue($val);
            }
        }

        // Check field name 't_distance' first before field var 'x_t_distance'
        $val = $CurrentForm->hasValue("t_distance") ? $CurrentForm->getValue("t_distance") : $CurrentForm->getValue("x_t_distance");
        if (!$this->t_distance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_distance->Visible = false; // Disable update for API request
            } else {
                $this->t_distance->setFormValue($val);
            }
        }

        // Check field name 't_v_no' first before field var 'x_t_v_no'
        $val = $CurrentForm->hasValue("t_v_no") ? $CurrentForm->getValue("t_v_no") : $CurrentForm->getValue("x_t_v_no");
        if (!$this->t_v_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_v_no->Visible = false; // Disable update for API request
            } else {
                $this->t_v_no->setFormValue($val);
            }
        }

        // Check field name 'purpose' first before field var 'x_purpose'
        $val = $CurrentForm->hasValue("purpose") ? $CurrentForm->getValue("purpose") : $CurrentForm->getValue("x_purpose");
        if (!$this->purpose->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->purpose->Visible = false; // Disable update for API request
            } else {
                $this->purpose->setFormValue($val);
            }
        }

        // Check field name 'receiving_condition' first before field var 'x_receiving_condition'
        $val = $CurrentForm->hasValue("receiving_condition") ? $CurrentForm->getValue("receiving_condition") : $CurrentForm->getValue("x_receiving_condition");
        if (!$this->receiving_condition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->receiving_condition->Visible = false; // Disable update for API request
            } else {
                $this->receiving_condition->setFormValue($val);
            }
        }

        // Check field name 'receiver_comments' first before field var 'x_receiver_comments'
        $val = $CurrentForm->hasValue("receiver_comments") ? $CurrentForm->getValue("receiver_comments") : $CurrentForm->getValue("x_receiver_comments");
        if (!$this->receiver_comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->receiver_comments->Visible = false; // Disable update for API request
            } else {
                $this->receiver_comments->setFormValue($val);
            }
        }

        // Check field name 'r_operator' first before field var 'x_r_operator'
        $val = $CurrentForm->hasValue("r_operator") ? $CurrentForm->getValue("r_operator") : $CurrentForm->getValue("x_r_operator");
        if (!$this->r_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_operator->Visible = false; // Disable update for API request
            } else {
                $this->r_operator->setFormValue($val);
            }
        }

        // Check field name 'r_datetime' first before field var 'x_r_datetime'
        $val = $CurrentForm->hasValue("r_datetime") ? $CurrentForm->getValue("r_datetime") : $CurrentForm->getValue("x_r_datetime");
        if (!$this->r_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_datetime->Visible = false; // Disable update for API request
            } else {
                $this->r_datetime->setFormValue($val);
            }
            $this->r_datetime->CurrentValue = UnFormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->gp_no->CurrentValue = $this->gp_no->FormValue;
        $this->_from->CurrentValue = $this->_from->FormValue;
        $this->to->CurrentValue = $this->to->FormValue;
        $this->attention->CurrentValue = $this->attention->FormValue;
        $this->transfer_nature->CurrentValue = $this->transfer_nature->FormValue;
        $this->due_date->CurrentValue = $this->due_date->FormValue;
        $this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        $this->item->CurrentValue = $this->item->FormValue;
        $this->despatchdetails->CurrentValue = $this->despatchdetails->FormValue;
        $this->sender_comments->CurrentValue = $this->sender_comments->FormValue;
        $this->t_mode->CurrentValue = $this->t_mode->FormValue;
        $this->t_distance->CurrentValue = $this->t_distance->FormValue;
        $this->t_v_no->CurrentValue = $this->t_v_no->FormValue;
        $this->purpose->CurrentValue = $this->purpose->FormValue;
        $this->receiving_condition->CurrentValue = $this->receiving_condition->FormValue;
        $this->receiver_comments->CurrentValue = $this->receiver_comments->FormValue;
        $this->r_operator->CurrentValue = $this->r_operator->FormValue;
        $this->r_datetime->CurrentValue = $this->r_datetime->FormValue;
        $this->r_datetime->CurrentValue = UnFormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("edit");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->_print->setDbValue($row['print']);
        $this->_from->setDbValue($row['from']);
        $this->to->setDbValue($row['to']);
        $this->attention->setDbValue($row['attention']);
        $this->transfer_nature->setDbValue($row['transfer_nature']);
        $this->due_date->setDbValue($row['due_date']);
        $this->group->setDbValue($row['group']);
        $this->product->setDbValue($row['product']);
        $this->count_received->setDbValue($row['count_received']);
        $this->item->setDbValue($row['item']);
        $this->gt_id->setDbValue($row['gt_id']);
        $this->quantity->setDbValue($row['quantity']);
        $this->despatchdetails->setDbValue($row['despatch details']);
        $this->sender_comments->setDbValue($row['sender_comments']);
        $this->t_mode->setDbValue($row['t_mode']);
        $this->t_distance->setDbValue($row['t_distance']);
        $this->t_v_no->setDbValue($row['t_v_no']);
        $this->purpose->setDbValue($row['purpose']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_operator->setDbValue($row['e_operator']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->receiving_condition->setDbValue($row['receiving_condition']);
        $this->receiver_comments->setDbValue($row['receiver_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->r_e_user_id->setDbValue($row['r_e_user_id']);
        $this->r_e_datetime->setDbValue($row['r_e_datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['gp_no'] = $this->gp_no->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['from'] = $this->_from->DefaultValue;
        $row['to'] = $this->to->DefaultValue;
        $row['attention'] = $this->attention->DefaultValue;
        $row['transfer_nature'] = $this->transfer_nature->DefaultValue;
        $row['due_date'] = $this->due_date->DefaultValue;
        $row['group'] = $this->group->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['count_received'] = $this->count_received->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['gt_id'] = $this->gt_id->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['despatch details'] = $this->despatchdetails->DefaultValue;
        $row['sender_comments'] = $this->sender_comments->DefaultValue;
        $row['t_mode'] = $this->t_mode->DefaultValue;
        $row['t_distance'] = $this->t_distance->DefaultValue;
        $row['t_v_no'] = $this->t_v_no->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['e_operator'] = $this->e_operator->DefaultValue;
        $row['e_datetime'] = $this->e_datetime->DefaultValue;
        $row['receiving_condition'] = $this->receiving_condition->DefaultValue;
        $row['receiver_comments'] = $this->receiver_comments->DefaultValue;
        $row['r_operator'] = $this->r_operator->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['r_e_user_id'] = $this->r_e_user_id->DefaultValue;
        $row['r_e_datetime'] = $this->r_e_datetime->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // gp_no
        $this->gp_no->RowCssClass = "row";

        // print
        $this->_print->RowCssClass = "row";

        // from
        $this->_from->RowCssClass = "row";

        // to
        $this->to->RowCssClass = "row";

        // attention
        $this->attention->RowCssClass = "row";

        // transfer_nature
        $this->transfer_nature->RowCssClass = "row";

        // due_date
        $this->due_date->RowCssClass = "row";

        // group
        $this->group->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // count_received
        $this->count_received->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // gt_id
        $this->gt_id->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // despatch details
        $this->despatchdetails->RowCssClass = "row";

        // sender_comments
        $this->sender_comments->RowCssClass = "row";

        // t_mode
        $this->t_mode->RowCssClass = "row";

        // t_distance
        $this->t_distance->RowCssClass = "row";

        // t_v_no
        $this->t_v_no->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_operator
        $this->e_operator->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // receiving_condition
        $this->receiving_condition->RowCssClass = "row";

        // receiver_comments
        $this->receiver_comments->RowCssClass = "row";

        // r_operator
        $this->r_operator->RowCssClass = "row";

        // r_datetime
        $this->r_datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // r_e_user_id
        $this->r_e_user_id->RowCssClass = "row";

        // r_e_datetime
        $this->r_e_datetime->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // gp_no
            $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
            $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());

            // from
            $this->_from->ViewValue = $this->_from->CurrentValue;
            $curVal = strval($this->_from->CurrentValue);
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->ViewValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->ViewValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                    }
                }
            } else {
                $this->_from->ViewValue = null;
            }

            // to
            $curVal = strval($this->to->CurrentValue);
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
                if ($this->to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                        $this->to->ViewValue = $this->to->displayValue($arwrk);
                    } else {
                        $this->to->ViewValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                    }
                }
            } else {
                $this->to->ViewValue = null;
            }

            // attention
            $curVal = strval($this->attention->CurrentValue);
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
                if ($this->attention->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                        $this->attention->ViewValue = $this->attention->displayValue($arwrk);
                    } else {
                        $this->attention->ViewValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                    }
                }
            } else {
                $this->attention->ViewValue = null;
            }

            // transfer_nature
            if (strval($this->transfer_nature->CurrentValue) != "") {
                $this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
            } else {
                $this->transfer_nature->ViewValue = null;
            }

            // due_date
            $this->due_date->ViewValue = $this->due_date->CurrentValue;
            $this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, $this->due_date->formatPattern());

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // despatch details
            $this->despatchdetails->ViewValue = $this->despatchdetails->CurrentValue;

            // sender_comments
            $this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;

            // t_mode
            if (strval($this->t_mode->CurrentValue) != "") {
                $this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
            } else {
                $this->t_mode->ViewValue = null;
            }

            // t_distance
            $this->t_distance->ViewValue = $this->t_distance->CurrentValue;
            $this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, $this->t_distance->formatPattern());

            // t_v_no
            $this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;

            // purpose
            $this->purpose->ViewValue = $this->purpose->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $this->e_operator->ViewValue = $this->e_operator->CurrentValue;
            $this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, $this->e_operator->formatPattern());

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // receiving_condition
            if (strval($this->receiving_condition->CurrentValue) != "") {
                $this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
            } else {
                $this->receiving_condition->ViewValue = null;
            }

            // receiver_comments
            $this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;

            // r_operator
            $curVal = strval($this->r_operator->CurrentValue);
            if ($curVal != "") {
                $this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
                if ($this->r_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->r_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->r_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->r_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->r_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
                    } else {
                        $this->r_operator->ViewValue = FormatNumber($this->r_operator->CurrentValue, $this->r_operator->formatPattern());
                    }
                }
            } else {
                $this->r_operator->ViewValue = null;
            }

            // r_datetime
            $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
            $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

            // jc_no
            $curVal = strval($this->jc_no->CurrentValue);
            if ($curVal != "") {
                $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
                if ($this->jc_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->jc_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jc_no->Lookup->renderViewRow($rswrk[0]);
                        $this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
                    } else {
                        $this->jc_no->ViewValue = FormatNumber($this->jc_no->CurrentValue, $this->jc_no->formatPattern());
                    }
                }
            } else {
                $this->jc_no->ViewValue = null;
            }

            // gp_no
            $this->gp_no->HrefValue = "";
            $this->gp_no->TooltipValue = "";

            // from
            if (!EmptyValue($this->_from->CurrentValue)) {
                $this->_from->HrefValue = $this->_from->getLinkPrefix() . $this->_from->CurrentValue; // Add prefix/suffix
                $this->_from->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_from->HrefValue = FullUrl($this->_from->HrefValue, "href");
                }
            } else {
                $this->_from->HrefValue = "";
            }
            $this->_from->TooltipValue = "";

            // to
            if (!EmptyValue($this->to->CurrentValue)) {
                $this->to->HrefValue = $this->to->getLinkPrefix() . $this->to->CurrentValue; // Add prefix/suffix
                $this->to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
                }
            } else {
                $this->to->HrefValue = "";
            }
            $this->to->TooltipValue = "";

            // attention
            if (!EmptyValue($this->attention->CurrentValue)) {
                $this->attention->HrefValue = $this->attention->getLinkPrefix() . $this->attention->CurrentValue; // Add prefix/suffix
                $this->attention->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
                }
            } else {
                $this->attention->HrefValue = "";
            }
            $this->attention->TooltipValue = "";

            // transfer_nature
            if (!EmptyValue($this->transfer_nature->CurrentValue)) {
                $this->transfer_nature->HrefValue = $this->transfer_nature->getLinkPrefix() . $this->transfer_nature->CurrentValue; // Add prefix/suffix
                $this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
                }
            } else {
                $this->transfer_nature->HrefValue = "";
            }
            $this->transfer_nature->TooltipValue = "";

            // due_date
            if (!EmptyValue($this->due_date->CurrentValue)) {
                $this->due_date->HrefValue = $this->due_date->getLinkPrefix() . $this->due_date->CurrentValue; // Add prefix/suffix
                $this->due_date->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
                }
            } else {
                $this->due_date->HrefValue = "";
            }
            $this->due_date->TooltipValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }
            $this->item->TooltipValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";
            $this->despatchdetails->TooltipValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";
            $this->sender_comments->TooltipValue = "";

            // t_mode
            if (!EmptyValue($this->t_mode->CurrentValue)) {
                $this->t_mode->HrefValue = $this->t_mode->getLinkPrefix() . $this->t_mode->CurrentValue; // Add prefix/suffix
                $this->t_mode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
                }
            } else {
                $this->t_mode->HrefValue = "";
            }
            $this->t_mode->TooltipValue = "";

            // t_distance
            $this->t_distance->HrefValue = "";
            $this->t_distance->TooltipValue = "";

            // t_v_no
            $this->t_v_no->HrefValue = "";
            $this->t_v_no->TooltipValue = "";

            // purpose
            $this->purpose->HrefValue = "";
            $this->purpose->TooltipValue = "";

            // receiving_condition
            $this->receiving_condition->HrefValue = "";

            // receiver_comments
            $this->receiver_comments->HrefValue = "";

            // r_operator
            $this->r_operator->HrefValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // gp_no
            $this->gp_no->setupEditAttributes();
            $this->gp_no->EditValue = $this->gp_no->CurrentValue;
            $this->gp_no->EditValue = FormatNumber($this->gp_no->EditValue, $this->gp_no->formatPattern());

            // from
            $this->_from->setupEditAttributes();
            $this->_from->EditValue = $this->_from->CurrentValue;
            $curVal = strval($this->_from->CurrentValue);
            if ($curVal != "") {
                $this->_from->EditValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->EditValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->EditValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                    }
                }
            } else {
                $this->_from->EditValue = null;
            }

            // to
            $this->to->setupEditAttributes();
            $curVal = strval($this->to->CurrentValue);
            if ($curVal != "") {
                $this->to->EditValue = $this->to->lookupCacheOption($curVal);
                if ($this->to->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                        $this->to->EditValue = $this->to->displayValue($arwrk);
                    } else {
                        $this->to->EditValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                    }
                }
            } else {
                $this->to->EditValue = null;
            }

            // attention
            $this->attention->setupEditAttributes();
            $curVal = strval($this->attention->CurrentValue);
            if ($curVal != "") {
                $this->attention->EditValue = $this->attention->lookupCacheOption($curVal);
                if ($this->attention->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                        $this->attention->EditValue = $this->attention->displayValue($arwrk);
                    } else {
                        $this->attention->EditValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                    }
                }
            } else {
                $this->attention->EditValue = null;
            }

            // transfer_nature
            $this->transfer_nature->setupEditAttributes();
            if (strval($this->transfer_nature->CurrentValue) != "") {
                $this->transfer_nature->EditValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
            } else {
                $this->transfer_nature->EditValue = null;
            }

            // due_date
            $this->due_date->setupEditAttributes();
            $this->due_date->EditValue = $this->due_date->CurrentValue;
            $this->due_date->EditValue = FormatDateTime($this->due_date->EditValue, $this->due_date->formatPattern());

            // item
            $this->item->setupEditAttributes();
            $this->item->EditValue = $this->item->CurrentValue;

            // despatch details
            $this->despatchdetails->setupEditAttributes();
            $this->despatchdetails->EditValue = $this->despatchdetails->CurrentValue;

            // sender_comments
            $this->sender_comments->setupEditAttributes();
            $this->sender_comments->EditValue = $this->sender_comments->CurrentValue;

            // t_mode
            $this->t_mode->setupEditAttributes();
            if (strval($this->t_mode->CurrentValue) != "") {
                $this->t_mode->EditValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
            } else {
                $this->t_mode->EditValue = null;
            }

            // t_distance
            $this->t_distance->setupEditAttributes();
            $this->t_distance->EditValue = $this->t_distance->CurrentValue;
            $this->t_distance->EditValue = FormatNumber($this->t_distance->EditValue, $this->t_distance->formatPattern());

            // t_v_no
            $this->t_v_no->setupEditAttributes();
            $this->t_v_no->EditValue = $this->t_v_no->CurrentValue;

            // purpose
            $this->purpose->setupEditAttributes();
            $this->purpose->EditValue = $this->purpose->CurrentValue;

            // receiving_condition
            $this->receiving_condition->setupEditAttributes();
            $this->receiving_condition->EditValue = $this->receiving_condition->options(true);
            $this->receiving_condition->PlaceHolder = RemoveHtml($this->receiving_condition->caption());

            // receiver_comments
            $this->receiver_comments->setupEditAttributes();
            $this->receiver_comments->EditValue = HtmlEncode($this->receiver_comments->CurrentValue);
            $this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());

            // r_operator

            // r_datetime

            // Edit refer script

            // gp_no
            $this->gp_no->HrefValue = "";
            $this->gp_no->TooltipValue = "";

            // from
            if (!EmptyValue($this->_from->CurrentValue)) {
                $this->_from->HrefValue = $this->_from->getLinkPrefix() . $this->_from->CurrentValue; // Add prefix/suffix
                $this->_from->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_from->HrefValue = FullUrl($this->_from->HrefValue, "href");
                }
            } else {
                $this->_from->HrefValue = "";
            }
            $this->_from->TooltipValue = "";

            // to
            if (!EmptyValue($this->to->CurrentValue)) {
                $this->to->HrefValue = $this->to->getLinkPrefix() . $this->to->CurrentValue; // Add prefix/suffix
                $this->to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
                }
            } else {
                $this->to->HrefValue = "";
            }
            $this->to->TooltipValue = "";

            // attention
            if (!EmptyValue($this->attention->CurrentValue)) {
                $this->attention->HrefValue = $this->attention->getLinkPrefix() . $this->attention->CurrentValue; // Add prefix/suffix
                $this->attention->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
                }
            } else {
                $this->attention->HrefValue = "";
            }
            $this->attention->TooltipValue = "";

            // transfer_nature
            if (!EmptyValue($this->transfer_nature->CurrentValue)) {
                $this->transfer_nature->HrefValue = $this->transfer_nature->getLinkPrefix() . $this->transfer_nature->CurrentValue; // Add prefix/suffix
                $this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
                }
            } else {
                $this->transfer_nature->HrefValue = "";
            }
            $this->transfer_nature->TooltipValue = "";

            // due_date
            if (!EmptyValue($this->due_date->CurrentValue)) {
                $this->due_date->HrefValue = $this->due_date->getLinkPrefix() . $this->due_date->CurrentValue; // Add prefix/suffix
                $this->due_date->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
                }
            } else {
                $this->due_date->HrefValue = "";
            }
            $this->due_date->TooltipValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }
            $this->item->TooltipValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";
            $this->despatchdetails->TooltipValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";
            $this->sender_comments->TooltipValue = "";

            // t_mode
            if (!EmptyValue($this->t_mode->CurrentValue)) {
                $this->t_mode->HrefValue = $this->t_mode->getLinkPrefix() . $this->t_mode->CurrentValue; // Add prefix/suffix
                $this->t_mode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
                }
            } else {
                $this->t_mode->HrefValue = "";
            }
            $this->t_mode->TooltipValue = "";

            // t_distance
            $this->t_distance->HrefValue = "";
            $this->t_distance->TooltipValue = "";

            // t_v_no
            $this->t_v_no->HrefValue = "";
            $this->t_v_no->TooltipValue = "";

            // purpose
            $this->purpose->HrefValue = "";
            $this->purpose->TooltipValue = "";

            // receiving_condition
            $this->receiving_condition->HrefValue = "";

            // receiver_comments
            $this->receiver_comments->HrefValue = "";

            // r_operator
            $this->r_operator->HrefValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->gp_no->Visible && $this->gp_no->Required) {
                if (!$this->gp_no->IsDetailKey && EmptyValue($this->gp_no->FormValue)) {
                    $this->gp_no->addErrorMessage(str_replace("%s", $this->gp_no->caption(), $this->gp_no->RequiredErrorMessage));
                }
            }
            if ($this->_from->Visible && $this->_from->Required) {
                if (!$this->_from->IsDetailKey && EmptyValue($this->_from->FormValue)) {
                    $this->_from->addErrorMessage(str_replace("%s", $this->_from->caption(), $this->_from->RequiredErrorMessage));
                }
            }
            if ($this->to->Visible && $this->to->Required) {
                if (!$this->to->IsDetailKey && EmptyValue($this->to->FormValue)) {
                    $this->to->addErrorMessage(str_replace("%s", $this->to->caption(), $this->to->RequiredErrorMessage));
                }
            }
            if ($this->attention->Visible && $this->attention->Required) {
                if (!$this->attention->IsDetailKey && EmptyValue($this->attention->FormValue)) {
                    $this->attention->addErrorMessage(str_replace("%s", $this->attention->caption(), $this->attention->RequiredErrorMessage));
                }
            }
            if ($this->transfer_nature->Visible && $this->transfer_nature->Required) {
                if (!$this->transfer_nature->IsDetailKey && EmptyValue($this->transfer_nature->FormValue)) {
                    $this->transfer_nature->addErrorMessage(str_replace("%s", $this->transfer_nature->caption(), $this->transfer_nature->RequiredErrorMessage));
                }
            }
            if ($this->due_date->Visible && $this->due_date->Required) {
                if (!$this->due_date->IsDetailKey && EmptyValue($this->due_date->FormValue)) {
                    $this->due_date->addErrorMessage(str_replace("%s", $this->due_date->caption(), $this->due_date->RequiredErrorMessage));
                }
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->despatchdetails->Visible && $this->despatchdetails->Required) {
                if (!$this->despatchdetails->IsDetailKey && EmptyValue($this->despatchdetails->FormValue)) {
                    $this->despatchdetails->addErrorMessage(str_replace("%s", $this->despatchdetails->caption(), $this->despatchdetails->RequiredErrorMessage));
                }
            }
            if ($this->sender_comments->Visible && $this->sender_comments->Required) {
                if (!$this->sender_comments->IsDetailKey && EmptyValue($this->sender_comments->FormValue)) {
                    $this->sender_comments->addErrorMessage(str_replace("%s", $this->sender_comments->caption(), $this->sender_comments->RequiredErrorMessage));
                }
            }
            if ($this->t_mode->Visible && $this->t_mode->Required) {
                if (!$this->t_mode->IsDetailKey && EmptyValue($this->t_mode->FormValue)) {
                    $this->t_mode->addErrorMessage(str_replace("%s", $this->t_mode->caption(), $this->t_mode->RequiredErrorMessage));
                }
            }
            if ($this->t_distance->Visible && $this->t_distance->Required) {
                if (!$this->t_distance->IsDetailKey && EmptyValue($this->t_distance->FormValue)) {
                    $this->t_distance->addErrorMessage(str_replace("%s", $this->t_distance->caption(), $this->t_distance->RequiredErrorMessage));
                }
            }
            if ($this->t_v_no->Visible && $this->t_v_no->Required) {
                if (!$this->t_v_no->IsDetailKey && EmptyValue($this->t_v_no->FormValue)) {
                    $this->t_v_no->addErrorMessage(str_replace("%s", $this->t_v_no->caption(), $this->t_v_no->RequiredErrorMessage));
                }
            }
            if ($this->purpose->Visible && $this->purpose->Required) {
                if (!$this->purpose->IsDetailKey && EmptyValue($this->purpose->FormValue)) {
                    $this->purpose->addErrorMessage(str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
                }
            }
            if ($this->receiving_condition->Visible && $this->receiving_condition->Required) {
                if (!$this->receiving_condition->IsDetailKey && EmptyValue($this->receiving_condition->FormValue)) {
                    $this->receiving_condition->addErrorMessage(str_replace("%s", $this->receiving_condition->caption(), $this->receiving_condition->RequiredErrorMessage));
                }
            }
            if ($this->receiver_comments->Visible && $this->receiver_comments->Required) {
                if (!$this->receiver_comments->IsDetailKey && EmptyValue($this->receiver_comments->FormValue)) {
                    $this->receiver_comments->addErrorMessage(str_replace("%s", $this->receiver_comments->caption(), $this->receiver_comments->RequiredErrorMessage));
                }
            }
            if ($this->r_operator->Visible && $this->r_operator->Required) {
                if (!$this->r_operator->IsDetailKey && EmptyValue($this->r_operator->FormValue)) {
                    $this->r_operator->addErrorMessage(str_replace("%s", $this->r_operator->caption(), $this->r_operator->RequiredErrorMessage));
                }
            }
            if ($this->r_datetime->Visible && $this->r_datetime->Required) {
                if (!$this->r_datetime->IsDetailKey && EmptyValue($this->r_datetime->FormValue)) {
                    $this->r_datetime->addErrorMessage(str_replace("%s", $this->r_datetime->caption(), $this->r_datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // receiving_condition
        $this->receiving_condition->setDbValueDef($rsnew, $this->receiving_condition->CurrentValue, $this->receiving_condition->ReadOnly);

        // receiver_comments
        $this->receiver_comments->setDbValueDef($rsnew, $this->receiver_comments->CurrentValue, $this->receiver_comments->ReadOnly);

        // r_operator
        $this->r_operator->CurrentValue = $this->r_operator->getAutoUpdateValue(); // PHP
        $this->r_operator->setDbValueDef($rsnew, $this->r_operator->CurrentValue, $this->r_operator->ReadOnly);

        // r_datetime
        $this->r_datetime->CurrentValue = $this->r_datetime->getAutoUpdateValue(); // PHP
        $this->r_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern()), $this->r_datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['receiving_condition'])) { // receiving_condition
            $this->receiving_condition->CurrentValue = $row['receiving_condition'];
        }
        if (isset($row['receiver_comments'])) { // receiver_comments
            $this->receiver_comments->CurrentValue = $row['receiver_comments'];
        }
        if (isset($row['r_operator'])) { // r_operator
            $this->r_operator->CurrentValue = $row['r_operator'];
        }
        if (isset($row['r_datetime'])) { // r_datetime
            $this->r_datetime->CurrentValue = $row['r_datetime'];
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->attention->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("gatepassreceivedlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x__from":
                    break;
                case "x_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_attention":
                    break;
                case "x_transfer_nature":
                    break;
                case "x_group":
                    break;
                case "x_t_mode":
                    break;
                case "x_operator":
                    break;
                case "x_receiving_condition":
                    break;
                case "x_r_operator":
                    break;
                case "x_jc_no":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
