<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GatePassAdd extends GatePass
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GatePassAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "gatepassadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->gp_no->Visible = false;
        $this->_print->Visible = false;
        $this->company_id->setVisibility();
        $this->_from->setVisibility();
        $this->from_po->setVisibility();
        $this->to->setVisibility();
        $this->to_other->setVisibility();
        $this->attention->setVisibility();
        $this->transfer_nature->setVisibility();
        $this->due_date->setVisibility();
        $this->jc_no->setVisibility();
        $this->item->setVisibility();
        $this->quantity->Visible = false;
        $this->sender_comments->setVisibility();
        $this->despatchdetails->setVisibility();
        $this->t_mode->setVisibility();
        $this->t_distance->setVisibility();
        $this->t_v_no->setVisibility();
        $this->purpose->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->Visible = false;
        $this->e_datetime->Visible = false;
        $this->receiving_condition->Visible = false;
        $this->receiver_comments->Visible = false;
        $this->r_operator->Visible = false;
        $this->r_datetime->Visible = false;
        $this->updated->Visible = false;
        $this->r_e_user_id->Visible = false;
        $this->r_e_datetime->Visible = false;
        $this->group->Visible = false;
        $this->product->Visible = false;
        $this->count_received->Visible = false;
        $this->gt_id->Visible = false;
        $this->to_category->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'gate_pass';
        $this->TableName = 'gate_pass';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (gate_pass)
        if (!isset($GLOBALS["gate_pass"]) || $GLOBALS["gate_pass"]::class == PROJECT_NAMESPACE . "gate_pass") {
            $GLOBALS["gate_pass"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "gatepassview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['gp_no'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->gp_no->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->_from);
        $this->setupLookupOptions($this->from_po);
        $this->setupLookupOptions($this->to);
        $this->setupLookupOptions($this->attention);
        $this->setupLookupOptions($this->transfer_nature);
        $this->setupLookupOptions($this->t_mode);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->receiving_condition);
        $this->setupLookupOptions($this->r_operator);
        $this->setupLookupOptions($this->r_e_user_id);
        $this->setupLookupOptions($this->group);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("gp_no") ?? Route("gp_no")) !== null) {
                $this->gp_no->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("gatepasslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "gatepasslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "gatepassview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "gatepasslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "gatepasslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->_print->DefaultValue = $this->_print->getDefault(); // PHP
        $this->_print->OldValue = $this->_print->DefaultValue;
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->_from->DefaultValue = $this->_from->getDefault(); // PHP
        $this->_from->OldValue = $this->_from->DefaultValue;
        $this->to->DefaultValue = $this->to->getDefault(); // PHP
        $this->to->OldValue = $this->to->DefaultValue;
        $this->transfer_nature->DefaultValue = $this->transfer_nature->getDefault(); // PHP
        $this->transfer_nature->OldValue = $this->transfer_nature->DefaultValue;
        $this->item->DefaultValue = $this->item->getDefault(); // PHP
        $this->item->OldValue = $this->item->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'from' first before field var 'x__from'
        $val = $CurrentForm->hasValue("from") ? $CurrentForm->getValue("from") : $CurrentForm->getValue("x__from");
        if (!$this->_from->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_from->Visible = false; // Disable update for API request
            } else {
                $this->_from->setFormValue($val);
            }
        }

        // Check field name 'from_po' first before field var 'x_from_po'
        $val = $CurrentForm->hasValue("from_po") ? $CurrentForm->getValue("from_po") : $CurrentForm->getValue("x_from_po");
        if (!$this->from_po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->from_po->Visible = false; // Disable update for API request
            } else {
                $this->from_po->setFormValue($val);
            }
        }

        // Check field name 'to' first before field var 'x_to'
        $val = $CurrentForm->hasValue("to") ? $CurrentForm->getValue("to") : $CurrentForm->getValue("x_to");
        if (!$this->to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->to->Visible = false; // Disable update for API request
            } else {
                $this->to->setFormValue($val);
            }
        }

        // Check field name 'to_other' first before field var 'x_to_other'
        $val = $CurrentForm->hasValue("to_other") ? $CurrentForm->getValue("to_other") : $CurrentForm->getValue("x_to_other");
        if (!$this->to_other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->to_other->Visible = false; // Disable update for API request
            } else {
                $this->to_other->setFormValue($val);
            }
        }

        // Check field name 'attention' first before field var 'x_attention'
        $val = $CurrentForm->hasValue("attention") ? $CurrentForm->getValue("attention") : $CurrentForm->getValue("x_attention");
        if (!$this->attention->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->attention->Visible = false; // Disable update for API request
            } else {
                $this->attention->setFormValue($val);
            }
        }

        // Check field name 'transfer_nature' first before field var 'x_transfer_nature'
        $val = $CurrentForm->hasValue("transfer_nature") ? $CurrentForm->getValue("transfer_nature") : $CurrentForm->getValue("x_transfer_nature");
        if (!$this->transfer_nature->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transfer_nature->Visible = false; // Disable update for API request
            } else {
                $this->transfer_nature->setFormValue($val);
            }
        }

        // Check field name 'due_date' first before field var 'x_due_date'
        $val = $CurrentForm->hasValue("due_date") ? $CurrentForm->getValue("due_date") : $CurrentForm->getValue("x_due_date");
        if (!$this->due_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->due_date->Visible = false; // Disable update for API request
            } else {
                $this->due_date->setFormValue($val, true, $validate);
            }
            $this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'sender_comments' first before field var 'x_sender_comments'
        $val = $CurrentForm->hasValue("sender_comments") ? $CurrentForm->getValue("sender_comments") : $CurrentForm->getValue("x_sender_comments");
        if (!$this->sender_comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sender_comments->Visible = false; // Disable update for API request
            } else {
                $this->sender_comments->setFormValue($val);
            }
        }

        // Check field name 'despatch details' first before field var 'x_despatchdetails'
        $val = $CurrentForm->hasValue("despatch details") ? $CurrentForm->getValue("despatch details") : $CurrentForm->getValue("x_despatchdetails");
        if (!$this->despatchdetails->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatchdetails->Visible = false; // Disable update for API request
            } else {
                $this->despatchdetails->setFormValue($val);
            }
        }

        // Check field name 't_mode' first before field var 'x_t_mode'
        $val = $CurrentForm->hasValue("t_mode") ? $CurrentForm->getValue("t_mode") : $CurrentForm->getValue("x_t_mode");
        if (!$this->t_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_mode->Visible = false; // Disable update for API request
            } else {
                $this->t_mode->setFormValue($val);
            }
        }

        // Check field name 't_distance' first before field var 'x_t_distance'
        $val = $CurrentForm->hasValue("t_distance") ? $CurrentForm->getValue("t_distance") : $CurrentForm->getValue("x_t_distance");
        if (!$this->t_distance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_distance->Visible = false; // Disable update for API request
            } else {
                $this->t_distance->setFormValue($val, true, $validate);
            }
        }

        // Check field name 't_v_no' first before field var 'x_t_v_no'
        $val = $CurrentForm->hasValue("t_v_no") ? $CurrentForm->getValue("t_v_no") : $CurrentForm->getValue("x_t_v_no");
        if (!$this->t_v_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_v_no->Visible = false; // Disable update for API request
            } else {
                $this->t_v_no->setFormValue($val);
            }
        }

        // Check field name 'purpose' first before field var 'x_purpose'
        $val = $CurrentForm->hasValue("purpose") ? $CurrentForm->getValue("purpose") : $CurrentForm->getValue("x_purpose");
        if (!$this->purpose->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->purpose->Visible = false; // Disable update for API request
            } else {
                $this->purpose->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'gp_no' first before field var 'x_gp_no'
        $val = $CurrentForm->hasValue("gp_no") ? $CurrentForm->getValue("gp_no") : $CurrentForm->getValue("x_gp_no");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->_from->CurrentValue = $this->_from->FormValue;
        $this->from_po->CurrentValue = $this->from_po->FormValue;
        $this->to->CurrentValue = $this->to->FormValue;
        $this->to_other->CurrentValue = $this->to_other->FormValue;
        $this->attention->CurrentValue = $this->attention->FormValue;
        $this->transfer_nature->CurrentValue = $this->transfer_nature->FormValue;
        $this->due_date->CurrentValue = $this->due_date->FormValue;
        $this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern());
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->item->CurrentValue = $this->item->FormValue;
        $this->sender_comments->CurrentValue = $this->sender_comments->FormValue;
        $this->despatchdetails->CurrentValue = $this->despatchdetails->FormValue;
        $this->t_mode->CurrentValue = $this->t_mode->FormValue;
        $this->t_distance->CurrentValue = $this->t_distance->FormValue;
        $this->t_v_no->CurrentValue = $this->t_v_no->FormValue;
        $this->purpose->CurrentValue = $this->purpose->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->gp_no->setDbValue($row['gp_no']);
        $this->_print->setDbValue($row['print']);
        $this->company_id->setDbValue($row['company_id']);
        $this->_from->setDbValue($row['from']);
        $this->from_po->setDbValue($row['from_po']);
        $this->to->setDbValue($row['to']);
        $this->to_other->setDbValue($row['to_other']);
        $this->attention->setDbValue($row['attention']);
        $this->transfer_nature->setDbValue($row['transfer_nature']);
        $this->due_date->setDbValue($row['due_date']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->item->setDbValue($row['item']);
        $this->quantity->setDbValue($row['quantity']);
        $this->sender_comments->setDbValue($row['sender_comments']);
        $this->despatchdetails->setDbValue($row['despatch details']);
        $this->t_mode->setDbValue($row['t_mode']);
        $this->t_distance->setDbValue($row['t_distance']);
        $this->t_v_no->setDbValue($row['t_v_no']);
        $this->purpose->setDbValue($row['purpose']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_operator->setDbValue($row['e_operator']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->receiving_condition->setDbValue($row['receiving_condition']);
        $this->receiver_comments->setDbValue($row['receiver_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->r_e_user_id->setDbValue($row['r_e_user_id']);
        $this->r_e_datetime->setDbValue($row['r_e_datetime']);
        $this->group->setDbValue($row['group']);
        $this->product->setDbValue($row['product']);
        $this->count_received->setDbValue($row['count_received']);
        $this->gt_id->setDbValue($row['gt_id']);
        $this->to_category->setDbValue($row['to_category']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['gp_no'] = $this->gp_no->DefaultValue;
        $row['print'] = $this->_print->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['from'] = $this->_from->DefaultValue;
        $row['from_po'] = $this->from_po->DefaultValue;
        $row['to'] = $this->to->DefaultValue;
        $row['to_other'] = $this->to_other->DefaultValue;
        $row['attention'] = $this->attention->DefaultValue;
        $row['transfer_nature'] = $this->transfer_nature->DefaultValue;
        $row['due_date'] = $this->due_date->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['sender_comments'] = $this->sender_comments->DefaultValue;
        $row['despatch details'] = $this->despatchdetails->DefaultValue;
        $row['t_mode'] = $this->t_mode->DefaultValue;
        $row['t_distance'] = $this->t_distance->DefaultValue;
        $row['t_v_no'] = $this->t_v_no->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['e_operator'] = $this->e_operator->DefaultValue;
        $row['e_datetime'] = $this->e_datetime->DefaultValue;
        $row['receiving_condition'] = $this->receiving_condition->DefaultValue;
        $row['receiver_comments'] = $this->receiver_comments->DefaultValue;
        $row['r_operator'] = $this->r_operator->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['r_e_user_id'] = $this->r_e_user_id->DefaultValue;
        $row['r_e_datetime'] = $this->r_e_datetime->DefaultValue;
        $row['group'] = $this->group->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['count_received'] = $this->count_received->DefaultValue;
        $row['gt_id'] = $this->gt_id->DefaultValue;
        $row['to_category'] = $this->to_category->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // gp_no
        $this->gp_no->RowCssClass = "row";

        // print
        $this->_print->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // from
        $this->_from->RowCssClass = "row";

        // from_po
        $this->from_po->RowCssClass = "row";

        // to
        $this->to->RowCssClass = "row";

        // to_other
        $this->to_other->RowCssClass = "row";

        // attention
        $this->attention->RowCssClass = "row";

        // transfer_nature
        $this->transfer_nature->RowCssClass = "row";

        // due_date
        $this->due_date->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // sender_comments
        $this->sender_comments->RowCssClass = "row";

        // despatch details
        $this->despatchdetails->RowCssClass = "row";

        // t_mode
        $this->t_mode->RowCssClass = "row";

        // t_distance
        $this->t_distance->RowCssClass = "row";

        // t_v_no
        $this->t_v_no->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_operator
        $this->e_operator->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // receiving_condition
        $this->receiving_condition->RowCssClass = "row";

        // receiver_comments
        $this->receiver_comments->RowCssClass = "row";

        // r_operator
        $this->r_operator->RowCssClass = "row";

        // r_datetime
        $this->r_datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // r_e_user_id
        $this->r_e_user_id->RowCssClass = "row";

        // r_e_datetime
        $this->r_e_datetime->RowCssClass = "row";

        // group
        $this->group->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // count_received
        $this->count_received->RowCssClass = "row";

        // gt_id
        $this->gt_id->RowCssClass = "row";

        // to_category
        $this->to_category->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // gp_no
            $this->gp_no->ViewValue = $this->gp_no->CurrentValue;
            $this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, $this->gp_no->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // from
            $curVal = strval($this->_from->CurrentValue);
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
                if ($this->_from->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_from->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_from->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_from->Lookup->renderViewRow($rswrk[0]);
                        $this->_from->ViewValue = $this->_from->displayValue($arwrk);
                    } else {
                        $this->_from->ViewValue = FormatNumber($this->_from->CurrentValue, $this->_from->formatPattern());
                    }
                }
            } else {
                $this->_from->ViewValue = null;
            }

            // from_po
            $curVal = strval($this->from_po->CurrentValue);
            if ($curVal != "") {
                $this->from_po->ViewValue = $this->from_po->lookupCacheOption($curVal);
                if ($this->from_po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->from_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->from_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->from_po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->from_po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->from_po->Lookup->renderViewRow($rswrk[0]);
                        $this->from_po->ViewValue = $this->from_po->displayValue($arwrk);
                    } else {
                        $this->from_po->ViewValue = FormatNumber($this->from_po->CurrentValue, $this->from_po->formatPattern());
                    }
                }
            } else {
                $this->from_po->ViewValue = null;
            }

            // to
            $curVal = strval($this->to->CurrentValue);
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
                if ($this->to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->to->Lookup->renderViewRow($rswrk[0]);
                        $this->to->ViewValue = $this->to->displayValue($arwrk);
                    } else {
                        $this->to->ViewValue = FormatNumber($this->to->CurrentValue, $this->to->formatPattern());
                    }
                }
            } else {
                $this->to->ViewValue = null;
            }

            // to_other
            $this->to_other->ViewValue = $this->to_other->CurrentValue;

            // attention
            $curVal = strval($this->attention->CurrentValue);
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
                if ($this->attention->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->attention->getSelectFilter($this); // PHP
                    $sqlWrk = $this->attention->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->attention->Lookup->renderViewRow($rswrk[0]);
                        $this->attention->ViewValue = $this->attention->displayValue($arwrk);
                    } else {
                        $this->attention->ViewValue = FormatNumber($this->attention->CurrentValue, $this->attention->formatPattern());
                    }
                }
            } else {
                $this->attention->ViewValue = null;
            }

            // transfer_nature
            if (strval($this->transfer_nature->CurrentValue) != "") {
                $this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
            } else {
                $this->transfer_nature->ViewValue = null;
            }

            // due_date
            $this->due_date->ViewValue = $this->due_date->CurrentValue;
            $this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, $this->due_date->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // sender_comments
            $this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;

            // despatch details
            $this->despatchdetails->ViewValue = $this->despatchdetails->CurrentValue;

            // t_mode
            if (strval($this->t_mode->CurrentValue) != "") {
                $this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
            } else {
                $this->t_mode->ViewValue = null;
            }

            // t_distance
            $this->t_distance->ViewValue = $this->t_distance->CurrentValue;
            $this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, $this->t_distance->formatPattern());

            // t_v_no
            $this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;

            // purpose
            $this->purpose->ViewValue = $this->purpose->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $this->e_operator->ViewValue = $this->e_operator->CurrentValue;
            $this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, $this->e_operator->formatPattern());

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // receiving_condition
            if (strval($this->receiving_condition->CurrentValue) != "") {
                $this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
            } else {
                $this->receiving_condition->ViewValue = null;
            }

            // receiver_comments
            $this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;

            // r_operator
            $curVal = strval($this->r_operator->CurrentValue);
            if ($curVal != "") {
                $this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
                if ($this->r_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->r_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->r_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->r_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->r_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
                    } else {
                        $this->r_operator->ViewValue = FormatNumber($this->r_operator->CurrentValue, $this->r_operator->formatPattern());
                    }
                }
            } else {
                $this->r_operator->ViewValue = null;
            }

            // r_datetime
            $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
            $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

            // company_id
            $this->company_id->HrefValue = "";

            // from
            if (!EmptyValue($this->_from->CurrentValue)) {
                $this->_from->HrefValue = $this->_from->getLinkPrefix() . $this->_from->CurrentValue; // Add prefix/suffix
                $this->_from->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_from->HrefValue = FullUrl($this->_from->HrefValue, "href");
                }
            } else {
                $this->_from->HrefValue = "";
            }
            $this->_from->TooltipValue = "";

            // from_po
            $this->from_po->HrefValue = "";

            // to
            if (!EmptyValue($this->to->CurrentValue)) {
                $this->to->HrefValue = $this->to->getLinkPrefix() . $this->to->CurrentValue; // Add prefix/suffix
                $this->to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
                }
            } else {
                $this->to->HrefValue = "";
            }
            $this->to->TooltipValue = "";

            // to_other
            $this->to_other->HrefValue = "";

            // attention
            if (!EmptyValue($this->attention->CurrentValue)) {
                $this->attention->HrefValue = $this->attention->getLinkPrefix() . $this->attention->CurrentValue; // Add prefix/suffix
                $this->attention->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
                }
            } else {
                $this->attention->HrefValue = "";
            }

            // transfer_nature
            if (!EmptyValue($this->transfer_nature->CurrentValue)) {
                $this->transfer_nature->HrefValue = $this->transfer_nature->getLinkPrefix() . $this->transfer_nature->CurrentValue; // Add prefix/suffix
                $this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
                }
            } else {
                $this->transfer_nature->HrefValue = "";
            }
            $this->transfer_nature->TooltipValue = "";

            // due_date
            if (!EmptyValue($this->due_date->CurrentValue)) {
                $this->due_date->HrefValue = $this->due_date->getLinkPrefix() . $this->due_date->CurrentValue; // Add prefix/suffix
                $this->due_date->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
                }
            } else {
                $this->due_date->HrefValue = "";
            }
            $this->due_date->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }
            $this->item->TooltipValue = "";

            // sender_comments
            $this->sender_comments->HrefValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";

            // t_mode
            if (!EmptyValue($this->t_mode->CurrentValue)) {
                $this->t_mode->HrefValue = $this->t_mode->getLinkPrefix() . $this->t_mode->CurrentValue; // Add prefix/suffix
                $this->t_mode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
                }
            } else {
                $this->t_mode->HrefValue = "";
            }

            // t_distance
            if (!EmptyValue($this->t_distance->CurrentValue)) {
                $this->t_distance->HrefValue = $this->t_distance->getLinkPrefix() . $this->t_distance->CurrentValue; // Add prefix/suffix
                $this->t_distance->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_distance->HrefValue = FullUrl($this->t_distance->HrefValue, "href");
                }
            } else {
                $this->t_distance->HrefValue = "";
            }

            // t_v_no
            $this->t_v_no->HrefValue = "";

            // purpose
            $this->purpose->HrefValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // from
            $this->_from->setupEditAttributes();
            $curVal = trim(strval($this->_from->CurrentValue));
            if ($curVal != "") {
                $this->_from->ViewValue = $this->_from->lookupCacheOption($curVal);
            } else {
                $this->_from->ViewValue = $this->_from->Lookup !== null && is_array($this->_from->lookupOptions()) && count($this->_from->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_from->ViewValue !== null) { // Load from cache
                $this->_from->EditValue = array_values($this->_from->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->_from->CurrentValue, $this->_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->_from->getSelectFilter($this); // PHP
                $sqlWrk = $this->_from->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->_from->EditValue = $arwrk;
            }
            $this->_from->PlaceHolder = RemoveHtml($this->_from->caption());

            // from_po
            $curVal = trim(strval($this->from_po->CurrentValue));
            if ($curVal != "") {
                $this->from_po->ViewValue = $this->from_po->lookupCacheOption($curVal);
            } else {
                $this->from_po->ViewValue = $this->from_po->Lookup !== null && is_array($this->from_po->lookupOptions()) && count($this->from_po->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->from_po->ViewValue !== null) { // Load from cache
                $this->from_po->EditValue = array_values($this->from_po->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->from_po->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->from_po->CurrentValue, $this->from_po->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->from_po->getSelectFilter($this); // PHP
                $sqlWrk = $this->from_po->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->from_po->EditValue = $arwrk;
            }
            $this->from_po->PlaceHolder = RemoveHtml($this->from_po->caption());

            // to
            $this->to->setupEditAttributes();
            $curVal = trim(strval($this->to->CurrentValue));
            if ($curVal != "") {
                $this->to->ViewValue = $this->to->lookupCacheOption($curVal);
            } else {
                $this->to->ViewValue = $this->to->Lookup !== null && is_array($this->to->lookupOptions()) && count($this->to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->to->ViewValue !== null) { // Load from cache
                $this->to->EditValue = array_values($this->to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->to->CurrentValue, $this->to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->to->getSelectFilter($this); // PHP
                $sqlWrk = $this->to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->to->EditValue = $arwrk;
            }
            $this->to->PlaceHolder = RemoveHtml($this->to->caption());

            // to_other
            $this->to_other->setupEditAttributes();
            $this->to_other->EditValue = HtmlEncode($this->to_other->CurrentValue);
            $this->to_other->PlaceHolder = RemoveHtml($this->to_other->caption());

            // attention
            $this->attention->setupEditAttributes();
            $curVal = trim(strval($this->attention->CurrentValue));
            if ($curVal != "") {
                $this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
            } else {
                $this->attention->ViewValue = $this->attention->Lookup !== null && is_array($this->attention->lookupOptions()) && count($this->attention->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->attention->ViewValue !== null) { // Load from cache
                $this->attention->EditValue = array_values($this->attention->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->attention->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->attention->CurrentValue, $this->attention->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->attention->getSelectFilter($this); // PHP
                $sqlWrk = $this->attention->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->attention->EditValue = $arwrk;
            }
            $this->attention->PlaceHolder = RemoveHtml($this->attention->caption());

            // transfer_nature
            $this->transfer_nature->setupEditAttributes();
            $this->transfer_nature->EditValue = $this->transfer_nature->options(true);
            $this->transfer_nature->PlaceHolder = RemoveHtml($this->transfer_nature->caption());

            // due_date
            $this->due_date->setupEditAttributes();
            $this->due_date->EditValue = HtmlEncode(FormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern()));
            $this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->CurrentValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
            if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
                $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
            }

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->CurrentValue);
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // sender_comments
            $this->sender_comments->setupEditAttributes();
            if (!$this->sender_comments->Raw) {
                $this->sender_comments->CurrentValue = HtmlDecode($this->sender_comments->CurrentValue);
            }
            $this->sender_comments->EditValue = HtmlEncode($this->sender_comments->CurrentValue);
            $this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

            // despatch details
            $this->despatchdetails->setupEditAttributes();
            if (!$this->despatchdetails->Raw) {
                $this->despatchdetails->CurrentValue = HtmlDecode($this->despatchdetails->CurrentValue);
            }
            $this->despatchdetails->EditValue = HtmlEncode($this->despatchdetails->CurrentValue);
            $this->despatchdetails->PlaceHolder = RemoveHtml($this->despatchdetails->caption());

            // t_mode
            $this->t_mode->setupEditAttributes();
            $this->t_mode->EditValue = $this->t_mode->options(true);
            $this->t_mode->PlaceHolder = RemoveHtml($this->t_mode->caption());

            // t_distance
            $this->t_distance->setupEditAttributes();
            $this->t_distance->EditValue = $this->t_distance->CurrentValue;
            $this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());
            if (strval($this->t_distance->EditValue) != "" && is_numeric($this->t_distance->EditValue)) {
                $this->t_distance->EditValue = FormatNumber($this->t_distance->EditValue, null);
            }

            // t_v_no
            $this->t_v_no->setupEditAttributes();
            if (!$this->t_v_no->Raw) {
                $this->t_v_no->CurrentValue = HtmlDecode($this->t_v_no->CurrentValue);
            }
            $this->t_v_no->EditValue = HtmlEncode($this->t_v_no->CurrentValue);
            $this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

            // purpose
            $this->purpose->setupEditAttributes();
            if (!$this->purpose->Raw) {
                $this->purpose->CurrentValue = HtmlDecode($this->purpose->CurrentValue);
            }
            $this->purpose->EditValue = HtmlEncode($this->purpose->CurrentValue);
            $this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

            // operator

            // datetime

            // Add refer script

            // company_id
            $this->company_id->HrefValue = "";

            // from
            if (!EmptyValue($this->_from->CurrentValue)) {
                $this->_from->HrefValue = $this->_from->getLinkPrefix() . $this->_from->CurrentValue; // Add prefix/suffix
                $this->_from->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_from->HrefValue = FullUrl($this->_from->HrefValue, "href");
                }
            } else {
                $this->_from->HrefValue = "";
            }

            // from_po
            $this->from_po->HrefValue = "";

            // to
            if (!EmptyValue($this->to->CurrentValue)) {
                $this->to->HrefValue = $this->to->getLinkPrefix() . $this->to->CurrentValue; // Add prefix/suffix
                $this->to->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
                }
            } else {
                $this->to->HrefValue = "";
            }

            // to_other
            $this->to_other->HrefValue = "";

            // attention
            if (!EmptyValue($this->attention->CurrentValue)) {
                $this->attention->HrefValue = $this->attention->getLinkPrefix() . $this->attention->CurrentValue; // Add prefix/suffix
                $this->attention->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
                }
            } else {
                $this->attention->HrefValue = "";
            }

            // transfer_nature
            if (!EmptyValue($this->transfer_nature->CurrentValue)) {
                $this->transfer_nature->HrefValue = $this->transfer_nature->getLinkPrefix() . $this->transfer_nature->CurrentValue; // Add prefix/suffix
                $this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
                }
            } else {
                $this->transfer_nature->HrefValue = "";
            }

            // due_date
            if (!EmptyValue($this->due_date->CurrentValue)) {
                $this->due_date->HrefValue = $this->due_date->getLinkPrefix() . $this->due_date->CurrentValue; // Add prefix/suffix
                $this->due_date->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
                }
            } else {
                $this->due_date->HrefValue = "";
            }

            // jc_no
            $this->jc_no->HrefValue = "";

            // item
            if (!EmptyValue($this->item->CurrentValue)) {
                $this->item->HrefValue = $this->item->getLinkPrefix() . $this->item->CurrentValue; // Add prefix/suffix
                $this->item->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
                }
            } else {
                $this->item->HrefValue = "";
            }

            // sender_comments
            $this->sender_comments->HrefValue = "";

            // despatch details
            $this->despatchdetails->HrefValue = "";

            // t_mode
            if (!EmptyValue($this->t_mode->CurrentValue)) {
                $this->t_mode->HrefValue = $this->t_mode->getLinkPrefix() . $this->t_mode->CurrentValue; // Add prefix/suffix
                $this->t_mode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
                }
            } else {
                $this->t_mode->HrefValue = "";
            }

            // t_distance
            if (!EmptyValue($this->t_distance->CurrentValue)) {
                $this->t_distance->HrefValue = $this->t_distance->getLinkPrefix() . $this->t_distance->CurrentValue; // Add prefix/suffix
                $this->t_distance->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->t_distance->HrefValue = FullUrl($this->t_distance->HrefValue, "href");
                }
            } else {
                $this->t_distance->HrefValue = "";
            }

            // t_v_no
            $this->t_v_no->HrefValue = "";

            // purpose
            $this->purpose->HrefValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->_from->Visible && $this->_from->Required) {
                if (!$this->_from->IsDetailKey && EmptyValue($this->_from->FormValue)) {
                    $this->_from->addErrorMessage(str_replace("%s", $this->_from->caption(), $this->_from->RequiredErrorMessage));
                }
            }
            if ($this->from_po->Visible && $this->from_po->Required) {
                if ($this->from_po->FormValue == "") {
                    $this->from_po->addErrorMessage(str_replace("%s", $this->from_po->caption(), $this->from_po->RequiredErrorMessage));
                }
            }
            if ($this->to->Visible && $this->to->Required) {
                if (!$this->to->IsDetailKey && EmptyValue($this->to->FormValue)) {
                    $this->to->addErrorMessage(str_replace("%s", $this->to->caption(), $this->to->RequiredErrorMessage));
                }
            }
            if ($this->to_other->Visible && $this->to_other->Required) {
                if (!$this->to_other->IsDetailKey && EmptyValue($this->to_other->FormValue)) {
                    $this->to_other->addErrorMessage(str_replace("%s", $this->to_other->caption(), $this->to_other->RequiredErrorMessage));
                }
            }
            if ($this->attention->Visible && $this->attention->Required) {
                if (!$this->attention->IsDetailKey && EmptyValue($this->attention->FormValue)) {
                    $this->attention->addErrorMessage(str_replace("%s", $this->attention->caption(), $this->attention->RequiredErrorMessage));
                }
            }
            if ($this->transfer_nature->Visible && $this->transfer_nature->Required) {
                if (!$this->transfer_nature->IsDetailKey && EmptyValue($this->transfer_nature->FormValue)) {
                    $this->transfer_nature->addErrorMessage(str_replace("%s", $this->transfer_nature->caption(), $this->transfer_nature->RequiredErrorMessage));
                }
            }
            if ($this->due_date->Visible && $this->due_date->Required) {
                if (!$this->due_date->IsDetailKey && EmptyValue($this->due_date->FormValue)) {
                    $this->due_date->addErrorMessage(str_replace("%s", $this->due_date->caption(), $this->due_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->due_date->FormValue, $this->due_date->formatPattern())) {
                $this->due_date->addErrorMessage($this->due_date->getErrorMessage(false));
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_no->FormValue)) {
                $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->sender_comments->Visible && $this->sender_comments->Required) {
                if (!$this->sender_comments->IsDetailKey && EmptyValue($this->sender_comments->FormValue)) {
                    $this->sender_comments->addErrorMessage(str_replace("%s", $this->sender_comments->caption(), $this->sender_comments->RequiredErrorMessage));
                }
            }
            if ($this->despatchdetails->Visible && $this->despatchdetails->Required) {
                if (!$this->despatchdetails->IsDetailKey && EmptyValue($this->despatchdetails->FormValue)) {
                    $this->despatchdetails->addErrorMessage(str_replace("%s", $this->despatchdetails->caption(), $this->despatchdetails->RequiredErrorMessage));
                }
            }
            if ($this->t_mode->Visible && $this->t_mode->Required) {
                if (!$this->t_mode->IsDetailKey && EmptyValue($this->t_mode->FormValue)) {
                    $this->t_mode->addErrorMessage(str_replace("%s", $this->t_mode->caption(), $this->t_mode->RequiredErrorMessage));
                }
            }
            if ($this->t_distance->Visible && $this->t_distance->Required) {
                if (!$this->t_distance->IsDetailKey && EmptyValue($this->t_distance->FormValue)) {
                    $this->t_distance->addErrorMessage(str_replace("%s", $this->t_distance->caption(), $this->t_distance->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->t_distance->FormValue)) {
                $this->t_distance->addErrorMessage($this->t_distance->getErrorMessage(false));
            }
            if ($this->t_v_no->Visible && $this->t_v_no->Required) {
                if (!$this->t_v_no->IsDetailKey && EmptyValue($this->t_v_no->FormValue)) {
                    $this->t_v_no->addErrorMessage(str_replace("%s", $this->t_v_no->caption(), $this->t_v_no->RequiredErrorMessage));
                }
            }
            if ($this->purpose->Visible && $this->purpose->Required) {
                if (!$this->purpose->IsDetailKey && EmptyValue($this->purpose->FormValue)) {
                    $this->purpose->addErrorMessage(str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // from
        $this->_from->setDbValueDef($rsnew, $this->_from->CurrentValue, false);

        // from_po
        $this->from_po->setDbValueDef($rsnew, $this->from_po->CurrentValue, false);

        // to
        $this->to->setDbValueDef($rsnew, $this->to->CurrentValue, false);

        // to_other
        $this->to_other->setDbValueDef($rsnew, $this->to_other->CurrentValue, false);

        // attention
        $this->attention->setDbValueDef($rsnew, $this->attention->CurrentValue, false);

        // transfer_nature
        $this->transfer_nature->setDbValueDef($rsnew, $this->transfer_nature->CurrentValue, false);

        // due_date
        $this->due_date->setDbValueDef($rsnew, UnFormatDateTime($this->due_date->CurrentValue, $this->due_date->formatPattern()), false);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, false);

        // item
        $this->item->setDbValueDef($rsnew, $this->item->CurrentValue, false);

        // sender_comments
        $this->sender_comments->setDbValueDef($rsnew, $this->sender_comments->CurrentValue, false);

        // despatch details
        $this->despatchdetails->setDbValueDef($rsnew, $this->despatchdetails->CurrentValue, false);

        // t_mode
        $this->t_mode->setDbValueDef($rsnew, $this->t_mode->CurrentValue, false);

        // t_distance
        $this->t_distance->setDbValueDef($rsnew, $this->t_distance->CurrentValue, false);

        // t_v_no
        $this->t_v_no->setDbValueDef($rsnew, $this->t_v_no->CurrentValue, false);

        // purpose
        $this->purpose->setDbValueDef($rsnew, $this->purpose->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['from'])) { // from
            $this->_from->setFormValue($row['from']);
        }
        if (isset($row['from_po'])) { // from_po
            $this->from_po->setFormValue($row['from_po']);
        }
        if (isset($row['to'])) { // to
            $this->to->setFormValue($row['to']);
        }
        if (isset($row['to_other'])) { // to_other
            $this->to_other->setFormValue($row['to_other']);
        }
        if (isset($row['attention'])) { // attention
            $this->attention->setFormValue($row['attention']);
        }
        if (isset($row['transfer_nature'])) { // transfer_nature
            $this->transfer_nature->setFormValue($row['transfer_nature']);
        }
        if (isset($row['due_date'])) { // due_date
            $this->due_date->setFormValue($row['due_date']);
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->setFormValue($row['jc_no']);
        }
        if (isset($row['item'])) { // item
            $this->item->setFormValue($row['item']);
        }
        if (isset($row['sender_comments'])) { // sender_comments
            $this->sender_comments->setFormValue($row['sender_comments']);
        }
        if (isset($row['despatch details'])) { // despatch details
            $this->despatchdetails->setFormValue($row['despatch details']);
        }
        if (isset($row['t_mode'])) { // t_mode
            $this->t_mode->setFormValue($row['t_mode']);
        }
        if (isset($row['t_distance'])) { // t_distance
            $this->t_distance->setFormValue($row['t_distance']);
        }
        if (isset($row['t_v_no'])) { // t_v_no
            $this->t_v_no->setFormValue($row['t_v_no']);
        }
        if (isset($row['purpose'])) { // purpose
            $this->purpose->setFormValue($row['purpose']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("gatepasslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__from":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_from_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_attention":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_transfer_nature":
                    break;
                case "x_t_mode":
                    break;
                case "x_operator":
                    break;
                case "x_receiving_condition":
                    break;
                case "x_r_operator":
                    break;
                case "x_r_e_user_id":
                    break;
                case "x_group":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    		IF (isset($_GET["CID"]))
    		{
    		$this->_from->ReadOnly = True;
    		$this->to->ReadOnly = True;
    		$this->item->ReadOnly = True;
    		$this->transfer_nature->ReadOnly = True;
    		}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        extract($_POST,EXTR_OVERWRITE);
        $_SESSION[SESSION_WARNING_MESSAGE] = '';
        if ( ($x_to == 0) && ($x_to_other == null) )
             $_SESSION[SESSION_WARNING_MESSAGE] .= 'Please provide additional information for the "Other Address" field.';
        // Return error message in $customError
    	if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    		{return TRUE;}
    	else
    		{return FALSE;}
    }
}
