<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FamilyInfoAdd extends FamilyInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FamilyInfoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "familyinfoadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->family_personal->setVisibility();
        $this->father_name->Visible = false;
        $this->family_id->setVisibility();
        $this->lifecycle->setVisibility();
        $this->gender->setVisibility();
        $this->_title->setVisibility();
        $this->marital_status->setVisibility();
        $this->name->setVisibility();
        $this->mobile->setVisibility();
        $this->spouse_name->setVisibility();
        $this->mobile_spouse->setVisibility();
        $this->_email->setVisibility();
        $this->category->setVisibility();
        $this->event->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->address->setVisibility();
        $this->country->setVisibility();
        $this->state->setVisibility();
        $this->city_india->Visible = false;
        $this->city->Visible = false;
        $this->city_name->setVisibility();
        $this->image->Visible = false;
        $this->work_details->setVisibility();
        $this->sequence->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->status->setVisibility();
        $this->sort_order->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'family_info';
        $this->TableName = 'family_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (family_info)
        if (!isset($GLOBALS["family_info"]) || $GLOBALS["family_info"]::class == PROJECT_NAMESPACE . "family_info") {
            $GLOBALS["family_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'family_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "familyinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->family_personal);
        $this->setupLookupOptions($this->family_id);
        $this->setupLookupOptions($this->lifecycle);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->_title);
        $this->setupLookupOptions($this->marital_status);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->event);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->state);
        $this->setupLookupOptions($this->city_india);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("familyinfolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "familyinfolist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "familyinfoview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "familyinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "familyinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->family_personal->DefaultValue = $this->family_personal->getDefault(); // PHP
        $this->family_personal->OldValue = $this->family_personal->DefaultValue;
        $this->lifecycle->DefaultValue = $this->lifecycle->getDefault(); // PHP
        $this->lifecycle->OldValue = $this->lifecycle->DefaultValue;
        $this->gender->DefaultValue = $this->gender->getDefault(); // PHP
        $this->gender->OldValue = $this->gender->DefaultValue;
        $this->_title->DefaultValue = $this->_title->getDefault(); // PHP
        $this->_title->OldValue = $this->_title->DefaultValue;
        $this->category->DefaultValue = $this->category->getDefault(); // PHP
        $this->category->OldValue = $this->category->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");

        // Check field name 'family_personal' first before field var 'x_family_personal'
        $val = $CurrentForm->hasValue("family_personal") ? $CurrentForm->getValue("family_personal") : $CurrentForm->getValue("x_family_personal");
        if (!$this->family_personal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->family_personal->Visible = false; // Disable update for API request
            } else {
                $this->family_personal->setFormValue($val);
            }
        }

        // Check field name 'family_id' first before field var 'x_family_id'
        $val = $CurrentForm->hasValue("family_id") ? $CurrentForm->getValue("family_id") : $CurrentForm->getValue("x_family_id");
        if (!$this->family_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->family_id->Visible = false; // Disable update for API request
            } else {
                $this->family_id->setFormValue($val);
            }
        }

        // Check field name 'lifecycle' first before field var 'x_lifecycle'
        $val = $CurrentForm->hasValue("lifecycle") ? $CurrentForm->getValue("lifecycle") : $CurrentForm->getValue("x_lifecycle");
        if (!$this->lifecycle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lifecycle->Visible = false; // Disable update for API request
            } else {
                $this->lifecycle->setFormValue($val);
            }
        }

        // Check field name 'gender' first before field var 'x_gender'
        $val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
        if (!$this->gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gender->Visible = false; // Disable update for API request
            } else {
                $this->gender->setFormValue($val);
            }
        }

        // Check field name 'title' first before field var 'x__title'
        $val = $CurrentForm->hasValue("title") ? $CurrentForm->getValue("title") : $CurrentForm->getValue("x__title");
        if (!$this->_title->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_title->Visible = false; // Disable update for API request
            } else {
                $this->_title->setFormValue($val);
            }
        }

        // Check field name 'marital_status' first before field var 'x_marital_status'
        $val = $CurrentForm->hasValue("marital_status") ? $CurrentForm->getValue("marital_status") : $CurrentForm->getValue("x_marital_status");
        if (!$this->marital_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->marital_status->Visible = false; // Disable update for API request
            } else {
                $this->marital_status->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'spouse_name' first before field var 'x_spouse_name'
        $val = $CurrentForm->hasValue("spouse_name") ? $CurrentForm->getValue("spouse_name") : $CurrentForm->getValue("x_spouse_name");
        if (!$this->spouse_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->spouse_name->Visible = false; // Disable update for API request
            } else {
                $this->spouse_name->setFormValue($val);
            }
        }

        // Check field name 'mobile_spouse' first before field var 'x_mobile_spouse'
        $val = $CurrentForm->hasValue("mobile_spouse") ? $CurrentForm->getValue("mobile_spouse") : $CurrentForm->getValue("x_mobile_spouse");
        if (!$this->mobile_spouse->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_spouse->Visible = false; // Disable update for API request
            } else {
                $this->mobile_spouse->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'event' first before field var 'x_event'
        $val = $CurrentForm->hasValue("event") ? $CurrentForm->getValue("event") : $CurrentForm->getValue("x_event");
        if (!$this->event->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event->Visible = false; // Disable update for API request
            } else {
                $this->event->setFormValue($val);
            }
        }

        // Check field name 'dob' first before field var 'x_dob'
        $val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
        if (!$this->dob->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dob->Visible = false; // Disable update for API request
            } else {
                $this->dob->setFormValue($val, true, $validate);
            }
            $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        }

        // Check field name 'dom' first before field var 'x_dom'
        $val = $CurrentForm->hasValue("dom") ? $CurrentForm->getValue("dom") : $CurrentForm->getValue("x_dom");
        if (!$this->dom->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dom->Visible = false; // Disable update for API request
            } else {
                $this->dom->setFormValue($val, true, $validate);
            }
            $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->country->Visible = false; // Disable update for API request
            } else {
                $this->country->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'state' first before field var 'x_state'
        $val = $CurrentForm->hasValue("state") ? $CurrentForm->getValue("state") : $CurrentForm->getValue("x_state");
        if (!$this->state->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->state->Visible = false; // Disable update for API request
            } else {
                $this->state->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'city_name' first before field var 'x_city_name'
        $val = $CurrentForm->hasValue("city_name") ? $CurrentForm->getValue("city_name") : $CurrentForm->getValue("x_city_name");
        if (!$this->city_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city_name->Visible = false; // Disable update for API request
            } else {
                $this->city_name->setFormValue($val);
            }
        }

        // Check field name 'work_details' first before field var 'x_work_details'
        $val = $CurrentForm->hasValue("work_details") ? $CurrentForm->getValue("work_details") : $CurrentForm->getValue("x_work_details");
        if (!$this->work_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->work_details->Visible = false; // Disable update for API request
            } else {
                $this->work_details->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->family_personal->CurrentValue = $this->family_personal->FormValue;
        $this->family_id->CurrentValue = $this->family_id->FormValue;
        $this->lifecycle->CurrentValue = $this->lifecycle->FormValue;
        $this->gender->CurrentValue = $this->gender->FormValue;
        $this->_title->CurrentValue = $this->_title->FormValue;
        $this->marital_status->CurrentValue = $this->marital_status->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->spouse_name->CurrentValue = $this->spouse_name->FormValue;
        $this->mobile_spouse->CurrentValue = $this->mobile_spouse->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->event->CurrentValue = $this->event->FormValue;
        $this->dob->CurrentValue = $this->dob->FormValue;
        $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->dom->CurrentValue = $this->dom->FormValue;
        $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        $this->address->CurrentValue = $this->address->FormValue;
        $this->country->CurrentValue = $this->country->FormValue;
        $this->state->CurrentValue = $this->state->FormValue;
        $this->city_name->CurrentValue = $this->city_name->FormValue;
        $this->work_details->CurrentValue = $this->work_details->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->status->CurrentValue = $this->status->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->family_personal->setDbValue($row['family_personal']);
        $this->father_name->setDbValue($row['father_name']);
        $this->family_id->setDbValue($row['family_id']);
        $this->lifecycle->setDbValue($row['lifecycle']);
        $this->gender->setDbValue($row['gender']);
        $this->_title->setDbValue($row['title']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->name->setDbValue($row['name']);
        $this->mobile->setDbValue($row['mobile']);
        $this->spouse_name->setDbValue($row['spouse_name']);
        $this->mobile_spouse->setDbValue($row['mobile_spouse']);
        $this->_email->setDbValue($row['email']);
        $this->category->setDbValue($row['category']);
        $this->event->setDbValue($row['event']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->address->setDbValue($row['address']);
        $this->country->setDbValue($row['country']);
        $this->state->setDbValue($row['state']);
        $this->city_india->setDbValue($row['city_india']);
        $this->city->setDbValue($row['city']);
        $this->city_name->setDbValue($row['city_name']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->work_details->setDbValue($row['work_details']);
        $this->sequence->setDbValue($row['sequence']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->status->setDbValue($row['status']);
        $this->sort_order->setDbValue($row['sort_order']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['family_personal'] = $this->family_personal->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['family_id'] = $this->family_id->DefaultValue;
        $row['lifecycle'] = $this->lifecycle->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['title'] = $this->_title->DefaultValue;
        $row['marital_status'] = $this->marital_status->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['spouse_name'] = $this->spouse_name->DefaultValue;
        $row['mobile_spouse'] = $this->mobile_spouse->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['event'] = $this->event->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['dom'] = $this->dom->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['state'] = $this->state->DefaultValue;
        $row['city_india'] = $this->city_india->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['work_details'] = $this->work_details->DefaultValue;
        $row['sequence'] = $this->sequence->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['sort_order'] = $this->sort_order->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // family_personal
        $this->family_personal->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // family_id
        $this->family_id->RowCssClass = "row";

        // lifecycle
        $this->lifecycle->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // title
        $this->_title->RowCssClass = "row";

        // marital_status
        $this->marital_status->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // spouse_name
        $this->spouse_name->RowCssClass = "row";

        // mobile_spouse
        $this->mobile_spouse->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // event
        $this->event->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // dom
        $this->dom->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // state
        $this->state->RowCssClass = "row";

        // city_india
        $this->city_india->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // work_details
        $this->work_details->RowCssClass = "row";

        // sequence
        $this->sequence->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // sort_order
        $this->sort_order->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // family_personal
            if (strval($this->family_personal->CurrentValue) != "") {
                $this->family_personal->ViewValue = $this->family_personal->optionCaption($this->family_personal->CurrentValue);
            } else {
                $this->family_personal->ViewValue = null;
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // family_id
            $this->family_id->ViewValue = $this->family_id->CurrentValue;
            $curVal = strval($this->family_id->CurrentValue);
            if ($curVal != "") {
                $this->family_id->ViewValue = $this->family_id->lookupCacheOption($curVal);
                if ($this->family_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->family_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->family_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->family_id->Lookup->renderViewRow($rswrk[0]);
                        $this->family_id->ViewValue = $this->family_id->displayValue($arwrk);
                    } else {
                        $this->family_id->ViewValue = $this->family_id->CurrentValue;
                    }
                }
            } else {
                $this->family_id->ViewValue = null;
            }

            // lifecycle
            if (strval($this->lifecycle->CurrentValue) != "") {
                $this->lifecycle->ViewValue = $this->lifecycle->optionCaption($this->lifecycle->CurrentValue);
            } else {
                $this->lifecycle->ViewValue = null;
            }

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // title
            if (strval($this->_title->CurrentValue) != "") {
                $this->_title->ViewValue = $this->_title->optionCaption($this->_title->CurrentValue);
            } else {
                $this->_title->ViewValue = null;
            }

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // spouse_name
            $this->spouse_name->ViewValue = $this->spouse_name->CurrentValue;

            // mobile_spouse
            $this->mobile_spouse->ViewValue = $this->mobile_spouse->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->category->Lookup->renderViewRow($row);
                            $this->category->ViewValue->add($this->category->displayValue($arwrk));
                        }
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // event
            $curVal = strval($this->event->CurrentValue);
            if ($curVal != "") {
                $this->event->ViewValue = $this->event->lookupCacheOption($curVal);
                if ($this->event->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->event->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->event->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->event->getSelectFilter($this); // PHP
                    $sqlWrk = $this->event->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->event->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->event->Lookup->renderViewRow($row);
                            $this->event->ViewValue->add($this->event->displayValue($arwrk));
                        }
                    } else {
                        $this->event->ViewValue = $this->event->CurrentValue;
                    }
                }
            } else {
                $this->event->ViewValue = null;
            }

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // country
            $this->country->ViewValue = $this->country->CurrentValue;
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // state
            $this->state->ViewValue = $this->state->CurrentValue;
            $curVal = strval($this->state->CurrentValue);
            if ($curVal != "") {
                $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
                if ($this->state->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->state->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->state->Lookup->renderViewRow($rswrk[0]);
                        $this->state->ViewValue = $this->state->displayValue($arwrk);
                    } else {
                        $this->state->ViewValue = FormatNumber($this->state->CurrentValue, $this->state->formatPattern());
                    }
                }
            } else {
                $this->state->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // work_details
            $this->work_details->ViewValue = $this->work_details->CurrentValue;

            // sequence
            $this->sequence->ViewValue = $this->sequence->CurrentValue;
            $this->sequence->ViewValue = FormatNumber($this->sequence->ViewValue, $this->sequence->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // sort_order
            $this->sort_order->ViewValue = $this->sort_order->CurrentValue;
            $this->sort_order->ViewValue = FormatNumber($this->sort_order->ViewValue, $this->sort_order->formatPattern());

            // id
            $this->id->HrefValue = "";

            // family_personal
            $this->family_personal->HrefValue = "";

            // family_id
            $this->family_id->HrefValue = "";

            // lifecycle
            $this->lifecycle->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // title
            $this->_title->HrefValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // spouse_name
            $this->spouse_name->HrefValue = "";

            // mobile_spouse
            $this->mobile_spouse->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // event
            $this->event->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // dom
            $this->dom->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // state
            $this->state->HrefValue = "";

            // city_name
            $this->city_name->HrefValue = "";

            // work_details
            $this->work_details->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // status
            $this->status->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // family_personal
            $this->family_personal->EditValue = $this->family_personal->options(false);
            $this->family_personal->PlaceHolder = RemoveHtml($this->family_personal->caption());

            // family_id
            $this->family_id->setupEditAttributes();
            if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("add")) { // Non system admin
                $this->family_id->CurrentValue = EmptyValue($this->family_id->CurrentValue) ? CurrentUserID() : $this->family_id->CurrentValue;
                if (trim(strval($this->family_id->CurrentValue)) == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->family_id->CurrentValue, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->family_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->family_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll();
                $arwrk = $rswrk;
                $this->family_id->EditValue = $arwrk;
            } else {
                $this->family_id->EditValue = $this->family_id->CurrentValue;
                $curVal = strval($this->family_id->CurrentValue);
                if ($curVal != "") {
                    $this->family_id->EditValue = $this->family_id->lookupCacheOption($curVal);
                    if ($this->family_id->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->family_id->getSelectFilter($this); // PHP
                        $sqlWrk = $this->family_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->family_id->Lookup->renderViewRow($rswrk[0]);
                            $this->family_id->EditValue = $this->family_id->displayValue($arwrk);
                        } else {
                            $this->family_id->EditValue = HtmlEncode($this->family_id->CurrentValue);
                        }
                    }
                } else {
                    $this->family_id->EditValue = null;
                }
                $this->family_id->PlaceHolder = RemoveHtml($this->family_id->caption());
            }

            // lifecycle
            $this->lifecycle->EditValue = $this->lifecycle->options(false);
            $this->lifecycle->PlaceHolder = RemoveHtml($this->lifecycle->caption());

            // gender
            $this->gender->EditValue = $this->gender->options(false);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // title
            $this->_title->EditValue = $this->_title->options(false);
            $this->_title->PlaceHolder = RemoveHtml($this->_title->caption());

            // marital_status
            $this->marital_status->EditValue = $this->marital_status->options(false);
            $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
            }

            // spouse_name
            $this->spouse_name->setupEditAttributes();
            if (!$this->spouse_name->Raw) {
                $this->spouse_name->CurrentValue = HtmlDecode($this->spouse_name->CurrentValue);
            }
            $this->spouse_name->EditValue = HtmlEncode($this->spouse_name->CurrentValue);
            $this->spouse_name->PlaceHolder = RemoveHtml($this->spouse_name->caption());

            // mobile_spouse
            $this->mobile_spouse->setupEditAttributes();
            if (!$this->mobile_spouse->Raw) {
                $this->mobile_spouse->CurrentValue = HtmlDecode($this->mobile_spouse->CurrentValue);
            }
            $this->mobile_spouse->EditValue = HtmlEncode($this->mobile_spouse->CurrentValue);
            $this->mobile_spouse->PlaceHolder = RemoveHtml($this->mobile_spouse->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // category
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // event
            $curVal = trim(strval($this->event->CurrentValue));
            if ($curVal != "") {
                $this->event->ViewValue = $this->event->lookupCacheOption($curVal);
            } else {
                $this->event->ViewValue = $this->event->Lookup !== null && is_array($this->event->lookupOptions()) && count($this->event->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->event->ViewValue !== null) { // Load from cache
                $this->event->EditValue = array_values($this->event->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->event->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->event->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->event->getSelectFilter($this); // PHP
                $sqlWrk = $this->event->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->event->EditValue = $arwrk;
            }
            $this->event->PlaceHolder = RemoveHtml($this->event->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // dom
            $this->dom->setupEditAttributes();
            $this->dom->EditValue = HtmlEncode(FormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()));
            $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // country
            $this->country->setupEditAttributes();
            $this->country->EditValue = $this->country->CurrentValue;
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->EditValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->EditValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->EditValue = HtmlEncode(FormatNumber($this->country->CurrentValue, $this->country->formatPattern()));
                    }
                }
            } else {
                $this->country->EditValue = null;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // state
            $this->state->setupEditAttributes();
            $this->state->EditValue = $this->state->CurrentValue;
            $curVal = strval($this->state->CurrentValue);
            if ($curVal != "") {
                $this->state->EditValue = $this->state->lookupCacheOption($curVal);
                if ($this->state->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->state->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->state->Lookup->renderViewRow($rswrk[0]);
                        $this->state->EditValue = $this->state->displayValue($arwrk);
                    } else {
                        $this->state->EditValue = HtmlEncode(FormatNumber($this->state->CurrentValue, $this->state->formatPattern()));
                    }
                }
            } else {
                $this->state->EditValue = null;
            }
            $this->state->PlaceHolder = RemoveHtml($this->state->caption());

            // city_name
            $this->city_name->setupEditAttributes();
            if (!$this->city_name->Raw) {
                $this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
            }
            $this->city_name->EditValue = HtmlEncode($this->city_name->CurrentValue);
            $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

            // work_details
            $this->work_details->setupEditAttributes();
            $this->work_details->EditValue = HtmlEncode($this->work_details->CurrentValue);
            $this->work_details->PlaceHolder = RemoveHtml($this->work_details->caption());

            // operator

            // datetime

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // family_personal
            $this->family_personal->HrefValue = "";

            // family_id
            $this->family_id->HrefValue = "";

            // lifecycle
            $this->lifecycle->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // title
            $this->_title->HrefValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // spouse_name
            $this->spouse_name->HrefValue = "";

            // mobile_spouse
            $this->mobile_spouse->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // event
            $this->event->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // dom
            $this->dom->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // state
            $this->state->HrefValue = "";

            // city_name
            $this->city_name->HrefValue = "";

            // work_details
            $this->work_details->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // status
            $this->status->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->family_personal->Visible && $this->family_personal->Required) {
                if ($this->family_personal->FormValue == "") {
                    $this->family_personal->addErrorMessage(str_replace("%s", $this->family_personal->caption(), $this->family_personal->RequiredErrorMessage));
                }
            }
            if ($this->family_id->Visible && $this->family_id->Required) {
                if (!$this->family_id->IsDetailKey && EmptyValue($this->family_id->FormValue)) {
                    $this->family_id->addErrorMessage(str_replace("%s", $this->family_id->caption(), $this->family_id->RequiredErrorMessage));
                }
            }
            if ($this->lifecycle->Visible && $this->lifecycle->Required) {
                if ($this->lifecycle->FormValue == "") {
                    $this->lifecycle->addErrorMessage(str_replace("%s", $this->lifecycle->caption(), $this->lifecycle->RequiredErrorMessage));
                }
            }
            if ($this->gender->Visible && $this->gender->Required) {
                if ($this->gender->FormValue == "") {
                    $this->gender->addErrorMessage(str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
                }
            }
            if ($this->_title->Visible && $this->_title->Required) {
                if ($this->_title->FormValue == "") {
                    $this->_title->addErrorMessage(str_replace("%s", $this->_title->caption(), $this->_title->RequiredErrorMessage));
                }
            }
            if ($this->marital_status->Visible && $this->marital_status->Required) {
                if ($this->marital_status->FormValue == "") {
                    $this->marital_status->addErrorMessage(str_replace("%s", $this->marital_status->caption(), $this->marital_status->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->mobile->FormValue)) {
                $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
            }
            if ($this->spouse_name->Visible && $this->spouse_name->Required) {
                if (!$this->spouse_name->IsDetailKey && EmptyValue($this->spouse_name->FormValue)) {
                    $this->spouse_name->addErrorMessage(str_replace("%s", $this->spouse_name->caption(), $this->spouse_name->RequiredErrorMessage));
                }
            }
            if ($this->mobile_spouse->Visible && $this->mobile_spouse->Required) {
                if (!$this->mobile_spouse->IsDetailKey && EmptyValue($this->mobile_spouse->FormValue)) {
                    $this->mobile_spouse->addErrorMessage(str_replace("%s", $this->mobile_spouse->caption(), $this->mobile_spouse->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_email->FormValue)) {
                $this->_email->addErrorMessage($this->_email->getErrorMessage(false));
            }
            if ($this->category->Visible && $this->category->Required) {
                if ($this->category->FormValue == "") {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->event->Visible && $this->event->Required) {
                if ($this->event->FormValue == "") {
                    $this->event->addErrorMessage(str_replace("%s", $this->event->caption(), $this->event->RequiredErrorMessage));
                }
            }
            if ($this->dob->Visible && $this->dob->Required) {
                if (!$this->dob->IsDetailKey && EmptyValue($this->dob->FormValue)) {
                    $this->dob->addErrorMessage(str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dob->FormValue, $this->dob->formatPattern())) {
                $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
            }
            if ($this->dom->Visible && $this->dom->Required) {
                if (!$this->dom->IsDetailKey && EmptyValue($this->dom->FormValue)) {
                    $this->dom->addErrorMessage(str_replace("%s", $this->dom->caption(), $this->dom->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dom->FormValue, $this->dom->formatPattern())) {
                $this->dom->addErrorMessage($this->dom->getErrorMessage(false));
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if (!$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->country->FormValue)) {
                $this->country->addErrorMessage($this->country->getErrorMessage(false));
            }
            if ($this->state->Visible && $this->state->Required) {
                if (!$this->state->IsDetailKey && EmptyValue($this->state->FormValue)) {
                    $this->state->addErrorMessage(str_replace("%s", $this->state->caption(), $this->state->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->state->FormValue)) {
                $this->state->addErrorMessage($this->state->getErrorMessage(false));
            }
            if ($this->city_name->Visible && $this->city_name->Required) {
                if (!$this->city_name->IsDetailKey && EmptyValue($this->city_name->FormValue)) {
                    $this->city_name->addErrorMessage(str_replace("%s", $this->city_name->caption(), $this->city_name->RequiredErrorMessage));
                }
            }
            if ($this->work_details->Visible && $this->work_details->Required) {
                if (!$this->work_details->IsDetailKey && EmptyValue($this->work_details->FormValue)) {
                    $this->work_details->addErrorMessage(str_replace("%s", $this->work_details->caption(), $this->work_details->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check if valid User ID
        if (
            !EmptyValue($Security->currentUserID()) &&
            !$Security->isAdmin() && // Non system admin
            !$Security->isValidUserID($this->family_id->CurrentValue)
        ) {
            $userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
            $userIdMsg = str_replace("%u", strval($this->family_id->CurrentValue), $userIdMsg);
            $this->setFailureMessage($userIdMsg);
            return false;
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // family_personal
        $this->family_personal->setDbValueDef($rsnew, $this->family_personal->CurrentValue, strval($this->family_personal->CurrentValue) == "");

        // family_id
        $this->family_id->setDbValueDef($rsnew, $this->family_id->CurrentValue, false);

        // lifecycle
        $this->lifecycle->setDbValueDef($rsnew, $this->lifecycle->CurrentValue, false);

        // gender
        $this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, false);

        // title
        $this->_title->setDbValueDef($rsnew, $this->_title->CurrentValue, false);

        // marital_status
        $this->marital_status->setDbValueDef($rsnew, $this->marital_status->CurrentValue, false);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // spouse_name
        $this->spouse_name->setDbValueDef($rsnew, $this->spouse_name->CurrentValue, false);

        // mobile_spouse
        $this->mobile_spouse->setDbValueDef($rsnew, $this->mobile_spouse->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, strval($this->category->CurrentValue) == "");

        // event
        $this->event->setDbValueDef($rsnew, $this->event->CurrentValue, false);

        // dob
        $this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()), false);

        // dom
        $this->dom->setDbValueDef($rsnew, UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()), false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // country
        $this->country->setDbValueDef($rsnew, $this->country->CurrentValue, false);

        // state
        $this->state->setDbValueDef($rsnew, $this->state->CurrentValue, false);

        // city_name
        $this->city_name->setDbValueDef($rsnew, $this->city_name->CurrentValue, false);

        // work_details
        $this->work_details->setDbValueDef($rsnew, $this->work_details->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, strval($this->status->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['family_personal'])) { // family_personal
            $this->family_personal->setFormValue($row['family_personal']);
        }
        if (isset($row['family_id'])) { // family_id
            $this->family_id->setFormValue($row['family_id']);
        }
        if (isset($row['lifecycle'])) { // lifecycle
            $this->lifecycle->setFormValue($row['lifecycle']);
        }
        if (isset($row['gender'])) { // gender
            $this->gender->setFormValue($row['gender']);
        }
        if (isset($row['title'])) { // title
            $this->_title->setFormValue($row['title']);
        }
        if (isset($row['marital_status'])) { // marital_status
            $this->marital_status->setFormValue($row['marital_status']);
        }
        if (isset($row['name'])) { // name
            $this->name->setFormValue($row['name']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['spouse_name'])) { // spouse_name
            $this->spouse_name->setFormValue($row['spouse_name']);
        }
        if (isset($row['mobile_spouse'])) { // mobile_spouse
            $this->mobile_spouse->setFormValue($row['mobile_spouse']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['category'])) { // category
            $this->category->setFormValue($row['category']);
        }
        if (isset($row['event'])) { // event
            $this->event->setFormValue($row['event']);
        }
        if (isset($row['dob'])) { // dob
            $this->dob->setFormValue($row['dob']);
        }
        if (isset($row['dom'])) { // dom
            $this->dom->setFormValue($row['dom']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['country'])) { // country
            $this->country->setFormValue($row['country']);
        }
        if (isset($row['state'])) { // state
            $this->state->setFormValue($row['state']);
        }
        if (isset($row['city_name'])) { // city_name
            $this->city_name->setFormValue($row['city_name']);
        }
        if (isset($row['work_details'])) { // work_details
            $this->work_details->setFormValue($row['work_details']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->family_id->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("familyinfolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_family_personal":
                    break;
                case "x_family_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lifecycle":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_gender":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__title":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_marital_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_event":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_country":
                    break;
                case "x_state":
                    break;
                case "x_city_india":
                    break;
                case "x_city":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'family_info');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) {
    	// Return error message in CustomError
    extract($_POST,EXTR_OVERWRITE);
    $_SESSION[SESSION_WARNING_MESSAGE] = '';
        if  (($x_family_personal < 2) && ($x_family_id == NULL))
        {
        $_SESSION[SESSION_WARNING_MESSAGE].= 'Selecting the Father\'s Name is mandatory in both "Primary Info (Family)" and "Detailed Info (Family)<br>';
        }
        if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
        {return TRUE;}
        else
        {return FALSE;}
    }
}
