<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FamilyEventEstimateSearch extends FamilyEventEstimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FamilyEventEstimateSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "familyeventestimatesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->family_id->setVisibility();
        $this->event_id->setVisibility();
        $this->event_1->setVisibility();
        $this->event_2->setVisibility();
        $this->event_3->setVisibility();
        $this->event_4->setVisibility();
        $this->event_5->setVisibility();
        $this->event_6->setVisibility();
        $this->event_7->setVisibility();
        $this->event_8->setVisibility();
        $this->event_9->setVisibility();
        $this->event_10->setVisibility();
        $this->event_11->setVisibility();
        $this->event_12->setVisibility();
        $this->event_13->setVisibility();
        $this->event_14->setVisibility();
        $this->event_15->setVisibility();
        $this->event_16->setVisibility();
        $this->event_17->setVisibility();
        $this->event_18->setVisibility();
        $this->event_19->setVisibility();
        $this->event_20->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'family_event_estimate';
        $this->TableName = 'family_event_estimate';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (family_event_estimate)
        if (!isset($GLOBALS["family_event_estimate"]) || $GLOBALS["family_event_estimate"]::class == PROJECT_NAMESPACE . "family_event_estimate") {
            $GLOBALS["family_event_estimate"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'family_event_estimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "familyeventestimateview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->family_id);
        $this->setupLookupOptions($this->event_id);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "familyeventestimatelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->family_id); // family_id
        $this->buildSearchUrl($srchUrl, $this->event_id); // event_id
        $this->buildSearchUrl($srchUrl, $this->event_1); // event_1
        $this->buildSearchUrl($srchUrl, $this->event_2); // event_2
        $this->buildSearchUrl($srchUrl, $this->event_3); // event_3
        $this->buildSearchUrl($srchUrl, $this->event_4); // event_4
        $this->buildSearchUrl($srchUrl, $this->event_5); // event_5
        $this->buildSearchUrl($srchUrl, $this->event_6); // event_6
        $this->buildSearchUrl($srchUrl, $this->event_7); // event_7
        $this->buildSearchUrl($srchUrl, $this->event_8); // event_8
        $this->buildSearchUrl($srchUrl, $this->event_9); // event_9
        $this->buildSearchUrl($srchUrl, $this->event_10); // event_10
        $this->buildSearchUrl($srchUrl, $this->event_11); // event_11
        $this->buildSearchUrl($srchUrl, $this->event_12); // event_12
        $this->buildSearchUrl($srchUrl, $this->event_13); // event_13
        $this->buildSearchUrl($srchUrl, $this->event_14); // event_14
        $this->buildSearchUrl($srchUrl, $this->event_15); // event_15
        $this->buildSearchUrl($srchUrl, $this->event_16); // event_16
        $this->buildSearchUrl($srchUrl, $this->event_17); // event_17
        $this->buildSearchUrl($srchUrl, $this->event_18); // event_18
        $this->buildSearchUrl($srchUrl, $this->event_19); // event_19
        $this->buildSearchUrl($srchUrl, $this->event_20); // event_20
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // family_id
        if ($this->family_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_id
        if ($this->event_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_1
        if ($this->event_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_2
        if ($this->event_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_3
        if ($this->event_3->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_4
        if ($this->event_4->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_5
        if ($this->event_5->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_6
        if ($this->event_6->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_7
        if ($this->event_7->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_8
        if ($this->event_8->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_9
        if ($this->event_9->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_10
        if ($this->event_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_11
        if ($this->event_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_12
        if ($this->event_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_13
        if ($this->event_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_14
        if ($this->event_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_15
        if ($this->event_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_16
        if ($this->event_16->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_17
        if ($this->event_17->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_18
        if ($this->event_18->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_19
        if ($this->event_19->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // event_20
        if ($this->event_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // family_id
        $this->family_id->RowCssClass = "row";

        // event_id
        $this->event_id->RowCssClass = "row";

        // event_1
        $this->event_1->RowCssClass = "row";

        // event_2
        $this->event_2->RowCssClass = "row";

        // event_3
        $this->event_3->RowCssClass = "row";

        // event_4
        $this->event_4->RowCssClass = "row";

        // event_5
        $this->event_5->RowCssClass = "row";

        // event_6
        $this->event_6->RowCssClass = "row";

        // event_7
        $this->event_7->RowCssClass = "row";

        // event_8
        $this->event_8->RowCssClass = "row";

        // event_9
        $this->event_9->RowCssClass = "row";

        // event_10
        $this->event_10->RowCssClass = "row";

        // event_11
        $this->event_11->RowCssClass = "row";

        // event_12
        $this->event_12->RowCssClass = "row";

        // event_13
        $this->event_13->RowCssClass = "row";

        // event_14
        $this->event_14->RowCssClass = "row";

        // event_15
        $this->event_15->RowCssClass = "row";

        // event_16
        $this->event_16->RowCssClass = "row";

        // event_17
        $this->event_17->RowCssClass = "row";

        // event_18
        $this->event_18->RowCssClass = "row";

        // event_19
        $this->event_19->RowCssClass = "row";

        // event_20
        $this->event_20->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // family_id
            $curVal = strval($this->family_id->CurrentValue);
            if ($curVal != "") {
                $this->family_id->ViewValue = $this->family_id->lookupCacheOption($curVal);
                if ($this->family_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->family_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->family_id->Lookup->renderViewRow($rswrk[0]);
                        $this->family_id->ViewValue = $this->family_id->displayValue($arwrk);
                    } else {
                        $this->family_id->ViewValue = FormatNumber($this->family_id->CurrentValue, $this->family_id->formatPattern());
                    }
                }
            } else {
                $this->family_id->ViewValue = null;
            }

            // event_id
            $curVal = strval($this->event_id->CurrentValue);
            if ($curVal != "") {
                $this->event_id->ViewValue = $this->event_id->lookupCacheOption($curVal);
                if ($this->event_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->event_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->event_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->event_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->event_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->event_id->Lookup->renderViewRow($rswrk[0]);
                        $this->event_id->ViewValue = $this->event_id->displayValue($arwrk);
                    } else {
                        $this->event_id->ViewValue = FormatNumber($this->event_id->CurrentValue, $this->event_id->formatPattern());
                    }
                }
            } else {
                $this->event_id->ViewValue = null;
            }

            // event_1
            $this->event_1->ViewValue = $this->event_1->CurrentValue;

            // event_2
            $this->event_2->ViewValue = $this->event_2->CurrentValue;

            // event_3
            $this->event_3->ViewValue = $this->event_3->CurrentValue;

            // event_4
            $this->event_4->ViewValue = $this->event_4->CurrentValue;

            // event_5
            $this->event_5->ViewValue = $this->event_5->CurrentValue;

            // event_6
            $this->event_6->ViewValue = $this->event_6->CurrentValue;

            // event_7
            $this->event_7->ViewValue = $this->event_7->CurrentValue;

            // event_8
            $this->event_8->ViewValue = $this->event_8->CurrentValue;

            // event_9
            $this->event_9->ViewValue = $this->event_9->CurrentValue;

            // event_10
            $this->event_10->ViewValue = $this->event_10->CurrentValue;

            // event_11
            $this->event_11->ViewValue = $this->event_11->CurrentValue;
            $this->event_11->ViewValue = FormatNumber($this->event_11->ViewValue, $this->event_11->formatPattern());

            // event_12
            $this->event_12->ViewValue = $this->event_12->CurrentValue;
            $this->event_12->ViewValue = FormatNumber($this->event_12->ViewValue, $this->event_12->formatPattern());

            // event_13
            $this->event_13->ViewValue = $this->event_13->CurrentValue;
            $this->event_13->ViewValue = FormatNumber($this->event_13->ViewValue, $this->event_13->formatPattern());

            // event_14
            $this->event_14->ViewValue = $this->event_14->CurrentValue;
            $this->event_14->ViewValue = FormatNumber($this->event_14->ViewValue, $this->event_14->formatPattern());

            // event_15
            $this->event_15->ViewValue = $this->event_15->CurrentValue;
            $this->event_15->ViewValue = FormatNumber($this->event_15->ViewValue, $this->event_15->formatPattern());

            // event_16
            $this->event_16->ViewValue = $this->event_16->CurrentValue;
            $this->event_16->ViewValue = FormatNumber($this->event_16->ViewValue, $this->event_16->formatPattern());

            // event_17
            $this->event_17->ViewValue = $this->event_17->CurrentValue;
            $this->event_17->ViewValue = FormatNumber($this->event_17->ViewValue, $this->event_17->formatPattern());

            // event_18
            $this->event_18->ViewValue = $this->event_18->CurrentValue;
            $this->event_18->ViewValue = FormatNumber($this->event_18->ViewValue, $this->event_18->formatPattern());

            // event_19
            $this->event_19->ViewValue = $this->event_19->CurrentValue;
            $this->event_19->ViewValue = FormatNumber($this->event_19->ViewValue, $this->event_19->formatPattern());

            // event_20
            $this->event_20->ViewValue = $this->event_20->CurrentValue;
            $this->event_20->ViewValue = FormatNumber($this->event_20->ViewValue, $this->event_20->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // family_id
            $this->family_id->HrefValue = "";
            $this->family_id->TooltipValue = "";

            // event_id
            $this->event_id->HrefValue = "";
            $this->event_id->TooltipValue = "";

            // event_1
            $this->event_1->HrefValue = "";
            $this->event_1->TooltipValue = "";

            // event_2
            $this->event_2->HrefValue = "";
            $this->event_2->TooltipValue = "";

            // event_3
            $this->event_3->HrefValue = "";
            $this->event_3->TooltipValue = "";

            // event_4
            $this->event_4->HrefValue = "";
            $this->event_4->TooltipValue = "";

            // event_5
            $this->event_5->HrefValue = "";
            $this->event_5->TooltipValue = "";

            // event_6
            $this->event_6->HrefValue = "";
            $this->event_6->TooltipValue = "";

            // event_7
            $this->event_7->HrefValue = "";
            $this->event_7->TooltipValue = "";

            // event_8
            $this->event_8->HrefValue = "";
            $this->event_8->TooltipValue = "";

            // event_9
            $this->event_9->HrefValue = "";
            $this->event_9->TooltipValue = "";

            // event_10
            $this->event_10->HrefValue = "";
            $this->event_10->TooltipValue = "";

            // event_11
            $this->event_11->HrefValue = "";
            $this->event_11->TooltipValue = "";

            // event_12
            $this->event_12->HrefValue = "";
            $this->event_12->TooltipValue = "";

            // event_13
            $this->event_13->HrefValue = "";
            $this->event_13->TooltipValue = "";

            // event_14
            $this->event_14->HrefValue = "";
            $this->event_14->TooltipValue = "";

            // event_15
            $this->event_15->HrefValue = "";
            $this->event_15->TooltipValue = "";

            // event_16
            $this->event_16->HrefValue = "";
            $this->event_16->TooltipValue = "";

            // event_17
            $this->event_17->HrefValue = "";
            $this->event_17->TooltipValue = "";

            // event_18
            $this->event_18->HrefValue = "";
            $this->event_18->TooltipValue = "";

            // event_19
            $this->event_19->HrefValue = "";
            $this->event_19->TooltipValue = "";

            // event_20
            $this->event_20->HrefValue = "";
            $this->event_20->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // family_id
            $this->family_id->setupEditAttributes();
            $curVal = trim(strval($this->family_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->family_id->AdvancedSearch->ViewValue = $this->family_id->lookupCacheOption($curVal);
            } else {
                $this->family_id->AdvancedSearch->ViewValue = $this->family_id->Lookup !== null && is_array($this->family_id->lookupOptions()) && count($this->family_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->family_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->family_id->EditValue = array_values($this->family_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->family_id->AdvancedSearch->SearchValue, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->family_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->family_id->Lookup->renderViewRow($row);
                }
                $this->family_id->EditValue = $arwrk;
            }
            $this->family_id->PlaceHolder = RemoveHtml($this->family_id->caption());

            // event_id
            $this->event_id->setupEditAttributes();
            $curVal = trim(strval($this->event_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->event_id->AdvancedSearch->ViewValue = $this->event_id->lookupCacheOption($curVal);
            } else {
                $this->event_id->AdvancedSearch->ViewValue = $this->event_id->Lookup !== null && is_array($this->event_id->lookupOptions()) && count($this->event_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->event_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->event_id->EditValue = array_values($this->event_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->event_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->event_id->AdvancedSearch->SearchValue, $this->event_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->event_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->event_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->event_id->EditValue = $arwrk;
            }
            $this->event_id->PlaceHolder = RemoveHtml($this->event_id->caption());

            // event_1
            $this->event_1->setupEditAttributes();
            $this->event_1->EditValue = $this->event_1->AdvancedSearch->SearchValue;
            $this->event_1->PlaceHolder = RemoveHtml($this->event_1->caption());

            // event_2
            $this->event_2->setupEditAttributes();
            $this->event_2->EditValue = $this->event_2->AdvancedSearch->SearchValue;
            $this->event_2->PlaceHolder = RemoveHtml($this->event_2->caption());

            // event_3
            $this->event_3->setupEditAttributes();
            $this->event_3->EditValue = $this->event_3->AdvancedSearch->SearchValue;
            $this->event_3->PlaceHolder = RemoveHtml($this->event_3->caption());

            // event_4
            $this->event_4->setupEditAttributes();
            $this->event_4->EditValue = $this->event_4->AdvancedSearch->SearchValue;
            $this->event_4->PlaceHolder = RemoveHtml($this->event_4->caption());

            // event_5
            $this->event_5->setupEditAttributes();
            $this->event_5->EditValue = $this->event_5->AdvancedSearch->SearchValue;
            $this->event_5->PlaceHolder = RemoveHtml($this->event_5->caption());

            // event_6
            $this->event_6->setupEditAttributes();
            $this->event_6->EditValue = $this->event_6->AdvancedSearch->SearchValue;
            $this->event_6->PlaceHolder = RemoveHtml($this->event_6->caption());

            // event_7
            $this->event_7->setupEditAttributes();
            $this->event_7->EditValue = $this->event_7->AdvancedSearch->SearchValue;
            $this->event_7->PlaceHolder = RemoveHtml($this->event_7->caption());

            // event_8
            $this->event_8->setupEditAttributes();
            $this->event_8->EditValue = $this->event_8->AdvancedSearch->SearchValue;
            $this->event_8->PlaceHolder = RemoveHtml($this->event_8->caption());

            // event_9
            $this->event_9->setupEditAttributes();
            $this->event_9->EditValue = $this->event_9->AdvancedSearch->SearchValue;
            $this->event_9->PlaceHolder = RemoveHtml($this->event_9->caption());

            // event_10
            $this->event_10->setupEditAttributes();
            $this->event_10->EditValue = $this->event_10->AdvancedSearch->SearchValue;
            $this->event_10->PlaceHolder = RemoveHtml($this->event_10->caption());

            // event_11
            $this->event_11->setupEditAttributes();
            $this->event_11->EditValue = $this->event_11->AdvancedSearch->SearchValue;
            $this->event_11->PlaceHolder = RemoveHtml($this->event_11->caption());

            // event_12
            $this->event_12->setupEditAttributes();
            $this->event_12->EditValue = $this->event_12->AdvancedSearch->SearchValue;
            $this->event_12->PlaceHolder = RemoveHtml($this->event_12->caption());

            // event_13
            $this->event_13->setupEditAttributes();
            $this->event_13->EditValue = $this->event_13->AdvancedSearch->SearchValue;
            $this->event_13->PlaceHolder = RemoveHtml($this->event_13->caption());

            // event_14
            $this->event_14->setupEditAttributes();
            $this->event_14->EditValue = $this->event_14->AdvancedSearch->SearchValue;
            $this->event_14->PlaceHolder = RemoveHtml($this->event_14->caption());

            // event_15
            $this->event_15->setupEditAttributes();
            $this->event_15->EditValue = $this->event_15->AdvancedSearch->SearchValue;
            $this->event_15->PlaceHolder = RemoveHtml($this->event_15->caption());

            // event_16
            $this->event_16->setupEditAttributes();
            $this->event_16->EditValue = $this->event_16->AdvancedSearch->SearchValue;
            $this->event_16->PlaceHolder = RemoveHtml($this->event_16->caption());

            // event_17
            $this->event_17->setupEditAttributes();
            $this->event_17->EditValue = $this->event_17->AdvancedSearch->SearchValue;
            $this->event_17->PlaceHolder = RemoveHtml($this->event_17->caption());

            // event_18
            $this->event_18->setupEditAttributes();
            $this->event_18->EditValue = $this->event_18->AdvancedSearch->SearchValue;
            $this->event_18->PlaceHolder = RemoveHtml($this->event_18->caption());

            // event_19
            $this->event_19->setupEditAttributes();
            $this->event_19->EditValue = $this->event_19->AdvancedSearch->SearchValue;
            $this->event_19->PlaceHolder = RemoveHtml($this->event_19->caption());

            // event_20
            $this->event_20->setupEditAttributes();
            $this->event_20->EditValue = $this->event_20->AdvancedSearch->SearchValue;
            $this->event_20->PlaceHolder = RemoveHtml($this->event_20->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $curVal = strval($this->operator->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->EditValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->EditValue = HtmlEncode(FormatNumber($this->operator->AdvancedSearch->SearchValue, $this->operator->formatPattern()));
                    }
                }
            } else {
                $this->operator->EditValue = null;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_11->AdvancedSearch->SearchValue)) {
            $this->event_11->addErrorMessage($this->event_11->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_12->AdvancedSearch->SearchValue)) {
            $this->event_12->addErrorMessage($this->event_12->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_13->AdvancedSearch->SearchValue)) {
            $this->event_13->addErrorMessage($this->event_13->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_14->AdvancedSearch->SearchValue)) {
            $this->event_14->addErrorMessage($this->event_14->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_15->AdvancedSearch->SearchValue)) {
            $this->event_15->addErrorMessage($this->event_15->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_16->AdvancedSearch->SearchValue)) {
            $this->event_16->addErrorMessage($this->event_16->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_17->AdvancedSearch->SearchValue)) {
            $this->event_17->addErrorMessage($this->event_17->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_18->AdvancedSearch->SearchValue)) {
            $this->event_18->addErrorMessage($this->event_18->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_19->AdvancedSearch->SearchValue)) {
            $this->event_19->addErrorMessage($this->event_19->getErrorMessage(false));
        }
        if (!CheckInteger($this->event_20->AdvancedSearch->SearchValue)) {
            $this->event_20->addErrorMessage($this->event_20->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->family_id->AdvancedSearch->load();
        $this->event_id->AdvancedSearch->load();
        $this->event_1->AdvancedSearch->load();
        $this->event_2->AdvancedSearch->load();
        $this->event_3->AdvancedSearch->load();
        $this->event_4->AdvancedSearch->load();
        $this->event_5->AdvancedSearch->load();
        $this->event_6->AdvancedSearch->load();
        $this->event_7->AdvancedSearch->load();
        $this->event_8->AdvancedSearch->load();
        $this->event_9->AdvancedSearch->load();
        $this->event_10->AdvancedSearch->load();
        $this->event_11->AdvancedSearch->load();
        $this->event_12->AdvancedSearch->load();
        $this->event_13->AdvancedSearch->load();
        $this->event_14->AdvancedSearch->load();
        $this->event_15->AdvancedSearch->load();
        $this->event_16->AdvancedSearch->load();
        $this->event_17->AdvancedSearch->load();
        $this->event_18->AdvancedSearch->load();
        $this->event_19->AdvancedSearch->load();
        $this->event_20->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("familyeventestimatelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_family_id":
                    break;
                case "x_event_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
