<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FamilyEventEstimateDelete extends FamilyEventEstimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FamilyEventEstimateDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "familyeventestimatedelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->family_id->setVisibility();
        $this->event_id->setVisibility();
        $this->event_1->setVisibility();
        $this->event_2->setVisibility();
        $this->event_3->setVisibility();
        $this->event_4->setVisibility();
        $this->event_5->setVisibility();
        $this->event_6->setVisibility();
        $this->event_7->setVisibility();
        $this->event_8->setVisibility();
        $this->event_9->setVisibility();
        $this->event_10->setVisibility();
        $this->event_11->setVisibility();
        $this->event_12->setVisibility();
        $this->event_13->setVisibility();
        $this->event_14->setVisibility();
        $this->event_15->setVisibility();
        $this->event_16->setVisibility();
        $this->event_17->setVisibility();
        $this->event_18->setVisibility();
        $this->event_19->setVisibility();
        $this->event_20->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'family_event_estimate';
        $this->TableName = 'family_event_estimate';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (family_event_estimate)
        if (!isset($GLOBALS["family_event_estimate"]) || $GLOBALS["family_event_estimate"]::class == PROJECT_NAMESPACE . "family_event_estimate") {
            $GLOBALS["family_event_estimate"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'family_event_estimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->family_id);
        $this->setupLookupOptions($this->event_id);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("familyeventestimatelist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("familyeventestimatelist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->family_id->setDbValue($row['family_id']);
        $this->event_id->setDbValue($row['event_id']);
        $this->event_1->setDbValue($row['event_1']);
        $this->event_2->setDbValue($row['event_2']);
        $this->event_3->setDbValue($row['event_3']);
        $this->event_4->setDbValue($row['event_4']);
        $this->event_5->setDbValue($row['event_5']);
        $this->event_6->setDbValue($row['event_6']);
        $this->event_7->setDbValue($row['event_7']);
        $this->event_8->setDbValue($row['event_8']);
        $this->event_9->setDbValue($row['event_9']);
        $this->event_10->setDbValue($row['event_10']);
        $this->event_11->setDbValue($row['event_11']);
        $this->event_12->setDbValue($row['event_12']);
        $this->event_13->setDbValue($row['event_13']);
        $this->event_14->setDbValue($row['event_14']);
        $this->event_15->setDbValue($row['event_15']);
        $this->event_16->setDbValue($row['event_16']);
        $this->event_17->setDbValue($row['event_17']);
        $this->event_18->setDbValue($row['event_18']);
        $this->event_19->setDbValue($row['event_19']);
        $this->event_20->setDbValue($row['event_20']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['family_id'] = $this->family_id->DefaultValue;
        $row['event_id'] = $this->event_id->DefaultValue;
        $row['event_1'] = $this->event_1->DefaultValue;
        $row['event_2'] = $this->event_2->DefaultValue;
        $row['event_3'] = $this->event_3->DefaultValue;
        $row['event_4'] = $this->event_4->DefaultValue;
        $row['event_5'] = $this->event_5->DefaultValue;
        $row['event_6'] = $this->event_6->DefaultValue;
        $row['event_7'] = $this->event_7->DefaultValue;
        $row['event_8'] = $this->event_8->DefaultValue;
        $row['event_9'] = $this->event_9->DefaultValue;
        $row['event_10'] = $this->event_10->DefaultValue;
        $row['event_11'] = $this->event_11->DefaultValue;
        $row['event_12'] = $this->event_12->DefaultValue;
        $row['event_13'] = $this->event_13->DefaultValue;
        $row['event_14'] = $this->event_14->DefaultValue;
        $row['event_15'] = $this->event_15->DefaultValue;
        $row['event_16'] = $this->event_16->DefaultValue;
        $row['event_17'] = $this->event_17->DefaultValue;
        $row['event_18'] = $this->event_18->DefaultValue;
        $row['event_19'] = $this->event_19->DefaultValue;
        $row['event_20'] = $this->event_20->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // family_id

        // event_id

        // event_1

        // event_2

        // event_3

        // event_4

        // event_5

        // event_6

        // event_7

        // event_8

        // event_9

        // event_10

        // event_11

        // event_12

        // event_13

        // event_14

        // event_15

        // event_16

        // event_17

        // event_18

        // event_19

        // event_20

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // family_id
            $curVal = strval($this->family_id->CurrentValue);
            if ($curVal != "") {
                $this->family_id->ViewValue = $this->family_id->lookupCacheOption($curVal);
                if ($this->family_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->family_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->family_id->Lookup->renderViewRow($rswrk[0]);
                        $this->family_id->ViewValue = $this->family_id->displayValue($arwrk);
                    } else {
                        $this->family_id->ViewValue = FormatNumber($this->family_id->CurrentValue, $this->family_id->formatPattern());
                    }
                }
            } else {
                $this->family_id->ViewValue = null;
            }

            // event_id
            $curVal = strval($this->event_id->CurrentValue);
            if ($curVal != "") {
                $this->event_id->ViewValue = $this->event_id->lookupCacheOption($curVal);
                if ($this->event_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->event_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->event_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->event_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->event_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->event_id->Lookup->renderViewRow($rswrk[0]);
                        $this->event_id->ViewValue = $this->event_id->displayValue($arwrk);
                    } else {
                        $this->event_id->ViewValue = FormatNumber($this->event_id->CurrentValue, $this->event_id->formatPattern());
                    }
                }
            } else {
                $this->event_id->ViewValue = null;
            }

            // event_1
            $this->event_1->ViewValue = $this->event_1->CurrentValue;

            // event_2
            $this->event_2->ViewValue = $this->event_2->CurrentValue;

            // event_3
            $this->event_3->ViewValue = $this->event_3->CurrentValue;

            // event_4
            $this->event_4->ViewValue = $this->event_4->CurrentValue;

            // event_5
            $this->event_5->ViewValue = $this->event_5->CurrentValue;

            // event_6
            $this->event_6->ViewValue = $this->event_6->CurrentValue;

            // event_7
            $this->event_7->ViewValue = $this->event_7->CurrentValue;

            // event_8
            $this->event_8->ViewValue = $this->event_8->CurrentValue;

            // event_9
            $this->event_9->ViewValue = $this->event_9->CurrentValue;

            // event_10
            $this->event_10->ViewValue = $this->event_10->CurrentValue;

            // event_11
            $this->event_11->ViewValue = $this->event_11->CurrentValue;
            $this->event_11->ViewValue = FormatNumber($this->event_11->ViewValue, $this->event_11->formatPattern());

            // event_12
            $this->event_12->ViewValue = $this->event_12->CurrentValue;
            $this->event_12->ViewValue = FormatNumber($this->event_12->ViewValue, $this->event_12->formatPattern());

            // event_13
            $this->event_13->ViewValue = $this->event_13->CurrentValue;
            $this->event_13->ViewValue = FormatNumber($this->event_13->ViewValue, $this->event_13->formatPattern());

            // event_14
            $this->event_14->ViewValue = $this->event_14->CurrentValue;
            $this->event_14->ViewValue = FormatNumber($this->event_14->ViewValue, $this->event_14->formatPattern());

            // event_15
            $this->event_15->ViewValue = $this->event_15->CurrentValue;
            $this->event_15->ViewValue = FormatNumber($this->event_15->ViewValue, $this->event_15->formatPattern());

            // event_16
            $this->event_16->ViewValue = $this->event_16->CurrentValue;
            $this->event_16->ViewValue = FormatNumber($this->event_16->ViewValue, $this->event_16->formatPattern());

            // event_17
            $this->event_17->ViewValue = $this->event_17->CurrentValue;
            $this->event_17->ViewValue = FormatNumber($this->event_17->ViewValue, $this->event_17->formatPattern());

            // event_18
            $this->event_18->ViewValue = $this->event_18->CurrentValue;
            $this->event_18->ViewValue = FormatNumber($this->event_18->ViewValue, $this->event_18->formatPattern());

            // event_19
            $this->event_19->ViewValue = $this->event_19->CurrentValue;
            $this->event_19->ViewValue = FormatNumber($this->event_19->ViewValue, $this->event_19->formatPattern());

            // event_20
            $this->event_20->ViewValue = $this->event_20->CurrentValue;
            $this->event_20->ViewValue = FormatNumber($this->event_20->ViewValue, $this->event_20->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // family_id
            $this->family_id->HrefValue = "";
            $this->family_id->TooltipValue = "";

            // event_id
            $this->event_id->HrefValue = "";
            $this->event_id->TooltipValue = "";

            // event_1
            $this->event_1->HrefValue = "";
            $this->event_1->TooltipValue = "";

            // event_2
            $this->event_2->HrefValue = "";
            $this->event_2->TooltipValue = "";

            // event_3
            $this->event_3->HrefValue = "";
            $this->event_3->TooltipValue = "";

            // event_4
            $this->event_4->HrefValue = "";
            $this->event_4->TooltipValue = "";

            // event_5
            $this->event_5->HrefValue = "";
            $this->event_5->TooltipValue = "";

            // event_6
            $this->event_6->HrefValue = "";
            $this->event_6->TooltipValue = "";

            // event_7
            $this->event_7->HrefValue = "";
            $this->event_7->TooltipValue = "";

            // event_8
            $this->event_8->HrefValue = "";
            $this->event_8->TooltipValue = "";

            // event_9
            $this->event_9->HrefValue = "";
            $this->event_9->TooltipValue = "";

            // event_10
            $this->event_10->HrefValue = "";
            $this->event_10->TooltipValue = "";

            // event_11
            $this->event_11->HrefValue = "";
            $this->event_11->TooltipValue = "";

            // event_12
            $this->event_12->HrefValue = "";
            $this->event_12->TooltipValue = "";

            // event_13
            $this->event_13->HrefValue = "";
            $this->event_13->TooltipValue = "";

            // event_14
            $this->event_14->HrefValue = "";
            $this->event_14->TooltipValue = "";

            // event_15
            $this->event_15->HrefValue = "";
            $this->event_15->TooltipValue = "";

            // event_16
            $this->event_16->HrefValue = "";
            $this->event_16->TooltipValue = "";

            // event_17
            $this->event_17->HrefValue = "";
            $this->event_17->TooltipValue = "";

            // event_18
            $this->event_18->HrefValue = "";
            $this->event_18->TooltipValue = "";

            // event_19
            $this->event_19->HrefValue = "";
            $this->event_19->TooltipValue = "";

            // event_20
            $this->event_20->HrefValue = "";
            $this->event_20->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("familyeventestimatelist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_family_id":
                    break;
                case "x_event_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
