<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FamilyEventEstimateAdd extends FamilyEventEstimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FamilyEventEstimateAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "familyeventestimateadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->family_id->setVisibility();
        $this->event_id->setVisibility();
        $this->event_1->setVisibility();
        $this->event_2->setVisibility();
        $this->event_3->setVisibility();
        $this->event_4->setVisibility();
        $this->event_5->setVisibility();
        $this->event_6->setVisibility();
        $this->event_7->setVisibility();
        $this->event_8->setVisibility();
        $this->event_9->setVisibility();
        $this->event_10->setVisibility();
        $this->event_11->setVisibility();
        $this->event_12->setVisibility();
        $this->event_13->setVisibility();
        $this->event_14->setVisibility();
        $this->event_15->setVisibility();
        $this->event_16->setVisibility();
        $this->event_17->setVisibility();
        $this->event_18->setVisibility();
        $this->event_19->setVisibility();
        $this->event_20->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'family_event_estimate';
        $this->TableName = 'family_event_estimate';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (family_event_estimate)
        if (!isset($GLOBALS["family_event_estimate"]) || $GLOBALS["family_event_estimate"]::class == PROJECT_NAMESPACE . "family_event_estimate") {
            $GLOBALS["family_event_estimate"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'family_event_estimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "familyeventestimateview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->family_id);
        $this->setupLookupOptions($this->event_id);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("familyeventestimatelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "familyeventestimatelist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "familyeventestimateview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "familyeventestimatelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "familyeventestimatelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->event_1->DefaultValue = $this->event_1->getDefault(); // PHP
        $this->event_1->OldValue = $this->event_1->DefaultValue;
        $this->event_2->DefaultValue = $this->event_2->getDefault(); // PHP
        $this->event_2->OldValue = $this->event_2->DefaultValue;
        $this->event_3->DefaultValue = $this->event_3->getDefault(); // PHP
        $this->event_3->OldValue = $this->event_3->DefaultValue;
        $this->event_4->DefaultValue = $this->event_4->getDefault(); // PHP
        $this->event_4->OldValue = $this->event_4->DefaultValue;
        $this->event_5->DefaultValue = $this->event_5->getDefault(); // PHP
        $this->event_5->OldValue = $this->event_5->DefaultValue;
        $this->event_6->DefaultValue = $this->event_6->getDefault(); // PHP
        $this->event_6->OldValue = $this->event_6->DefaultValue;
        $this->event_7->DefaultValue = $this->event_7->getDefault(); // PHP
        $this->event_7->OldValue = $this->event_7->DefaultValue;
        $this->event_8->DefaultValue = $this->event_8->getDefault(); // PHP
        $this->event_8->OldValue = $this->event_8->DefaultValue;
        $this->event_9->DefaultValue = $this->event_9->getDefault(); // PHP
        $this->event_9->OldValue = $this->event_9->DefaultValue;
        $this->event_10->DefaultValue = $this->event_10->getDefault(); // PHP
        $this->event_10->OldValue = $this->event_10->DefaultValue;
        $this->event_11->DefaultValue = $this->event_11->getDefault(); // PHP
        $this->event_11->OldValue = $this->event_11->DefaultValue;
        $this->event_12->DefaultValue = $this->event_12->getDefault(); // PHP
        $this->event_12->OldValue = $this->event_12->DefaultValue;
        $this->event_13->DefaultValue = $this->event_13->getDefault(); // PHP
        $this->event_13->OldValue = $this->event_13->DefaultValue;
        $this->event_14->DefaultValue = $this->event_14->getDefault(); // PHP
        $this->event_14->OldValue = $this->event_14->DefaultValue;
        $this->event_15->DefaultValue = $this->event_15->getDefault(); // PHP
        $this->event_15->OldValue = $this->event_15->DefaultValue;
        $this->event_16->DefaultValue = $this->event_16->getDefault(); // PHP
        $this->event_16->OldValue = $this->event_16->DefaultValue;
        $this->event_17->DefaultValue = $this->event_17->getDefault(); // PHP
        $this->event_17->OldValue = $this->event_17->DefaultValue;
        $this->event_18->DefaultValue = $this->event_18->getDefault(); // PHP
        $this->event_18->OldValue = $this->event_18->DefaultValue;
        $this->event_19->DefaultValue = $this->event_19->getDefault(); // PHP
        $this->event_19->OldValue = $this->event_19->DefaultValue;
        $this->event_20->DefaultValue = $this->event_20->getDefault(); // PHP
        $this->event_20->OldValue = $this->event_20->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'family_id' first before field var 'x_family_id'
        $val = $CurrentForm->hasValue("family_id") ? $CurrentForm->getValue("family_id") : $CurrentForm->getValue("x_family_id");
        if (!$this->family_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->family_id->Visible = false; // Disable update for API request
            } else {
                $this->family_id->setFormValue($val);
            }
        }

        // Check field name 'event_id' first before field var 'x_event_id'
        $val = $CurrentForm->hasValue("event_id") ? $CurrentForm->getValue("event_id") : $CurrentForm->getValue("x_event_id");
        if (!$this->event_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_id->Visible = false; // Disable update for API request
            } else {
                $this->event_id->setFormValue($val);
            }
        }

        // Check field name 'event_1' first before field var 'x_event_1'
        $val = $CurrentForm->hasValue("event_1") ? $CurrentForm->getValue("event_1") : $CurrentForm->getValue("x_event_1");
        if (!$this->event_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_1->Visible = false; // Disable update for API request
            } else {
                $this->event_1->setFormValue($val);
            }
        }

        // Check field name 'event_2' first before field var 'x_event_2'
        $val = $CurrentForm->hasValue("event_2") ? $CurrentForm->getValue("event_2") : $CurrentForm->getValue("x_event_2");
        if (!$this->event_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_2->Visible = false; // Disable update for API request
            } else {
                $this->event_2->setFormValue($val);
            }
        }

        // Check field name 'event_3' first before field var 'x_event_3'
        $val = $CurrentForm->hasValue("event_3") ? $CurrentForm->getValue("event_3") : $CurrentForm->getValue("x_event_3");
        if (!$this->event_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_3->Visible = false; // Disable update for API request
            } else {
                $this->event_3->setFormValue($val);
            }
        }

        // Check field name 'event_4' first before field var 'x_event_4'
        $val = $CurrentForm->hasValue("event_4") ? $CurrentForm->getValue("event_4") : $CurrentForm->getValue("x_event_4");
        if (!$this->event_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_4->Visible = false; // Disable update for API request
            } else {
                $this->event_4->setFormValue($val);
            }
        }

        // Check field name 'event_5' first before field var 'x_event_5'
        $val = $CurrentForm->hasValue("event_5") ? $CurrentForm->getValue("event_5") : $CurrentForm->getValue("x_event_5");
        if (!$this->event_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_5->Visible = false; // Disable update for API request
            } else {
                $this->event_5->setFormValue($val);
            }
        }

        // Check field name 'event_6' first before field var 'x_event_6'
        $val = $CurrentForm->hasValue("event_6") ? $CurrentForm->getValue("event_6") : $CurrentForm->getValue("x_event_6");
        if (!$this->event_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_6->Visible = false; // Disable update for API request
            } else {
                $this->event_6->setFormValue($val);
            }
        }

        // Check field name 'event_7' first before field var 'x_event_7'
        $val = $CurrentForm->hasValue("event_7") ? $CurrentForm->getValue("event_7") : $CurrentForm->getValue("x_event_7");
        if (!$this->event_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_7->Visible = false; // Disable update for API request
            } else {
                $this->event_7->setFormValue($val);
            }
        }

        // Check field name 'event_8' first before field var 'x_event_8'
        $val = $CurrentForm->hasValue("event_8") ? $CurrentForm->getValue("event_8") : $CurrentForm->getValue("x_event_8");
        if (!$this->event_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_8->Visible = false; // Disable update for API request
            } else {
                $this->event_8->setFormValue($val);
            }
        }

        // Check field name 'event_9' first before field var 'x_event_9'
        $val = $CurrentForm->hasValue("event_9") ? $CurrentForm->getValue("event_9") : $CurrentForm->getValue("x_event_9");
        if (!$this->event_9->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_9->Visible = false; // Disable update for API request
            } else {
                $this->event_9->setFormValue($val);
            }
        }

        // Check field name 'event_10' first before field var 'x_event_10'
        $val = $CurrentForm->hasValue("event_10") ? $CurrentForm->getValue("event_10") : $CurrentForm->getValue("x_event_10");
        if (!$this->event_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_10->Visible = false; // Disable update for API request
            } else {
                $this->event_10->setFormValue($val);
            }
        }

        // Check field name 'event_11' first before field var 'x_event_11'
        $val = $CurrentForm->hasValue("event_11") ? $CurrentForm->getValue("event_11") : $CurrentForm->getValue("x_event_11");
        if (!$this->event_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_11->Visible = false; // Disable update for API request
            } else {
                $this->event_11->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_12' first before field var 'x_event_12'
        $val = $CurrentForm->hasValue("event_12") ? $CurrentForm->getValue("event_12") : $CurrentForm->getValue("x_event_12");
        if (!$this->event_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_12->Visible = false; // Disable update for API request
            } else {
                $this->event_12->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_13' first before field var 'x_event_13'
        $val = $CurrentForm->hasValue("event_13") ? $CurrentForm->getValue("event_13") : $CurrentForm->getValue("x_event_13");
        if (!$this->event_13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_13->Visible = false; // Disable update for API request
            } else {
                $this->event_13->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_14' first before field var 'x_event_14'
        $val = $CurrentForm->hasValue("event_14") ? $CurrentForm->getValue("event_14") : $CurrentForm->getValue("x_event_14");
        if (!$this->event_14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_14->Visible = false; // Disable update for API request
            } else {
                $this->event_14->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_15' first before field var 'x_event_15'
        $val = $CurrentForm->hasValue("event_15") ? $CurrentForm->getValue("event_15") : $CurrentForm->getValue("x_event_15");
        if (!$this->event_15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_15->Visible = false; // Disable update for API request
            } else {
                $this->event_15->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_16' first before field var 'x_event_16'
        $val = $CurrentForm->hasValue("event_16") ? $CurrentForm->getValue("event_16") : $CurrentForm->getValue("x_event_16");
        if (!$this->event_16->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_16->Visible = false; // Disable update for API request
            } else {
                $this->event_16->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_17' first before field var 'x_event_17'
        $val = $CurrentForm->hasValue("event_17") ? $CurrentForm->getValue("event_17") : $CurrentForm->getValue("x_event_17");
        if (!$this->event_17->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_17->Visible = false; // Disable update for API request
            } else {
                $this->event_17->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_18' first before field var 'x_event_18'
        $val = $CurrentForm->hasValue("event_18") ? $CurrentForm->getValue("event_18") : $CurrentForm->getValue("x_event_18");
        if (!$this->event_18->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_18->Visible = false; // Disable update for API request
            } else {
                $this->event_18->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_19' first before field var 'x_event_19'
        $val = $CurrentForm->hasValue("event_19") ? $CurrentForm->getValue("event_19") : $CurrentForm->getValue("x_event_19");
        if (!$this->event_19->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_19->Visible = false; // Disable update for API request
            } else {
                $this->event_19->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'event_20' first before field var 'x_event_20'
        $val = $CurrentForm->hasValue("event_20") ? $CurrentForm->getValue("event_20") : $CurrentForm->getValue("x_event_20");
        if (!$this->event_20->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->event_20->Visible = false; // Disable update for API request
            } else {
                $this->event_20->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->family_id->CurrentValue = $this->family_id->FormValue;
        $this->event_id->CurrentValue = $this->event_id->FormValue;
        $this->event_1->CurrentValue = $this->event_1->FormValue;
        $this->event_2->CurrentValue = $this->event_2->FormValue;
        $this->event_3->CurrentValue = $this->event_3->FormValue;
        $this->event_4->CurrentValue = $this->event_4->FormValue;
        $this->event_5->CurrentValue = $this->event_5->FormValue;
        $this->event_6->CurrentValue = $this->event_6->FormValue;
        $this->event_7->CurrentValue = $this->event_7->FormValue;
        $this->event_8->CurrentValue = $this->event_8->FormValue;
        $this->event_9->CurrentValue = $this->event_9->FormValue;
        $this->event_10->CurrentValue = $this->event_10->FormValue;
        $this->event_11->CurrentValue = $this->event_11->FormValue;
        $this->event_12->CurrentValue = $this->event_12->FormValue;
        $this->event_13->CurrentValue = $this->event_13->FormValue;
        $this->event_14->CurrentValue = $this->event_14->FormValue;
        $this->event_15->CurrentValue = $this->event_15->FormValue;
        $this->event_16->CurrentValue = $this->event_16->FormValue;
        $this->event_17->CurrentValue = $this->event_17->FormValue;
        $this->event_18->CurrentValue = $this->event_18->FormValue;
        $this->event_19->CurrentValue = $this->event_19->FormValue;
        $this->event_20->CurrentValue = $this->event_20->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->family_id->setDbValue($row['family_id']);
        $this->event_id->setDbValue($row['event_id']);
        $this->event_1->setDbValue($row['event_1']);
        $this->event_2->setDbValue($row['event_2']);
        $this->event_3->setDbValue($row['event_3']);
        $this->event_4->setDbValue($row['event_4']);
        $this->event_5->setDbValue($row['event_5']);
        $this->event_6->setDbValue($row['event_6']);
        $this->event_7->setDbValue($row['event_7']);
        $this->event_8->setDbValue($row['event_8']);
        $this->event_9->setDbValue($row['event_9']);
        $this->event_10->setDbValue($row['event_10']);
        $this->event_11->setDbValue($row['event_11']);
        $this->event_12->setDbValue($row['event_12']);
        $this->event_13->setDbValue($row['event_13']);
        $this->event_14->setDbValue($row['event_14']);
        $this->event_15->setDbValue($row['event_15']);
        $this->event_16->setDbValue($row['event_16']);
        $this->event_17->setDbValue($row['event_17']);
        $this->event_18->setDbValue($row['event_18']);
        $this->event_19->setDbValue($row['event_19']);
        $this->event_20->setDbValue($row['event_20']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['family_id'] = $this->family_id->DefaultValue;
        $row['event_id'] = $this->event_id->DefaultValue;
        $row['event_1'] = $this->event_1->DefaultValue;
        $row['event_2'] = $this->event_2->DefaultValue;
        $row['event_3'] = $this->event_3->DefaultValue;
        $row['event_4'] = $this->event_4->DefaultValue;
        $row['event_5'] = $this->event_5->DefaultValue;
        $row['event_6'] = $this->event_6->DefaultValue;
        $row['event_7'] = $this->event_7->DefaultValue;
        $row['event_8'] = $this->event_8->DefaultValue;
        $row['event_9'] = $this->event_9->DefaultValue;
        $row['event_10'] = $this->event_10->DefaultValue;
        $row['event_11'] = $this->event_11->DefaultValue;
        $row['event_12'] = $this->event_12->DefaultValue;
        $row['event_13'] = $this->event_13->DefaultValue;
        $row['event_14'] = $this->event_14->DefaultValue;
        $row['event_15'] = $this->event_15->DefaultValue;
        $row['event_16'] = $this->event_16->DefaultValue;
        $row['event_17'] = $this->event_17->DefaultValue;
        $row['event_18'] = $this->event_18->DefaultValue;
        $row['event_19'] = $this->event_19->DefaultValue;
        $row['event_20'] = $this->event_20->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // family_id
        $this->family_id->RowCssClass = "row";

        // event_id
        $this->event_id->RowCssClass = "row";

        // event_1
        $this->event_1->RowCssClass = "row";

        // event_2
        $this->event_2->RowCssClass = "row";

        // event_3
        $this->event_3->RowCssClass = "row";

        // event_4
        $this->event_4->RowCssClass = "row";

        // event_5
        $this->event_5->RowCssClass = "row";

        // event_6
        $this->event_6->RowCssClass = "row";

        // event_7
        $this->event_7->RowCssClass = "row";

        // event_8
        $this->event_8->RowCssClass = "row";

        // event_9
        $this->event_9->RowCssClass = "row";

        // event_10
        $this->event_10->RowCssClass = "row";

        // event_11
        $this->event_11->RowCssClass = "row";

        // event_12
        $this->event_12->RowCssClass = "row";

        // event_13
        $this->event_13->RowCssClass = "row";

        // event_14
        $this->event_14->RowCssClass = "row";

        // event_15
        $this->event_15->RowCssClass = "row";

        // event_16
        $this->event_16->RowCssClass = "row";

        // event_17
        $this->event_17->RowCssClass = "row";

        // event_18
        $this->event_18->RowCssClass = "row";

        // event_19
        $this->event_19->RowCssClass = "row";

        // event_20
        $this->event_20->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // family_id
            $curVal = strval($this->family_id->CurrentValue);
            if ($curVal != "") {
                $this->family_id->ViewValue = $this->family_id->lookupCacheOption($curVal);
                if ($this->family_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->family_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->family_id->Lookup->renderViewRow($rswrk[0]);
                        $this->family_id->ViewValue = $this->family_id->displayValue($arwrk);
                    } else {
                        $this->family_id->ViewValue = FormatNumber($this->family_id->CurrentValue, $this->family_id->formatPattern());
                    }
                }
            } else {
                $this->family_id->ViewValue = null;
            }

            // event_id
            $curVal = strval($this->event_id->CurrentValue);
            if ($curVal != "") {
                $this->event_id->ViewValue = $this->event_id->lookupCacheOption($curVal);
                if ($this->event_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->event_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->event_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->event_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->event_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->event_id->Lookup->renderViewRow($rswrk[0]);
                        $this->event_id->ViewValue = $this->event_id->displayValue($arwrk);
                    } else {
                        $this->event_id->ViewValue = FormatNumber($this->event_id->CurrentValue, $this->event_id->formatPattern());
                    }
                }
            } else {
                $this->event_id->ViewValue = null;
            }

            // event_1
            $this->event_1->ViewValue = $this->event_1->CurrentValue;

            // event_2
            $this->event_2->ViewValue = $this->event_2->CurrentValue;

            // event_3
            $this->event_3->ViewValue = $this->event_3->CurrentValue;

            // event_4
            $this->event_4->ViewValue = $this->event_4->CurrentValue;

            // event_5
            $this->event_5->ViewValue = $this->event_5->CurrentValue;

            // event_6
            $this->event_6->ViewValue = $this->event_6->CurrentValue;

            // event_7
            $this->event_7->ViewValue = $this->event_7->CurrentValue;

            // event_8
            $this->event_8->ViewValue = $this->event_8->CurrentValue;

            // event_9
            $this->event_9->ViewValue = $this->event_9->CurrentValue;

            // event_10
            $this->event_10->ViewValue = $this->event_10->CurrentValue;

            // event_11
            $this->event_11->ViewValue = $this->event_11->CurrentValue;
            $this->event_11->ViewValue = FormatNumber($this->event_11->ViewValue, $this->event_11->formatPattern());

            // event_12
            $this->event_12->ViewValue = $this->event_12->CurrentValue;
            $this->event_12->ViewValue = FormatNumber($this->event_12->ViewValue, $this->event_12->formatPattern());

            // event_13
            $this->event_13->ViewValue = $this->event_13->CurrentValue;
            $this->event_13->ViewValue = FormatNumber($this->event_13->ViewValue, $this->event_13->formatPattern());

            // event_14
            $this->event_14->ViewValue = $this->event_14->CurrentValue;
            $this->event_14->ViewValue = FormatNumber($this->event_14->ViewValue, $this->event_14->formatPattern());

            // event_15
            $this->event_15->ViewValue = $this->event_15->CurrentValue;
            $this->event_15->ViewValue = FormatNumber($this->event_15->ViewValue, $this->event_15->formatPattern());

            // event_16
            $this->event_16->ViewValue = $this->event_16->CurrentValue;
            $this->event_16->ViewValue = FormatNumber($this->event_16->ViewValue, $this->event_16->formatPattern());

            // event_17
            $this->event_17->ViewValue = $this->event_17->CurrentValue;
            $this->event_17->ViewValue = FormatNumber($this->event_17->ViewValue, $this->event_17->formatPattern());

            // event_18
            $this->event_18->ViewValue = $this->event_18->CurrentValue;
            $this->event_18->ViewValue = FormatNumber($this->event_18->ViewValue, $this->event_18->formatPattern());

            // event_19
            $this->event_19->ViewValue = $this->event_19->CurrentValue;
            $this->event_19->ViewValue = FormatNumber($this->event_19->ViewValue, $this->event_19->formatPattern());

            // event_20
            $this->event_20->ViewValue = $this->event_20->CurrentValue;
            $this->event_20->ViewValue = FormatNumber($this->event_20->ViewValue, $this->event_20->formatPattern());

            // family_id
            $this->family_id->HrefValue = "";

            // event_id
            $this->event_id->HrefValue = "";

            // event_1
            $this->event_1->HrefValue = "";

            // event_2
            $this->event_2->HrefValue = "";

            // event_3
            $this->event_3->HrefValue = "";

            // event_4
            $this->event_4->HrefValue = "";

            // event_5
            $this->event_5->HrefValue = "";

            // event_6
            $this->event_6->HrefValue = "";

            // event_7
            $this->event_7->HrefValue = "";

            // event_8
            $this->event_8->HrefValue = "";

            // event_9
            $this->event_9->HrefValue = "";

            // event_10
            $this->event_10->HrefValue = "";

            // event_11
            $this->event_11->HrefValue = "";

            // event_12
            $this->event_12->HrefValue = "";

            // event_13
            $this->event_13->HrefValue = "";

            // event_14
            $this->event_14->HrefValue = "";

            // event_15
            $this->event_15->HrefValue = "";

            // event_16
            $this->event_16->HrefValue = "";

            // event_17
            $this->event_17->HrefValue = "";

            // event_18
            $this->event_18->HrefValue = "";

            // event_19
            $this->event_19->HrefValue = "";

            // event_20
            $this->event_20->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // family_id
            $this->family_id->setupEditAttributes();
            $curVal = trim(strval($this->family_id->CurrentValue));
            if ($curVal != "") {
                $this->family_id->ViewValue = $this->family_id->lookupCacheOption($curVal);
            } else {
                $this->family_id->ViewValue = $this->family_id->Lookup !== null && is_array($this->family_id->lookupOptions()) && count($this->family_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->family_id->ViewValue !== null) { // Load from cache
                $this->family_id->EditValue = array_values($this->family_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->family_id->CurrentValue, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->family_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->family_id->Lookup->renderViewRow($row);
                }
                $this->family_id->EditValue = $arwrk;
            }
            $this->family_id->PlaceHolder = RemoveHtml($this->family_id->caption());

            // event_id
            $this->event_id->setupEditAttributes();
            $curVal = trim(strval($this->event_id->CurrentValue));
            if ($curVal != "") {
                $this->event_id->ViewValue = $this->event_id->lookupCacheOption($curVal);
            } else {
                $this->event_id->ViewValue = $this->event_id->Lookup !== null && is_array($this->event_id->lookupOptions()) && count($this->event_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->event_id->ViewValue !== null) { // Load from cache
                $this->event_id->EditValue = array_values($this->event_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->event_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->event_id->CurrentValue, $this->event_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->event_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->event_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->event_id->EditValue = $arwrk;
            }
            $this->event_id->PlaceHolder = RemoveHtml($this->event_id->caption());

            // event_1
            $this->event_1->setupEditAttributes();
            $this->event_1->EditValue = $this->event_1->CurrentValue;
            $this->event_1->PlaceHolder = RemoveHtml($this->event_1->caption());
            if (strval($this->event_1->EditValue) != "" && is_numeric($this->event_1->EditValue)) {
                $this->event_1->EditValue = $this->event_1->EditValue;
            }

            // event_2
            $this->event_2->setupEditAttributes();
            $this->event_2->EditValue = $this->event_2->CurrentValue;
            $this->event_2->PlaceHolder = RemoveHtml($this->event_2->caption());
            if (strval($this->event_2->EditValue) != "" && is_numeric($this->event_2->EditValue)) {
                $this->event_2->EditValue = $this->event_2->EditValue;
            }

            // event_3
            $this->event_3->setupEditAttributes();
            $this->event_3->EditValue = $this->event_3->CurrentValue;
            $this->event_3->PlaceHolder = RemoveHtml($this->event_3->caption());
            if (strval($this->event_3->EditValue) != "" && is_numeric($this->event_3->EditValue)) {
                $this->event_3->EditValue = $this->event_3->EditValue;
            }

            // event_4
            $this->event_4->setupEditAttributes();
            $this->event_4->EditValue = $this->event_4->CurrentValue;
            $this->event_4->PlaceHolder = RemoveHtml($this->event_4->caption());
            if (strval($this->event_4->EditValue) != "" && is_numeric($this->event_4->EditValue)) {
                $this->event_4->EditValue = $this->event_4->EditValue;
            }

            // event_5
            $this->event_5->setupEditAttributes();
            $this->event_5->EditValue = $this->event_5->CurrentValue;
            $this->event_5->PlaceHolder = RemoveHtml($this->event_5->caption());
            if (strval($this->event_5->EditValue) != "" && is_numeric($this->event_5->EditValue)) {
                $this->event_5->EditValue = $this->event_5->EditValue;
            }

            // event_6
            $this->event_6->setupEditAttributes();
            $this->event_6->EditValue = $this->event_6->CurrentValue;
            $this->event_6->PlaceHolder = RemoveHtml($this->event_6->caption());
            if (strval($this->event_6->EditValue) != "" && is_numeric($this->event_6->EditValue)) {
                $this->event_6->EditValue = $this->event_6->EditValue;
            }

            // event_7
            $this->event_7->setupEditAttributes();
            $this->event_7->EditValue = $this->event_7->CurrentValue;
            $this->event_7->PlaceHolder = RemoveHtml($this->event_7->caption());
            if (strval($this->event_7->EditValue) != "" && is_numeric($this->event_7->EditValue)) {
                $this->event_7->EditValue = $this->event_7->EditValue;
            }

            // event_8
            $this->event_8->setupEditAttributes();
            $this->event_8->EditValue = $this->event_8->CurrentValue;
            $this->event_8->PlaceHolder = RemoveHtml($this->event_8->caption());
            if (strval($this->event_8->EditValue) != "" && is_numeric($this->event_8->EditValue)) {
                $this->event_8->EditValue = $this->event_8->EditValue;
            }

            // event_9
            $this->event_9->setupEditAttributes();
            $this->event_9->EditValue = $this->event_9->CurrentValue;
            $this->event_9->PlaceHolder = RemoveHtml($this->event_9->caption());
            if (strval($this->event_9->EditValue) != "" && is_numeric($this->event_9->EditValue)) {
                $this->event_9->EditValue = $this->event_9->EditValue;
            }

            // event_10
            $this->event_10->setupEditAttributes();
            $this->event_10->EditValue = $this->event_10->CurrentValue;
            $this->event_10->PlaceHolder = RemoveHtml($this->event_10->caption());
            if (strval($this->event_10->EditValue) != "" && is_numeric($this->event_10->EditValue)) {
                $this->event_10->EditValue = $this->event_10->EditValue;
            }

            // event_11
            $this->event_11->setupEditAttributes();
            $this->event_11->EditValue = $this->event_11->CurrentValue;
            $this->event_11->PlaceHolder = RemoveHtml($this->event_11->caption());
            if (strval($this->event_11->EditValue) != "" && is_numeric($this->event_11->EditValue)) {
                $this->event_11->EditValue = FormatNumber($this->event_11->EditValue, null);
            }

            // event_12
            $this->event_12->setupEditAttributes();
            $this->event_12->EditValue = $this->event_12->CurrentValue;
            $this->event_12->PlaceHolder = RemoveHtml($this->event_12->caption());
            if (strval($this->event_12->EditValue) != "" && is_numeric($this->event_12->EditValue)) {
                $this->event_12->EditValue = FormatNumber($this->event_12->EditValue, null);
            }

            // event_13
            $this->event_13->setupEditAttributes();
            $this->event_13->EditValue = $this->event_13->CurrentValue;
            $this->event_13->PlaceHolder = RemoveHtml($this->event_13->caption());
            if (strval($this->event_13->EditValue) != "" && is_numeric($this->event_13->EditValue)) {
                $this->event_13->EditValue = FormatNumber($this->event_13->EditValue, null);
            }

            // event_14
            $this->event_14->setupEditAttributes();
            $this->event_14->EditValue = $this->event_14->CurrentValue;
            $this->event_14->PlaceHolder = RemoveHtml($this->event_14->caption());
            if (strval($this->event_14->EditValue) != "" && is_numeric($this->event_14->EditValue)) {
                $this->event_14->EditValue = FormatNumber($this->event_14->EditValue, null);
            }

            // event_15
            $this->event_15->setupEditAttributes();
            $this->event_15->EditValue = $this->event_15->CurrentValue;
            $this->event_15->PlaceHolder = RemoveHtml($this->event_15->caption());
            if (strval($this->event_15->EditValue) != "" && is_numeric($this->event_15->EditValue)) {
                $this->event_15->EditValue = FormatNumber($this->event_15->EditValue, null);
            }

            // event_16
            $this->event_16->setupEditAttributes();
            $this->event_16->EditValue = $this->event_16->CurrentValue;
            $this->event_16->PlaceHolder = RemoveHtml($this->event_16->caption());
            if (strval($this->event_16->EditValue) != "" && is_numeric($this->event_16->EditValue)) {
                $this->event_16->EditValue = FormatNumber($this->event_16->EditValue, null);
            }

            // event_17
            $this->event_17->setupEditAttributes();
            $this->event_17->EditValue = $this->event_17->CurrentValue;
            $this->event_17->PlaceHolder = RemoveHtml($this->event_17->caption());
            if (strval($this->event_17->EditValue) != "" && is_numeric($this->event_17->EditValue)) {
                $this->event_17->EditValue = FormatNumber($this->event_17->EditValue, null);
            }

            // event_18
            $this->event_18->setupEditAttributes();
            $this->event_18->EditValue = $this->event_18->CurrentValue;
            $this->event_18->PlaceHolder = RemoveHtml($this->event_18->caption());
            if (strval($this->event_18->EditValue) != "" && is_numeric($this->event_18->EditValue)) {
                $this->event_18->EditValue = FormatNumber($this->event_18->EditValue, null);
            }

            // event_19
            $this->event_19->setupEditAttributes();
            $this->event_19->EditValue = $this->event_19->CurrentValue;
            $this->event_19->PlaceHolder = RemoveHtml($this->event_19->caption());
            if (strval($this->event_19->EditValue) != "" && is_numeric($this->event_19->EditValue)) {
                $this->event_19->EditValue = FormatNumber($this->event_19->EditValue, null);
            }

            // event_20
            $this->event_20->setupEditAttributes();
            $this->event_20->EditValue = $this->event_20->CurrentValue;
            $this->event_20->PlaceHolder = RemoveHtml($this->event_20->caption());
            if (strval($this->event_20->EditValue) != "" && is_numeric($this->event_20->EditValue)) {
                $this->event_20->EditValue = FormatNumber($this->event_20->EditValue, null);
            }

            // Add refer script

            // family_id
            $this->family_id->HrefValue = "";

            // event_id
            $this->event_id->HrefValue = "";

            // event_1
            $this->event_1->HrefValue = "";

            // event_2
            $this->event_2->HrefValue = "";

            // event_3
            $this->event_3->HrefValue = "";

            // event_4
            $this->event_4->HrefValue = "";

            // event_5
            $this->event_5->HrefValue = "";

            // event_6
            $this->event_6->HrefValue = "";

            // event_7
            $this->event_7->HrefValue = "";

            // event_8
            $this->event_8->HrefValue = "";

            // event_9
            $this->event_9->HrefValue = "";

            // event_10
            $this->event_10->HrefValue = "";

            // event_11
            $this->event_11->HrefValue = "";

            // event_12
            $this->event_12->HrefValue = "";

            // event_13
            $this->event_13->HrefValue = "";

            // event_14
            $this->event_14->HrefValue = "";

            // event_15
            $this->event_15->HrefValue = "";

            // event_16
            $this->event_16->HrefValue = "";

            // event_17
            $this->event_17->HrefValue = "";

            // event_18
            $this->event_18->HrefValue = "";

            // event_19
            $this->event_19->HrefValue = "";

            // event_20
            $this->event_20->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->family_id->Visible && $this->family_id->Required) {
                if (!$this->family_id->IsDetailKey && EmptyValue($this->family_id->FormValue)) {
                    $this->family_id->addErrorMessage(str_replace("%s", $this->family_id->caption(), $this->family_id->RequiredErrorMessage));
                }
            }
            if ($this->event_id->Visible && $this->event_id->Required) {
                if (!$this->event_id->IsDetailKey && EmptyValue($this->event_id->FormValue)) {
                    $this->event_id->addErrorMessage(str_replace("%s", $this->event_id->caption(), $this->event_id->RequiredErrorMessage));
                }
            }
            if ($this->event_1->Visible && $this->event_1->Required) {
                if (!$this->event_1->IsDetailKey && EmptyValue($this->event_1->FormValue)) {
                    $this->event_1->addErrorMessage(str_replace("%s", $this->event_1->caption(), $this->event_1->RequiredErrorMessage));
                }
            }
            if ($this->event_2->Visible && $this->event_2->Required) {
                if (!$this->event_2->IsDetailKey && EmptyValue($this->event_2->FormValue)) {
                    $this->event_2->addErrorMessage(str_replace("%s", $this->event_2->caption(), $this->event_2->RequiredErrorMessage));
                }
            }
            if ($this->event_3->Visible && $this->event_3->Required) {
                if (!$this->event_3->IsDetailKey && EmptyValue($this->event_3->FormValue)) {
                    $this->event_3->addErrorMessage(str_replace("%s", $this->event_3->caption(), $this->event_3->RequiredErrorMessage));
                }
            }
            if ($this->event_4->Visible && $this->event_4->Required) {
                if (!$this->event_4->IsDetailKey && EmptyValue($this->event_4->FormValue)) {
                    $this->event_4->addErrorMessage(str_replace("%s", $this->event_4->caption(), $this->event_4->RequiredErrorMessage));
                }
            }
            if ($this->event_5->Visible && $this->event_5->Required) {
                if (!$this->event_5->IsDetailKey && EmptyValue($this->event_5->FormValue)) {
                    $this->event_5->addErrorMessage(str_replace("%s", $this->event_5->caption(), $this->event_5->RequiredErrorMessage));
                }
            }
            if ($this->event_6->Visible && $this->event_6->Required) {
                if (!$this->event_6->IsDetailKey && EmptyValue($this->event_6->FormValue)) {
                    $this->event_6->addErrorMessage(str_replace("%s", $this->event_6->caption(), $this->event_6->RequiredErrorMessage));
                }
            }
            if ($this->event_7->Visible && $this->event_7->Required) {
                if (!$this->event_7->IsDetailKey && EmptyValue($this->event_7->FormValue)) {
                    $this->event_7->addErrorMessage(str_replace("%s", $this->event_7->caption(), $this->event_7->RequiredErrorMessage));
                }
            }
            if ($this->event_8->Visible && $this->event_8->Required) {
                if (!$this->event_8->IsDetailKey && EmptyValue($this->event_8->FormValue)) {
                    $this->event_8->addErrorMessage(str_replace("%s", $this->event_8->caption(), $this->event_8->RequiredErrorMessage));
                }
            }
            if ($this->event_9->Visible && $this->event_9->Required) {
                if (!$this->event_9->IsDetailKey && EmptyValue($this->event_9->FormValue)) {
                    $this->event_9->addErrorMessage(str_replace("%s", $this->event_9->caption(), $this->event_9->RequiredErrorMessage));
                }
            }
            if ($this->event_10->Visible && $this->event_10->Required) {
                if (!$this->event_10->IsDetailKey && EmptyValue($this->event_10->FormValue)) {
                    $this->event_10->addErrorMessage(str_replace("%s", $this->event_10->caption(), $this->event_10->RequiredErrorMessage));
                }
            }
            if ($this->event_11->Visible && $this->event_11->Required) {
                if (!$this->event_11->IsDetailKey && EmptyValue($this->event_11->FormValue)) {
                    $this->event_11->addErrorMessage(str_replace("%s", $this->event_11->caption(), $this->event_11->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_11->FormValue)) {
                $this->event_11->addErrorMessage($this->event_11->getErrorMessage(false));
            }
            if ($this->event_12->Visible && $this->event_12->Required) {
                if (!$this->event_12->IsDetailKey && EmptyValue($this->event_12->FormValue)) {
                    $this->event_12->addErrorMessage(str_replace("%s", $this->event_12->caption(), $this->event_12->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_12->FormValue)) {
                $this->event_12->addErrorMessage($this->event_12->getErrorMessage(false));
            }
            if ($this->event_13->Visible && $this->event_13->Required) {
                if (!$this->event_13->IsDetailKey && EmptyValue($this->event_13->FormValue)) {
                    $this->event_13->addErrorMessage(str_replace("%s", $this->event_13->caption(), $this->event_13->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_13->FormValue)) {
                $this->event_13->addErrorMessage($this->event_13->getErrorMessage(false));
            }
            if ($this->event_14->Visible && $this->event_14->Required) {
                if (!$this->event_14->IsDetailKey && EmptyValue($this->event_14->FormValue)) {
                    $this->event_14->addErrorMessage(str_replace("%s", $this->event_14->caption(), $this->event_14->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_14->FormValue)) {
                $this->event_14->addErrorMessage($this->event_14->getErrorMessage(false));
            }
            if ($this->event_15->Visible && $this->event_15->Required) {
                if (!$this->event_15->IsDetailKey && EmptyValue($this->event_15->FormValue)) {
                    $this->event_15->addErrorMessage(str_replace("%s", $this->event_15->caption(), $this->event_15->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_15->FormValue)) {
                $this->event_15->addErrorMessage($this->event_15->getErrorMessage(false));
            }
            if ($this->event_16->Visible && $this->event_16->Required) {
                if (!$this->event_16->IsDetailKey && EmptyValue($this->event_16->FormValue)) {
                    $this->event_16->addErrorMessage(str_replace("%s", $this->event_16->caption(), $this->event_16->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_16->FormValue)) {
                $this->event_16->addErrorMessage($this->event_16->getErrorMessage(false));
            }
            if ($this->event_17->Visible && $this->event_17->Required) {
                if (!$this->event_17->IsDetailKey && EmptyValue($this->event_17->FormValue)) {
                    $this->event_17->addErrorMessage(str_replace("%s", $this->event_17->caption(), $this->event_17->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_17->FormValue)) {
                $this->event_17->addErrorMessage($this->event_17->getErrorMessage(false));
            }
            if ($this->event_18->Visible && $this->event_18->Required) {
                if (!$this->event_18->IsDetailKey && EmptyValue($this->event_18->FormValue)) {
                    $this->event_18->addErrorMessage(str_replace("%s", $this->event_18->caption(), $this->event_18->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_18->FormValue)) {
                $this->event_18->addErrorMessage($this->event_18->getErrorMessage(false));
            }
            if ($this->event_19->Visible && $this->event_19->Required) {
                if (!$this->event_19->IsDetailKey && EmptyValue($this->event_19->FormValue)) {
                    $this->event_19->addErrorMessage(str_replace("%s", $this->event_19->caption(), $this->event_19->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_19->FormValue)) {
                $this->event_19->addErrorMessage($this->event_19->getErrorMessage(false));
            }
            if ($this->event_20->Visible && $this->event_20->Required) {
                if (!$this->event_20->IsDetailKey && EmptyValue($this->event_20->FormValue)) {
                    $this->event_20->addErrorMessage(str_replace("%s", $this->event_20->caption(), $this->event_20->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->event_20->FormValue)) {
                $this->event_20->addErrorMessage($this->event_20->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // family_id
        $this->family_id->setDbValueDef($rsnew, $this->family_id->CurrentValue, false);

        // event_id
        $this->event_id->setDbValueDef($rsnew, $this->event_id->CurrentValue, false);

        // event_1
        $this->event_1->setDbValueDef($rsnew, $this->event_1->CurrentValue, strval($this->event_1->CurrentValue) == "");

        // event_2
        $this->event_2->setDbValueDef($rsnew, $this->event_2->CurrentValue, strval($this->event_2->CurrentValue) == "");

        // event_3
        $this->event_3->setDbValueDef($rsnew, $this->event_3->CurrentValue, strval($this->event_3->CurrentValue) == "");

        // event_4
        $this->event_4->setDbValueDef($rsnew, $this->event_4->CurrentValue, strval($this->event_4->CurrentValue) == "");

        // event_5
        $this->event_5->setDbValueDef($rsnew, $this->event_5->CurrentValue, strval($this->event_5->CurrentValue) == "");

        // event_6
        $this->event_6->setDbValueDef($rsnew, $this->event_6->CurrentValue, strval($this->event_6->CurrentValue) == "");

        // event_7
        $this->event_7->setDbValueDef($rsnew, $this->event_7->CurrentValue, strval($this->event_7->CurrentValue) == "");

        // event_8
        $this->event_8->setDbValueDef($rsnew, $this->event_8->CurrentValue, strval($this->event_8->CurrentValue) == "");

        // event_9
        $this->event_9->setDbValueDef($rsnew, $this->event_9->CurrentValue, strval($this->event_9->CurrentValue) == "");

        // event_10
        $this->event_10->setDbValueDef($rsnew, $this->event_10->CurrentValue, strval($this->event_10->CurrentValue) == "");

        // event_11
        $this->event_11->setDbValueDef($rsnew, $this->event_11->CurrentValue, strval($this->event_11->CurrentValue) == "");

        // event_12
        $this->event_12->setDbValueDef($rsnew, $this->event_12->CurrentValue, strval($this->event_12->CurrentValue) == "");

        // event_13
        $this->event_13->setDbValueDef($rsnew, $this->event_13->CurrentValue, strval($this->event_13->CurrentValue) == "");

        // event_14
        $this->event_14->setDbValueDef($rsnew, $this->event_14->CurrentValue, strval($this->event_14->CurrentValue) == "");

        // event_15
        $this->event_15->setDbValueDef($rsnew, $this->event_15->CurrentValue, strval($this->event_15->CurrentValue) == "");

        // event_16
        $this->event_16->setDbValueDef($rsnew, $this->event_16->CurrentValue, strval($this->event_16->CurrentValue) == "");

        // event_17
        $this->event_17->setDbValueDef($rsnew, $this->event_17->CurrentValue, strval($this->event_17->CurrentValue) == "");

        // event_18
        $this->event_18->setDbValueDef($rsnew, $this->event_18->CurrentValue, strval($this->event_18->CurrentValue) == "");

        // event_19
        $this->event_19->setDbValueDef($rsnew, $this->event_19->CurrentValue, strval($this->event_19->CurrentValue) == "");

        // event_20
        $this->event_20->setDbValueDef($rsnew, $this->event_20->CurrentValue, strval($this->event_20->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['family_id'])) { // family_id
            $this->family_id->setFormValue($row['family_id']);
        }
        if (isset($row['event_id'])) { // event_id
            $this->event_id->setFormValue($row['event_id']);
        }
        if (isset($row['event_1'])) { // event_1
            $this->event_1->setFormValue($row['event_1']);
        }
        if (isset($row['event_2'])) { // event_2
            $this->event_2->setFormValue($row['event_2']);
        }
        if (isset($row['event_3'])) { // event_3
            $this->event_3->setFormValue($row['event_3']);
        }
        if (isset($row['event_4'])) { // event_4
            $this->event_4->setFormValue($row['event_4']);
        }
        if (isset($row['event_5'])) { // event_5
            $this->event_5->setFormValue($row['event_5']);
        }
        if (isset($row['event_6'])) { // event_6
            $this->event_6->setFormValue($row['event_6']);
        }
        if (isset($row['event_7'])) { // event_7
            $this->event_7->setFormValue($row['event_7']);
        }
        if (isset($row['event_8'])) { // event_8
            $this->event_8->setFormValue($row['event_8']);
        }
        if (isset($row['event_9'])) { // event_9
            $this->event_9->setFormValue($row['event_9']);
        }
        if (isset($row['event_10'])) { // event_10
            $this->event_10->setFormValue($row['event_10']);
        }
        if (isset($row['event_11'])) { // event_11
            $this->event_11->setFormValue($row['event_11']);
        }
        if (isset($row['event_12'])) { // event_12
            $this->event_12->setFormValue($row['event_12']);
        }
        if (isset($row['event_13'])) { // event_13
            $this->event_13->setFormValue($row['event_13']);
        }
        if (isset($row['event_14'])) { // event_14
            $this->event_14->setFormValue($row['event_14']);
        }
        if (isset($row['event_15'])) { // event_15
            $this->event_15->setFormValue($row['event_15']);
        }
        if (isset($row['event_16'])) { // event_16
            $this->event_16->setFormValue($row['event_16']);
        }
        if (isset($row['event_17'])) { // event_17
            $this->event_17->setFormValue($row['event_17']);
        }
        if (isset($row['event_18'])) { // event_18
            $this->event_18->setFormValue($row['event_18']);
        }
        if (isset($row['event_19'])) { // event_19
            $this->event_19->setFormValue($row['event_19']);
        }
        if (isset($row['event_20'])) { // event_20
            $this->event_20->setFormValue($row['event_20']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("familyeventestimatelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_family_id":
                    break;
                case "x_event_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
