<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for family_event_estimate
 */
class FamilyEventEstimate extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $family_id;
    public $event_id;
    public $event_1;
    public $event_2;
    public $event_3;
    public $event_4;
    public $event_5;
    public $event_6;
    public $event_7;
    public $event_8;
    public $event_9;
    public $event_10;
    public $event_11;
    public $event_12;
    public $event_13;
    public $event_14;
    public $event_15;
    public $event_16;
    public $event_17;
    public $event_18;
    public $event_19;
    public $event_20;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "family_event_estimate";
        $this->TableName = 'family_event_estimate';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "family_event_estimate";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // family_id
        $this->family_id = new DbField(
            $this, // Table
            'x_family_id', // Variable name
            'family_id', // Name
            '`family_id`', // Expression
            '`family_id`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`family_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->family_id->InputTextType = "text";
        $this->family_id->Raw = true;
        $this->family_id->setSelectMultiple(false); // Select one
        $this->family_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->family_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->family_id->UseFilter = true; // Table header filter
        $this->family_id->Lookup = new Lookup($this->family_id, 'family_info', true, 'id', ["name","father_name","mobile",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->family_id) . "',COALESCE(`father_name`,''),'" . ValueSeparator(2, $this->family_id) . "',COALESCE(`mobile`,''))");
        $this->family_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->family_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['family_id'] = &$this->family_id;

        // event_id
        $this->event_id = new DbField(
            $this, // Table
            'x_event_id', // Variable name
            'event_id', // Name
            '`event_id`', // Expression
            '`event_id`', // Basic search expression
            2, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->event_id->addMethod("getSelectFilter", fn() => "`event_type`=0 and `status`=1");
        $this->event_id->InputTextType = "text";
        $this->event_id->Raw = true;
        $this->event_id->setSelectMultiple(false); // Select one
        $this->event_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->event_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->event_id->Lookup = new Lookup($this->event_id, 'family_event_list', false, 'id', ["event_name","","",""], '', '', [], [], [], [], [], [], false, '`event_name` ASC', '', "`event_name`");
        $this->event_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_id'] = &$this->event_id;

        // event_1
        $this->event_1 = new DbField(
            $this, // Table
            'x_event_1', // Variable name
            'event_1', // Name
            '`event_1`', // Expression
            '`event_1`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_1->addMethod("getDefault", fn() => 0);
        $this->event_1->InputTextType = "text";
        $this->event_1->Raw = true;
        $this->event_1->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_1'] = &$this->event_1;

        // event_2
        $this->event_2 = new DbField(
            $this, // Table
            'x_event_2', // Variable name
            'event_2', // Name
            '`event_2`', // Expression
            '`event_2`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_2->addMethod("getDefault", fn() => 0);
        $this->event_2->InputTextType = "text";
        $this->event_2->Raw = true;
        $this->event_2->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_2'] = &$this->event_2;

        // event_3
        $this->event_3 = new DbField(
            $this, // Table
            'x_event_3', // Variable name
            'event_3', // Name
            '`event_3`', // Expression
            '`event_3`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_3`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_3->addMethod("getDefault", fn() => 0);
        $this->event_3->InputTextType = "text";
        $this->event_3->Raw = true;
        $this->event_3->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_3'] = &$this->event_3;

        // event_4
        $this->event_4 = new DbField(
            $this, // Table
            'x_event_4', // Variable name
            'event_4', // Name
            '`event_4`', // Expression
            '`event_4`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_4`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_4->addMethod("getDefault", fn() => 0);
        $this->event_4->InputTextType = "text";
        $this->event_4->Raw = true;
        $this->event_4->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_4'] = &$this->event_4;

        // event_5
        $this->event_5 = new DbField(
            $this, // Table
            'x_event_5', // Variable name
            'event_5', // Name
            '`event_5`', // Expression
            '`event_5`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_5`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_5->addMethod("getDefault", fn() => 0);
        $this->event_5->InputTextType = "text";
        $this->event_5->Raw = true;
        $this->event_5->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_5'] = &$this->event_5;

        // event_6
        $this->event_6 = new DbField(
            $this, // Table
            'x_event_6', // Variable name
            'event_6', // Name
            '`event_6`', // Expression
            '`event_6`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_6`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_6->addMethod("getDefault", fn() => 0);
        $this->event_6->InputTextType = "text";
        $this->event_6->Raw = true;
        $this->event_6->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_6'] = &$this->event_6;

        // event_7
        $this->event_7 = new DbField(
            $this, // Table
            'x_event_7', // Variable name
            'event_7', // Name
            '`event_7`', // Expression
            '`event_7`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_7`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_7->addMethod("getDefault", fn() => 0);
        $this->event_7->InputTextType = "text";
        $this->event_7->Raw = true;
        $this->event_7->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_7'] = &$this->event_7;

        // event_8
        $this->event_8 = new DbField(
            $this, // Table
            'x_event_8', // Variable name
            'event_8', // Name
            '`event_8`', // Expression
            '`event_8`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_8`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_8->addMethod("getDefault", fn() => 0);
        $this->event_8->InputTextType = "text";
        $this->event_8->Raw = true;
        $this->event_8->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_8'] = &$this->event_8;

        // event_9
        $this->event_9 = new DbField(
            $this, // Table
            'x_event_9', // Variable name
            'event_9', // Name
            '`event_9`', // Expression
            '`event_9`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_9`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_9->addMethod("getDefault", fn() => 0);
        $this->event_9->InputTextType = "text";
        $this->event_9->Raw = true;
        $this->event_9->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_9'] = &$this->event_9;

        // event_10
        $this->event_10 = new DbField(
            $this, // Table
            'x_event_10', // Variable name
            'event_10', // Name
            '`event_10`', // Expression
            '`event_10`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_10->addMethod("getDefault", fn() => 0);
        $this->event_10->InputTextType = "text";
        $this->event_10->Raw = true;
        $this->event_10->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['event_10'] = &$this->event_10;

        // event_11
        $this->event_11 = new DbField(
            $this, // Table
            'x_event_11', // Variable name
            'event_11', // Name
            '`event_11`', // Expression
            '`event_11`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_11->addMethod("getDefault", fn() => 0);
        $this->event_11->InputTextType = "text";
        $this->event_11->Raw = true;
        $this->event_11->Nullable = false; // NOT NULL field
        $this->event_11->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_11'] = &$this->event_11;

        // event_12
        $this->event_12 = new DbField(
            $this, // Table
            'x_event_12', // Variable name
            'event_12', // Name
            '`event_12`', // Expression
            '`event_12`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_12->addMethod("getDefault", fn() => 0);
        $this->event_12->InputTextType = "text";
        $this->event_12->Raw = true;
        $this->event_12->Nullable = false; // NOT NULL field
        $this->event_12->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_12'] = &$this->event_12;

        // event_13
        $this->event_13 = new DbField(
            $this, // Table
            'x_event_13', // Variable name
            'event_13', // Name
            '`event_13`', // Expression
            '`event_13`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_13`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_13->addMethod("getDefault", fn() => 0);
        $this->event_13->InputTextType = "text";
        $this->event_13->Raw = true;
        $this->event_13->Nullable = false; // NOT NULL field
        $this->event_13->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_13->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_13'] = &$this->event_13;

        // event_14
        $this->event_14 = new DbField(
            $this, // Table
            'x_event_14', // Variable name
            'event_14', // Name
            '`event_14`', // Expression
            '`event_14`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_14`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_14->addMethod("getDefault", fn() => 0);
        $this->event_14->InputTextType = "text";
        $this->event_14->Raw = true;
        $this->event_14->Nullable = false; // NOT NULL field
        $this->event_14->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_14->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_14'] = &$this->event_14;

        // event_15
        $this->event_15 = new DbField(
            $this, // Table
            'x_event_15', // Variable name
            'event_15', // Name
            '`event_15`', // Expression
            '`event_15`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_15`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_15->addMethod("getDefault", fn() => 0);
        $this->event_15->InputTextType = "text";
        $this->event_15->Raw = true;
        $this->event_15->Nullable = false; // NOT NULL field
        $this->event_15->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_15->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_15'] = &$this->event_15;

        // event_16
        $this->event_16 = new DbField(
            $this, // Table
            'x_event_16', // Variable name
            'event_16', // Name
            '`event_16`', // Expression
            '`event_16`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_16`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_16->addMethod("getDefault", fn() => 0);
        $this->event_16->InputTextType = "text";
        $this->event_16->Raw = true;
        $this->event_16->Nullable = false; // NOT NULL field
        $this->event_16->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_16->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_16'] = &$this->event_16;

        // event_17
        $this->event_17 = new DbField(
            $this, // Table
            'x_event_17', // Variable name
            'event_17', // Name
            '`event_17`', // Expression
            '`event_17`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_17`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_17->addMethod("getDefault", fn() => 0);
        $this->event_17->InputTextType = "text";
        $this->event_17->Raw = true;
        $this->event_17->Nullable = false; // NOT NULL field
        $this->event_17->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_17->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_17'] = &$this->event_17;

        // event_18
        $this->event_18 = new DbField(
            $this, // Table
            'x_event_18', // Variable name
            'event_18', // Name
            '`event_18`', // Expression
            '`event_18`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_18`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_18->addMethod("getDefault", fn() => 0);
        $this->event_18->InputTextType = "text";
        $this->event_18->Raw = true;
        $this->event_18->Nullable = false; // NOT NULL field
        $this->event_18->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_18->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_18'] = &$this->event_18;

        // event_19
        $this->event_19 = new DbField(
            $this, // Table
            'x_event_19', // Variable name
            'event_19', // Name
            '`event_19`', // Expression
            '`event_19`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_19`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_19->addMethod("getDefault", fn() => 0);
        $this->event_19->InputTextType = "text";
        $this->event_19->Raw = true;
        $this->event_19->Nullable = false; // NOT NULL field
        $this->event_19->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_19->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_19'] = &$this->event_19;

        // event_20
        $this->event_20 = new DbField(
            $this, // Table
            'x_event_20', // Variable name
            'event_20', // Name
            '`event_20`', // Expression
            '`event_20`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`event_20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->event_20->addMethod("getDefault", fn() => 0);
        $this->event_20->InputTextType = "text";
        $this->event_20->Raw = true;
        $this->event_20->Nullable = false; // NOT NULL field
        $this->event_20->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->event_20->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['event_20'] = &$this->event_20;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getSelectFilter", fn() => "`activated`=1");
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Sortable = false; // Allow sort
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Sortable = false; // Allow sort
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "family_event_estimate";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->family_id->DbValue = $row['family_id'];
        $this->event_id->DbValue = $row['event_id'];
        $this->event_1->DbValue = $row['event_1'];
        $this->event_2->DbValue = $row['event_2'];
        $this->event_3->DbValue = $row['event_3'];
        $this->event_4->DbValue = $row['event_4'];
        $this->event_5->DbValue = $row['event_5'];
        $this->event_6->DbValue = $row['event_6'];
        $this->event_7->DbValue = $row['event_7'];
        $this->event_8->DbValue = $row['event_8'];
        $this->event_9->DbValue = $row['event_9'];
        $this->event_10->DbValue = $row['event_10'];
        $this->event_11->DbValue = $row['event_11'];
        $this->event_12->DbValue = $row['event_12'];
        $this->event_13->DbValue = $row['event_13'];
        $this->event_14->DbValue = $row['event_14'];
        $this->event_15->DbValue = $row['event_15'];
        $this->event_16->DbValue = $row['event_16'];
        $this->event_17->DbValue = $row['event_17'];
        $this->event_18->DbValue = $row['event_18'];
        $this->event_19->DbValue = $row['event_19'];
        $this->event_20->DbValue = $row['event_20'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("familyeventestimatelist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "familyeventestimateview" => $Language->phrase("View"),
            "familyeventestimateedit" => $Language->phrase("Edit"),
            "familyeventestimateadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "familyeventestimatelist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "FamilyEventEstimateView",
            Config("API_ADD_ACTION") => "FamilyEventEstimateAdd",
            Config("API_EDIT_ACTION") => "FamilyEventEstimateEdit",
            Config("API_DELETE_ACTION") => "FamilyEventEstimateDelete",
            Config("API_LIST_ACTION") => "FamilyEventEstimateList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "familyeventestimatelist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("familyeventestimateview", $parm);
        } else {
            $url = $this->keyUrl("familyeventestimateview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "familyeventestimateadd?" . $parm;
        } else {
            $url = "familyeventestimateadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("familyeventestimateedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("familyeventestimatelist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("familyeventestimateadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("familyeventestimatelist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("familyeventestimatedelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->family_id->setDbValue($row['family_id']);
        $this->event_id->setDbValue($row['event_id']);
        $this->event_1->setDbValue($row['event_1']);
        $this->event_2->setDbValue($row['event_2']);
        $this->event_3->setDbValue($row['event_3']);
        $this->event_4->setDbValue($row['event_4']);
        $this->event_5->setDbValue($row['event_5']);
        $this->event_6->setDbValue($row['event_6']);
        $this->event_7->setDbValue($row['event_7']);
        $this->event_8->setDbValue($row['event_8']);
        $this->event_9->setDbValue($row['event_9']);
        $this->event_10->setDbValue($row['event_10']);
        $this->event_11->setDbValue($row['event_11']);
        $this->event_12->setDbValue($row['event_12']);
        $this->event_13->setDbValue($row['event_13']);
        $this->event_14->setDbValue($row['event_14']);
        $this->event_15->setDbValue($row['event_15']);
        $this->event_16->setDbValue($row['event_16']);
        $this->event_17->setDbValue($row['event_17']);
        $this->event_18->setDbValue($row['event_18']);
        $this->event_19->setDbValue($row['event_19']);
        $this->event_20->setDbValue($row['event_20']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "FamilyEventEstimateList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // family_id

        // event_id

        // event_1

        // event_2

        // event_3

        // event_4

        // event_5

        // event_6

        // event_7

        // event_8

        // event_9

        // event_10

        // event_11

        // event_12

        // event_13

        // event_14

        // event_15

        // event_16

        // event_17

        // event_18

        // event_19

        // event_20

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // family_id
        $curVal = strval($this->family_id->CurrentValue);
        if ($curVal != "") {
            $this->family_id->ViewValue = $this->family_id->lookupCacheOption($curVal);
            if ($this->family_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->family_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->family_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->family_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->family_id->Lookup->renderViewRow($rswrk[0]);
                    $this->family_id->ViewValue = $this->family_id->displayValue($arwrk);
                } else {
                    $this->family_id->ViewValue = FormatNumber($this->family_id->CurrentValue, $this->family_id->formatPattern());
                }
            }
        } else {
            $this->family_id->ViewValue = null;
        }

        // event_id
        $curVal = strval($this->event_id->CurrentValue);
        if ($curVal != "") {
            $this->event_id->ViewValue = $this->event_id->lookupCacheOption($curVal);
            if ($this->event_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->event_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->event_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->event_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->event_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->event_id->Lookup->renderViewRow($rswrk[0]);
                    $this->event_id->ViewValue = $this->event_id->displayValue($arwrk);
                } else {
                    $this->event_id->ViewValue = FormatNumber($this->event_id->CurrentValue, $this->event_id->formatPattern());
                }
            }
        } else {
            $this->event_id->ViewValue = null;
        }

        // event_1
        $this->event_1->ViewValue = $this->event_1->CurrentValue;

        // event_2
        $this->event_2->ViewValue = $this->event_2->CurrentValue;

        // event_3
        $this->event_3->ViewValue = $this->event_3->CurrentValue;

        // event_4
        $this->event_4->ViewValue = $this->event_4->CurrentValue;

        // event_5
        $this->event_5->ViewValue = $this->event_5->CurrentValue;

        // event_6
        $this->event_6->ViewValue = $this->event_6->CurrentValue;

        // event_7
        $this->event_7->ViewValue = $this->event_7->CurrentValue;

        // event_8
        $this->event_8->ViewValue = $this->event_8->CurrentValue;

        // event_9
        $this->event_9->ViewValue = $this->event_9->CurrentValue;

        // event_10
        $this->event_10->ViewValue = $this->event_10->CurrentValue;

        // event_11
        $this->event_11->ViewValue = $this->event_11->CurrentValue;
        $this->event_11->ViewValue = FormatNumber($this->event_11->ViewValue, $this->event_11->formatPattern());

        // event_12
        $this->event_12->ViewValue = $this->event_12->CurrentValue;
        $this->event_12->ViewValue = FormatNumber($this->event_12->ViewValue, $this->event_12->formatPattern());

        // event_13
        $this->event_13->ViewValue = $this->event_13->CurrentValue;
        $this->event_13->ViewValue = FormatNumber($this->event_13->ViewValue, $this->event_13->formatPattern());

        // event_14
        $this->event_14->ViewValue = $this->event_14->CurrentValue;
        $this->event_14->ViewValue = FormatNumber($this->event_14->ViewValue, $this->event_14->formatPattern());

        // event_15
        $this->event_15->ViewValue = $this->event_15->CurrentValue;
        $this->event_15->ViewValue = FormatNumber($this->event_15->ViewValue, $this->event_15->formatPattern());

        // event_16
        $this->event_16->ViewValue = $this->event_16->CurrentValue;
        $this->event_16->ViewValue = FormatNumber($this->event_16->ViewValue, $this->event_16->formatPattern());

        // event_17
        $this->event_17->ViewValue = $this->event_17->CurrentValue;
        $this->event_17->ViewValue = FormatNumber($this->event_17->ViewValue, $this->event_17->formatPattern());

        // event_18
        $this->event_18->ViewValue = $this->event_18->CurrentValue;
        $this->event_18->ViewValue = FormatNumber($this->event_18->ViewValue, $this->event_18->formatPattern());

        // event_19
        $this->event_19->ViewValue = $this->event_19->CurrentValue;
        $this->event_19->ViewValue = FormatNumber($this->event_19->ViewValue, $this->event_19->formatPattern());

        // event_20
        $this->event_20->ViewValue = $this->event_20->CurrentValue;
        $this->event_20->ViewValue = FormatNumber($this->event_20->ViewValue, $this->event_20->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // family_id
        $this->family_id->HrefValue = "";
        $this->family_id->TooltipValue = "";

        // event_id
        $this->event_id->HrefValue = "";
        $this->event_id->TooltipValue = "";

        // event_1
        $this->event_1->HrefValue = "";
        $this->event_1->TooltipValue = "";

        // event_2
        $this->event_2->HrefValue = "";
        $this->event_2->TooltipValue = "";

        // event_3
        $this->event_3->HrefValue = "";
        $this->event_3->TooltipValue = "";

        // event_4
        $this->event_4->HrefValue = "";
        $this->event_4->TooltipValue = "";

        // event_5
        $this->event_5->HrefValue = "";
        $this->event_5->TooltipValue = "";

        // event_6
        $this->event_6->HrefValue = "";
        $this->event_6->TooltipValue = "";

        // event_7
        $this->event_7->HrefValue = "";
        $this->event_7->TooltipValue = "";

        // event_8
        $this->event_8->HrefValue = "";
        $this->event_8->TooltipValue = "";

        // event_9
        $this->event_9->HrefValue = "";
        $this->event_9->TooltipValue = "";

        // event_10
        $this->event_10->HrefValue = "";
        $this->event_10->TooltipValue = "";

        // event_11
        $this->event_11->HrefValue = "";
        $this->event_11->TooltipValue = "";

        // event_12
        $this->event_12->HrefValue = "";
        $this->event_12->TooltipValue = "";

        // event_13
        $this->event_13->HrefValue = "";
        $this->event_13->TooltipValue = "";

        // event_14
        $this->event_14->HrefValue = "";
        $this->event_14->TooltipValue = "";

        // event_15
        $this->event_15->HrefValue = "";
        $this->event_15->TooltipValue = "";

        // event_16
        $this->event_16->HrefValue = "";
        $this->event_16->TooltipValue = "";

        // event_17
        $this->event_17->HrefValue = "";
        $this->event_17->TooltipValue = "";

        // event_18
        $this->event_18->HrefValue = "";
        $this->event_18->TooltipValue = "";

        // event_19
        $this->event_19->HrefValue = "";
        $this->event_19->TooltipValue = "";

        // event_20
        $this->event_20->HrefValue = "";
        $this->event_20->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // family_id
        $this->family_id->setupEditAttributes();
        $this->family_id->PlaceHolder = RemoveHtml($this->family_id->caption());

        // event_id
        $this->event_id->setupEditAttributes();
        $this->event_id->PlaceHolder = RemoveHtml($this->event_id->caption());

        // event_1
        $this->event_1->setupEditAttributes();
        $this->event_1->EditValue = $this->event_1->CurrentValue;
        $this->event_1->PlaceHolder = RemoveHtml($this->event_1->caption());
        if (strval($this->event_1->EditValue) != "" && is_numeric($this->event_1->EditValue)) {
            $this->event_1->EditValue = $this->event_1->EditValue;
        }

        // event_2
        $this->event_2->setupEditAttributes();
        $this->event_2->EditValue = $this->event_2->CurrentValue;
        $this->event_2->PlaceHolder = RemoveHtml($this->event_2->caption());
        if (strval($this->event_2->EditValue) != "" && is_numeric($this->event_2->EditValue)) {
            $this->event_2->EditValue = $this->event_2->EditValue;
        }

        // event_3
        $this->event_3->setupEditAttributes();
        $this->event_3->EditValue = $this->event_3->CurrentValue;
        $this->event_3->PlaceHolder = RemoveHtml($this->event_3->caption());
        if (strval($this->event_3->EditValue) != "" && is_numeric($this->event_3->EditValue)) {
            $this->event_3->EditValue = $this->event_3->EditValue;
        }

        // event_4
        $this->event_4->setupEditAttributes();
        $this->event_4->EditValue = $this->event_4->CurrentValue;
        $this->event_4->PlaceHolder = RemoveHtml($this->event_4->caption());
        if (strval($this->event_4->EditValue) != "" && is_numeric($this->event_4->EditValue)) {
            $this->event_4->EditValue = $this->event_4->EditValue;
        }

        // event_5
        $this->event_5->setupEditAttributes();
        $this->event_5->EditValue = $this->event_5->CurrentValue;
        $this->event_5->PlaceHolder = RemoveHtml($this->event_5->caption());
        if (strval($this->event_5->EditValue) != "" && is_numeric($this->event_5->EditValue)) {
            $this->event_5->EditValue = $this->event_5->EditValue;
        }

        // event_6
        $this->event_6->setupEditAttributes();
        $this->event_6->EditValue = $this->event_6->CurrentValue;
        $this->event_6->PlaceHolder = RemoveHtml($this->event_6->caption());
        if (strval($this->event_6->EditValue) != "" && is_numeric($this->event_6->EditValue)) {
            $this->event_6->EditValue = $this->event_6->EditValue;
        }

        // event_7
        $this->event_7->setupEditAttributes();
        $this->event_7->EditValue = $this->event_7->CurrentValue;
        $this->event_7->PlaceHolder = RemoveHtml($this->event_7->caption());
        if (strval($this->event_7->EditValue) != "" && is_numeric($this->event_7->EditValue)) {
            $this->event_7->EditValue = $this->event_7->EditValue;
        }

        // event_8
        $this->event_8->setupEditAttributes();
        $this->event_8->EditValue = $this->event_8->CurrentValue;
        $this->event_8->PlaceHolder = RemoveHtml($this->event_8->caption());
        if (strval($this->event_8->EditValue) != "" && is_numeric($this->event_8->EditValue)) {
            $this->event_8->EditValue = $this->event_8->EditValue;
        }

        // event_9
        $this->event_9->setupEditAttributes();
        $this->event_9->EditValue = $this->event_9->CurrentValue;
        $this->event_9->PlaceHolder = RemoveHtml($this->event_9->caption());
        if (strval($this->event_9->EditValue) != "" && is_numeric($this->event_9->EditValue)) {
            $this->event_9->EditValue = $this->event_9->EditValue;
        }

        // event_10
        $this->event_10->setupEditAttributes();
        $this->event_10->EditValue = $this->event_10->CurrentValue;
        $this->event_10->PlaceHolder = RemoveHtml($this->event_10->caption());
        if (strval($this->event_10->EditValue) != "" && is_numeric($this->event_10->EditValue)) {
            $this->event_10->EditValue = $this->event_10->EditValue;
        }

        // event_11
        $this->event_11->setupEditAttributes();
        $this->event_11->EditValue = $this->event_11->CurrentValue;
        $this->event_11->PlaceHolder = RemoveHtml($this->event_11->caption());
        if (strval($this->event_11->EditValue) != "" && is_numeric($this->event_11->EditValue)) {
            $this->event_11->EditValue = FormatNumber($this->event_11->EditValue, null);
        }

        // event_12
        $this->event_12->setupEditAttributes();
        $this->event_12->EditValue = $this->event_12->CurrentValue;
        $this->event_12->PlaceHolder = RemoveHtml($this->event_12->caption());
        if (strval($this->event_12->EditValue) != "" && is_numeric($this->event_12->EditValue)) {
            $this->event_12->EditValue = FormatNumber($this->event_12->EditValue, null);
        }

        // event_13
        $this->event_13->setupEditAttributes();
        $this->event_13->EditValue = $this->event_13->CurrentValue;
        $this->event_13->PlaceHolder = RemoveHtml($this->event_13->caption());
        if (strval($this->event_13->EditValue) != "" && is_numeric($this->event_13->EditValue)) {
            $this->event_13->EditValue = FormatNumber($this->event_13->EditValue, null);
        }

        // event_14
        $this->event_14->setupEditAttributes();
        $this->event_14->EditValue = $this->event_14->CurrentValue;
        $this->event_14->PlaceHolder = RemoveHtml($this->event_14->caption());
        if (strval($this->event_14->EditValue) != "" && is_numeric($this->event_14->EditValue)) {
            $this->event_14->EditValue = FormatNumber($this->event_14->EditValue, null);
        }

        // event_15
        $this->event_15->setupEditAttributes();
        $this->event_15->EditValue = $this->event_15->CurrentValue;
        $this->event_15->PlaceHolder = RemoveHtml($this->event_15->caption());
        if (strval($this->event_15->EditValue) != "" && is_numeric($this->event_15->EditValue)) {
            $this->event_15->EditValue = FormatNumber($this->event_15->EditValue, null);
        }

        // event_16
        $this->event_16->setupEditAttributes();
        $this->event_16->EditValue = $this->event_16->CurrentValue;
        $this->event_16->PlaceHolder = RemoveHtml($this->event_16->caption());
        if (strval($this->event_16->EditValue) != "" && is_numeric($this->event_16->EditValue)) {
            $this->event_16->EditValue = FormatNumber($this->event_16->EditValue, null);
        }

        // event_17
        $this->event_17->setupEditAttributes();
        $this->event_17->EditValue = $this->event_17->CurrentValue;
        $this->event_17->PlaceHolder = RemoveHtml($this->event_17->caption());
        if (strval($this->event_17->EditValue) != "" && is_numeric($this->event_17->EditValue)) {
            $this->event_17->EditValue = FormatNumber($this->event_17->EditValue, null);
        }

        // event_18
        $this->event_18->setupEditAttributes();
        $this->event_18->EditValue = $this->event_18->CurrentValue;
        $this->event_18->PlaceHolder = RemoveHtml($this->event_18->caption());
        if (strval($this->event_18->EditValue) != "" && is_numeric($this->event_18->EditValue)) {
            $this->event_18->EditValue = FormatNumber($this->event_18->EditValue, null);
        }

        // event_19
        $this->event_19->setupEditAttributes();
        $this->event_19->EditValue = $this->event_19->CurrentValue;
        $this->event_19->PlaceHolder = RemoveHtml($this->event_19->caption());
        if (strval($this->event_19->EditValue) != "" && is_numeric($this->event_19->EditValue)) {
            $this->event_19->EditValue = FormatNumber($this->event_19->EditValue, null);
        }

        // event_20
        $this->event_20->setupEditAttributes();
        $this->event_20->EditValue = $this->event_20->CurrentValue;
        $this->event_20->PlaceHolder = RemoveHtml($this->event_20->caption());
        if (strval($this->event_20->EditValue) != "" && is_numeric($this->event_20->EditValue)) {
            $this->event_20->EditValue = FormatNumber($this->event_20->EditValue, null);
        }

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->event_1->CurrentValue)) {
                $this->event_1->Total += $this->event_1->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_2->CurrentValue)) {
                $this->event_2->Total += $this->event_2->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_3->CurrentValue)) {
                $this->event_3->Total += $this->event_3->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_4->CurrentValue)) {
                $this->event_4->Total += $this->event_4->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_5->CurrentValue)) {
                $this->event_5->Total += $this->event_5->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_6->CurrentValue)) {
                $this->event_6->Total += $this->event_6->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_7->CurrentValue)) {
                $this->event_7->Total += $this->event_7->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_8->CurrentValue)) {
                $this->event_8->Total += $this->event_8->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_9->CurrentValue)) {
                $this->event_9->Total += $this->event_9->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_10->CurrentValue)) {
                $this->event_10->Total += $this->event_10->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_11->CurrentValue)) {
                $this->event_11->Total += $this->event_11->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_12->CurrentValue)) {
                $this->event_12->Total += $this->event_12->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_13->CurrentValue)) {
                $this->event_13->Total += $this->event_13->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_14->CurrentValue)) {
                $this->event_14->Total += $this->event_14->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_15->CurrentValue)) {
                $this->event_15->Total += $this->event_15->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_16->CurrentValue)) {
                $this->event_16->Total += $this->event_16->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_17->CurrentValue)) {
                $this->event_17->Total += $this->event_17->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_18->CurrentValue)) {
                $this->event_18->Total += $this->event_18->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_19->CurrentValue)) {
                $this->event_19->Total += $this->event_19->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->event_20->CurrentValue)) {
                $this->event_20->Total += $this->event_20->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->event_1->CurrentValue = $this->event_1->Total;
            $this->event_1->ViewValue = $this->event_1->CurrentValue;
            $this->event_1->HrefValue = ""; // Clear href value
            $this->event_2->CurrentValue = $this->event_2->Total;
            $this->event_2->ViewValue = $this->event_2->CurrentValue;
            $this->event_2->HrefValue = ""; // Clear href value
            $this->event_3->CurrentValue = $this->event_3->Total;
            $this->event_3->ViewValue = $this->event_3->CurrentValue;
            $this->event_3->HrefValue = ""; // Clear href value
            $this->event_4->CurrentValue = $this->event_4->Total;
            $this->event_4->ViewValue = $this->event_4->CurrentValue;
            $this->event_4->HrefValue = ""; // Clear href value
            $this->event_5->CurrentValue = $this->event_5->Total;
            $this->event_5->ViewValue = $this->event_5->CurrentValue;
            $this->event_5->HrefValue = ""; // Clear href value
            $this->event_6->CurrentValue = $this->event_6->Total;
            $this->event_6->ViewValue = $this->event_6->CurrentValue;
            $this->event_6->HrefValue = ""; // Clear href value
            $this->event_7->CurrentValue = $this->event_7->Total;
            $this->event_7->ViewValue = $this->event_7->CurrentValue;
            $this->event_7->HrefValue = ""; // Clear href value
            $this->event_8->CurrentValue = $this->event_8->Total;
            $this->event_8->ViewValue = $this->event_8->CurrentValue;
            $this->event_8->HrefValue = ""; // Clear href value
            $this->event_9->CurrentValue = $this->event_9->Total;
            $this->event_9->ViewValue = $this->event_9->CurrentValue;
            $this->event_9->HrefValue = ""; // Clear href value
            $this->event_10->CurrentValue = $this->event_10->Total;
            $this->event_10->ViewValue = $this->event_10->CurrentValue;
            $this->event_10->HrefValue = ""; // Clear href value
            $this->event_11->CurrentValue = $this->event_11->Total;
            $this->event_11->ViewValue = $this->event_11->CurrentValue;
            $this->event_11->ViewValue = FormatNumber($this->event_11->ViewValue, $this->event_11->formatPattern());
            $this->event_11->HrefValue = ""; // Clear href value
            $this->event_12->CurrentValue = $this->event_12->Total;
            $this->event_12->ViewValue = $this->event_12->CurrentValue;
            $this->event_12->ViewValue = FormatNumber($this->event_12->ViewValue, $this->event_12->formatPattern());
            $this->event_12->HrefValue = ""; // Clear href value
            $this->event_13->CurrentValue = $this->event_13->Total;
            $this->event_13->ViewValue = $this->event_13->CurrentValue;
            $this->event_13->ViewValue = FormatNumber($this->event_13->ViewValue, $this->event_13->formatPattern());
            $this->event_13->HrefValue = ""; // Clear href value
            $this->event_14->CurrentValue = $this->event_14->Total;
            $this->event_14->ViewValue = $this->event_14->CurrentValue;
            $this->event_14->ViewValue = FormatNumber($this->event_14->ViewValue, $this->event_14->formatPattern());
            $this->event_14->HrefValue = ""; // Clear href value
            $this->event_15->CurrentValue = $this->event_15->Total;
            $this->event_15->ViewValue = $this->event_15->CurrentValue;
            $this->event_15->ViewValue = FormatNumber($this->event_15->ViewValue, $this->event_15->formatPattern());
            $this->event_15->HrefValue = ""; // Clear href value
            $this->event_16->CurrentValue = $this->event_16->Total;
            $this->event_16->ViewValue = $this->event_16->CurrentValue;
            $this->event_16->ViewValue = FormatNumber($this->event_16->ViewValue, $this->event_16->formatPattern());
            $this->event_16->HrefValue = ""; // Clear href value
            $this->event_17->CurrentValue = $this->event_17->Total;
            $this->event_17->ViewValue = $this->event_17->CurrentValue;
            $this->event_17->ViewValue = FormatNumber($this->event_17->ViewValue, $this->event_17->formatPattern());
            $this->event_17->HrefValue = ""; // Clear href value
            $this->event_18->CurrentValue = $this->event_18->Total;
            $this->event_18->ViewValue = $this->event_18->CurrentValue;
            $this->event_18->ViewValue = FormatNumber($this->event_18->ViewValue, $this->event_18->formatPattern());
            $this->event_18->HrefValue = ""; // Clear href value
            $this->event_19->CurrentValue = $this->event_19->Total;
            $this->event_19->ViewValue = $this->event_19->CurrentValue;
            $this->event_19->ViewValue = FormatNumber($this->event_19->ViewValue, $this->event_19->formatPattern());
            $this->event_19->HrefValue = ""; // Clear href value
            $this->event_20->CurrentValue = $this->event_20->Total;
            $this->event_20->ViewValue = $this->event_20->CurrentValue;
            $this->event_20->ViewValue = FormatNumber($this->event_20->ViewValue, $this->event_20->formatPattern());
            $this->event_20->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->family_id);
                    $doc->exportCaption($this->event_id);
                    $doc->exportCaption($this->event_1);
                    $doc->exportCaption($this->event_2);
                    $doc->exportCaption($this->event_3);
                    $doc->exportCaption($this->event_4);
                    $doc->exportCaption($this->event_5);
                    $doc->exportCaption($this->event_6);
                    $doc->exportCaption($this->event_7);
                    $doc->exportCaption($this->event_8);
                    $doc->exportCaption($this->event_9);
                    $doc->exportCaption($this->event_10);
                    $doc->exportCaption($this->event_11);
                    $doc->exportCaption($this->event_12);
                    $doc->exportCaption($this->event_13);
                    $doc->exportCaption($this->event_14);
                    $doc->exportCaption($this->event_15);
                    $doc->exportCaption($this->event_16);
                    $doc->exportCaption($this->event_17);
                    $doc->exportCaption($this->event_18);
                    $doc->exportCaption($this->event_19);
                    $doc->exportCaption($this->event_20);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->family_id);
                    $doc->exportCaption($this->event_id);
                    $doc->exportCaption($this->event_1);
                    $doc->exportCaption($this->event_2);
                    $doc->exportCaption($this->event_3);
                    $doc->exportCaption($this->event_4);
                    $doc->exportCaption($this->event_5);
                    $doc->exportCaption($this->event_6);
                    $doc->exportCaption($this->event_7);
                    $doc->exportCaption($this->event_8);
                    $doc->exportCaption($this->event_9);
                    $doc->exportCaption($this->event_10);
                    $doc->exportCaption($this->event_11);
                    $doc->exportCaption($this->event_12);
                    $doc->exportCaption($this->event_13);
                    $doc->exportCaption($this->event_14);
                    $doc->exportCaption($this->event_15);
                    $doc->exportCaption($this->event_16);
                    $doc->exportCaption($this->event_17);
                    $doc->exportCaption($this->event_18);
                    $doc->exportCaption($this->event_19);
                    $doc->exportCaption($this->event_20);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->family_id);
                        $doc->exportField($this->event_id);
                        $doc->exportField($this->event_1);
                        $doc->exportField($this->event_2);
                        $doc->exportField($this->event_3);
                        $doc->exportField($this->event_4);
                        $doc->exportField($this->event_5);
                        $doc->exportField($this->event_6);
                        $doc->exportField($this->event_7);
                        $doc->exportField($this->event_8);
                        $doc->exportField($this->event_9);
                        $doc->exportField($this->event_10);
                        $doc->exportField($this->event_11);
                        $doc->exportField($this->event_12);
                        $doc->exportField($this->event_13);
                        $doc->exportField($this->event_14);
                        $doc->exportField($this->event_15);
                        $doc->exportField($this->event_16);
                        $doc->exportField($this->event_17);
                        $doc->exportField($this->event_18);
                        $doc->exportField($this->event_19);
                        $doc->exportField($this->event_20);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->family_id);
                        $doc->exportField($this->event_id);
                        $doc->exportField($this->event_1);
                        $doc->exportField($this->event_2);
                        $doc->exportField($this->event_3);
                        $doc->exportField($this->event_4);
                        $doc->exportField($this->event_5);
                        $doc->exportField($this->event_6);
                        $doc->exportField($this->event_7);
                        $doc->exportField($this->event_8);
                        $doc->exportField($this->event_9);
                        $doc->exportField($this->event_10);
                        $doc->exportField($this->event_11);
                        $doc->exportField($this->event_12);
                        $doc->exportField($this->event_13);
                        $doc->exportField($this->event_14);
                        $doc->exportField($this->event_15);
                        $doc->exportField($this->event_16);
                        $doc->exportField($this->event_17);
                        $doc->exportField($this->event_18);
                        $doc->exportField($this->event_19);
                        $doc->exportField($this->event_20);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->family_id, '');
                $doc->exportAggregate($this->event_id, '');
                $doc->exportAggregate($this->event_1, 'TOTAL');
                $doc->exportAggregate($this->event_2, 'TOTAL');
                $doc->exportAggregate($this->event_3, 'TOTAL');
                $doc->exportAggregate($this->event_4, 'TOTAL');
                $doc->exportAggregate($this->event_5, 'TOTAL');
                $doc->exportAggregate($this->event_6, 'TOTAL');
                $doc->exportAggregate($this->event_7, 'TOTAL');
                $doc->exportAggregate($this->event_8, 'TOTAL');
                $doc->exportAggregate($this->event_9, 'TOTAL');
                $doc->exportAggregate($this->event_10, 'TOTAL');
                $doc->exportAggregate($this->event_11, 'TOTAL');
                $doc->exportAggregate($this->event_12, 'TOTAL');
                $doc->exportAggregate($this->event_13, 'TOTAL');
                $doc->exportAggregate($this->event_14, 'TOTAL');
                $doc->exportAggregate($this->event_15, 'TOTAL');
                $doc->exportAggregate($this->event_16, 'TOTAL');
                $doc->exportAggregate($this->event_17, 'TOTAL');
                $doc->exportAggregate($this->event_18, 'TOTAL');
                $doc->exportAggregate($this->event_19, 'TOTAL');
                $doc->exportAggregate($this->event_20, 'TOTAL');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
