<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class CustomizedMessageAdd extends CustomizedMessage
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CustomizedMessageAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "customizedmessageadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->reference->setVisibility();
        $this->message_type->setVisibility();
        $this->wa_type->setVisibility();
        $this->wa_id->setVisibility();
        $this->mobile_no->setVisibility();
        $this->_email->setVisibility();
        $this->subject->setVisibility();
        $this->_message->setVisibility();
        $this->_sms->setVisibility();
        $this->uploads->setVisibility();
        $this->b_type->setVisibility();
        $this->b_1->setVisibility();
        $this->b_2->setVisibility();
        $this->b_3->setVisibility();
        $this->b_4->Visible = false;
        $this->trigger_time->Visible = false;
        $this->status->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'customized_message';
        $this->TableName = 'customized_message';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (customized_message)
        if (!isset($GLOBALS["customized_message"]) || $GLOBALS["customized_message"]::class == PROJECT_NAMESPACE . "customized_message") {
            $GLOBALS["customized_message"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'customized_message');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "customizedmessageview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->message_type);
        $this->setupLookupOptions($this->wa_type);
        $this->setupLookupOptions($this->wa_id);
        $this->setupLookupOptions($this->b_type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("customizedmessagelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = 'autoprogramme?apcid=b4e62d5681b956d7cf98e467f6427ae4';

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "customizedmessagelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "customizedmessagelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->reference->DefaultValue = $this->reference->getDefault(); // PHP
        $this->reference->OldValue = $this->reference->DefaultValue;
        $this->trigger_time->DefaultValue = $this->trigger_time->getDefault(); // PHP
        $this->trigger_time->OldValue = $this->trigger_time->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'reference' first before field var 'x_reference'
        $val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
        if (!$this->reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference->Visible = false; // Disable update for API request
            } else {
                $this->reference->setFormValue($val);
            }
        }

        // Check field name 'message_type' first before field var 'x_message_type'
        $val = $CurrentForm->hasValue("message_type") ? $CurrentForm->getValue("message_type") : $CurrentForm->getValue("x_message_type");
        if (!$this->message_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->message_type->Visible = false; // Disable update for API request
            } else {
                $this->message_type->setFormValue($val);
            }
        }

        // Check field name 'wa_type' first before field var 'x_wa_type'
        $val = $CurrentForm->hasValue("wa_type") ? $CurrentForm->getValue("wa_type") : $CurrentForm->getValue("x_wa_type");
        if (!$this->wa_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_type->Visible = false; // Disable update for API request
            } else {
                $this->wa_type->setFormValue($val);
            }
        }

        // Check field name 'wa_id' first before field var 'x_wa_id'
        $val = $CurrentForm->hasValue("wa_id") ? $CurrentForm->getValue("wa_id") : $CurrentForm->getValue("x_wa_id");
        if (!$this->wa_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_id->Visible = false; // Disable update for API request
            } else {
                $this->wa_id->setFormValue($val);
            }
        }

        // Check field name 'mobile_no' first before field var 'x_mobile_no'
        $val = $CurrentForm->hasValue("mobile_no") ? $CurrentForm->getValue("mobile_no") : $CurrentForm->getValue("x_mobile_no");
        if (!$this->mobile_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_no->Visible = false; // Disable update for API request
            } else {
                $this->mobile_no->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'subject' first before field var 'x_subject'
        $val = $CurrentForm->hasValue("subject") ? $CurrentForm->getValue("subject") : $CurrentForm->getValue("x_subject");
        if (!$this->subject->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->subject->Visible = false; // Disable update for API request
            } else {
                $this->subject->setFormValue($val);
            }
        }

        // Check field name 'message' first before field var 'x__message'
        $val = $CurrentForm->hasValue("message") ? $CurrentForm->getValue("message") : $CurrentForm->getValue("x__message");
        if (!$this->_message->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_message->Visible = false; // Disable update for API request
            } else {
                $this->_message->setFormValue($val);
            }
        }

        // Check field name 'sms' first before field var 'x__sms'
        $val = $CurrentForm->hasValue("sms") ? $CurrentForm->getValue("sms") : $CurrentForm->getValue("x__sms");
        if (!$this->_sms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_sms->Visible = false; // Disable update for API request
            } else {
                $this->_sms->setFormValue($val);
            }
        }

        // Check field name 'b_type' first before field var 'x_b_type'
        $val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
        if (!$this->b_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_type->Visible = false; // Disable update for API request
            } else {
                $this->b_type->setFormValue($val);
            }
        }

        // Check field name 'b_1' first before field var 'x_b_1'
        $val = $CurrentForm->hasValue("b_1") ? $CurrentForm->getValue("b_1") : $CurrentForm->getValue("x_b_1");
        if (!$this->b_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_1->Visible = false; // Disable update for API request
            } else {
                $this->b_1->setFormValue($val);
            }
        }

        // Check field name 'b_2' first before field var 'x_b_2'
        $val = $CurrentForm->hasValue("b_2") ? $CurrentForm->getValue("b_2") : $CurrentForm->getValue("x_b_2");
        if (!$this->b_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_2->Visible = false; // Disable update for API request
            } else {
                $this->b_2->setFormValue($val);
            }
        }

        // Check field name 'b_3' first before field var 'x_b_3'
        $val = $CurrentForm->hasValue("b_3") ? $CurrentForm->getValue("b_3") : $CurrentForm->getValue("x_b_3");
        if (!$this->b_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_3->Visible = false; // Disable update for API request
            } else {
                $this->b_3->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->reference->CurrentValue = $this->reference->FormValue;
        $this->message_type->CurrentValue = $this->message_type->FormValue;
        $this->wa_type->CurrentValue = $this->wa_type->FormValue;
        $this->wa_id->CurrentValue = $this->wa_id->FormValue;
        $this->mobile_no->CurrentValue = $this->mobile_no->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->subject->CurrentValue = $this->subject->FormValue;
        $this->_message->CurrentValue = $this->_message->FormValue;
        $this->_sms->CurrentValue = $this->_sms->FormValue;
        $this->b_type->CurrentValue = $this->b_type->FormValue;
        $this->b_1->CurrentValue = $this->b_1->FormValue;
        $this->b_2->CurrentValue = $this->b_2->FormValue;
        $this->b_3->CurrentValue = $this->b_3->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->reference->setDbValue($row['reference']);
        $this->message_type->setDbValue($row['message_type']);
        $this->wa_type->setDbValue($row['wa_type']);
        $this->wa_id->setDbValue($row['wa_id']);
        $this->mobile_no->setDbValue($row['mobile_no']);
        $this->_email->setDbValue($row['email']);
        $this->subject->setDbValue($row['subject']);
        $this->_message->setDbValue($row['message']);
        $this->_sms->setDbValue($row['sms']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->b_type->setDbValue($row['b_type']);
        $this->b_1->setDbValue($row['b_1']);
        $this->b_2->setDbValue($row['b_2']);
        $this->b_3->setDbValue($row['b_3']);
        $this->b_4->setDbValue($row['b_4']);
        $this->trigger_time->setDbValue($row['trigger_time']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['reference'] = $this->reference->DefaultValue;
        $row['message_type'] = $this->message_type->DefaultValue;
        $row['wa_type'] = $this->wa_type->DefaultValue;
        $row['wa_id'] = $this->wa_id->DefaultValue;
        $row['mobile_no'] = $this->mobile_no->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['subject'] = $this->subject->DefaultValue;
        $row['message'] = $this->_message->DefaultValue;
        $row['sms'] = $this->_sms->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['b_type'] = $this->b_type->DefaultValue;
        $row['b_1'] = $this->b_1->DefaultValue;
        $row['b_2'] = $this->b_2->DefaultValue;
        $row['b_3'] = $this->b_3->DefaultValue;
        $row['b_4'] = $this->b_4->DefaultValue;
        $row['trigger_time'] = $this->trigger_time->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // reference
        $this->reference->RowCssClass = "row";

        // message_type
        $this->message_type->RowCssClass = "row";

        // wa_type
        $this->wa_type->RowCssClass = "row";

        // wa_id
        $this->wa_id->RowCssClass = "row";

        // mobile_no
        $this->mobile_no->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // subject
        $this->subject->RowCssClass = "row";

        // message
        $this->_message->RowCssClass = "row";

        // sms
        $this->_sms->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // b_type
        $this->b_type->RowCssClass = "row";

        // b_1
        $this->b_1->RowCssClass = "row";

        // b_2
        $this->b_2->RowCssClass = "row";

        // b_3
        $this->b_3->RowCssClass = "row";

        // b_4
        $this->b_4->RowCssClass = "row";

        // trigger_time
        $this->trigger_time->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;

            // message_type
            $curVal = strval($this->message_type->CurrentValue);
            if ($curVal != "") {
                $this->message_type->ViewValue = $this->message_type->lookupCacheOption($curVal);
                if ($this->message_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->message_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->message_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->message_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->message_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->message_type->Lookup->renderViewRow($rswrk[0]);
                        $this->message_type->ViewValue = $this->message_type->displayValue($arwrk);
                    } else {
                        $this->message_type->ViewValue = FormatNumber($this->message_type->CurrentValue, $this->message_type->formatPattern());
                    }
                }
            } else {
                $this->message_type->ViewValue = null;
            }

            // wa_type
            $curVal = strval($this->wa_type->CurrentValue);
            if ($curVal != "") {
                $this->wa_type->ViewValue = $this->wa_type->lookupCacheOption($curVal);
                if ($this->wa_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type->ViewValue = $this->wa_type->displayValue($arwrk);
                    } else {
                        $this->wa_type->ViewValue = FormatNumber($this->wa_type->CurrentValue, $this->wa_type->formatPattern());
                    }
                }
            } else {
                $this->wa_type->ViewValue = null;
            }

            // wa_id
            $curVal = strval($this->wa_id->CurrentValue);
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
                if ($this->wa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->wa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
                    } else {
                        $this->wa_id->ViewValue = FormatNumber($this->wa_id->CurrentValue, $this->wa_id->formatPattern());
                    }
                }
            } else {
                $this->wa_id->ViewValue = null;
            }

            // mobile_no
            $this->mobile_no->ViewValue = $this->mobile_no->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // subject
            $this->subject->ViewValue = $this->subject->CurrentValue;

            // message
            $this->_message->ViewValue = $this->_message->CurrentValue;

            // sms
            $this->_sms->ViewValue = $this->_sms->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // b_type
            if (strval($this->b_type->CurrentValue) != "") {
                $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
            } else {
                $this->b_type->ViewValue = null;
            }

            // b_1
            $this->b_1->ViewValue = $this->b_1->CurrentValue;

            // b_2
            $this->b_2->ViewValue = $this->b_2->CurrentValue;

            // b_3
            $this->b_3->ViewValue = $this->b_3->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // reference
            $this->reference->HrefValue = "";

            // message_type
            $this->message_type->HrefValue = "";

            // wa_type
            $this->wa_type->HrefValue = "";

            // wa_id
            $this->wa_id->HrefValue = "";

            // mobile_no
            $this->mobile_no->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // subject
            $this->subject->HrefValue = "";

            // message
            $this->_message->HrefValue = "";

            // sms
            $this->_sms->HrefValue = "";

            // uploads
            $this->uploads->HrefValue = "";
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // b_type
            $this->b_type->HrefValue = "";

            // b_1
            $this->b_1->HrefValue = "";

            // b_2
            $this->b_2->HrefValue = "";

            // b_3
            $this->b_3->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // reference
            $this->reference->setupEditAttributes();
            if (!$this->reference->Raw) {
                $this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
            }
            $this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // message_type
            $this->message_type->setupEditAttributes();
            $curVal = trim(strval($this->message_type->CurrentValue));
            if ($curVal != "") {
                $this->message_type->ViewValue = $this->message_type->lookupCacheOption($curVal);
            } else {
                $this->message_type->ViewValue = $this->message_type->Lookup !== null && is_array($this->message_type->lookupOptions()) && count($this->message_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->message_type->ViewValue !== null) { // Load from cache
                $this->message_type->EditValue = array_values($this->message_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->message_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->message_type->CurrentValue, $this->message_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->message_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->message_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->message_type->EditValue = $arwrk;
            }
            $this->message_type->PlaceHolder = RemoveHtml($this->message_type->caption());

            // wa_type
            $this->wa_type->setupEditAttributes();
            $curVal = trim(strval($this->wa_type->CurrentValue));
            if ($curVal != "") {
                $this->wa_type->ViewValue = $this->wa_type->lookupCacheOption($curVal);
            } else {
                $this->wa_type->ViewValue = $this->wa_type->Lookup !== null && is_array($this->wa_type->lookupOptions()) && count($this->wa_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_type->ViewValue !== null) { // Load from cache
                $this->wa_type->EditValue = array_values($this->wa_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_type->CurrentValue, $this->wa_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->wa_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_type->EditValue = $arwrk;
            }
            $this->wa_type->PlaceHolder = RemoveHtml($this->wa_type->caption());

            // wa_id
            $this->wa_id->setupEditAttributes();
            $curVal = trim(strval($this->wa_id->CurrentValue));
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
            } else {
                $this->wa_id->ViewValue = $this->wa_id->Lookup !== null && is_array($this->wa_id->lookupOptions()) && count($this->wa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_id->ViewValue !== null) { // Load from cache
                $this->wa_id->EditValue = array_values($this->wa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_id->CurrentValue, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->wa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_id->EditValue = $arwrk;
            }
            $this->wa_id->PlaceHolder = RemoveHtml($this->wa_id->caption());

            // mobile_no
            $this->mobile_no->setupEditAttributes();
            if (!$this->mobile_no->Raw) {
                $this->mobile_no->CurrentValue = HtmlDecode($this->mobile_no->CurrentValue);
            }
            $this->mobile_no->EditValue = HtmlEncode($this->mobile_no->CurrentValue);
            $this->mobile_no->PlaceHolder = RemoveHtml($this->mobile_no->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // subject
            $this->subject->setupEditAttributes();
            $this->subject->EditValue = HtmlEncode($this->subject->CurrentValue);
            $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

            // message
            $this->_message->setupEditAttributes();
            $this->_message->EditValue = HtmlEncode($this->_message->CurrentValue);
            $this->_message->PlaceHolder = RemoveHtml($this->_message->caption());

            // sms
            $this->_sms->setupEditAttributes();
            $this->_sms->EditValue = HtmlEncode($this->_sms->CurrentValue);
            $this->_sms->PlaceHolder = RemoveHtml($this->_sms->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // b_type
            $this->b_type->setupEditAttributes();
            $this->b_type->EditValue = $this->b_type->options(true);
            $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

            // b_1
            $this->b_1->setupEditAttributes();
            if (!$this->b_1->Raw) {
                $this->b_1->CurrentValue = HtmlDecode($this->b_1->CurrentValue);
            }
            $this->b_1->EditValue = HtmlEncode($this->b_1->CurrentValue);
            $this->b_1->PlaceHolder = RemoveHtml($this->b_1->caption());

            // b_2
            $this->b_2->setupEditAttributes();
            if (!$this->b_2->Raw) {
                $this->b_2->CurrentValue = HtmlDecode($this->b_2->CurrentValue);
            }
            $this->b_2->EditValue = HtmlEncode($this->b_2->CurrentValue);
            $this->b_2->PlaceHolder = RemoveHtml($this->b_2->caption());

            // b_3
            $this->b_3->setupEditAttributes();
            if (!$this->b_3->Raw) {
                $this->b_3->CurrentValue = HtmlDecode($this->b_3->CurrentValue);
            }
            $this->b_3->EditValue = HtmlEncode($this->b_3->CurrentValue);
            $this->b_3->PlaceHolder = RemoveHtml($this->b_3->caption());

            // operator

            // datetime

            // Add refer script

            // reference
            $this->reference->HrefValue = "";

            // message_type
            $this->message_type->HrefValue = "";

            // wa_type
            $this->wa_type->HrefValue = "";

            // wa_id
            $this->wa_id->HrefValue = "";

            // mobile_no
            $this->mobile_no->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // subject
            $this->subject->HrefValue = "";

            // message
            $this->_message->HrefValue = "";

            // sms
            $this->_sms->HrefValue = "";

            // uploads
            $this->uploads->HrefValue = "";
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // b_type
            $this->b_type->HrefValue = "";

            // b_1
            $this->b_1->HrefValue = "";

            // b_2
            $this->b_2->HrefValue = "";

            // b_3
            $this->b_3->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->reference->Visible && $this->reference->Required) {
                if (!$this->reference->IsDetailKey && EmptyValue($this->reference->FormValue)) {
                    $this->reference->addErrorMessage(str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
                }
            }
            if ($this->message_type->Visible && $this->message_type->Required) {
                if (!$this->message_type->IsDetailKey && EmptyValue($this->message_type->FormValue)) {
                    $this->message_type->addErrorMessage(str_replace("%s", $this->message_type->caption(), $this->message_type->RequiredErrorMessage));
                }
            }
            if ($this->wa_type->Visible && $this->wa_type->Required) {
                if (!$this->wa_type->IsDetailKey && EmptyValue($this->wa_type->FormValue)) {
                    $this->wa_type->addErrorMessage(str_replace("%s", $this->wa_type->caption(), $this->wa_type->RequiredErrorMessage));
                }
            }
            if ($this->wa_id->Visible && $this->wa_id->Required) {
                if (!$this->wa_id->IsDetailKey && EmptyValue($this->wa_id->FormValue)) {
                    $this->wa_id->addErrorMessage(str_replace("%s", $this->wa_id->caption(), $this->wa_id->RequiredErrorMessage));
                }
            }
            if ($this->mobile_no->Visible && $this->mobile_no->Required) {
                if (!$this->mobile_no->IsDetailKey && EmptyValue($this->mobile_no->FormValue)) {
                    $this->mobile_no->addErrorMessage(str_replace("%s", $this->mobile_no->caption(), $this->mobile_no->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_email->FormValue)) {
                $this->_email->addErrorMessage($this->_email->getErrorMessage(false));
            }
            if ($this->subject->Visible && $this->subject->Required) {
                if (!$this->subject->IsDetailKey && EmptyValue($this->subject->FormValue)) {
                    $this->subject->addErrorMessage(str_replace("%s", $this->subject->caption(), $this->subject->RequiredErrorMessage));
                }
            }
            if ($this->_message->Visible && $this->_message->Required) {
                if (!$this->_message->IsDetailKey && EmptyValue($this->_message->FormValue)) {
                    $this->_message->addErrorMessage(str_replace("%s", $this->_message->caption(), $this->_message->RequiredErrorMessage));
                }
            }
            if ($this->_sms->Visible && $this->_sms->Required) {
                if (!$this->_sms->IsDetailKey && EmptyValue($this->_sms->FormValue)) {
                    $this->_sms->addErrorMessage(str_replace("%s", $this->_sms->caption(), $this->_sms->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->b_type->Visible && $this->b_type->Required) {
                if (!$this->b_type->IsDetailKey && EmptyValue($this->b_type->FormValue)) {
                    $this->b_type->addErrorMessage(str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
                }
            }
            if ($this->b_1->Visible && $this->b_1->Required) {
                if (!$this->b_1->IsDetailKey && EmptyValue($this->b_1->FormValue)) {
                    $this->b_1->addErrorMessage(str_replace("%s", $this->b_1->caption(), $this->b_1->RequiredErrorMessage));
                }
            }
            if ($this->b_2->Visible && $this->b_2->Required) {
                if (!$this->b_2->IsDetailKey && EmptyValue($this->b_2->FormValue)) {
                    $this->b_2->addErrorMessage(str_replace("%s", $this->b_2->caption(), $this->b_2->RequiredErrorMessage));
                }
            }
            if ($this->b_3->Visible && $this->b_3->Required) {
                if (!$this->b_3->IsDetailKey && EmptyValue($this->b_3->FormValue)) {
                    $this->b_3->addErrorMessage(str_replace("%s", $this->b_3->caption(), $this->b_3->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // reference
        $this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, false);

        // message_type
        $this->message_type->setDbValueDef($rsnew, $this->message_type->CurrentValue, false);

        // wa_type
        $this->wa_type->setDbValueDef($rsnew, $this->wa_type->CurrentValue, false);

        // wa_id
        $this->wa_id->setDbValueDef($rsnew, $this->wa_id->CurrentValue, false);

        // mobile_no
        $this->mobile_no->setDbValueDef($rsnew, $this->mobile_no->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // subject
        $this->subject->setDbValueDef($rsnew, $this->subject->CurrentValue, false);

        // message
        $this->_message->setDbValueDef($rsnew, $this->_message->CurrentValue, false);

        // sms
        $this->_sms->setDbValueDef($rsnew, $this->_sms->CurrentValue, false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 640; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // b_type
        $this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, false);

        // b_1
        $this->b_1->setDbValueDef($rsnew, $this->b_1->CurrentValue, false);

        // b_2
        $this->b_2->setDbValueDef($rsnew, $this->b_2->CurrentValue, false);

        // b_3
        $this->b_3->setDbValueDef($rsnew, $this->b_3->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['reference'])) { // reference
            $this->reference->setFormValue($row['reference']);
        }
        if (isset($row['message_type'])) { // message_type
            $this->message_type->setFormValue($row['message_type']);
        }
        if (isset($row['wa_type'])) { // wa_type
            $this->wa_type->setFormValue($row['wa_type']);
        }
        if (isset($row['wa_id'])) { // wa_id
            $this->wa_id->setFormValue($row['wa_id']);
        }
        if (isset($row['mobile_no'])) { // mobile_no
            $this->mobile_no->setFormValue($row['mobile_no']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['subject'])) { // subject
            $this->subject->setFormValue($row['subject']);
        }
        if (isset($row['message'])) { // message
            $this->_message->setFormValue($row['message']);
        }
        if (isset($row['sms'])) { // sms
            $this->_sms->setFormValue($row['sms']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['b_type'])) { // b_type
            $this->b_type->setFormValue($row['b_type']);
        }
        if (isset($row['b_1'])) { // b_1
            $this->b_1->setFormValue($row['b_1']);
        }
        if (isset($row['b_2'])) { // b_2
            $this->b_2->setFormValue($row['b_2']);
        }
        if (isset($row['b_3'])) { // b_3
            $this->b_3->setFormValue($row['b_3']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("customizedmessagelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_message_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_id":
                    break;
                case "x_b_type":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	isset($_GET['ref']) ? '' : $_GET['ref'] = 0; 
    	if ($_GET['ref'] > 0)
    	{
    		$this->reference->ReadOnly = true;
    	}
    	else
    	{
    		$this->reference->Visible = False;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
