<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class CostCalculatorDetailedSearch extends CostCalculatorDetailed
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CostCalculatorDetailedSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "costcalculatordetailedsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->cc_id->setVisibility();
        $this->rid->setVisibility();
        $this->sqm->setVisibility();
        $this->item->setVisibility();
        $this->packing_type->setVisibility();
        $this->method->setVisibility();
        $this->qty->setVisibility();
        $this->last_price->setVisibility();
        $this->amount->setVisibility();
        $this->process->setVisibility();
        $this->w_cm->setVisibility();
        $this->l_cm->setVisibility();
        $this->description->setVisibility();
        $this->overhead->setVisibility();
        $this->margin->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'cost_calculator_detailed';
        $this->TableName = 'cost_calculator_detailed';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (cost_calculator_detailed)
        if (!isset($GLOBALS["cost_calculator_detailed"]) || $GLOBALS["cost_calculator_detailed"]::class == PROJECT_NAMESPACE . "cost_calculator_detailed") {
            $GLOBALS["cost_calculator_detailed"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'cost_calculator_detailed');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "costcalculatordetailedview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->cc_id);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->item);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->process);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "costcalculatordetailedlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->cc_id); // cc_id
        $this->buildSearchUrl($srchUrl, $this->rid); // rid
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->item); // item
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->method); // method
        $this->buildSearchUrl($srchUrl, $this->qty); // qty
        $this->buildSearchUrl($srchUrl, $this->last_price); // last_price
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->w_cm); // w_cm
        $this->buildSearchUrl($srchUrl, $this->l_cm); // l_cm
        $this->buildSearchUrl($srchUrl, $this->description); // description
        $this->buildSearchUrl($srchUrl, $this->overhead); // overhead
        $this->buildSearchUrl($srchUrl, $this->margin); // margin
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cc_id
        if ($this->cc_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // item
        if ($this->item->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // method
        if ($this->method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // last_price
        if ($this->last_price->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // w_cm
        if ($this->w_cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // l_cm
        if ($this->l_cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // overhead
        if ($this->overhead->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // margin
        if ($this->margin->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // cc_id
        $this->cc_id->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // last_price
        $this->last_price->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // overhead
        $this->overhead->RowCssClass = "row";

        // margin
        $this->margin->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // cc_id
            $curVal = strval($this->cc_id->CurrentValue);
            if ($curVal != "") {
                $this->cc_id->ViewValue = $this->cc_id->lookupCacheOption($curVal);
                if ($this->cc_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->cc_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->cc_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->cc_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->cc_id->Lookup->renderViewRow($rswrk[0]);
                        $this->cc_id->ViewValue = $this->cc_id->displayValue($arwrk);
                    } else {
                        $this->cc_id->ViewValue = FormatNumber($this->cc_id->CurrentValue, $this->cc_id->formatPattern());
                    }
                }
            } else {
                $this->cc_id->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // item
            $curVal = strval($this->item->CurrentValue);
            if ($curVal != "") {
                $this->item->ViewValue = $this->item->lookupCacheOption($curVal);
                if ($this->item->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->item->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->item->getSelectFilter($this); // PHP
                    $sqlWrk = $this->item->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->item->Lookup->renderViewRow($rswrk[0]);
                        $this->item->ViewValue = $this->item->displayValue($arwrk);
                    } else {
                        $this->item->ViewValue = FormatNumber($this->item->CurrentValue, $this->item->formatPattern());
                    }
                }
            } else {
                $this->item->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = FormatNumber($this->method->CurrentValue, $this->method->formatPattern());
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;
            $this->last_price->ViewValue = FormatNumber($this->last_price->ViewValue, $this->last_price->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // overhead
            $this->overhead->ViewValue = $this->overhead->CurrentValue;
            $this->overhead->ViewValue = FormatNumber($this->overhead->ViewValue, $this->overhead->formatPattern());

            // margin
            $this->margin->ViewValue = $this->margin->CurrentValue;
            $this->margin->ViewValue = FormatNumber($this->margin->ViewValue, $this->margin->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // cc_id
            if (!EmptyValue($this->cc_id->CurrentValue)) {
                $this->cc_id->HrefValue = $this->cc_id->getLinkPrefix() . $this->cc_id->CurrentValue; // Add prefix/suffix
                $this->cc_id->LinkAttrs["target"] = "_parent"; // Add target
                if ($this->isExport()) {
                    $this->cc_id->HrefValue = FullUrl($this->cc_id->HrefValue, "href");
                }
            } else {
                $this->cc_id->HrefValue = "";
            }
            $this->cc_id->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // last_price
            $this->last_price->HrefValue = "";
            $this->last_price->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";
            $this->w_cm->TooltipValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";
            $this->l_cm->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // overhead
            $this->overhead->HrefValue = "";
            $this->overhead->TooltipValue = "";

            // margin
            $this->margin->HrefValue = "";
            $this->margin->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // cc_id
            $this->cc_id->setupEditAttributes();
            $curVal = trim(strval($this->cc_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->cc_id->AdvancedSearch->ViewValue = $this->cc_id->lookupCacheOption($curVal);
            } else {
                $this->cc_id->AdvancedSearch->ViewValue = $this->cc_id->Lookup !== null && is_array($this->cc_id->lookupOptions()) && count($this->cc_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cc_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->cc_id->EditValue = array_values($this->cc_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->cc_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->cc_id->AdvancedSearch->SearchValue, $this->cc_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->cc_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->cc_id->EditValue = $arwrk;
            }
            $this->cc_id->PlaceHolder = RemoveHtml($this->cc_id->caption());

            // rid
            $this->rid->setupEditAttributes();
            $curVal = trim(strval($this->rid->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->rid->AdvancedSearch->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->AdvancedSearch->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->AdvancedSearch->SearchValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // item
            $this->item->setupEditAttributes();
            $curVal = trim(strval($this->item->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->item->AdvancedSearch->ViewValue = $this->item->lookupCacheOption($curVal);
            } else {
                $this->item->AdvancedSearch->ViewValue = $this->item->Lookup !== null && is_array($this->item->lookupOptions()) && count($this->item->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->item->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->item->EditValue = array_values($this->item->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->item->AdvancedSearch->SearchValue, $this->item->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->item->getSelectFilter($this); // PHP
                $sqlWrk = $this->item->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->item->EditValue = $arwrk;
            }
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->method->AdvancedSearch->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->AdvancedSearch->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->AdvancedSearch->SearchValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // last_price
            $this->last_price->setupEditAttributes();
            $this->last_price->EditValue = $this->last_price->AdvancedSearch->SearchValue;
            $this->last_price->PlaceHolder = RemoveHtml($this->last_price->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->AdvancedSearch->SearchValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditValue = $this->w_cm->AdvancedSearch->SearchValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditValue = $this->l_cm->AdvancedSearch->SearchValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // overhead
            $this->overhead->setupEditAttributes();
            $this->overhead->EditValue = $this->overhead->AdvancedSearch->SearchValue;
            $this->overhead->PlaceHolder = RemoveHtml($this->overhead->caption());

            // margin
            $this->margin->setupEditAttributes();
            $this->margin->EditValue = $this->margin->AdvancedSearch->SearchValue;
            $this->margin->PlaceHolder = RemoveHtml($this->margin->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty->AdvancedSearch->SearchValue)) {
            $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->last_price->AdvancedSearch->SearchValue)) {
            $this->last_price->addErrorMessage($this->last_price->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->w_cm->AdvancedSearch->SearchValue)) {
            $this->w_cm->addErrorMessage($this->w_cm->getErrorMessage(false));
        }
        if (!CheckInteger($this->l_cm->AdvancedSearch->SearchValue)) {
            $this->l_cm->addErrorMessage($this->l_cm->getErrorMessage(false));
        }
        if (!CheckNumber($this->overhead->AdvancedSearch->SearchValue)) {
            $this->overhead->addErrorMessage($this->overhead->getErrorMessage(false));
        }
        if (!CheckNumber($this->margin->AdvancedSearch->SearchValue)) {
            $this->margin->addErrorMessage($this->margin->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->cc_id->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->method->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->last_price->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->w_cm->AdvancedSearch->load();
        $this->l_cm->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->overhead->AdvancedSearch->load();
        $this->margin->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("costcalculatordetailedlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_cc_id":
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_item":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
