<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class CompositionAddopt extends Composition
{
    use MessagesTrait;

    // Page ID
    public $PageID = "addopt";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CompositionAddopt";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "compositionaddopt";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->setVisibility();
        $this->wool->setVisibility();
        $this->viscose->setVisibility();
        $this->polyester->setVisibility();
        $this->cotton->setVisibility();
        $this->jute->setVisibility();
        $this->other->setVisibility();
        $this->other_name->setVisibility();
        $this->description_type->setVisibility();
        $this->code->setVisibility();
        $this->composition->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->uid->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'composition';
        $this->TableName = 'composition';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (composition)
        if (!isset($GLOBALS["composition"]) || $GLOBALS["composition"]::class == PROJECT_NAMESPACE . "composition") {
            $GLOBALS["composition"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'composition');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $IsModal = false;
    public $IsMobileOrModal = true; // Add option page is always modal

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->description_type);
        $this->setupLookupOptions($this->status);

        // Load default values for add
        $this->loadDefaultValues();

        // Set up Breadcrumb
        // $this->setupBreadcrumb(); // Not used
        $this->loadRowValues(); // Load default values

        // Render row
        $this->RowType = RowType::ADD; // Render add type
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->wool->DefaultValue = $this->wool->getDefault(); // PHP
        $this->wool->OldValue = $this->wool->DefaultValue;
        $this->viscose->DefaultValue = $this->viscose->getDefault(); // PHP
        $this->viscose->OldValue = $this->viscose->DefaultValue;
        $this->polyester->DefaultValue = $this->polyester->getDefault(); // PHP
        $this->polyester->OldValue = $this->polyester->DefaultValue;
        $this->cotton->DefaultValue = $this->cotton->getDefault(); // PHP
        $this->cotton->OldValue = $this->cotton->DefaultValue;
        $this->jute->DefaultValue = $this->jute->getDefault(); // PHP
        $this->jute->OldValue = $this->jute->DefaultValue;
        $this->other->DefaultValue = $this->other->getDefault(); // PHP
        $this->other->OldValue = $this->other->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            $this->grp->setFormValue($val);
        }

        // Check field name 'wool' first before field var 'x_wool'
        $val = $CurrentForm->hasValue("wool") ? $CurrentForm->getValue("wool") : $CurrentForm->getValue("x_wool");
        if (!$this->wool->IsDetailKey) {
            $this->wool->setFormValue($val, true, $validate);
        }

        // Check field name 'viscose' first before field var 'x_viscose'
        $val = $CurrentForm->hasValue("viscose") ? $CurrentForm->getValue("viscose") : $CurrentForm->getValue("x_viscose");
        if (!$this->viscose->IsDetailKey) {
            $this->viscose->setFormValue($val, true, $validate);
        }

        // Check field name 'polyester' first before field var 'x_polyester'
        $val = $CurrentForm->hasValue("polyester") ? $CurrentForm->getValue("polyester") : $CurrentForm->getValue("x_polyester");
        if (!$this->polyester->IsDetailKey) {
            $this->polyester->setFormValue($val, true, $validate);
        }

        // Check field name 'cotton' first before field var 'x_cotton'
        $val = $CurrentForm->hasValue("cotton") ? $CurrentForm->getValue("cotton") : $CurrentForm->getValue("x_cotton");
        if (!$this->cotton->IsDetailKey) {
            $this->cotton->setFormValue($val, true, $validate);
        }

        // Check field name 'jute' first before field var 'x_jute'
        $val = $CurrentForm->hasValue("jute") ? $CurrentForm->getValue("jute") : $CurrentForm->getValue("x_jute");
        if (!$this->jute->IsDetailKey) {
            $this->jute->setFormValue($val, true, $validate);
        }

        // Check field name 'other' first before field var 'x_other'
        $val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
        if (!$this->other->IsDetailKey) {
            $this->other->setFormValue($val, true, $validate);
        }

        // Check field name 'other_name' first before field var 'x_other_name'
        $val = $CurrentForm->hasValue("other_name") ? $CurrentForm->getValue("other_name") : $CurrentForm->getValue("x_other_name");
        if (!$this->other_name->IsDetailKey) {
            $this->other_name->setFormValue($val);
        }

        // Check field name 'description_type' first before field var 'x_description_type'
        $val = $CurrentForm->hasValue("description_type") ? $CurrentForm->getValue("description_type") : $CurrentForm->getValue("x_description_type");
        if (!$this->description_type->IsDetailKey) {
            $this->description_type->setFormValue($val);
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            $this->code->setFormValue($val);
        }

        // Check field name 'composition' first before field var 'x_composition'
        $val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
        if (!$this->composition->IsDetailKey) {
            $this->composition->setFormValue($val);
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            $this->status->setFormValue($val);
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            $this->operator->setFormValue($val);
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            $this->datetime->setFormValue($val);
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'uid' first before field var 'x_uid'
        $val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
        if (!$this->uid->IsDetailKey) {
            $this->uid->setFormValue($val);
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = ConvertToUtf8($this->grp->FormValue);
        $this->wool->CurrentValue = ConvertToUtf8($this->wool->FormValue);
        $this->viscose->CurrentValue = ConvertToUtf8($this->viscose->FormValue);
        $this->polyester->CurrentValue = ConvertToUtf8($this->polyester->FormValue);
        $this->cotton->CurrentValue = ConvertToUtf8($this->cotton->FormValue);
        $this->jute->CurrentValue = ConvertToUtf8($this->jute->FormValue);
        $this->other->CurrentValue = ConvertToUtf8($this->other->FormValue);
        $this->other_name->CurrentValue = ConvertToUtf8($this->other_name->FormValue);
        $this->description_type->CurrentValue = ConvertToUtf8($this->description_type->FormValue);
        $this->code->CurrentValue = ConvertToUtf8($this->code->FormValue);
        $this->composition->CurrentValue = ConvertToUtf8($this->composition->FormValue);
        $this->status->CurrentValue = ConvertToUtf8($this->status->FormValue);
        $this->operator->CurrentValue = ConvertToUtf8($this->operator->FormValue);
        $this->datetime->CurrentValue = ConvertToUtf8($this->datetime->FormValue);
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->uid->CurrentValue = ConvertToUtf8($this->uid->FormValue);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->wool->setDbValue($row['wool']);
        $this->viscose->setDbValue($row['viscose']);
        $this->polyester->setDbValue($row['polyester']);
        $this->cotton->setDbValue($row['cotton']);
        $this->jute->setDbValue($row['jute']);
        $this->other->setDbValue($row['other']);
        $this->other_name->setDbValue($row['other_name']);
        $this->description_type->setDbValue($row['description_type']);
        $this->code->setDbValue($row['code']);
        $this->composition->setDbValue($row['composition']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->uid->setDbValue($row['uid']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['wool'] = $this->wool->DefaultValue;
        $row['viscose'] = $this->viscose->DefaultValue;
        $row['polyester'] = $this->polyester->DefaultValue;
        $row['cotton'] = $this->cotton->DefaultValue;
        $row['jute'] = $this->jute->DefaultValue;
        $row['other'] = $this->other->DefaultValue;
        $row['other_name'] = $this->other_name->DefaultValue;
        $row['description_type'] = $this->description_type->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // wool
        $this->wool->RowCssClass = "row";

        // viscose
        $this->viscose->RowCssClass = "row";

        // polyester
        $this->polyester->RowCssClass = "row";

        // cotton
        $this->cotton->RowCssClass = "row";

        // jute
        $this->jute->RowCssClass = "row";

        // other
        $this->other->RowCssClass = "row";

        // other_name
        $this->other_name->RowCssClass = "row";

        // description_type
        $this->description_type->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // wool
            $this->wool->ViewValue = $this->wool->CurrentValue;
            $this->wool->ViewValue = FormatNumber($this->wool->ViewValue, $this->wool->formatPattern());

            // viscose
            $this->viscose->ViewValue = $this->viscose->CurrentValue;
            $this->viscose->ViewValue = FormatNumber($this->viscose->ViewValue, $this->viscose->formatPattern());

            // polyester
            $this->polyester->ViewValue = $this->polyester->CurrentValue;
            $this->polyester->ViewValue = FormatNumber($this->polyester->ViewValue, $this->polyester->formatPattern());

            // cotton
            $this->cotton->ViewValue = $this->cotton->CurrentValue;
            $this->cotton->ViewValue = FormatNumber($this->cotton->ViewValue, $this->cotton->formatPattern());

            // jute
            $this->jute->ViewValue = $this->jute->CurrentValue;
            $this->jute->ViewValue = FormatNumber($this->jute->ViewValue, $this->jute->formatPattern());

            // other
            $this->other->ViewValue = $this->other->CurrentValue;
            $this->other->ViewValue = FormatNumber($this->other->ViewValue, $this->other->formatPattern());

            // other_name
            $this->other_name->ViewValue = $this->other_name->CurrentValue;

            // description_type
            if (strval($this->description_type->CurrentValue) != "") {
                $this->description_type->ViewValue = $this->description_type->optionCaption($this->description_type->CurrentValue);
            } else {
                $this->description_type->ViewValue = null;
            }

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // composition
            $this->composition->ViewValue = $this->composition->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // wool
            $this->wool->HrefValue = "";
            $this->wool->TooltipValue = "";

            // viscose
            $this->viscose->HrefValue = "";
            $this->viscose->TooltipValue = "";

            // polyester
            $this->polyester->HrefValue = "";
            $this->polyester->TooltipValue = "";

            // cotton
            $this->cotton->HrefValue = "";
            $this->cotton->TooltipValue = "";

            // jute
            $this->jute->HrefValue = "";
            $this->jute->TooltipValue = "";

            // other
            $this->other->HrefValue = "";
            $this->other->TooltipValue = "";

            // other_name
            $this->other_name->HrefValue = "";
            $this->other_name->TooltipValue = "";

            // description_type
            $this->description_type->HrefValue = "";
            $this->description_type->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // uid
            $this->uid->HrefValue = "";
            $this->uid->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // wool
            $this->wool->setupEditAttributes();
            $this->wool->EditValue = $this->wool->CurrentValue;
            $this->wool->PlaceHolder = RemoveHtml($this->wool->caption());
            if (strval($this->wool->EditValue) != "" && is_numeric($this->wool->EditValue)) {
                $this->wool->EditValue = FormatNumber($this->wool->EditValue, null);
            }

            // viscose
            $this->viscose->setupEditAttributes();
            $this->viscose->EditValue = $this->viscose->CurrentValue;
            $this->viscose->PlaceHolder = RemoveHtml($this->viscose->caption());
            if (strval($this->viscose->EditValue) != "" && is_numeric($this->viscose->EditValue)) {
                $this->viscose->EditValue = FormatNumber($this->viscose->EditValue, null);
            }

            // polyester
            $this->polyester->setupEditAttributes();
            $this->polyester->EditValue = $this->polyester->CurrentValue;
            $this->polyester->PlaceHolder = RemoveHtml($this->polyester->caption());
            if (strval($this->polyester->EditValue) != "" && is_numeric($this->polyester->EditValue)) {
                $this->polyester->EditValue = FormatNumber($this->polyester->EditValue, null);
            }

            // cotton
            $this->cotton->setupEditAttributes();
            $this->cotton->EditValue = $this->cotton->CurrentValue;
            $this->cotton->PlaceHolder = RemoveHtml($this->cotton->caption());
            if (strval($this->cotton->EditValue) != "" && is_numeric($this->cotton->EditValue)) {
                $this->cotton->EditValue = FormatNumber($this->cotton->EditValue, null);
            }

            // jute
            $this->jute->setupEditAttributes();
            $this->jute->EditValue = $this->jute->CurrentValue;
            $this->jute->PlaceHolder = RemoveHtml($this->jute->caption());
            if (strval($this->jute->EditValue) != "" && is_numeric($this->jute->EditValue)) {
                $this->jute->EditValue = FormatNumber($this->jute->EditValue, null);
            }

            // other
            $this->other->setupEditAttributes();
            $this->other->EditValue = $this->other->CurrentValue;
            $this->other->PlaceHolder = RemoveHtml($this->other->caption());
            if (strval($this->other->EditValue) != "" && is_numeric($this->other->EditValue)) {
                $this->other->EditValue = FormatNumber($this->other->EditValue, null);
            }

            // other_name
            $this->other_name->setupEditAttributes();
            if (!$this->other_name->Raw) {
                $this->other_name->CurrentValue = HtmlDecode($this->other_name->CurrentValue);
            }
            $this->other_name->EditValue = HtmlEncode($this->other_name->CurrentValue);
            $this->other_name->PlaceHolder = RemoveHtml($this->other_name->caption());

            // description_type
            $this->description_type->setupEditAttributes();
            $this->description_type->EditValue = $this->description_type->options(true);
            $this->description_type->PlaceHolder = RemoveHtml($this->description_type->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditCustomAttributes = $this->code->getEditCustomAttributes(); // PHP
            if (!$this->code->Raw) {
                $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // composition
            $this->composition->setupEditAttributes();
            $this->composition->EditCustomAttributes = $this->composition->getEditCustomAttributes(); // PHP
            if (!$this->composition->Raw) {
                $this->composition->CurrentValue = HtmlDecode($this->composition->CurrentValue);
            }
            $this->composition->EditValue = HtmlEncode($this->composition->CurrentValue);
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->CurrentValue = FormatNumber(CurrentUserID(), $this->operator->formatPattern());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->CurrentValue = FormatDateTime(CurrentDateTime(), $this->datetime->formatPattern());

            // uid
            $this->uid->setupEditAttributes();
            if (!$this->uid->Raw) {
                $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
            }
            $this->uid->EditValue = HtmlEncode($this->uid->CurrentValue);
            $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // wool
            $this->wool->HrefValue = "";

            // viscose
            $this->viscose->HrefValue = "";

            // polyester
            $this->polyester->HrefValue = "";

            // cotton
            $this->cotton->HrefValue = "";

            // jute
            $this->jute->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // other_name
            $this->other_name->HrefValue = "";

            // description_type
            $this->description_type->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // uid
            $this->uid->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->wool->Visible && $this->wool->Required) {
                if (!$this->wool->IsDetailKey && EmptyValue($this->wool->FormValue)) {
                    $this->wool->addErrorMessage(str_replace("%s", $this->wool->caption(), $this->wool->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->wool->FormValue)) {
                $this->wool->addErrorMessage($this->wool->getErrorMessage(false));
            }
            if ($this->viscose->Visible && $this->viscose->Required) {
                if (!$this->viscose->IsDetailKey && EmptyValue($this->viscose->FormValue)) {
                    $this->viscose->addErrorMessage(str_replace("%s", $this->viscose->caption(), $this->viscose->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->viscose->FormValue)) {
                $this->viscose->addErrorMessage($this->viscose->getErrorMessage(false));
            }
            if ($this->polyester->Visible && $this->polyester->Required) {
                if (!$this->polyester->IsDetailKey && EmptyValue($this->polyester->FormValue)) {
                    $this->polyester->addErrorMessage(str_replace("%s", $this->polyester->caption(), $this->polyester->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->polyester->FormValue)) {
                $this->polyester->addErrorMessage($this->polyester->getErrorMessage(false));
            }
            if ($this->cotton->Visible && $this->cotton->Required) {
                if (!$this->cotton->IsDetailKey && EmptyValue($this->cotton->FormValue)) {
                    $this->cotton->addErrorMessage(str_replace("%s", $this->cotton->caption(), $this->cotton->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->cotton->FormValue)) {
                $this->cotton->addErrorMessage($this->cotton->getErrorMessage(false));
            }
            if ($this->jute->Visible && $this->jute->Required) {
                if (!$this->jute->IsDetailKey && EmptyValue($this->jute->FormValue)) {
                    $this->jute->addErrorMessage(str_replace("%s", $this->jute->caption(), $this->jute->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jute->FormValue)) {
                $this->jute->addErrorMessage($this->jute->getErrorMessage(false));
            }
            if ($this->other->Visible && $this->other->Required) {
                if (!$this->other->IsDetailKey && EmptyValue($this->other->FormValue)) {
                    $this->other->addErrorMessage(str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->other->FormValue)) {
                $this->other->addErrorMessage($this->other->getErrorMessage(false));
            }
            if ($this->other_name->Visible && $this->other_name->Required) {
                if (!$this->other_name->IsDetailKey && EmptyValue($this->other_name->FormValue)) {
                    $this->other_name->addErrorMessage(str_replace("%s", $this->other_name->caption(), $this->other_name->RequiredErrorMessage));
                }
            }
            if ($this->description_type->Visible && $this->description_type->Required) {
                if (!$this->description_type->IsDetailKey && EmptyValue($this->description_type->FormValue)) {
                    $this->description_type->addErrorMessage(str_replace("%s", $this->description_type->caption(), $this->description_type->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->composition->Visible && $this->composition->Required) {
                if (!$this->composition->IsDetailKey && EmptyValue($this->composition->FormValue)) {
                    $this->composition->addErrorMessage(str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->uid->Visible && $this->uid->Required) {
                if (!$this->uid->IsDetailKey && EmptyValue($this->uid->FormValue)) {
                    $this->uid->addErrorMessage(str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("compositionlist"), "", $this->TableVar, true);
        $pageId = "addopt";
        $Breadcrumb->add("addopt", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_type":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
